/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.salesforce;

import com.metamatrix.connector.salesforce.ConnectorTarget;
import com.metamatrix.connector.salesforce.SalesforceConnectorException;
import com.metamatrix.connector.salesforce.SalesforceSessionMonitor;
import com.metamatrix.connector.salesforce.connection.SalesforceConnection;
import com.metamatrix.connector.salesforce.connection.SalesforceConnectionPoolFactory;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;

public class Connector
implements com.metamatrix.data.api.Connector {
    public static final int MAX_CONNECTIONS_PER_USER = 5;
    public static final int MAX_CONNECTION_WAIT_TIME_MS = 120000;
    public static final int MAX_TIME_BETWEEN_IDLE_EVICT_RUN_MS = 60000;
    public static final int DEFAULT_MIN_EVICTABLE_IDLE_TIME_MILLIS = 600000;
    private ConnectorLogger logger;
    private ConnectorEnvironment connectorEnv;
    private ConnectorTarget target;
    private KeyedObjectPool availablePool;
    private KeyedObjectPoolFactory poolFactory;
    private SalesforceSessionMonitor closedSessionsMonitor;

    public Connection getConnection(SecurityContext secContext) throws ConnectorException {
        this.logger.logTrace("Enter Connector.getConnection()");
        SalesforceConnection connection = null;
        try {
            connection = (SalesforceConnection)this.availablePool.borrowObject((Object)this.target.key());
        }
        catch (Exception e) {
            throw new ConnectorException((Throwable)e, "Requesting connection from pool for key " + this.target.key());
        }
        finally {
            this.logger.logTrace("Leave Connector.getConnection()");
        }
        return connection;
    }

    public void returnConnection(Connection connection) throws ConnectorException {
        if (this.availablePool != null && connection instanceof SalesforceConnection) {
            SalesforceConnection sfc = (SalesforceConnection)connection;
            try {
                this.logger.logTrace("Connection returnConnection() called on " + sfc.key() + " sessionid=" + sfc.getSessionId());
                this.availablePool.returnObject((Object)sfc.key(), (Object)sfc);
            }
            catch (Exception e) {
                throw new ConnectorException((Throwable)e);
            }
        }
    }

    public void initialize(ConnectorEnvironment env) throws ConnectorException {
        env.getLogger().logTrace("Enter Salesforce Connector.initialize()");
        this.connectorEnv = env;
        this.logger = env.getLogger();
        this.target = new ConnectorTarget(env.getProperties(), this.getLogger());
        this.closedSessionsMonitor = new SalesforceSessionMonitor(this);
        this.initializePool();
        this.getLogger().logInfo(this.getLogPreamble().append("Initialized").toString());
        this.getLogger().logTrace(this.getLogPreamble().append("Initialization Properties: " + env.getProperties()).toString());
        this.logger.logTrace("Return Salesforce Connector.initialize()");
    }

    public void start() throws ConnectorException {
        this.getLogger().logInfo(this.getLogPreamble().append("Started").toString());
    }

    public void stop() {
        try {
            this.getLogger().logInfo(this.getLogPreamble().append("Stopped").toString());
            this.shutDownPool();
        }
        catch (ConnectorException e) {
        }
        catch (Exception e) {
            this.logger.logWarning(e.getMessage());
        }
    }

    public ConnectorEnvironment getConnectorEnv() {
        return this.connectorEnv;
    }

    public ConnectorTarget getTarget() {
        return this.target;
    }

    private void initializePool() throws ConnectorException {
        int maxConnectionsPerUser = 5;
        try {
            String maxConnectionsPerUserString = this.connectorEnv.getProperties().getProperty("com.metamatrix.data.pool.max_connections_per_id");
            if (maxConnectionsPerUserString != null) {
                maxConnectionsPerUser = Integer.decode(maxConnectionsPerUserString);
            }
        }
        catch (NumberFormatException e) {
            throw new SalesforceConnectorException(new IllegalArgumentException("com.metamatrix.data.pool.max_connections_per_id"));
        }
        boolean useLifo = true;
        String useLifoString = this.connectorEnv.getProperties().getProperty("com.metamatrix.data.pool.lifo");
        if (useLifoString != null) {
            useLifo = Boolean.valueOf(useLifoString);
        }
        boolean testWhenIdle = true;
        String testWhenIdleString = this.connectorEnv.getProperties().getProperty("com.metamatrix.data.pool.test-when-idle");
        if (testWhenIdleString != null) {
            testWhenIdle = Boolean.valueOf(testWhenIdleString);
        }
        int maxConnectionWaitTimeMs = 120000;
        try {
            String maxConnectionWaitTimeMsString = this.connectorEnv.getProperties().getProperty("com.metamatrix.data.pool.max_connection_wait_time");
            if (maxConnectionWaitTimeMsString != null) {
                maxConnectionWaitTimeMs = Integer.decode(maxConnectionWaitTimeMsString);
            }
        }
        catch (NumberFormatException e) {
            throw new SalesforceConnectorException(new IllegalArgumentException("com.metamatrix.data.pool.max_connection_wait_time"));
        }
        int evictionRunTimeMs = 60000;
        try {
            String evictionRunTimeMsString = this.connectorEnv.getProperties().getProperty("com.metamatrix.data.pool.evict-run-time");
            if (evictionRunTimeMsString != null) {
                evictionRunTimeMs = Integer.decode(evictionRunTimeMsString);
            }
        }
        catch (NumberFormatException e) {
            throw new SalesforceConnectorException(new IllegalArgumentException("com.metamatrix.data.pool.evict-run-time"));
        }
        int evictionIdleTimeMs = 600000;
        try {
            String evictionIdleTimeMsString = this.connectorEnv.getProperties().getProperty("com.metamatrix.data.pool.evict-idle-time");
            if (evictionIdleTimeMsString != null) {
                evictionIdleTimeMs = Integer.decode(evictionIdleTimeMsString);
            }
        }
        catch (NumberFormatException e) {
            throw new SalesforceConnectorException(new IllegalArgumentException("com.metamatrix.data.pool.evict-idle-time"));
        }
        boolean validateOnBorrow = true;
        String validateOnBorrowString = this.connectorEnv.getProperties().getProperty("com.metamatrix.data.pool.validate-on-borrow");
        if (validateOnBorrowString != null) {
            validateOnBorrow = Boolean.valueOf(validateOnBorrowString);
        }
        boolean validateOnReturn = true;
        String validateOnReturnString = this.connectorEnv.getProperties().getProperty("com.metamatrix.data.pool.validate-on-return");
        if (validateOnReturnString != null) {
            validateOnReturn = Boolean.valueOf(validateOnReturnString);
        }
        this.poolFactory = new GenericKeyedObjectPoolFactory((KeyedPoolableObjectFactory)new SalesforceConnectionPoolFactory(this), maxConnectionsPerUser, 1, (long)maxConnectionWaitTimeMs, maxConnectionsPerUser, -1, 0, validateOnBorrow, validateOnReturn, (long)evictionRunTimeMs, 3, (long)evictionIdleTimeMs, testWhenIdle, useLifo);
        this.availablePool = this.poolFactory.createPool();
    }

    private void shutDownPool() throws Exception {
        if (this.availablePool != null) {
            this.availablePool.clear();
            this.availablePool.close();
        }
        this.availablePool = null;
        this.poolFactory = null;
    }

    public boolean isSessionClosed(String id) {
        return this.closedSessionsMonitor.isMonitored(id);
    }

    public void registerClosedSession(String id) {
        this.closedSessionsMonitor.addSession(id);
    }

    public ConnectorLogger getLogger() throws ConnectorException {
        if (null == this.logger) {
            throw new ConnectorException("Error:  Connector initialize not called");
        }
        return this.logger;
    }

    public StringBuffer getLogPreamble() {
        StringBuffer preamble = new StringBuffer();
        preamble.append("Salesforce Connector id = ");
        preamble.append(this.connectorEnv.getConnectorName());
        preamble.append(":");
        return preamble;
    }
}

