/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.messaging;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.messaging.MessageBus;
import com.metamatrix.common.messaging.MessagingException;
import com.metamatrix.common.messaging.NoOpMessageBus;
import com.metamatrix.common.messaging.jgroups.JGroupsMessageBus;
import com.metamatrix.common.messaging.rmi.RMIMessageBus;
import com.metamatrix.core.event.AsynchEventBroker;
import com.metamatrix.core.event.EventBroker;
import com.metamatrix.core.event.EventBrokerException;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.core.event.EventSourceException;
import java.util.EventObject;
import java.util.Properties;

public class VMMessageBus
implements MessageBus {
    private static MessageBus messageBus;
    private static Object lock;
    private static boolean closed;
    private static EventBroker eventBroker;

    public VMMessageBus() {
        this.init();
        LogManager.logTrace((String)"MESSAGE_BUS", (String)("VMMessageBus returning new instance using messageBus = " + (messageBus != null ? messageBus : "<null>")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VMMessageBus(MessageBus mBus) {
        Object object = lock;
        synchronized (object) {
            if (messageBus == null) {
                messageBus = mBus;
                closed = false;
            }
            LogManager.logTrace((String)"MESSAGE_BUS", (String)("VMMessageBus called with " + (mBus != null ? mBus : "<null>") + " and returning new instance using messageBus = " + (messageBus != null ? messageBus : "<null>")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = lock;
        synchronized (object) {
            if (messageBus == null) {
                LogManager.logTrace((String)"MESSAGE_BUS", (String)"VMMessageBus init called");
                Properties env = null;
                try {
                    String mbType = System.getProperty("metamatrix.message.bus.type");
                    if (mbType == null || mbType.trim().length() == 0) {
                        env = CurrentConfiguration.getProperties();
                        mbType = env.getProperty("metamatrix.message.bus.type");
                    }
                    LogManager.logTrace((String)"MESSAGE_BUS", (String)("init creating MessageBus type: " + mbType));
                    messageBus = mbType != null && mbType.equals("noop.message.bus") ? new NoOpMessageBus() : (mbType != null && mbType.equals("rmi.message.bus") ? new RMIMessageBus(env, eventBroker) : new JGroupsMessageBus(env, eventBroker));
                    closed = false;
                }
                catch (Exception e) {
                    LogManager.logTrace((String)"MESSAGE_BUS", (Throwable)e, (String)"Exception thrown in init");
                    Properties properties = new Properties();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        Object object = lock;
        synchronized (object) {
            if (messageBus == null) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Class eventClass, EventObjectListener listener) throws MessagingException {
        Object object = lock;
        synchronized (object) {
            if (closed) {
                return;
            }
            messageBus.addListener(eventClass, listener);
            try {
                eventBroker.addListener(eventClass, listener);
            }
            catch (EventSourceException e) {
                throw new MessagingException((Throwable)e, "ERR.003.017.0013", CommonPlugin.Util.getString("ERR.003.017.0013"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws MessagingException {
        Object object = lock;
        synchronized (object) {
            if (closed) {
                return;
            }
            closed = true;
            messageBus.shutdown();
            try {
                eventBroker.shutdown();
            }
            catch (EventBrokerException e) {
                throw new MessagingException((Throwable)e, "ERR.003.017.0014", CommonPlugin.Util.getString("ERR.003.017.0014"));
            }
            messageBus = null;
            eventBroker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Class eventClass, EventObjectListener listener) throws MessagingException {
        Object object = lock;
        synchronized (object) {
            if (closed) {
                return;
            }
            messageBus.removeListener(eventClass, listener);
            try {
                eventBroker.removeListener(eventClass, listener);
            }
            catch (EventSourceException e) {
                throw new MessagingException((Throwable)e, "ERR.003.017.0015", CommonPlugin.Util.getString("ERR.003.017.0015"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(EventObjectListener listener) throws MessagingException {
        Object object = lock;
        synchronized (object) {
            if (closed) {
                return;
            }
            messageBus.removeListener(listener);
            try {
                eventBroker.removeListener(listener);
            }
            catch (EventSourceException e) {
                throw new MessagingException((Throwable)e, "ERR.003.017.0015", CommonPlugin.Util.getString("ERR.003.017.0015"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(EventObject obj) throws MessagingException {
        Object object = lock;
        synchronized (object) {
            if (closed) {
                return;
            }
            messageBus.processEvent(obj);
            eventBroker.processEvent(obj);
        }
    }

    static {
        lock = new Object();
        closed = true;
        eventBroker = new AsynchEventBroker("VMMessageBus");
    }
}

