/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilDataProvider;
import com.metamatrix.util.UtilException;

public class UtilBufferedDataProvider
implements UtilDataProvider {
    private static String footprint = "$Revision:   3.9.2.0  $";
    private int blockSizeForRead;
    private byte[] buffer;
    private int numBytesReturnedFromBuffer;
    private int numBytesInBuffer;
    private UtilDataProvider dataProviderObject;
    private boolean cacheMoreData = true;
    private int lastNumBytesWriten = 0;

    public UtilBufferedDataProvider(UtilDataProvider utilDataProvider) {
        this.dataProviderObject = utilDataProvider;
        this.buffer = null;
        this.numBytesReturnedFromBuffer = 0;
        this.numBytesInBuffer = 0;
        this.blockSizeForRead = 1024;
    }

    public UtilBufferedDataProvider(UtilDataProvider utilDataProvider, int n) {
        this.dataProviderObject = utilDataProvider;
        this.buffer = null;
        this.numBytesReturnedFromBuffer = 0;
        this.numBytesInBuffer = 0;
        this.blockSizeForRead = n;
    }

    private void cacheNextBlock() throws UtilException {
        if (this.buffer == null) {
            this.buffer = new byte[this.blockSizeForRead];
        }
        this.numBytesInBuffer = this.dataProviderObject.getArrayOfBytes(this.buffer, 0, this.blockSizeForRead);
        this.numBytesReturnedFromBuffer = 0;
    }

    public byte getByte() throws UtilException {
        if (this.numBytesReturnedFromBuffer == this.numBytesInBuffer) {
            this.cacheNextBlock();
        }
        return this.buffer[this.numBytesReturnedFromBuffer++];
    }

    public byte peekCachedByte(int n) throws UtilException {
        if (this.numBytesReturnedFromBuffer + n > this.numBytesInBuffer) {
            throw new UtilException(1025);
        }
        return this.buffer[this.numBytesReturnedFromBuffer + n];
    }

    public int getArrayOfBytes(byte[] byArray, int n, int n2) throws UtilException {
        int n3 = this.numBytesInBuffer - this.numBytesReturnedFromBuffer;
        if (n2 > 0) {
            if (n2 <= n3) {
                System.arraycopy(this.buffer, this.numBytesReturnedFromBuffer, byArray, n, n2);
                this.numBytesReturnedFromBuffer += n2;
                this.lastNumBytesWriten = n + n2;
            } else {
                int n4 = n2;
                if (n3 > 0) {
                    System.arraycopy(this.buffer, this.numBytesReturnedFromBuffer, byArray, n, n3);
                    n4 -= n3;
                    this.numBytesReturnedFromBuffer = this.numBytesInBuffer;
                    this.lastNumBytesWriten = n + n3;
                }
                if (n4 > 0) {
                    this.cacheNextBlock();
                    if (!this.cacheMoreData) {
                        if (this.numBytesInBuffer > 0) {
                            if (this.numBytesInBuffer < this.blockSizeForRead && n4 >= this.numBytesInBuffer) {
                                n4 = this.numBytesInBuffer;
                            }
                        } else {
                            n4 = -1;
                        }
                    }
                    this.getArrayOfBytes(byArray, n + n3, n4);
                }
            }
        }
        if (!this.cacheMoreData && this.lastNumBytesWriten < n2) {
            n2 = this.lastNumBytesWriten;
        }
        return n2;
    }

    public void empty() throws UtilException {
        this.numBytesInBuffer = 0;
        this.dataProviderObject.empty();
    }

    public void receive() throws UtilException {
        this.dataProviderObject.receive();
    }

    public boolean isCacheEmpty() {
        return this.numBytesReturnedFromBuffer == this.numBytesInBuffer;
    }

    public int getNumRemainingBytesInBuffer() {
        return this.numBytesInBuffer - this.numBytesReturnedFromBuffer;
    }

    public boolean moreUnbufferedDataToReturn() {
        return this.dataProviderObject.moreUnbufferedDataToReturn();
    }

    public void reset() {
        this.numBytesInBuffer = 0;
        this.numBytesReturnedFromBuffer = 0;
    }
}

