/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataWriter;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDAConstants;
import com.metamatrix.jdbc.db2.drda.DRDAPkgNamCsn;
import com.metamatrix.jdbc.db2.drda.DRDAUtil;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilTransliterator;
import java.io.InputStream;
import java.sql.SQLException;

public abstract class DRDARequest
extends DRDAConstants {
    private static String footprint = "$Revision:   3.87.1.4  $";
    public DRDAUtil drdaUtil;
    public DRDACommunication comm;
    public DB2ImplConnection implConn;
    int severityCode;
    public boolean isCursorHeldOpen;
    String serverDiagnostics;
    public SQLException exception;
    public int numExceptions;
    public boolean hasWarnings;
    public boolean chainCommit;
    public boolean checkingForAdditionalUpdateCounts;
    public boolean continuingQuery;
    public boolean useOUTOVRlob;
    public int resultType;
    public boolean isCursorOpen;
    public boolean moreData;
    private boolean isABEND = false;
    int numRowsAffected;
    int returnValueForStoredProcedure;
    boolean returnValueSet;
    int spRetVal;
    public static final short PROCESS_UNTIL_ROW_OR_UPDATECOUNT = 0;
    public static final short PROCESS_UNTIL_ROW = 1;
    public static final short PROCESS_UNTIL_END = 2;
    public static final short PROCESS_DESC_ONLY = 3;
    public static final short PROCESS_PARAM_INFO = 4;
    public int processMode;
    public DRDAByteOrderedDataReader reader;
    public DRDAByteOrderedDataWriter writer;
    public DRDAPkgNamCsn packageConsistencyToken;
    public boolean isCachedRequest;
    int sqlCode;
    byte[] sqlStateBytes;
    byte[] sqlErrProcBytes;
    byte[] errParamBytes;
    UtilTransliterator errParamsTranslit;
    public boolean isStoredProcedure;
    boolean continueProcessingChain = true;
    int codePointLength = 0;
    int codePoint = 0;

    public DRDARequest(DB2ImplConnection dB2ImplConnection, DRDACommunication dRDACommunication, DRDAByteOrderedDataReader dRDAByteOrderedDataReader, DRDAByteOrderedDataWriter dRDAByteOrderedDataWriter) {
        this.comm = dRDACommunication;
        this.numRowsAffected = 0;
        this.resultType = 0;
        this.isCursorOpen = false;
        this.moreData = false;
        this.processMode = 0;
        this.exception = null;
        this.reader = dRDAByteOrderedDataReader;
        this.writer = dRDAByteOrderedDataWriter;
        this.isCachedRequest = false;
        this.implConn = dB2ImplConnection;
        this.hasWarnings = false;
        this.checkingForAdditionalUpdateCounts = false;
        this.continuingQuery = false;
        this.drdaUtil = dRDACommunication.drdaUtil;
        this.useOUTOVRlob = false;
        this.spRetVal = 0;
        boolean bl = false;
        this.sqlStateBytes = new byte[5];
        this.sqlErrProcBytes = new byte[8];
    }

    public int getNumRowsAffected() {
        return this.numRowsAffected;
    }

    public int getReturnValueForStoredProcedure() {
        return this.returnValueForStoredProcedure;
    }

    public int getResultType() {
        return this.resultType;
    }

    public UtilPagedTempBuffer cacheEXTDTA(int n, UtilTransliterator utilTransliterator, int n2) throws SQLException {
        UtilPagedTempBuffer utilPagedTempBuffer;
        block11: {
            long l = 0L;
            utilPagedTempBuffer = new UtilPagedTempBuffer();
            try {
                boolean bl = false;
                if (n2 < 0) {
                    bl = true;
                    n2 = this.reader.getNumBytesLeftInCurrentPacket();
                }
                if (n == 2005) {
                    UtilException utilException = null;
                    boolean bl2 = false;
                    int n3 = 0;
                    byte[] byArray = new byte[8192];
                    InputStream inputStream = utilTransliterator.decodeAsUCS2ByteStream(this.reader.getInputStream(n2), n2);
                    while (n3 != -1) {
                        n3 = inputStream.read(byArray, 0, 8192);
                        try {
                            if (n3 != -1 && !bl2) {
                                l += (long)utilPagedTempBuffer.write(l, byArray, 0, n3);
                            }
                        }
                        catch (UtilException utilException2) {
                            inputStream.skip(n2);
                            utilException = utilException2;
                            bl2 = true;
                        }
                        if (n3 != -1 || !bl || !this.reader.depacketizingExtendedPacket) continue;
                        this.reader.signalStartOfPacket(false);
                        inputStream = utilTransliterator.decodeAsUCS2ByteStream(this.reader.getInputStream(this.reader.getNumBytesLeftInCurrentPacket()), this.reader.getNumBytesLeftInCurrentPacket());
                        n3 = 0;
                    }
                    if (utilException != null) {
                        throw utilException;
                    }
                    break block11;
                }
                int n4 = 0;
                byte[] byArray = new byte[16384];
                while (n2 > 0) {
                    n4 = this.reader.readBytes(byArray, 0, Math.min(16384, n2));
                    l += (long)utilPagedTempBuffer.write(l, byArray, 0, n4);
                    if ((n2 -= n4) != 0 || !bl || !this.reader.depacketizingExtendedPacket) continue;
                    this.reader.signalStartOfPacket(false);
                    n2 = this.reader.getNumBytesLeftInCurrentPacket();
                }
            }
            catch (Exception exception) {
                if (exception.getMessage() == null) {
                    String[] stringArray = new String[]{exception.getClass().toString()};
                    throw this.comm.exceptions.getException(7121, stringArray);
                }
                throw this.comm.exceptions.getException(exception);
            }
        }
        return utilPagedTempBuffer;
    }

    public void continueQuery(BaseWarnings baseWarnings) throws SQLException {
    }

    public void closeQuery(BaseWarnings baseWarnings) throws SQLException {
        try {
            int n;
            int n2;
            this.continuingQuery = false;
            if (!this.isCursorOpen) {
                return;
            }
            int n3 = 1;
            if (this.implConn.isXAImplConn && this.implConn.inLocalTransaction && this.implConn.comm.useBetaXAImplementation) {
                int n4 = n3;
                n3 = (short)(n3 + 1);
                n2 = this.writer.writePacketHeader((short)1, (short)64, n4);
                n = this.writer.writeCodePoint((short)4181);
                this.writer.writeInt16(5);
                this.writer.writeInt16(4487);
                this.writer.writeInt8(9);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6145);
                this.writer.writeInt32(-1);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6403);
                this.writer.writeInt32(0);
                this.writer.writeCodePointLength(n);
                this.writer.writePacketLength(n2);
            }
            n2 = 0;
            if (this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit) {
                int n5 = n3;
                n3 = (short)(n3 + 1);
                n2 = this.writer.writePacketHeader((short)1, (short)64, n5);
            } else {
                n2 = this.writer.writePacketHeader((short)1, (short)0, n3);
            }
            n = this.writer.writeCodePoint((short)8197);
            if (this.isStoredProcedure) {
                this.writer.writeSP_PKGNAMCSN(this.packageConsistencyToken);
            } else {
                this.writer.writePKGNAMCSN(this.packageConsistencyToken);
            }
            if (this.comm.SQLAMLevel >= 7) {
                this.writer.writeInt16(this.packageConsistencyToken.queryInstanceId.length + 4);
                this.writer.writeInt16(8539);
                this.writer.writeBytes(this.packageConsistencyToken.queryInstanceId);
            }
            this.writer.writeCodePointLength(n);
            this.writer.writePacketLength(n2);
            if (this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit) {
                if (this.implConn.isXAImplConn && this.implConn.comm.useBetaXAImplementation) {
                    int n6 = this.writer.writePacketHeader((short)1, (short)0, n3);
                    int n7 = this.writer.writeCodePoint((short)4181);
                    this.writer.writeInt16(5);
                    this.writer.writeInt16(4487);
                    this.writer.writeInt8(3);
                    this.writer.writeInt16(8);
                    this.writer.writeInt16(6145);
                    this.writer.writeInt32(-1);
                    this.writer.writeInt16(8);
                    this.writer.writeInt16(6403);
                    this.writer.writeInt32(0x10000000);
                    this.writer.writeCodePointLength(n7);
                    this.writer.writePacketLength(n6);
                } else {
                    int n8 = this.writer.writePacketHeader((short)1, (short)0, n3);
                    int n9 = this.writer.writeCodePoint((short)8206);
                    this.writer.writeCodePointLength(n9);
                    this.writer.writePacketLength(n8);
                }
            }
        }
        catch (Exception exception) {
            try {
                this.writer.empty();
            }
            catch (UtilException utilException) {
                // empty catch block
            }
            if (exception instanceof UtilException) {
                throw this.comm.exceptions.getException(exception);
            }
            throw (SQLException)exception;
        }
        this.isCursorOpen = false;
    }

    public final void ensureBytes(int n, BaseWarnings baseWarnings) throws SQLException, UtilException {
        long l = this.reader.getNumBytesLeftInCurrentPacket();
        boolean bl = false;
        if (!this.reader.interpretAsBigEndian) {
            bl = true;
            this.reader.interpretAsBigEndian = true;
        }
        try {
            if (l < (long)n && !this.reader.depacketizingExtendedPacket) {
                if (!this.reader.morePacketsToProcess) {
                    if (l != 0L) {
                        l = this.reader.cacheRemainingBytes();
                    }
                    this.continueQuery(baseWarnings);
                    this.submitRequest();
                    this.processReply(baseWarnings);
                    if (l != 0L) {
                        this.reader.addBytesToCache((int)((long)n - l));
                        this.reader.setToReadFromByteArray();
                    }
                } else if (this.codePoint == 9243) {
                    int n2 = this.reader.getNumBytesLeftInCurrentPacket();
                    if (n2 > 0) {
                        this.reader.addBytesToCache(n2);
                        this.processReply(baseWarnings);
                        this.reader.addBytesToCache(n - n2);
                        this.reader.setToReadFromByteArray();
                        return;
                    }
                    if (n2 == 0) {
                        this.processReply(baseWarnings);
                    }
                }
            } else if (this.reader.depacketizingExtendedPacket) {
                boolean bl2 = this.reader.processMode == 2;
                int n3 = this.reader.getNumBytesLeftInCurrentPacket();
                int n4 = this.reader.getNextExtendedPacketLength();
                if (n4 > 2) {
                    n3 += n4 - 2;
                }
                int n5 = 0;
                if (this.reader.processMode == 3) {
                    n5 = this.reader.numBytesInByteBuffer;
                }
                boolean bl3 = bl2 = n4 > 2 && bl2;
                if (n3 < n) {
                    if ((n5 += this.reader.cacheRemainingBytesInCurrentPacket(bl2)) + this.reader.getNumBytesLeftInCurrentPacket() > n) {
                        this.reader.addBytesToCache(n - n5);
                        this.reader.setToReadFromByteArray();
                    } else {
                        this.continueQuery(baseWarnings);
                        this.submitRequest();
                        this.processReply(baseWarnings);
                        this.reader.addBytesToCache(n - (n5 += this.reader.cacheRemainingBytesInCurrentPacket(true)));
                        this.reader.setToReadFromByteArray();
                    }
                } else if (n5 > 0) {
                    this.reader.processMode = 2;
                    this.reader.addBytesToCache(n - n5);
                    this.reader.setToReadFromByteArray();
                }
            }
        }
        catch (UtilException utilException) {
            if (utilException.getReason() != 1001) {
                if (this.exception == null) {
                    throw this.comm.exceptions.getException(utilException);
                }
                throw this.exception;
            }
            this.resultType = 1;
        }
        if (bl) {
            this.reader.interpretAsBigEndian = false;
        }
    }

    public void submitRequest() throws SQLException {
        try {
            this.clearReplyChannel();
            this.writer.send();
            this.reader.receive();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            try {
                this.writer.empty();
            }
            catch (UtilException utilException) {
                // empty catch block
            }
            throw this.comm.exceptions.getException(exception);
        }
    }

    public void clearExceptions() {
        this.exception = null;
        this.numExceptions = 0;
        this.isABEND = false;
    }

    protected void clearReplyChannel() throws SQLException {
        try {
            if (this.comm.currentlyRegisteredReader != null && this.comm.currentlyRegisteredReader != this.reader) {
                boolean bl = false;
                try {
                    bl = this.comm.currentlyRegisteredReader.bufferAllData();
                }
                catch (Exception exception) {
                    throw this.comm.exceptions.getException(this.comm.exceptions.getException(exception), 1, 6091);
                }
                if (!bl) {
                    throw this.comm.exceptions.getException(6091);
                }
            }
            this.reader.empty();
            this.comm.currentlyRegisteredReader = this.reader;
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
    }

    public void processReply(BaseWarnings baseWarnings) throws SQLException {
        this.continueProcessingChain = true;
        this.codePointLength = 0;
        this.codePoint = 0;
        try {
            while (this.continueProcessingChain) {
                if (this.reader.currentPacketLength - this.reader.numBytesReadFromCurrentPacket >= 4 || this.reader.morePacketsToProcess) {
                    this.codePointLength = this.reader.readUnsignedInt16();
                    this.codePoint = this.reader.readInt16();
                    this.codePointLength -= 4;
                    this.continueProcessingChain = this.processCodePoint(this.codePointLength, this.codePoint, baseWarnings);
                    continue;
                }
                this.continueProcessingChain = false;
                if (this.checkingForAdditionalUpdateCounts && this.resultType == 3) {
                    this.checkingForAdditionalUpdateCounts = false;
                    continue;
                }
                if (this.isCursorOpen) continue;
                this.resultType = 1;
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
        finally {
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }

    public boolean processCodePoint(int n, int n2, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (n2) {
                case 53: {
                    int n3 = n;
                    do {
                        this.reader.readAndDiscardBytes(2);
                        short s = this.reader.readInt16();
                        short s2 = this.reader.readInt16();
                        n3 -= 6;
                        switch (s) {
                            case 4508: {
                                if (s2 == 0) break;
                                this.comm.TempSingleByteServerTransliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(Integer.toString(s2));
                                break;
                            }
                            case 4509: {
                                if (s2 == 0) break;
                                this.comm.TempDoubleByteServerTransliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(Integer.toString(s2));
                                break;
                            }
                            case 4510: {
                                if (s2 == 0) break;
                                this.comm.TempMultiByteServerTransliterator = this.comm.transliteratorPool.getTransliteratorForCodePage(Integer.toString(s2));
                                break;
                            }
                        }
                    } while (n3 != 0);
                    break;
                }
                case 4680: {
                    break;
                }
                case 6404: {
                    int n4 = this.reader.readInt32();
                    if (n4 == 99) {
                        this.comm.implConn.warnings.add(7111);
                        break;
                    }
                    if (n4 != 0) {
                        String[] stringArray = new String[]{Integer.toString(n4)};
                        throw this.comm.exceptions.getException(7089, stringArray);
                    }
                    break;
                }
                case 8733: {
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                case 8741: {
                    int n5;
                    String string = null;
                    int n6 = 0;
                    int n7 = n;
                    do {
                        n5 = this.reader.readInt16();
                        short s = this.reader.readInt16();
                        n5 -= 4;
                        n7 -= 4;
                        switch (s) {
                            case 8515: {
                                byte by = this.reader.readInt8();
                                if (by == 1) {
                                    string = "2D528";
                                    n6 = -426;
                                    break;
                                }
                                string = "2D529";
                                n6 = -426;
                                break;
                            }
                            default: {
                                this.reader.readAndDiscardBytes(n5);
                            }
                        }
                    } while ((n7 -= n5) != 0);
                    this.exception = this.comm.exceptions.getException(n6, null, string, n6);
                    break;
                }
                case 8723: {
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                case 8717: {
                    int n8;
                    int n9 = n;
                    String[] stringArray = new String[2];
                    do {
                        n8 = this.reader.readInt16();
                        short s = this.reader.readInt16();
                        n8 -= 4;
                        n9 -= 4;
                        switch (s) {
                            case 4415: {
                                stringArray[0] = this.drdaUtil.getNameForCPType(this.reader.readInt8());
                                break;
                            }
                            case 4435: {
                                stringArray[1] = this.serverDiagnostics = this.reader.readString(n);
                                break;
                            }
                            default: {
                                this.reader.readAndDiscardBytes(n8);
                            }
                        }
                    } while ((n9 -= n8) != 0);
                    this.exception = this.serverDiagnostics != null ? this.comm.exceptions.getException(7125, stringArray) : this.comm.exceptions.getException(7064, stringArray);
                    this.isABEND = true;
                    break;
                }
                case 9224: {
                    this.processSQLCA(baseWarnings);
                    if (!this.moreData) {
                        this.isCursorOpen = false;
                    }
                    if (this.processMode == 0 && this.numRowsAffected != 0) {
                        this.resultType = 3;
                        return this.checkingForAdditionalUpdateCounts;
                    }
                    return true;
                }
                case 4425: {
                    this.severityCode = this.reader.readInt16();
                    break;
                }
                case 4435: {
                    this.serverDiagnostics = this.reader.readString(n);
                    break;
                }
                case 8464: {
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                case 4658: {
                    int n10;
                    int n11 = n;
                    String[] stringArray = new String[2];
                    do {
                        n10 = this.reader.readInt16();
                        short s = this.reader.readInt16();
                        n10 -= 4;
                        n11 -= 4;
                        switch (s) {
                            case 4415: {
                                stringArray[0] = this.drdaUtil.getNameForCPType(this.reader.readInt8());
                                break;
                            }
                            case 4435: {
                                stringArray[1] = this.serverDiagnostics = this.reader.readString(n);
                                break;
                            }
                            default: {
                                this.reader.readAndDiscardBytes(n10);
                            }
                        }
                    } while ((n11 -= n10) != 0);
                    if (this.serverDiagnostics != null) {
                        this.exception = this.comm.exceptions.getException(7123, stringArray);
                        break;
                    }
                    this.exception = this.comm.exceptions.getException(7001, stringArray);
                    break;
                }
                case 4636: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7002);
                    break;
                }
                case 4692: {
                    int n12;
                    int n13 = n;
                    String[] stringArray = new String[2];
                    do {
                        n12 = this.reader.readInt16();
                        short s = this.reader.readInt16();
                        n12 -= 4;
                        n13 -= 4;
                        switch (s) {
                            case 4415: {
                                stringArray[0] = this.drdaUtil.getNameForCPType(this.reader.readInt8());
                                break;
                            }
                            case 4435: {
                                stringArray[1] = this.serverDiagnostics = this.reader.readString(n);
                                break;
                            }
                            default: {
                                this.reader.readAndDiscardBytes(n12);
                            }
                        }
                    } while ((n13 -= n12) != 0);
                    if (this.serverDiagnostics != null) {
                        this.exception = this.comm.exceptions.getException(7124, stringArray);
                        break;
                    }
                    this.exception = this.comm.exceptions.getException(7003, stringArray);
                    break;
                }
                case 4688: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7004);
                    break;
                }
                case 4632: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7005);
                    break;
                }
                case 4624: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7006);
                    break;
                }
                case 4677: {
                    int n14;
                    int n15 = n;
                    String[] stringArray = new String[2];
                    do {
                        n14 = this.reader.readInt16();
                        short s = this.reader.readInt16();
                        n14 -= 4;
                        n15 -= 4;
                        switch (s) {
                            case 4415: {
                                stringArray[0] = this.drdaUtil.getNameForCPType(this.reader.readInt8());
                                break;
                            }
                            case 4435: {
                                stringArray[1] = this.serverDiagnostics = this.reader.readString(n);
                                break;
                            }
                            default: {
                                this.reader.readAndDiscardBytes(n14);
                            }
                        }
                    } while ((n15 -= n14) != 0);
                    if (this.serverDiagnostics != null) {
                        this.exception = this.comm.exceptions.getException(7122, stringArray);
                        break;
                    }
                    this.exception = this.comm.exceptions.getException(7007, stringArray);
                    break;
                }
                case 4689: {
                    int n16;
                    int n17 = n;
                    String[] stringArray = new String[1];
                    do {
                        n16 = this.reader.readInt16();
                        short s = this.reader.readInt16();
                        n16 -= 4;
                        n17 -= 4;
                        switch (s) {
                            case 12: {
                                stringArray[0] = this.drdaUtil.getNameForCPType(this.reader.readInt16());
                                break;
                            }
                            default: {
                                this.reader.readAndDiscardBytes(n16);
                            }
                        }
                    } while ((n17 -= n16) != 0);
                    this.exception = this.comm.exceptions.getException(7008, stringArray);
                    break;
                }
                case 4659: {
                    int n18;
                    int n19 = n;
                    String[] stringArray = new String[2];
                    do {
                        n18 = this.reader.readInt16();
                        short s = this.reader.readInt16();
                        n18 -= 4;
                        n19 -= 4;
                        switch (s) {
                            case 4397: {
                                stringArray[0] = this.reader.readString(n18);
                                break;
                            }
                            case 4435: {
                                stringArray[1] = this.reader.readString(n18);
                                break;
                            }
                            default: {
                                this.reader.readAndDiscardBytes(n18);
                            }
                        }
                    } while ((n19 -= n18) != 0);
                    this.exception = this.comm.exceptions.getException(7009, stringArray);
                    break;
                }
                case 4684: {
                    int n20;
                    int n21 = n;
                    String[] stringArray = new String[2];
                    do {
                        n20 = this.reader.readInt16();
                        short s = this.reader.readInt16();
                        n21 -= 4;
                        n20 -= 4;
                        block66 : switch (s) {
                            case 4425: {
                                this.reader.readAndDiscardBytes(n20);
                                break;
                            }
                            case 4426: {
                                byte by = this.reader.readInt8();
                                switch (by) {
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 6: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7043, null);
                                        break block66;
                                    }
                                    case 7: 
                                    case 8: 
                                    case 9: 
                                    case 10: 
                                    case 11: {
                                        if (this.comm.isUDBCompatible() && (this.comm.ServerClassName.equalsIgnoreCase("QDB2") || this.comm.ServerClassName.equalsIgnoreCase("QAS"))) {
                                            this.exception = this.comm.exceptions.getException(7085);
                                            break block66;
                                        }
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7044, null);
                                        break block66;
                                    }
                                    case 12: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7045, null);
                                        break block66;
                                    }
                                    case 13: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7046, null);
                                        break block66;
                                    }
                                    case 14: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7047, null);
                                        break block66;
                                    }
                                    case 15: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7048, null);
                                        break block66;
                                    }
                                    case 16: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7049, null);
                                        break block66;
                                    }
                                    case 17: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7050, null);
                                        break block66;
                                    }
                                    case 18: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7051, null);
                                        break block66;
                                    }
                                    case 19: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7052, null);
                                        break block66;
                                    }
                                    case 20: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7053, null);
                                        break block66;
                                    }
                                    case 21: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7054, null);
                                        break block66;
                                    }
                                    case 22: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7055, null);
                                        break block66;
                                    }
                                    case 23: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7056, null);
                                        break block66;
                                    }
                                    case 24: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7057, null);
                                        break block66;
                                    }
                                    case 25: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7058, null);
                                        break block66;
                                    }
                                    case 26: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7059, null);
                                        break block66;
                                    }
                                    case 27: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7060, null);
                                        break block66;
                                    }
                                    case 29: {
                                        stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7061, null);
                                        break block66;
                                    }
                                }
                                stringArray[0] = this.comm.exceptions.getMessages().getImplLocalMessages().getString(7062, null);
                                break;
                            }
                            case 12: {
                                stringArray[1] = ", " + Integer.toHexString(this.reader.readInt16());
                                break;
                            }
                            default: {
                                this.reader.readAndDiscardBytes(n20);
                            }
                        }
                    } while ((n21 -= n20) != 0);
                    if (this.exception == null) {
                        this.exception = this.comm.exceptions.getException(7010, stringArray, "0800");
                    }
                    break;
                }
                case 4703: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7011);
                    break;
                }
                case 4690: {
                    int n22 = n;
                    String[] stringArray = new String[1];
                    do {
                        int n23 = this.reader.readInt16();
                        short s = this.reader.readInt16();
                        n23 -= 4;
                        n22 -= 4;
                        switch (s) {
                            case 12: {
                                stringArray[0] = this.drdaUtil.getNameForCPType(this.reader.readInt16());
                                n22 -= 2;
                                break;
                            }
                            default: {
                                this.reader.readAndDiscardBytes(n23);
                                n22 -= n23;
                            }
                        }
                    } while (n22 != 0);
                    this.exception = this.comm.exceptions.getException(7012, stringArray);
                    break;
                }
                case 8721: {
                    this.reader.readAndDiscardBytes(n);
                    String[] stringArray = new String[]{this.implConn.databaseName.toUpperCase()};
                    this.exception = this.comm.exceptions.getException(7015, stringArray, "08000");
                    break;
                }
                case 8707: {
                    this.reader.readAndDiscardBytes(n);
                    String[] stringArray = new String[]{this.implConn.databaseName.toUpperCase()};
                    this.exception = this.comm.exceptions.getException(7035, stringArray, "08000");
                    break;
                }
                case 8708: 
                case 8730: {
                    this.reader.readAndDiscardBytes(n);
                    String[] stringArray = new String[]{this.implConn.databaseName.toUpperCase()};
                    this.exception = this.comm.exceptions.getException(7036, stringArray, "08000");
                    break;
                }
                case 4691: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7034);
                    break;
                }
                case 8718: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7063);
                    break;
                }
                case 8714: {
                    this.reader.readAndDiscardBytes(n);
                    this.exception = this.comm.exceptions.getException(7071);
                    break;
                }
                case 8539: {
                    if (this.packageConsistencyToken.queryInstanceId == null) {
                        this.packageConsistencyToken.queryInstanceId = new byte[n];
                    }
                    this.reader.readBytes(this.packageConsistencyToken.queryInstanceId, 0, n);
                    break;
                }
                case 5228: {
                    if ((short)(n + 4) == -32760) {
                        n = this.reader.readInt32();
                        this.reader.readAndDiscardBytes(n);
                        break;
                    }
                    if ((short)(n + 4) == -32764) {
                        this.reader.discardCurrentPacket();
                        break;
                    }
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                case 4420: 
                case 4683: 
                case 8466: 
                case 8467: 
                case 8523: 
                case 8528: 
                case 8543: 
                case 8728: {
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                default: {
                    this.reader.readAndDiscardBytes(n);
                    String[] stringArray = new String[]{this.drdaUtil.getNameForCPType(n2)};
                    if (this.exception != null) {
                        this.exception.setNextException(this.comm.exceptions.getException(7013, stringArray));
                    } else {
                        this.exception = this.comm.exceptions.getException(7013, stringArray);
                    }
                    return false;
                }
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
        return true;
    }

    public void discardReplyBytes() {
        try {
            this.clearReplyChannel();
            this.reader.empty();
        }
        catch (UtilException utilException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public final void processSQLCA(BaseWarnings baseWarnings) throws UtilException {
        try {
            if (this.reader.currentPacketLength - this.reader.numBytesReadFromCurrentPacket < 1) {
                this.ensureBytes(1, baseWarnings);
            }
            if (this.reader.readUnsignedInt8() != 255) {
                if (!this.comm.isServerBigEndianOS) {
                    this.reader.interpretAsBigEndian = false;
                }
                if (this.reader.currentPacketLength - this.reader.numBytesReadFromCurrentPacket < 17) {
                    this.ensureBytes(17, baseWarnings);
                }
                this.sqlCode = this.reader.readInt32();
                this.reader.readBytes(this.sqlStateBytes, 0, 5);
                this.reader.readBytes(this.sqlErrProcBytes, 0, 8);
                if (this.reader.currentPacketLength - this.reader.numBytesReadFromCurrentPacket < 1) {
                    this.ensureBytes(1, baseWarnings);
                }
                if (this.reader.readUnsignedInt8() != 255) {
                    short s;
                    if (this.comm.SQLAMLevel < 7) {
                        if (this.reader.currentPacketLength - this.reader.numBytesReadFromCurrentPacket < 53) {
                            this.ensureBytes(53, baseWarnings);
                        }
                    } else if (this.reader.currentPacketLength - this.reader.numBytesReadFromCurrentPacket < 35) {
                        this.ensureBytes(35, baseWarnings);
                    }
                    if (this.comm.SQLAMLevel < 7) {
                        this.reader.readAndDiscardBytes(18);
                    }
                    int n = this.reader.readInt32();
                    this.reader.readAndDiscardBytes(4);
                    int n2 = this.reader.readInt32();
                    this.reader.readAndDiscardBytes(23);
                    if (this.comm.SQLAMLevel >= 7) {
                        this.reader.interpretAsBigEndian = true;
                        if (this.reader.currentPacketLength - this.reader.numBytesReadFromCurrentPacket < 2) {
                            this.ensureBytes(2, baseWarnings);
                        }
                        if (this.reader.currentPacketLength - this.reader.numBytesReadFromCurrentPacket < (s = this.reader.readInt16())) {
                            this.ensureBytes(s, baseWarnings);
                        }
                        this.reader.readAndDiscardBytes(s);
                    }
                    this.returnValueForStoredProcedure = n;
                    if (n2 >= 0) {
                        this.numRowsAffected = n2;
                        this.resultType = 3;
                        this.checkingForAdditionalUpdateCounts = true;
                    }
                    this.reader.interpretAsBigEndian = true;
                    if (this.reader.currentPacketLength - this.reader.numBytesReadFromCurrentPacket < 2) {
                        this.ensureBytes(2, baseWarnings);
                    }
                    if ((s = this.reader.readInt16()) != 0) {
                        this.errParamsTranslit = this.comm.MultiByteServerTransliterator;
                        if (this.reader.currentPacketLength - this.reader.numBytesReadFromCurrentPacket < s + 2) {
                            this.ensureBytes(s + 2, baseWarnings);
                        }
                        this.errParamBytes = new byte[s];
                        try {
                            this.reader.readBytes(this.errParamBytes, 0, s);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.reader.readAndDiscardBytes(2);
                    } else {
                        short s2;
                        this.errParamsTranslit = this.comm.SingleByteServerTransliterator;
                        if (this.reader.currentPacketLength - this.reader.numBytesReadFromCurrentPacket < 2) {
                            this.ensureBytes(2, baseWarnings);
                        }
                        if (this.reader.currentPacketLength - this.reader.numBytesReadFromCurrentPacket < (s2 = this.reader.readInt16())) {
                            this.ensureBytes(s2, baseWarnings);
                        }
                        if (s2 != 0) {
                            this.errParamBytes = new byte[s2];
                            this.reader.readBytes(this.errParamBytes, 0, s2);
                        }
                    }
                }
                if (this.comm.SQLAMLevel >= 7) {
                    if (this.reader.currentPacketLength - this.reader.numBytesReadFromCurrentPacket < 1) {
                        this.ensureBytes(1, baseWarnings);
                    }
                    if (this.reader.readUnsignedInt8() != 255 && this.sqlCode >= 0) {
                        this.exception = this.comm.exceptions.getException(7087);
                    }
                }
                if (this.sqlCode > 0) {
                    switch (this.sqlCode) {
                        case 802: {
                            this.exception = this.comm.exceptions.getException(this.sqlCode, this.drdaUtil.readDelimitedStringFromBytes(this.errParamBytes, 18, (short)255, this.errParamsTranslit), this.comm.SingleByteServerTransliterator.decode(this.sqlStateBytes, 0, 5), this.sqlCode);
                            break;
                        }
                        case 100: {
                            if (this.comm.serverType != 9 && !this.implConn.holdCursorsOverCommit) {
                                this.isCursorOpen = false;
                            }
                            this.moreData = false;
                            break;
                        }
                        case 20: {
                            this.hasWarnings = true;
                            baseWarnings.add(this.sqlCode, this.drdaUtil.readDelimitedStringFromBytes(this.errParamBytes, 18, (short)255, this.errParamsTranslit), this.comm.SingleByteServerTransliterator.decode(this.sqlStateBytes, 0, 5), this.sqlCode);
                            break;
                        }
                        default: {
                            this.hasWarnings = true;
                            baseWarnings.add(this.sqlCode, this.comm.SingleByteServerTransliterator.decode(this.sqlStateBytes, 0, 5), this.sqlCode);
                            break;
                        }
                    }
                } else if (this.sqlCode < 0 && this.sqlCode != -501) {
                    String string = this.comm.SingleByteServerTransliterator.decode(this.sqlStateBytes, 0, 5);
                    String[] stringArray = null;
                    try {
                        stringArray = this.drdaUtil.readDelimitedStringFromBytes(this.errParamBytes, 18, (short)255, this.errParamsTranslit);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SQLException sQLException = null;
                    if (string.equalsIgnoreCase("42601")) {
                        if (this.sqlCode == -7 && stringArray[0].equalsIgnoreCase("\n")) {
                            sQLException = this.comm.exceptions.getException(7086, stringArray, string, this.sqlCode);
                        }
                    } else if (string.equalsIgnoreCase("57014")) {
                        if (this.sqlCode == -952) {
                            sQLException = this.comm.exceptions.getException(6078, "HY008");
                        }
                    } else if (string.equalsIgnoreCase("57011")) {
                        if (this.sqlCode == -954) {
                            sQLException = this.comm.exceptions.getException(7105, stringArray, string, this.sqlCode);
                        } else if (this.sqlCode == -964) {
                            sQLException = this.comm.exceptions.getException(7104, stringArray, string, this.sqlCode);
                        }
                    } else if (string.equalsIgnoreCase("55006") && this.sqlCode == -950) {
                        sQLException = this.comm.exceptions.getException(7110, stringArray, string, this.sqlCode);
                    }
                    if (this.sqlCode == -440) {
                        if (stringArray[0].equalsIgnoreCase("procedure")) {
                            stringArray[0] = stringArray[1];
                        }
                        sQLException = this.comm.exceptions.getException(this.sqlCode, stringArray, string, this.sqlCode);
                    } else if (sQLException == null) {
                        sQLException = this.comm.exceptions.getException(this.sqlCode, stringArray, string, this.sqlCode);
                    }
                    if (this.exception == null) {
                        this.exception = sQLException;
                    } else if (sQLException.getErrorCode() != -514 && !sQLException.getSQLState().equalsIgnoreCase("26501") && sQLException.getErrorCode() != -518 && !sQLException.getSQLState().equalsIgnoreCase("07003")) {
                        if (this.isABEND) {
                            this.exception = this.comm.exceptions.getException(7064, null, "40001", -911);
                            this.isABEND = false;
                        }
                        this.exception.setNextException(sQLException);
                    }
                    ++this.numExceptions;
                }
            }
            this.reader.interpretAsBigEndian = true;
        }
        catch (SQLException sQLException) {
            this.exception = sQLException;
        }
    }
}

