/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.modelgenerator.wsdl.validation.internal;

import com.metamatrix.modeler.modelgenerator.wsdl.ModelGeneratorWsdlPlugin;
import com.metamatrix.modeler.modelgenerator.xml.XmlImporterUiPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.wsdl.validation.internal.resolver.IExtensibleURIResolver;
import org.eclipse.wst.wsdl.validation.internal.resolver.IURIResolutionResult;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDParser;

public class NamespaceResolver
implements IExtensibleURIResolver {
    private Map<String, String> namespaceToXsd;

    public NamespaceResolver() throws Exception {
        String path;
        IPreferenceStore prefs = XmlImporterUiPlugin.getDefault().getPreferenceStore();
        String directory = prefs.getString("xsdLibrary");
        File xsdDirectory = new File(directory);
        if (!xsdDirectory.exists()) {
            throw new Exception(ModelGeneratorWsdlPlugin.Util.getString("NamespaceResolver.BadDirectory"));
        }
        ArrayList<String> xsdPaths = new ArrayList<String>();
        if (xsdDirectory.canRead()) {
            String[] allContents = xsdDirectory.list();
            for (int i = 0; i < allContents.length; ++i) {
                path = allContents[i];
                if (!path.endsWith(".xsd")) continue;
                xsdPaths.add(directory + File.separatorChar + path);
            }
        }
        this.namespaceToXsd = new HashMap<String, String>();
        Iterator iter = xsdPaths.iterator();
        while (iter.hasNext()) {
            XSDParser parser = new XSDParser();
            path = (String)iter.next();
            parser.parse((InputStream)new FileInputStream(path));
            XSDSchema schema = parser.getSchema();
            String namespace = schema.getTargetNamespace();
            this.namespaceToXsd.put(namespace, "file:" + path);
        }
    }

    public void resolve(String baseLocation, String publicId, String systemId, IURIResolutionResult result) {
        if (this.namespaceToXsd.containsKey(publicId)) {
            result.setPhysicalLocation(this.namespaceToXsd.get(publicId));
            result.setLogicalLocation(this.namespaceToXsd.get(publicId));
        }
    }
}

