/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilDataConsumer;
import com.metamatrix.util.UtilDataProvider;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTempBuffer;
import com.metamatrix.util.UtilTempBufferBlock;
import com.metamatrix.util.UtilTempBufferInputStream;
import com.metamatrix.util.UtilTempBufferOutputStream;
import com.metamatrix.util.UtilTempFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class UtilPagedTempBuffer
implements UtilTempBuffer {
    private static String footprint = "$Revision:   3.16.1.0  $";
    private int currentBlockNum;
    private UtilTempBufferBlock[] blocks;
    private int numAllocatedBlocks;
    private int maxBlocks;
    private byte[] staticByteArray;
    private int blockSize;
    private int blockShift;
    private File tmpFileInfo;
    private RandomAccessFile tmpFile;
    private InputStream lastInputStream;
    private OutputStream lastOutputStream;
    long nextAvail;
    boolean overflowToDisk;
    boolean hitOutOfMemoryError;
    static final int DEFAULT_NUM_BLOCKS = 128;
    static final int DEFAULT_BLOCK_SIZE = 16;
    static final int DEFAULT_BLOCK_SHIFT = 14;
    static final String TEMP_FILE_PREFIX = "ddtb";
    static final int NUM_BITS_IN_LONG = 64;
    static final int NUM_BITS_TO_REPRESENT_1KB = 10;
    static final int NUM_BLOCKS_GROWTH_INCREMENT = 100;

    public UtilPagedTempBuffer() {
        this.setup(128, 16);
    }

    public UtilPagedTempBuffer(int n) {
        int n2;
        int n3;
        int n4 = n;
        if (n4 % 2 != 0) {
            n3 = n4;
            n2 = 1;
        } else {
            int n5;
            for (n5 = 1; n5 < 6 && n4 % (1 << n5 + 1) == 0; ++n5) {
            }
            n2 = 1 << n5;
            n3 = n4 / n2;
        }
        this.setup(n3, n2);
    }

    public UtilPagedTempBuffer(int n, int n2) {
        this.setup(n, n2);
    }

    public void setup(int n, int n2) {
        this.blocks = null;
        this.currentBlockNum = 0;
        this.numAllocatedBlocks = 0;
        this.maxBlocks = n;
        this.setBlockSize(n2);
        this.tmpFileInfo = null;
        this.tmpFile = null;
        this.nextAvail = 0L;
        this.lastInputStream = null;
        this.lastOutputStream = null;
        this.staticByteArray = new byte[256];
        this.overflowToDisk = true;
    }

    public void setOverflowToDisk(boolean bl) {
        this.overflowToDisk = bl;
    }

    public int write(long l, byte by) throws UtilException {
        this.staticByteArray[0] = by;
        return this.write(l, this.staticByteArray, 0, 1);
    }

    public int write(long l, byte[] byArray) throws UtilException {
        return this.write(l, byArray, 0, byArray.length);
    }

    public int write(long l, byte[] byArray, int n, int n2) throws UtilException {
        if (l < 0L) {
            throw new UtilException(1023, "offset can not be negative.");
        }
        if (byArray == null) {
            throw new UtilException(1023, "buffer can not be null.");
        }
        if (n < 0 || n > byArray.length) {
            throw new UtilException(1023, "invalid bufferOffset.");
        }
        if (n2 < 0) {
            throw new UtilException(1023, "length can not be negative.");
        }
        if (l > this.nextAvail) {
            throw new UtilException(1023, "specified offset extends beyond current end of buffer.");
        }
        if (n2 > byArray.length - n) {
            n2 = byArray.length - n;
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = (int)(l >> this.blockShift);
        UtilTempBufferBlock utilTempBufferBlock = null;
        int n4 = 0;
        boolean bl = false;
        while (true) {
            int n5;
            int n6;
            if ((n6 = this.blockSize - (n5 = (int)(l & (long)(this.blockSize - 1)))) > n2) {
                n6 = n2;
            }
            boolean bl2 = true;
            if (n6 == this.blockSize || l >= this.nextAvail && n5 == 0) {
                bl2 = false;
            }
            if ((utilTempBufferBlock = this.getBlock(n3, bl2)) == null) {
                bl = true;
                break;
            }
            utilTempBufferBlock.blockDirty = true;
            System.arraycopy(byArray, n, utilTempBufferBlock.data, n5, n6);
            l += (long)n6;
            n4 += n6;
            if ((n2 -= n6) == 0) break;
            n += n6;
            ++n3;
        }
        if (l > this.nextAvail) {
            this.nextAvail = l;
        }
        if (bl) {
            return -n4;
        }
        return n4;
    }

    public int write(long l, UtilDataProvider utilDataProvider, int n) throws UtilException {
        if (l < 0L) {
            throw new UtilException(1023, "offset can not be negative.");
        }
        if (utilDataProvider == null) {
            throw new UtilException(1023, "dataProvider cannot be null");
        }
        if (n < 0) {
            throw new UtilException(1023, "length can not be negative.");
        }
        if (l > this.nextAvail) {
            throw new UtilException(1023, "specified offset extends beyond current end of buffer.");
        }
        if (n == 0) {
            return 0;
        }
        int n2 = (int)(l >> this.blockShift);
        UtilTempBufferBlock utilTempBufferBlock = null;
        int n3 = 0;
        boolean bl = false;
        while (true) {
            int n4;
            int n5;
            if ((n5 = this.blockSize - (n4 = (int)(l & (long)(this.blockSize - 1)))) > n) {
                n5 = n;
            }
            boolean bl2 = true;
            if (n5 == this.blockSize || l >= this.nextAvail && n4 == 0) {
                bl2 = false;
            }
            if ((utilTempBufferBlock = this.getBlock(n2, bl2)) == null) {
                bl = true;
                break;
            }
            utilTempBufferBlock.blockDirty = true;
            int n6 = n5;
            while (n6 > 0) {
                try {
                    int n7 = utilDataProvider.getArrayOfBytes(utilTempBufferBlock.data, n4, n6);
                    n6 -= n7;
                    n4 += n7;
                    n3 += n7;
                }
                catch (UtilException utilException) {
                    if (utilException.getReason() == 1001) {
                        if ((l += (long)(n5 - n6)) > this.nextAvail) {
                            this.nextAvail = l;
                        }
                        return n3;
                    }
                    throw utilException;
                }
            }
            l += (long)n5;
            if ((n -= n5) == 0) break;
            ++n2;
        }
        if (l > this.nextAvail) {
            this.nextAvail = l;
        }
        if (bl) {
            return -n3;
        }
        return n3;
    }

    public int write(long l, UtilDataProvider utilDataProvider) throws UtilException {
        return this.write(l, utilDataProvider, Integer.MAX_VALUE);
    }

    public int write(UtilDataProvider utilDataProvider) throws UtilException {
        return this.write(0L, utilDataProvider, Integer.MAX_VALUE);
    }

    public int writeInt(int n) throws UtilException {
        this.staticByteArray[0] = (byte)(n >>> 24 & 0xFF);
        this.staticByteArray[1] = (byte)(n >>> 16 & 0xFF);
        this.staticByteArray[2] = (byte)(n >>> 8 & 0xFF);
        this.staticByteArray[3] = (byte)(n >>> 0 & 0xFF);
        return this.write(this.nextAvail, this.staticByteArray, 0, 4);
    }

    public int writeInt(long l, int n) throws UtilException {
        this.staticByteArray[0] = (byte)(n >>> 24 & 0xFF);
        this.staticByteArray[1] = (byte)(n >>> 16 & 0xFF);
        this.staticByteArray[2] = (byte)(n >>> 8 & 0xFF);
        this.staticByteArray[3] = (byte)(n >>> 0 & 0xFF);
        return this.write(l, this.staticByteArray, 0, 4);
    }

    public int writeLong(long l) throws UtilException {
        this.staticByteArray[0] = (byte)(l >>> 56 & 0xFFL);
        this.staticByteArray[1] = (byte)(l >>> 48 & 0xFFL);
        this.staticByteArray[2] = (byte)(l >>> 40 & 0xFFL);
        this.staticByteArray[3] = (byte)(l >>> 32 & 0xFFL);
        this.staticByteArray[4] = (byte)(l >>> 24 & 0xFFL);
        this.staticByteArray[5] = (byte)(l >>> 16 & 0xFFL);
        this.staticByteArray[6] = (byte)(l >>> 8 & 0xFFL);
        this.staticByteArray[7] = (byte)(l >>> 0 & 0xFFL);
        return this.write(this.nextAvail, this.staticByteArray, 0, 8);
    }

    public byte read(long l) throws UtilException {
        int n = this.read(l, this.staticByteArray, 0, 1);
        if (n != 1) {
            throw new UtilException(1016);
        }
        return this.staticByteArray[0];
    }

    public byte[] read(long l, int n) throws UtilException {
        byte[] byArray;
        int n2;
        if (l + (long)n > this.nextAvail) {
            n = (int)(this.nextAvail - l);
        }
        if ((n2 = this.read(l, byArray = new byte[n], 0, n)) != n) {
            throw new UtilException(1016);
        }
        return byArray;
    }

    public int read(long l, byte[] byArray, int n, int n2) throws UtilException {
        if (l < 0L) {
            throw new UtilException(1023, "offset can not be negative.");
        }
        if (byArray == null) {
            throw new UtilException(1023, "dataProvider cannot be null");
        }
        if (n < 0 || n > byArray.length) {
            throw new UtilException(1023, "invalid bufferOffset");
        }
        if (n2 <= 0) {
            if (n2 == 0) {
                return 0;
            }
            throw new UtilException(1023, "length can not be negative.");
        }
        if (l > this.nextAvail) {
            throw new UtilException(1023, "specified offset extends beyond current end of buffer.");
        }
        if (l + (long)n2 > this.nextAvail) {
            n2 = (int)(this.nextAvail - l);
        }
        if (n + n2 > byArray.length) {
            throw new UtilException(1023, "insufficient space in specified buffer");
        }
        int n3 = (int)(l >> this.blockShift);
        int n4 = 0;
        UtilTempBufferBlock utilTempBufferBlock = null;
        while (true) {
            int n5;
            int n6;
            if ((n6 = this.blockSize - (n5 = (int)(l & (long)(this.blockSize - 1)))) > n2) {
                n6 = n2;
            }
            utilTempBufferBlock = this.currentBlockNum == n3 && this.blocks[this.currentBlockNum].blockNum == n3 && this.blocks[this.currentBlockNum].data.length - n5 >= n6 ? this.blocks[this.currentBlockNum] : this.getBlock(n3, true);
            System.arraycopy(utilTempBufferBlock.data, n5, byArray, n, n6);
            n4 += n6;
            if ((n2 -= n6) == 0) break;
            n += n6;
            l += (long)n6;
            ++n3;
        }
        return n4;
    }

    public byte readByte(long l) throws UtilException {
        try {
            int n = (int)(l >> this.blockShift);
            int n2 = (int)(l & (long)(this.blockSize - 1));
            if (this.currentBlockNum == n && this.blocks[this.currentBlockNum].blockNum == n) {
                return this.blocks[this.currentBlockNum].data[n2];
            }
            UtilTempBufferBlock utilTempBufferBlock = this.getBlock(n, true);
            return utilTempBufferBlock.data[n2];
        }
        catch (Exception exception) {
            throw new UtilException(1023, exception.getMessage());
        }
    }

    public int read(long l, UtilDataConsumer utilDataConsumer, int n) throws UtilException {
        if (l < 0L) {
            throw new UtilException(1023, "offset can not be negative.");
        }
        if (utilDataConsumer == null) {
            throw new UtilException(1023, "dataConsumer cannot be null");
        }
        if (n < 0) {
            throw new UtilException(1023, "length can not be negative.");
        }
        if (l > this.nextAvail) {
            throw new UtilException(1023, "specified offset extends beyond current end of buffer.");
        }
        UtilDebug.assert("Attempting to read past end of file", l + (long)n <= this.nextAvail);
        if (l + (long)n > this.nextAvail) {
            n = (int)(this.nextAvail - l);
        }
        if (n == 0) {
            return 0;
        }
        int n2 = (int)(l >> this.blockShift);
        int n3 = 0;
        UtilTempBufferBlock utilTempBufferBlock = null;
        while (true) {
            int n4;
            int n5;
            if ((n5 = this.blockSize - (n4 = (int)(l & (long)(this.blockSize - 1)))) > n) {
                n5 = n;
            }
            utilTempBufferBlock = this.getBlock(n2, true);
            utilDataConsumer.putArrayOfBytes(utilTempBufferBlock.data, n4, n5);
            n3 += n5;
            if ((n -= n5) == 0) break;
            l += (long)n5;
            ++n2;
        }
        return n3;
    }

    public int readInt(long l) throws UtilException {
        int n = this.read(l, this.staticByteArray, 0, 4);
        if (n != 4) {
            return -1;
        }
        int n2 = ((this.staticByteArray[0] & 0xFF) << 24) + ((this.staticByteArray[1] & 0xFF) << 16) + ((this.staticByteArray[2] & 0xFF) << 8) + ((this.staticByteArray[3] & 0xFF) << 0);
        return n2;
    }

    public long readLong(long l) throws UtilException {
        int n = this.read(l, this.staticByteArray, 0, 8);
        if (n != 8) {
            return -1L;
        }
        long l2 = (((long)this.staticByteArray[0] & 0xFFL) << 56) + (((long)this.staticByteArray[1] & 0xFFL) << 48) + (((long)this.staticByteArray[2] & 0xFFL) << 40) + (((long)this.staticByteArray[3] & 0xFFL) << 32) + (((long)this.staticByteArray[4] & 0xFFL) << 24) + (((long)this.staticByteArray[5] & 0xFFL) << 16) + (((long)this.staticByteArray[6] & 0xFFL) << 8) + (((long)this.staticByteArray[7] & 0xFFL) << 0);
        return l2;
    }

    public InputStream getInputStream() {
        this.closeInputStream();
        this.lastInputStream = new UtilTempBufferInputStream(this);
        return this.lastInputStream;
    }

    public OutputStream getOutputStream() {
        this.closeOutputStream();
        this.lastOutputStream = new UtilTempBufferOutputStream(this);
        return this.lastOutputStream;
    }

    public void truncate(long l) throws UtilException {
        int n;
        this.nextAvail = l;
        this.closeInputStream();
        this.closeOutputStream();
        for (int i = n = (int)l / this.blockSize + 1; i < this.numAllocatedBlocks; ++i) {
            UtilTempBufferBlock utilTempBufferBlock = this.blocks[i];
            if (utilTempBufferBlock == null) continue;
            utilTempBufferBlock.reset();
        }
        if (this.tmpFile != null) {
            try {
                this.tmpFile.setLength(l);
            }
            catch (IOException iOException) {
                throw new UtilException(1015, iOException.getMessage());
            }
        }
    }

    public void truncate() throws UtilException {
        this.nextAvail = 0L;
        this.closeInputStream();
        this.closeOutputStream();
        for (int i = 0; i < this.numAllocatedBlocks; ++i) {
            UtilTempBufferBlock utilTempBufferBlock = this.blocks[i];
            if (utilTempBufferBlock == null) continue;
            utilTempBufferBlock.reset();
        }
        if (this.tmpFile != null) {
            try {
                this.tmpFile.setLength(0L);
            }
            catch (IOException iOException) {
                throw new UtilException(1015, iOException.getMessage());
            }
        }
    }

    public void truncate(boolean bl) throws UtilException {
        if (!bl) {
            this.truncate();
        } else {
            this.nextAvail = 0L;
            this.closeInputStream();
            this.closeOutputStream();
            if (this.tmpFile != null) {
                try {
                    this.tmpFile.close();
                    this.tmpFile = null;
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            UtilPagedTempBuffer.this.tmpFileInfo.delete();
                            return null;
                        }
                    });
                    this.tmpFileInfo = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.blocks != null) {
                for (int i = 0; i < this.numAllocatedBlocks; ++i) {
                    this.blocks[i] = null;
                }
                this.numAllocatedBlocks = 0;
                this.hitOutOfMemoryError = false;
            }
        }
    }

    public long getSize() {
        return this.nextAvail;
    }

    private void setBlockSize(int n) {
        if (n == 16) {
            this.blockSize = 16384;
            this.blockShift = 14;
        } else {
            int n2;
            for (n2 = 1; n2 < 54; ++n2) {
                int n3 = n >> n2;
                if (n >> n2 != 0) continue;
                this.blockShift = n2 - 1 + 10;
                break;
            }
            if (n2 == 54) {
                UtilDebug.assert("Invalid block size specified.  Block size is in KBytes and must be a power of 2", false);
                this.blockShift = 14;
            }
            this.blockSize = 1 << this.blockShift;
            UtilDebug.assert("Blocksize should be a power of two", this.blockSize == n * 1024);
        }
    }

    private UtilTempBufferBlock getBlock(int n, boolean bl) throws UtilException {
        int n2;
        if (this.hitOutOfMemoryError) {
            if (this.numAllocatedBlocks == 0) {
                throw new OutOfMemoryError();
            }
            n2 = n % this.numAllocatedBlocks;
        } else {
            n2 = n < this.maxBlocks ? n : n % this.maxBlocks;
            if (this.blocks == null || n2 >= this.blocks.length) {
                int n3 = Math.min(n2 + 100, this.maxBlocks);
                UtilTempBufferBlock[] utilTempBufferBlockArray = new UtilTempBufferBlock[n3];
                if (this.blocks != null) {
                    for (int i = 0; i < this.blocks.length; ++i) {
                        utilTempBufferBlockArray[i] = this.blocks[i];
                    }
                }
                this.blocks = utilTempBufferBlockArray;
            }
        }
        if (this.blocks == null) {
            throw new OutOfMemoryError();
        }
        if (this.blocks[n2] == null) {
            try {
                this.blocks[n2] = new UtilTempBufferBlock(this.blockSize);
                ++this.numAllocatedBlocks;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.hitOutOfMemoryError = true;
                if (this.numAllocatedBlocks == 0) {
                    throw new OutOfMemoryError();
                }
                n2 = n % this.numAllocatedBlocks;
            }
        }
        UtilTempBufferBlock utilTempBufferBlock = this.blocks[n2];
        if (utilTempBufferBlock.blockNum != n) {
            if (utilTempBufferBlock.blockDirty) {
                if (this.overflowToDisk) {
                    this.writeTmpFile(utilTempBufferBlock);
                } else {
                    return null;
                }
            }
            utilTempBufferBlock.blockNum = n;
            utilTempBufferBlock.blockDirty = false;
            if (bl) {
                this.readTmpFile(utilTempBufferBlock);
                utilTempBufferBlock.blockDirty = false;
            }
        }
        this.currentBlockNum = n2;
        return this.blocks[n2];
    }

    private RandomAccessFile getTempFile() throws UtilException {
        if (this.tmpFile == null) {
            try {
                this.tmpFileInfo = UtilTempFile.createTempFile(TEMP_FILE_PREFIX);
                try {
                    this.tmpFile = (RandomAccessFile)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return new RandomAccessFile(UtilPagedTempBuffer.this.tmpFileInfo, "rw");
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
            }
            catch (IOException iOException) {
                throw new UtilException(1012, iOException.getMessage());
            }
        }
        return this.tmpFile;
    }

    private void writeTmpFile(UtilTempBufferBlock utilTempBufferBlock) throws UtilException {
        RandomAccessFile randomAccessFile = this.getTempFile();
        int n = utilTempBufferBlock.blockNum << this.blockShift;
        try {
            randomAccessFile.seek(n);
            randomAccessFile.write(utilTempBufferBlock.data);
        }
        catch (IOException iOException) {
            throw new UtilException(1013, iOException.getMessage());
        }
    }

    private void readTmpFile(UtilTempBufferBlock utilTempBufferBlock) throws UtilException {
        RandomAccessFile randomAccessFile = this.getTempFile();
        int n = utilTempBufferBlock.blockNum << this.blockShift;
        try {
            randomAccessFile.seek(n);
            randomAccessFile.read(utilTempBufferBlock.data);
        }
        catch (IOException iOException) {
            throw new UtilException(1014, iOException.getMessage());
        }
    }

    private void closeInputStream() {
        if (this.lastInputStream != null) {
            try {
                this.lastInputStream.close();
                this.lastInputStream = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void closeOutputStream() {
        if (this.lastOutputStream != null) {
            try {
                this.lastOutputStream.close();
                this.lastOutputStream = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void finalize() throws Throwable {
        this.truncate(true);
    }
}

