/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sybase;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseTimestamp;
import com.metamatrix.util.UtilDateAndTimeFunctions;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;

public class SybaseDateTime {
    private static String footprint = "$Revision:   3.5.1.1  $";
    public static final int NUM_300TH_SECONDS_IN_ONE_MINUTE = 18000;
    private static int BASEYEAR = 1753;
    private static int BASEBIAS = 53690;
    private static int MAXYEAR = 9999;
    private static int BASEYEARFORDATE = 1;
    private static int BASEBIASFORDATE = 693596;

    public static void validateTimestamp(BaseExceptions baseExceptions, BaseTimestamp baseTimestamp) throws SQLException {
        if (baseTimestamp == null) {
            return;
        }
        int n = baseTimestamp.getYear();
        if (n < BASEYEAR || n > MAXYEAR) {
            throw baseExceptions.getException(7011);
        }
    }

    public static void validateDate(BaseExceptions baseExceptions, Date date) throws SQLException {
        if (date == null) {
            return;
        }
        int n = date.getYear() + 1900;
        if (n < BASEYEARFORDATE || n > MAXYEAR) {
            throw baseExceptions.getException(7011);
        }
    }

    public static BaseTimestamp toTimestamp(int n, int n2) {
        int n3 = n2 / 300;
        int n4 = n2 - n3 * 300;
        int n5 = (n4 * 10 + 1) / 3 * 1000000;
        return new BaseTimestamp(1900, 0, ++n, 0, 0, n3, n5, null);
    }

    public static BaseTimestamp toTimestamp(int n) {
        int n2 = n / 300;
        int n3 = n - n2 * 300;
        int n4 = (n3 * 10 + 1) / 3 * 1000000;
        return new BaseTimestamp(1970, 0, 1, 0, 0, n2, n4, null);
    }

    public static Date toDate(int n) {
        return new Date(0, 0, n + 1);
    }

    public static int[] toNativeTimestamp(BaseTimestamp baseTimestamp) {
        int n = baseTimestamp.getYear();
        int n2 = baseTimestamp.getMonth() + 1;
        int n3 = (n -= BASEYEAR) * 365 + UtilDateAndTimeFunctions.leapCount(n) + UtilDateAndTimeFunctions.JulianDays[n2] + baseTimestamp.getDate();
        if (n2 > 2 && UtilDateAndTimeFunctions.isLeapYear(n + BASEYEAR)) {
            ++n3;
        }
        int n4 = n3 - BASEBIAS - 1;
        int n5 = baseTimestamp.getHours() * 1080000 + baseTimestamp.getMinutes() * 18000 + baseTimestamp.getSeconds() * 300 + (int)(((long)baseTimestamp.getNanos() * 300L + 500000000L) / 1000000000L);
        if (n5 >= 25920000) {
            n5 = 0;
        }
        int[] nArray = new int[]{++n4, n5};
        return nArray;
    }

    public static int toNativeTime(Time time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        int n = calendar.get(11) * 1080000 + calendar.get(12) * 18000 + calendar.get(13) * 300;
        int n2 = calendar.get(14) * 300 / 1000;
        return n += n2;
    }

    public static int toNativeTime(BaseTimestamp baseTimestamp) {
        int n = baseTimestamp.getHours() * 1080000 + baseTimestamp.getMinutes() * 18000 + baseTimestamp.getSeconds() * 300 + (int)(((long)baseTimestamp.getNanos() * 300L + 500000000L) / 1000000000L);
        return n;
    }

    public static int toNativeDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = (n -= BASEYEARFORDATE) * 365 + SybaseDateTime.leapCount(n) + UtilDateAndTimeFunctions.JulianDays[n2] + calendar.get(5);
        if (n2 > 2 && UtilDateAndTimeFunctions.isLeapYear(n + BASEYEARFORDATE)) {
            ++n3;
        }
        return n3 - BASEBIASFORDATE;
    }

    static int leapCount(int n) {
        if (n < 0) {
            return 0;
        }
        long l = n / 100;
        return (int)((long)(n >> 2) - l + (l >> 2));
    }
}

