/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.resolver.util.ResolverUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.Reference;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleRemoveOptionalJoins
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        try {
            this.removeOptionalJoinNodes(plan, metadata, capFinder, null);
        }
        catch (QueryResolverException e) {
            throw new MetaMatrixComponentException((Throwable)e);
        }
        return plan;
    }

    private boolean removeOptionalJoinNodes(PlanNode node, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, Set elements) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException, QueryResolverException {
        if (node.getChildCount() == 0) {
            return false;
        }
        boolean isRoot = false;
        switch (node.getType()) {
            case 7: {
                if (this.removedJoin(node, node.getFirstChild(), elements, metadata)) {
                    return true;
                }
                if (this.removedJoin(node, node.getLastChild(), elements, metadata)) {
                    return true;
                }
                List crits = (List)node.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
                ElementCollectorVisitor.getElements(crits, elements);
                break;
            }
            case 11: {
                if (node.getProperty((Object)NodeConstants.Info.INTO_GROUP) != null) {
                    elements = null;
                    node = NodeEditor.findNodePreOrder(node.getFirstChild(), 11);
                }
                if (elements == null) {
                    isRoot = true;
                    elements = new HashSet();
                }
                if (!isRoot && NodeEditor.findNodePreOrder(node.getFirstChild(), 23, 11) != null) {
                    isRoot = true;
                }
                if (!isRoot) break;
                List columns = (List)node.getProperty((Object)NodeConstants.Info.PROJECT_COLS);
                ElementCollectorVisitor.getElements(columns, elements);
                this.collectCorrelatedReferences(node, elements);
                break;
            }
            case 19: {
                if (elements == null) break;
                Map symbolMap = (Map)node.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
                HashSet convertedElements = new HashSet();
                for (Expression expression : elements) {
                    Expression convertedExpression = (Expression)symbolMap.get(expression);
                    if (convertedExpression == null) continue;
                    convertedElements.addAll(ElementCollectorVisitor.getElements((LanguageObject)convertedExpression, true));
                }
                elements = convertedElements;
                isRoot = true;
                break;
            }
            case 13: {
                if (elements == null) break;
                Criteria crit = (Criteria)node.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
                elements.addAll(ElementCollectorVisitor.getElements((LanguageObject)crit, true));
                break;
            }
            case 17: {
                List sortNodes;
                if (elements == null || (sortNodes = (List)node.getProperty((Object)NodeConstants.Info.SORT_ORDER)) == null) break;
                elements.addAll(sortNodes);
                break;
            }
            case 5: 
            case 29: {
                elements = null;
            }
        }
        if (isRoot) {
            boolean optionalRemoved = false;
            while (optionalRemoved = this.removeOptionalJoinNodes(node.getFirstChild(), metadata, capFinder, elements)) {
            }
            return false;
        }
        Iterator iter = node.getChildren().iterator();
        while (node.getChildCount() >= 1 && iter.hasNext()) {
            if (!this.removeOptionalJoinNodes((PlanNode)iter.next(), metadata, capFinder, elements)) continue;
            return true;
        }
        return false;
    }

    private void collectCorrelatedReferences(PlanNode node, Set<ElementSymbol> elements) {
        List refs = (List)node.getProperty((Object)NodeConstants.Info.CORRELATED_REFERENCES);
        if (refs != null) {
            for (Reference ref : refs) {
                Expression expr = ref.getExpression();
                ElementCollectorVisitor.getElements((LanguageObject)expr, elements);
            }
        }
    }

    private boolean removedJoin(PlanNode joinNode, PlanNode optionalNode, Set elements, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException, QueryResolverException {
        Set groups = optionalNode.getGroups();
        Assertion.isNotNull((Object)elements);
        for (ElementSymbol symbol : elements) {
            if (!groups.contains(symbol.getGroupSymbol())) continue;
            return false;
        }
        JoinType jt = (JoinType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
        if (!optionalNode.hasBooleanProperty((Object)NodeConstants.Info.IS_OPTIONAL)) {
            return false;
        }
        PlanNode parentNode = joinNode.getParent();
        joinNode.removeChild(optionalNode);
        NodeEditor.removeChildNode(parentNode, joinNode);
        HashSet optionElements = new HashSet();
        Iterator i = optionalNode.getGroups().iterator();
        while (i.hasNext()) {
            optionElements.addAll(ResolverUtil.resolveElementsInGroup((GroupSymbol)i.next(), metadata));
        }
        this.correctParents(optionalNode.getGroups(), parentNode, optionElements);
        return true;
    }

    private void correctParents(Set groups, PlanNode parentNode, HashSet optionElements) {
        boolean done = false;
        boolean correctJoinGroups = true;
        while (!done && parentNode != null) {
            switch (parentNode.getType()) {
                case 29: {
                    done = true;
                    break;
                }
                case 19: {
                    HashSet parentOptionalElements = new HashSet();
                    Map symbolMap = (Map)parentNode.getProperty((Object)NodeConstants.Info.SYMBOL_MAP);
                    for (Map.Entry entry : symbolMap.entrySet()) {
                        Expression parentExpression = (Expression)entry.getValue();
                        Collection parentElements = ElementCollectorVisitor.getElements((LanguageObject)parentExpression, true);
                        parentElements.retainAll(optionElements);
                        if (parentElements.isEmpty()) continue;
                        parentOptionalElements.addAll(ElementCollectorVisitor.getElements((LanguageObject)((Expression)entry.getKey()), true));
                    }
                    correctJoinGroups = false;
                    optionElements = parentOptionalElements;
                    if (!optionElements.isEmpty()) break;
                    done = true;
                    break;
                }
                case 7: {
                    List joinCriteria = (List)parentNode.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
                    this.removeOptionalEntries(optionElements, joinCriteria, null);
                    if (!correctJoinGroups) break;
                    parentNode.getGroups().removeAll(groups);
                    break;
                }
                case 11: {
                    if (parentNode.getParent() != null && parentNode.getProperty((Object)NodeConstants.Info.INTO_GROUP) == null) break;
                    done = true;
                }
            }
            parentNode = parentNode.getParent();
        }
    }

    private void removeOptionalEntries(HashSet optionElements, List languageObjects, PlanNode parentNode) {
        if (languageObjects != null && !languageObjects.isEmpty()) {
            if (parentNode != null) {
                parentNode.getGroups().clear();
            }
            Iterator i = languageObjects.iterator();
            while (i.hasNext()) {
                LanguageObject object = (LanguageObject)i.next();
                if (this.isOptional(optionElements, object)) {
                    i.remove();
                    continue;
                }
                if (parentNode == null) continue;
                parentNode.addGroups(GroupsUsedByElementsVisitor.getGroups((LanguageObject)object));
            }
        }
    }

    private boolean isOptional(HashSet optionElements, LanguageObject languageObject) {
        Collection elementsUsed = ElementCollectorVisitor.getElements(languageObject, true);
        elementsUsed.retainAll(optionElements);
        return !elementsUsed.isEmpty();
    }

    public String toString() {
        return "RuleRemoveOptionalJoins";
    }
}

