/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseClassUtility;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseLicense;
import com.metamatrix.jdbc.base.BasePropertiesFile;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;

public final class BaseLicenseUtility {
    private static String footprint = "$Revision:   3.14.1.0  $";
    protected static String spPassword = null;

    public static boolean isLocked(BaseConnection baseConnection) throws SQLException {
        String string = BaseClassUtility.getRootName(baseConnection);
        boolean bl = true;
        try {
            String string2 = "com.metamatrix.jdbc." + string.toLowerCase() + "." + string + "License";
            BaseLicense baseLicense = (BaseLicense)Class.forName(string2).newInstance();
            baseConnection.requireCPUCheck = baseLicense.doCPUCheck();
            bl = baseLicense.getMajorVer() == 3 && baseLicense.getMinorVer() == 7 ? false : BaseLicenseUtility.checkEvalAndEmbedding(baseConnection, string, bl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = BaseLicenseUtility.checkEvalAndEmbedding(baseConnection, string, bl);
        }
        catch (InstantiationException instantiationException) {
            throw baseConnection.exceptions.getException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw baseConnection.exceptions.getException(illegalAccessException);
        }
        return bl;
    }

    private static boolean checkEvalAndEmbedding(BaseConnection baseConnection, String string, boolean bl) throws SQLException {
        int n = BaseLicenseUtility.checkEval(string);
        if (n == 0) {
            baseConnection.isEval = true;
            bl = false;
        } else {
            if (n == 1) {
                throw baseConnection.exceptions.getException(6044);
            }
            if (BaseLicenseUtility.isEmbeddedWithClassName()) {
                baseConnection.isEmbedded = true;
                bl = false;
            } else if (BaseLicenseUtility.isEmbeddedWithSystemProperty()) {
                baseConnection.isEmbedded = true;
                bl = false;
            }
        }
        return bl;
    }

    static boolean unlock(String string) {
        BasePropertiesFile basePropertiesFile = new BasePropertiesFile();
        String string2 = basePropertiesFile.getProperty("connectjdbc.properties", "applicationKey");
        if (string2 != null) {
            if (string2.startsWith("sp:") && string != null) {
                string = "sp:" + string;
            }
            if (string2.equals(string)) {
                return true;
            }
        }
        return false;
    }

    private static int checkEval(String string) {
        int n = 0;
        String string2 = string.toLowerCase() + ".eval.expiration";
        BasePropertiesFile basePropertiesFile = new BasePropertiesFile();
        String string3 = basePropertiesFile.getProperty("connectjdbc.properties", string2);
        Date date = new Date();
        if (string3 != null) {
            Date date2 = new Date(Long.parseLong(string3));
            if (date.after(date2)) {
                n = 1;
            }
        } else {
            n = 2;
        }
        return n;
    }

    private static boolean isEmbeddedWithClassName() {
        BasePropertiesFile basePropertiesFile = new BasePropertiesFile();
        String string = basePropertiesFile.getProperty("connectjdbc.properties", "applicationKey");
        if (string != null && string.regionMatches(true, 0, "class:", 0, 6)) {
            try {
                String string2 = string.substring(6, string.length());
                if (Class.forName(string2) != null) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    protected static boolean isEmbeddedWithSystemProperty() {
        Boolean bl = new Boolean(false);
        BasePropertiesFile basePropertiesFile = new BasePropertiesFile();
        final String string = basePropertiesFile.getProperty("connectjdbc.properties", "applicationKey");
        if (string != null && string.regionMatches(true, 0, "sp:", 0, 3)) {
            Object var3_3 = null;
            PrivilegedAction privilegedAction = new PrivilegedAction(){

                public Object run() {
                    if (spPassword != null) {
                        if (("sp:" + spPassword).equals(string)) {
                            return new Boolean(true);
                        }
                    } else {
                        Properties properties = System.getProperties();
                        String string2 = properties.getProperty("module.core.status");
                        if (string2 != null && string2.length() > 0) {
                            spPassword = string2;
                            properties.setProperty("module.core.status", "running");
                            return new Boolean(BaseLicenseUtility.isEmbeddedWithSystemProperty());
                        }
                    }
                    return new Boolean(false);
                }
            };
            try {
                bl = (Boolean)AccessController.doPrivileged(privilegedAction);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return bl;
    }
}

