/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseArrayImplResultSet;
import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseResultSet;
import com.metamatrix.jdbc.base.BaseStatement;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class BaseArray
implements Array {
    static final String footprint = "$Revision:   1.1.1.0  $";
    private Object[] m_arrayData;
    private int m_elementType;
    private int m_baseSQLType;
    private BaseColumn m_colDescForArray;
    private BaseStatement m_baseStatement;

    public BaseArray(Object[] objectArray, BaseStatement baseStatement, int n, int n2) {
        this.m_arrayData = objectArray;
        this.m_baseStatement = baseStatement;
        this.m_baseSQLType = n;
        this.m_elementType = n2;
    }

    public void setColumnDescription(BaseColumn baseColumn) {
        this.m_colDescForArray = baseColumn;
    }

    public Object getArray() throws SQLException {
        return this.m_arrayData;
    }

    private Object[] createArray(long l, int n) throws SQLException {
        if (--l < 0L || l >= (long)this.m_arrayData.length) {
            String[] stringArray = new String[]{"index"};
            throw this.m_baseStatement.exceptions.getException(6125, stringArray);
        }
        if (n <= 0) {
            String[] stringArray = new String[]{"count"};
            throw this.m_baseStatement.exceptions.getException(6125, stringArray);
        }
        if (l == 0L && n == this.m_arrayData.length) {
            return this.m_arrayData;
        }
        long l2 = (long)n > (long)this.m_arrayData.length - l ? (long)this.m_arrayData.length - l : (long)n;
        Object[] objectArray = BaseData.createObjectArray(this.m_elementType, (int)l2);
        int n2 = 0;
        while ((long)n2 < l2) {
            objectArray[n2] = this.m_arrayData[(int)l + n2];
            ++n2;
        }
        return objectArray;
    }

    public Object getArray(long l, int n) throws SQLException {
        return this.createArray(l, n);
    }

    public Object getArray(long l, int n, Map map) throws SQLException {
        return this.createArray(l, n);
    }

    public Object getArray(Map map) throws SQLException {
        return this.getArray();
    }

    public int getBaseType() throws SQLException {
        return this.m_baseSQLType;
    }

    public String getBaseTypeName() throws SQLException {
        if (this.m_colDescForArray == null) {
            return "";
        }
        return this.m_colDescForArray.typeName;
    }

    private ResultSet createResultSet(Object[] objectArray) throws SQLException {
        BaseArrayImplResultSet baseArrayImplResultSet = new BaseArrayImplResultSet(objectArray, this.m_elementType);
        BaseColumns baseColumns = new BaseColumns();
        if (this.m_colDescForArray == null) {
            this.m_colDescForArray = new BaseColumn(BaseImplConnection.mapJavaTypeToSQLType(this.m_elementType));
        }
        baseColumns.add(this.m_colDescForArray);
        return new BaseResultSet(this.m_baseStatement, baseColumns, baseArrayImplResultSet);
    }

    public ResultSet getResultSet() throws SQLException {
        return this.createResultSet(this.m_arrayData);
    }

    public ResultSet getResultSet(long l, int n) throws SQLException {
        return this.createResultSet(this.createArray(l, n));
    }

    public ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        return this.createResultSet(this.createArray(l, n));
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        return this.createResultSet(this.m_arrayData);
    }
}

