/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver.tds;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseColumns;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataReader;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataWriter;
import com.metamatrix.jdbc.sqlserver.SQLServerColumn;
import com.metamatrix.jdbc.sqlserver.SQLServerImplConnection;
import com.metamatrix.jdbc.sqlserver.SQLServerImplStatement;
import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSConstants;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCParameter;
import com.metamatrix.util.UtilDataConversions;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilSmallDecimal;
import com.metamatrix.util.UtilTransliterator;
import com.metamatrix.util.UtilVectorUnsynced;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Hashtable;

public abstract class TDSRequest {
    private static String footprint = "$Revision:   3.66.1.7  $";
    protected int processMode;
    int savedProcessMode = 0;
    public static final short PROCESS_UNDEFINED = 0;
    public static final short PROCESS_UNTIL_RESULT_FOUND = 1;
    public static final short PROCESS_REST_OF_RESULTSET = 2;
    public static final short PROCESS_ENTIRE_REPLY = 3;
    public static final short PROCESS_PREPARE_REPLY = 4;
    public static final short PROCESS_ALL_RESULTS = 5;
    public TDSConnection conn;
    public boolean prepareSubmitted;
    public TDSRPCParameter prepareHandleParam;
    protected int messageType;
    protected int resultType;
    protected int numRowsFetchedFromResultSet;
    protected int numRowsAffected;
    public int returnStatus;
    public boolean returnStatusIsValid;
    protected BaseColumns currentBaseColumns;
    protected Hashtable baseColumnSets;
    public SQLServerColumn[] currentNativeColumns;
    protected Hashtable nativeColumnsSets;
    private int altRowState;
    private static int ALTROW_NONE = 0;
    private static int ALTROW_END_PREVIOUS = 1;
    private static int ALTROW_START_RESULT = 2;
    private static int ALTROW_END_RESULT = 3;
    public int lastColumnProcessedForCurrentRow;
    protected SQLException exception;
    public SQLServerByteOrderedDataReader reader;
    public SQLServerByteOrderedDataWriter writer;
    private boolean lastRowReturned;
    protected UtilVectorUnsynced tableNames;
    private int longColumnsCount = -1;
    public boolean[] currentIsLongOfColumns;
    private int[] currentScaleOfColumns;
    private int[] currentPrecisionOfColumns;
    private static final int MAX_DECIMAL_CHARS = 42;
    private char[] convertedDecimalValue;
    private int[] encodedNativeDecimalValue;
    private byte[] tempData1;
    private byte[] tempData2;
    private byte[] tempData3;
    private byte[] tempData4;
    private byte[] tempData5;
    private byte[] tempData6;
    private byte[] tempData7;
    private byte[] tempData8;
    private byte[] tempData9;
    private byte[] tempData10;
    private byte[] tempData11;
    private byte[] tempData12;
    private byte[] tempData13;
    private byte[] tempData14;
    private byte[] tempData15;
    private byte[] tempData16;
    public byte currentToken = 0;

    public TDSRequest(TDSConnection tDSConnection, SQLServerByteOrderedDataReader sQLServerByteOrderedDataReader, SQLServerByteOrderedDataWriter sQLServerByteOrderedDataWriter, int n) {
        this.conn = tDSConnection;
        this.reader = sQLServerByteOrderedDataReader;
        this.writer = sQLServerByteOrderedDataWriter;
        this.messageType = n;
        this.resultType = 0;
        this.numRowsAffected = -1;
        this.numRowsFetchedFromResultSet = 0;
        this.baseColumnSets = new Hashtable();
        this.nativeColumnsSets = new Hashtable();
        this.altRowState = ALTROW_NONE;
        this.exception = null;
        this.lastColumnProcessedForCurrentRow = 0;
        this.lastRowReturned = false;
        this.tableNames = new UtilVectorUnsynced();
    }

    protected boolean internalOutOfOrderAccessPerformed() {
        return false;
    }

    public boolean hasLongColumns() {
        if (this.longColumnsCount == -1) {
            this.longColumnsCount = 0;
            for (int i = 0; i < this.currentNativeColumns.length; ++i) {
                SQLServerColumn sQLServerColumn = this.currentNativeColumns[i];
                if (!sQLServerColumn.isLongColumn()) continue;
                ++this.longColumnsCount;
            }
        }
        return this.longColumnsCount > 0;
    }

    public boolean getResultOfSingleExecuteInBatch(int[] nArray, BaseWarnings baseWarnings) throws SQLException {
        nArray[0] = -1;
        this.exception = null;
        this.numRowsAffected = -1;
        this.processMode = 1;
        boolean bl = false;
        while (!bl) {
            byte by = 0;
            try {
                by = this.readToken();
            }
            catch (SQLException sQLException) {
                break;
            }
            if (by == 0) break;
            if (by == -1 || by == -2) {
                try {
                    int n = this.reader.readUnsignedInt16();
                    this.reader.pushUnsignedInt16(n);
                    if ((n & 0xFFFFFF80) != 0) {
                        this.processReplyToken(by, baseWarnings);
                        break;
                    }
                    if (n == 0) {
                        this.processReplyToken(by, baseWarnings);
                        this.reader.empty();
                        break;
                    }
                }
                catch (UtilException utilException) {
                    throw this.conn.exceptions.getException((Exception)((Object)utilException));
                }
            }
            this.processReplyToken(by, baseWarnings);
            if (by == 121) {
                if (nArray[0] != -1) continue;
                nArray[0] = 0;
                continue;
            }
            if (by == -127) {
                this.completeRowProcessing(baseWarnings);
                this.exception = this.conn.exceptions.getException(6053);
                continue;
            }
            if (nArray[0] != -1 || this.numRowsAffected == -1) continue;
            nArray[0] = this.numRowsAffected;
        }
        if (this.exception != null) {
            nArray[0] = -1;
            throw this.exception;
        }
        return nArray[0] == -1;
    }

    public final BaseColumns getColumnDescriptions() {
        return this.currentBaseColumns;
    }

    public int getResultType() {
        return this.resultType;
    }

    public final int getNumRowsAffected() {
        return this.numRowsAffected;
    }

    public final void discardReplyBytes() {
        try {
            this.reader.empty();
            if (this.conn.currentlyRegisteredReader == this.reader) {
                this.conn.currentlyRegisteredReader = null;
            }
            if (this.conn.currentlyRegisteredRequest == this) {
                this.conn.currentlyRegisteredRequest = null;
            }
        }
        catch (UtilException utilException) {
            // empty catch block
        }
    }

    public final SQLServerColumn getColumn(int n) {
        return this.currentNativeColumns[n - 1];
    }

    final String getNameOfUnhandledDataType(byte by) {
        switch (by) {
            case 45: {
                return new String("BINARY");
            }
            case 47: {
                return new String("CHAR");
            }
            case 60: {
                return new String("MONEY");
            }
            case 58: {
                return new String("SMALLDATETIME");
            }
            case 59: {
                return new String("SMALLFLOAT");
            }
            case 122: {
                return new String("SMALLMONEY");
            }
            case 98: {
                return new String("SQLVARIANT");
            }
            case 37: {
                return new String("VARBINARY");
            }
            case 39: {
                return new String("VARCHAR");
            }
            case 31: {
                return new String("VOID");
            }
        }
        return new String("Unknown: 0x" + UtilDataConversions.byteToHex((byte)by));
    }

    final String getNameForTokenType(byte by) {
        switch (by) {
            case -120: {
                return new String("ALTMETADATA");
            }
            case -45: {
                return new String("ALTROW");
            }
            case -91: {
                return new String("COLINFO");
            }
            case -127: {
                return new String("COLMETADATA");
            }
            case 96: {
                return new String("DEBUG_CMD");
            }
            case -3: {
                return new String("DONE");
            }
            case -1: {
                return new String("DONEINPROC");
            }
            case -2: {
                return new String("DONEPROC");
            }
            case -29: {
                return new String("ENVCHANGE");
            }
            case -86: {
                return new String("ERROR");
            }
            case -85: {
                return new String("INFO");
            }
            case -83: {
                return new String("LOGINACK");
            }
            case 120: {
                return new String("OFFSET");
            }
            case -87: {
                return new String("ORDER");
            }
            case 121: {
                return new String("RETURNSTATUS");
            }
            case -84: {
                return new String("RETURNVALUE");
            }
            case -47: {
                return new String("ROW");
            }
            case -19: {
                return new String("SSPI");
            }
            case -92: {
                return new String("TABNAME");
            }
        }
        return new String("Unknown token: 0x" + UtilDataConversions.byteToHex((byte)by));
    }

    public void clearCancelReply() throws SQLException {
        try {
            block5: {
                this.reader.prepareToReadCancelReply();
                while (true) {
                    byte by;
                    if ((by = this.reader.readToken()) == 0) {
                        this.reader.empty();
                        if (this.conn.getCancelPendingStatement() != null) {
                            this.reader.receive();
                            continue;
                        }
                        break block5;
                    }
                    this.processMode = 3;
                    this.processReplyToken(by, null);
                    if (this.conn.getCancelPendingStatement() == null) break;
                }
                this.reader.empty();
            }
            this.resultType = 1;
            this.conn.currentlyRegisteredReader = null;
            this.conn.currentlyRegisteredRequest = null;
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
    }

    protected void clearReplyChannel() throws SQLException {
        try {
            if (this.conn.getCancelPendingStatement() != null) {
                this.conn.getCancelPendingStatement().processAnyCancelReply();
            }
            if (this.conn.currentlyRegisteredReader != null && this.conn.currentlyRegisteredReader != this.reader) {
                if (this.conn.getTDSVersion() > 2 && (this.conn.isTransactionImplicitOn && this.conn.transactionDescriptor == 0L || !this.conn.connection.exposedAutoCommitMode && this.conn.sqlHasTransactionKeyword)) {
                    this.conn.currentlyRegisteredRequest.readTransactionDescriptor(this.conn.warnings);
                } else {
                    boolean bl = false;
                    try {
                        bl = this.conn.currentlyRegisteredReader.bufferAllData();
                    }
                    catch (Exception exception) {
                        throw this.conn.exceptions.getException(this.conn.exceptions.getException(exception), 1, 6091);
                    }
                    if (!bl) {
                        throw this.conn.exceptions.getException(6091);
                    }
                }
            }
            try {
                if (this.conn.getTDSVersion() > 2 && this.conn.connection.implConnection.fullyProcessReply && (this.conn.currentlyRegisteredReader == null || this.conn.currentlyRegisteredReader == this.reader)) {
                    if (this.currentToken == -47 && this.currentNativeColumns != null && this.lastColumnProcessedForCurrentRow + 1 <= this.currentNativeColumns.length) {
                        this.getColumnDataForRow(0, 0, -1);
                    }
                    this.processReply(3, this.conn.warnings);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.reader.empty();
            this.conn.currentlyRegisteredReader = this.reader;
            this.conn.currentlyRegisteredRequest = this;
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
    }

    final void processErrorToken() throws SQLException {
        try {
            int n = this.reader.readUnsignedInt16();
            int n2 = this.reader.readInt32();
            short s = this.reader.readUnsignedInt8();
            short s2 = this.reader.readUnsignedInt8();
            String string = this.reader.readString(this.reader.readUnsignedInt16() * 2);
            String string2 = this.reader.readString(this.reader.readUnsignedInt8() * 2);
            String string3 = this.reader.readString(this.reader.readUnsignedInt8() * 2);
            if (this.conn.getTDSVersion() > 2) {
                int n3 = this.reader.readInt32();
            } else {
                int n4 = this.reader.readUnsignedInt16();
            }
            if (n2 == 8525) {
                this.conn.connection.distributedTransactionCompleted = true;
            }
            String[] stringArray = new String[]{string};
            this.exception = this.conn.exceptions.getException(this.exception, 1, 6001, stringArray, SQLServerImplConnection.mapNativeErrorToSQLState(n2), n2);
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
    }

    final boolean processInfoToken(BaseWarnings baseWarnings) throws SQLException {
        boolean bl = true;
        try {
            int n = this.reader.readUnsignedInt16();
            if (this.processMode == 2 && this.reader.lookAheadForBytes(n + 4, TDSConstants.infoMessageCommands)) {
                this.reader.pushUnsignedInt16(n);
                this.reader.pushByte((byte)-85);
                return false;
            }
            if (baseWarnings == null) {
                this.reader.readAndDiscardBytes(n);
            } else {
                int n2 = this.reader.readInt32();
                byte by = this.reader.readInt8();
                byte by2 = this.reader.readInt8();
                String string = this.reader.readString(this.reader.readUnsignedInt16() * 2);
                this.reader.readString(this.reader.readInt8() * 2);
                this.reader.readString(this.reader.readInt8() * 2);
                if (this.conn.getTDSVersion() > 2) {
                    this.reader.readUnsignedInt32();
                } else {
                    this.reader.readUnsignedInt16();
                }
                String[] stringArray = new String[]{string};
                if (this.exception != null || n2 == 4506) {
                    this.exception = this.conn.exceptions.getException(this.exception, 1, 6001, stringArray, SQLServerImplConnection.mapNativeErrorToSQLState(n2), n2);
                } else {
                    baseWarnings.add(6001, stringArray, SQLServerImplConnection.mapNativeErrorToSQLState(n2), n2);
                }
                bl = this.processInfoTokenAction(n2, by, by2);
            }
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
        return bl;
    }

    protected boolean processInfoTokenAction(int n, byte by, byte by2) {
        return true;
    }

    final void processEnvChange(BaseWarnings baseWarnings) throws UtilException {
        String string;
        int n = this.reader.readUnsignedInt16() - 1;
        byte by = this.reader.readInt8();
        if (by == 8 || by == 11) {
            byte by2 = this.reader.readInt8();
            this.conn.transactionDescriptor = this.reader.readInt64();
            this.writer.setTransactionDescriptor(this.conn.transactionDescriptor);
            this.reader.readAndDiscardBytes(1);
            return;
        }
        if (by == 9 || by == 10 || by == 12 || by == 17) {
            byte by3 = this.reader.readInt8();
            this.conn.transactionDescriptor = 0L;
            this.writer.setTransactionDescriptor(0L);
            byte by4 = this.reader.readInt8();
            long l = this.reader.readInt64();
            return;
        }
        if (by == 18) {
            this.reader.readInt8();
            this.reader.readInt8();
            return;
        }
        if (by == 16 || by == 19) {
            byte by5 = this.reader.readInt8();
            this.reader.readString(by5);
            this.reader.readInt8();
            return;
        }
        if (by == 13) {
            byte by6 = this.reader.readInt8();
            this.reader.readString(by6 * 2);
            this.reader.readInt8();
            return;
        }
        if (by == 15) {
            this.reader.readAndDiscardBytes(n - 1);
            return;
        }
        byte by7 = this.reader.readInt8();
        if (by == 7) {
            byte[] byArray = new byte[by7];
            this.reader.getArrayOfBytes(byArray, 0, by7);
            this.conn.setSQLCollation(byArray);
            try {
                this.conn.setNonUnicodeTransliterator(byArray);
            }
            catch (SQLException sQLException) {
                this.exception = sQLException;
            }
            string = "";
        } else if (by == 3) {
            string = this.reader.readString(by7 * 2);
            if (string.equalsIgnoreCase("iso_1")) {
                string = "Cp1252";
            }
            try {
                this.conn.setNonUnicodeTransliterator(string);
            }
            catch (SQLException sQLException) {
                this.exception = sQLException;
            }
        } else {
            string = this.reader.readString(by7 * 2);
        }
        by7 = this.reader.readInt8();
        if (by == 7) {
            this.reader.readAndDiscardBytes(by7);
        } else {
            this.reader.readAndDiscardBytes(by7 * 2);
        }
        if (by == 1 || by == 2) {
            if (by == 1) {
                this.conn.setCatalog(string);
            }
        } else if (by == 4) {
            this.conn.setPacketSize(Integer.valueOf(string));
        }
    }

    final boolean processDoneToken(byte by) throws SQLException {
        boolean bl = false;
        try {
            int n = this.reader.readUnsignedInt16();
            int n2 = this.reader.readUnsignedInt16();
            if ((n & 0x20) != 0) {
                this.conn.setCancelPendingStatement(null);
                if (this.conn.getTDSVersion() > 2) {
                    this.reader.readInt64();
                } else {
                    this.reader.readInt32();
                }
                bl = true;
            } else if ((n & 2) != 0 && this.exception == null) {
                if (this.conn.getCancelPendingStatement() == null) {
                    String[] stringArray = new String[]{Integer.toString(n2)};
                    this.exception = this.conn.exceptions.getException(this.exception, 1, 7007, stringArray, "08006");
                }
                if (this.conn.getTDSVersion() > 2) {
                    this.reader.readInt64();
                } else {
                    this.reader.readInt32();
                }
                bl = true;
            } else if ((n & 0x10) != 0 && n2 != 193) {
                if (this.processMode == 2) {
                    this.reader.pushUnsignedInt16(n2);
                    this.reader.pushUnsignedInt16(n);
                    this.reader.pushByte(by);
                    bl = false;
                } else if (this.processMode == 1) {
                    this.resultType = 3;
                    this.numRowsAffected = this.conn.getTDSVersion() > 2 ? (int)this.reader.readInt64() : this.reader.readInt32();
                    bl = false;
                } else if (this.processMode == 5) {
                    this.resultType = 3;
                    this.numRowsAffected = this.conn.getTDSVersion() > 2 ? (int)this.reader.readInt64() : this.reader.readInt32();
                    bl = true;
                } else {
                    if (this.conn.getTDSVersion() > 2) {
                        this.reader.readInt64();
                    } else {
                        this.reader.readInt32();
                    }
                    bl = true;
                }
            } else if (n2 == 198 || n2 == 216 || n2 == 199 || n2 == 222 || n2 == 223 || n2 == 253) {
                if (this.processMode == 2) {
                    this.reader.pushUnsignedInt16(n2);
                    this.reader.pushUnsignedInt16(n);
                    this.reader.pushByte(by);
                    bl = false;
                } else if (this.processMode == 1) {
                    this.resultType = 3;
                    this.numRowsAffected = this.conn.getTDSVersion() > 2 ? (int)this.reader.readInt64() : this.reader.readInt32();
                    bl = false;
                } else if (this.processMode == 5) {
                    this.resultType = 3;
                    this.numRowsAffected = this.conn.getTDSVersion() > 2 ? (int)this.reader.readInt64() : this.reader.readInt32();
                    bl = true;
                } else {
                    if (this.conn.getTDSVersion() > 2) {
                        this.reader.readInt64();
                    } else {
                        this.reader.readInt32();
                    }
                    bl = true;
                }
            } else {
                if (this.conn.getTDSVersion() > 2) {
                    this.reader.readInt64();
                } else {
                    this.reader.readInt32();
                }
                bl = true;
            }
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
        return bl;
    }

    final void getReturnedValue(int n, BaseData baseData, byte by, UtilTransliterator utilTransliterator, int n2, int n3, boolean bl, int n4) throws SQLException {
        try {
            int n5 = n4;
            block1 : switch (by) {
                case -89: 
                case -81: {
                    if (!bl) {
                        n5 = this.reader.readUnsignedInt16();
                    }
                    if (bl || (short)n5 != -1) {
                        this.reader.transliterator = utilTransliterator;
                        String string = this.reader.readString(n5);
                        this.reader.transliterator = this.conn.unicodeTransliterator;
                        if (by == -81 && n2 > n5) {
                            int n6;
                            StringBuffer stringBuffer = new StringBuffer(n6);
                            for (n6 = n2 - n5; n6 > 0; --n6) {
                                stringBuffer.append(' ');
                            }
                            string = string.concat(stringBuffer.toString());
                        }
                        baseData.setString(string);
                        break;
                    }
                    baseData.setNull(10);
                    break;
                }
                case -25: 
                case -17: {
                    if (!bl) {
                        n5 = this.reader.readUnsignedInt16();
                    }
                    if (bl || (short)n5 != -1) {
                        baseData.setString(this.reader.readString(n5));
                        break;
                    }
                    baseData.setNull(10);
                    break;
                }
                case 38: {
                    n5 = this.reader.readUnsignedInt8();
                    switch (n5) {
                        case 1: {
                            baseData.setInteger((int)this.reader.readUnsignedInt8());
                            break block1;
                        }
                        case 2: {
                            baseData.setInteger((int)this.reader.readInt16());
                            break block1;
                        }
                        case 4: {
                            baseData.setInteger(this.reader.readInt32());
                            break block1;
                        }
                        case 8: {
                            baseData.setLong(this.reader.readInt64());
                            break block1;
                        }
                    }
                    baseData.setNull(4);
                    break;
                }
                case 48: {
                    baseData.setInteger((int)this.reader.readUnsignedInt8());
                    break;
                }
                case 52: {
                    baseData.setInteger((int)this.reader.readInt16());
                    break;
                }
                case 56: {
                    baseData.setInteger(this.reader.readInt32());
                    break;
                }
                case 127: {
                    baseData.setLong(this.reader.readInt64());
                    break;
                }
                case 106: 
                case 108: {
                    if (!bl) {
                        n5 = this.reader.readUnsignedInt8();
                    }
                    if (bl || n5 != 0) {
                        short s = this.reader.readUnsignedInt8();
                        byte[] byArray = this.getByteArray(--n5);
                        this.reader.getArrayOfBytes(byArray, 0, n5);
                        if (n == 10) {
                            baseData.setString(this.convertNativeDecimalToString(byArray, n5, s, n3));
                            break;
                        }
                        if (n2 > 18) {
                            int n7 = n5 / 2 - 1;
                            int n8 = n5 - 1;
                            for (int i = n7; i >= 0; --i) {
                                byte by2 = byArray[n8 - i];
                                byArray[n8 - i] = byArray[i];
                                byArray[i] = by2;
                            }
                            BigInteger bigInteger = new BigInteger(s == 0 ? -1 : 1, byArray);
                            baseData.setBigDecimal(new BigDecimal(bigInteger, n3));
                            break;
                        }
                        baseData.setSmallDecimal(new UtilSmallDecimal(byArray, s == 0 ? -1 : 1, n3));
                        break;
                    }
                    baseData.setNull(8);
                    break;
                }
                case 110: {
                    n5 = this.reader.readUnsignedInt8();
                    if (n5 != 0) {
                        if (n5 == 8) {
                            baseData.setSmallDecimal(new UtilSmallDecimal(this.reader.readInt32(), this.reader.readInt32(), n3));
                            break;
                        }
                        byte[] byArray = this.getByteArray(n5);
                        this.reader.getArrayOfBytes(byArray, 0, n5);
                        baseData.setSmallDecimal(new UtilSmallDecimal(byArray, n3));
                        break;
                    }
                    baseData.setNull(21);
                    break;
                }
                case 60: {
                    baseData.setSmallDecimal(new UtilSmallDecimal(this.reader.readInt32(), this.reader.readInt32(), n3));
                    break;
                }
                case 122: {
                    byte[] byArray = this.getByteArray(4);
                    this.reader.getArrayOfBytes(byArray, 0, 4);
                    baseData.setSmallDecimal(new UtilSmallDecimal(byArray, n3));
                    break;
                }
                case 109: {
                    n5 = this.reader.readUnsignedInt8();
                    if (n5 == 4) {
                        baseData.setFloat(this.reader.readIEEE32BitFloat());
                        break;
                    }
                    if (n5 == 8) {
                        baseData.setDouble(this.reader.readIEEE64BitDouble());
                        break;
                    }
                    baseData.setNull(6);
                    break;
                }
                case 62: {
                    baseData.setDouble(this.reader.readIEEE64BitDouble());
                    break;
                }
                case 59: {
                    baseData.setFloat(this.reader.readIEEE32BitFloat());
                    break;
                }
                case 50: {
                    baseData.setByte(this.reader.readInt8());
                    break;
                }
                case 104: {
                    n5 = this.reader.readInt8();
                    if (n5 != 0) {
                        baseData.setByte(this.reader.readInt8());
                        break;
                    }
                    baseData.setNull(1);
                    break;
                }
                case -91: 
                case -83: {
                    if (!bl) {
                        n5 = this.reader.readUnsignedInt16();
                    }
                    if (bl || (short)n5 != -1) {
                        byte[] byArray;
                        if (by == -83) {
                            byArray = new byte[n2];
                            this.reader.getArrayOfBytes(byArray, 0, n5);
                            for (long i = (long)(byArray.length - n5); i > 0L; --i) {
                                byArray[(int)((long)n5 + i) - 1] = 0;
                            }
                        } else {
                            byArray = new byte[n5];
                            this.reader.getArrayOfBytes(byArray, 0, n5);
                        }
                        baseData.setBytes(byArray);
                        break;
                    }
                    baseData.setNull(2);
                    break;
                }
                case 111: {
                    n5 = this.reader.readUnsignedInt8();
                    if (n5 != 0) {
                        byte[] byArray = new byte[n5];
                        this.reader.getArrayOfBytes(byArray, 0, n5);
                        if (n5 == 4) {
                            baseData.setNativeBytes(byArray, 103);
                            break;
                        }
                        baseData.setNativeBytes(byArray, 102);
                        break;
                    }
                    if (n5 == 4) {
                        baseData.setNull(103);
                        break;
                    }
                    baseData.setNull(102);
                    break;
                }
                case 61: {
                    byte[] byArray = new byte[8];
                    this.reader.getArrayOfBytes(byArray, 0, 8);
                    baseData.setNativeBytes(byArray, 102);
                    break;
                }
                case 58: {
                    byte[] byArray = new byte[4];
                    this.reader.getArrayOfBytes(byArray, 0, 4);
                    baseData.setNativeBytes(byArray, 103);
                    break;
                }
                case 36: {
                    if (!bl) {
                        n5 = this.reader.readUnsignedInt8();
                    }
                    if (n5 != 0) {
                        byte[] byArray = new byte[n5];
                        this.reader.getArrayOfBytes(byArray, 0, n5);
                        baseData.setNativeBytes(byArray, 101);
                        break;
                    }
                    baseData.setNull(101);
                    break;
                }
                case 98: {
                    n5 = this.reader.readInt32();
                    if (n5 == 0) {
                        baseData.setNull(10);
                        break;
                    }
                    byte[] byArray = this.getByteArray(5);
                    UtilTransliterator utilTransliterator2 = null;
                    int n9 = 0;
                    int n10 = 0;
                    short s = 0;
                    byte by3 = this.reader.readInt8();
                    short s2 = this.reader.readUnsignedInt8();
                    switch (by3) {
                        case -91: 
                        case -83: 
                        case 37: 
                        case 45: {
                            n10 = n9 = this.reader.readUnsignedInt16();
                            break;
                        }
                        case -89: 
                        case -81: 
                        case -25: 
                        case -17: 
                        case 39: 
                        case 47: {
                            this.reader.getArrayOfBytes(byArray, 0, 5);
                            utilTransliterator2 = this.conn.getTransliteratorForCodePage(this.conn.mapCollationToCodePage(byArray));
                            n9 = this.reader.readUnsignedInt16();
                            break;
                        }
                        case 106: 
                        case 108: {
                            n10 = this.reader.readUnsignedInt8();
                            s = this.reader.readUnsignedInt8();
                            break;
                        }
                        case 36: 
                        case 48: 
                        case 50: 
                        case 52: 
                        case 56: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 122: 
                        case 127: {
                            UtilDebug.assert((String)"Unexpected sql_variant property", (s2 == 0 ? 1 : 0) != 0);
                            break;
                        }
                        case -15: 
                        case 34: 
                        case 35: 
                        case 38: 
                        case 55: 
                        case 63: 
                        case 98: 
                        case 99: 
                        case 104: 
                        case 109: 
                        case 110: 
                        case 111: {
                            UtilDebug.assert((String)"Unexpected sql_variant type.", (boolean)false);
                        }
                    }
                    this.getReturnedValue(n, baseData, by3, utilTransliterator2, n10, s, true, n5 - (2 + s2));
                    break;
                }
                default: {
                    String[] stringArray = new String[]{this.getNameOfUnhandledDataType(by)};
                    throw this.conn.exceptions.getException(7005, stringArray, "08006");
                }
            }
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
    }

    final void processOrderToken() throws UtilException, SQLException {
        int n = this.reader.readUnsignedInt16();
        this.reader.readAndDiscardBytes(n);
    }

    final void processColMetaData(byte by) throws UtilException, SQLException {
        int n;
        int n2;
        Integer n3;
        boolean bl;
        this.lastRowReturned = false;
        this.resultType = 2;
        this.numRowsFetchedFromResultSet = 0;
        int n4 = this.reader.readUnsignedInt16();
        if (n4 == 65535) {
            return;
        }
        boolean bl2 = bl = by == -120;
        if (bl) {
            n3 = new Integer(this.reader.readUnsignedInt16());
            n2 = this.reader.readUnsignedInt8();
            for (n = 0; n < n2; ++n) {
                this.reader.readUnsignedInt16();
            }
        } else {
            n3 = new Integer(0);
        }
        this.currentBaseColumns = new BaseColumns();
        this.baseColumnSets.put(n3, this.currentBaseColumns);
        this.currentNativeColumns = new SQLServerColumn[n4];
        this.nativeColumnsSets.put(n3, this.currentNativeColumns);
        for (n2 = 0; n2 < n4; ++n2) {
            byte by2;
            String string;
            Object[] objectArray;
            byte by3;
            n = 0;
            short s = 0;
            int n5 = 0;
            short s2 = 0;
            int n6 = 0;
            BaseColumn baseColumn = new BaseColumn();
            SQLServerColumn sQLServerColumn = new SQLServerColumn(this.conn.connection);
            if (bl) {
                s2 = this.reader.readUnsignedInt8();
                n6 = this.reader.readUnsignedInt16();
            }
            int n7 = this.conn.getTDSVersion() > 2 ? this.reader.readInt32() : this.reader.readUnsignedInt16();
            int n8 = this.reader.readUnsignedInt16();
            sQLServerColumn.TDSType = by3 = this.reader.readInt8();
            switch (by3) {
                case 36: 
                case 38: 
                case 104: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 111: {
                    n5 = this.reader.readUnsignedInt8();
                    break;
                }
                case -91: 
                case -89: 
                case -83: 
                case -81: 
                case -25: 
                case -17: {
                    n5 = this.reader.readUnsignedInt16();
                    break;
                }
                case 34: 
                case 35: 
                case 99: {
                    n5 = (int)this.reader.readUnsignedInt32();
                    break;
                }
                case 98: {
                    n5 = (int)this.reader.readUnsignedInt32() - 9;
                    break;
                }
            }
            if (by3 == 106 || by3 == 108) {
                n = this.reader.readUnsignedInt8();
                s = this.reader.readUnsignedInt8();
            }
            if (this.conn.getTDSVersion() >= 2) {
                objectArray = this.getByteArray(5);
                switch (by3) {
                    case -89: 
                    case -81: 
                    case 35: {
                        this.reader.getArrayOfBytes((byte[])objectArray, 0, 5);
                        baseColumn.transliterator = sQLServerColumn.nonUnicodeCharTransliterator = this.conn.getTransliteratorForCodePage(this.conn.mapCollationToCodePage((byte[])objectArray));
                        break;
                    }
                    case -25: 
                    case -17: 
                    case 99: {
                        this.reader.getArrayOfBytes((byte[])objectArray, 0, 5);
                        baseColumn.transliterator = this.conn.unicodeTransliterator;
                        break;
                    }
                }
            } else if (by3 == -81 || by3 == -89 || by3 == 35) {
                sQLServerColumn.nonUnicodeCharTransliterator = this.conn.nonUnicodeTransliterator;
                baseColumn.transliterator = this.conn.nonUnicodeTransliterator;
            }
            if (by3 == 35 || by3 == 99 || by3 == 34) {
                if (this.conn.getTDSVersion() > 2) {
                    int n9 = this.reader.readInt8();
                    for (int i = 0; i < n9; ++i) {
                        string = this.reader.readString(this.reader.readUnsignedInt16() * 2);
                        baseColumn.tableName = baseColumn.tableName + string;
                        if (i == n9 - 1) continue;
                        baseColumn.tableName = baseColumn.tableName + ".";
                    }
                } else {
                    baseColumn.tableName = this.reader.readString(this.reader.readUnsignedInt16() * 2);
                }
            }
            if (by3 == -15 && (by2 = this.reader.readInt8()) == 1) {
                String string2 = "";
                string = "";
                String string3 = "";
                string2 = this.reader.readString(this.reader.readInt8() * 2);
                string = this.reader.readString(this.reader.readInt8() * 2);
                string3 = this.reader.readString(this.reader.readUnsignedInt16() * 2);
            }
            baseColumn.name = this.reader.readString(this.reader.readUnsignedInt8() * 2);
            if (baseColumn.name.length() == 0 && bl) {
                baseColumn.name = this.getComputeColumnName(s2, n6);
            }
            baseColumn.label = baseColumn.name;
            switch (sQLServerColumn.TDSType) {
                case 50: 
                case 104: {
                    baseColumn.isSearchable = 4;
                    baseColumn.isSigned = false;
                    baseColumn.setType(-7);
                    baseColumn.typeName = new String("bit");
                    break;
                }
                case -25: {
                    if (n5 == 65535) {
                        baseColumn.displaySize = 0x3FFFFFFF;
                        baseColumn.precision = 0x3FFFFFFF;
                        baseColumn.isSigned = false;
                        baseColumn.isSearchable = 4;
                        baseColumn.setType(-1);
                        baseColumn.typeName = new String("nvarchar(max)");
                        sQLServerColumn.isPartLenDataType = true;
                        sQLServerColumn.TDSType = (byte)99;
                        break;
                    }
                    baseColumn.displaySize = n5 / 2;
                    baseColumn.precision = n5 / 2;
                    baseColumn.isSearchable = 4;
                    baseColumn.isSigned = false;
                    baseColumn.setType(12);
                    baseColumn.typeName = new String("nvarchar");
                    break;
                }
                case -89: {
                    if (n5 == 65535) {
                        baseColumn.displaySize = Integer.MAX_VALUE;
                        baseColumn.precision = Integer.MAX_VALUE;
                        baseColumn.isSigned = false;
                        baseColumn.isSearchable = 4;
                        baseColumn.setType(-1);
                        baseColumn.baseDataType = 18;
                        baseColumn.typeName = new String("varchar(max)");
                        sQLServerColumn.isPartLenDataType = true;
                        sQLServerColumn.TDSType = (byte)35;
                        break;
                    }
                    baseColumn.displaySize = n5;
                    baseColumn.precision = n5;
                    baseColumn.isSearchable = 4;
                    baseColumn.isSigned = false;
                    baseColumn.setType(12);
                    baseColumn.typeName = new String("varchar");
                    break;
                }
                case -17: {
                    baseColumn.displaySize = n5 / 2;
                    baseColumn.precision = n5 / 2;
                    baseColumn.isSearchable = 4;
                    baseColumn.isSigned = false;
                    baseColumn.setType(1);
                    baseColumn.typeName = new String("nchar");
                    break;
                }
                case -81: {
                    baseColumn.displaySize = n5;
                    baseColumn.precision = n5;
                    baseColumn.isSearchable = 4;
                    baseColumn.isSigned = false;
                    baseColumn.setType(1);
                    baseColumn.typeName = new String("char");
                    break;
                }
                case -83: {
                    baseColumn.precision = n5;
                    baseColumn.displaySize = baseColumn.precision * 2;
                    baseColumn.isSearchable = 4;
                    baseColumn.isSigned = false;
                    baseColumn.setType(-2);
                    if (n7 == 80) {
                        baseColumn.typeName = new String("timestamp");
                        break;
                    }
                    baseColumn.typeName = new String("binary");
                    break;
                }
                case -91: {
                    if (n5 == 65535) {
                        baseColumn.displaySize = Integer.MAX_VALUE;
                        baseColumn.precision = Integer.MAX_VALUE;
                        baseColumn.isSigned = false;
                        baseColumn.isSearchable = 4;
                        baseColumn.setType(-4);
                        baseColumn.typeName = new String("varbinary(max)");
                        sQLServerColumn.isPartLenDataType = true;
                        sQLServerColumn.TDSType = (byte)34;
                        break;
                    }
                    baseColumn.precision = n5;
                    baseColumn.displaySize = baseColumn.precision * 2;
                    baseColumn.isSearchable = 4;
                    baseColumn.isSigned = false;
                    baseColumn.setType(-3);
                    baseColumn.typeName = new String("varbinary");
                    break;
                }
                case 106: 
                case 108: {
                    baseColumn.precision = n;
                    baseColumn.displaySize = baseColumn.precision + 2;
                    baseColumn.scale = s;
                    if (baseColumn.precision == baseColumn.scale) {
                        ++baseColumn.displaySize;
                    }
                    baseColumn.isSearchable = 4;
                    if (sQLServerColumn.TDSType == 108) {
                        baseColumn.setType(2);
                        baseColumn.typeName = new String("numeric");
                        break;
                    }
                    baseColumn.setType(3);
                    baseColumn.typeName = new String("decimal");
                    break;
                }
                case 38: {
                    baseColumn.isSearchable = 4;
                    if (n5 == 1) {
                        baseColumn.typeName = new String("tinyint");
                        baseColumn.setType(-6);
                        baseColumn.displaySize = 3;
                        baseColumn.isSigned = false;
                        break;
                    }
                    if (n5 == 2) {
                        baseColumn.typeName = new String("smallint");
                        baseColumn.setType(5);
                        break;
                    }
                    if (n5 == 4) {
                        baseColumn.typeName = new String("int");
                        baseColumn.setType(4);
                        break;
                    }
                    if (n5 == 8) {
                        baseColumn.typeName = new String("bigint");
                        baseColumn.setType(-5);
                        break;
                    }
                    UtilDebug.assert((String)"Unexpected integer length returned", (boolean)false);
                    break;
                }
                case 111: {
                    baseColumn.isSearchable = 4;
                    baseColumn.isSigned = false;
                    baseColumn.setType(93);
                    if (n5 == 4) {
                        baseColumn.typeName = new String("smalldatetime");
                        baseColumn.displaySize = 16;
                        baseColumn.precision = 16;
                        baseColumn.scale = 0;
                        break;
                    }
                    if (n5 != 8) break;
                    baseColumn.typeName = new String("datetime");
                    baseColumn.displaySize = 23;
                    baseColumn.precision = 23;
                    baseColumn.scale = 3;
                    break;
                }
                case 61: {
                    baseColumn.isSearchable = 4;
                    baseColumn.isSigned = false;
                    baseColumn.typeName = new String("datetime");
                    baseColumn.setType(93);
                    baseColumn.displaySize = 23;
                    baseColumn.precision = 23;
                    baseColumn.scale = 3;
                    break;
                }
                case 58: {
                    baseColumn.isSearchable = 4;
                    baseColumn.isSigned = false;
                    baseColumn.typeName = new String("smalldatetime");
                    baseColumn.setType(93);
                    baseColumn.displaySize = 16;
                    baseColumn.precision = 16;
                    baseColumn.scale = 3;
                    break;
                }
                case 36: {
                    baseColumn.displaySize = 36;
                    baseColumn.precision = 36;
                    baseColumn.isSearchable = 4;
                    baseColumn.isSigned = false;
                    baseColumn.setType(1);
                    baseColumn.typeName = new String("uniqueidentifier");
                    break;
                }
                case 110: {
                    baseColumn.scale = 4;
                    baseColumn.isCurrency = true;
                    baseColumn.isSearchable = 4;
                    baseColumn.setType(3);
                    if (n5 == 4) {
                        baseColumn.typeName = new String("smallmoney");
                        baseColumn.displaySize = 12;
                        baseColumn.precision = 10;
                        break;
                    }
                    if (n5 != 8) break;
                    baseColumn.typeName = new String("money");
                    baseColumn.displaySize = 21;
                    baseColumn.precision = 19;
                    break;
                }
                case 60: {
                    baseColumn.scale = 4;
                    baseColumn.isCurrency = true;
                    baseColumn.isSearchable = 4;
                    baseColumn.setType(3);
                    baseColumn.typeName = new String("money");
                    baseColumn.displaySize = 21;
                    baseColumn.precision = 19;
                    break;
                }
                case 122: {
                    baseColumn.scale = 4;
                    baseColumn.isCurrency = true;
                    baseColumn.isSearchable = 4;
                    baseColumn.setType(3);
                    baseColumn.typeName = new String("smallmoney");
                    baseColumn.displaySize = 12;
                    baseColumn.precision = 10;
                    break;
                }
                case 109: {
                    baseColumn.isSearchable = 4;
                    if (n5 == 4) {
                        baseColumn.typeName = new String("real");
                        baseColumn.setType(7);
                        break;
                    }
                    if (n5 != 8) break;
                    baseColumn.typeName = new String("float");
                    baseColumn.setType(6);
                    break;
                }
                case 62: {
                    baseColumn.isSearchable = 4;
                    baseColumn.typeName = new String("float");
                    baseColumn.setType(6);
                    break;
                }
                case 59: {
                    baseColumn.isSearchable = 4;
                    baseColumn.typeName = new String("real");
                    baseColumn.setType(7);
                    break;
                }
                case 48: {
                    baseColumn.isSearchable = 4;
                    baseColumn.setType(-6);
                    baseColumn.typeName = new String("tinyint");
                    break;
                }
                case 52: {
                    baseColumn.isSearchable = 4;
                    baseColumn.setType(5);
                    baseColumn.typeName = new String("smallint");
                    break;
                }
                case 56: {
                    baseColumn.isSearchable = 4;
                    baseColumn.setType(4);
                    baseColumn.typeName = new String("int");
                    break;
                }
                case 127: {
                    baseColumn.isSearchable = 4;
                    baseColumn.setType(-5);
                    baseColumn.typeName = new String("bigint");
                    break;
                }
                case 34: {
                    baseColumn.displaySize = n5;
                    baseColumn.precision = n5;
                    baseColumn.isSigned = false;
                    baseColumn.isSearchable = 1;
                    baseColumn.setType(-4);
                    baseColumn.typeName = new String("image");
                    break;
                }
                case 35: {
                    baseColumn.displaySize = n5;
                    baseColumn.precision = n5;
                    baseColumn.isSigned = false;
                    baseColumn.isSearchable = 4;
                    baseColumn.setType(-1);
                    baseColumn.baseDataType = 18;
                    baseColumn.typeName = new String("text");
                    break;
                }
                case 99: {
                    baseColumn.displaySize = n5 / 2;
                    baseColumn.precision = n5 / 2;
                    baseColumn.isSigned = false;
                    baseColumn.isSearchable = 4;
                    baseColumn.setType(-1);
                    baseColumn.typeName = new String("ntext");
                    break;
                }
                case 98: {
                    baseColumn.displaySize = n5;
                    baseColumn.precision = 0;
                    baseColumn.isSigned = false;
                    baseColumn.isSearchable = 4;
                    baseColumn.setType(12);
                    baseColumn.typeName = new String("sql_variant");
                    break;
                }
                case -15: {
                    if (this.conn.connection.implConnection.xmlDescribeTypeIsChar) {
                        baseColumn.displaySize = 0x3FFFFFFF;
                        baseColumn.precision = 0x3FFFFFFF;
                        baseColumn.isSigned = false;
                        baseColumn.isSearchable = 4;
                        baseColumn.setType(-1);
                        baseColumn.typeName = new String("xml");
                    } else {
                        baseColumn.displaySize = Integer.MAX_VALUE;
                        baseColumn.precision = Integer.MAX_VALUE;
                        baseColumn.isSigned = false;
                        baseColumn.isSearchable = 1;
                        baseColumn.setType(-4);
                        baseColumn.typeName = new String("xml");
                    }
                    sQLServerColumn.isPartLenDataType = true;
                    break;
                }
                default: {
                    objectArray = new String[]{this.getNameOfUnhandledDataType(sQLServerColumn.TDSType)};
                    throw this.conn.exceptions.getException(7005, (String[])objectArray, "08006");
                }
            }
            baseColumn.isNullable = (n8 & 1) == 0 ? 0 : 1;
            if ((n8 & 0x10) == 0) {
                baseColumn.isAutoIncrement = false;
            } else {
                baseColumn.isAutoIncrement = true;
                baseColumn.typeName = baseColumn.typeName + " identity";
            }
            baseColumn.isCaseSensitive = (n8 & 2) != 0;
            baseColumn.isDefinitelyWritable = false;
            switch (n8 & 0xC) {
                case 0: {
                    baseColumn.isReadOnly = true;
                    baseColumn.isWritable = false;
                    break;
                }
                case 4: {
                    baseColumn.isReadOnly = false;
                    baseColumn.isWritable = true;
                    break;
                }
                case 8: {
                    baseColumn.isReadOnly = false;
                    baseColumn.isWritable = true;
                    break;
                }
                default: {
                    UtilDebug.assert((String)"Unexpected read flags", (boolean)false);
                }
            }
            this.currentBaseColumns.add(baseColumn);
            this.currentNativeColumns[n2] = sQLServerColumn;
        }
        if (bl) {
            this.switchColumnDescriptions(new Integer(0));
        } else {
            this.getExtendedMetaData();
            this.switchColumnDescriptions(n3);
        }
    }

    final void processTabName() throws UtilException, SQLException {
        int n = this.reader.readUnsignedInt16();
        while (n > 0) {
            int n2 = 0;
            if (this.conn.getTDSVersion() > 2) {
                int n3 = this.reader.readInt8();
                String string = "";
                for (int i = 0; i < n3; ++i) {
                    int n4 = this.reader.readUnsignedInt16() * 2;
                    string = string + this.reader.readString(n4);
                    n2 += 2 + n4;
                    if (i == n3 - 1) continue;
                    string = string + ".";
                }
                this.tableNames.addElement((Object)string);
                n -= n2 + 1;
                continue;
            }
            n2 = this.reader.readUnsignedInt16() * 2;
            if (n2 == 0) {
                this.tableNames.addElement((Object)"");
            } else {
                this.tableNames.addElement((Object)this.reader.readString(n2));
            }
            n -= n2 + 2;
        }
    }

    final void processColInfo() throws UtilException, SQLException {
        int n = this.reader.readUnsignedInt16();
        for (int i = 1; i <= this.currentNativeColumns.length; ++i) {
            short s;
            short s2 = this.reader.readUnsignedInt8();
            BaseColumn baseColumn = this.currentBaseColumns.get(i);
            short s3 = this.reader.readUnsignedInt8();
            if (s3 != 0 && s3 <= this.tableNames.size()) {
                baseColumn.tableName = (String)this.tableNames.elementAt(s3 - 1);
            }
            if (((s = this.reader.readUnsignedInt8()) & 0x10) != 0) {
                baseColumn.isHidden = true;
            }
            if ((s & 8) != 0) {
                baseColumn.isKey = true;
            }
            if ((s & 0x20) == 0) continue;
            String string = this.reader.readString(this.reader.readUnsignedInt8() * 2);
        }
        this.currentBaseColumns.resetCount();
    }

    final void processAltRow() throws UtilException, SQLException {
        if (this.altRowState != ALTROW_END_PREVIOUS) {
            String[] stringArray = new String[]{this.getNameForTokenType((byte)-45)};
            throw this.conn.exceptions.getException(7004, stringArray, "08006");
        }
        int n = this.reader.readUnsignedInt16();
        Integer n2 = new Integer(n);
        this.switchColumnDescriptions(n2);
        this.resultType = 2;
        this.reader.pushUnsignedInt16(n);
        this.reader.pushByte((byte)-45);
        this.altRowState = ALTROW_START_RESULT;
    }

    final void processRow() throws UtilException, SQLException {
        Integer n = new Integer(0);
        this.switchColumnDescriptions(n);
        this.lastRowReturned = false;
        this.resultType = 2;
        this.numRowsFetchedFromResultSet = 0;
        this.reader.pushByte((byte)-47);
        this.altRowState = ALTROW_NONE;
    }

    private void switchColumnDescriptions(Integer n) {
        this.currentBaseColumns = (BaseColumns)this.baseColumnSets.get(n);
        this.currentNativeColumns = (SQLServerColumn[])this.nativeColumnsSets.get(n);
        if (this.currentIsLongOfColumns == null || this.currentIsLongOfColumns.length < this.currentNativeColumns.length) {
            this.currentIsLongOfColumns = new boolean[this.currentNativeColumns.length];
        }
        if (this.currentPrecisionOfColumns == null || this.currentPrecisionOfColumns.length < this.currentNativeColumns.length) {
            this.currentPrecisionOfColumns = new int[this.currentNativeColumns.length];
        }
        if (this.currentScaleOfColumns == null || this.currentScaleOfColumns.length < this.currentNativeColumns.length) {
            this.currentScaleOfColumns = new int[this.currentNativeColumns.length];
        }
        for (int i = 0; i < this.currentNativeColumns.length; ++i) {
            this.currentIsLongOfColumns[i] = this.currentNativeColumns[i].isLongColumn();
            this.currentPrecisionOfColumns[i] = this.currentBaseColumns.get((int)(i + 1)).precision;
            this.currentScaleOfColumns[i] = this.currentBaseColumns.get((int)(i + 1)).scale;
        }
    }

    public final SQLServerColumn getColumnDataForRow(int n, int n2) throws SQLException {
        return this.getColumnDataForRow(n, n2, this.conn.maxMemoryPerLongDataCache);
    }

    /*
     * Unable to fully structure code
     */
    public final SQLServerColumn getColumnDataForRow(int var1_1, int var2_2, int var3_3) throws SQLException {
        if (var1_1 > 0 && var1_1 <= this.lastColumnProcessedForCurrentRow) {
            return this.currentNativeColumns[var1_1 - 1];
        }
        var4_4 = this.currentNativeColumns.length;
        v0 = var5_5 = var1_1 == 0 ? var4_4 : var1_1;
        if (var5_5 > var4_4) {
            var5_5 = var4_4;
        }
        var6_6 = null;
        for (var7_7 = this.lastColumnProcessedForCurrentRow + 1; var7_7 <= var5_5; ++var7_7) {
            var6_6 = this.currentNativeColumns[var7_7 - 1];
            if (this.currentIsLongOfColumns[var7_7 - 1] && !var6_6.isPartLenDataType) {
                try {
                    var8_8 = var6_6.data;
                    if (var6_6.releaseLongDataAtNextFetch) {
                        var6_6.longData = null;
                    }
                    var6_6.longDataCached = false;
                    var9_13 = this.reader.readUnsignedInt8();
                    if (var9_13 == 0) {
                        var8_8.setNull(0);
                    }
                    this.reader.readAndDiscardBytes(var9_13 + 8);
                    var10_15 = this.reader.readInt32();
                    var11_16 = var1_1 == 0 ? -1 : (var3_3 > 0 ? var3_3 : (var7_7 != var1_1 ? (this.internalOutOfOrderAccessPerformed() ? 0x200000 : -1) : (var2_2 == 19 || var2_2 == 20 ? 2048 : 0)));
                    if (var11_16 == -1) {
                        var8_8.setNull(0);
                        this.reader.readAndDiscardBytes(var10_15);
                    }
                    if (var11_16 > 0) {
                        var12_17 = null;
                        switch (var6_6.TDSType) {
                            case 99: {
                                var12_17 = this.reader.transliterator;
                                break;
                            }
                            case 35: {
                                var12_17 = var6_6.nonUnicodeCharTransliterator;
                                this.reader.transliterator = this.conn.unicodeTransliterator;
                            }
                        }
                        var6_6.cacheLongData(var11_16, this.reader, var10_15, var12_17, true, false, this.conn.exceptions, this);
                    }
                    switch (var6_6.TDSType) {
                        case 99: {
                            var8_8.setCharacterStreamReader(this.reader.getReader(var10_15, false));
                            break;
                        }
                        case 35: {
                            this.reader.transliterator = var6_6.nonUnicodeCharTransliterator;
                            if (var2_2 == 15) {
                                var8_8.setASCIIStream(this.reader.getAsciiStream(var10_15, false));
                            } else {
                                var8_8.setCharacterStreamReader(this.reader.getReader(var10_15, false));
                            }
                            this.reader.transliterator = this.conn.unicodeTransliterator;
                            break;
                        }
                        case 34: {
                            var8_8.setBinaryStream(this.reader.getInputStream(var10_15, false));
                        }
                    }
                }
                catch (UtilException var8_9) {
                    throw this.conn.exceptions.getException((Exception)var8_9);
                }
            } else if (this.currentIsLongOfColumns[var7_7 - 1] && var6_6.isPartLenDataType) {
                try {
                    var8_10 = var6_6.data;
                    if (var6_6.releaseLongDataAtNextFetch) {
                        var6_6.longData = null;
                    }
                    var6_6.longDataCached = false;
                    var9_14 = this.reader.readInt64();
                    if (var9_14 == -1L) {
                        var8_10.setNull(0);
                    }
                    var11_16 = var1_1 == 0 ? -1 : (this.conn.maxMemoryPerLongDataCache > 0 ? this.conn.maxMemoryPerLongDataCache : (var7_7 != var1_1 ? (this.internalOutOfOrderAccessPerformed() ? 0x200000 : -1) : (var2_2 == 19 || var2_2 == 20 ? 2048 : 0)));
                    if (var11_16 == -1 || var11_16 > 0 && (var6_6.TDSType == 34 || var6_6.TDSType == -15 && !this.conn.connection.implConnection.xmlDescribeTypeIsChar)) {
                        var12_18 = true;
                        var13_20 = this.reader.readInt32();
                        if (var13_20 == 0 && var11_16 > 0) {
                            var6_6.cacheLongData(var11_16, this.reader, var13_20, null, var12_18, false, this.conn.exceptions, this);
                        }
                        while (var13_20 != 0) {
                            if (var11_16 == -1) {
                                this.reader.readAndDiscardBytes(var13_20);
                            } else if (var11_16 > 0) {
                                var6_6.cacheLongData(var11_16, this.reader, var13_20, null, var12_18, false, this.conn.exceptions, this);
                            }
                            var12_18 = false;
                            var13_20 = this.reader.readInt32();
                        }
                    } else if (var11_16 > 0) {
                        var12_19 = null;
                        switch (var6_6.TDSType) {
                            case -15: 
                            case 99: {
                                var12_19 = this.reader.transliterator;
                                break;
                            }
                            case 35: {
                                var12_19 = var6_6.nonUnicodeCharTransliterator;
                                this.reader.transliterator = this.conn.unicodeTransliterator;
                            }
                        }
                        var6_6.cacheLongData(var11_16, this.reader, (int)var9_14, var12_19, true, true, this.conn.exceptions, this);
                    }
                    if (var11_16 == -1) {
                        var8_10.setNull(0);
                    }
                    if (var11_16 != 0) ** GOTO lbl120
                    switch (var6_6.TDSType) {
                        case 99: {
                            var8_10.setCharacterStreamReader(this.reader.getReader((int)var9_14, true));
                            break;
                        }
                        case 35: {
                            this.reader.transliterator = var6_6.nonUnicodeCharTransliterator;
                            if (var2_2 == 15) {
                                var8_10.setASCIIStream(this.reader.getAsciiStream((int)var9_14, true));
                            } else {
                                var8_10.setCharacterStreamReader(this.reader.getReader((int)var9_14, true));
                            }
                            this.reader.transliterator = this.conn.unicodeTransliterator;
                            break;
                        }
                        case 34: {
                            var8_10.setBinaryStream(this.reader.getInputStream((int)var9_14, true));
                            break;
                        }
                        case -15: {
                            if (this.conn.connection.implConnection.xmlDescribeTypeIsChar) {
                                var8_10.setCharacterStreamReader(this.reader.getReader((int)var9_14, true));
                                break;
                            }
                            var8_10.setBinaryStream(this.reader.getInputStream((int)var9_14, true));
                        }
                    }
                }
                catch (UtilException var8_11) {
                    throw this.conn.exceptions.getException((Exception)var8_11);
                }
            } else {
                var8_12 = var5_5 == this.lastColumnProcessedForCurrentRow + 1 ? var2_2 : 0;
                this.getReturnedValue(var8_12, var6_6.data, var6_6.TDSType, var6_6.nonUnicodeCharTransliterator, this.currentPrecisionOfColumns[var7_7 - 1], this.currentScaleOfColumns[var7_7 - 1], false, 0);
            }
lbl120:
            // 9 sources

            ++this.lastColumnProcessedForCurrentRow;
        }
        return var6_6;
    }

    public boolean getRow(BaseWarnings baseWarnings) throws SQLException {
        try {
            byte by;
            if (this.numRowsFetchedFromResultSet > 0 && this.lastColumnProcessedForCurrentRow + 1 <= this.currentNativeColumns.length) {
                this.getColumnDataForRow(0, 0);
            }
            if ((by = this.readToken()) == 0) {
                this.lastRowReturned = true;
                return false;
            }
            if (by == -47) {
                if (this.altRowState != ALTROW_NONE) {
                    this.altRowState = ALTROW_END_RESULT;
                    this.reader.pushByte(by);
                    this.lastRowReturned = true;
                    this.numRowsFetchedFromResultSet = 0;
                    return false;
                }
                this.lastColumnProcessedForCurrentRow = 0;
                ++this.numRowsFetchedFromResultSet;
                this.lastRowReturned = false;
                return true;
            }
            if (by == -45) {
                if (this.altRowState == ALTROW_START_RESULT) {
                    this.altRowState = ALTROW_END_RESULT;
                    this.reader.readUnsignedInt16();
                    this.lastColumnProcessedForCurrentRow = 0;
                    ++this.numRowsFetchedFromResultSet;
                    this.lastRowReturned = false;
                    return true;
                }
                this.altRowState = ALTROW_END_PREVIOUS;
                this.reader.pushByte(by);
                this.lastRowReturned = true;
                this.numRowsFetchedFromResultSet = 0;
                return false;
            }
            this.altRowState = ALTROW_NONE;
            this.reader.pushByte(by);
            this.processReply(2, baseWarnings);
            this.lastRowReturned = true;
            return false;
        }
        catch (UtilException utilException) {
            this.lastRowReturned = true;
            return false;
        }
    }

    public boolean getRow(BaseWarnings baseWarnings, int n) throws SQLException {
        try {
            byte by;
            if (this.numRowsFetchedFromResultSet > 0 && this.lastColumnProcessedForCurrentRow + 1 <= this.currentNativeColumns.length) {
                this.getColumnDataForRow(0, 0, n);
            }
            if ((by = this.readToken()) == 0) {
                this.lastRowReturned = true;
                return false;
            }
            if (by == -47) {
                if (this.altRowState != ALTROW_NONE) {
                    this.altRowState = ALTROW_END_RESULT;
                    this.reader.pushByte(by);
                    this.lastRowReturned = true;
                    this.numRowsFetchedFromResultSet = 0;
                    return false;
                }
                this.lastColumnProcessedForCurrentRow = 0;
                ++this.numRowsFetchedFromResultSet;
                this.lastRowReturned = false;
                return true;
            }
            if (by == -45) {
                if (this.altRowState == ALTROW_START_RESULT) {
                    this.altRowState = ALTROW_END_RESULT;
                    this.reader.readUnsignedInt16();
                    this.lastColumnProcessedForCurrentRow = 0;
                    ++this.numRowsFetchedFromResultSet;
                    this.lastRowReturned = false;
                    return true;
                }
                this.altRowState = ALTROW_END_PREVIOUS;
                this.reader.pushByte(by);
                this.lastRowReturned = true;
                this.numRowsFetchedFromResultSet = 0;
                return false;
            }
            this.altRowState = ALTROW_NONE;
            this.reader.pushByte(by);
            this.processReply(2, baseWarnings);
            this.lastRowReturned = true;
            return false;
        }
        catch (UtilException utilException) {
            this.lastRowReturned = true;
            return false;
        }
    }

    protected boolean processReplyToken(byte by, BaseWarnings baseWarnings) throws SQLException {
        boolean bl = true;
        try {
            switch (by) {
                case -127: 
                case -120: {
                    if (this.processMode == 2) {
                        this.reader.pushByte(by);
                        bl = false;
                        break;
                    }
                    if (this.processMode == 1) {
                        this.processColMetaData(by);
                        byte[] byArray = new byte[]{-86};
                        bl = this.reader.lookAheadForBytes(1, byArray);
                        break;
                    }
                    if (this.processMode == 4) {
                        this.processColMetaData(by);
                        bl = true;
                        break;
                    }
                    if (this.processMode == 5 || this.processMode == 3) {
                        this.processColMetaData(by);
                        this.completeRowProcessing(baseWarnings);
                        bl = true;
                    }
                    break;
                }
                case -3: 
                case -2: 
                case -1: {
                    bl = this.processDoneToken(by);
                    break;
                }
                case -85: {
                    bl = this.processInfoToken(baseWarnings);
                    break;
                }
                case 121: {
                    this.returnStatus = this.reader.readInt32();
                    this.returnStatusIsValid = true;
                    bl = true;
                    break;
                }
                case -84: {
                    if (this.conn.getTDSVersion() > 2) {
                        int n = this.reader.readUnsignedInt16();
                    } else {
                        int n = this.reader.readUnsignedInt16();
                        this.reader.readAndDiscardBytes(n);
                    }
                    bl = true;
                    break;
                }
                case -86: {
                    this.processErrorToken();
                    bl = true;
                    break;
                }
                case -29: {
                    this.processEnvChange(baseWarnings);
                    break;
                }
                case -47: {
                    this.processRow();
                    if (this.processMode == 3 || this.processMode == 5) {
                        this.completeRowProcessing(baseWarnings);
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case -45: {
                    this.processAltRow();
                    if (this.processMode == 3 || this.processMode == 5) {
                        this.completeRowProcessing(baseWarnings);
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case -92: 
                case -91: 
                case -87: {
                    if (this.processMode == 3) {
                        int n = this.reader.readUnsignedInt16();
                        this.reader.readAndDiscardBytes(n);
                        bl = true;
                        break;
                    }
                    String[] stringArray = new String[]{this.getNameForTokenType(by)};
                    throw this.conn.exceptions.getException(7003, stringArray, "08006");
                }
                default: {
                    String[] stringArray = new String[]{this.getNameForTokenType(by)};
                    throw this.conn.exceptions.getException(7003, stringArray, "08006");
                }
            }
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processReply(int n, BaseWarnings baseWarnings) throws SQLException {
        this.processMode = n;
        try {
            if (n != 2) {
                this.resultType = 0;
                this.numRowsAffected = -1;
                this.exception = null;
            }
            boolean bl = true;
            while (bl) {
                byte by = this.readToken();
                if (by == 0) {
                    if (n != 5 || this.resultType != 3) {
                        this.resultType = this.savedProcessMode == 5 ? 3 : 1;
                    }
                    bl = false;
                    this.discardReplyBytes();
                    continue;
                }
                bl = this.processReplyToken(by, baseWarnings);
            }
        }
        finally {
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }

    public void completeRowProcessing(BaseWarnings baseWarnings) throws SQLException {
        if (this.resultType == 2 && !this.lastRowReturned) {
            this.savedProcessMode = this.processMode;
            while (this.getRow(baseWarnings, -1)) {
            }
            this.processMode = this.savedProcessMode;
            this.savedProcessMode = 0;
            this.lastRowReturned = false;
        }
    }

    private String getComputeColumnName(int n, int n2) {
        if (this.conn.connection.implConnection.useODBCCompatibleComputeColumnNames) {
            switch (n) {
                case 79: {
                    return "avg";
                }
                case 75: {
                    return "cnt";
                }
                case 82: {
                    return "max";
                }
                case 81: {
                    return "min";
                }
                case 77: {
                    return "sum";
                }
                case 48: {
                    return "stdev";
                }
                case 49: {
                    return "stdevp";
                }
                case 50: {
                    return "var";
                }
                case 51: {
                    return "varp";
                }
            }
            return "Unknow Operation";
        }
        String string = this.getOperationString(n);
        BaseColumn baseColumn = ((BaseColumns)this.baseColumnSets.get(new Integer(0))).get(n2);
        String string2 = baseColumn.name;
        return string + "(" + string2 + ")";
    }

    private String getOperationString(int n) {
        switch (n) {
            case 79: {
                return "Avg";
            }
            case 75: {
                return "Count";
            }
            case 82: {
                return "Max";
            }
            case 81: {
                return "Min";
            }
            case 77: {
                return "Sum";
            }
            case 48: {
                return "StDev";
            }
            case 49: {
                return "StDevP";
            }
            case 50: {
                return "Var";
            }
            case 51: {
                return "VarP";
            }
        }
        return "Unknow Operation";
    }

    public void unprepare(BaseWarnings baseWarnings) throws SQLException {
    }

    private void getExtendedMetaData() throws UtilException, SQLException {
        byte by = 0;
        this.tableNames.removeAllElements();
        while (true) {
            if ((by = this.readToken()) == 0) {
                throw new UtilException(1001, true);
            }
            if (by == -120) {
                this.processColMetaData(by);
                continue;
            }
            if (by == -87) {
                this.processOrderToken();
                continue;
            }
            if (by == -92) {
                this.processTabName();
                continue;
            }
            if (by != -91) break;
            this.processColInfo();
        }
        this.reader.pushByte(by);
    }

    protected abstract void submitRequest(SQLServerImplStatement var1) throws SQLException;

    public void execute(SQLServerImplStatement sQLServerImplStatement, BaseWarnings baseWarnings) throws SQLException {
        this.submitRequest(sQLServerImplStatement);
    }

    private byte[] getByteArray(int n) {
        switch (n) {
            case 1: {
                if (this.tempData1 == null) {
                    this.tempData1 = new byte[1];
                }
                return this.tempData1;
            }
            case 2: {
                if (this.tempData2 == null) {
                    this.tempData2 = new byte[2];
                }
                return this.tempData2;
            }
            case 3: {
                if (this.tempData3 == null) {
                    this.tempData3 = new byte[3];
                }
                return this.tempData3;
            }
            case 4: {
                if (this.tempData4 == null) {
                    this.tempData4 = new byte[4];
                }
                return this.tempData4;
            }
            case 5: {
                if (this.tempData5 == null) {
                    this.tempData5 = new byte[5];
                }
                return this.tempData5;
            }
            case 6: {
                if (this.tempData6 == null) {
                    this.tempData6 = new byte[6];
                }
                return this.tempData6;
            }
            case 7: {
                if (this.tempData7 == null) {
                    this.tempData7 = new byte[7];
                }
                return this.tempData7;
            }
            case 8: {
                if (this.tempData8 == null) {
                    this.tempData8 = new byte[8];
                }
                return this.tempData8;
            }
            case 9: {
                if (this.tempData9 == null) {
                    this.tempData9 = new byte[9];
                }
                return this.tempData9;
            }
            case 10: {
                if (this.tempData10 == null) {
                    this.tempData10 = new byte[10];
                }
                return this.tempData10;
            }
            case 11: {
                if (this.tempData11 == null) {
                    this.tempData11 = new byte[11];
                }
                return this.tempData11;
            }
            case 12: {
                if (this.tempData12 == null) {
                    this.tempData12 = new byte[12];
                }
                return this.tempData12;
            }
            case 13: {
                if (this.tempData13 == null) {
                    this.tempData13 = new byte[13];
                }
                return this.tempData13;
            }
            case 14: {
                if (this.tempData14 == null) {
                    this.tempData14 = new byte[14];
                }
                return this.tempData14;
            }
            case 15: {
                if (this.tempData15 == null) {
                    this.tempData15 = new byte[15];
                }
                return this.tempData15;
            }
            case 16: {
                if (this.tempData16 == null) {
                    this.tempData16 = new byte[16];
                }
                return this.tempData16;
            }
        }
        return new byte[n];
    }

    public String convertNativeDecimalToString(byte[] byArray, int n, int n2, int n3) {
        int n4 = 41;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        n5 = n - 1;
        while (n5 != 0 && byArray[n5] == 0) {
            --n5;
            --n;
        }
        n5 = 0;
        if (this.convertedDecimalValue == null) {
            this.convertedDecimalValue = new char[42];
        }
        if (this.encodedNativeDecimalValue == null) {
            this.encodedNativeDecimalValue = new int[6];
        }
        while (n > 2) {
            this.encodedNativeDecimalValue[n6] = byArray[n5++] & 0xFF | (byArray[n5++] & 0xFF) << 8 | (byArray[n5++] & 0xFF) << 16;
            ++n6;
            n -= 3;
        }
        if (n == 2) {
            this.encodedNativeDecimalValue[n6] = byArray[n5++] & 0xFF | (byArray[n5] & 0xFF) << 8;
        } else if (n == 1) {
            this.encodedNativeDecimalValue[n6] = byArray[n5] & 0xFF;
        } else {
            --n6;
        }
        int n8 = n6;
        do {
            int n9 = 0;
            for (n6 = n8; n6 >= 0; --n6) {
                int n10 = this.encodedNativeDecimalValue[n6] + (n9 << 24);
                int n11 = n10 / 100;
                n9 = n10 - n11 * 100;
                this.encodedNativeDecimalValue[n6] = n11;
            }
            if (this.encodedNativeDecimalValue[n8] == 0) {
                --n8;
            }
            this.convertedDecimalValue[n4--] = BaseData.DigitOnes[n9];
            if (++n7 == n3) {
                this.convertedDecimalValue[n4--] = 46;
            }
            this.convertedDecimalValue[n4--] = BaseData.DigitTens[n9];
            if (++n7 != n3) continue;
            this.convertedDecimalValue[n4--] = 46;
        } while (n8 >= 0);
        if (n3 > n7) {
            while (n3 > n7) {
                ++n7;
                this.convertedDecimalValue[n4--] = 48;
            }
            this.convertedDecimalValue[n4--] = 46;
            this.convertedDecimalValue[n4--] = 48;
        } else if (n3 == n7) {
            this.convertedDecimalValue[n4--] = 48;
        } else if (this.convertedDecimalValue[n4 + 1] == '0' && this.convertedDecimalValue[n4 + 2] != '.') {
            ++n4;
        }
        if (n2 == 0) {
            this.convertedDecimalValue[n4--] = 45;
        }
        return new String(this.convertedDecimalValue, n4 + 1, 41 - n4);
    }

    public final byte readToken() throws SQLException {
        SQLServerImplStatement sQLServerImplStatement = this.conn.getCancelPendingStatement();
        if (sQLServerImplStatement != null && sQLServerImplStatement.getCancelOnNextRead()) {
            sQLServerImplStatement.setCancelableWork(false);
            sQLServerImplStatement.setCancelOnNextRead(false);
            throw this.conn.exceptions.getException(6078, "HY008");
        }
        try {
            this.currentToken = this.reader.readToken();
            return this.currentToken;
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void readPrepareHandle(BaseWarnings baseWarnings) throws SQLException {
        while (this.resultType != 1) {
            this.completeRowProcessing(baseWarnings);
            this.processReply(1, baseWarnings);
        }
    }

    public void readTransactionDescriptor(BaseWarnings baseWarnings) throws SQLException {
        if (this.resultType == 2 || this.resultType == 3) {
            while (this.resultType != 1) {
                this.completeRowProcessing(baseWarnings);
                this.processReply(1, baseWarnings);
            }
        }
    }

    void getPLPDataForOutputParameters(int n, BaseData baseData, byte by, UtilTransliterator utilTransliterator) throws SQLException {
        try {
            long l = this.reader.readInt64();
            if (l == -1L) {
                switch (by) {
                    case -89: 
                    case -25: {
                        baseData.setNull(10);
                        break;
                    }
                    case -91: {
                        baseData.setNull(2);
                        break;
                    }
                    case -15: {
                        if (this.conn.connection.implConnection.xmlDescribeTypeIsChar) {
                            baseData.setNull(10);
                            break;
                        }
                        baseData.setNull(2);
                    }
                }
            } else {
                int n2 = this.conn.maxMemoryPerLongDataCache > 0 ? this.conn.maxMemoryPerLongDataCache : 2048;
                long[] lArray = new long[1];
                UtilPagedTempBuffer utilPagedTempBuffer = null;
                if (by == -91 || by == -15 && !this.conn.connection.implConnection.xmlDescribeTypeIsChar) {
                    boolean bl = true;
                    int n3 = this.reader.readInt32();
                    if (n3 == 0) {
                        utilPagedTempBuffer = this.cacheLongData(n2, this.reader, n3, null, bl, lArray, false, utilPagedTempBuffer, this.conn.exceptions);
                    }
                    while (n3 != 0) {
                        utilPagedTempBuffer = this.cacheLongData(n2, this.reader, n3, null, bl, lArray, false, utilPagedTempBuffer, this.conn.exceptions);
                        bl = false;
                        n3 = this.reader.readInt32();
                    }
                } else {
                    UtilTransliterator utilTransliterator2 = null;
                    switch (by) {
                        case -25: 
                        case -15: {
                            utilTransliterator2 = this.reader.transliterator;
                            break;
                        }
                        case -89: {
                            utilTransliterator2 = utilTransliterator;
                            this.reader.transliterator = this.conn.unicodeTransliterator;
                        }
                    }
                    utilPagedTempBuffer = this.cacheLongData(n2, this.reader, (int)l, utilTransliterator2, true, lArray, true, utilPagedTempBuffer, this.conn.exceptions);
                }
                switch (by) {
                    case -89: 
                    case -25: {
                        baseData.setUCS2InputStream(utilPagedTempBuffer.getInputStream());
                        break;
                    }
                    case -91: {
                        baseData.setBinaryStream(utilPagedTempBuffer.getInputStream());
                        break;
                    }
                    case -15: {
                        if (this.conn.connection.implConnection.xmlDescribeTypeIsChar) {
                            baseData.setUCS2InputStream(utilPagedTempBuffer.getInputStream());
                            break;
                        }
                        baseData.setBinaryStream(utilPagedTempBuffer.getInputStream());
                    }
                }
            }
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public UtilPagedTempBuffer cacheLongData(int n, SQLServerByteOrderedDataReader sQLServerByteOrderedDataReader, int n2, UtilTransliterator utilTransliterator, boolean bl, long[] lArray, boolean bl2, UtilPagedTempBuffer utilPagedTempBuffer, BaseExceptions baseExceptions) throws SQLException {
        try {
            if (utilPagedTempBuffer == null) {
                utilPagedTempBuffer = new UtilPagedTempBuffer(n);
            } else if (bl) {
                utilPagedTempBuffer.truncate();
            }
            if (bl) {
                lArray[0] = 0L;
            }
            if (utilTransliterator == null) {
                int n3 = 0;
                byte[] byArray = new byte[16384];
                while (n2 > 0) {
                    n3 = sQLServerByteOrderedDataReader.getArrayOfBytes(byArray, 0, Math.min(16384, n2));
                    lArray[0] = lArray[0] + (long)utilPagedTempBuffer.write(lArray[0], byArray, 0, n3);
                    n2 -= n3;
                }
            } else {
                boolean bl3 = false;
                UtilException utilException = null;
                int n4 = 0;
                byte[] byArray = new byte[8192];
                InputStream inputStream = utilTransliterator.decodeAsUCS2ByteStream(sQLServerByteOrderedDataReader.getInputStream(n2, bl2), n2);
                while (n4 != -1) {
                    n4 = inputStream.read(byArray, 0, 8192);
                    try {
                        if (n4 == -1 || bl3) continue;
                        lArray[0] = lArray[0] + (long)utilPagedTempBuffer.write(lArray[0], byArray, 0, n4);
                    }
                    catch (UtilException utilException2) {
                        inputStream.skip(n2);
                        utilException = utilException2;
                        bl3 = true;
                    }
                }
                if (utilException != null) {
                    throw utilException;
                }
            }
        }
        catch (Exception exception) {
            throw baseExceptions.getException(exception);
        }
        return utilPagedTempBuffer;
    }
}

