/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcspy;

import com.metamatrix.jdbcspy.SpyLoggerForDataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class SpyXAResource
implements XAResource {
    private static String footprint = "$Revision:   1.2.2.0  $";
    private XAResource realXAResource;
    private SpyLoggerForDataSource spyLogger;
    private int id;
    private static int Id = 0;

    public SpyXAResource(XAResource xAResource, SpyLoggerForDataSource spyLoggerForDataSource) {
        this.realXAResource = xAResource;
        this.spyLogger = spyLoggerForDataSource;
        this.id = ++Id;
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        this.spyLogger.println("\n" + this + ".commit(Xid xid, boolean onePhase)");
        this.spyLogger.println("xid = " + this.spyLogger.xidToString(xid));
        this.spyLogger.println("onePhase = " + bl);
        try {
            this.realXAResource.commit(xid, bl);
        }
        catch (Throwable throwable) {
            throw this.spyLogger.xaException(throwable);
        }
        this.spyLogger.println("OK");
    }

    public void end(Xid xid, int n) throws XAException {
        this.spyLogger.println("\n" + this + ".end(Xid xid, int flags)");
        this.spyLogger.println("xid = " + this.spyLogger.xidToString(xid));
        this.spyLogger.println("flags = " + this.spyLogger.flagsToString(n));
        try {
            this.realXAResource.end(xid, n);
        }
        catch (Throwable throwable) {
            throw this.spyLogger.xaException(throwable);
        }
        this.spyLogger.println("OK");
    }

    public void forget(Xid xid) throws XAException {
        this.spyLogger.println("\n" + this + ".forget(Xid xid)");
        this.spyLogger.println("xid = " + this.spyLogger.xidToString(xid));
        try {
            this.realXAResource.forget(xid);
        }
        catch (Throwable throwable) {
            throw this.spyLogger.xaException(throwable);
        }
        this.spyLogger.println("OK");
    }

    public int getTransactionTimeout() throws XAException {
        int n;
        this.spyLogger.println("\n" + this + ".getTransactionTimeout()");
        try {
            n = this.realXAResource.getTransactionTimeout();
        }
        catch (Throwable throwable) {
            throw this.spyLogger.xaException(throwable);
        }
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public int prepare(Xid xid) throws XAException {
        int n;
        this.spyLogger.println("\n" + this + ".prepare(Xid xid)");
        this.spyLogger.println("xid = " + this.spyLogger.xidToString(xid));
        try {
            n = this.realXAResource.prepare(xid);
        }
        catch (Throwable throwable) {
            throw this.spyLogger.xaException(throwable);
        }
        this.spyLogger.println("OK (" + this.spyLogger.xaRetCodeToString(n) + ")");
        return n;
    }

    public Xid[] recover(int n) throws XAException {
        Xid[] xidArray;
        this.spyLogger.println("\n" + this + ".recover(int flag)");
        this.spyLogger.println("flag = " + this.spyLogger.flagsToString(n));
        try {
            xidArray = this.realXAResource.recover(n);
        }
        catch (Throwable throwable) {
            throw this.spyLogger.xaException(throwable);
        }
        if (xidArray == null) {
            this.spyLogger.println("OK (null)");
            return null;
        }
        for (int i = 0; i < xidArray.length; ++i) {
            this.spyLogger.println("==> " + this.spyLogger.xidToString(xidArray[i]));
        }
        this.spyLogger.println("OK (Xid[" + xidArray.length + "])");
        return xidArray;
    }

    public void rollback(Xid xid) throws XAException {
        this.spyLogger.println("\n" + this + ".rollback(Xid xid)");
        this.spyLogger.println("xid = " + this.spyLogger.xidToString(xid));
        try {
            this.realXAResource.rollback(xid);
        }
        catch (Throwable throwable) {
            throw this.spyLogger.xaException(throwable);
        }
        this.spyLogger.println("OK");
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".setTransactionTimeout(int seconds)");
        this.spyLogger.println("seconds = " + n);
        try {
            bl = this.realXAResource.setTransactionTimeout(n);
        }
        catch (Throwable throwable) {
            throw this.spyLogger.xaException(throwable);
        }
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public void start(Xid xid, int n) throws XAException {
        this.spyLogger.println("\n" + this + ".start(Xid xid, int flags)");
        this.spyLogger.println("xid = " + this.spyLogger.xidToString(xid));
        this.spyLogger.println("flags = " + this.spyLogger.flagsToString(n));
        try {
            this.realXAResource.start(xid, n);
        }
        catch (Throwable throwable) {
            throw this.spyLogger.xaException(throwable);
        }
        this.spyLogger.println("OK");
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        boolean bl;
        this.spyLogger.println("\n" + this + ".isSameRM(XAResource xares)");
        this.spyLogger.println("xares = " + xAResource);
        try {
            if (xAResource instanceof SpyXAResource) {
                xAResource = ((SpyXAResource)xAResource).realXAResource;
            }
            bl = this.realXAResource.isSameRM(xAResource);
        }
        catch (Throwable throwable) {
            throw this.spyLogger.xaException(throwable);
        }
        this.spyLogger.println("OK (" + bl + ")");
        return bl;
    }

    public final String toString() {
        return "XAResource[" + this.id + "]";
    }
}

