/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.jdbc.base.BaseImplClobService;
import com.metamatrix.util.UtilDebug;
import java.sql.SQLException;

public class BaseImplClobCached
extends BaseImplClobService {
    private static String footprint = "$Revision:   3.1.1.0  $";
    private int cacheStartOffset = -1;
    private int cacheEndOffset = -1;
    private char[] cachedData = null;

    public BaseImplClobCached(BaseImplClob baseImplClob, BaseExceptions baseExceptions) {
        super(baseImplClob, baseExceptions);
    }

    public int readData(char[] cArray, int n, long l, int n2) throws SQLException {
        this.fetchDataToCache(l, n2);
        int n3 = new Long(l).intValue();
        System.arraycopy(this.cachedData, n3, cArray, n, n2);
        return n2;
    }

    protected char[] getCachedData() {
        return this.cachedData;
    }

    protected void fetchDataToCache(long l, int n) throws SQLException {
        UtilDebug.assert((String)"clobOffset must be positive", (l > 0L ? 1 : 0) != 0);
        UtilDebug.assert((String)"numCharsToRead must be non-negative", (n >= 0 ? 1 : 0) != 0);
        this.createCacheBuffer();
        if (l + (long)n > 0x3FFFFFFFL) {
            throw this.exceptions.getException(6066);
        }
        int n2 = new Long(l).intValue();
        int n3 = new Long(l + (long)n).intValue();
        int n4 = n2;
        int n5 = n3;
        if (this.cacheStartOffset == -1 || this.cacheEndOffset == -1) {
            UtilDebug.assert((String)"Invalid Cache State", (this.cacheStartOffset == -1 && this.cacheEndOffset == -1 ? 1 : 0) != 0);
            int n6 = n3 - n2;
            if (n6 > 0) {
                this.subImplClob.readData(this.cachedData, n4, n2, n6);
                this.cacheStartOffset = n4;
                this.cacheEndOffset = n5 - 1;
            }
        } else {
            int n7;
            if (n4 < this.cacheStartOffset && (n7 = this.cacheStartOffset - n4) > 0) {
                this.subImplClob.readData(this.cachedData, n4, n2, n7);
                this.cacheStartOffset = n4;
            }
            if (n5 > this.cacheEndOffset) {
                n2 = n4 = this.cacheEndOffset + 1;
                n7 = n5 - n4;
                if (n7 > 0) {
                    this.subImplClob.readData(this.cachedData, n4, n2, n7);
                    this.cacheEndOffset = n5 - 1;
                }
            }
        }
    }

    private void createCacheBuffer() throws SQLException {
        if (this.cachedData == null) {
            int n;
            try {
                n = new Long(this.getLength()).intValue();
            }
            catch (Exception exception) {
                throw this.exceptions.getException(6066);
            }
            this.cachedData = new char[n + 1];
        }
    }
}

