/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sybase;

import com.metamatrix.util.UtilBufferedDataProvider;
import com.metamatrix.util.UtilDataProvider;
import com.metamatrix.util.UtilDepacketizingDataProvider;
import com.metamatrix.util.UtilException;

public class SybaseDepacketizingDataProvider
extends UtilDepacketizingDataProvider {
    private static String footprint = "$Revision:   3.1.6.0  $";
    private int messageType;
    private int statusField;
    private byte[] header = new byte[8];

    public SybaseDepacketizingDataProvider(UtilDataProvider utilDataProvider) {
        super(utilDataProvider);
    }

    protected void signalStartOfPacket() throws UtilException {
        for (int i = 8; i > 0; i -= this.dataProvider.getArrayOfBytes(this.header, 8 - i, i)) {
        }
        this.messageType = this.header[0];
        this.statusField = this.header[1];
        int n = ((this.header[2] & 0xFF) << 8) + (this.header[3] & 0xFF);
        this.setPacketSize(n);
        this.numBytesReadFromCurrentPacket = 8;
    }

    protected void signalEndOfPacket() throws UtilException {
        super.signalEndOfPacket();
        if ((this.statusField & 1) != 0) {
            this.noMoreDataToRead = true;
        }
    }

    public boolean moreUnbufferedDataToReturn() {
        if (this.noMoreDataToRead) {
            return false;
        }
        return (this.statusField & 1) == 0 || this.packetSize - this.numBytesReadFromCurrentPacket > ((UtilBufferedDataProvider)this.dataProvider).getNumRemainingBytesInBuffer();
    }
}

