/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilDataConversions;
import com.metamatrix.util.UtilDataProvider;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;

public class UtilBufferedDataQueue {
    static String footprint = "$Revision:   3.5.1.0  $";
    static final int MAX_BUFFER_SIZE = 0x200000;
    static final int NUM_KB_IN_2GB = 0x200000;
    UtilPagedTempBuffer buffer;
    int currentPos;
    int endOfDataPos;
    boolean isEmpty;
    int maxBufferSize;
    boolean useInfinitelyLargeBuffer;

    public UtilBufferedDataQueue(int n) throws UtilException {
        if (n <= 0 || n > 0x200000) {
            this.useInfinitelyLargeBuffer = true;
        } else {
            this.useInfinitelyLargeBuffer = false;
            this.maxBufferSize = n * 1024;
        }
        this.empty();
        this.buffer = null;
    }

    public UtilBufferedDataQueue(UtilPagedTempBuffer utilPagedTempBuffer, int n) throws UtilException {
        this.useInfinitelyLargeBuffer = true;
        this.currentPos = 0;
        this.endOfDataPos = n;
        this.isEmpty = false;
        this.buffer = utilPagedTempBuffer;
    }

    public void close() {
        if (this.buffer != null) {
            try {
                this.buffer.truncate(true);
            }
            catch (UtilException utilException) {
                // empty catch block
            }
        }
    }

    public int numBufferedBytes() {
        if (this.isEmpty) {
            return 0;
        }
        if (this.endOfDataPos > this.currentPos) {
            return this.endOfDataPos - this.currentPos;
        }
        return this.maxBufferSize - this.currentPos + this.endOfDataPos;
    }

    public void displayBuffer() {
        block8: {
            System.out.println("\n******************** BUFFER CONTENTS **********************");
            try {
                if (this.buffer == null || this.isEmpty) {
                    System.out.println("EMPTY");
                    break block8;
                }
                System.out.println("Num bytes in queue = " + this.numBufferedBytes());
                System.out.print("START --> ");
                if (this.currentPos < this.endOfDataPos) {
                    for (int i = this.currentPos; i < this.endOfDataPos; ++i) {
                        System.out.print(UtilDataConversions.byteToHex(this.buffer.read(i)) + " ");
                    }
                } else {
                    int n;
                    for (n = this.currentPos; n < this.maxBufferSize; ++n) {
                        System.out.print(UtilDataConversions.byteToHex(this.buffer.read(n)) + " ");
                    }
                    for (n = 0; n < this.endOfDataPos; ++n) {
                        System.out.print(UtilDataConversions.byteToHex(this.buffer.read(n)) + " ");
                    }
                }
                System.out.println("<-- END ");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean bufferAllData(UtilDataProvider utilDataProvider) throws UtilException {
        if (this.buffer == null) {
            this.buffer = this.createUtilPagedTempBuffer();
        }
        int n = 0;
        if (this.useInfinitelyLargeBuffer) {
            n = this.buffer.write((long)this.endOfDataPos, utilDataProvider);
            if (n != 0) {
                this.endOfDataPos += n;
                this.isEmpty = false;
            }
            return true;
        }
        if (this.numBufferedBytes() == this.maxBufferSize) {
            return false;
        }
        if (this.numBufferedBytes() == 0) {
            int n2 = this.maxBufferSize;
            n = this.buffer.write(0L, utilDataProvider, n2);
            if (n != 0) {
                this.isEmpty = false;
            }
            this.currentPos = 0;
            this.endOfDataPos = Math.abs(n);
            if (n == n2) {
                return false;
            }
            return n >= 0;
        }
        if (this.currentPos < this.endOfDataPos) {
            int n3;
            if (this.endOfDataPos < this.maxBufferSize) {
                n3 = this.maxBufferSize - this.endOfDataPos;
                n = this.buffer.write(this.endOfDataPos, utilDataProvider, n3);
                this.endOfDataPos += Math.abs(n);
                if (n != n3) {
                    return n >= 0;
                }
            }
            if (this.currentPos > 0) {
                n3 = this.currentPos;
                int n4 = this.buffer.write(0L, utilDataProvider, n3);
                this.endOfDataPos = Math.abs(n4);
                n += this.endOfDataPos;
                if (n4 != n3) {
                    return n4 >= 0;
                }
            }
            return false;
        }
        int n5 = this.currentPos - this.endOfDataPos;
        n = this.buffer.write(this.endOfDataPos, utilDataProvider, n5);
        this.endOfDataPos += Math.abs(n);
        if (n == n5) {
            return false;
        }
        return n >= 0;
    }

    public int write(byte[] byArray, int n, int n2) throws UtilException {
        if (this.buffer == null) {
            this.buffer = this.createUtilPagedTempBuffer();
        }
        int n3 = 0;
        if (this.useInfinitelyLargeBuffer) {
            n3 = this.buffer.write(this.endOfDataPos, byArray, n, n2);
            if (n3 != 0) {
                this.endOfDataPos += n3;
                this.isEmpty = false;
            }
            return n3;
        }
        if (this.numBufferedBytes() == this.maxBufferSize) {
            return 0;
        }
        if (this.numBufferedBytes() == 0) {
            int n4 = Math.min(n2, this.maxBufferSize);
            n3 = this.buffer.write(0L, byArray, n, n4);
            if (n3 != 0) {
                this.isEmpty = false;
            }
            this.currentPos = 0;
            this.endOfDataPos = Math.abs(n3);
            return this.endOfDataPos;
        }
        if (this.currentPos < this.endOfDataPos) {
            int n5;
            if (this.endOfDataPos < this.maxBufferSize) {
                n5 = Math.min(n2, this.maxBufferSize - this.endOfDataPos);
                n3 = this.buffer.write(this.endOfDataPos, byArray, n, n5);
                this.endOfDataPos += Math.abs(n3);
                if (n3 != n5) {
                    return Math.abs(n3);
                }
                n3 = Math.abs(n3);
            }
            if (n3 < n2 && this.currentPos > 0) {
                n5 = Math.min(n2 - n3, this.currentPos);
                int n6 = this.buffer.write(0L, byArray, n + n3, n5);
                this.endOfDataPos = Math.abs(n6);
                n3 += this.endOfDataPos;
            }
            return n3;
        }
        int n7 = this.currentPos - this.endOfDataPos;
        n7 = Math.min(n2, this.currentPos - this.endOfDataPos);
        n3 = this.buffer.write(this.endOfDataPos, byArray, n, n7);
        this.endOfDataPos += Math.abs(n3);
        return Math.abs(n3);
    }

    public int read(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (this.isEmpty) {
            return 0;
        }
        if (n2 > this.numBufferedBytes()) {
            n2 = this.numBufferedBytes();
        }
        if (this.currentPos < this.endOfDataPos) {
            n3 = this.buffer.read(this.currentPos, byArray, n, n2);
            this.currentPos += n3;
        } else {
            int n4 = n2 < this.maxBufferSize - this.currentPos ? n2 : this.maxBufferSize - this.currentPos;
            int n5 = this.buffer.read(this.currentPos, byArray, n, n4);
            n2 -= n5;
            this.currentPos += n5;
            n3 += n5;
            if (this.currentPos == this.maxBufferSize) {
                this.currentPos = 0;
            }
            if (n2 > 0) {
                n5 = this.buffer.read(this.currentPos, byArray, n + n5, n2);
                this.currentPos += n5;
                n3 += n5;
            }
        }
        if (this.currentPos == this.endOfDataPos) {
            this.empty();
        }
        return n3;
    }

    public void skip(int n) {
        if (n <= 0) {
            return;
        }
        if (this.isEmpty) {
            return;
        }
        if (n > this.numBufferedBytes()) {
            this.empty();
            return;
        }
        this.currentPos = this.currentPos < this.endOfDataPos ? (this.currentPos += n) : (n < this.maxBufferSize - this.currentPos ? (this.currentPos += n) : (n -= this.maxBufferSize - this.currentPos));
    }

    public void empty() {
        this.currentPos = 0;
        this.endOfDataPos = 0;
        this.isEmpty = true;
    }

    private UtilPagedTempBuffer createUtilPagedTempBuffer() {
        UtilPagedTempBuffer utilPagedTempBuffer = null;
        if (this.useInfinitelyLargeBuffer) {
            utilPagedTempBuffer = new UtilPagedTempBuffer(0x200000);
            utilPagedTempBuffer.setOverflowToDisk(true);
        } else {
            int n;
            int n2;
            int n3 = this.maxBufferSize / 1024;
            if (n3 % 2 != 0) {
                n2 = n3;
                n = 1;
            } else {
                int n4;
                for (n4 = 1; n4 < 6 && n3 % (1 << n4 + 1) == 0; ++n4) {
                }
                n = 1 << n4;
                n2 = n3 / n;
            }
            utilPagedTempBuffer = new UtilPagedTempBuffer(n2, n);
            utilPagedTempBuffer.setOverflowToDisk(false);
        }
        return utilPagedTempBuffer;
    }
}

