/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.xml.soap;

import com.metamatrix.connector.xml.SOAPConnectorState;
import com.metamatrix.connector.xml.base.Messages;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.internal.core.text.MessageFormat;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;

public class SOAPConnectorStateImpl
implements SOAPConnectorState {
    public static final String ENCODING_STYLE_PROPERTY_NAME = "EncodingStyle";
    public static final String RPC_ENC_STYLE = "RPC - Encoded";
    public static final String RPC_LITERAL_STYLE = "RPC - Literal";
    public static final String DOC_ENCODED_STYLE = "Document - Encoded";
    public static final String DOC_LITERAL_STYLE = "Document - Literal";
    public static final String CONNECTOR_EXCEPTION_ON_SOAP_FAULT = "ExceptionOnSOAPFault";
    public static final String USE_HTTP_CHUNKING_PROPERTY_NAME = "UseHTTPChunking";
    private boolean m_encoded;
    private boolean m_RPC;
    private boolean m_exceptionOnFault;
    private boolean m_useChunking;
    private ConnectorLogger logger;
    private String hostnameVerifierClassName;

    public SOAPConnectorStateImpl() {
        this.setEncoded(true);
        this.setRPC(true);
        this.setExceptionOnFault(false);
        this.setUseHttpChunking(true);
    }

    private boolean isNotNullOrEmpty(String value) {
        return value != null && !value.equals("");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setState(ConnectorEnvironment env) throws ConnectorException {
        Properties props = env.getProperties();
        String enc = props.getProperty(ENCODING_STYLE_PROPERTY_NAME);
        if (!this.isNotNullOrEmpty(enc)) throw new ConnectorException(Messages.getString((String)"SOAPConnectorStateImpl.empty.ENCODING_STYLE_PROPERTY_NAME"));
        if (enc.equalsIgnoreCase(RPC_ENC_STYLE) || enc.equalsIgnoreCase(RPC_LITERAL_STYLE) || enc.equalsIgnoreCase(DOC_ENCODED_STYLE) || enc.equalsIgnoreCase(DOC_LITERAL_STYLE)) {
            if (enc.equalsIgnoreCase(RPC_ENC_STYLE) || enc.equalsIgnoreCase(RPC_LITERAL_STYLE)) {
                this.setRPC(true);
            } else {
                this.setRPC(false);
            }
            if (enc.equalsIgnoreCase(RPC_ENC_STYLE) || enc.equalsIgnoreCase(DOC_ENCODED_STYLE)) {
                this.setEncoded(true);
            } else {
                this.setEncoded(false);
            }
        } else {
            String rawMsg = Messages.getString((String)"SOAPConnectorStateImpl.invalid.ENCODING_STYLE_PROPERTY_NAME");
            Object[] objs = new Object[]{RPC_ENC_STYLE, RPC_LITERAL_STYLE, DOC_ENCODED_STYLE, DOC_LITERAL_STYLE};
            String msg = MessageFormat.format((String)rawMsg, (Object[])objs);
            throw new ConnectorException(msg);
        }
        String strExceptionOnFault = props.getProperty(CONNECTOR_EXCEPTION_ON_SOAP_FAULT);
        if (!this.isNotNullOrEmpty(strExceptionOnFault)) {
            throw new ConnectorException(Messages.getString((String)"SOAPConnectorStateImpl.empty.CONNECTOR_EXCEPTION_ON_SOAP_FAULT"));
        }
        boolean exOnFault = false;
        exOnFault = Boolean.valueOf(strExceptionOnFault);
        this.setExceptionOnFault(exOnFault);
        boolean useChunking = true;
        String strUseHttpChunking = props.getProperty(USE_HTTP_CHUNKING_PROPERTY_NAME);
        if (this.isNotNullOrEmpty(strUseHttpChunking)) {
            useChunking = Boolean.valueOf(strUseHttpChunking);
            this.setUseHttpChunking(useChunking);
        }
        this.setHostnameVerifierClassName(props.getProperty("HostnameVerifier"));
        if (this.getHostnameVerifierClassName() == null) return;
        try {
            HostnameVerifier verifier = (HostnameVerifier)Class.forName(this.getHostnameVerifierClassName()).newInstance();
            HttpsURLConnection.setDefaultHostnameVerifier(verifier);
            return;
        }
        catch (Exception e) {
            throw new ConnectorException((Throwable)e, "Unable to load HostnameVerifier");
        }
    }

    public Properties getState() {
        Properties props = new Properties();
        String style = null;
        style = this.isRPC() ? (this.isEncoded() ? RPC_ENC_STYLE : RPC_LITERAL_STYLE) : (this.isEncoded() ? DOC_ENCODED_STYLE : DOC_LITERAL_STYLE);
        props.setProperty(ENCODING_STYLE_PROPERTY_NAME, style);
        props.setProperty(CONNECTOR_EXCEPTION_ON_SOAP_FAULT, Boolean.toString(this.isExceptionOnFault()));
        props.setProperty(USE_HTTP_CHUNKING_PROPERTY_NAME, Boolean.toString(this.isUseHttpChunking()));
        return props;
    }

    private void setEncoded(boolean encoded) {
        this.m_encoded = encoded;
    }

    public boolean isEncoded() {
        return this.m_encoded;
    }

    private void setRPC(boolean rpc) {
        this.m_RPC = rpc;
    }

    public boolean isRPC() {
        return this.m_RPC;
    }

    private void setExceptionOnFault(boolean exceptionOnFault) {
        this.m_exceptionOnFault = exceptionOnFault;
    }

    public boolean isExceptionOnFault() {
        return this.m_exceptionOnFault;
    }

    private void setUseHttpChunking(boolean useChunking) {
        this.m_useChunking = useChunking;
    }

    public boolean isUseHttpChunking() {
        return this.m_useChunking;
    }

    public void setLogger(ConnectorLogger logger) {
        this.logger = logger;
    }

    public ConnectorLogger getLogger() {
        return this.logger;
    }

    private void setHostnameVerifierClassName(String property) {
        this.hostnameVerifierClassName = property;
    }

    private String getHostnameVerifierClassName() {
        return this.hostnameVerifierClassName;
    }
}

