/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.util.concurrent;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlertSerializer {
    private final Log log = LogFactory.getLog(AlertSerializer.class);
    private static Map<Integer, ReentrantReadWriteLock> locks = new HashMap<Integer, ReentrantReadWriteLock>();
    private static Map<Integer, Long> lockTimes = Collections.synchronizedMap(new HashMap());
    private static AlertSerializer singleton = new AlertSerializer();

    public static synchronized AlertSerializer getSingleton() {
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(int alertDefinitionId) {
        String msg = "tid= " + Thread.currentThread().getId() + ": alertDefinitionId=" + alertDefinitionId;
        boolean debug = this.log.isDebugEnabled();
        ReentrantReadWriteLock lock = null;
        this.logDebug(debug, msg, ": about to synchronize");
        AlertSerializer alertSerializer = this;
        synchronized (alertSerializer) {
            this.logDebug(debug, msg, ": synchronized");
            lock = locks.get(alertDefinitionId);
            if (lock == null) {
                this.logDebug(debug, msg, ": creating new lock");
                lock = new ReentrantReadWriteLock();
                locks.put(alertDefinitionId, lock);
            }
        }
        this.logDebug(debug, msg, ": acquiring write lock");
        long start = System.currentTimeMillis();
        lock.writeLock().lock();
        long end = System.currentTimeMillis();
        long duration = end - start;
        lockTimes.put(alertDefinitionId, end);
        if (duration < 5000L) {
            this.logDebug(debug, msg, ": acquired write lock in millis=" + duration);
        } else {
            this.log.info((Object)(msg + ": acquired write lock in millis=" + duration));
        }
    }

    public void unlock(int alertDefinitionId) {
        String msg = "tid= " + Thread.currentThread().getId() + ": alertDefinitionId=" + alertDefinitionId;
        boolean debug = this.log.isDebugEnabled();
        ReentrantReadWriteLock lock = locks.get(alertDefinitionId);
        if (lock != null) {
            Long lockedTime = lockTimes.get(alertDefinitionId);
            long duration = System.currentTimeMillis() - (lockedTime != null ? lockedTime : Long.MAX_VALUE);
            if (duration < 5000L) {
                this.logDebug(debug, msg, ": releasing write lock after being locked for millis=" + duration);
            } else {
                this.log.info((Object)(msg + ": releasing write lock after being locked for millis=" + duration));
            }
            lock.writeLock().unlock();
            this.logDebug(debug, msg, ": released write lock");
        } else {
            this.log.warn((Object)(msg + ": cannot release write lock"));
        }
    }

    private void logDebug(boolean enabled, String arg1, String arg2) {
        if (enabled) {
            this.log.debug((Object)(arg1 + arg2));
        }
    }
}

