/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.inventory.CreateResourceRequest;
import org.rhq.core.clientapi.agent.inventory.CreateResourceResponse;
import org.rhq.core.clientapi.agent.inventory.DeleteResourceRequest;
import org.rhq.core.clientapi.agent.inventory.DeleteResourceResponse;
import org.rhq.core.clientapi.agent.inventory.ResourceFactoryAgentService;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.content.InstalledPackage;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.PackageVersion;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.resource.Agent;
import org.rhq.core.domain.resource.CreateResourceHistory;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.DeleteResourceHistory;
import org.rhq.core.domain.resource.DeleteResourceStatus;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.domain.util.PageControl;
import org.rhq.core.domain.util.PageList;
import org.rhq.core.domain.util.PageOrdering;
import org.rhq.core.server.PersistenceUtility;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.enterprise.server.agentclient.AgentClient;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.authz.PermissionException;
import org.rhq.enterprise.server.content.ContentManagerHelper;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.core.AgentManagerLocal;
import org.rhq.enterprise.server.jaxb.adapter.ConfigurationAdapter;
import org.rhq.enterprise.server.resource.ResourceFactoryManagerLocal;
import org.rhq.enterprise.server.resource.ResourceFactoryManagerRemote;
import org.rhq.enterprise.server.resource.ResourceManagerLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
public class ResourceFactoryManagerBean
implements ResourceFactoryManagerLocal,
ResourceFactoryManagerRemote {
    private static final int REQUEST_TIMEOUT = 3600000;
    private final Log log = LogFactory.getLog(ResourceFactoryManagerBean.class);
    @PersistenceContext(unitName="rhqpu")
    private EntityManager entityManager;
    @EJB
    private AgentManagerLocal agentManager;
    @EJB
    private AuthorizationManagerLocal authorizationManager;
    @EJB
    private SubjectManagerLocal subjectManager;
    @EJB
    private ResourceFactoryManagerLocal resourceFactoryManager;
    @EJB
    private ResourceManagerLocal resourceManager;
    @EJB
    private ContentManagerLocal contentManager;

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public Resource createInventoryResource(int parentResourceId, int resourceTypeId, String resourceName, String resourceKey) {
        Resource parentResource = (Resource)this.entityManager.find(Resource.class, (Object)parentResourceId);
        ResourceType resourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)resourceTypeId);
        Subject overLord = this.subjectManager.getOverlord();
        Resource resource = this.resourceManager.getResourceByParentAndKey(overLord, parentResource, resourceKey, resourceType.getPlugin(), resourceType.getName());
        if (resource == null) {
            resource = new Resource(resourceKey, resourceName, resourceType);
            resource.setParentResource(parentResource);
            resource.setAgent(parentResource.getAgent());
            resource.setInventoryStatus(InventoryStatus.COMMITTED);
            this.entityManager.persist((Object)resource);
        } else {
            resource.setInventoryStatus(InventoryStatus.COMMITTED);
            resource.setItime(Calendar.getInstance().getTimeInMillis());
        }
        return resource;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void completeCreateResource(CreateResourceResponse response) {
        this.log.debug((Object)("Received call to complete create resource: " + response));
        CreateResourceHistory history = (CreateResourceHistory)this.entityManager.find(CreateResourceHistory.class, (Object)response.getRequestId());
        if (history == null) {
            this.log.error((Object)("Attempting to complete a request that was not found in the database: " + response.getRequestId()));
            return;
        }
        history.setNewResourceKey(response.getResourceKey());
        history.setErrorMessage(response.getErrorMessage());
        history.setStatus(response.getStatus());
        if (response.getResourceConfiguration() != null) {
            this.entityManager.merge((Object)response.getResourceConfiguration());
        }
        String newResourceName = response.getResourceName();
        if (history.getCreatedResourceName() != null) {
            newResourceName = history.getCreatedResourceName();
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public void completeDeleteResourceRequest(DeleteResourceResponse response) {
        this.log.debug((Object)("Received call to complete delete resource: " + response));
        DeleteResourceHistory history = (DeleteResourceHistory)this.entityManager.find(DeleteResourceHistory.class, (Object)response.getRequestId());
        if (history == null) {
            this.log.error((Object)("Attemping to complete a request that was not found in the database: " + response.getRequestId()));
            return;
        }
        history.setErrorMessage(response.getErrorMessage());
        history.setStatus(response.getStatus());
        if (response.getStatus() == DeleteResourceStatus.SUCCESS) {
            Resource resource = history.getResource();
            Set children = resource.getChildResources();
            resource.setInventoryStatus(InventoryStatus.DELETED);
            resource.setItime(System.currentTimeMillis());
            this.entityManager.merge((Object)resource);
            this.uninventoryChildren(children);
        }
    }

    private void uninventoryChildren(Set<Resource> children) {
        for (Resource child : children) {
            this.resourceManager.uninventoryResource(this.subjectManager.getOverlord(), child.getId());
        }
    }

    @Override
    public void checkForTimedOutRequests() {
        try {
            Query query = this.entityManager.createNamedQuery("CreateResourceHistory.findWithStatus");
            query.setParameter("status", (Object)CreateResourceStatus.IN_PROGRESS);
            List createHistories = query.getResultList();
            if (createHistories == null) {
                return;
            }
            for (CreateResourceHistory request : createHistories) {
                long duration = request.getDuration();
                if (duration <= 3600000L) continue;
                this.log.debug((Object)("Timing out request after duration: " + duration + " Request: " + request));
                request.setErrorMessage("Request with duration " + duration + " exceeded the timeout threshold of " + 3600000);
                request.setStatus(CreateResourceStatus.TIMED_OUT);
            }
            query = this.entityManager.createNamedQuery("CreateResourceHistory.findWithStatus");
            query.setParameter("status", (Object)CreateResourceStatus.IN_PROGRESS);
            List deleteHistories = query.getResultList();
            if (deleteHistories == null) {
                return;
            }
            for (DeleteResourceHistory request : deleteHistories) {
                long duration = request.getDuration();
                if (duration <= 3600000L) continue;
                this.log.debug((Object)("Timing out request after duration: " + duration + " Request: " + request));
                request.setErrorMessage("Request with duration " + duration + " exceeded the timeout threshold of " + 3600000);
                request.setStatus(DeleteResourceStatus.TIMED_OUT);
            }
        }
        catch (Throwable e) {
            this.log.error((Object)"Error while processing timed out requests", e);
        }
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public CreateResourceHistory persistCreateHistory(Subject user, int parentResourceId, int resourceTypeId, String createResourceName, Configuration configuration) {
        Resource parentResource = (Resource)this.entityManager.getReference(Resource.class, (Object)parentResourceId);
        ResourceType resourceType = (ResourceType)this.entityManager.getReference(ResourceType.class, (Object)resourceTypeId);
        Configuration configurationClone = configuration.deepCopy(false);
        CreateResourceHistory history = new CreateResourceHistory(parentResource, resourceType, user.getName(), configurationClone);
        history.setCreatedResourceName(createResourceName);
        history.setStatus(CreateResourceStatus.IN_PROGRESS);
        this.entityManager.persist((Object)history);
        parentResource.addCreateChildResourceHistory(history);
        parentResource.getAgent();
        return history;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public CreateResourceHistory persistCreateHistory(Subject user, int parentResourceId, int resourceTypeId, String createResourceName, PackageVersion packageVersion, Configuration deploymentTimeConfiguration) {
        Resource parentResource = (Resource)this.entityManager.getReference(Resource.class, (Object)parentResourceId);
        ResourceType resourceType = (ResourceType)this.entityManager.getReference(ResourceType.class, (Object)resourceTypeId);
        CreateResourceHistory history = new CreateResourceHistory(parentResource, resourceType, user.getName(), (InstalledPackage)null);
        history.setCreatedResourceName(createResourceName);
        history.setConfiguration(deploymentTimeConfiguration);
        history.setStatus(CreateResourceStatus.IN_PROGRESS);
        this.entityManager.persist((Object)history);
        parentResource.addCreateChildResourceHistory(history);
        parentResource.getAgent();
        return history;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public DeleteResourceHistory persistDeleteHistory(Subject user, int resourceId) {
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        DeleteResourceHistory history = new DeleteResourceHistory(resource, user.getName());
        history.setStatus(DeleteResourceStatus.IN_PROGRESS);
        this.entityManager.persist((Object)history);
        resource.addDeleteResourceHistory(history);
        resource.getAgent();
        return history;
    }

    @Override
    public CreateResourceHistory getCreateHistoryItem(int historyItemId) {
        Query query = this.entityManager.createNamedQuery("CreateResourceHistory.findById");
        query.setParameter("id", (Object)historyItemId);
        CreateResourceHistory history = (CreateResourceHistory)query.getSingleResult();
        return history;
    }

    @Override
    public int getCreateChildResourceHistoryCount(int parentResourceId, Long beginDate, Long endDate) {
        Query query = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"CreateResourceHistory.findByParentResourceId");
        query.setParameter("id", (Object)parentResourceId);
        query.setParameter("startTime", (Object)beginDate);
        query.setParameter("endTime", (Object)endDate);
        long totalCount = (Long)query.getSingleResult();
        return (int)totalCount;
    }

    @Override
    public PageList<CreateResourceHistory> findCreateChildResourceHistory(int parentResourceId, Long beginDate, Long endDate, PageControl pageControl) {
        pageControl.initDefaultOrderingField("crh.id", PageOrdering.DESC);
        int totalCount = this.getCreateChildResourceHistoryCount(parentResourceId, beginDate, endDate);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"CreateResourceHistory.findByParentResourceId", (PageControl)pageControl);
        query.setParameter("id", (Object)parentResourceId);
        query.setParameter("startTime", (Object)beginDate);
        query.setParameter("endTime", (Object)endDate);
        List history = query.getResultList();
        PageList pageList = new PageList((Collection)history, totalCount, pageControl);
        return pageList;
    }

    @Override
    public int getDeleteChildResourceHistoryCount(int parentResourceId, Long beginDate, Long endDate) {
        Query query = PersistenceUtility.createCountQuery((EntityManager)this.entityManager, (String)"DeleteResourceHistory.findByParentResourceId");
        query.setParameter("id", (Object)parentResourceId);
        query.setParameter("startTime", (Object)beginDate);
        query.setParameter("endTime", (Object)endDate);
        long totalCount = (Long)query.getSingleResult();
        return (int)totalCount;
    }

    @Override
    public PageList<DeleteResourceHistory> findDeleteChildResourceHistory(int parentResourceId, Long beginDate, Long endDate, PageControl pageControl) {
        pageControl.initDefaultOrderingField("drh.id", PageOrdering.DESC);
        int totalCount = this.getDeleteChildResourceHistoryCount(parentResourceId, beginDate, endDate);
        Query query = PersistenceUtility.createQueryWithOrderBy((EntityManager)this.entityManager, (String)"DeleteResourceHistory.findByParentResourceId", (PageControl)pageControl);
        query.setParameter("id", (Object)parentResourceId);
        query.setParameter("startTime", (Object)beginDate);
        query.setParameter("endTime", (Object)endDate);
        List history = query.getResultList();
        PageList pageList = new PageList((Collection)history, totalCount, pageControl);
        return pageList;
    }

    @Override
    public void createResource(Subject user, int parentResourceId, int resourceTypeId, String resourceName, Configuration pluginConfiguration, Configuration resourceConfiguration) {
        this.log.debug((Object)("Received call to create configuration backed resource under parent: " + parentResourceId + " of type: " + resourceTypeId));
        ResourceType resourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)resourceTypeId);
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)parentResourceId);
        Agent agent = resource.getAgent();
        if (!this.authorizationManager.hasResourcePermission(user, Permission.CREATE_CHILD_RESOURCES, resource.getId())) {
            throw new PermissionException("User [" + user.getName() + "] does not have permission to create a child resource for resource [" + resource + "]");
        }
        CreateResourceHistory persistedHistory = this.resourceFactoryManager.persistCreateHistory(user, parentResourceId, resourceTypeId, resourceName, resourceConfiguration);
        CreateResourceRequest request = new CreateResourceRequest(persistedHistory.getId(), parentResourceId, resourceName, resourceType.getName(), resourceType.getPlugin(), pluginConfiguration, resourceConfiguration);
        try {
            AgentClient agentClient = this.agentManager.getAgentClient(agent);
            ResourceFactoryAgentService resourceFactoryAgentService = agentClient.getResourceFactoryAgentService();
            resourceFactoryAgentService.createResource(request);
        }
        catch (Exception e) {
            this.log.error((Object)"Error while sending create resource request to agent service", (Throwable)e);
            String errorMessage = ThrowableUtil.getAllMessages((Throwable)e);
            CreateResourceResponse response = new CreateResourceResponse(persistedHistory.getId(), null, null, CreateResourceStatus.FAILURE, errorMessage, resourceConfiguration);
            this.resourceFactoryManager.completeCreateResource(response);
            throw new RuntimeException("Error while sending create resource request to agent service", e);
        }
    }

    @Override
    public void createPackageBackedResource(Subject subject, int parentResourceId, int newResourceTypeId, String newResourceName, @XmlJavaTypeAdapter(value=ConfigurationAdapter.class) Configuration pluginConfiguration, String packageName, String packageVersionNumber, Integer architectureId, @XmlJavaTypeAdapter(value=ConfigurationAdapter.class) Configuration deploymentTimeConfiguration, byte[] packageBits) {
        this.createResource(subject, parentResourceId, newResourceTypeId, newResourceName, pluginConfiguration, packageName, packageVersionNumber, architectureId, deploymentTimeConfiguration, new ByteArrayInputStream(packageBits));
    }

    @Override
    public void createResource(Subject user, int parentResourceId, int newResourceTypeId, String newResourceName, Configuration pluginConfiguration, String packageName, String packageVersionNumber, Integer architectureId, Configuration deploymentTimeConfiguration, InputStream packageBitStream) {
        this.createResource(user, parentResourceId, newResourceTypeId, newResourceName, pluginConfiguration, packageName, packageVersionNumber, architectureId, deploymentTimeConfiguration, packageBitStream, null);
    }

    @Override
    public void createResource(Subject user, int parentResourceId, int newResourceTypeId, String newResourceName, Configuration pluginConfiguration, String packageName, String packageVersionNumber, Integer architectureId, Configuration deploymentTimeConfiguration, InputStream packageBitStream, Map<String, String> packageUploadDetails) {
        this.log.info((Object)("Received call to create package backed resource under parent [" + parentResourceId + "]"));
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)parentResourceId);
        ResourceType newResourceType = (ResourceType)this.entityManager.find(ResourceType.class, (Object)newResourceTypeId);
        PackageType newPackageType = this.contentManager.getResourceCreationPackageType(newResourceTypeId);
        Agent agent = resource.getAgent();
        if (!this.authorizationManager.hasResourcePermission(user, Permission.CREATE_CHILD_RESOURCES, resource.getId())) {
            throw new PermissionException("User [" + user.getName() + "] does not have permission to create a child resource for resource [" + resource + "]");
        }
        packageVersionNumber = null == packageVersionNumber ? Long.toString(System.currentTimeMillis()) : packageVersionNumber;
        architectureId = null != architectureId ? architectureId.intValue() : this.contentManager.getNoArchitecture().getId();
        PackageVersion packageVersion = null;
        packageVersion = packageUploadDetails == null ? this.contentManager.createPackageVersion(packageName, newPackageType.getId(), packageVersionNumber, architectureId, packageBitStream) : this.contentManager.getUploadedPackageVersion(packageName, newPackageType.getId(), packageVersionNumber, architectureId, packageBitStream, packageUploadDetails, newResourceTypeId);
        CreateResourceHistory persistedHistory = this.resourceFactoryManager.persistCreateHistory(user, parentResourceId, newResourceTypeId, newResourceName, packageVersion, deploymentTimeConfiguration);
        ResourcePackageDetails packageDetails = ContentManagerHelper.packageVersionToDetails(packageVersion);
        packageDetails.setDeploymentTimeConfiguration(deploymentTimeConfiguration);
        CreateResourceRequest request = new CreateResourceRequest(persistedHistory.getId(), parentResourceId, newResourceName, newResourceType.getName(), newResourceType.getPlugin(), pluginConfiguration, packageDetails);
        try {
            AgentClient agentClient = this.agentManager.getAgentClient(agent);
            ResourceFactoryAgentService resourceFactoryAgentService = agentClient.getResourceFactoryAgentService();
            resourceFactoryAgentService.createResource(request);
        }
        catch (NoResultException nre) {
        }
        catch (Exception e) {
            this.log.error((Object)"Error while sending create resource request to agent service", (Throwable)e);
            String errorMessage = ThrowableUtil.getAllMessages((Throwable)e);
            CreateResourceResponse response = new CreateResourceResponse(persistedHistory.getId(), null, null, CreateResourceStatus.FAILURE, errorMessage, null);
            this.resourceFactoryManager.completeCreateResource(response);
            throw new RuntimeException("Error while sending create resource request to agent service", e);
        }
    }

    @Override
    public void deleteResource(Subject subject, int resourceId) {
        this.log.debug((Object)("Received call to delete resource: " + resourceId));
        Resource resource = (Resource)this.entityManager.find(Resource.class, (Object)resourceId);
        Agent agent = resource.getAgent();
        if (!this.authorizationManager.hasResourcePermission(subject, Permission.DELETE_RESOURCE, resource.getId())) {
            throw new PermissionException("User [" + subject.getName() + "] does not have permission to delete resource [" + resource + "]");
        }
        DeleteResourceHistory persistedHistory = this.resourceFactoryManager.persistDeleteHistory(subject, resourceId);
        DeleteResourceRequest request = new DeleteResourceRequest(persistedHistory.getId(), resourceId);
        try {
            AgentClient agentClient = this.agentManager.getAgentClient(agent);
            ResourceFactoryAgentService resourceFactoryAgentService = agentClient.getResourceFactoryAgentService();
            resourceFactoryAgentService.deleteResource(request);
        }
        catch (Exception e) {
            this.log.error((Object)"Error while sending delete resource request to agent service", (Throwable)e);
            String errorMessage = ThrowableUtil.getAllMessages((Throwable)e);
            DeleteResourceResponse response = new DeleteResourceResponse(persistedHistory.getId(), DeleteResourceStatus.FAILURE, errorMessage);
            this.resourceFactoryManager.completeDeleteResourceRequest(response);
            throw new RuntimeException("Error while sending delete resource request to agent service", e);
        }
    }
}

