/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.resource;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.resource.composite.ResourceFacets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFacetsCache {
    private final Log log = LogFactory.getLog(ResourceFacetsCache.class);
    private Map<Integer, ResourceFacets> cache = new HashMap<Integer, ResourceFacets>();
    private static ResourceFacetsCache singleton = new ResourceFacetsCache();

    private ResourceFacetsCache() {
    }

    public static ResourceFacetsCache getSingleton() {
        return singleton;
    }

    public ResourceFacets getResourceFacets(int resourceTypeId) {
        return this.cache.get(resourceTypeId);
    }

    public void reload(List<ResourceFacets> facets) {
        try {
            HashMap<Integer, ResourceFacets> reloadedFacets = new HashMap<Integer, ResourceFacets>();
            for (ResourceFacets facet : facets) {
                reloadedFacets.put(facet.getResourceTypeId(), facet);
            }
            this.cache = reloadedFacets;
        }
        catch (Throwable t) {
            this.log.error((Object)"Could not reload ResourceFacets cache", t);
        }
    }
}

