/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.bundle;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginValidator;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.bundle.BundlePluginDescriptorType;

public class BundlePluginValidator
implements ServerPluginValidator {
    private final Log log = LogFactory.getLog(BundlePluginValidator.class);

    public boolean validate(ServerPluginEnvironment env) {
        if (!(env.getPluginDescriptor() instanceof BundlePluginDescriptorType)) {
            this.log.error((Object)("Descriptor was not of the bundle type: " + env.getPluginDescriptor()));
            return false;
        }
        BundlePluginDescriptorType descriptor = (BundlePluginDescriptorType)env.getPluginDescriptor();
        if (descriptor.getBundle() == null) {
            this.log.error((Object)"Descriptor missing the bundle type");
            return false;
        }
        if (descriptor.getBundle().getType() == null) {
            this.log.error((Object)"Descriptor missing the bundle type's name attribute");
            return false;
        }
        if (descriptor.getBundle().getType().trim().length() == 0) {
            this.log.error((Object)"Descriptor bundle type's name must be non-zero in length");
            return false;
        }
        return true;
    }
}

