/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.perspective.activator.context;

import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.auth.Subject;
import org.rhq.core.domain.authz.Permission;
import org.rhq.enterprise.server.authz.AuthorizationManagerLocal;
import org.rhq.enterprise.server.perspective.activator.LicenseFeature;
import org.rhq.enterprise.server.perspective.activator.context.ActivationContext;
import org.rhq.enterprise.server.perspective.activator.context.ActivationContextScope;
import org.rhq.enterprise.server.system.SystemManagerLocal;
import org.rhq.enterprise.server.util.LookupUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalActivationContext
implements ActivationContext {
    private Subject subject;
    private transient EnumSet<LicenseFeature> licenseFeatures;
    private transient Boolean superuser;
    private transient EnumSet<Permission> globalPermissions;

    public GlobalActivationContext(Subject subject) {
        this.subject = subject;
    }

    @Override
    public ActivationContextScope getScope() {
        return ActivationContextScope.GLOBAL;
    }

    @NotNull
    public EnumSet<LicenseFeature> getLicenseFeatures() {
        if (this.licenseFeatures == null) {
            this.licenseFeatures = EnumSet.noneOf(LicenseFeature.class);
            SystemManagerLocal systemManager = LookupUtil.getSystemManager();
            boolean monitoringEnabled = systemManager.isMonitoringEnabled();
            if (monitoringEnabled) {
                this.licenseFeatures.add(LicenseFeature.MONITORING);
            }
        }
        return this.licenseFeatures;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public boolean isSuperuser() {
        if (this.superuser == null) {
            AuthorizationManagerLocal authorizationManager = LookupUtil.getAuthorizationManager();
            this.superuser = authorizationManager.isSystemSuperuser(this.subject);
        }
        return this.superuser;
    }

    public boolean hasGlobalPermission(Permission permission) {
        return this.isSuperuser() || this.getGlobalPermissions().contains(permission);
    }

    protected EnumSet<Permission> getGlobalPermissions() {
        if (this.globalPermissions == null) {
            AuthorizationManagerLocal authorizationManager = LookupUtil.getAuthorizationManager();
            Set<Permission> perms = authorizationManager.getExplicitGlobalPermissions(this.subject);
            this.globalPermissions = EnumSet.copyOf(perms);
        }
        return this.globalPermissions;
    }
}

