/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.core.jaas;

import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.rhq.enterprise.server.util.LookupUtil;

public class TempSessionLoginModule
extends UsernamePasswordLoginModule {
    private static final Log LOG = LogFactory.getLog(TempSessionLoginModule.class);

    public void initialize(Subject theSubject, CallbackHandler theHandler, Map theSharedState, Map theOptions) {
        super.initialize(theSubject, theHandler, theSharedState, theOptions);
    }

    protected String getUsersPassword() {
        return "";
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        boolean validPassword = false;
        try {
            validPassword = LookupUtil.getSubjectManager().authenticateTemporarySessionPassword(inputPassword);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to authenticate a session password for user [" + this.getUsername() + "]"), (Throwable)e);
        }
        return validPassword;
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        return new Group[]{roles};
    }
}

