package jbosson.example;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.EntityManagerImpl;
import org.hibernate.jmx.StatisticsService;

@Stateless
@Local(ProductService.class)
public class ProductServiceBean implements ProductService{
	
	@PersistenceContext
	private EntityManager em;
	
	@SuppressWarnings("unchecked")
	public List<Product> getProducts() {
		init();
		return em.createQuery("from Product").getResultList();
	}
	
	public Product createProduct(Product p) {
		init();
		em.persist(p);
		return p;
	}
	
	private static final String HIBERNATE_STATISTICS_MBEAN_OBJECTNAME = "Hibernate:application=jbosson-simple,type=statistics";
	
	
	public static boolean done;
	
	public void init() {
		if (!done) {
		    try
		    {
		        Session session;
		        if (em.getDelegate() instanceof EntityManagerImpl) {
		            EntityManagerImpl entityManagerImpl = (EntityManagerImpl) em.getDelegate();
		            session = entityManagerImpl.getSession();
		        } else {
		            session = (Session) em.getDelegate();
		        }
		    	
		       SessionFactory sessionFactory = session.getSessionFactory();
		       
		       ArrayList<MBeanServer> list = MBeanServerFactory.findMBeanServer(null);
		       MBeanServer server = list.get(0);
	
		       ObjectName objectName = new ObjectName(HIBERNATE_STATISTICS_MBEAN_OBJECTNAME);
		       StatisticsService mBean = new StatisticsService();
		       mBean.setSessionFactory(sessionFactory);
		       server.registerMBean(mBean, objectName);
		       sessionFactory.getStatistics().setStatisticsEnabled(true);
		       done = true;
		    }
		    catch ( InstanceAlreadyExistsException iaee )
		    {
		       log.info("Duplicate mbean registration ignored: " + HIBERNATE_STATISTICS_MBEAN_OBJECTNAME);
		    }
		    catch (Exception e)
		    {
		       log.log(Level.WARNING,"Couldn't register hibernate statistics mbean", e);
		    }
		}
	 }	
	
	private static Logger log = Logger.getLogger(ProductServiceBean.class.getName());
	
} 
