/*
 * $Id: www-mib.c 8676 2008-01-17 23:11:17Z ispringer $
 */
/* General includes */
#include <sys/types.h>
 
/* Apache includes */
#include <httpd.h>
#include <http_log.h>
#include <apr_hash.h>
#include <apr_optional.h>

/* SNMP includes */
#include "ucd-snmp-config.h"
#include <asn1.h>
#include <snmp.h>
#include <snmp_api.h>
#include <snmp_agent.h>
#include <snmp_vars.h>

/* module includes */
#include "covalent-snmp-config.h"
#include "snmpcommon/snmpcommon.h"
#include "www-mib.h"
#include "www-mib-services.h"
#include "www-mib-protocol.h"
#include "www-mib-document.h"

/* Generated files containing defined (implemented) request and response types */
#include "www-mib/http-protocol.h"

#ifdef WWW_MIB
int www_protocols_registered = 0;
www_protocol_t *www_protocols = NULL;



/*
 * Function to register a www protocol.
 * USE: By Covalent SNMP to register the default www protocol (HTTP).
 *      By other www protocol modules as optional function to register
 *      their own www protocol.
 */
int
covalent_snmp_www_protocol_register(www_protocol_t *protocol)
{
    /* FIXME: This is totally broken. If the DSO is never unloaded
     * then this struct's next pointer will end up pointing to itself
     * as soon as we hit this function the second time through
     * pre_config, which means we'll get stuck in an infinite loop
     * trying to find the end of the list.
     * This is currently fixed by not calling this function
     * more than once on Win32 [see covalent_snmp_www_protocol_init()] */
    www_protocol_t *ptr;

    if (protocol) {
         protocol->number = www_protocols_registered++;
         if (www_protocols) {
             for (ptr= www_protocols; ptr->next; ptr = ptr->next);
             ptr->next = protocol;
         } else {
             www_protocols = protocol;
         }
     }
     return(0);
}

/*
 * Function that initialises the www protocol registration and
 * adds the www protocol (HTTP).
 * USE: By Covalent SNMP only as pre_config part.
 */
int
covalent_snmp_www_protocol_init()
{
    static www_protocol_t http_protocol = { 0, "HTTP",
            WWW_MIB_TOTAL_HTTP_REQUESTS, http_request_types,
            WWW_MIB_TOTAL_HTTP_RESPONSES, http_response_types, NULL};

#ifdef WIN32
    /* Only define this for Win32 right now because we don't want
     * to affect anything in the Unix code path. */
    static int times_to_run = 1;
    if (times_to_run <= 0) {
        return 0; /* already ran, just continue */
    }
    times_to_run--;
#endif /* WIN32 */

    covalent_snmp_www_protocol_register(&http_protocol);
    
    return(0);
}


/*
 * Function returns the www protocol definition if the requested
 * protocol is registered.
 * Use internal to Covalent SNMP.
 */
www_protocol_t *
get_www_protocol_definition_by_name(char *protocol)
{
www_protocol_t *ptr = NULL;

   if (protocol) {
        for (ptr = www_protocols; ptr; ptr = ptr->next) {
           if(strstr(ptr->protocol, protocol)) {
              break;
           }
        }
    }
    /* If we don't find a matching protocol assume HTTP. */
    return((ptr ? ptr : www_protocols));
}

/*
 * Function returns the www protocol definition if the requested
 * protocol is registered.
 * Use internal to Covalent SNMP.
 */
www_protocol_t *
get_www_protocol_definition_by_number(int protocol)
{
www_protocol_t *ptr;

    for (ptr = www_protocols; ptr; ptr = ptr->next) {
        if(ptr->number == protocol) {
           break;
        }
    }
    /* If we don't find a matching protocol assume HTTP. */
    return((ptr ? ptr : www_protocols));
}



    

int
get_response_type_index(www_protocol_t *protocol, int response_type)
{
int i;

    if (protocol) {
        for (i = 0; (protocol->response_types[i] > 0) ; i++) {
            if(protocol->response_types[i] == response_type) {
                return(i);
            }
        }
    }
    return(-1);
}

const int
get_response_type(www_protocol_t *protocol, int index)
{
    if ((protocol) && (index != -1)) {
        return(protocol->response_types[index]);
    }
    return(0);
}

int
get_request_type_index(www_protocol_t *protocol, const char *method)
{
int i;

    if (protocol) {
        for (i = 0; (protocol->request_types[i]) ; i++) {
            if(!strcmp(protocol->request_types[i], method)) {
                return(i);
            }
        }
    }
    return(-1);
}

const char*
get_request_type(www_protocol_t *protocol, int index)
{
    if ((protocol) && (index != -1)) {
        return(protocol->request_types[index]);
    }
    return(NULL);
}

void init_www_mib(apr_pool_t *p, const char *persdir)
{
    init_www_mib_services();
    init_www_mib_protocol(p);
    init_www_mib_documents(p, persdir);
}

#endif /* WWW_MIB */
