/*
 * RHQ Management Platform
 * Copyright (C) 2005-2008 Red Hat, Inc.
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

/**
 * Tool to create a number of war files to be able to stress the war component.
 * @author Heiko W. Rupp
 *
 */
public class MakeWars {

    private static final String WEB_XML = "<web-app/>";
    private static final String JBOSS_WEB_XML = "<jboss-web><context-root>%root%</context-root></jboss-web>";
    private static final String INDEX_HTML = "<html><head><title>Test</title></head><body><h1>Hello World</h1></body></html>";
    private static String separator = System.getProperty("file.separator");

    /**
     * Start the show; Args are targetdir rootPrefix numFiles.
     * @param args
     */
    public static void main(String[] args) {

        File dir;

        if (args.length != 3) {
            System.err.println("Usage MakeWars <target dir> <root prefix> <number of files>");
            System.exit(1);
        }
        String path = args[0];
        dir = new File(path);
        if (!dir.exists()) {
            System.err.println("Directory " + dir + " does not exist");
            System.exit(2);
        }
        if (!dir.isDirectory()) {
            System.err.println("Path " + dir + " does not denote a directory");
            System.exit(3);
        }

        for (int i = 0; i < Integer.parseInt(args[2]); i++) {
            createWar(dir, args[1], i);
        }
        System.out.println("Done!");

    }

    /**
     * Creates an individual war file. A file is always named 'test'i with i being the
     * i passed in.
     * @param dir Directory to put the file into
     * @param root_prefix prefix for the content root
     * @param i a counter variable used to distinguish generated files.
     */
    private static void createWar(File dir, String root_prefix, int i) {
        try {
            File out = new File(dir + separator + "test" + i + ".war");
            OutputStream os = new FileOutputStream(out);
            JarOutputStream jos = new JarOutputStream(os);

            JarEntry webXml = new JarEntry("WEB-INF/web.xml");
            jos.putNextEntry(webXml);
            jos.write(WEB_XML.getBytes());
            jos.closeEntry();

            JarEntry jbossWebXml = new JarEntry("WEB-INF/jboss-web.xml");
            jos.putNextEntry(jbossWebXml);
            String root = root_prefix + i;
            String cont = JBOSS_WEB_XML.replace("%root%", root);
            jos.write(cont.getBytes());
            jos.closeEntry();

            JarEntry indexHtml = new JarEntry("index.html");
            jos.putNextEntry(indexHtml);
            jos.write(INDEX_HTML.getBytes());
            jos.closeEntry();

            jos.close();
        } catch (Exception e) {
            e.printStackTrace();
            System.exit(255);
        }
    }
}
