/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.builder.RouteBuilder;

/**
 * @version 
 */
public class RouteMustHaveOutputOnExceptionTest extends ContextTestSupport {

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testValid() throws Exception {
        context.addRoutes(new RouteBuilder() {
            @Override
            public void configure() throws Exception {
                from("direct:start")
                    .onException(Exception.class)
                        .maximumRedeliveries(2)
                        .backOffMultiplier(1.5)
                        .handled(true)
                        .delay(1000)
                            .log("Halting for some time")
                            .to("mock:halt")
                        .end()
                    .end()
                    .to("mock:result");
            }
        });
        context.start();
    }

    public void testInValid() throws Exception {
        context.addRoutes(new RouteBuilder() {
            @Override
            public void configure() throws Exception {
                from("direct:start")
                    .onException(Exception.class)
                        .maximumRedeliveries(2)
                        .backOffMultiplier(1.5)
                        .handled(true)
                        .delay(1000)
                            .log("Halting for some time")
                            .to("mock:halt")
                        // end missing
                    .end()
                    .to("mock:result");
            }
        });
        try {
            context.start();
            fail("Should have thrown an exception");
        } catch (FailedToCreateRouteException e) {
            // expected
        }
    }

}
