/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.Date;
import java.util.HashMap;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.AggregateRouteNode;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultRouteNode;
import org.apache.camel.impl.DoCatchRouteNode;
import org.apache.camel.impl.DoFinallyRouteNode;
import org.apache.camel.impl.OnCompletionRouteNode;
import org.apache.camel.impl.OnExceptionRouteNode;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.FinallyDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.processor.Logger;
import org.apache.camel.processor.interceptor.DefaultTraceEventMessage;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TracedRouteNodes;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceInterceptor
extends DelegateProcessor
implements ExchangeFormatter {
    private static final transient Log LOG = LogFactory.getLog(TraceInterceptor.class);
    private static final String JPA_TRACE_EVENT_MESSAGE = "org.apache.camel.processor.interceptor.jpa.JpaTraceEventMessage";
    private Logger logger;
    private Producer traceEventProducer;
    private final ProcessorDefinition node;
    private final Tracer tracer;
    private TraceFormatter formatter;
    private Class<?> jpaTraceEventMessageClass;
    private RouteContext routeContext;

    public TraceInterceptor(ProcessorDefinition node, Processor target, TraceFormatter formatter, Tracer tracer) {
        super(target);
        this.tracer = tracer;
        this.node = node;
        this.formatter = formatter;
        this.logger = tracer.getLogger(this);
        if (tracer.getFormatter() != null) {
            this.formatter = tracer.getFormatter();
        }
    }

    @Override
    public String toString() {
        return "TraceInterceptor[" + this.node + "]";
    }

    public void setRouteContext(RouteContext routeContext) {
        this.routeContext = routeContext;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (!this.tracer.isEnabled() || this.routeContext != null && !this.routeContext.isTracing()) {
            super.proceed(exchange);
            return;
        }
        if (exchange.getProperty("CamelTraceEvent", Boolean.class) != null) {
            super.process(exchange);
            return;
        }
        boolean shouldLog = this.shouldLogNode(this.node) && this.shouldLogExchange(exchange);
        boolean trace = true;
        try {
            TracedRouteNodes traced;
            if (shouldLog) {
                if (exchange.getUnitOfWork() != null) {
                    traced = exchange.getUnitOfWork().getTracedRouteNodes();
                    if (this.node instanceof OnCompletionDefinition || this.node instanceof OnExceptionDefinition) {
                        trace = false;
                    } else if (ProcessorDefinitionHelper.isFirstChildOfType(OnCompletionDefinition.class, this.node)) {
                        this.traceOnCompletion(traced, exchange);
                    } else if (ProcessorDefinitionHelper.isFirstChildOfType(OnExceptionDefinition.class, this.node)) {
                        this.traceOnException(traced, exchange);
                    } else if (ProcessorDefinitionHelper.isFirstChildOfType(CatchDefinition.class, this.node)) {
                        this.traceDoCatch(traced, exchange);
                    } else if (ProcessorDefinitionHelper.isFirstChildOfType(FinallyDefinition.class, this.node)) {
                        this.traceDoFinally(traced, exchange);
                    } else if (ProcessorDefinitionHelper.isFirstChildOfType(AggregateDefinition.class, this.node)) {
                        this.traceAggregate(traced, exchange);
                    } else {
                        traced.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
                    }
                } else if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Cannot trace as this Exchange does not have an UnitOfWork: " + exchange));
                }
            }
            if (shouldLog && trace) {
                this.logExchange(exchange);
                this.traceExchange(exchange);
            }
            if (this.node.getParent() instanceof InterceptDefinition && exchange.getUnitOfWork() != null) {
                traced = exchange.getUnitOfWork().getTracedRouteNodes();
                this.traceIntercept((InterceptDefinition)this.node.getParent(), traced, exchange);
            }
            super.proceed(exchange);
            if (shouldLog && this.tracer.isTraceOutExchanges()) {
                this.logExchange(exchange);
                this.traceExchange(exchange);
            }
        }
        catch (Exception e) {
            if (this.shouldLogException(exchange)) {
                this.logException(exchange, e);
            }
            throw e;
        }
    }

    private void traceOnCompletion(TracedRouteNodes traced, Exchange exchange) {
        traced.addTraced(new OnCompletionRouteNode());
        traced.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
    }

    private void traceOnException(TracedRouteNodes traced, Exchange exchange) throws Exception {
        traced.addTraced(new DefaultRouteNode(traced.getLastNode().getProcessorDefinition(), traced.getLastNode().getProcessor()));
        traced.addTraced(new OnExceptionRouteNode());
        this.logExchange(exchange);
        this.traceExchange(exchange);
        traced.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
    }

    private void traceDoCatch(TracedRouteNodes traced, Exchange exchange) throws Exception {
        traced.addTraced(new DefaultRouteNode(traced.getLastNode().getProcessorDefinition(), traced.getLastNode().getProcessor()));
        traced.addTraced(new DoCatchRouteNode());
        this.logExchange(exchange);
        this.traceExchange(exchange);
        traced.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
    }

    private void traceDoFinally(TracedRouteNodes traced, Exchange exchange) throws Exception {
        traced.addTraced(new DefaultRouteNode(traced.getLastNode().getProcessorDefinition(), traced.getLastNode().getProcessor()));
        traced.addTraced(new DoFinallyRouteNode());
        this.logExchange(exchange);
        this.traceExchange(exchange);
        traced.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
    }

    private void traceAggregate(TracedRouteNodes traced, Exchange exchange) {
        traced.addTraced(new AggregateRouteNode((AggregateDefinition)this.node.getParent()));
        traced.addTraced(new DefaultRouteNode(this.node, super.getProcessor()));
    }

    protected void traceIntercept(InterceptDefinition intercept, TracedRouteNodes traced, Exchange exchange) throws Exception {
        Processor last = intercept.getInterceptedProcessor(traced.getAndIncrementCounter(intercept));
        if (last != null) {
            boolean shouldLog;
            traced.addTraced(new DefaultRouteNode(this.node, last));
            boolean bl = shouldLog = this.shouldLogNode(this.node) && this.shouldLogExchange(exchange);
            if (shouldLog) {
                this.logExchange(exchange);
                this.traceExchange(exchange);
            }
        }
    }

    @Override
    public Object format(Exchange exchange) {
        return this.formatter.format(this, this.getNode(), exchange);
    }

    public ProcessorDefinition<?> getNode() {
        return this.node;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public TraceFormatter getFormatter() {
        return this.formatter;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    protected void logExchange(Exchange exchange) {
        this.logger.process(exchange);
    }

    protected void traceExchange(Exchange exchange) throws Exception {
        if (this.tracer.getDestination() != null || this.tracer.getDestinationUri() != null) {
            Date timestamp = new Date();
            DefaultExchange event = new DefaultExchange(exchange);
            event.setProperty("CamelTraceEventNodeId", this.node.getId());
            event.setProperty("CamelTraceEventTimestamp", timestamp);
            event.setProperty("CamelTraceEventExchange", exchange);
            DefaultTraceEventMessage msg = new DefaultTraceEventMessage(timestamp, this.node, exchange);
            if (this.tracer.isUseJpa()) {
                LOG.trace((Object)"Using class: org.apache.camel.processor.interceptor.jpa.JpaTraceEventMessage for tracing event messages");
                this.loadJpaTraceEventMessageClass(exchange);
                Object jpa = ObjectHelper.newInstance(this.jpaTraceEventMessageClass);
                HashMap<String, Object> options = new HashMap<String, Object>();
                IntrospectionSupport.getProperties(msg, options, null);
                IntrospectionSupport.setProperties(jpa, options);
                IntrospectionSupport.setProperty(jpa, "timestamp", msg.getTimestamp());
                event.getIn().setBody(jpa);
            } else {
                event.getIn().setBody(msg);
            }
            event.setProperty("CamelTraceEvent", Boolean.TRUE);
            try {
                this.getTraceEventProducer(exchange).process(event);
            }
            catch (Exception e) {
                LOG.error((Object)("Error processing trace event (original Exchange will continue): " + event), (Throwable)e);
            }
        }
    }

    private synchronized void loadJpaTraceEventMessageClass(Exchange exchange) {
        if (this.jpaTraceEventMessageClass == null) {
            this.jpaTraceEventMessageClass = exchange.getContext().getClassResolver().resolveClass(JPA_TRACE_EVENT_MESSAGE);
            if (this.jpaTraceEventMessageClass == null) {
                throw new IllegalArgumentException("Cannot find class: org.apache.camel.processor.interceptor.jpa.JpaTraceEventMessage. Make sure camel-jpa.jar is in the classpath.");
            }
        }
    }

    protected void logException(Exchange exchange, Throwable throwable) {
        if (this.tracer.isTraceExceptions()) {
            if (this.tracer.isLogStackTrace()) {
                this.logger.process(exchange, throwable);
            } else {
                this.logger.process(exchange, ", Exception: " + throwable.toString());
            }
        }
    }

    protected boolean shouldLogExchange(Exchange exchange) {
        return this.tracer.isEnabled() && (this.tracer.getTraceFilter() == null || this.tracer.getTraceFilter().matches(exchange));
    }

    protected boolean shouldLogException(Exchange exchange) {
        return this.tracer.isTraceExceptions();
    }

    public boolean shouldTraceOutExchanges() {
        return this.tracer.isTraceOutExchanges();
    }

    protected boolean shouldLogNode(ProcessorDefinition<?> node) {
        if (node == null) {
            return false;
        }
        return this.tracer.isTraceInterceptors() || !(node instanceof InterceptStrategy);
    }

    private synchronized Producer getTraceEventProducer(Exchange exchange) throws Exception {
        if (this.traceEventProducer == null) {
            Endpoint endpoint = this.tracer.getDestination() != null ? this.tracer.getDestination() : exchange.getContext().getEndpoint(this.tracer.getDestinationUri());
            this.traceEventProducer = endpoint.createProducer();
            ServiceHelper.startService(this.traceEventProducer);
        }
        return this.traceEventProducer;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.traceEventProducer = null;
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.traceEventProducer != null) {
            ServiceHelper.stopService(this.traceEventProducer);
        }
    }
}

