/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.impl.DefaultRouteContext;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CollectionStringBuffer;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement
@XmlType(name="expression")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ExpressionDefinition
implements Expression,
Predicate {
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    private String id;
    @XmlValue
    private String expression;
    @XmlTransient
    private Predicate predicate;
    @XmlTransient
    private Expression expressionValue;
    @XmlTransient
    private ExpressionDefinition expressionType;

    public ExpressionDefinition() {
    }

    public ExpressionDefinition(String expression) {
        this.expression = expression;
    }

    public ExpressionDefinition(Predicate predicate) {
        this.predicate = predicate;
    }

    public ExpressionDefinition(Expression expression) {
        this.expressionValue = expression;
    }

    public static String getLabel(List<ExpressionDefinition> expressions) {
        CollectionStringBuffer buffer = new CollectionStringBuffer();
        for (ExpressionDefinition expression : expressions) {
            buffer.append(expression.getLabel());
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getLanguage() != null) {
            sb.append(this.getLanguage()).append("{");
        }
        if (this.getExpression() != null) {
            sb.append(this.getExpression());
        }
        if (this.getPredicate() != null) {
            sb.append(this.getPredicate().toString());
        }
        if (this.getExpressionValue() != null) {
            sb.append(this.getExpressionValue().toString());
        }
        if (this.getLanguage() != null) {
            sb.append("}");
        }
        return sb.toString();
    }

    public Object evaluate(Exchange exchange) {
        return this.evaluate(exchange, Object.class);
    }

    @Override
    public <T> T evaluate(Exchange exchange, Class<T> type) {
        if (this.expressionValue == null) {
            DefaultRouteContext routeContext = new DefaultRouteContext(exchange.getContext());
            this.expressionValue = this.createExpression(routeContext);
        }
        ObjectHelper.notNull(this.expressionValue, "expressionValue");
        return this.expressionValue.evaluate(exchange, type);
    }

    public void assertMatches(String text, Exchange exchange) throws AssertionError {
        if (!this.matches(exchange)) {
            throw new AssertionError((Object)(text + this.getExpression() + " for exchange: " + exchange));
        }
    }

    @Override
    public boolean matches(Exchange exchange) {
        if (this.predicate == null) {
            DefaultRouteContext routeContext = new DefaultRouteContext(exchange.getContext());
            this.predicate = this.createPredicate(routeContext);
        }
        ObjectHelper.notNull(this.predicate, "predicate");
        return this.predicate.matches(exchange);
    }

    public String getLanguage() {
        return "";
    }

    public Predicate createPredicate(RouteContext routeContext) {
        if (this.predicate == null) {
            if (this.expressionType != null) {
                this.predicate = this.expressionType.createPredicate(routeContext);
            } else if (this.expressionValue != null) {
                this.predicate = PredicateBuilder.toPredicate(this.expressionValue);
            } else if (this.getExpression() != null) {
                ObjectHelper.notNull("language", this.getLanguage());
                CamelContext camelContext = routeContext.getCamelContext();
                Language language = camelContext.resolveLanguage(this.getLanguage());
                this.predicate = language.createPredicate(this.getExpression());
                this.configurePredicate(routeContext, this.predicate);
            }
        }
        return this.predicate;
    }

    public Expression createExpression(RouteContext routeContext) {
        if (this.expressionValue == null) {
            if (this.expressionType != null) {
                this.expressionValue = this.expressionType.createExpression(routeContext);
            } else if (this.getExpression() != null) {
                ObjectHelper.notNull("language", this.getLanguage());
                CamelContext camelContext = routeContext.getCamelContext();
                Language language = camelContext.resolveLanguage(this.getLanguage());
                this.expressionValue = language.createExpression(this.getExpression());
                this.configureExpression(routeContext, this.expressionValue);
            }
        }
        return this.expressionValue;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public Expression getExpressionValue() {
        return this.expressionValue;
    }

    protected void setExpressionValue(Expression expressionValue) {
        this.expressionValue = expressionValue;
    }

    public ExpressionDefinition getExpressionType() {
        return this.expressionType;
    }

    public String getLabel() {
        String language = this.getExpression();
        if (ObjectHelper.isEmpty(language)) {
            Predicate predicate = this.getPredicate();
            if (predicate != null) {
                return predicate.toString();
            }
            Expression expressionValue = this.getExpressionValue();
            if (expressionValue != null) {
                return expressionValue.toString();
            }
        } else {
            return language;
        }
        return "";
    }

    protected void setExpressionType(ExpressionDefinition expressionType) {
        this.expressionType = expressionType;
    }

    protected void configurePredicate(RouteContext routeContext, Predicate predicate) {
    }

    protected void configureExpression(RouteContext routeContext, Expression expression) {
    }

    protected void setProperty(Object bean, String name, Object value) {
        try {
            IntrospectionSupport.setProperty(bean, name, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to set property " + name + " on " + bean + ". Reason: " + e, e);
        }
    }
}

