/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.List;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.impl.DefaultRoute;
import org.apache.camel.management.InstrumentationProcessor;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDrivenConsumerRoute
extends DefaultRoute {
    private final Processor processor;
    private Consumer consumer;

    public EventDrivenConsumerRoute(RouteContext routeContext, Endpoint endpoint, Processor processor) {
        super(routeContext, endpoint);
        this.processor = processor;
    }

    @Override
    public String toString() {
        return "EventDrivenConsumerRoute[" + this.getEndpoint() + " -> " + this.processor + "]";
    }

    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    protected void addServices(List<Service> services) throws Exception {
        Processor processor;
        Endpoint endpoint = this.getEndpoint();
        this.consumer = endpoint.createConsumer(this.processor);
        if (this.consumer != null) {
            services.add(this.consumer);
        }
        if ((processor = this.getProcessor()) instanceof Service) {
            services.add((Service)((Object)processor));
        }
    }

    @Override
    public Navigate<Processor> navigate() {
        Processor answer = this.getProcessor();
        if (answer instanceof InstrumentationProcessor) {
            answer = ((InstrumentationProcessor)answer).getProcessor();
        }
        if (answer instanceof Navigate) {
            return (Navigate)((Object)answer);
        }
        return null;
    }

    @Override
    public Consumer getConsumer() {
        return this.consumer;
    }
}

