/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.concurrent.ExecutorService;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.processor.WireTapProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.concurrent.ExecutorServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="wireTap")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WireTapDefinition
extends SendDefinition<WireTapDefinition>
implements ExecutorServiceAwareDefinition<ProcessorDefinition> {
    @XmlTransient
    private Processor newExchangeProcessor;
    @XmlAttribute(name="processorRef")
    private String newExchangeProcessorRef;
    @XmlElement(name="body")
    private ExpressionSubElementDefinition newExchangeExpression;
    @XmlTransient
    private ExecutorService executorService;
    @XmlAttribute
    private String executorServiceRef;
    @XmlAttribute
    private Boolean copy;

    public WireTapDefinition() {
    }

    public WireTapDefinition(String uri) {
        this.setUri(uri);
    }

    public WireTapDefinition(Endpoint endpoint) {
        this.setEndpoint(endpoint);
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        Endpoint endpoint = this.resolveEndpoint(routeContext);
        this.executorService = ExecutorServiceHelper.getConfiguredExecutorService(routeContext, "WireTap", this);
        if (this.executorService == null) {
            this.executorService = routeContext.getCamelContext().getExecutorServiceStrategy().newDefaultThreadPool(this, "WireTap");
        }
        WireTapProcessor answer = new WireTapProcessor(endpoint, this.getPattern(), this.executorService);
        if (this.isCopy() == null) {
            answer.setCopy(true);
        } else {
            answer.setCopy(this.isCopy());
        }
        if (this.newExchangeProcessorRef != null) {
            this.newExchangeProcessor = routeContext.lookup(this.newExchangeProcessorRef, Processor.class);
        }
        answer.setNewExchangeProcessor(this.newExchangeProcessor);
        if (this.newExchangeExpression != null) {
            answer.setNewExchangeExpression(this.newExchangeExpression.createExpression(routeContext));
        }
        return answer;
    }

    @Override
    public ExchangePattern getPattern() {
        return ExchangePattern.InOnly;
    }

    public String toString() {
        return "WireTap[" + this.getLabel() + "]";
    }

    @Override
    public String getShortName() {
        return "wireTap";
    }

    @Override
    public ProcessorDefinition executorService(ExecutorService executorService) {
        throw new UnsupportedOperationException("wireTap does not support these builder methods");
    }

    @Override
    public ProcessorDefinition executorServiceRef(String executorServiceRef) {
        throw new UnsupportedOperationException("wireTap does not support these builder methods");
    }

    public Processor getNewExchangeProcessor() {
        return this.newExchangeProcessor;
    }

    public void setNewExchangeProcessor(Processor processor) {
        this.newExchangeProcessor = processor;
    }

    public String getNewExchangeProcessorRef() {
        return this.newExchangeProcessorRef;
    }

    public void setNewExchangeProcessorRef(String ref) {
        this.newExchangeProcessorRef = ref;
    }

    public ExpressionSubElementDefinition getNewExchangeExpression() {
        return this.newExchangeExpression;
    }

    public void setNewExchangeExpression(ExpressionSubElementDefinition expression) {
        this.newExchangeExpression = expression;
    }

    public void setNewExchangeExpression(Expression expression) {
        this.newExchangeExpression = new ExpressionSubElementDefinition(expression);
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorServiceRef;
    }

    @Override
    public void setExecutorServiceRef(String executorServiceRef) {
        this.executorServiceRef = executorServiceRef;
    }

    public Boolean isCopy() {
        return this.copy;
    }

    public void setCopy(Boolean copy) {
        this.copy = copy;
    }
}

