/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertiesParser
implements PropertiesParser {
    protected final transient Log log = LogFactory.getLog(this.getClass());

    @Override
    public String parseUri(String text, Properties properties, String prefixToken, String suffixToken) throws IllegalArgumentException {
        String answer = text;
        boolean done = false;
        ArrayList<String> visited = new ArrayList<String>();
        while (!done) {
            ArrayList<String> replaced = new ArrayList<String>();
            answer = this.doParseUri(answer, properties, replaced, prefixToken, suffixToken);
            for (String replace : replaced) {
                if (!visited.contains(replace)) continue;
                throw new IllegalArgumentException("Circular reference detected with key [" + replace + "] in uri " + text);
            }
            visited.addAll(replaced);
            done = !answer.contains(prefixToken);
        }
        return answer;
    }

    @Override
    public String parsePropertyValue(String value) {
        return value;
    }

    private String doParseUri(String uri, Properties properties, List<String> replaced, String prefixToken, String suffixToken) {
        StringBuilder sb = new StringBuilder();
        int pivot = 0;
        int size = uri.length();
        while (pivot < size) {
            int endIdx;
            int idx = uri.indexOf(prefixToken, pivot);
            if (idx < 0) {
                sb.append(this.createConstantPart(uri, pivot, size));
                break;
            }
            if (pivot < idx) {
                sb.append(this.createConstantPart(uri, pivot, idx));
            }
            if ((endIdx = uri.indexOf(suffixToken, pivot = idx + prefixToken.length())) < 0) {
                throw new IllegalArgumentException("Expecting " + suffixToken + " but found end of string for uri: " + uri);
            }
            String key = uri.substring(pivot, endIdx);
            String part = this.createPlaceholderPart(key, properties, replaced);
            if (part == null) {
                throw new IllegalArgumentException("Property with key [" + key + "] not found in properties for uri: " + uri);
            }
            sb.append(part);
            pivot = endIdx + suffixToken.length();
        }
        return sb.toString();
    }

    private String createConstantPart(String uri, int start, int end) {
        return this.parsePropertyValue(uri.substring(start, end));
    }

    private String createPlaceholderPart(String placeholderPart, Properties properties, List<String> replaced) {
        replaced.add(placeholderPart);
        String propertyValue = System.getProperty(placeholderPart);
        if (propertyValue != null) {
            this.log.info((Object)("Found a JVM system property: " + placeholderPart + ". Overriding property set via Property Location"));
        } else {
            propertyValue = properties.getProperty(placeholderPart);
        }
        return this.parsePropertyValue(propertyValue);
    }
}

