/*
 * $Id: mesa.c,v 0.69 1995/04/20 22:16:31 zhao Exp $
 *
 *
 *   A sample implementation of a Mesa/X canvas. 
 *    See ../DEMOS/mesa.c for an example of its use
 *
 *   The object file in libforms.a is compiled with Mesa 1.1.4.
 *   If you're using 1.1.2, you should remove mesa.o from libforms.a 
 *   and define MESA112 here and re-compile this file.
 *
 */

#include "forms.h"
#include "GL/xmesa.h"
#include "GL/gl.h"

static int
mesa_activate(FL_OBJECT * ob)
{
    XMesaContext context;
    int rgb = fl_vmode == TrueColor && fl_state[fl_vmode].depth >= 24;

#ifdef MESA112
    context = XMesaCreateContext(fl_display, FL_ObjWin(ob),
				 rgb,
				 ob->double_buffer,	/* double buffering */
				 FL_FALSE);
#else
    context = XMesaCreateContext(fl_display, fl_state[fl_vmode].xvinfo,
                                 rgb,
                                 ob->double_buffer,
                                 GL_FALSE);
#endif


    if (!context)
    {
	fprintf(stderr, "Can't attatch Mesa context!\n");
	return -1;
    }

    ob->u_vdata = context;

#ifndef MESA112
    XMesaBindWindow( context, FL_ObjWin(ob));
#endif
    XMesaMakeCurrent(context);

    return 0;
}


static int
mesa_cleanup(FL_OBJECT * ob)
{
    XMesaDestroyContext(ob->u_vdata);
    return 0;
}


FL_OBJECT *
fl_create_mesacanvas(int type, FL_Coord x, FL_Coord y, FL_Coord w, FL_Coord h,
		     const char *label)
{
    FL_OBJECT *ob = fl_create_canvas(type, x, y, w, h, label);
    fl_modify_canvas_prop(ob, 0, mesa_activate, mesa_cleanup);
    return ob;
}


FL_OBJECT *
fl_add_mesacanvas(int type, FL_Coord x, FL_Coord y, FL_Coord w, FL_Coord h,
		  const char *label)
{
    FL_OBJECT *ob = fl_create_mesacanvas(type, x, y, w, h, label);
    fl_add_object(fl_current_form, ob);
    return ob;
}
