/* Demo showing object gravity, form minsize etc. (also double click) */

#define WWW_BROWSER "mosaic"

#include "forms.h"
/* Header file generated with fdesign. */
/**** Forms and Objects ****/
typedef struct {
	FL_FORM *www;
	FL_OBJECT *listbr;
	FL_OBJECT *cat;
	FL_OBJECT *file;
	FL_OBJECT *shown;
	FL_OBJECT *miscgrp;
	FL_OBJECT *butgrp;
	void *vdata;
	long ldata;
} FD_www;

extern FD_www * create_form_www(void);

/* Application program begins */

#define MAX_SITES 30

typedef struct
{
    char *cat;
    char *sites[MAX_SITES][2];
} WWW;

/* real program should have these on disks */
static WWW www_sites[] =
{
    /* all X related stuff */
    {
	"X related",
	{"@b@C4XForms Home Page","http://bragg.phys.uwm.edu/xforms",
	 "X Journal", "http://landru.unx.com/SIGS/TXJ/docs/txjhome.html",
	 "X Archive Site","ftp://ftp.x.org",
	 "OpenGL and X", "http://www.sgi.com/Technology/openGL/opengl.html",
	 0}
    },

    /* useful FAQS */
    {
	"All FAQs",
	{"Usenet FAQs", "http://www.cis.ohio-state.edu/hypertext/faq/usenet",
	 "X Wideget FAQ", "http://www.wri.com/~cwikla/widget",
	 0}
    },

    /* Sports related www sites */
    {
	"Sports",
	{"SatchelSports","http://www.starwave.com/SatchelSports.html",
	 "Game Recap", "http://www.starwave.com/SatchelSports.html",
	 "Patricia's NBA Daily News","http://www.primenet.com/~terra/news.html",
	 "Houston Rockets","http://hyrax.med.uth.tmc.edu/misc/rockets.html",
	 0
	}
    },

    /* money */
    {
	"Financial",
	{"@f Holt Report","ftp://ftp.netcom.com/pub/ge/geoholt/holt_rpt.htm",
	0
	}
    },

    {
       "Travel",
       {"New York","http://www.panix.com/clay/nyc.html",
       0
       }
    },

    /* things that do not belong to any of the above */
    {
	"Misc",
	{
	  "Star Trek: Voyager","http://voyager.paramount.com",
 	0
	}
    },

    /* sentinel */

    {0}
};

FD_www *ui;
static show_sites;


/* initialize and show how many categories we have got */
void 
init_cat(void)
{
    WWW *www = www_sites;

    for (; www->cat; www++)
	fl_addto_choice(ui->cat, www->cat);
}

/* initialize file menu */
void 
init_file_menu(void)
{
    fl_addto_menu(ui->file, " Save | Load | Quit ");
}

/* initialize sites given category cat */
void 
init_sites(int cat)
{
    WWW *www = www_sites + cat - 1;
    int i;

    if (cat <= 0)
	return;

    /* cat changed. Update sites */
    fl_freeze_form(ui->www);
    fl_clear_browser(ui->listbr);
    for (i = 0; www->sites[i][0]; i++)
	fl_addto_browser(ui->listbr, www->sites[i][show_sites]);
    fl_unfreeze_form(ui->www);
}

/* new catogrey is selected */
void 
change_cat(FL_OBJECT * ob, long data)
{
    init_sites(fl_get_choice(ob));
}

/* we can show either the subject a site carries or the site name*/
void init_shown(void)
{
    fl_addto_choice(ui->shown, "Subject|Sites");
}

/* request a change of what is shown, site name or subject */ 
void 
change_shown(FL_OBJECT * ob, long data)
{
    int oldshow = show_sites;
    if ((show_sites = fl_get_choice(ob) == 2) != oldshow)
	init_sites(fl_get_choice(ui->cat));
}

/* file menu is selected. Currently we do nothing except exit */ 
void 
do_file_menu(FL_OBJECT * ob, long data)
{
      if(fl_get_menu(ob)== 3)
        exit(1);
      else
        fl_show_alert("Sorry","Not implemented yet","", 0);
}

/* give category, cat, and the line no. within the browser, get sitename*/
char *
get_site(int cat, int thesite)
{
    return www_sites[cat - 1].sites[thesite - 1][1];
}

/* since browser does not currently support double clicks, we fake it here
 * You can also use fl_last_event to get the interval between two clicks */

#include <sys/time.h>
static long lastsec, lastusec;
static struct timeval tp;
static struct timezone tzp;

static void 
reset_time(void)
{
    gettimeofday(&tp, &tzp);
    lastsec = tp.tv_sec;
    lastusec = tp.tv_usec;
}

/* measured in sec */
float 
time_passed(void)
{
    gettimeofday(&tp, &tzp);
    return (float) (tp.tv_sec - lastsec) + 0.000001 * (tp.tv_usec - lastusec);
}

/* either double-clicked or connect button is pressed */
void 
connect_cb(FL_OBJECT * ob, long data)
{
    char cmdbuf[1024];
    int i;

    if ((i = fl_get_browser(ui->listbr)) > 0)
    {
        reset_time();
	fl_set_cursor(ui->www->window, XC_watch);
	XFlush(fl_get_display());
	sprintf(cmdbuf, "%s %s", WWW_BROWSER, get_site(fl_get_choice(ui->cat), i));
	system(cmdbuf);
	fl_reset_cursor(ui->www->window);
    }
}

void 
change_sites(FL_OBJECT * ob, long data)
{
    static int lasti = -1;
    int i;

    i = fl_get_browser(ob);
    if (i == lasti && time_passed() < 0.5)
	connect_cb(0, 0);
    else
    {
	lasti = i;
	reset_time();
    }
}

int 
main(int argc, char *argv[])
{
    fl_initialize(argv[0], "WWWLauncher", 0, 0, &argc, argv);

    ui = create_form_www();

    /* some basic resizing policy */
    fl_set_form_minsize(ui->www, 320, 330);
    fl_set_object_resize(ui->listbr,0, NorthWestGravity, SouthEastGravity);
    fl_set_object_resize(ui->miscgrp,FL_RESIZE_X, NorthGravity, NorthGravity); 
    fl_set_object_resize(ui->butgrp,0, NorthEastGravity, NorthEastGravity); 

    init_file_menu();
    init_cat();
    init_sites(1);
    init_shown();
    reset_time();
    fl_show_form(ui->www, FL_PLACE_CENTER|FL_FREE_SIZE, 
                          FL_FULLBORDER, "www launcher");
    fl_do_forms();
    return 0;
}


/*****************************************************/
/* Form definition file generated with fdesign. */

FD_www *create_form_www(void)
{
  FL_OBJECT *obj;
  FD_www *fdui = fl_calloc(1, sizeof(FD_www));

  fdui->www = fl_bgn_form(FL_NO_BOX, 320, 330);
  obj = fl_add_box(FL_UP_BOX,0,0,320,330,"");
  fdui->listbr = obj = fl_add_browser(FL_HOLD_BROWSER,15,20,210,220,"");
    fl_set_object_callback(obj,change_sites,0);
    fl_set_browser_fontsize(obj,FL_NORMAL_FONT);
    fl_set_object_resize(obj, FL_RESIZE_ALL, WestGravity, SouthEastGravity);

  fdui->miscgrp = fl_bgn_group();
  fdui->file = obj = fl_add_menu(FL_PULLDOWN_MENU,15,295,70,20,"File");
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj,do_file_menu,0);
  fdui->cat = obj = fl_add_choice(FL_DROPLIST_CHOICE,15,255,95,20,"");
    fl_set_object_callback(obj,change_cat,0);
  fdui->shown = obj = fl_add_choice(FL_DROPLIST_CHOICE,120,255,95,20,"");
    fl_set_object_callback(obj,change_shown,0);
  obj = fl_add_text(FL_NORMAL_TEXT,10,285,300,15,"@DnLine");
    fl_set_object_boxtype(obj,FL_NO_BOX);
  fl_end_group();

  fdui->butgrp = fl_bgn_group();
  obj = fl_add_button(FL_NORMAL_BUTTON,235,180,75,30,"Done");
  obj = fl_add_button(FL_NORMAL_BUTTON,235,210,75,30,"Connect");
    fl_set_object_callback(obj,connect_cb,0);
  fl_end_group();

  fl_end_form();

  return fdui;
}
/*---------------------------------------*/

