/*
 * OpenGL canvas demo
 */
#include "forms.h"

typedef struct {
	FL_FORM *form;
	FL_OBJECT *canvas;
	FL_OBJECT *done;
	FL_OBJECT *menu;
	FL_OBJECT *butgrp;
	FL_OBJECT *dec;
	void *vdata;
	long ldata;
} FD_fff;

extern FD_fff * create_form_fff(void);

#include "GL/gl.h"

FD_fff *ui;

static int prim = GL_POLYGON ;

#define v3f glVertex3f
static void draw_cube( void )
{
   glColor3f( 1.0, 0.0, 0.0 );
   glBegin( prim );
   v3f( 1.0, 1.0, 1.0 );   v3f( 1.0, -1.0, 1.0 );
   v3f( 1.0, -1.0, -1.0 ); v3f( 1.0, 1.0, -1.0 );
   glEnd();

   glBegin( prim );
   v3f( -1.0, 1.0, 1.0 );   v3f( -1.0, 1.0, -1.0 );
   v3f( -1.0, -1.0, -1.0 ); v3f( -1.0, -1.0, 1.0 );
   glEnd();

   glColor3f( 0.0, 1.0, 0.0 );
   glBegin( prim );
   v3f(  1.0, 1.0,  1.0 ); v3f(  1.0, 1.0, -1.0 );
   v3f( -1.0, 1.0, -1.0 ); v3f( -1.0, 1.0,  1.0 );
   glEnd();

   glBegin( prim );
   v3f(  1.0, -1.0,  1.0 ); v3f( -1.0, -1.0,  1.0 );
   v3f( -1.0, -1.0, -1.0 ); v3f(  1.0, -1.0, -1.0 );
   glEnd();

   glColor3f( 0.0, 0.0, 1.0 );
   glBegin( prim );
   v3f(  1.0,  1.0,  1.0 ); v3f( -1.0,  1.0,  1.0 );
   v3f( -1.0, -1.0,  1.0 ); v3f(  1.0, -1.0,  1.0 );
   glEnd();

   glBegin( prim );
   v3f(  1.0, 1.0, -1.0 ); v3f(  1.0,-1.0, -1.0 );
   v3f( -1.0,-1.0, -1.0 ); v3f( -1.0, 1.0, -1.0 );
   glEnd();
}

int
idle_cb(XEvent *ev, void *data)
{
    static GLfloat xrot, yrot, zrot;

    glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    glPushMatrix();

    glRotatef( xrot, 1.0, 0.0, 0.0 );
    glRotatef( yrot, 0.0, 1.0, 0.0 );
    glRotatef( zrot, 0.0, 0.0, 1.0 );
    glTranslatef(-1.0,1.2,-0.5); 

    draw_cube();

    glPopMatrix();

    glFinish();

    if(ev)
    {
       xrot += 10.0;
       yrot += 7.0;
       zrot -= 3.0;
    }
    glXSwapBuffers(fl_display, fl_get_canvas_id(ui->canvas));
    return 0;
}

int
canvas_expose(FL_OBJECT *ob, Window win, int w, int h, XEvent *xev, void *ud)
{

    glViewport(0,0, (GLint)w, (GLint)h);
    glClearColor(0.0,0.0,0.0,0.0);

    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    glFrustum( -1.0, 1.0,  -1.0, 1.0,  1.0, 10.0 ); 
    glTranslatef( 0.0, 0.0, -5.0 );  

    glMatrixMode( GL_MODELVIEW ); 
    glLoadIdentity();
    glCullFace( GL_BACK );
    glEnable( GL_CULL_FACE ); 

    glShadeModel( GL_FLAT );

    /* refresh */
    idle_cb(0, 0);
    return 0;
}


int
buttonpress_cb(FL_OBJECT *ob, Window win, int w, int h, XEvent *xev, void *ud)
{
   static suspended;
   suspended = (suspended + 1) %2;
   fl_set_idle_callback(suspended ? 0:idle_cb,0);
   return 0;
}

void
switch_primitive(FL_OBJECT *ob, long data)
{
    static primitive[] = { GL_POLYGON, GL_LINE_LOOP};
    static int i ;
    prim = primitive[++i%2];
}


void
menu_cb(FL_OBJECT *ob, long data)
{
}

int main(int argc, char *argv[])
{

   FL_OBJECT *ob;

   fl_initialize(argv[0], "FormDemo", 0, 0, &argc, argv);
   ui = create_form_fff();

   /* fill-in form initialization code */
   fl_addto_menu(ui->menu,"Item1|Item2|Item3|Item4");

   fl_add_canvas_handler(ui->canvas, Expose, canvas_expose, 0);
   fl_add_canvas_handler(ui->canvas, ButtonPress, buttonpress_cb, 0);
   fl_set_idle_callback(idle_cb, 0);

   /* geometry stuff */
   fl_set_form_minsize(ui->form, 340, 280);

   fl_show_form(ui->form,FL_PLACE_CENTER|FL_FREE_SIZE,FL_FULLBORDER,
               "OpenGL Canvas");

   /* select button press mask */
   fl_addto_selected_xevent(FL_ObjWin(ui->canvas), ButtonPressMask);

   while((ob = fl_do_forms()) != ui->done)
       ;
   return 0;
}

/* Form definition file generated with fdesign. */


FD_fff *create_form_fff(void)
{
  FL_OBJECT *obj;
  FD_fff *fdui = (FD_fff *) fl_calloc(1, sizeof(FD_fff));

  fdui->form = fl_bgn_form(FL_NO_BOX, 340, 280);
  obj = fl_add_box(FL_UP_BOX,0,0,340,280,"");
  fdui->canvas = obj = fl_add_glcanvas(FL_NORMAL_CANVAS,20,20,220,215,"");
  fl_set_object_resize(obj, 0, NorthWestGravity, SouthEastGravity);
  fdui->done = obj = fl_add_button(FL_NORMAL_BUTTON,255,20,70,30,"Done");
    fl_set_button_shortcut(obj,"Dd",1);
    fl_set_object_resize(obj, 0, SouthEastGravity, SouthEastGravity);
  fdui->menu = obj = fl_add_menu(FL_PULLDOWN_MENU,20,245,70,20,"Canvas");
    fl_set_object_boxtype(obj,FL_FLAT_BOX);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
    fl_set_object_callback(obj,menu_cb,0);
    fl_set_object_resize(obj, 0, NorthWestGravity, ForgetGravity);

  fdui->butgrp = fl_bgn_group();
  obj = fl_add_button(FL_NORMAL_BUTTON,255,205,70,30,"Poly/Line");
    fl_set_object_callback(obj,switch_primitive,0);
  fl_end_group();
  fl_set_object_resize(fdui->butgrp, 0, NorthEastGravity, NorthEastGravity);

  fl_end_form();
  return fdui;
}

