/* This is a demo that shows the different types of browsers.  */

#include <stdio.h>
#include <string.h>
#include "forms.h"

FL_FORM *form;
FL_OBJECT *br[4], *exitobj, *readout;

void deselect(FL_OBJECT *obj, long arg)
{
  int i;
  for (i=0; i<4; i++) fl_deselect_browser(br[i]);
}

void set_size(FL_OBJECT *obj, long arg)
{
  int i;
  for (i=0; i<4; i++) fl_set_browser_fontsize(br[i],arg);
}

void set_style(FL_OBJECT *obj, long arg)
{
  int i;
  for (i=0; i<4; i++) fl_set_browser_fontstyle(br[i], (int) arg);
}

void create_form(void)
{
  FL_OBJECT *obj;

  form = fl_bgn_form(FL_UP_BOX,700,570);
  readout = fl_add_box(FL_UP_BOX,50,490,600,50,"");
  fl_set_object_lsize(readout,FL_LARGE_SIZE);
  fl_set_object_lstyle(readout,FL_BOLD_STYLE);

  fl_set_object_color(readout,FL_MAGENTA,FL_MAGENTA);
  br[0] = fl_add_browser(FL_NORMAL_BROWSER,20,160,150,290,"NORMAL_BROWSER");
  br[1] = fl_add_browser(FL_SELECT_BROWSER,190,160,150,290,"SELECT_BROWSER");
  br[2] = fl_add_browser(FL_HOLD_BROWSER,360,160,150,290,"HOLD_BROWSER");
    fl_set_object_color(br[2],FL_COL1,FL_GREEN);
  br[3] = fl_add_browser(FL_MULTI_BROWSER,530,160,150,290,"MULTI_BROWSER");
    fl_set_object_color(br[3],FL_COL1,FL_CYAN);
  exitobj = obj = fl_add_button(FL_NORMAL_BUTTON,560,30,120,30,"Exit");
  obj = fl_add_button(FL_NORMAL_BUTTON,560,80,120,30,"Deselect");
    fl_set_object_callback(obj,deselect,0);

  fl_bgn_group();
  obj = fl_add_lightbutton(FL_RADIO_BUTTON,20,80,100,30,"Tiny");
    fl_set_object_lsize(obj,FL_TINY_SIZE);
    fl_set_object_callback(obj,set_size,obj->lsize);
  obj = fl_add_lightbutton(FL_RADIO_BUTTON,130,80,100,30,"Small");
    fl_set_object_lsize(obj,FL_SMALL_SIZE);
    fl_set_object_callback(obj,set_size,obj->lsize);
    fl_set_button(obj,1);
  obj = fl_add_lightbutton(FL_RADIO_BUTTON,240,80,100,30,"Normal");
    fl_set_object_lsize(obj,FL_NORMAL_SIZE);
    fl_set_object_callback(obj,set_size,obj->lsize);
  obj = fl_add_lightbutton(FL_RADIO_BUTTON,350,80,100,30,"Large");
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_callback(obj,set_size,obj->lsize);
  fl_end_group();

  fl_bgn_group();
  obj = fl_add_lightbutton(FL_RADIO_BUTTON,20,30,100,30,"Normal");
    fl_set_object_callback(obj,set_style,FL_NORMAL_STYLE);
    fl_set_button(obj,1);
  obj = fl_add_lightbutton(FL_RADIO_BUTTON,120,30,100,30,"Bold");
    fl_set_object_callback(obj,set_style,FL_BOLD_STYLE);
  obj = fl_add_lightbutton(FL_RADIO_BUTTON,220,30,100,30,"Italic");
    fl_set_object_callback(obj,set_style,FL_ITALIC_STYLE);
  obj = fl_add_lightbutton(FL_RADIO_BUTTON,320,30,100,30,"BoldItalic");
    fl_set_object_callback(obj,set_style,FL_BOLDITALIC_STYLE);
  obj = fl_add_lightbutton(FL_RADIO_BUTTON,420,30,100,30,"Fixed");
    fl_set_object_callback(obj,set_style,FL_FIXED_STYLE);
  fl_end_group();
  fl_end_form();
}

int
main(int argc, char *argv[])
{
  FL_OBJECT *obj;
  int i,j;
  char ttt[80];

  fl_initialize(argv[0], "FormDemo", 0, 0 ,&argc, argv);
  create_form();
  for (i=0; i<4; i++)
    for (j=1; j<=100; j++)
    {
      sprintf(ttt,"Line with qb %3i",j);
      fl_add_browser_line(br[i],ttt);
    }

  fl_show_form(form,FL_PLACE_CENTER,FL_NOBORDER,NULL);

  do
  {
    obj = fl_do_forms();
    if (obj == br[0] || obj == br[1] || obj == br[2] || obj == br[3])
    {
      if (obj == br[0]) sprintf(ttt,"In NORMAL_BROWSER ");
      else if (obj == br[1]) sprintf(ttt,"In SELECT_BROWSER ");
      else if (obj == br[2]) sprintf(ttt,"In HOLD_BROWSER ");
      else if (obj == br[3]) sprintf(ttt,"In MULTI_BROWSER ");
      i = fl_get_browser(obj);
      if (i<0)
        {strcat(ttt,fl_get_browser_line(obj,-i)); strcat(ttt," was deselected.");}
      else
        {strcat(ttt,fl_get_browser_line(obj,i)); strcat(ttt," was selected.");}
      fl_set_object_label(readout,ttt);
    }
  }
  while (obj != exitobj);
  fl_hide_form(form);
  return 0;
}

