proc set_emacs_text_bindings {w} {

  # Set up editing bindings
  bind $w <Control-a> "$w mark set insert {insert linestart}"
  bind $w <Control-e> "$w mark set insert {insert lineend}"
  bind $w <Control-b> "$w mark set insert {insert - 1 chars}"
  bind $w <Control-f> "$w mark set insert {insert + 1 chars}"
  bind $w <Control-p> "$w mark set insert {insert - 1 lines}"
  bind $w <Control-n> "$w mark set insert {insert + 1 lines}"
  bind $w <Control-d> "$w delete insert {insert + 1 chars}"
  bind $w <Control-k> "if \[$w compare insert == {insert lineend}\] {\
                         $w delete insert {insert + 1 chars}\
                       } else {\
                         $w delete insert {insert lineend}\
                       }"
  bind $w <Meta-d> "$w delete insert {insert wordend}"
  bind $w <Meta-p> "$w mark set insert 1.0"
  bind $w <Meta-n> "$w mark set insert end"
  bind $w <Delete> "$w delete {insert - 1 chars} insert"
  bind $w <Home> "$w mark set insert {insert linestart}"
  bind $w <End> "$w mark set insert {insert lineend}"
  bind $w <Left> "$w mark set insert {insert - 1 chars}"
  bind $w <Right> "$w mark set insert {insert + 1 chars}"
  bind $w <Down> "$w mark set insert {insert + 1 lines}"
  bind $w <Up> "$w mark set insert {insert - 1 lines}"
  bind $w <3> "$w insert insert \[selection get\]; $w yview -pickplace insert"
  bind $w <Control-y> "$w insert insert \[selection get\]; $w yview -pickplace insert"
}

proc set_emacs_entry_bindings {w} {

  # Set up editing bindings
  bind $w <Control-a> "$w icursor 0"
  bind $w <Control-e> "$w icursor end"
  bind $w <Control-b> "$w icursor \[expr \[$w index insert\]-1\]"
  bind $w <Control-f> "$w icursor \[expr \[$w index insert\]+1\]"
  bind $w <Control-p> ";"
  bind $w <Control-n> ";"
  bind $w <Control-d> "$w delete insert" 
  bind $w <Control-k> "$w delete insert end"
  bind $w <Meta-d> ";"
  bind $w <Delete> "$w delete \[expr \[$w index insert\] - 1\]"
  bind $w <Home> "$w icursor 0"
  bind $w <End> "$w icursor end"
  bind $w <Left> "$w icursor \[expr \[$w index insert\]-1\]"
  bind $w <Right> "$w icursor \[expr \[$w index insert\]+1\]"
  bind $w <Down> ";"
  bind $w <Up> ";"
  bind $w <3> "$w insert insert \[selection get\]"
  bind $w <Control-y> "$w insert insert \[selection get\]"
}
