# The dialog boxes go here

set clandestine_mode 0
set archive_only_mode 0
set batch_after_install 0
set set_prefix_var ""
set create_source_updates_mode 0
set verify_sum_mode 0
set verify_sum_only_mode 0
set dont_warn_paths 0

proc center_dialog {w {p ""}} {
	
	update idletasks
	if {$p == ""} {
		set p [winfo parent $w]
	}
	set x [expr [winfo width $p]/2 - [winfo reqwidth $w]/2 \
		+ [winfo rootx $p] + [winfo vrootx $p]]
	set y [expr [winfo height $p]/2 - [winfo reqheight $w]/2 \
		+ [winfo rooty $p] + [winfo vrooty $p]]
	wm group $w $p
	wm geometry $w +$x+$y
	wm deiconify $w
}

# The following copyright is included for the following modified
# version of tk_dialog
# Copyright (c) 1992-1993 The Regents of the University of California.
# All rights reserved.
#
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
# CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
#

# tk_dialog:
# This procedure displays a dialog box, waits for a button in the dialog
# to be invoked, then returns the index of the selected button.
# Arguments:
# w -		Window to use for dialog top-level.
# title -	Title to display in dialog's decorative frame.
# text -	Message to display in dialog.
# bitmap -	Bitmap to display in dialog (empty string means none).
# default -	Index of button that is to display the default ring
#		(-1 means none).
# args -	One or more strings to display in buttons across the
#		bottom of the dialog box.

proc rhs_dialog {w title text bitmap default args} {
    global tk_priv

    # 1. Create the top-level window and divide it into top
    # and bottom parts.

    catch {destroy $w}
    toplevel $w -class Dialog
    wm title $w $title
    wm iconname $w Dialog
    frame $w.top -relief raised -bd 1
    pack $w.top -side top -fill both
    frame $w.bot -relief raised -bd 1
    pack $w.bot -side bottom -fill both

    # 2. Fill the top part with bitmap and message.

    message $w.msg -aspect 100000 -text $text -font fixed
    pack $w.msg -in $w.top -side right -expand 1 -fill both -padx 5m -pady 5m
    if {$bitmap != ""} {
	label $w.bitmap -bitmap $bitmap
	pack $w.bitmap -in $w.top -side left -padx 5m -pady 5m
    }

    # 3. Create a row of buttons at the bottom of the dialog.

    set i 0
    foreach but $args {
	button $w.button$i -text $but -command "set tk_priv(button) $i"
	if {$i == $default} {
	    frame $w.default -relief sunken -bd 1
	    raise $w.button$i $w.default
	    pack $w.default -in $w.bot -side left -expand 1 -padx 3m -pady 2m
	    pack $w.button$i -in $w.default -padx 2m -pady 2m \
		    -ipadx 2m -ipady 1m
	    bind $w <Return> "$w.button$i flash; set tk_priv(button) $i"
	} else {
	    pack $w.button$i -in $w.bot -side left -expand 1 \
		    -padx 3m -pady 3m -ipadx 2m -ipady 1m
	}
	incr i
    }

    # 4. Withdraw the window, then update all the geometry information
    # so we know how big it wants to be, then center the window in the
    # display and de-iconify it.

    wm withdraw $w
    center_dialog $w

    # 5. Set a grab and claim the focus too.

    set oldFocus [focus]
    grab $w
    focus $w

    # 6. Wait for the user to respond, then restore the focus and
    # return the index of the selected button.

    tkwait variable tk_priv(button)
    destroy $w
    focus $oldFocus
    return $tk_priv(button)
}

proc rhs_error_dialog {s} {
	rhs_dialog .error "Error" $s error 0 "OK"
}

proc rhs_continue_dialog {s} {
	return [rhs_dialog .error "Notice" $s question 1 "Continue" "Cancel"]
}

proc rhs_yesno_dialog {s c} {
	return [rhs_dialog .error "Notice" $s question $c "Yes" "No"]
}

proc rhs_info_dialog {s} {
    rhs_dialog .error "Info" $s info 0 "OK"
}