NAME

    h2n - Translate host table to name server file format

SYNOPSIS

    h2n -d DOMAIN -n NET [options]

DESCRIPTION

    h2n translates /etc/hosts to DNS files and creates a BIND boot file.
    This tool can be run once or many times.  After converting your host
    table to DNS format, you can manually maintain the DNS files, or you
    can maintain the host table and run h2n each time you modify
    /etc/hosts.  h2n automatically increments the serial number in each DNS
    file when it makes a new one.

    h2n generates files starting with the prefix "db."  These are called
    "db files."  The domain data is stored in a file called db.DOMAIN,
    where DOMAIN is the first label in your domain name (given with the -d
    option).  The address-to-name data is stored in files named db.NET,
    where NET is a network number (given with the -n option).

    Each time h2n is run, it generates the DNS files from scratch.  Any
    changes you manually made to the DNS files are lost.  If you'd like to
    add resource records to a db file generated by h2n, put your RRs in a
    file prefixed with "spcl" instead of "db".  h2n will include this
    file's data by adding a $INCLUDE directive to the end of the db file.

    By default, h2n will generate an MX record with a weight of 10 that
    points to the host itself as the mail exchanger.  MX records can be
    suppressed with -M.  Additional MX records can be added with -m.  To
    suppress generating the default MX record for a host, include "[no
    smtp]" in that host's host table comment.

    By default, h2n will create a boot file, ./boot.cacheonly, for a
    caching only name server.  If either of the -z or -Z options are used,
    h2n creates a boot file, named ./boot.sec.save or ./boot.sec
    respectively, for a secondary name server.

    Options are:

    	-b BOOTFILE
		Use BOOTFILE instead of the default: ./named.boot.

	-c DOMAIN
		Create CNAME records in the default domain for all the
		hosts in DOMAIN.  Including more than one -c option is
		allowed.

	-d DOMAIN
		Your domain name is DOMAIN.

	-e DOMAIN
		Eliminate all lines from the host table with names in
		DOMAIN.  Including more than one -e option is allowed.

	-f FILE
		Command line options are in a file called FILE.  This
		option cannot be used within FILE.

	-h HOST
		Use HOST in the fields of the SOA record that require a
		hostname.  The default is the host on which you run h2n.

	-m WEIGHT:MX-HOST
		Include an MX record for each host in your domain pointing
		to MX-HOST at WEIGHT.  Including more than one -m option is
		allowed.  Example:  -m 10:terminator.movie.edu -m
		20:wormhole

	-n NET[:SUBNETMASK]
		NET is your network number without the trailing zeros.
		Including more than one -n option is allowed.  If
		SUBNETMASK is provided, create data for each subnet of NET.
		Example:  -n 192.249.249 -n 15.15.16:255.255.248.0

	-o REFRESH:RETRY:EXPIRE:MINIMUM
		Change the default SOA values (10800:3600:604800:86400) to
		the values provided.

	-s SERVER
		List SERVER in each domain's NS records.  Including more
		than one -s option is allowed.

	-t      Generate TXT records from the host table comments.  If "[no
		smtp]" appears in a comment, it is ignored.

	-u USER
		Use USER in the SOA mail address instead of root.  USER can
		be a complete mail address as in:  me@a.b.c.

	-w      Generate WKS records that list the SMTP service over the
		TCP protocol if an MX record is also created.

	-z ADDRESS
		Create a boot file, ./boot.sec.save, for a secondary name
		server that lists ADDRESS as the master to load from.  Save
		a copy of the domain data in a backup file.  (This option
		is similar to the -Z option.)

	-C COMMENT-FILE
		Create resource records by using keys in the host table
		comment field as indices into COMMENT-FILE.  COMMENT-FILE
		contains "key:resource record" pairs like:  "720:IN HINFO
		hp9000s720 hp-ux".  When h2n encounters "720" in the
		comment section of the host table, it creates a resource
		record by replacing the "720:"  with the host's canonical
		name.

	-H HOSTFILE
		Use HOSTFILE instead of /etc/hosts.

	-M      Don't generate MX records.

	-N SUBNETMASK
		Apply SUBNETMASK to all network numbers instead of listing
		each subnet with -n.  Specifying a subnet mask with -n
		overrides the -N subnet mask for that network only.

	-Z ADDRESS
		Create a boot file, ./boot.sec, for a secondary name server
		that lists ADDRESS as the master to load from.  Do not save
		a copy of the data in a backup file.  (This option is
		similar to the -z option.)

EXAMPLES

    Create name server data for networks 192.249.249 and 192.253.253 in
    movie.edu.

	h2n -d movie.edu -n 192.249.249 -n 192.253.253

    Create name server data for networks 192.249.249 and 192.253.253 in
    movie.edu.  Eliminate lines in the host table that contain fx.movie.edu
    and include MX records for all hosts pointing to the mail hub,
    postmanrings2x.movie.edu.  Include all of the options in a file.

	h2n -f option_file

    option_file contains the following lines:

	-d movie.edu
	-n 192.249.249
	-n 192.253.253
	-e fx.movie.edu
	-m 50:postmanrings2x.movie.edu
