#pragma pack(2)


/************************/
/***** Header Files *****/
/************************/
#include <Pilot.h>
#include <System/FeatureMgr.h>
#include "prefdb2.h"
#include "freekey2.h"



/***** InitPrefDB *****/
void InitPrefDB( DmOpenRef dbref )
{
	ULong size;
	PrefDBRecord* rec;
	VoidHand recHand;
	VoidPtr recPtr;
	UInt at=0;
	int i;

	size = sizeof( PrefDBRecord );
	rec = (PrefDBRecord*) MemPtrNew( size );

	rec->modState = 0;
	rec->keymap = HackKeymapQWERTY;
	rec->keyClick = 0;
	rec->lastTime = 0;
	rec->lastKeyDown = 0;
	rec->smartArrow = 0;
	rec->shortcutPending = 0;
	for( i=0; i<kLastLength; i++ )
		rec->lastChars[i] = 0;

	recHand = DmNewRecord( dbref, &at, size );
	recPtr = MemHandleLock( recHand );
	DmWrite( recPtr, 0, rec, size );
	MemHandleUnlock( recHand );
	DmReleaseRecord( dbref, at, true );

	MemPtrFree( rec );
}



/***** OpenPrefDB *****/
DmOpenRef OpenPrefDB( void )
{
	DmOpenRef dbref;
	int err;

	dbref = DmOpenDatabaseByTypeCreator( kPrefDBType, HackCreatorID,
		dmModeReadWrite );
	if( dbref ) return dbref;

	// Try creating a new database
	err = DmCreateDatabase( 0, kPrefDBName, HackCreatorID,
		kPrefDBType, false );
	if( err ) return 0;

	dbref = DmOpenDatabaseByTypeCreator( kPrefDBType, HackCreatorID,
		dmModeReadWrite );
	if( ! dbref ) return 0;

	InitPrefDB( dbref );
	return dbref;
}



/***** ClosePrefDB *****/
void ClosePrefDB( DmOpenRef dmref )
{
	DmCloseDatabase( dmref );
}



/***** ReadPrefDB *****/
void ReadPrefDB( DmOpenRef dmref, PrefDBRecord* into )
{
	VoidHand recHand;
	PrefDBRecord* rec;

	recHand = DmGetRecord( dmref, 0 );
	rec = (PrefDBRecord*) MemHandleLock( recHand );

	MemMove( into, rec, sizeof( PrefDBRecord ) );
	
	MemHandleUnlock( recHand );
	DmReleaseRecord( dmref, 0, false );
}



/***** WritePrefDB *****/
void WritePrefDB( DmOpenRef dmref, PrefDBRecord* from )
{
	VoidHand recHand;
	PrefDBRecord* rec;

	recHand = DmGetRecord( dmref, 0 );
	rec = (PrefDBRecord*) MemHandleLock( recHand );

	DmWrite( rec, 0, from, sizeof( PrefDBRecord ) );
	
	MemHandleUnlock( recHand );
	DmReleaseRecord( dmref, 0, false );
}



/***** GetSerPortID *****/
UInt GetSerPortID( void )
{
	DWord value=0;
	FtrGet( HackCreatorID, HackSerialPortID, &value );
	return value;
}



/***** SetSerPortID *****/
void SetSerPortID( UInt serPortID )
{
	FtrSet( HackCreatorID, HackSerialPortID, serPortID );
}



/***** GetModState *****/
ULong GetModState( void )
{
	DWord value=0;
	FtrGet( HackCreatorID, HackModState, &value );
	return value;
}



/***** SetModState *****/
void SetModState( ULong modState )
{
	FtrSet( HackCreatorID, HackModState, modState );
}



/***** GetKeymap *****/
char GetKeymap( void )
{
	DWord value=0;
	FtrGet( HackCreatorID, HackKeymap, &value );
	return value;
}



/***** SetKeymap *****/
void SetKeymap( char keymap )
{
	FtrSet( HackCreatorID, HackKeymap, keymap );
}



/***** GetKeyClick *****/
char GetKeyClick( void )
{
	DWord value=0;
	FtrGet( HackCreatorID, HackKCOn, &value );
	return value;
}



/***** SetKeyClick *****/
void SetKeyClick( char keyClick )
{
	FtrSet( HackCreatorID, HackKCOn, keyClick );
}



/***** GetLastKeyDown *****/
void GetLastKeyDown( ULong *theTime, char *theChar )
{
	DWord value=0;
	FtrGet( HackCreatorID, HackLastKeydown, &value );
	*theTime = value;
	*theTime >>= 8;
	*theChar = (signed char) value&0xFF;
}



/***** SetLastKeyDown *****/
void SetLastKeyDown( ULong theTime, char theChar )
{
	ULong value,temp;
	theTime &= 0xFFFFFF;
	value = theTime << 8;
	temp = (ULong) theChar;
	temp &= 0xFF;
	value |= temp;
	FtrSet( HackCreatorID, HackLastKeydown, value );
}



/***** GetLastChar *****/
char GetLastChar( void )
{
	DWord value=0;
	FtrGet( HackCreatorID, HackLastChar, &value );
	return value;
}



/***** SetLastChar *****/
void SetLastChar( char lastChar )
{
	FtrSet( HackCreatorID, HackLastChar, lastChar );
}



/***** GetSmartArrow *****/
char GetSmartArrow( void )
{
	return false;
}



/***** SetSmartArrow *****/
void SetSmartArrow( char smartArrow )
{
}



/***** GetShortcutPending *****/
int GetShortcutPending( void )
{
	DWord value=0;
	FtrGet( HackCreatorID, HackSCP, &value );
	return value;
}



/***** SetShortcutPending *****/
void SetShortcutPending( int shortcutPending )
{
	FtrSet( HackCreatorID, HackSCP, shortcutPending );
}



/***** GetLastChars *****/
char* GetLastChars( PrefDBRecord* rec )
{
	return &(rec->lastChars[0]);
}
