'\"
.so man.macros
'----------------------------------------------------------------------
.TH Mwm n 4.0 Tk "Tix Extensions"
.BS
'
'
.SH NAME
Mwm - Communicate with the Motif(tm) window manager.
'
'
'
.SH SYNOPSIS
.PP
\fI$toplevel\fR->\fBMwm\fIOption\fR?(\fIargs\fR)?
.PP
.SH COMMAND OPTIONS
.PP
.TP
\fI$toplevel\fR->\fBMwmDecoration\fR?(?option?\fR=>?value? ?...?\fR)? 

When no options are given, this command returns the values of all the
decorations options for the toplevel window with the $widget\fR.

When only one option is given without specifying the value, the
current value of that option is returned.

When more than one "option value" pairs are passed to this command,
the specified values will be assigned to the corresponding options. As
a result, the appearance of the Motif decorations around the toplevel
window will be changed.

Possible options are: \fB-border\fR, \fB-menu\fR, \fB-maximize\fR,
\fB-minimize\fR, \fB-resizeh\fR and \fB-title\fR. The value must be a
Boolean value. The values returned by this command are undefined when
the window is not managed by mwm.
'
'
.TP
\fI$toplevel\fR->\fBMwmIsmwmrunning\fR
This returns true if mwm is running on the screen where the specified
window is located, false otherwise.
'
'
.TP
\fI$toplevel\fR->\fBMwmProtocol\fR
'
When no additional options are given, this command returns all
protocols associated with this toplevel window.
'
.TP
\fI$toplevel\fR->\fBMwmProtocol\fR(activate => \fIprotocol_name\fR)
'
Activate the mwm protocol message in mwm's menu.
'
.TP
\fI$toplevel\fR->\fBMwmProtocol\fR(add => \fIprotocol_name\fR,"menu_message"\fR)
'
Add a new mwm protocol message for this toplevel window. The
message is identified by the string name specified in
\fIprotocol_name\fR. A menu item will be added into mwm's menu as
specified by \fImenu_message\fR. Once a new mwm protocol message is
added to a toplevel, it can be catched by the TK \fBwm protocol\fR
command. Here is an example:
.nf
$mw->MwmProtocol(add => 'MY_PRINT_HELLO', '"Print Hello"  _H Ctrl<Key>H');
$mw->protocol(MY_PRINT_HELLO => sub {print "Hello"});
.fi
'
.TP
\fI$toplevel\fR->\fBMwmProtocol\fR(deactivate => \fIprotocol_name\fR)
'
Deactivate the mwm protocol message in mwm's menu.
'
.TP
\fI$toplevel\fR->\fBMwmProtocol\fR(delete => \fIprotocol_name\fR)
'
Delete the mwm protocol message from mwm's menu. Please note that the
window manager protocol handler associated with this protocol (by the
\fBwm protocol\fR command) is not deleted automatically. You have to
delete the protocol handle explicitly.  E.g.:
.nf
 $mw->MwmProtocol(delete => 'MY_PRINT_HELLO');
 $mw->protocol(MY_PRINT_HELLO => '');
.fi
'
.PP
.SH BUGS
This is a Tix extension which perl/Tk has adopted. It has not been 
tested as perl/Tk's author has not got round to installing a Motif Window
Manager.
.PP
On some versions of Mwm, the \fB-border\fR will not disappear unless
\fB-resizeh\fR is turned off. Also, the -title will not disappear
unless all of \fB-title\fR, \fB-menu\fR, \fB-maximize\fR and
\fB-minimize\fR are turned off.
'
'
.SH AUTHOR
'
Ioi Kim Lam - ioi@graphics.cis.upenn.edu
'
'
.PP
.SH KEYWORDS
TIX
