/*
 * Simple http (web) server.
 * Jim Rees University of Michigan April 1998
 */

#pragma pack(2)

#include <Common.h>
#include <System/SysAll.h>
#include <System/DataMgr.h>
#include <System/DateTime.h>
#include <UI/UIAll.h>

#include <System/Unix/unix_stdio.h>
#include <System/Unix/unix_stdlib.h>
#include <System/Unix/unix_string.h>

#include "httpd.h"
#include "date.h"

static char monthname[][4] = {
    "Jan", "Feb", "Mar", "Apr", "May", "Jun",
    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};

int send_date_index(int fd)
{
    int i, n;
    DmOpenRef DateDB;
    VoidHand hp;
    ApptDBRecordType *ap;
    char *cp, *desc;

    DateDB = DmOpenDatabaseByTypeCreator('DATA', 'date', dmModeReadOnly);
    if (!DateDB) {
	send_404(fd, "/date/");
	return;
    }

    wrstr(fd, html0, "text/html");
    wrs(fd, "<h1>Datebook</h1>\n");

    for (n = 0; ; n++) {
	hp = DmQueryRecord(DateDB, n);
	if (!hp)
	    break;

	cp = (char *) MemHandleLock(hp);
	ap = (ApptDBRecordType *) cp;
	cp += sizeof (ApptDBRecordType);
	if (ap->flags.alarm)
	    cp += sizeof (AlarmInfoType);
	if (ap->flags.repeat)
	    cp += sizeof (RepeatInfoType);
	if (ap->flags.exceptions)
	    cp += sizeof (ExceptionsListType);
	desc = cp;

	wrstr(fd, "%d-%s-%02d",
	      ap->when.date.year + 1904,
	      monthname[ap->when.date.month - 1],
	      ap->when.date.day);
	if (ap->when.startTime.hours != 255)
	    wrstr(fd, " %2d:%02d", ap->when.startTime.hours, ap->when.startTime.minutes);
	if (ap->flags.description)
	    wrstr(fd, " %s", desc);
	if (ap->flags.note)
	    wrstr(fd, " <a href=\"/date/%d\">note</a>", n);
	wrs(fd, "<br>\n");

	MemPtrUnlock((VoidHand) ap);
    }

    DmCloseDatabase(DateDB);
    wrs(fd, "<p>\n");
    wrs(fd, html_go_home);
}

send_date_file(int fd, char *url)
{
    int n;
    DmOpenRef DateDB;
    VoidHand hp;
    ApptDBRecordType *ap = NULL;
    char *cp, *note, *desc;

    DateDB = DmOpenDatabaseByTypeCreator('DATA', 'date', dmModeReadOnly);
    if (!DateDB)
	goto notfound;

    if (sscanf(url, "/date/%d", &n) != 1)
	goto notfound;

    hp = DmQueryRecord(DateDB, n);
    if (!hp)
	goto notfound;

    cp = (char *) MemHandleLock(hp);
    ap = (ApptDBRecordType *) cp;
    cp += sizeof (ApptDBRecordType);
    if (ap->flags.alarm)
	cp += sizeof (AlarmInfoType);
    if (ap->flags.repeat)
	cp += sizeof (RepeatInfoType);
    if (ap->flags.exceptions)
	cp += sizeof (ExceptionsListType);
    desc = cp;
    cp += strlen(desc) + 1;
    note = cp;

    if (!ap->flags.note)
	goto notfound;

    wrstr(fd, html0, "text/plain");
    wrs(fd, note);
    MemPtrUnlock((VoidHand) ap);
    wrs(fd, "\n");
    DmCloseDatabase(DateDB);
    return;

 notfound:
    if (ap)
	MemPtrUnlock((VoidHand) ap);
    if (DateDB)
	DmCloseDatabase(DateDB);
    send_404(fd, url);
}

/*
copyright 1998
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works
and redistribute this software and such derivative works
for any purpose, so long as the name of the university of
michigan is not used in any advertising or publicity
pertaining to the use or distribution of this software
without specific, written prior authorization.  if the
above copyright notice or any other identification of the
university of michigan is included in any copy of any
portion of this software, then the disclaimer below must
also be included.

this software is provided as is, without representation
from the university of michigan as to its fitness for any
purpose, and without warranty by the university of
michigan of any kind, either express or implied, including
without limitation the implied warranties of
merchantability and fitness for a particular purpose. the
regents of the university of michigan shall not be liable
for any damages, including special, indirect, incidental, or
consequential damages, with respect to any claim arising
out of or in connection with the use of the software, even
if it has been or is hereafter advised of the possibility of
such damages.
*/
