require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_LINUX_NILFS2_ONDISK_H)) {
    eval 'sub _LINUX_NILFS2_ONDISK_H () {1;}' unless defined(&_LINUX_NILFS2_ONDISK_H);
    require 'linux/types.ph';
    require 'linux/magic.ph';
    require 'asm/byteorder.ph';
    eval 'sub NILFS_INODE_BMAP_SIZE () {7;}' unless defined(&NILFS_INODE_BMAP_SIZE);
    eval 'sub i_device_code () { $i_bmap[0];}' unless defined(&i_device_code);
    eval 'sub NILFS_MIN_INODE_SIZE () {128;}' unless defined(&NILFS_MIN_INODE_SIZE);
    eval 'sub NILFS_SR_MDT_OFFSET {
        my($inode_size, $i) = @_;
	    eval q(((0)-> &sr_dat + ($inode_size) * ($i)));
    }' unless defined(&NILFS_SR_MDT_OFFSET);
    eval 'sub NILFS_SR_DAT_OFFSET {
        my($inode_size) = @_;
	    eval q( &NILFS_SR_MDT_OFFSET($inode_size, 0));
    }' unless defined(&NILFS_SR_DAT_OFFSET);
    eval 'sub NILFS_SR_CPFILE_OFFSET {
        my($inode_size) = @_;
	    eval q( &NILFS_SR_MDT_OFFSET($inode_size, 1));
    }' unless defined(&NILFS_SR_CPFILE_OFFSET);
    eval 'sub NILFS_SR_SUFILE_OFFSET {
        my($inode_size) = @_;
	    eval q( &NILFS_SR_MDT_OFFSET($inode_size, 2));
    }' unless defined(&NILFS_SR_SUFILE_OFFSET);
    eval 'sub NILFS_SR_BYTES {
        my($inode_size) = @_;
	    eval q( &NILFS_SR_MDT_OFFSET($inode_size, 3));
    }' unless defined(&NILFS_SR_BYTES);
    eval 'sub NILFS_DFL_MAX_MNT_COUNT () {50;}' unless defined(&NILFS_DFL_MAX_MNT_COUNT);
    eval 'sub NILFS_VALID_FS () {0x1;}' unless defined(&NILFS_VALID_FS);
    eval 'sub NILFS_ERROR_FS () {0x2;}' unless defined(&NILFS_ERROR_FS);
    eval 'sub NILFS_RESIZE_FS () {0x4;}' unless defined(&NILFS_RESIZE_FS);
    eval 'sub NILFS_MOUNT_ERROR_MODE () {0x70;}' unless defined(&NILFS_MOUNT_ERROR_MODE);
    eval 'sub NILFS_MOUNT_ERRORS_CONT () {0x10;}' unless defined(&NILFS_MOUNT_ERRORS_CONT);
    eval 'sub NILFS_MOUNT_ERRORS_RO () {0x20;}' unless defined(&NILFS_MOUNT_ERRORS_RO);
    eval 'sub NILFS_MOUNT_ERRORS_PANIC () {0x40;}' unless defined(&NILFS_MOUNT_ERRORS_PANIC);
    eval 'sub NILFS_MOUNT_BARRIER () {0x1000;}' unless defined(&NILFS_MOUNT_BARRIER);
    eval 'sub NILFS_MOUNT_STRICT_ORDER () {0x2000;}' unless defined(&NILFS_MOUNT_STRICT_ORDER);
    eval 'sub NILFS_MOUNT_NORECOVERY () {0x4000;}' unless defined(&NILFS_MOUNT_NORECOVERY);
    eval 'sub NILFS_MOUNT_DISCARD () {0x8000;}' unless defined(&NILFS_MOUNT_DISCARD);
    eval 'sub NILFS_OS_LINUX () {0;}' unless defined(&NILFS_OS_LINUX);
    eval 'sub NILFS_CURRENT_REV () {2;}' unless defined(&NILFS_CURRENT_REV);
    eval 'sub NILFS_MINOR_REV () {0;}' unless defined(&NILFS_MINOR_REV);
    eval 'sub NILFS_MIN_SUPP_REV () {2;}' unless defined(&NILFS_MIN_SUPP_REV);
    eval 'sub NILFS_FEATURE_COMPAT_RO_BLOCK_COUNT () {0x1;}' unless defined(&NILFS_FEATURE_COMPAT_RO_BLOCK_COUNT);
    eval 'sub NILFS_FEATURE_COMPAT_SUPP () {0;}' unless defined(&NILFS_FEATURE_COMPAT_SUPP);
    eval 'sub NILFS_FEATURE_COMPAT_RO_SUPP () { &NILFS_FEATURE_COMPAT_RO_BLOCK_COUNT;}' unless defined(&NILFS_FEATURE_COMPAT_RO_SUPP);
    eval 'sub NILFS_FEATURE_INCOMPAT_SUPP () {0;}' unless defined(&NILFS_FEATURE_INCOMPAT_SUPP);
    eval 'sub NILFS_SB_BYTES () {((0)-> &s_reserved);}' unless defined(&NILFS_SB_BYTES);
    eval 'sub NILFS_ROOT_INO () {2;}' unless defined(&NILFS_ROOT_INO);
    eval 'sub NILFS_DAT_INO () {3;}' unless defined(&NILFS_DAT_INO);
    eval 'sub NILFS_CPFILE_INO () {4;}' unless defined(&NILFS_CPFILE_INO);
    eval 'sub NILFS_SUFILE_INO () {5;}' unless defined(&NILFS_SUFILE_INO);
    eval 'sub NILFS_IFILE_INO () {6;}' unless defined(&NILFS_IFILE_INO);
    eval 'sub NILFS_ATIME_INO () {7;}' unless defined(&NILFS_ATIME_INO);
    eval 'sub NILFS_XATTR_INO () {8;}' unless defined(&NILFS_XATTR_INO);
    eval 'sub NILFS_SKETCH_INO () {10;}' unless defined(&NILFS_SKETCH_INO);
    eval 'sub NILFS_USER_INO () {11;}' unless defined(&NILFS_USER_INO);
    eval 'sub NILFS_SB_OFFSET_BYTES () {1024;}' unless defined(&NILFS_SB_OFFSET_BYTES);
    eval 'sub NILFS_SEG_MIN_BLOCKS () {16;}' unless defined(&NILFS_SEG_MIN_BLOCKS);
    eval 'sub NILFS_PSEG_MIN_BLOCKS () {2;}' unless defined(&NILFS_PSEG_MIN_BLOCKS);
    eval 'sub NILFS_MIN_NRSVSEGS () {8;}' unless defined(&NILFS_MIN_NRSVSEGS);
    eval 'sub NILFS_ROOT_METADATA_FILE {
        my($ino) = @_;
	    eval q((($ino) >=  &NILFS_DAT_INO  && ($ino) <=  &NILFS_SUFILE_INO));
    }' unless defined(&NILFS_ROOT_METADATA_FILE);
    eval 'sub NILFS_SB2_OFFSET_BYTES {
        my($devsize) = @_;
	    eval q((((($devsize) >> 12) - 1) << 12));
    }' unless defined(&NILFS_SB2_OFFSET_BYTES);
    eval 'sub NILFS_LINK_MAX () {32000;}' unless defined(&NILFS_LINK_MAX);
    eval 'sub NILFS_NAME_LEN () {255;}' unless defined(&NILFS_NAME_LEN);
    eval 'sub NILFS_MIN_BLOCK_SIZE () {1024;}' unless defined(&NILFS_MIN_BLOCK_SIZE);
    eval 'sub NILFS_MAX_BLOCK_SIZE () {65536;}' unless defined(&NILFS_MAX_BLOCK_SIZE);
    eval("sub NILFS_FT_UNKNOWN () { 0; }") unless defined(&NILFS_FT_UNKNOWN);
    eval("sub NILFS_FT_REG_FILE () { 1; }") unless defined(&NILFS_FT_REG_FILE);
    eval("sub NILFS_FT_DIR () { 2; }") unless defined(&NILFS_FT_DIR);
    eval("sub NILFS_FT_CHRDEV () { 3; }") unless defined(&NILFS_FT_CHRDEV);
    eval("sub NILFS_FT_BLKDEV () { 4; }") unless defined(&NILFS_FT_BLKDEV);
    eval("sub NILFS_FT_FIFO () { 5; }") unless defined(&NILFS_FT_FIFO);
    eval("sub NILFS_FT_SOCK () { 6; }") unless defined(&NILFS_FT_SOCK);
    eval("sub NILFS_FT_SYMLINK () { 7; }") unless defined(&NILFS_FT_SYMLINK);
    eval("sub NILFS_FT_MAX () { 8; }") unless defined(&NILFS_FT_MAX);
    eval 'sub NILFS_DIR_PAD () {8;}' unless defined(&NILFS_DIR_PAD);
    eval 'sub NILFS_DIR_ROUND () {( &NILFS_DIR_PAD - 1);}' unless defined(&NILFS_DIR_ROUND);
    eval 'sub NILFS_DIR_REC_LEN {
        my($name_len) = @_;
	    eval q(((($name_len) + 12+  &NILFS_DIR_ROUND) & ~ &NILFS_DIR_ROUND));
    }' unless defined(&NILFS_DIR_REC_LEN);
    eval 'sub NILFS_MAX_REC_LEN () {((1<< 16) - 1);}' unless defined(&NILFS_MAX_REC_LEN);
    eval 'sub NILFS_SEGSUM_MAGIC () {0x1eaffa11;}' unless defined(&NILFS_SEGSUM_MAGIC);
    eval 'sub NILFS_SS_LOGBGN () {0x1;}' unless defined(&NILFS_SS_LOGBGN);
    eval 'sub NILFS_SS_LOGEND () {0x2;}' unless defined(&NILFS_SS_LOGEND);
    eval 'sub NILFS_SS_SR () {0x4;}' unless defined(&NILFS_SS_SR);
    eval 'sub NILFS_SS_SYNDT () {0x8;}' unless defined(&NILFS_SS_SYNDT);
    eval 'sub NILFS_SS_GC () {0x10;}' unless defined(&NILFS_SS_GC);
    eval 'sub NILFS_BTREE_NODE_ROOT () {0x1;}' unless defined(&NILFS_BTREE_NODE_ROOT);
    eval 'sub NILFS_BTREE_LEVEL_DATA () {0;}' unless defined(&NILFS_BTREE_LEVEL_DATA);
    eval 'sub NILFS_BTREE_LEVEL_NODE_MIN () {( &NILFS_BTREE_LEVEL_DATA + 1);}' unless defined(&NILFS_BTREE_LEVEL_NODE_MIN);
    eval 'sub NILFS_BTREE_LEVEL_MAX () {14;}' unless defined(&NILFS_BTREE_LEVEL_MAX);
    eval 'sub NILFS_MIN_DAT_ENTRY_SIZE () {32;}' unless defined(&NILFS_MIN_DAT_ENTRY_SIZE);
    eval 'sub NILFS_MIN_CHECKPOINT_SIZE () {(64+  &NILFS_MIN_INODE_SIZE);}' unless defined(&NILFS_MIN_CHECKPOINT_SIZE);
    eval("sub NILFS_CHECKPOINT_SNAPSHOT () { 0; }") unless defined(&NILFS_CHECKPOINT_SNAPSHOT);
    eval("sub NILFS_CHECKPOINT_INVALID () { 1; }") unless defined(&NILFS_CHECKPOINT_INVALID);
    eval("sub NILFS_CHECKPOINT_SKETCH () { 2; }") unless defined(&NILFS_CHECKPOINT_SKETCH);
    eval("sub NILFS_CHECKPOINT_MINOR () { 3; }") unless defined(&NILFS_CHECKPOINT_MINOR);
    eval 'sub NILFS_CHECKPOINT_FNS {
        my($flag, $name) = @_;
	    eval q( &static  &__inline__  &void  &nilfs_checkpoint_set_$name(\'struct nilfs_checkpoint\' * &cp) {  ($cp->{cp_flags}) =  &__cpu_to_le32( &__le32_to_cpu( ($cp->{cp_flags})) | (1 <<  &NILFS_CHECKPOINT_$flag)); }  &static  &__inline__  &void  &nilfs_checkpoint_clear_$name(\'struct nilfs_checkpoint\' * &cp) {  ($cp->{cp_flags}) =  &__cpu_to_le32( &__le32_to_cpu( ($cp->{cp_flags})) & ~(1 <<  &NILFS_CHECKPOINT_$flag)); }  &static  &__inline__ \'int\'  &nilfs_checkpoint_$name( &const \'struct nilfs_checkpoint\' * &cp) {  &return !!( &__le32_to_cpu( ($cp->{cp_flags})) & (1 <<  &NILFS_CHECKPOINT_$flag)); });
    }' unless defined(&NILFS_CHECKPOINT_FNS);
    eval 'sub NILFS_CPFILE_FIRST_CHECKPOINT_OFFSET () {(($sizeof{\'struct nilfs_cpfile_header\'} + $sizeof{\'struct nilfs_checkpoint\'} - 1) / $sizeof{\'struct nilfs_checkpoint\'});}' unless defined(&NILFS_CPFILE_FIRST_CHECKPOINT_OFFSET);
    eval 'sub NILFS_MIN_SEGMENT_USAGE_SIZE () {16;}' unless defined(&NILFS_MIN_SEGMENT_USAGE_SIZE);
    eval("sub NILFS_SEGMENT_USAGE_ACTIVE () { 0; }") unless defined(&NILFS_SEGMENT_USAGE_ACTIVE);
    eval("sub NILFS_SEGMENT_USAGE_DIRTY () { 1; }") unless defined(&NILFS_SEGMENT_USAGE_DIRTY);
    eval("sub NILFS_SEGMENT_USAGE_ERROR () { 2; }") unless defined(&NILFS_SEGMENT_USAGE_ERROR);
    eval 'sub NILFS_SEGMENT_USAGE_FNS {
        my($flag, $name) = @_;
	    eval q( &static  &__inline__  &void  &nilfs_segment_usage_set_$name(\'struct nilfs_segment_usage\' * &su) {  ($su->{su_flags}) =  &__cpu_to_le32( &__le32_to_cpu( ($su->{su_flags})) | (1 <<  &NILFS_SEGMENT_USAGE_$flag));}  &static  &__inline__  &void  &nilfs_segment_usage_clear_$name(\'struct nilfs_segment_usage\' * &su) {  ($su->{su_flags}) =  &__cpu_to_le32( &__le32_to_cpu( ($su->{su_flags})) & ~(1 <<  &NILFS_SEGMENT_USAGE_$flag)); }  &static  &__inline__ \'int\'  &nilfs_segment_usage_$name( &const \'struct nilfs_segment_usage\' * &su) {  &return !!( &__le32_to_cpu( ($su->{su_flags})) & (1 <<  &NILFS_SEGMENT_USAGE_$flag)); });
    }' unless defined(&NILFS_SEGMENT_USAGE_FNS);
    eval 'sub nilfs_segment_usage_set_clean {
        my($su) = @_;
	    eval q({  ($su->{su_lastmod}) =  &__cpu_to_le64(0);  ($su->{su_nblocks}) =  &__cpu_to_le32(0);  ($su->{su_flags}) =  &__cpu_to_le32(0); });
    }' unless defined(&nilfs_segment_usage_set_clean);
    eval 'sub nilfs_segment_usage_clean {
        my($su) = @_;
	    eval q({ ! &__le32_to_cpu( ($su->{su_flags})); });
    }' unless defined(&nilfs_segment_usage_clean);
    eval 'sub NILFS_SUFILE_FIRST_SEGMENT_USAGE_OFFSET () {(($sizeof{\'struct nilfs_sufile_header\'} + $sizeof{\'struct nilfs_segment_usage\'} - 1) / $sizeof{\'struct nilfs_segment_usage\'});}' unless defined(&NILFS_SUFILE_FIRST_SEGMENT_USAGE_OFFSET);
}
1;
