/*
 * arch/arm/mach-lpc32xx/include/mach/irqs.h
 *
 * Author: Kevin Wells <kevin.wells@nxp.com>
 *
 * Copyright (C) 2010 NXP Semiconductors
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __ASM_ARM_ARCH_IRQS_H
#define __ASM_ARM_ARCH_IRQS_H

#define LPC32XX_SIC1_IRQ(n)		(32 + (n))
#define LPC32XX_SIC2_IRQ(n)		(64 + (n))

/*
 * MIC interrupts
 */
#define IRQ_LPC32XX_SUB1IRQ		0
#define IRQ_LPC32XX_SUB2IRQ		1
#define IRQ_LPC32XX_PWM3		3
#define IRQ_LPC32XX_PWM4		4
#define IRQ_LPC32XX_HSTIMER		5
#define IRQ_LPC32XX_WATCH		6
#define IRQ_LPC32XX_UART_IIR3		7
#define IRQ_LPC32XX_UART_IIR4		8
#define IRQ_LPC32XX_UART_IIR5		9
#define IRQ_LPC32XX_UART_IIR6		10
#define IRQ_LPC32XX_FLASH		11
#define IRQ_LPC32XX_SD1			13
#define IRQ_LPC32XX_LCD			14
#define IRQ_LPC32XX_SD0			15
#define IRQ_LPC32XX_TIMER0		16
#define IRQ_LPC32XX_TIMER1		17
#define IRQ_LPC32XX_TIMER2		18
#define IRQ_LPC32XX_TIMER3		19
#define IRQ_LPC32XX_SSP0		20
#define IRQ_LPC32XX_SSP1		21
#define IRQ_LPC32XX_I2S0		22
#define IRQ_LPC32XX_I2S1		23
#define IRQ_LPC32XX_UART_IIR7		24
#define IRQ_LPC32XX_UART_IIR2		25
#define IRQ_LPC32XX_UART_IIR1		26
#define IRQ_LPC32XX_MSTIMER		27
#define IRQ_LPC32XX_DMA			28
#define IRQ_LPC32XX_ETHERNET		29
#define IRQ_LPC32XX_SUB1FIQ		30
#define IRQ_LPC32XX_SUB2FIQ		31

/*
 * SIC1 interrupts start at offset 32
 */
#define IRQ_LPC32XX_JTAG_COMM_TX	LPC32XX_SIC1_IRQ(1)
#define IRQ_LPC32XX_JTAG_COMM_RX	LPC32XX_SIC1_IRQ(2)
#define IRQ_LPC32XX_GPI_28		LPC32XX_SIC1_IRQ(4)
#define IRQ_LPC32XX_TS_P		LPC32XX_SIC1_IRQ(6)
#define IRQ_LPC32XX_TS_IRQ		LPC32XX_SIC1_IRQ(7)
#define IRQ_LPC32XX_TS_AUX		LPC32XX_SIC1_IRQ(8)
#define IRQ_LPC32XX_SPI2		LPC32XX_SIC1_IRQ(12)
#define IRQ_LPC32XX_PLLUSB		LPC32XX_SIC1_IRQ(13)
#define IRQ_LPC32XX_PLLHCLK		LPC32XX_SIC1_IRQ(14)
#define IRQ_LPC32XX_PLL397		LPC32XX_SIC1_IRQ(17)
#define IRQ_LPC32XX_I2C_2		LPC32XX_SIC1_IRQ(18)
#define IRQ_LPC32XX_I2C_1		LPC32XX_SIC1_IRQ(19)
#define IRQ_LPC32XX_RTC			LPC32XX_SIC1_IRQ(20)
#define IRQ_LPC32XX_KEY			LPC32XX_SIC1_IRQ(22)
#define IRQ_LPC32XX_SPI1		LPC32XX_SIC1_IRQ(23)
#define IRQ_LPC32XX_SW			LPC32XX_SIC1_IRQ(24)
#define IRQ_LPC32XX_USB_OTG_TIMER	LPC32XX_SIC1_IRQ(25)
#define IRQ_LPC32XX_USB_OTG_ATX		LPC32XX_SIC1_IRQ(26)
#define IRQ_LPC32XX_USB_HOST		LPC32XX_SIC1_IRQ(27)
#define IRQ_LPC32XX_USB_DEV_DMA		LPC32XX_SIC1_IRQ(28)
#define IRQ_LPC32XX_USB_DEV_LP		LPC32XX_SIC1_IRQ(29)
#define IRQ_LPC32XX_USB_DEV_HP		LPC32XX_SIC1_IRQ(30)
#define IRQ_LPC32XX_USB_I2C		LPC32XX_SIC1_IRQ(31)

/*
 * SIC2 interrupts start at offset 64
 */
#define IRQ_LPC32XX_GPIO_00		LPC32XX_SIC2_IRQ(0)
#define IRQ_LPC32XX_GPIO_01		LPC32XX_SIC2_IRQ(1)
#define IRQ_LPC32XX_GPIO_02		LPC32XX_SIC2_IRQ(2)
#define IRQ_LPC32XX_GPIO_03		LPC32XX_SIC2_IRQ(3)
#define IRQ_LPC32XX_GPIO_04		LPC32XX_SIC2_IRQ(4)
#define IRQ_LPC32XX_GPIO_05		LPC32XX_SIC2_IRQ(5)
#define IRQ_LPC32XX_SPI2_DATAIN		LPC32XX_SIC2_IRQ(6)
#define IRQ_LPC32XX_U2_HCTS		LPC32XX_SIC2_IRQ(7)
#define IRQ_LPC32XX_P0_P1_IRQ		LPC32XX_SIC2_IRQ(8)
#define IRQ_LPC32XX_GPI_08		LPC32XX_SIC2_IRQ(9)
#define IRQ_LPC32XX_GPI_09		LPC32XX_SIC2_IRQ(10)
#define IRQ_LPC32XX_GPI_19		LPC32XX_SIC2_IRQ(11)
#define IRQ_LPC32XX_U7_HCTS		LPC32XX_SIC2_IRQ(12)
#define IRQ_LPC32XX_GPI_07		LPC32XX_SIC2_IRQ(15)
#define IRQ_LPC32XX_SDIO		LPC32XX_SIC2_IRQ(18)
#define IRQ_LPC32XX_U5_RX		LPC32XX_SIC2_IRQ(19)
#define IRQ_LPC32XX_SPI1_DATAIN		LPC32XX_SIC2_IRQ(20)
#define IRQ_LPC32XX_GPI_00		LPC32XX_SIC2_IRQ(22)
#define IRQ_LPC32XX_GPI_01		LPC32XX_SIC2_IRQ(23)
#define IRQ_LPC32XX_GPI_02		LPC32XX_SIC2_IRQ(24)
#define IRQ_LPC32XX_GPI_03		LPC32XX_SIC2_IRQ(25)
#define IRQ_LPC32XX_GPI_04		LPC32XX_SIC2_IRQ(26)
#define IRQ_LPC32XX_GPI_05		LPC32XX_SIC2_IRQ(27)
#define IRQ_LPC32XX_GPI_06		LPC32XX_SIC2_IRQ(28)
#define IRQ_LPC32XX_SYSCLK		LPC32XX_SIC2_IRQ(31)

#define NR_IRQS				96

#endif
