/*
 * linux/fs/nls_cp949.c
 *
 * Charset cp949 translation tables.
 * This translation table was generated automatically, the
 * original table can be download from the Microsoft website.
 * (http://www.microsoft.com/typography/unicode/unicodecp.htm)
 */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/string.h>
#include <linux/nls.h>
#include <linux/init.h>

static struct nls_unicode c2u_81[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xAC, 0x02}, {0xAC, 0x03}, {0xAC, 0x05}, /* 0x40-0x43 */
	{0xAC, 0x06}, {0xAC, 0x0B}, {0xAC, 0x0C}, {0xAC, 0x0D}, /* 0x44-0x47 */
	{0xAC, 0x0E}, {0xAC, 0x0F}, {0xAC, 0x18}, {0xAC, 0x1E}, /* 0x48-0x4B */
	{0xAC, 0x1F}, {0xAC, 0x21}, {0xAC, 0x22}, {0xAC, 0x23}, /* 0x4C-0x4F */
	{0xAC, 0x25}, {0xAC, 0x26}, {0xAC, 0x27}, {0xAC, 0x28}, /* 0x50-0x53 */
	{0xAC, 0x29}, {0xAC, 0x2A}, {0xAC, 0x2B}, {0xAC, 0x2E}, /* 0x54-0x57 */
	{0xAC, 0x32}, {0xAC, 0x33}, {0xAC, 0x34}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xAC, 0x35}, {0xAC, 0x36}, {0xAC, 0x37}, /* 0x60-0x63 */
	{0xAC, 0x3A}, {0xAC, 0x3B}, {0xAC, 0x3D}, {0xAC, 0x3E}, /* 0x64-0x67 */
	{0xAC, 0x3F}, {0xAC, 0x41}, {0xAC, 0x42}, {0xAC, 0x43}, /* 0x68-0x6B */
	{0xAC, 0x44}, {0xAC, 0x45}, {0xAC, 0x46}, {0xAC, 0x47}, /* 0x6C-0x6F */
	{0xAC, 0x48}, {0xAC, 0x49}, {0xAC, 0x4A}, {0xAC, 0x4C}, /* 0x70-0x73 */
	{0xAC, 0x4E}, {0xAC, 0x4F}, {0xAC, 0x50}, {0xAC, 0x51}, /* 0x74-0x77 */
	{0xAC, 0x52}, {0xAC, 0x53}, {0xAC, 0x55}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xAC, 0x56}, {0xAC, 0x57}, {0xAC, 0x59}, /* 0x80-0x83 */
	{0xAC, 0x5A}, {0xAC, 0x5B}, {0xAC, 0x5D}, {0xAC, 0x5E}, /* 0x84-0x87 */
	{0xAC, 0x5F}, {0xAC, 0x60}, {0xAC, 0x61}, {0xAC, 0x62}, /* 0x88-0x8B */
	{0xAC, 0x63}, {0xAC, 0x64}, {0xAC, 0x65}, {0xAC, 0x66}, /* 0x8C-0x8F */
	{0xAC, 0x67}, {0xAC, 0x68}, {0xAC, 0x69}, {0xAC, 0x6A}, /* 0x90-0x93 */
	{0xAC, 0x6B}, {0xAC, 0x6C}, {0xAC, 0x6D}, {0xAC, 0x6E}, /* 0x94-0x97 */
	{0xAC, 0x6F}, {0xAC, 0x72}, {0xAC, 0x73}, {0xAC, 0x75}, /* 0x98-0x9B */
	{0xAC, 0x76}, {0xAC, 0x79}, {0xAC, 0x7B}, {0xAC, 0x7C}, /* 0x9C-0x9F */
	{0xAC, 0x7D}, {0xAC, 0x7E}, {0xAC, 0x7F}, {0xAC, 0x82}, /* 0xA0-0xA3 */
	{0xAC, 0x87}, {0xAC, 0x88}, {0xAC, 0x8D}, {0xAC, 0x8E}, /* 0xA4-0xA7 */
	{0xAC, 0x8F}, {0xAC, 0x91}, {0xAC, 0x92}, {0xAC, 0x93}, /* 0xA8-0xAB */
	{0xAC, 0x95}, {0xAC, 0x96}, {0xAC, 0x97}, {0xAC, 0x98}, /* 0xAC-0xAF */
	{0xAC, 0x99}, {0xAC, 0x9A}, {0xAC, 0x9B}, {0xAC, 0x9E}, /* 0xB0-0xB3 */
	{0xAC, 0xA2}, {0xAC, 0xA3}, {0xAC, 0xA4}, {0xAC, 0xA5}, /* 0xB4-0xB7 */
	{0xAC, 0xA6}, {0xAC, 0xA7}, {0xAC, 0xAB}, {0xAC, 0xAD}, /* 0xB8-0xBB */
	{0xAC, 0xAE}, {0xAC, 0xB1}, {0xAC, 0xB2}, {0xAC, 0xB3}, /* 0xBC-0xBF */
	{0xAC, 0xB4}, {0xAC, 0xB5}, {0xAC, 0xB6}, {0xAC, 0xB7}, /* 0xC0-0xC3 */
	{0xAC, 0xBA}, {0xAC, 0xBE}, {0xAC, 0xBF}, {0xAC, 0xC0}, /* 0xC4-0xC7 */
	{0xAC, 0xC2}, {0xAC, 0xC3}, {0xAC, 0xC5}, {0xAC, 0xC6}, /* 0xC8-0xCB */
	{0xAC, 0xC7}, {0xAC, 0xC9}, {0xAC, 0xCA}, {0xAC, 0xCB}, /* 0xCC-0xCF */
	{0xAC, 0xCD}, {0xAC, 0xCE}, {0xAC, 0xCF}, {0xAC, 0xD0}, /* 0xD0-0xD3 */
	{0xAC, 0xD1}, {0xAC, 0xD2}, {0xAC, 0xD3}, {0xAC, 0xD4}, /* 0xD4-0xD7 */
	{0xAC, 0xD6}, {0xAC, 0xD8}, {0xAC, 0xD9}, {0xAC, 0xDA}, /* 0xD8-0xDB */
	{0xAC, 0xDB}, {0xAC, 0xDC}, {0xAC, 0xDD}, {0xAC, 0xDE}, /* 0xDC-0xDF */
	{0xAC, 0xDF}, {0xAC, 0xE2}, {0xAC, 0xE3}, {0xAC, 0xE5}, /* 0xE0-0xE3 */
	{0xAC, 0xE6}, {0xAC, 0xE9}, {0xAC, 0xEB}, {0xAC, 0xED}, /* 0xE4-0xE7 */
	{0xAC, 0xEE}, {0xAC, 0xF2}, {0xAC, 0xF4}, {0xAC, 0xF7}, /* 0xE8-0xEB */
	{0xAC, 0xF8}, {0xAC, 0xF9}, {0xAC, 0xFA}, {0xAC, 0xFB}, /* 0xEC-0xEF */
	{0xAC, 0xFE}, {0xAC, 0xFF}, {0xAD, 0x01}, {0xAD, 0x02}, /* 0xF0-0xF3 */
	{0xAD, 0x03}, {0xAD, 0x05}, {0xAD, 0x07}, {0xAD, 0x08}, /* 0xF4-0xF7 */
	{0xAD, 0x09}, {0xAD, 0x0A}, {0xAD, 0x0B}, {0xAD, 0x0E}, /* 0xF8-0xFB */
	{0xAD, 0x10}, {0xAD, 0x12}, {0xAD, 0x13}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_82[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xAD, 0x14}, {0xAD, 0x15}, {0xAD, 0x16}, /* 0x40-0x43 */
	{0xAD, 0x17}, {0xAD, 0x19}, {0xAD, 0x1A}, {0xAD, 0x1B}, /* 0x44-0x47 */
	{0xAD, 0x1D}, {0xAD, 0x1E}, {0xAD, 0x1F}, {0xAD, 0x21}, /* 0x48-0x4B */
	{0xAD, 0x22}, {0xAD, 0x23}, {0xAD, 0x24}, {0xAD, 0x25}, /* 0x4C-0x4F */
	{0xAD, 0x26}, {0xAD, 0x27}, {0xAD, 0x28}, {0xAD, 0x2A}, /* 0x50-0x53 */
	{0xAD, 0x2B}, {0xAD, 0x2E}, {0xAD, 0x2F}, {0xAD, 0x30}, /* 0x54-0x57 */
	{0xAD, 0x31}, {0xAD, 0x32}, {0xAD, 0x33}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xAD, 0x36}, {0xAD, 0x37}, {0xAD, 0x39}, /* 0x60-0x63 */
	{0xAD, 0x3A}, {0xAD, 0x3B}, {0xAD, 0x3D}, {0xAD, 0x3E}, /* 0x64-0x67 */
	{0xAD, 0x3F}, {0xAD, 0x40}, {0xAD, 0x41}, {0xAD, 0x42}, /* 0x68-0x6B */
	{0xAD, 0x43}, {0xAD, 0x46}, {0xAD, 0x48}, {0xAD, 0x4A}, /* 0x6C-0x6F */
	{0xAD, 0x4B}, {0xAD, 0x4C}, {0xAD, 0x4D}, {0xAD, 0x4E}, /* 0x70-0x73 */
	{0xAD, 0x4F}, {0xAD, 0x51}, {0xAD, 0x52}, {0xAD, 0x53}, /* 0x74-0x77 */
	{0xAD, 0x55}, {0xAD, 0x56}, {0xAD, 0x57}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xAD, 0x59}, {0xAD, 0x5A}, {0xAD, 0x5B}, /* 0x80-0x83 */
	{0xAD, 0x5C}, {0xAD, 0x5D}, {0xAD, 0x5E}, {0xAD, 0x5F}, /* 0x84-0x87 */
	{0xAD, 0x60}, {0xAD, 0x62}, {0xAD, 0x64}, {0xAD, 0x65}, /* 0x88-0x8B */
	{0xAD, 0x66}, {0xAD, 0x67}, {0xAD, 0x68}, {0xAD, 0x69}, /* 0x8C-0x8F */
	{0xAD, 0x6A}, {0xAD, 0x6B}, {0xAD, 0x6E}, {0xAD, 0x6F}, /* 0x90-0x93 */
	{0xAD, 0x71}, {0xAD, 0x72}, {0xAD, 0x77}, {0xAD, 0x78}, /* 0x94-0x97 */
	{0xAD, 0x79}, {0xAD, 0x7A}, {0xAD, 0x7E}, {0xAD, 0x80}, /* 0x98-0x9B */
	{0xAD, 0x83}, {0xAD, 0x84}, {0xAD, 0x85}, {0xAD, 0x86}, /* 0x9C-0x9F */
	{0xAD, 0x87}, {0xAD, 0x8A}, {0xAD, 0x8B}, {0xAD, 0x8D}, /* 0xA0-0xA3 */
	{0xAD, 0x8E}, {0xAD, 0x8F}, {0xAD, 0x91}, {0xAD, 0x92}, /* 0xA4-0xA7 */
	{0xAD, 0x93}, {0xAD, 0x94}, {0xAD, 0x95}, {0xAD, 0x96}, /* 0xA8-0xAB */
	{0xAD, 0x97}, {0xAD, 0x98}, {0xAD, 0x99}, {0xAD, 0x9A}, /* 0xAC-0xAF */
	{0xAD, 0x9B}, {0xAD, 0x9E}, {0xAD, 0x9F}, {0xAD, 0xA0}, /* 0xB0-0xB3 */
	{0xAD, 0xA1}, {0xAD, 0xA2}, {0xAD, 0xA3}, {0xAD, 0xA5}, /* 0xB4-0xB7 */
	{0xAD, 0xA6}, {0xAD, 0xA7}, {0xAD, 0xA8}, {0xAD, 0xA9}, /* 0xB8-0xBB */
	{0xAD, 0xAA}, {0xAD, 0xAB}, {0xAD, 0xAC}, {0xAD, 0xAD}, /* 0xBC-0xBF */
	{0xAD, 0xAE}, {0xAD, 0xAF}, {0xAD, 0xB0}, {0xAD, 0xB1}, /* 0xC0-0xC3 */
	{0xAD, 0xB2}, {0xAD, 0xB3}, {0xAD, 0xB4}, {0xAD, 0xB5}, /* 0xC4-0xC7 */
	{0xAD, 0xB6}, {0xAD, 0xB8}, {0xAD, 0xB9}, {0xAD, 0xBA}, /* 0xC8-0xCB */
	{0xAD, 0xBB}, {0xAD, 0xBC}, {0xAD, 0xBD}, {0xAD, 0xBE}, /* 0xCC-0xCF */
	{0xAD, 0xBF}, {0xAD, 0xC2}, {0xAD, 0xC3}, {0xAD, 0xC5}, /* 0xD0-0xD3 */
	{0xAD, 0xC6}, {0xAD, 0xC7}, {0xAD, 0xC9}, {0xAD, 0xCA}, /* 0xD4-0xD7 */
	{0xAD, 0xCB}, {0xAD, 0xCC}, {0xAD, 0xCD}, {0xAD, 0xCE}, /* 0xD8-0xDB */
	{0xAD, 0xCF}, {0xAD, 0xD2}, {0xAD, 0xD4}, {0xAD, 0xD5}, /* 0xDC-0xDF */
	{0xAD, 0xD6}, {0xAD, 0xD7}, {0xAD, 0xD8}, {0xAD, 0xD9}, /* 0xE0-0xE3 */
	{0xAD, 0xDA}, {0xAD, 0xDB}, {0xAD, 0xDD}, {0xAD, 0xDE}, /* 0xE4-0xE7 */
	{0xAD, 0xDF}, {0xAD, 0xE1}, {0xAD, 0xE2}, {0xAD, 0xE3}, /* 0xE8-0xEB */
	{0xAD, 0xE5}, {0xAD, 0xE6}, {0xAD, 0xE7}, {0xAD, 0xE8}, /* 0xEC-0xEF */
	{0xAD, 0xE9}, {0xAD, 0xEA}, {0xAD, 0xEB}, {0xAD, 0xEC}, /* 0xF0-0xF3 */
	{0xAD, 0xED}, {0xAD, 0xEE}, {0xAD, 0xEF}, {0xAD, 0xF0}, /* 0xF4-0xF7 */
	{0xAD, 0xF1}, {0xAD, 0xF2}, {0xAD, 0xF3}, {0xAD, 0xF4}, /* 0xF8-0xFB */
	{0xAD, 0xF5}, {0xAD, 0xF6}, {0xAD, 0xF7}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_83[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xAD, 0xFA}, {0xAD, 0xFB}, {0xAD, 0xFD}, /* 0x40-0x43 */
	{0xAD, 0xFE}, {0xAE, 0x02}, {0xAE, 0x03}, {0xAE, 0x04}, /* 0x44-0x47 */
	{0xAE, 0x05}, {0xAE, 0x06}, {0xAE, 0x07}, {0xAE, 0x0A}, /* 0x48-0x4B */
	{0xAE, 0x0C}, {0xAE, 0x0E}, {0xAE, 0x0F}, {0xAE, 0x10}, /* 0x4C-0x4F */
	{0xAE, 0x11}, {0xAE, 0x12}, {0xAE, 0x13}, {0xAE, 0x15}, /* 0x50-0x53 */
	{0xAE, 0x16}, {0xAE, 0x17}, {0xAE, 0x18}, {0xAE, 0x19}, /* 0x54-0x57 */
	{0xAE, 0x1A}, {0xAE, 0x1B}, {0xAE, 0x1C}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xAE, 0x1D}, {0xAE, 0x1E}, {0xAE, 0x1F}, /* 0x60-0x63 */
	{0xAE, 0x20}, {0xAE, 0x21}, {0xAE, 0x22}, {0xAE, 0x23}, /* 0x64-0x67 */
	{0xAE, 0x24}, {0xAE, 0x25}, {0xAE, 0x26}, {0xAE, 0x27}, /* 0x68-0x6B */
	{0xAE, 0x28}, {0xAE, 0x29}, {0xAE, 0x2A}, {0xAE, 0x2B}, /* 0x6C-0x6F */
	{0xAE, 0x2C}, {0xAE, 0x2D}, {0xAE, 0x2E}, {0xAE, 0x2F}, /* 0x70-0x73 */
	{0xAE, 0x32}, {0xAE, 0x33}, {0xAE, 0x35}, {0xAE, 0x36}, /* 0x74-0x77 */
	{0xAE, 0x39}, {0xAE, 0x3B}, {0xAE, 0x3C}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xAE, 0x3D}, {0xAE, 0x3E}, {0xAE, 0x3F}, /* 0x80-0x83 */
	{0xAE, 0x42}, {0xAE, 0x44}, {0xAE, 0x47}, {0xAE, 0x48}, /* 0x84-0x87 */
	{0xAE, 0x49}, {0xAE, 0x4B}, {0xAE, 0x4F}, {0xAE, 0x51}, /* 0x88-0x8B */
	{0xAE, 0x52}, {0xAE, 0x53}, {0xAE, 0x55}, {0xAE, 0x57}, /* 0x8C-0x8F */
	{0xAE, 0x58}, {0xAE, 0x59}, {0xAE, 0x5A}, {0xAE, 0x5B}, /* 0x90-0x93 */
	{0xAE, 0x5E}, {0xAE, 0x62}, {0xAE, 0x63}, {0xAE, 0x64}, /* 0x94-0x97 */
	{0xAE, 0x66}, {0xAE, 0x67}, {0xAE, 0x6A}, {0xAE, 0x6B}, /* 0x98-0x9B */
	{0xAE, 0x6D}, {0xAE, 0x6E}, {0xAE, 0x6F}, {0xAE, 0x71}, /* 0x9C-0x9F */
	{0xAE, 0x72}, {0xAE, 0x73}, {0xAE, 0x74}, {0xAE, 0x75}, /* 0xA0-0xA3 */
	{0xAE, 0x76}, {0xAE, 0x77}, {0xAE, 0x7A}, {0xAE, 0x7E}, /* 0xA4-0xA7 */
	{0xAE, 0x7F}, {0xAE, 0x80}, {0xAE, 0x81}, {0xAE, 0x82}, /* 0xA8-0xAB */
	{0xAE, 0x83}, {0xAE, 0x86}, {0xAE, 0x87}, {0xAE, 0x88}, /* 0xAC-0xAF */
	{0xAE, 0x89}, {0xAE, 0x8A}, {0xAE, 0x8B}, {0xAE, 0x8D}, /* 0xB0-0xB3 */
	{0xAE, 0x8E}, {0xAE, 0x8F}, {0xAE, 0x90}, {0xAE, 0x91}, /* 0xB4-0xB7 */
	{0xAE, 0x92}, {0xAE, 0x93}, {0xAE, 0x94}, {0xAE, 0x95}, /* 0xB8-0xBB */
	{0xAE, 0x96}, {0xAE, 0x97}, {0xAE, 0x98}, {0xAE, 0x99}, /* 0xBC-0xBF */
	{0xAE, 0x9A}, {0xAE, 0x9B}, {0xAE, 0x9C}, {0xAE, 0x9D}, /* 0xC0-0xC3 */
	{0xAE, 0x9E}, {0xAE, 0x9F}, {0xAE, 0xA0}, {0xAE, 0xA1}, /* 0xC4-0xC7 */
	{0xAE, 0xA2}, {0xAE, 0xA3}, {0xAE, 0xA4}, {0xAE, 0xA5}, /* 0xC8-0xCB */
	{0xAE, 0xA6}, {0xAE, 0xA7}, {0xAE, 0xA8}, {0xAE, 0xA9}, /* 0xCC-0xCF */
	{0xAE, 0xAA}, {0xAE, 0xAB}, {0xAE, 0xAC}, {0xAE, 0xAD}, /* 0xD0-0xD3 */
	{0xAE, 0xAE}, {0xAE, 0xAF}, {0xAE, 0xB0}, {0xAE, 0xB1}, /* 0xD4-0xD7 */
	{0xAE, 0xB2}, {0xAE, 0xB3}, {0xAE, 0xB4}, {0xAE, 0xB5}, /* 0xD8-0xDB */
	{0xAE, 0xB6}, {0xAE, 0xB7}, {0xAE, 0xB8}, {0xAE, 0xB9}, /* 0xDC-0xDF */
	{0xAE, 0xBA}, {0xAE, 0xBB}, {0xAE, 0xBF}, {0xAE, 0xC1}, /* 0xE0-0xE3 */
	{0xAE, 0xC2}, {0xAE, 0xC3}, {0xAE, 0xC5}, {0xAE, 0xC6}, /* 0xE4-0xE7 */
	{0xAE, 0xC7}, {0xAE, 0xC8}, {0xAE, 0xC9}, {0xAE, 0xCA}, /* 0xE8-0xEB */
	{0xAE, 0xCB}, {0xAE, 0xCE}, {0xAE, 0xD2}, {0xAE, 0xD3}, /* 0xEC-0xEF */
	{0xAE, 0xD4}, {0xAE, 0xD5}, {0xAE, 0xD6}, {0xAE, 0xD7}, /* 0xF0-0xF3 */
	{0xAE, 0xDA}, {0xAE, 0xDB}, {0xAE, 0xDD}, {0xAE, 0xDE}, /* 0xF4-0xF7 */
	{0xAE, 0xDF}, {0xAE, 0xE0}, {0xAE, 0xE1}, {0xAE, 0xE2}, /* 0xF8-0xFB */
	{0xAE, 0xE3}, {0xAE, 0xE4}, {0xAE, 0xE5}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_84[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xAE, 0xE6}, {0xAE, 0xE7}, {0xAE, 0xE9}, /* 0x40-0x43 */
	{0xAE, 0xEA}, {0xAE, 0xEC}, {0xAE, 0xEE}, {0xAE, 0xEF}, /* 0x44-0x47 */
	{0xAE, 0xF0}, {0xAE, 0xF1}, {0xAE, 0xF2}, {0xAE, 0xF3}, /* 0x48-0x4B */
	{0xAE, 0xF5}, {0xAE, 0xF6}, {0xAE, 0xF7}, {0xAE, 0xF9}, /* 0x4C-0x4F */
	{0xAE, 0xFA}, {0xAE, 0xFB}, {0xAE, 0xFD}, {0xAE, 0xFE}, /* 0x50-0x53 */
	{0xAE, 0xFF}, {0xAF, 0x00}, {0xAF, 0x01}, {0xAF, 0x02}, /* 0x54-0x57 */
	{0xAF, 0x03}, {0xAF, 0x04}, {0xAF, 0x05}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xAF, 0x06}, {0xAF, 0x09}, {0xAF, 0x0A}, /* 0x60-0x63 */
	{0xAF, 0x0B}, {0xAF, 0x0C}, {0xAF, 0x0E}, {0xAF, 0x0F}, /* 0x64-0x67 */
	{0xAF, 0x11}, {0xAF, 0x12}, {0xAF, 0x13}, {0xAF, 0x14}, /* 0x68-0x6B */
	{0xAF, 0x15}, {0xAF, 0x16}, {0xAF, 0x17}, {0xAF, 0x18}, /* 0x6C-0x6F */
	{0xAF, 0x19}, {0xAF, 0x1A}, {0xAF, 0x1B}, {0xAF, 0x1C}, /* 0x70-0x73 */
	{0xAF, 0x1D}, {0xAF, 0x1E}, {0xAF, 0x1F}, {0xAF, 0x20}, /* 0x74-0x77 */
	{0xAF, 0x21}, {0xAF, 0x22}, {0xAF, 0x23}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xAF, 0x24}, {0xAF, 0x25}, {0xAF, 0x26}, /* 0x80-0x83 */
	{0xAF, 0x27}, {0xAF, 0x28}, {0xAF, 0x29}, {0xAF, 0x2A}, /* 0x84-0x87 */
	{0xAF, 0x2B}, {0xAF, 0x2E}, {0xAF, 0x2F}, {0xAF, 0x31}, /* 0x88-0x8B */
	{0xAF, 0x33}, {0xAF, 0x35}, {0xAF, 0x36}, {0xAF, 0x37}, /* 0x8C-0x8F */
	{0xAF, 0x38}, {0xAF, 0x39}, {0xAF, 0x3A}, {0xAF, 0x3B}, /* 0x90-0x93 */
	{0xAF, 0x3E}, {0xAF, 0x40}, {0xAF, 0x44}, {0xAF, 0x45}, /* 0x94-0x97 */
	{0xAF, 0x46}, {0xAF, 0x47}, {0xAF, 0x4A}, {0xAF, 0x4B}, /* 0x98-0x9B */
	{0xAF, 0x4C}, {0xAF, 0x4D}, {0xAF, 0x4E}, {0xAF, 0x4F}, /* 0x9C-0x9F */
	{0xAF, 0x51}, {0xAF, 0x52}, {0xAF, 0x53}, {0xAF, 0x54}, /* 0xA0-0xA3 */
	{0xAF, 0x55}, {0xAF, 0x56}, {0xAF, 0x57}, {0xAF, 0x58}, /* 0xA4-0xA7 */
	{0xAF, 0x59}, {0xAF, 0x5A}, {0xAF, 0x5B}, {0xAF, 0x5E}, /* 0xA8-0xAB */
	{0xAF, 0x5F}, {0xAF, 0x60}, {0xAF, 0x61}, {0xAF, 0x62}, /* 0xAC-0xAF */
	{0xAF, 0x63}, {0xAF, 0x66}, {0xAF, 0x67}, {0xAF, 0x68}, /* 0xB0-0xB3 */
	{0xAF, 0x69}, {0xAF, 0x6A}, {0xAF, 0x6B}, {0xAF, 0x6C}, /* 0xB4-0xB7 */
	{0xAF, 0x6D}, {0xAF, 0x6E}, {0xAF, 0x6F}, {0xAF, 0x70}, /* 0xB8-0xBB */
	{0xAF, 0x71}, {0xAF, 0x72}, {0xAF, 0x73}, {0xAF, 0x74}, /* 0xBC-0xBF */
	{0xAF, 0x75}, {0xAF, 0x76}, {0xAF, 0x77}, {0xAF, 0x78}, /* 0xC0-0xC3 */
	{0xAF, 0x7A}, {0xAF, 0x7B}, {0xAF, 0x7C}, {0xAF, 0x7D}, /* 0xC4-0xC7 */
	{0xAF, 0x7E}, {0xAF, 0x7F}, {0xAF, 0x81}, {0xAF, 0x82}, /* 0xC8-0xCB */
	{0xAF, 0x83}, {0xAF, 0x85}, {0xAF, 0x86}, {0xAF, 0x87}, /* 0xCC-0xCF */
	{0xAF, 0x89}, {0xAF, 0x8A}, {0xAF, 0x8B}, {0xAF, 0x8C}, /* 0xD0-0xD3 */
	{0xAF, 0x8D}, {0xAF, 0x8E}, {0xAF, 0x8F}, {0xAF, 0x92}, /* 0xD4-0xD7 */
	{0xAF, 0x93}, {0xAF, 0x94}, {0xAF, 0x96}, {0xAF, 0x97}, /* 0xD8-0xDB */
	{0xAF, 0x98}, {0xAF, 0x99}, {0xAF, 0x9A}, {0xAF, 0x9B}, /* 0xDC-0xDF */
	{0xAF, 0x9D}, {0xAF, 0x9E}, {0xAF, 0x9F}, {0xAF, 0xA0}, /* 0xE0-0xE3 */
	{0xAF, 0xA1}, {0xAF, 0xA2}, {0xAF, 0xA3}, {0xAF, 0xA4}, /* 0xE4-0xE7 */
	{0xAF, 0xA5}, {0xAF, 0xA6}, {0xAF, 0xA7}, {0xAF, 0xA8}, /* 0xE8-0xEB */
	{0xAF, 0xA9}, {0xAF, 0xAA}, {0xAF, 0xAB}, {0xAF, 0xAC}, /* 0xEC-0xEF */
	{0xAF, 0xAD}, {0xAF, 0xAE}, {0xAF, 0xAF}, {0xAF, 0xB0}, /* 0xF0-0xF3 */
	{0xAF, 0xB1}, {0xAF, 0xB2}, {0xAF, 0xB3}, {0xAF, 0xB4}, /* 0xF4-0xF7 */
	{0xAF, 0xB5}, {0xAF, 0xB6}, {0xAF, 0xB7}, {0xAF, 0xBA}, /* 0xF8-0xFB */
	{0xAF, 0xBB}, {0xAF, 0xBD}, {0xAF, 0xBE}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_85[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xAF, 0xBF}, {0xAF, 0xC1}, {0xAF, 0xC2}, /* 0x40-0x43 */
	{0xAF, 0xC3}, {0xAF, 0xC4}, {0xAF, 0xC5}, {0xAF, 0xC6}, /* 0x44-0x47 */
	{0xAF, 0xCA}, {0xAF, 0xCC}, {0xAF, 0xCF}, {0xAF, 0xD0}, /* 0x48-0x4B */
	{0xAF, 0xD1}, {0xAF, 0xD2}, {0xAF, 0xD3}, {0xAF, 0xD5}, /* 0x4C-0x4F */
	{0xAF, 0xD6}, {0xAF, 0xD7}, {0xAF, 0xD8}, {0xAF, 0xD9}, /* 0x50-0x53 */
	{0xAF, 0xDA}, {0xAF, 0xDB}, {0xAF, 0xDD}, {0xAF, 0xDE}, /* 0x54-0x57 */
	{0xAF, 0xDF}, {0xAF, 0xE0}, {0xAF, 0xE1}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xAF, 0xE2}, {0xAF, 0xE3}, {0xAF, 0xE4}, /* 0x60-0x63 */
	{0xAF, 0xE5}, {0xAF, 0xE6}, {0xAF, 0xE7}, {0xAF, 0xEA}, /* 0x64-0x67 */
	{0xAF, 0xEB}, {0xAF, 0xEC}, {0xAF, 0xED}, {0xAF, 0xEE}, /* 0x68-0x6B */
	{0xAF, 0xEF}, {0xAF, 0xF2}, {0xAF, 0xF3}, {0xAF, 0xF5}, /* 0x6C-0x6F */
	{0xAF, 0xF6}, {0xAF, 0xF7}, {0xAF, 0xF9}, {0xAF, 0xFA}, /* 0x70-0x73 */
	{0xAF, 0xFB}, {0xAF, 0xFC}, {0xAF, 0xFD}, {0xAF, 0xFE}, /* 0x74-0x77 */
	{0xAF, 0xFF}, {0xB0, 0x02}, {0xB0, 0x03}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xB0, 0x05}, {0xB0, 0x06}, {0xB0, 0x07}, /* 0x80-0x83 */
	{0xB0, 0x08}, {0xB0, 0x09}, {0xB0, 0x0A}, {0xB0, 0x0B}, /* 0x84-0x87 */
	{0xB0, 0x0D}, {0xB0, 0x0E}, {0xB0, 0x0F}, {0xB0, 0x11}, /* 0x88-0x8B */
	{0xB0, 0x12}, {0xB0, 0x13}, {0xB0, 0x15}, {0xB0, 0x16}, /* 0x8C-0x8F */
	{0xB0, 0x17}, {0xB0, 0x18}, {0xB0, 0x19}, {0xB0, 0x1A}, /* 0x90-0x93 */
	{0xB0, 0x1B}, {0xB0, 0x1E}, {0xB0, 0x1F}, {0xB0, 0x20}, /* 0x94-0x97 */
	{0xB0, 0x21}, {0xB0, 0x22}, {0xB0, 0x23}, {0xB0, 0x24}, /* 0x98-0x9B */
	{0xB0, 0x25}, {0xB0, 0x26}, {0xB0, 0x27}, {0xB0, 0x29}, /* 0x9C-0x9F */
	{0xB0, 0x2A}, {0xB0, 0x2B}, {0xB0, 0x2C}, {0xB0, 0x2D}, /* 0xA0-0xA3 */
	{0xB0, 0x2E}, {0xB0, 0x2F}, {0xB0, 0x30}, {0xB0, 0x31}, /* 0xA4-0xA7 */
	{0xB0, 0x32}, {0xB0, 0x33}, {0xB0, 0x34}, {0xB0, 0x35}, /* 0xA8-0xAB */
	{0xB0, 0x36}, {0xB0, 0x37}, {0xB0, 0x38}, {0xB0, 0x39}, /* 0xAC-0xAF */
	{0xB0, 0x3A}, {0xB0, 0x3B}, {0xB0, 0x3C}, {0xB0, 0x3D}, /* 0xB0-0xB3 */
	{0xB0, 0x3E}, {0xB0, 0x3F}, {0xB0, 0x40}, {0xB0, 0x41}, /* 0xB4-0xB7 */
	{0xB0, 0x42}, {0xB0, 0x43}, {0xB0, 0x46}, {0xB0, 0x47}, /* 0xB8-0xBB */
	{0xB0, 0x49}, {0xB0, 0x4B}, {0xB0, 0x4D}, {0xB0, 0x4F}, /* 0xBC-0xBF */
	{0xB0, 0x50}, {0xB0, 0x51}, {0xB0, 0x52}, {0xB0, 0x56}, /* 0xC0-0xC3 */
	{0xB0, 0x58}, {0xB0, 0x5A}, {0xB0, 0x5B}, {0xB0, 0x5C}, /* 0xC4-0xC7 */
	{0xB0, 0x5E}, {0xB0, 0x5F}, {0xB0, 0x60}, {0xB0, 0x61}, /* 0xC8-0xCB */
	{0xB0, 0x62}, {0xB0, 0x63}, {0xB0, 0x64}, {0xB0, 0x65}, /* 0xCC-0xCF */
	{0xB0, 0x66}, {0xB0, 0x67}, {0xB0, 0x68}, {0xB0, 0x69}, /* 0xD0-0xD3 */
	{0xB0, 0x6A}, {0xB0, 0x6B}, {0xB0, 0x6C}, {0xB0, 0x6D}, /* 0xD4-0xD7 */
	{0xB0, 0x6E}, {0xB0, 0x6F}, {0xB0, 0x70}, {0xB0, 0x71}, /* 0xD8-0xDB */
	{0xB0, 0x72}, {0xB0, 0x73}, {0xB0, 0x74}, {0xB0, 0x75}, /* 0xDC-0xDF */
	{0xB0, 0x76}, {0xB0, 0x77}, {0xB0, 0x78}, {0xB0, 0x79}, /* 0xE0-0xE3 */
	{0xB0, 0x7A}, {0xB0, 0x7B}, {0xB0, 0x7E}, {0xB0, 0x7F}, /* 0xE4-0xE7 */
	{0xB0, 0x81}, {0xB0, 0x82}, {0xB0, 0x83}, {0xB0, 0x85}, /* 0xE8-0xEB */
	{0xB0, 0x86}, {0xB0, 0x87}, {0xB0, 0x88}, {0xB0, 0x89}, /* 0xEC-0xEF */
	{0xB0, 0x8A}, {0xB0, 0x8B}, {0xB0, 0x8E}, {0xB0, 0x90}, /* 0xF0-0xF3 */
	{0xB0, 0x92}, {0xB0, 0x93}, {0xB0, 0x94}, {0xB0, 0x95}, /* 0xF4-0xF7 */
	{0xB0, 0x96}, {0xB0, 0x97}, {0xB0, 0x9B}, {0xB0, 0x9D}, /* 0xF8-0xFB */
	{0xB0, 0x9E}, {0xB0, 0xA3}, {0xB0, 0xA4}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_86[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xB0, 0xA5}, {0xB0, 0xA6}, {0xB0, 0xA7}, /* 0x40-0x43 */
	{0xB0, 0xAA}, {0xB0, 0xB0}, {0xB0, 0xB2}, {0xB0, 0xB6}, /* 0x44-0x47 */
	{0xB0, 0xB7}, {0xB0, 0xB9}, {0xB0, 0xBA}, {0xB0, 0xBB}, /* 0x48-0x4B */
	{0xB0, 0xBD}, {0xB0, 0xBE}, {0xB0, 0xBF}, {0xB0, 0xC0}, /* 0x4C-0x4F */
	{0xB0, 0xC1}, {0xB0, 0xC2}, {0xB0, 0xC3}, {0xB0, 0xC6}, /* 0x50-0x53 */
	{0xB0, 0xCA}, {0xB0, 0xCB}, {0xB0, 0xCC}, {0xB0, 0xCD}, /* 0x54-0x57 */
	{0xB0, 0xCE}, {0xB0, 0xCF}, {0xB0, 0xD2}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xB0, 0xD3}, {0xB0, 0xD5}, {0xB0, 0xD6}, /* 0x60-0x63 */
	{0xB0, 0xD7}, {0xB0, 0xD9}, {0xB0, 0xDA}, {0xB0, 0xDB}, /* 0x64-0x67 */
	{0xB0, 0xDC}, {0xB0, 0xDD}, {0xB0, 0xDE}, {0xB0, 0xDF}, /* 0x68-0x6B */
	{0xB0, 0xE1}, {0xB0, 0xE2}, {0xB0, 0xE3}, {0xB0, 0xE4}, /* 0x6C-0x6F */
	{0xB0, 0xE6}, {0xB0, 0xE7}, {0xB0, 0xE8}, {0xB0, 0xE9}, /* 0x70-0x73 */
	{0xB0, 0xEA}, {0xB0, 0xEB}, {0xB0, 0xEC}, {0xB0, 0xED}, /* 0x74-0x77 */
	{0xB0, 0xEE}, {0xB0, 0xEF}, {0xB0, 0xF0}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xB0, 0xF1}, {0xB0, 0xF2}, {0xB0, 0xF3}, /* 0x80-0x83 */
	{0xB0, 0xF4}, {0xB0, 0xF5}, {0xB0, 0xF6}, {0xB0, 0xF7}, /* 0x84-0x87 */
	{0xB0, 0xF8}, {0xB0, 0xF9}, {0xB0, 0xFA}, {0xB0, 0xFB}, /* 0x88-0x8B */
	{0xB0, 0xFC}, {0xB0, 0xFD}, {0xB0, 0xFE}, {0xB0, 0xFF}, /* 0x8C-0x8F */
	{0xB1, 0x00}, {0xB1, 0x01}, {0xB1, 0x02}, {0xB1, 0x03}, /* 0x90-0x93 */
	{0xB1, 0x04}, {0xB1, 0x05}, {0xB1, 0x06}, {0xB1, 0x07}, /* 0x94-0x97 */
	{0xB1, 0x0A}, {0xB1, 0x0D}, {0xB1, 0x0E}, {0xB1, 0x0F}, /* 0x98-0x9B */
	{0xB1, 0x11}, {0xB1, 0x14}, {0xB1, 0x15}, {0xB1, 0x16}, /* 0x9C-0x9F */
	{0xB1, 0x17}, {0xB1, 0x1A}, {0xB1, 0x1E}, {0xB1, 0x1F}, /* 0xA0-0xA3 */
	{0xB1, 0x20}, {0xB1, 0x21}, {0xB1, 0x22}, {0xB1, 0x26}, /* 0xA4-0xA7 */
	{0xB1, 0x27}, {0xB1, 0x29}, {0xB1, 0x2A}, {0xB1, 0x2B}, /* 0xA8-0xAB */
	{0xB1, 0x2D}, {0xB1, 0x2E}, {0xB1, 0x2F}, {0xB1, 0x30}, /* 0xAC-0xAF */
	{0xB1, 0x31}, {0xB1, 0x32}, {0xB1, 0x33}, {0xB1, 0x36}, /* 0xB0-0xB3 */
	{0xB1, 0x3A}, {0xB1, 0x3B}, {0xB1, 0x3C}, {0xB1, 0x3D}, /* 0xB4-0xB7 */
	{0xB1, 0x3E}, {0xB1, 0x3F}, {0xB1, 0x42}, {0xB1, 0x43}, /* 0xB8-0xBB */
	{0xB1, 0x45}, {0xB1, 0x46}, {0xB1, 0x47}, {0xB1, 0x49}, /* 0xBC-0xBF */
	{0xB1, 0x4A}, {0xB1, 0x4B}, {0xB1, 0x4C}, {0xB1, 0x4D}, /* 0xC0-0xC3 */
	{0xB1, 0x4E}, {0xB1, 0x4F}, {0xB1, 0x52}, {0xB1, 0x53}, /* 0xC4-0xC7 */
	{0xB1, 0x56}, {0xB1, 0x57}, {0xB1, 0x59}, {0xB1, 0x5A}, /* 0xC8-0xCB */
	{0xB1, 0x5B}, {0xB1, 0x5D}, {0xB1, 0x5E}, {0xB1, 0x5F}, /* 0xCC-0xCF */
	{0xB1, 0x61}, {0xB1, 0x62}, {0xB1, 0x63}, {0xB1, 0x64}, /* 0xD0-0xD3 */
	{0xB1, 0x65}, {0xB1, 0x66}, {0xB1, 0x67}, {0xB1, 0x68}, /* 0xD4-0xD7 */
	{0xB1, 0x69}, {0xB1, 0x6A}, {0xB1, 0x6B}, {0xB1, 0x6C}, /* 0xD8-0xDB */
	{0xB1, 0x6D}, {0xB1, 0x6E}, {0xB1, 0x6F}, {0xB1, 0x70}, /* 0xDC-0xDF */
	{0xB1, 0x71}, {0xB1, 0x72}, {0xB1, 0x73}, {0xB1, 0x74}, /* 0xE0-0xE3 */
	{0xB1, 0x75}, {0xB1, 0x76}, {0xB1, 0x77}, {0xB1, 0x7A}, /* 0xE4-0xE7 */
	{0xB1, 0x7B}, {0xB1, 0x7D}, {0xB1, 0x7E}, {0xB1, 0x7F}, /* 0xE8-0xEB */
	{0xB1, 0x81}, {0xB1, 0x83}, {0xB1, 0x84}, {0xB1, 0x85}, /* 0xEC-0xEF */
	{0xB1, 0x86}, {0xB1, 0x87}, {0xB1, 0x8A}, {0xB1, 0x8C}, /* 0xF0-0xF3 */
	{0xB1, 0x8E}, {0xB1, 0x8F}, {0xB1, 0x90}, {0xB1, 0x91}, /* 0xF4-0xF7 */
	{0xB1, 0x95}, {0xB1, 0x96}, {0xB1, 0x97}, {0xB1, 0x99}, /* 0xF8-0xFB */
	{0xB1, 0x9A}, {0xB1, 0x9B}, {0xB1, 0x9D}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_87[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xB1, 0x9E}, {0xB1, 0x9F}, {0xB1, 0xA0}, /* 0x40-0x43 */
	{0xB1, 0xA1}, {0xB1, 0xA2}, {0xB1, 0xA3}, {0xB1, 0xA4}, /* 0x44-0x47 */
	{0xB1, 0xA5}, {0xB1, 0xA6}, {0xB1, 0xA7}, {0xB1, 0xA9}, /* 0x48-0x4B */
	{0xB1, 0xAA}, {0xB1, 0xAB}, {0xB1, 0xAC}, {0xB1, 0xAD}, /* 0x4C-0x4F */
	{0xB1, 0xAE}, {0xB1, 0xAF}, {0xB1, 0xB0}, {0xB1, 0xB1}, /* 0x50-0x53 */
	{0xB1, 0xB2}, {0xB1, 0xB3}, {0xB1, 0xB4}, {0xB1, 0xB5}, /* 0x54-0x57 */
	{0xB1, 0xB6}, {0xB1, 0xB7}, {0xB1, 0xB8}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xB1, 0xB9}, {0xB1, 0xBA}, {0xB1, 0xBB}, /* 0x60-0x63 */
	{0xB1, 0xBC}, {0xB1, 0xBD}, {0xB1, 0xBE}, {0xB1, 0xBF}, /* 0x64-0x67 */
	{0xB1, 0xC0}, {0xB1, 0xC1}, {0xB1, 0xC2}, {0xB1, 0xC3}, /* 0x68-0x6B */
	{0xB1, 0xC4}, {0xB1, 0xC5}, {0xB1, 0xC6}, {0xB1, 0xC7}, /* 0x6C-0x6F */
	{0xB1, 0xC8}, {0xB1, 0xC9}, {0xB1, 0xCA}, {0xB1, 0xCB}, /* 0x70-0x73 */
	{0xB1, 0xCD}, {0xB1, 0xCE}, {0xB1, 0xCF}, {0xB1, 0xD1}, /* 0x74-0x77 */
	{0xB1, 0xD2}, {0xB1, 0xD3}, {0xB1, 0xD5}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xB1, 0xD6}, {0xB1, 0xD7}, {0xB1, 0xD8}, /* 0x80-0x83 */
	{0xB1, 0xD9}, {0xB1, 0xDA}, {0xB1, 0xDB}, {0xB1, 0xDE}, /* 0x84-0x87 */
	{0xB1, 0xE0}, {0xB1, 0xE1}, {0xB1, 0xE2}, {0xB1, 0xE3}, /* 0x88-0x8B */
	{0xB1, 0xE4}, {0xB1, 0xE5}, {0xB1, 0xE6}, {0xB1, 0xE7}, /* 0x8C-0x8F */
	{0xB1, 0xEA}, {0xB1, 0xEB}, {0xB1, 0xED}, {0xB1, 0xEE}, /* 0x90-0x93 */
	{0xB1, 0xEF}, {0xB1, 0xF1}, {0xB1, 0xF2}, {0xB1, 0xF3}, /* 0x94-0x97 */
	{0xB1, 0xF4}, {0xB1, 0xF5}, {0xB1, 0xF6}, {0xB1, 0xF7}, /* 0x98-0x9B */
	{0xB1, 0xF8}, {0xB1, 0xFA}, {0xB1, 0xFC}, {0xB1, 0xFE}, /* 0x9C-0x9F */
	{0xB1, 0xFF}, {0xB2, 0x00}, {0xB2, 0x01}, {0xB2, 0x02}, /* 0xA0-0xA3 */
	{0xB2, 0x03}, {0xB2, 0x06}, {0xB2, 0x07}, {0xB2, 0x09}, /* 0xA4-0xA7 */
	{0xB2, 0x0A}, {0xB2, 0x0D}, {0xB2, 0x0E}, {0xB2, 0x0F}, /* 0xA8-0xAB */
	{0xB2, 0x10}, {0xB2, 0x11}, {0xB2, 0x12}, {0xB2, 0x13}, /* 0xAC-0xAF */
	{0xB2, 0x16}, {0xB2, 0x18}, {0xB2, 0x1A}, {0xB2, 0x1B}, /* 0xB0-0xB3 */
	{0xB2, 0x1C}, {0xB2, 0x1D}, {0xB2, 0x1E}, {0xB2, 0x1F}, /* 0xB4-0xB7 */
	{0xB2, 0x21}, {0xB2, 0x22}, {0xB2, 0x23}, {0xB2, 0x24}, /* 0xB8-0xBB */
	{0xB2, 0x25}, {0xB2, 0x26}, {0xB2, 0x27}, {0xB2, 0x28}, /* 0xBC-0xBF */
	{0xB2, 0x29}, {0xB2, 0x2A}, {0xB2, 0x2B}, {0xB2, 0x2C}, /* 0xC0-0xC3 */
	{0xB2, 0x2D}, {0xB2, 0x2E}, {0xB2, 0x2F}, {0xB2, 0x30}, /* 0xC4-0xC7 */
	{0xB2, 0x31}, {0xB2, 0x32}, {0xB2, 0x33}, {0xB2, 0x35}, /* 0xC8-0xCB */
	{0xB2, 0x36}, {0xB2, 0x37}, {0xB2, 0x38}, {0xB2, 0x39}, /* 0xCC-0xCF */
	{0xB2, 0x3A}, {0xB2, 0x3B}, {0xB2, 0x3D}, {0xB2, 0x3E}, /* 0xD0-0xD3 */
	{0xB2, 0x3F}, {0xB2, 0x40}, {0xB2, 0x41}, {0xB2, 0x42}, /* 0xD4-0xD7 */
	{0xB2, 0x43}, {0xB2, 0x44}, {0xB2, 0x45}, {0xB2, 0x46}, /* 0xD8-0xDB */
	{0xB2, 0x47}, {0xB2, 0x48}, {0xB2, 0x49}, {0xB2, 0x4A}, /* 0xDC-0xDF */
	{0xB2, 0x4B}, {0xB2, 0x4C}, {0xB2, 0x4D}, {0xB2, 0x4E}, /* 0xE0-0xE3 */
	{0xB2, 0x4F}, {0xB2, 0x50}, {0xB2, 0x51}, {0xB2, 0x52}, /* 0xE4-0xE7 */
	{0xB2, 0x53}, {0xB2, 0x54}, {0xB2, 0x55}, {0xB2, 0x56}, /* 0xE8-0xEB */
	{0xB2, 0x57}, {0xB2, 0x59}, {0xB2, 0x5A}, {0xB2, 0x5B}, /* 0xEC-0xEF */
	{0xB2, 0x5D}, {0xB2, 0x5E}, {0xB2, 0x5F}, {0xB2, 0x61}, /* 0xF0-0xF3 */
	{0xB2, 0x62}, {0xB2, 0x63}, {0xB2, 0x64}, {0xB2, 0x65}, /* 0xF4-0xF7 */
	{0xB2, 0x66}, {0xB2, 0x67}, {0xB2, 0x6A}, {0xB2, 0x6B}, /* 0xF8-0xFB */
	{0xB2, 0x6C}, {0xB2, 0x6D}, {0xB2, 0x6E}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_88[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xB2, 0x6F}, {0xB2, 0x70}, {0xB2, 0x71}, /* 0x40-0x43 */
	{0xB2, 0x72}, {0xB2, 0x73}, {0xB2, 0x76}, {0xB2, 0x77}, /* 0x44-0x47 */
	{0xB2, 0x78}, {0xB2, 0x79}, {0xB2, 0x7A}, {0xB2, 0x7B}, /* 0x48-0x4B */
	{0xB2, 0x7D}, {0xB2, 0x7E}, {0xB2, 0x7F}, {0xB2, 0x80}, /* 0x4C-0x4F */
	{0xB2, 0x81}, {0xB2, 0x82}, {0xB2, 0x83}, {0xB2, 0x86}, /* 0x50-0x53 */
	{0xB2, 0x87}, {0xB2, 0x88}, {0xB2, 0x8A}, {0xB2, 0x8B}, /* 0x54-0x57 */
	{0xB2, 0x8C}, {0xB2, 0x8D}, {0xB2, 0x8E}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xB2, 0x8F}, {0xB2, 0x92}, {0xB2, 0x93}, /* 0x60-0x63 */
	{0xB2, 0x95}, {0xB2, 0x96}, {0xB2, 0x97}, {0xB2, 0x9B}, /* 0x64-0x67 */
	{0xB2, 0x9C}, {0xB2, 0x9D}, {0xB2, 0x9E}, {0xB2, 0x9F}, /* 0x68-0x6B */
	{0xB2, 0xA2}, {0xB2, 0xA4}, {0xB2, 0xA7}, {0xB2, 0xA8}, /* 0x6C-0x6F */
	{0xB2, 0xA9}, {0xB2, 0xAB}, {0xB2, 0xAD}, {0xB2, 0xAE}, /* 0x70-0x73 */
	{0xB2, 0xAF}, {0xB2, 0xB1}, {0xB2, 0xB2}, {0xB2, 0xB3}, /* 0x74-0x77 */
	{0xB2, 0xB5}, {0xB2, 0xB6}, {0xB2, 0xB7}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xB2, 0xB8}, {0xB2, 0xB9}, {0xB2, 0xBA}, /* 0x80-0x83 */
	{0xB2, 0xBB}, {0xB2, 0xBC}, {0xB2, 0xBD}, {0xB2, 0xBE}, /* 0x84-0x87 */
	{0xB2, 0xBF}, {0xB2, 0xC0}, {0xB2, 0xC1}, {0xB2, 0xC2}, /* 0x88-0x8B */
	{0xB2, 0xC3}, {0xB2, 0xC4}, {0xB2, 0xC5}, {0xB2, 0xC6}, /* 0x8C-0x8F */
	{0xB2, 0xC7}, {0xB2, 0xCA}, {0xB2, 0xCB}, {0xB2, 0xCD}, /* 0x90-0x93 */
	{0xB2, 0xCE}, {0xB2, 0xCF}, {0xB2, 0xD1}, {0xB2, 0xD3}, /* 0x94-0x97 */
	{0xB2, 0xD4}, {0xB2, 0xD5}, {0xB2, 0xD6}, {0xB2, 0xD7}, /* 0x98-0x9B */
	{0xB2, 0xDA}, {0xB2, 0xDC}, {0xB2, 0xDE}, {0xB2, 0xDF}, /* 0x9C-0x9F */
	{0xB2, 0xE0}, {0xB2, 0xE1}, {0xB2, 0xE3}, {0xB2, 0xE7}, /* 0xA0-0xA3 */
	{0xB2, 0xE9}, {0xB2, 0xEA}, {0xB2, 0xF0}, {0xB2, 0xF1}, /* 0xA4-0xA7 */
	{0xB2, 0xF2}, {0xB2, 0xF6}, {0xB2, 0xFC}, {0xB2, 0xFD}, /* 0xA8-0xAB */
	{0xB2, 0xFE}, {0xB3, 0x02}, {0xB3, 0x03}, {0xB3, 0x05}, /* 0xAC-0xAF */
	{0xB3, 0x06}, {0xB3, 0x07}, {0xB3, 0x09}, {0xB3, 0x0A}, /* 0xB0-0xB3 */
	{0xB3, 0x0B}, {0xB3, 0x0C}, {0xB3, 0x0D}, {0xB3, 0x0E}, /* 0xB4-0xB7 */
	{0xB3, 0x0F}, {0xB3, 0x12}, {0xB3, 0x16}, {0xB3, 0x17}, /* 0xB8-0xBB */
	{0xB3, 0x18}, {0xB3, 0x19}, {0xB3, 0x1A}, {0xB3, 0x1B}, /* 0xBC-0xBF */
	{0xB3, 0x1D}, {0xB3, 0x1E}, {0xB3, 0x1F}, {0xB3, 0x20}, /* 0xC0-0xC3 */
	{0xB3, 0x21}, {0xB3, 0x22}, {0xB3, 0x23}, {0xB3, 0x24}, /* 0xC4-0xC7 */
	{0xB3, 0x25}, {0xB3, 0x26}, {0xB3, 0x27}, {0xB3, 0x28}, /* 0xC8-0xCB */
	{0xB3, 0x29}, {0xB3, 0x2A}, {0xB3, 0x2B}, {0xB3, 0x2C}, /* 0xCC-0xCF */
	{0xB3, 0x2D}, {0xB3, 0x2E}, {0xB3, 0x2F}, {0xB3, 0x30}, /* 0xD0-0xD3 */
	{0xB3, 0x31}, {0xB3, 0x32}, {0xB3, 0x33}, {0xB3, 0x34}, /* 0xD4-0xD7 */
	{0xB3, 0x35}, {0xB3, 0x36}, {0xB3, 0x37}, {0xB3, 0x38}, /* 0xD8-0xDB */
	{0xB3, 0x39}, {0xB3, 0x3A}, {0xB3, 0x3B}, {0xB3, 0x3C}, /* 0xDC-0xDF */
	{0xB3, 0x3D}, {0xB3, 0x3E}, {0xB3, 0x3F}, {0xB3, 0x40}, /* 0xE0-0xE3 */
	{0xB3, 0x41}, {0xB3, 0x42}, {0xB3, 0x43}, {0xB3, 0x44}, /* 0xE4-0xE7 */
	{0xB3, 0x45}, {0xB3, 0x46}, {0xB3, 0x47}, {0xB3, 0x48}, /* 0xE8-0xEB */
	{0xB3, 0x49}, {0xB3, 0x4A}, {0xB3, 0x4B}, {0xB3, 0x4C}, /* 0xEC-0xEF */
	{0xB3, 0x4D}, {0xB3, 0x4E}, {0xB3, 0x4F}, {0xB3, 0x50}, /* 0xF0-0xF3 */
	{0xB3, 0x51}, {0xB3, 0x52}, {0xB3, 0x53}, {0xB3, 0x57}, /* 0xF4-0xF7 */
	{0xB3, 0x59}, {0xB3, 0x5A}, {0xB3, 0x5D}, {0xB3, 0x60}, /* 0xF8-0xFB */
	{0xB3, 0x61}, {0xB3, 0x62}, {0xB3, 0x63}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_89[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xB3, 0x66}, {0xB3, 0x68}, {0xB3, 0x6A}, /* 0x40-0x43 */
	{0xB3, 0x6C}, {0xB3, 0x6D}, {0xB3, 0x6F}, {0xB3, 0x72}, /* 0x44-0x47 */
	{0xB3, 0x73}, {0xB3, 0x75}, {0xB3, 0x76}, {0xB3, 0x77}, /* 0x48-0x4B */
	{0xB3, 0x79}, {0xB3, 0x7A}, {0xB3, 0x7B}, {0xB3, 0x7C}, /* 0x4C-0x4F */
	{0xB3, 0x7D}, {0xB3, 0x7E}, {0xB3, 0x7F}, {0xB3, 0x82}, /* 0x50-0x53 */
	{0xB3, 0x86}, {0xB3, 0x87}, {0xB3, 0x88}, {0xB3, 0x89}, /* 0x54-0x57 */
	{0xB3, 0x8A}, {0xB3, 0x8B}, {0xB3, 0x8D}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xB3, 0x8E}, {0xB3, 0x8F}, {0xB3, 0x91}, /* 0x60-0x63 */
	{0xB3, 0x92}, {0xB3, 0x93}, {0xB3, 0x95}, {0xB3, 0x96}, /* 0x64-0x67 */
	{0xB3, 0x97}, {0xB3, 0x98}, {0xB3, 0x99}, {0xB3, 0x9A}, /* 0x68-0x6B */
	{0xB3, 0x9B}, {0xB3, 0x9C}, {0xB3, 0x9D}, {0xB3, 0x9E}, /* 0x6C-0x6F */
	{0xB3, 0x9F}, {0xB3, 0xA2}, {0xB3, 0xA3}, {0xB3, 0xA4}, /* 0x70-0x73 */
	{0xB3, 0xA5}, {0xB3, 0xA6}, {0xB3, 0xA7}, {0xB3, 0xA9}, /* 0x74-0x77 */
	{0xB3, 0xAA}, {0xB3, 0xAB}, {0xB3, 0xAD}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xB3, 0xAE}, {0xB3, 0xAF}, {0xB3, 0xB0}, /* 0x80-0x83 */
	{0xB3, 0xB1}, {0xB3, 0xB2}, {0xB3, 0xB3}, {0xB3, 0xB4}, /* 0x84-0x87 */
	{0xB3, 0xB5}, {0xB3, 0xB6}, {0xB3, 0xB7}, {0xB3, 0xB8}, /* 0x88-0x8B */
	{0xB3, 0xB9}, {0xB3, 0xBA}, {0xB3, 0xBB}, {0xB3, 0xBC}, /* 0x8C-0x8F */
	{0xB3, 0xBD}, {0xB3, 0xBE}, {0xB3, 0xBF}, {0xB3, 0xC0}, /* 0x90-0x93 */
	{0xB3, 0xC1}, {0xB3, 0xC2}, {0xB3, 0xC3}, {0xB3, 0xC6}, /* 0x94-0x97 */
	{0xB3, 0xC7}, {0xB3, 0xC9}, {0xB3, 0xCA}, {0xB3, 0xCD}, /* 0x98-0x9B */
	{0xB3, 0xCF}, {0xB3, 0xD1}, {0xB3, 0xD2}, {0xB3, 0xD3}, /* 0x9C-0x9F */
	{0xB3, 0xD6}, {0xB3, 0xD8}, {0xB3, 0xDA}, {0xB3, 0xDC}, /* 0xA0-0xA3 */
	{0xB3, 0xDE}, {0xB3, 0xDF}, {0xB3, 0xE1}, {0xB3, 0xE2}, /* 0xA4-0xA7 */
	{0xB3, 0xE3}, {0xB3, 0xE5}, {0xB3, 0xE6}, {0xB3, 0xE7}, /* 0xA8-0xAB */
	{0xB3, 0xE9}, {0xB3, 0xEA}, {0xB3, 0xEB}, {0xB3, 0xEC}, /* 0xAC-0xAF */
	{0xB3, 0xED}, {0xB3, 0xEE}, {0xB3, 0xEF}, {0xB3, 0xF0}, /* 0xB0-0xB3 */
	{0xB3, 0xF1}, {0xB3, 0xF2}, {0xB3, 0xF3}, {0xB3, 0xF4}, /* 0xB4-0xB7 */
	{0xB3, 0xF5}, {0xB3, 0xF6}, {0xB3, 0xF7}, {0xB3, 0xF8}, /* 0xB8-0xBB */
	{0xB3, 0xF9}, {0xB3, 0xFA}, {0xB3, 0xFB}, {0xB3, 0xFD}, /* 0xBC-0xBF */
	{0xB3, 0xFE}, {0xB3, 0xFF}, {0xB4, 0x00}, {0xB4, 0x01}, /* 0xC0-0xC3 */
	{0xB4, 0x02}, {0xB4, 0x03}, {0xB4, 0x04}, {0xB4, 0x05}, /* 0xC4-0xC7 */
	{0xB4, 0x06}, {0xB4, 0x07}, {0xB4, 0x08}, {0xB4, 0x09}, /* 0xC8-0xCB */
	{0xB4, 0x0A}, {0xB4, 0x0B}, {0xB4, 0x0C}, {0xB4, 0x0D}, /* 0xCC-0xCF */
	{0xB4, 0x0E}, {0xB4, 0x0F}, {0xB4, 0x11}, {0xB4, 0x12}, /* 0xD0-0xD3 */
	{0xB4, 0x13}, {0xB4, 0x14}, {0xB4, 0x15}, {0xB4, 0x16}, /* 0xD4-0xD7 */
	{0xB4, 0x17}, {0xB4, 0x19}, {0xB4, 0x1A}, {0xB4, 0x1B}, /* 0xD8-0xDB */
	{0xB4, 0x1D}, {0xB4, 0x1E}, {0xB4, 0x1F}, {0xB4, 0x21}, /* 0xDC-0xDF */
	{0xB4, 0x22}, {0xB4, 0x23}, {0xB4, 0x24}, {0xB4, 0x25}, /* 0xE0-0xE3 */
	{0xB4, 0x26}, {0xB4, 0x27}, {0xB4, 0x2A}, {0xB4, 0x2C}, /* 0xE4-0xE7 */
	{0xB4, 0x2D}, {0xB4, 0x2E}, {0xB4, 0x2F}, {0xB4, 0x30}, /* 0xE8-0xEB */
	{0xB4, 0x31}, {0xB4, 0x32}, {0xB4, 0x33}, {0xB4, 0x35}, /* 0xEC-0xEF */
	{0xB4, 0x36}, {0xB4, 0x37}, {0xB4, 0x38}, {0xB4, 0x39}, /* 0xF0-0xF3 */
	{0xB4, 0x3A}, {0xB4, 0x3B}, {0xB4, 0x3C}, {0xB4, 0x3D}, /* 0xF4-0xF7 */
	{0xB4, 0x3E}, {0xB4, 0x3F}, {0xB4, 0x40}, {0xB4, 0x41}, /* 0xF8-0xFB */
	{0xB4, 0x42}, {0xB4, 0x43}, {0xB4, 0x44}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_8A[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xB4, 0x45}, {0xB4, 0x46}, {0xB4, 0x47}, /* 0x40-0x43 */
	{0xB4, 0x48}, {0xB4, 0x49}, {0xB4, 0x4A}, {0xB4, 0x4B}, /* 0x44-0x47 */
	{0xB4, 0x4C}, {0xB4, 0x4D}, {0xB4, 0x4E}, {0xB4, 0x4F}, /* 0x48-0x4B */
	{0xB4, 0x52}, {0xB4, 0x53}, {0xB4, 0x55}, {0xB4, 0x56}, /* 0x4C-0x4F */
	{0xB4, 0x57}, {0xB4, 0x59}, {0xB4, 0x5A}, {0xB4, 0x5B}, /* 0x50-0x53 */
	{0xB4, 0x5C}, {0xB4, 0x5D}, {0xB4, 0x5E}, {0xB4, 0x5F}, /* 0x54-0x57 */
	{0xB4, 0x62}, {0xB4, 0x64}, {0xB4, 0x66}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xB4, 0x67}, {0xB4, 0x68}, {0xB4, 0x69}, /* 0x60-0x63 */
	{0xB4, 0x6A}, {0xB4, 0x6B}, {0xB4, 0x6D}, {0xB4, 0x6E}, /* 0x64-0x67 */
	{0xB4, 0x6F}, {0xB4, 0x70}, {0xB4, 0x71}, {0xB4, 0x72}, /* 0x68-0x6B */
	{0xB4, 0x73}, {0xB4, 0x74}, {0xB4, 0x75}, {0xB4, 0x76}, /* 0x6C-0x6F */
	{0xB4, 0x77}, {0xB4, 0x78}, {0xB4, 0x79}, {0xB4, 0x7A}, /* 0x70-0x73 */
	{0xB4, 0x7B}, {0xB4, 0x7C}, {0xB4, 0x7D}, {0xB4, 0x7E}, /* 0x74-0x77 */
	{0xB4, 0x7F}, {0xB4, 0x81}, {0xB4, 0x82}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xB4, 0x83}, {0xB4, 0x84}, {0xB4, 0x85}, /* 0x80-0x83 */
	{0xB4, 0x86}, {0xB4, 0x87}, {0xB4, 0x89}, {0xB4, 0x8A}, /* 0x84-0x87 */
	{0xB4, 0x8B}, {0xB4, 0x8C}, {0xB4, 0x8D}, {0xB4, 0x8E}, /* 0x88-0x8B */
	{0xB4, 0x8F}, {0xB4, 0x90}, {0xB4, 0x91}, {0xB4, 0x92}, /* 0x8C-0x8F */
	{0xB4, 0x93}, {0xB4, 0x94}, {0xB4, 0x95}, {0xB4, 0x96}, /* 0x90-0x93 */
	{0xB4, 0x97}, {0xB4, 0x98}, {0xB4, 0x99}, {0xB4, 0x9A}, /* 0x94-0x97 */
	{0xB4, 0x9B}, {0xB4, 0x9C}, {0xB4, 0x9E}, {0xB4, 0x9F}, /* 0x98-0x9B */
	{0xB4, 0xA0}, {0xB4, 0xA1}, {0xB4, 0xA2}, {0xB4, 0xA3}, /* 0x9C-0x9F */
	{0xB4, 0xA5}, {0xB4, 0xA6}, {0xB4, 0xA7}, {0xB4, 0xA9}, /* 0xA0-0xA3 */
	{0xB4, 0xAA}, {0xB4, 0xAB}, {0xB4, 0xAD}, {0xB4, 0xAE}, /* 0xA4-0xA7 */
	{0xB4, 0xAF}, {0xB4, 0xB0}, {0xB4, 0xB1}, {0xB4, 0xB2}, /* 0xA8-0xAB */
	{0xB4, 0xB3}, {0xB4, 0xB4}, {0xB4, 0xB6}, {0xB4, 0xB8}, /* 0xAC-0xAF */
	{0xB4, 0xBA}, {0xB4, 0xBB}, {0xB4, 0xBC}, {0xB4, 0xBD}, /* 0xB0-0xB3 */
	{0xB4, 0xBE}, {0xB4, 0xBF}, {0xB4, 0xC1}, {0xB4, 0xC2}, /* 0xB4-0xB7 */
	{0xB4, 0xC3}, {0xB4, 0xC5}, {0xB4, 0xC6}, {0xB4, 0xC7}, /* 0xB8-0xBB */
	{0xB4, 0xC9}, {0xB4, 0xCA}, {0xB4, 0xCB}, {0xB4, 0xCC}, /* 0xBC-0xBF */
	{0xB4, 0xCD}, {0xB4, 0xCE}, {0xB4, 0xCF}, {0xB4, 0xD1}, /* 0xC0-0xC3 */
	{0xB4, 0xD2}, {0xB4, 0xD3}, {0xB4, 0xD4}, {0xB4, 0xD6}, /* 0xC4-0xC7 */
	{0xB4, 0xD7}, {0xB4, 0xD8}, {0xB4, 0xD9}, {0xB4, 0xDA}, /* 0xC8-0xCB */
	{0xB4, 0xDB}, {0xB4, 0xDE}, {0xB4, 0xDF}, {0xB4, 0xE1}, /* 0xCC-0xCF */
	{0xB4, 0xE2}, {0xB4, 0xE5}, {0xB4, 0xE7}, {0xB4, 0xE8}, /* 0xD0-0xD3 */
	{0xB4, 0xE9}, {0xB4, 0xEA}, {0xB4, 0xEB}, {0xB4, 0xEE}, /* 0xD4-0xD7 */
	{0xB4, 0xF0}, {0xB4, 0xF2}, {0xB4, 0xF3}, {0xB4, 0xF4}, /* 0xD8-0xDB */
	{0xB4, 0xF5}, {0xB4, 0xF6}, {0xB4, 0xF7}, {0xB4, 0xF9}, /* 0xDC-0xDF */
	{0xB4, 0xFA}, {0xB4, 0xFB}, {0xB4, 0xFC}, {0xB4, 0xFD}, /* 0xE0-0xE3 */
	{0xB4, 0xFE}, {0xB4, 0xFF}, {0xB5, 0x00}, {0xB5, 0x01}, /* 0xE4-0xE7 */
	{0xB5, 0x02}, {0xB5, 0x03}, {0xB5, 0x04}, {0xB5, 0x05}, /* 0xE8-0xEB */
	{0xB5, 0x06}, {0xB5, 0x07}, {0xB5, 0x08}, {0xB5, 0x09}, /* 0xEC-0xEF */
	{0xB5, 0x0A}, {0xB5, 0x0B}, {0xB5, 0x0C}, {0xB5, 0x0D}, /* 0xF0-0xF3 */
	{0xB5, 0x0E}, {0xB5, 0x0F}, {0xB5, 0x10}, {0xB5, 0x11}, /* 0xF4-0xF7 */
	{0xB5, 0x12}, {0xB5, 0x13}, {0xB5, 0x16}, {0xB5, 0x17}, /* 0xF8-0xFB */
	{0xB5, 0x19}, {0xB5, 0x1A}, {0xB5, 0x1D}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_8B[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xB5, 0x1E}, {0xB5, 0x1F}, {0xB5, 0x20}, /* 0x40-0x43 */
	{0xB5, 0x21}, {0xB5, 0x22}, {0xB5, 0x23}, {0xB5, 0x26}, /* 0x44-0x47 */
	{0xB5, 0x2B}, {0xB5, 0x2C}, {0xB5, 0x2D}, {0xB5, 0x2E}, /* 0x48-0x4B */
	{0xB5, 0x2F}, {0xB5, 0x32}, {0xB5, 0x33}, {0xB5, 0x35}, /* 0x4C-0x4F */
	{0xB5, 0x36}, {0xB5, 0x37}, {0xB5, 0x39}, {0xB5, 0x3A}, /* 0x50-0x53 */
	{0xB5, 0x3B}, {0xB5, 0x3C}, {0xB5, 0x3D}, {0xB5, 0x3E}, /* 0x54-0x57 */
	{0xB5, 0x3F}, {0xB5, 0x42}, {0xB5, 0x46}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xB5, 0x47}, {0xB5, 0x48}, {0xB5, 0x49}, /* 0x60-0x63 */
	{0xB5, 0x4A}, {0xB5, 0x4E}, {0xB5, 0x4F}, {0xB5, 0x51}, /* 0x64-0x67 */
	{0xB5, 0x52}, {0xB5, 0x53}, {0xB5, 0x55}, {0xB5, 0x56}, /* 0x68-0x6B */
	{0xB5, 0x57}, {0xB5, 0x58}, {0xB5, 0x59}, {0xB5, 0x5A}, /* 0x6C-0x6F */
	{0xB5, 0x5B}, {0xB5, 0x5E}, {0xB5, 0x62}, {0xB5, 0x63}, /* 0x70-0x73 */
	{0xB5, 0x64}, {0xB5, 0x65}, {0xB5, 0x66}, {0xB5, 0x67}, /* 0x74-0x77 */
	{0xB5, 0x68}, {0xB5, 0x69}, {0xB5, 0x6A}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xB5, 0x6B}, {0xB5, 0x6C}, {0xB5, 0x6D}, /* 0x80-0x83 */
	{0xB5, 0x6E}, {0xB5, 0x6F}, {0xB5, 0x70}, {0xB5, 0x71}, /* 0x84-0x87 */
	{0xB5, 0x72}, {0xB5, 0x73}, {0xB5, 0x74}, {0xB5, 0x75}, /* 0x88-0x8B */
	{0xB5, 0x76}, {0xB5, 0x77}, {0xB5, 0x78}, {0xB5, 0x79}, /* 0x8C-0x8F */
	{0xB5, 0x7A}, {0xB5, 0x7B}, {0xB5, 0x7C}, {0xB5, 0x7D}, /* 0x90-0x93 */
	{0xB5, 0x7E}, {0xB5, 0x7F}, {0xB5, 0x80}, {0xB5, 0x81}, /* 0x94-0x97 */
	{0xB5, 0x82}, {0xB5, 0x83}, {0xB5, 0x84}, {0xB5, 0x85}, /* 0x98-0x9B */
	{0xB5, 0x86}, {0xB5, 0x87}, {0xB5, 0x88}, {0xB5, 0x89}, /* 0x9C-0x9F */
	{0xB5, 0x8A}, {0xB5, 0x8B}, {0xB5, 0x8C}, {0xB5, 0x8D}, /* 0xA0-0xA3 */
	{0xB5, 0x8E}, {0xB5, 0x8F}, {0xB5, 0x90}, {0xB5, 0x91}, /* 0xA4-0xA7 */
	{0xB5, 0x92}, {0xB5, 0x93}, {0xB5, 0x94}, {0xB5, 0x95}, /* 0xA8-0xAB */
	{0xB5, 0x96}, {0xB5, 0x97}, {0xB5, 0x98}, {0xB5, 0x99}, /* 0xAC-0xAF */
	{0xB5, 0x9A}, {0xB5, 0x9B}, {0xB5, 0x9C}, {0xB5, 0x9D}, /* 0xB0-0xB3 */
	{0xB5, 0x9E}, {0xB5, 0x9F}, {0xB5, 0xA2}, {0xB5, 0xA3}, /* 0xB4-0xB7 */
	{0xB5, 0xA5}, {0xB5, 0xA6}, {0xB5, 0xA7}, {0xB5, 0xA9}, /* 0xB8-0xBB */
	{0xB5, 0xAC}, {0xB5, 0xAD}, {0xB5, 0xAE}, {0xB5, 0xAF}, /* 0xBC-0xBF */
	{0xB5, 0xB2}, {0xB5, 0xB6}, {0xB5, 0xB7}, {0xB5, 0xB8}, /* 0xC0-0xC3 */
	{0xB5, 0xB9}, {0xB5, 0xBA}, {0xB5, 0xBE}, {0xB5, 0xBF}, /* 0xC4-0xC7 */
	{0xB5, 0xC1}, {0xB5, 0xC2}, {0xB5, 0xC3}, {0xB5, 0xC5}, /* 0xC8-0xCB */
	{0xB5, 0xC6}, {0xB5, 0xC7}, {0xB5, 0xC8}, {0xB5, 0xC9}, /* 0xCC-0xCF */
	{0xB5, 0xCA}, {0xB5, 0xCB}, {0xB5, 0xCE}, {0xB5, 0xD2}, /* 0xD0-0xD3 */
	{0xB5, 0xD3}, {0xB5, 0xD4}, {0xB5, 0xD5}, {0xB5, 0xD6}, /* 0xD4-0xD7 */
	{0xB5, 0xD7}, {0xB5, 0xD9}, {0xB5, 0xDA}, {0xB5, 0xDB}, /* 0xD8-0xDB */
	{0xB5, 0xDC}, {0xB5, 0xDD}, {0xB5, 0xDE}, {0xB5, 0xDF}, /* 0xDC-0xDF */
	{0xB5, 0xE0}, {0xB5, 0xE1}, {0xB5, 0xE2}, {0xB5, 0xE3}, /* 0xE0-0xE3 */
	{0xB5, 0xE4}, {0xB5, 0xE5}, {0xB5, 0xE6}, {0xB5, 0xE7}, /* 0xE4-0xE7 */
	{0xB5, 0xE8}, {0xB5, 0xE9}, {0xB5, 0xEA}, {0xB5, 0xEB}, /* 0xE8-0xEB */
	{0xB5, 0xED}, {0xB5, 0xEE}, {0xB5, 0xEF}, {0xB5, 0xF0}, /* 0xEC-0xEF */
	{0xB5, 0xF1}, {0xB5, 0xF2}, {0xB5, 0xF3}, {0xB5, 0xF4}, /* 0xF0-0xF3 */
	{0xB5, 0xF5}, {0xB5, 0xF6}, {0xB5, 0xF7}, {0xB5, 0xF8}, /* 0xF4-0xF7 */
	{0xB5, 0xF9}, {0xB5, 0xFA}, {0xB5, 0xFB}, {0xB5, 0xFC}, /* 0xF8-0xFB */
	{0xB5, 0xFD}, {0xB5, 0xFE}, {0xB5, 0xFF}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_8C[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xB6, 0x00}, {0xB6, 0x01}, {0xB6, 0x02}, /* 0x40-0x43 */
	{0xB6, 0x03}, {0xB6, 0x04}, {0xB6, 0x05}, {0xB6, 0x06}, /* 0x44-0x47 */
	{0xB6, 0x07}, {0xB6, 0x08}, {0xB6, 0x09}, {0xB6, 0x0A}, /* 0x48-0x4B */
	{0xB6, 0x0B}, {0xB6, 0x0C}, {0xB6, 0x0D}, {0xB6, 0x0E}, /* 0x4C-0x4F */
	{0xB6, 0x0F}, {0xB6, 0x12}, {0xB6, 0x13}, {0xB6, 0x15}, /* 0x50-0x53 */
	{0xB6, 0x16}, {0xB6, 0x17}, {0xB6, 0x19}, {0xB6, 0x1A}, /* 0x54-0x57 */
	{0xB6, 0x1B}, {0xB6, 0x1C}, {0xB6, 0x1D}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xB6, 0x1E}, {0xB6, 0x1F}, {0xB6, 0x20}, /* 0x60-0x63 */
	{0xB6, 0x21}, {0xB6, 0x22}, {0xB6, 0x23}, {0xB6, 0x24}, /* 0x64-0x67 */
	{0xB6, 0x26}, {0xB6, 0x27}, {0xB6, 0x28}, {0xB6, 0x29}, /* 0x68-0x6B */
	{0xB6, 0x2A}, {0xB6, 0x2B}, {0xB6, 0x2D}, {0xB6, 0x2E}, /* 0x6C-0x6F */
	{0xB6, 0x2F}, {0xB6, 0x30}, {0xB6, 0x31}, {0xB6, 0x32}, /* 0x70-0x73 */
	{0xB6, 0x33}, {0xB6, 0x35}, {0xB6, 0x36}, {0xB6, 0x37}, /* 0x74-0x77 */
	{0xB6, 0x38}, {0xB6, 0x39}, {0xB6, 0x3A}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xB6, 0x3B}, {0xB6, 0x3C}, {0xB6, 0x3D}, /* 0x80-0x83 */
	{0xB6, 0x3E}, {0xB6, 0x3F}, {0xB6, 0x40}, {0xB6, 0x41}, /* 0x84-0x87 */
	{0xB6, 0x42}, {0xB6, 0x43}, {0xB6, 0x44}, {0xB6, 0x45}, /* 0x88-0x8B */
	{0xB6, 0x46}, {0xB6, 0x47}, {0xB6, 0x49}, {0xB6, 0x4A}, /* 0x8C-0x8F */
	{0xB6, 0x4B}, {0xB6, 0x4C}, {0xB6, 0x4D}, {0xB6, 0x4E}, /* 0x90-0x93 */
	{0xB6, 0x4F}, {0xB6, 0x50}, {0xB6, 0x51}, {0xB6, 0x52}, /* 0x94-0x97 */
	{0xB6, 0x53}, {0xB6, 0x54}, {0xB6, 0x55}, {0xB6, 0x56}, /* 0x98-0x9B */
	{0xB6, 0x57}, {0xB6, 0x58}, {0xB6, 0x59}, {0xB6, 0x5A}, /* 0x9C-0x9F */
	{0xB6, 0x5B}, {0xB6, 0x5C}, {0xB6, 0x5D}, {0xB6, 0x5E}, /* 0xA0-0xA3 */
	{0xB6, 0x5F}, {0xB6, 0x60}, {0xB6, 0x61}, {0xB6, 0x62}, /* 0xA4-0xA7 */
	{0xB6, 0x63}, {0xB6, 0x65}, {0xB6, 0x66}, {0xB6, 0x67}, /* 0xA8-0xAB */
	{0xB6, 0x69}, {0xB6, 0x6A}, {0xB6, 0x6B}, {0xB6, 0x6C}, /* 0xAC-0xAF */
	{0xB6, 0x6D}, {0xB6, 0x6E}, {0xB6, 0x6F}, {0xB6, 0x70}, /* 0xB0-0xB3 */
	{0xB6, 0x71}, {0xB6, 0x72}, {0xB6, 0x73}, {0xB6, 0x74}, /* 0xB4-0xB7 */
	{0xB6, 0x75}, {0xB6, 0x76}, {0xB6, 0x77}, {0xB6, 0x78}, /* 0xB8-0xBB */
	{0xB6, 0x79}, {0xB6, 0x7A}, {0xB6, 0x7B}, {0xB6, 0x7C}, /* 0xBC-0xBF */
	{0xB6, 0x7D}, {0xB6, 0x7E}, {0xB6, 0x7F}, {0xB6, 0x80}, /* 0xC0-0xC3 */
	{0xB6, 0x81}, {0xB6, 0x82}, {0xB6, 0x83}, {0xB6, 0x84}, /* 0xC4-0xC7 */
	{0xB6, 0x85}, {0xB6, 0x86}, {0xB6, 0x87}, {0xB6, 0x88}, /* 0xC8-0xCB */
	{0xB6, 0x89}, {0xB6, 0x8A}, {0xB6, 0x8B}, {0xB6, 0x8C}, /* 0xCC-0xCF */
	{0xB6, 0x8D}, {0xB6, 0x8E}, {0xB6, 0x8F}, {0xB6, 0x90}, /* 0xD0-0xD3 */
	{0xB6, 0x91}, {0xB6, 0x92}, {0xB6, 0x93}, {0xB6, 0x94}, /* 0xD4-0xD7 */
	{0xB6, 0x95}, {0xB6, 0x96}, {0xB6, 0x97}, {0xB6, 0x98}, /* 0xD8-0xDB */
	{0xB6, 0x99}, {0xB6, 0x9A}, {0xB6, 0x9B}, {0xB6, 0x9E}, /* 0xDC-0xDF */
	{0xB6, 0x9F}, {0xB6, 0xA1}, {0xB6, 0xA2}, {0xB6, 0xA3}, /* 0xE0-0xE3 */
	{0xB6, 0xA5}, {0xB6, 0xA6}, {0xB6, 0xA7}, {0xB6, 0xA8}, /* 0xE4-0xE7 */
	{0xB6, 0xA9}, {0xB6, 0xAA}, {0xB6, 0xAD}, {0xB6, 0xAE}, /* 0xE8-0xEB */
	{0xB6, 0xAF}, {0xB6, 0xB0}, {0xB6, 0xB2}, {0xB6, 0xB3}, /* 0xEC-0xEF */
	{0xB6, 0xB4}, {0xB6, 0xB5}, {0xB6, 0xB6}, {0xB6, 0xB7}, /* 0xF0-0xF3 */
	{0xB6, 0xB8}, {0xB6, 0xB9}, {0xB6, 0xBA}, {0xB6, 0xBB}, /* 0xF4-0xF7 */
	{0xB6, 0xBC}, {0xB6, 0xBD}, {0xB6, 0xBE}, {0xB6, 0xBF}, /* 0xF8-0xFB */
	{0xB6, 0xC0}, {0xB6, 0xC1}, {0xB6, 0xC2}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_8D[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xB6, 0xC3}, {0xB6, 0xC4}, {0xB6, 0xC5}, /* 0x40-0x43 */
	{0xB6, 0xC6}, {0xB6, 0xC7}, {0xB6, 0xC8}, {0xB6, 0xC9}, /* 0x44-0x47 */
	{0xB6, 0xCA}, {0xB6, 0xCB}, {0xB6, 0xCC}, {0xB6, 0xCD}, /* 0x48-0x4B */
	{0xB6, 0xCE}, {0xB6, 0xCF}, {0xB6, 0xD0}, {0xB6, 0xD1}, /* 0x4C-0x4F */
	{0xB6, 0xD2}, {0xB6, 0xD3}, {0xB6, 0xD5}, {0xB6, 0xD6}, /* 0x50-0x53 */
	{0xB6, 0xD7}, {0xB6, 0xD8}, {0xB6, 0xD9}, {0xB6, 0xDA}, /* 0x54-0x57 */
	{0xB6, 0xDB}, {0xB6, 0xDC}, {0xB6, 0xDD}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xB6, 0xDE}, {0xB6, 0xDF}, {0xB6, 0xE0}, /* 0x60-0x63 */
	{0xB6, 0xE1}, {0xB6, 0xE2}, {0xB6, 0xE3}, {0xB6, 0xE4}, /* 0x64-0x67 */
	{0xB6, 0xE5}, {0xB6, 0xE6}, {0xB6, 0xE7}, {0xB6, 0xE8}, /* 0x68-0x6B */
	{0xB6, 0xE9}, {0xB6, 0xEA}, {0xB6, 0xEB}, {0xB6, 0xEC}, /* 0x6C-0x6F */
	{0xB6, 0xED}, {0xB6, 0xEE}, {0xB6, 0xEF}, {0xB6, 0xF1}, /* 0x70-0x73 */
	{0xB6, 0xF2}, {0xB6, 0xF3}, {0xB6, 0xF5}, {0xB6, 0xF6}, /* 0x74-0x77 */
	{0xB6, 0xF7}, {0xB6, 0xF9}, {0xB6, 0xFA}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xB6, 0xFB}, {0xB6, 0xFC}, {0xB6, 0xFD}, /* 0x80-0x83 */
	{0xB6, 0xFE}, {0xB6, 0xFF}, {0xB7, 0x02}, {0xB7, 0x03}, /* 0x84-0x87 */
	{0xB7, 0x04}, {0xB7, 0x06}, {0xB7, 0x07}, {0xB7, 0x08}, /* 0x88-0x8B */
	{0xB7, 0x09}, {0xB7, 0x0A}, {0xB7, 0x0B}, {0xB7, 0x0C}, /* 0x8C-0x8F */
	{0xB7, 0x0D}, {0xB7, 0x0E}, {0xB7, 0x0F}, {0xB7, 0x10}, /* 0x90-0x93 */
	{0xB7, 0x11}, {0xB7, 0x12}, {0xB7, 0x13}, {0xB7, 0x14}, /* 0x94-0x97 */
	{0xB7, 0x15}, {0xB7, 0x16}, {0xB7, 0x17}, {0xB7, 0x18}, /* 0x98-0x9B */
	{0xB7, 0x19}, {0xB7, 0x1A}, {0xB7, 0x1B}, {0xB7, 0x1C}, /* 0x9C-0x9F */
	{0xB7, 0x1D}, {0xB7, 0x1E}, {0xB7, 0x1F}, {0xB7, 0x20}, /* 0xA0-0xA3 */
	{0xB7, 0x21}, {0xB7, 0x22}, {0xB7, 0x23}, {0xB7, 0x24}, /* 0xA4-0xA7 */
	{0xB7, 0x25}, {0xB7, 0x26}, {0xB7, 0x27}, {0xB7, 0x2A}, /* 0xA8-0xAB */
	{0xB7, 0x2B}, {0xB7, 0x2D}, {0xB7, 0x2E}, {0xB7, 0x31}, /* 0xAC-0xAF */
	{0xB7, 0x32}, {0xB7, 0x33}, {0xB7, 0x34}, {0xB7, 0x35}, /* 0xB0-0xB3 */
	{0xB7, 0x36}, {0xB7, 0x37}, {0xB7, 0x3A}, {0xB7, 0x3C}, /* 0xB4-0xB7 */
	{0xB7, 0x3D}, {0xB7, 0x3E}, {0xB7, 0x3F}, {0xB7, 0x40}, /* 0xB8-0xBB */
	{0xB7, 0x41}, {0xB7, 0x42}, {0xB7, 0x43}, {0xB7, 0x45}, /* 0xBC-0xBF */
	{0xB7, 0x46}, {0xB7, 0x47}, {0xB7, 0x49}, {0xB7, 0x4A}, /* 0xC0-0xC3 */
	{0xB7, 0x4B}, {0xB7, 0x4D}, {0xB7, 0x4E}, {0xB7, 0x4F}, /* 0xC4-0xC7 */
	{0xB7, 0x50}, {0xB7, 0x51}, {0xB7, 0x52}, {0xB7, 0x53}, /* 0xC8-0xCB */
	{0xB7, 0x56}, {0xB7, 0x57}, {0xB7, 0x58}, {0xB7, 0x59}, /* 0xCC-0xCF */
	{0xB7, 0x5A}, {0xB7, 0x5B}, {0xB7, 0x5C}, {0xB7, 0x5D}, /* 0xD0-0xD3 */
	{0xB7, 0x5E}, {0xB7, 0x5F}, {0xB7, 0x61}, {0xB7, 0x62}, /* 0xD4-0xD7 */
	{0xB7, 0x63}, {0xB7, 0x65}, {0xB7, 0x66}, {0xB7, 0x67}, /* 0xD8-0xDB */
	{0xB7, 0x69}, {0xB7, 0x6A}, {0xB7, 0x6B}, {0xB7, 0x6C}, /* 0xDC-0xDF */
	{0xB7, 0x6D}, {0xB7, 0x6E}, {0xB7, 0x6F}, {0xB7, 0x72}, /* 0xE0-0xE3 */
	{0xB7, 0x74}, {0xB7, 0x76}, {0xB7, 0x77}, {0xB7, 0x78}, /* 0xE4-0xE7 */
	{0xB7, 0x79}, {0xB7, 0x7A}, {0xB7, 0x7B}, {0xB7, 0x7E}, /* 0xE8-0xEB */
	{0xB7, 0x7F}, {0xB7, 0x81}, {0xB7, 0x82}, {0xB7, 0x83}, /* 0xEC-0xEF */
	{0xB7, 0x85}, {0xB7, 0x86}, {0xB7, 0x87}, {0xB7, 0x88}, /* 0xF0-0xF3 */
	{0xB7, 0x89}, {0xB7, 0x8A}, {0xB7, 0x8B}, {0xB7, 0x8E}, /* 0xF4-0xF7 */
	{0xB7, 0x93}, {0xB7, 0x94}, {0xB7, 0x95}, {0xB7, 0x9A}, /* 0xF8-0xFB */
	{0xB7, 0x9B}, {0xB7, 0x9D}, {0xB7, 0x9E}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_8E[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xB7, 0x9F}, {0xB7, 0xA1}, {0xB7, 0xA2}, /* 0x40-0x43 */
	{0xB7, 0xA3}, {0xB7, 0xA4}, {0xB7, 0xA5}, {0xB7, 0xA6}, /* 0x44-0x47 */
	{0xB7, 0xA7}, {0xB7, 0xAA}, {0xB7, 0xAE}, {0xB7, 0xAF}, /* 0x48-0x4B */
	{0xB7, 0xB0}, {0xB7, 0xB1}, {0xB7, 0xB2}, {0xB7, 0xB3}, /* 0x4C-0x4F */
	{0xB7, 0xB6}, {0xB7, 0xB7}, {0xB7, 0xB9}, {0xB7, 0xBA}, /* 0x50-0x53 */
	{0xB7, 0xBB}, {0xB7, 0xBC}, {0xB7, 0xBD}, {0xB7, 0xBE}, /* 0x54-0x57 */
	{0xB7, 0xBF}, {0xB7, 0xC0}, {0xB7, 0xC1}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xB7, 0xC2}, {0xB7, 0xC3}, {0xB7, 0xC4}, /* 0x60-0x63 */
	{0xB7, 0xC5}, {0xB7, 0xC6}, {0xB7, 0xC8}, {0xB7, 0xCA}, /* 0x64-0x67 */
	{0xB7, 0xCB}, {0xB7, 0xCC}, {0xB7, 0xCD}, {0xB7, 0xCE}, /* 0x68-0x6B */
	{0xB7, 0xCF}, {0xB7, 0xD0}, {0xB7, 0xD1}, {0xB7, 0xD2}, /* 0x6C-0x6F */
	{0xB7, 0xD3}, {0xB7, 0xD4}, {0xB7, 0xD5}, {0xB7, 0xD6}, /* 0x70-0x73 */
	{0xB7, 0xD7}, {0xB7, 0xD8}, {0xB7, 0xD9}, {0xB7, 0xDA}, /* 0x74-0x77 */
	{0xB7, 0xDB}, {0xB7, 0xDC}, {0xB7, 0xDD}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xB7, 0xDE}, {0xB7, 0xDF}, {0xB7, 0xE0}, /* 0x80-0x83 */
	{0xB7, 0xE1}, {0xB7, 0xE2}, {0xB7, 0xE3}, {0xB7, 0xE4}, /* 0x84-0x87 */
	{0xB7, 0xE5}, {0xB7, 0xE6}, {0xB7, 0xE7}, {0xB7, 0xE8}, /* 0x88-0x8B */
	{0xB7, 0xE9}, {0xB7, 0xEA}, {0xB7, 0xEB}, {0xB7, 0xEE}, /* 0x8C-0x8F */
	{0xB7, 0xEF}, {0xB7, 0xF1}, {0xB7, 0xF2}, {0xB7, 0xF3}, /* 0x90-0x93 */
	{0xB7, 0xF5}, {0xB7, 0xF6}, {0xB7, 0xF7}, {0xB7, 0xF8}, /* 0x94-0x97 */
	{0xB7, 0xF9}, {0xB7, 0xFA}, {0xB7, 0xFB}, {0xB7, 0xFE}, /* 0x98-0x9B */
	{0xB8, 0x02}, {0xB8, 0x03}, {0xB8, 0x04}, {0xB8, 0x05}, /* 0x9C-0x9F */
	{0xB8, 0x06}, {0xB8, 0x0A}, {0xB8, 0x0B}, {0xB8, 0x0D}, /* 0xA0-0xA3 */
	{0xB8, 0x0E}, {0xB8, 0x0F}, {0xB8, 0x11}, {0xB8, 0x12}, /* 0xA4-0xA7 */
	{0xB8, 0x13}, {0xB8, 0x14}, {0xB8, 0x15}, {0xB8, 0x16}, /* 0xA8-0xAB */
	{0xB8, 0x17}, {0xB8, 0x1A}, {0xB8, 0x1C}, {0xB8, 0x1E}, /* 0xAC-0xAF */
	{0xB8, 0x1F}, {0xB8, 0x20}, {0xB8, 0x21}, {0xB8, 0x22}, /* 0xB0-0xB3 */
	{0xB8, 0x23}, {0xB8, 0x26}, {0xB8, 0x27}, {0xB8, 0x29}, /* 0xB4-0xB7 */
	{0xB8, 0x2A}, {0xB8, 0x2B}, {0xB8, 0x2D}, {0xB8, 0x2E}, /* 0xB8-0xBB */
	{0xB8, 0x2F}, {0xB8, 0x30}, {0xB8, 0x31}, {0xB8, 0x32}, /* 0xBC-0xBF */
	{0xB8, 0x33}, {0xB8, 0x36}, {0xB8, 0x3A}, {0xB8, 0x3B}, /* 0xC0-0xC3 */
	{0xB8, 0x3C}, {0xB8, 0x3D}, {0xB8, 0x3E}, {0xB8, 0x3F}, /* 0xC4-0xC7 */
	{0xB8, 0x41}, {0xB8, 0x42}, {0xB8, 0x43}, {0xB8, 0x45}, /* 0xC8-0xCB */
	{0xB8, 0x46}, {0xB8, 0x47}, {0xB8, 0x48}, {0xB8, 0x49}, /* 0xCC-0xCF */
	{0xB8, 0x4A}, {0xB8, 0x4B}, {0xB8, 0x4C}, {0xB8, 0x4D}, /* 0xD0-0xD3 */
	{0xB8, 0x4E}, {0xB8, 0x4F}, {0xB8, 0x50}, {0xB8, 0x52}, /* 0xD4-0xD7 */
	{0xB8, 0x54}, {0xB8, 0x55}, {0xB8, 0x56}, {0xB8, 0x57}, /* 0xD8-0xDB */
	{0xB8, 0x58}, {0xB8, 0x59}, {0xB8, 0x5A}, {0xB8, 0x5B}, /* 0xDC-0xDF */
	{0xB8, 0x5E}, {0xB8, 0x5F}, {0xB8, 0x61}, {0xB8, 0x62}, /* 0xE0-0xE3 */
	{0xB8, 0x63}, {0xB8, 0x65}, {0xB8, 0x66}, {0xB8, 0x67}, /* 0xE4-0xE7 */
	{0xB8, 0x68}, {0xB8, 0x69}, {0xB8, 0x6A}, {0xB8, 0x6B}, /* 0xE8-0xEB */
	{0xB8, 0x6E}, {0xB8, 0x70}, {0xB8, 0x72}, {0xB8, 0x73}, /* 0xEC-0xEF */
	{0xB8, 0x74}, {0xB8, 0x75}, {0xB8, 0x76}, {0xB8, 0x77}, /* 0xF0-0xF3 */
	{0xB8, 0x79}, {0xB8, 0x7A}, {0xB8, 0x7B}, {0xB8, 0x7D}, /* 0xF4-0xF7 */
	{0xB8, 0x7E}, {0xB8, 0x7F}, {0xB8, 0x80}, {0xB8, 0x81}, /* 0xF8-0xFB */
	{0xB8, 0x82}, {0xB8, 0x83}, {0xB8, 0x84}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_8F[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xB8, 0x85}, {0xB8, 0x86}, {0xB8, 0x87}, /* 0x40-0x43 */
	{0xB8, 0x88}, {0xB8, 0x89}, {0xB8, 0x8A}, {0xB8, 0x8B}, /* 0x44-0x47 */
	{0xB8, 0x8C}, {0xB8, 0x8E}, {0xB8, 0x8F}, {0xB8, 0x90}, /* 0x48-0x4B */
	{0xB8, 0x91}, {0xB8, 0x92}, {0xB8, 0x93}, {0xB8, 0x94}, /* 0x4C-0x4F */
	{0xB8, 0x95}, {0xB8, 0x96}, {0xB8, 0x97}, {0xB8, 0x98}, /* 0x50-0x53 */
	{0xB8, 0x99}, {0xB8, 0x9A}, {0xB8, 0x9B}, {0xB8, 0x9C}, /* 0x54-0x57 */
	{0xB8, 0x9D}, {0xB8, 0x9E}, {0xB8, 0x9F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xB8, 0xA0}, {0xB8, 0xA1}, {0xB8, 0xA2}, /* 0x60-0x63 */
	{0xB8, 0xA3}, {0xB8, 0xA4}, {0xB8, 0xA5}, {0xB8, 0xA6}, /* 0x64-0x67 */
	{0xB8, 0xA7}, {0xB8, 0xA9}, {0xB8, 0xAA}, {0xB8, 0xAB}, /* 0x68-0x6B */
	{0xB8, 0xAC}, {0xB8, 0xAD}, {0xB8, 0xAE}, {0xB8, 0xAF}, /* 0x6C-0x6F */
	{0xB8, 0xB1}, {0xB8, 0xB2}, {0xB8, 0xB3}, {0xB8, 0xB5}, /* 0x70-0x73 */
	{0xB8, 0xB6}, {0xB8, 0xB7}, {0xB8, 0xB9}, {0xB8, 0xBA}, /* 0x74-0x77 */
	{0xB8, 0xBB}, {0xB8, 0xBC}, {0xB8, 0xBD}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xB8, 0xBE}, {0xB8, 0xBF}, {0xB8, 0xC2}, /* 0x80-0x83 */
	{0xB8, 0xC4}, {0xB8, 0xC6}, {0xB8, 0xC7}, {0xB8, 0xC8}, /* 0x84-0x87 */
	{0xB8, 0xC9}, {0xB8, 0xCA}, {0xB8, 0xCB}, {0xB8, 0xCD}, /* 0x88-0x8B */
	{0xB8, 0xCE}, {0xB8, 0xCF}, {0xB8, 0xD1}, {0xB8, 0xD2}, /* 0x8C-0x8F */
	{0xB8, 0xD3}, {0xB8, 0xD5}, {0xB8, 0xD6}, {0xB8, 0xD7}, /* 0x90-0x93 */
	{0xB8, 0xD8}, {0xB8, 0xD9}, {0xB8, 0xDA}, {0xB8, 0xDB}, /* 0x94-0x97 */
	{0xB8, 0xDC}, {0xB8, 0xDE}, {0xB8, 0xE0}, {0xB8, 0xE2}, /* 0x98-0x9B */
	{0xB8, 0xE3}, {0xB8, 0xE4}, {0xB8, 0xE5}, {0xB8, 0xE6}, /* 0x9C-0x9F */
	{0xB8, 0xE7}, {0xB8, 0xEA}, {0xB8, 0xEB}, {0xB8, 0xED}, /* 0xA0-0xA3 */
	{0xB8, 0xEE}, {0xB8, 0xEF}, {0xB8, 0xF1}, {0xB8, 0xF2}, /* 0xA4-0xA7 */
	{0xB8, 0xF3}, {0xB8, 0xF4}, {0xB8, 0xF5}, {0xB8, 0xF6}, /* 0xA8-0xAB */
	{0xB8, 0xF7}, {0xB8, 0xFA}, {0xB8, 0xFC}, {0xB8, 0xFE}, /* 0xAC-0xAF */
	{0xB8, 0xFF}, {0xB9, 0x00}, {0xB9, 0x01}, {0xB9, 0x02}, /* 0xB0-0xB3 */
	{0xB9, 0x03}, {0xB9, 0x05}, {0xB9, 0x06}, {0xB9, 0x07}, /* 0xB4-0xB7 */
	{0xB9, 0x08}, {0xB9, 0x09}, {0xB9, 0x0A}, {0xB9, 0x0B}, /* 0xB8-0xBB */
	{0xB9, 0x0C}, {0xB9, 0x0D}, {0xB9, 0x0E}, {0xB9, 0x0F}, /* 0xBC-0xBF */
	{0xB9, 0x10}, {0xB9, 0x11}, {0xB9, 0x12}, {0xB9, 0x13}, /* 0xC0-0xC3 */
	{0xB9, 0x14}, {0xB9, 0x15}, {0xB9, 0x16}, {0xB9, 0x17}, /* 0xC4-0xC7 */
	{0xB9, 0x19}, {0xB9, 0x1A}, {0xB9, 0x1B}, {0xB9, 0x1C}, /* 0xC8-0xCB */
	{0xB9, 0x1D}, {0xB9, 0x1E}, {0xB9, 0x1F}, {0xB9, 0x21}, /* 0xCC-0xCF */
	{0xB9, 0x22}, {0xB9, 0x23}, {0xB9, 0x24}, {0xB9, 0x25}, /* 0xD0-0xD3 */
	{0xB9, 0x26}, {0xB9, 0x27}, {0xB9, 0x28}, {0xB9, 0x29}, /* 0xD4-0xD7 */
	{0xB9, 0x2A}, {0xB9, 0x2B}, {0xB9, 0x2C}, {0xB9, 0x2D}, /* 0xD8-0xDB */
	{0xB9, 0x2E}, {0xB9, 0x2F}, {0xB9, 0x30}, {0xB9, 0x31}, /* 0xDC-0xDF */
	{0xB9, 0x32}, {0xB9, 0x33}, {0xB9, 0x34}, {0xB9, 0x35}, /* 0xE0-0xE3 */
	{0xB9, 0x36}, {0xB9, 0x37}, {0xB9, 0x38}, {0xB9, 0x39}, /* 0xE4-0xE7 */
	{0xB9, 0x3A}, {0xB9, 0x3B}, {0xB9, 0x3E}, {0xB9, 0x3F}, /* 0xE8-0xEB */
	{0xB9, 0x41}, {0xB9, 0x42}, {0xB9, 0x43}, {0xB9, 0x45}, /* 0xEC-0xEF */
	{0xB9, 0x46}, {0xB9, 0x47}, {0xB9, 0x48}, {0xB9, 0x49}, /* 0xF0-0xF3 */
	{0xB9, 0x4A}, {0xB9, 0x4B}, {0xB9, 0x4D}, {0xB9, 0x4E}, /* 0xF4-0xF7 */
	{0xB9, 0x50}, {0xB9, 0x52}, {0xB9, 0x53}, {0xB9, 0x54}, /* 0xF8-0xFB */
	{0xB9, 0x55}, {0xB9, 0x56}, {0xB9, 0x57}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_90[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xB9, 0x5A}, {0xB9, 0x5B}, {0xB9, 0x5D}, /* 0x40-0x43 */
	{0xB9, 0x5E}, {0xB9, 0x5F}, {0xB9, 0x61}, {0xB9, 0x62}, /* 0x44-0x47 */
	{0xB9, 0x63}, {0xB9, 0x64}, {0xB9, 0x65}, {0xB9, 0x66}, /* 0x48-0x4B */
	{0xB9, 0x67}, {0xB9, 0x6A}, {0xB9, 0x6C}, {0xB9, 0x6E}, /* 0x4C-0x4F */
	{0xB9, 0x6F}, {0xB9, 0x70}, {0xB9, 0x71}, {0xB9, 0x72}, /* 0x50-0x53 */
	{0xB9, 0x73}, {0xB9, 0x76}, {0xB9, 0x77}, {0xB9, 0x79}, /* 0x54-0x57 */
	{0xB9, 0x7A}, {0xB9, 0x7B}, {0xB9, 0x7D}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xB9, 0x7E}, {0xB9, 0x7F}, {0xB9, 0x80}, /* 0x60-0x63 */
	{0xB9, 0x81}, {0xB9, 0x82}, {0xB9, 0x83}, {0xB9, 0x86}, /* 0x64-0x67 */
	{0xB9, 0x88}, {0xB9, 0x8B}, {0xB9, 0x8C}, {0xB9, 0x8F}, /* 0x68-0x6B */
	{0xB9, 0x90}, {0xB9, 0x91}, {0xB9, 0x92}, {0xB9, 0x93}, /* 0x6C-0x6F */
	{0xB9, 0x94}, {0xB9, 0x95}, {0xB9, 0x96}, {0xB9, 0x97}, /* 0x70-0x73 */
	{0xB9, 0x98}, {0xB9, 0x99}, {0xB9, 0x9A}, {0xB9, 0x9B}, /* 0x74-0x77 */
	{0xB9, 0x9C}, {0xB9, 0x9D}, {0xB9, 0x9E}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xB9, 0x9F}, {0xB9, 0xA0}, {0xB9, 0xA1}, /* 0x80-0x83 */
	{0xB9, 0xA2}, {0xB9, 0xA3}, {0xB9, 0xA4}, {0xB9, 0xA5}, /* 0x84-0x87 */
	{0xB9, 0xA6}, {0xB9, 0xA7}, {0xB9, 0xA8}, {0xB9, 0xA9}, /* 0x88-0x8B */
	{0xB9, 0xAA}, {0xB9, 0xAB}, {0xB9, 0xAE}, {0xB9, 0xAF}, /* 0x8C-0x8F */
	{0xB9, 0xB1}, {0xB9, 0xB2}, {0xB9, 0xB3}, {0xB9, 0xB5}, /* 0x90-0x93 */
	{0xB9, 0xB6}, {0xB9, 0xB7}, {0xB9, 0xB8}, {0xB9, 0xB9}, /* 0x94-0x97 */
	{0xB9, 0xBA}, {0xB9, 0xBB}, {0xB9, 0xBE}, {0xB9, 0xC0}, /* 0x98-0x9B */
	{0xB9, 0xC2}, {0xB9, 0xC3}, {0xB9, 0xC4}, {0xB9, 0xC5}, /* 0x9C-0x9F */
	{0xB9, 0xC6}, {0xB9, 0xC7}, {0xB9, 0xCA}, {0xB9, 0xCB}, /* 0xA0-0xA3 */
	{0xB9, 0xCD}, {0xB9, 0xD3}, {0xB9, 0xD4}, {0xB9, 0xD5}, /* 0xA4-0xA7 */
	{0xB9, 0xD6}, {0xB9, 0xD7}, {0xB9, 0xDA}, {0xB9, 0xDC}, /* 0xA8-0xAB */
	{0xB9, 0xDF}, {0xB9, 0xE0}, {0xB9, 0xE2}, {0xB9, 0xE6}, /* 0xAC-0xAF */
	{0xB9, 0xE7}, {0xB9, 0xE9}, {0xB9, 0xEA}, {0xB9, 0xEB}, /* 0xB0-0xB3 */
	{0xB9, 0xED}, {0xB9, 0xEE}, {0xB9, 0xEF}, {0xB9, 0xF0}, /* 0xB4-0xB7 */
	{0xB9, 0xF1}, {0xB9, 0xF2}, {0xB9, 0xF3}, {0xB9, 0xF6}, /* 0xB8-0xBB */
	{0xB9, 0xFB}, {0xB9, 0xFC}, {0xB9, 0xFD}, {0xB9, 0xFE}, /* 0xBC-0xBF */
	{0xB9, 0xFF}, {0xBA, 0x02}, {0xBA, 0x03}, {0xBA, 0x04}, /* 0xC0-0xC3 */
	{0xBA, 0x05}, {0xBA, 0x06}, {0xBA, 0x07}, {0xBA, 0x09}, /* 0xC4-0xC7 */
	{0xBA, 0x0A}, {0xBA, 0x0B}, {0xBA, 0x0C}, {0xBA, 0x0D}, /* 0xC8-0xCB */
	{0xBA, 0x0E}, {0xBA, 0x0F}, {0xBA, 0x10}, {0xBA, 0x11}, /* 0xCC-0xCF */
	{0xBA, 0x12}, {0xBA, 0x13}, {0xBA, 0x14}, {0xBA, 0x16}, /* 0xD0-0xD3 */
	{0xBA, 0x17}, {0xBA, 0x18}, {0xBA, 0x19}, {0xBA, 0x1A}, /* 0xD4-0xD7 */
	{0xBA, 0x1B}, {0xBA, 0x1C}, {0xBA, 0x1D}, {0xBA, 0x1E}, /* 0xD8-0xDB */
	{0xBA, 0x1F}, {0xBA, 0x20}, {0xBA, 0x21}, {0xBA, 0x22}, /* 0xDC-0xDF */
	{0xBA, 0x23}, {0xBA, 0x24}, {0xBA, 0x25}, {0xBA, 0x26}, /* 0xE0-0xE3 */
	{0xBA, 0x27}, {0xBA, 0x28}, {0xBA, 0x29}, {0xBA, 0x2A}, /* 0xE4-0xE7 */
	{0xBA, 0x2B}, {0xBA, 0x2C}, {0xBA, 0x2D}, {0xBA, 0x2E}, /* 0xE8-0xEB */
	{0xBA, 0x2F}, {0xBA, 0x30}, {0xBA, 0x31}, {0xBA, 0x32}, /* 0xEC-0xEF */
	{0xBA, 0x33}, {0xBA, 0x34}, {0xBA, 0x35}, {0xBA, 0x36}, /* 0xF0-0xF3 */
	{0xBA, 0x37}, {0xBA, 0x3A}, {0xBA, 0x3B}, {0xBA, 0x3D}, /* 0xF4-0xF7 */
	{0xBA, 0x3E}, {0xBA, 0x3F}, {0xBA, 0x41}, {0xBA, 0x43}, /* 0xF8-0xFB */
	{0xBA, 0x44}, {0xBA, 0x45}, {0xBA, 0x46}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_91[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xBA, 0x47}, {0xBA, 0x4A}, {0xBA, 0x4C}, /* 0x40-0x43 */
	{0xBA, 0x4F}, {0xBA, 0x50}, {0xBA, 0x51}, {0xBA, 0x52}, /* 0x44-0x47 */
	{0xBA, 0x56}, {0xBA, 0x57}, {0xBA, 0x59}, {0xBA, 0x5A}, /* 0x48-0x4B */
	{0xBA, 0x5B}, {0xBA, 0x5D}, {0xBA, 0x5E}, {0xBA, 0x5F}, /* 0x4C-0x4F */
	{0xBA, 0x60}, {0xBA, 0x61}, {0xBA, 0x62}, {0xBA, 0x63}, /* 0x50-0x53 */
	{0xBA, 0x66}, {0xBA, 0x6A}, {0xBA, 0x6B}, {0xBA, 0x6C}, /* 0x54-0x57 */
	{0xBA, 0x6D}, {0xBA, 0x6E}, {0xBA, 0x6F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xBA, 0x72}, {0xBA, 0x73}, {0xBA, 0x75}, /* 0x60-0x63 */
	{0xBA, 0x76}, {0xBA, 0x77}, {0xBA, 0x79}, {0xBA, 0x7A}, /* 0x64-0x67 */
	{0xBA, 0x7B}, {0xBA, 0x7C}, {0xBA, 0x7D}, {0xBA, 0x7E}, /* 0x68-0x6B */
	{0xBA, 0x7F}, {0xBA, 0x80}, {0xBA, 0x81}, {0xBA, 0x82}, /* 0x6C-0x6F */
	{0xBA, 0x86}, {0xBA, 0x88}, {0xBA, 0x89}, {0xBA, 0x8A}, /* 0x70-0x73 */
	{0xBA, 0x8B}, {0xBA, 0x8D}, {0xBA, 0x8E}, {0xBA, 0x8F}, /* 0x74-0x77 */
	{0xBA, 0x90}, {0xBA, 0x91}, {0xBA, 0x92}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xBA, 0x93}, {0xBA, 0x94}, {0xBA, 0x95}, /* 0x80-0x83 */
	{0xBA, 0x96}, {0xBA, 0x97}, {0xBA, 0x98}, {0xBA, 0x99}, /* 0x84-0x87 */
	{0xBA, 0x9A}, {0xBA, 0x9B}, {0xBA, 0x9C}, {0xBA, 0x9D}, /* 0x88-0x8B */
	{0xBA, 0x9E}, {0xBA, 0x9F}, {0xBA, 0xA0}, {0xBA, 0xA1}, /* 0x8C-0x8F */
	{0xBA, 0xA2}, {0xBA, 0xA3}, {0xBA, 0xA4}, {0xBA, 0xA5}, /* 0x90-0x93 */
	{0xBA, 0xA6}, {0xBA, 0xA7}, {0xBA, 0xAA}, {0xBA, 0xAD}, /* 0x94-0x97 */
	{0xBA, 0xAE}, {0xBA, 0xAF}, {0xBA, 0xB1}, {0xBA, 0xB3}, /* 0x98-0x9B */
	{0xBA, 0xB4}, {0xBA, 0xB5}, {0xBA, 0xB6}, {0xBA, 0xB7}, /* 0x9C-0x9F */
	{0xBA, 0xBA}, {0xBA, 0xBC}, {0xBA, 0xBE}, {0xBA, 0xBF}, /* 0xA0-0xA3 */
	{0xBA, 0xC0}, {0xBA, 0xC1}, {0xBA, 0xC2}, {0xBA, 0xC3}, /* 0xA4-0xA7 */
	{0xBA, 0xC5}, {0xBA, 0xC6}, {0xBA, 0xC7}, {0xBA, 0xC9}, /* 0xA8-0xAB */
	{0xBA, 0xCA}, {0xBA, 0xCB}, {0xBA, 0xCC}, {0xBA, 0xCD}, /* 0xAC-0xAF */
	{0xBA, 0xCE}, {0xBA, 0xCF}, {0xBA, 0xD0}, {0xBA, 0xD1}, /* 0xB0-0xB3 */
	{0xBA, 0xD2}, {0xBA, 0xD3}, {0xBA, 0xD4}, {0xBA, 0xD5}, /* 0xB4-0xB7 */
	{0xBA, 0xD6}, {0xBA, 0xD7}, {0xBA, 0xDA}, {0xBA, 0xDB}, /* 0xB8-0xBB */
	{0xBA, 0xDC}, {0xBA, 0xDD}, {0xBA, 0xDE}, {0xBA, 0xDF}, /* 0xBC-0xBF */
	{0xBA, 0xE0}, {0xBA, 0xE1}, {0xBA, 0xE2}, {0xBA, 0xE3}, /* 0xC0-0xC3 */
	{0xBA, 0xE4}, {0xBA, 0xE5}, {0xBA, 0xE6}, {0xBA, 0xE7}, /* 0xC4-0xC7 */
	{0xBA, 0xE8}, {0xBA, 0xE9}, {0xBA, 0xEA}, {0xBA, 0xEB}, /* 0xC8-0xCB */
	{0xBA, 0xEC}, {0xBA, 0xED}, {0xBA, 0xEE}, {0xBA, 0xEF}, /* 0xCC-0xCF */
	{0xBA, 0xF0}, {0xBA, 0xF1}, {0xBA, 0xF2}, {0xBA, 0xF3}, /* 0xD0-0xD3 */
	{0xBA, 0xF4}, {0xBA, 0xF5}, {0xBA, 0xF6}, {0xBA, 0xF7}, /* 0xD4-0xD7 */
	{0xBA, 0xF8}, {0xBA, 0xF9}, {0xBA, 0xFA}, {0xBA, 0xFB}, /* 0xD8-0xDB */
	{0xBA, 0xFD}, {0xBA, 0xFE}, {0xBA, 0xFF}, {0xBB, 0x01}, /* 0xDC-0xDF */
	{0xBB, 0x02}, {0xBB, 0x03}, {0xBB, 0x05}, {0xBB, 0x06}, /* 0xE0-0xE3 */
	{0xBB, 0x07}, {0xBB, 0x08}, {0xBB, 0x09}, {0xBB, 0x0A}, /* 0xE4-0xE7 */
	{0xBB, 0x0B}, {0xBB, 0x0C}, {0xBB, 0x0E}, {0xBB, 0x10}, /* 0xE8-0xEB */
	{0xBB, 0x12}, {0xBB, 0x13}, {0xBB, 0x14}, {0xBB, 0x15}, /* 0xEC-0xEF */
	{0xBB, 0x16}, {0xBB, 0x17}, {0xBB, 0x19}, {0xBB, 0x1A}, /* 0xF0-0xF3 */
	{0xBB, 0x1B}, {0xBB, 0x1D}, {0xBB, 0x1E}, {0xBB, 0x1F}, /* 0xF4-0xF7 */
	{0xBB, 0x21}, {0xBB, 0x22}, {0xBB, 0x23}, {0xBB, 0x24}, /* 0xF8-0xFB */
	{0xBB, 0x25}, {0xBB, 0x26}, {0xBB, 0x27}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_92[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xBB, 0x28}, {0xBB, 0x2A}, {0xBB, 0x2C}, /* 0x40-0x43 */
	{0xBB, 0x2D}, {0xBB, 0x2E}, {0xBB, 0x2F}, {0xBB, 0x30}, /* 0x44-0x47 */
	{0xBB, 0x31}, {0xBB, 0x32}, {0xBB, 0x33}, {0xBB, 0x37}, /* 0x48-0x4B */
	{0xBB, 0x39}, {0xBB, 0x3A}, {0xBB, 0x3F}, {0xBB, 0x40}, /* 0x4C-0x4F */
	{0xBB, 0x41}, {0xBB, 0x42}, {0xBB, 0x43}, {0xBB, 0x46}, /* 0x50-0x53 */
	{0xBB, 0x48}, {0xBB, 0x4A}, {0xBB, 0x4B}, {0xBB, 0x4C}, /* 0x54-0x57 */
	{0xBB, 0x4E}, {0xBB, 0x51}, {0xBB, 0x52}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xBB, 0x53}, {0xBB, 0x55}, {0xBB, 0x56}, /* 0x60-0x63 */
	{0xBB, 0x57}, {0xBB, 0x59}, {0xBB, 0x5A}, {0xBB, 0x5B}, /* 0x64-0x67 */
	{0xBB, 0x5C}, {0xBB, 0x5D}, {0xBB, 0x5E}, {0xBB, 0x5F}, /* 0x68-0x6B */
	{0xBB, 0x60}, {0xBB, 0x62}, {0xBB, 0x64}, {0xBB, 0x65}, /* 0x6C-0x6F */
	{0xBB, 0x66}, {0xBB, 0x67}, {0xBB, 0x68}, {0xBB, 0x69}, /* 0x70-0x73 */
	{0xBB, 0x6A}, {0xBB, 0x6B}, {0xBB, 0x6D}, {0xBB, 0x6E}, /* 0x74-0x77 */
	{0xBB, 0x6F}, {0xBB, 0x70}, {0xBB, 0x71}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xBB, 0x72}, {0xBB, 0x73}, {0xBB, 0x74}, /* 0x80-0x83 */
	{0xBB, 0x75}, {0xBB, 0x76}, {0xBB, 0x77}, {0xBB, 0x78}, /* 0x84-0x87 */
	{0xBB, 0x79}, {0xBB, 0x7A}, {0xBB, 0x7B}, {0xBB, 0x7C}, /* 0x88-0x8B */
	{0xBB, 0x7D}, {0xBB, 0x7E}, {0xBB, 0x7F}, {0xBB, 0x80}, /* 0x8C-0x8F */
	{0xBB, 0x81}, {0xBB, 0x82}, {0xBB, 0x83}, {0xBB, 0x84}, /* 0x90-0x93 */
	{0xBB, 0x85}, {0xBB, 0x86}, {0xBB, 0x87}, {0xBB, 0x89}, /* 0x94-0x97 */
	{0xBB, 0x8A}, {0xBB, 0x8B}, {0xBB, 0x8D}, {0xBB, 0x8E}, /* 0x98-0x9B */
	{0xBB, 0x8F}, {0xBB, 0x91}, {0xBB, 0x92}, {0xBB, 0x93}, /* 0x9C-0x9F */
	{0xBB, 0x94}, {0xBB, 0x95}, {0xBB, 0x96}, {0xBB, 0x97}, /* 0xA0-0xA3 */
	{0xBB, 0x98}, {0xBB, 0x99}, {0xBB, 0x9A}, {0xBB, 0x9B}, /* 0xA4-0xA7 */
	{0xBB, 0x9C}, {0xBB, 0x9D}, {0xBB, 0x9E}, {0xBB, 0x9F}, /* 0xA8-0xAB */
	{0xBB, 0xA0}, {0xBB, 0xA1}, {0xBB, 0xA2}, {0xBB, 0xA3}, /* 0xAC-0xAF */
	{0xBB, 0xA5}, {0xBB, 0xA6}, {0xBB, 0xA7}, {0xBB, 0xA9}, /* 0xB0-0xB3 */
	{0xBB, 0xAA}, {0xBB, 0xAB}, {0xBB, 0xAD}, {0xBB, 0xAE}, /* 0xB4-0xB7 */
	{0xBB, 0xAF}, {0xBB, 0xB0}, {0xBB, 0xB1}, {0xBB, 0xB2}, /* 0xB8-0xBB */
	{0xBB, 0xB3}, {0xBB, 0xB5}, {0xBB, 0xB6}, {0xBB, 0xB8}, /* 0xBC-0xBF */
	{0xBB, 0xB9}, {0xBB, 0xBA}, {0xBB, 0xBB}, {0xBB, 0xBC}, /* 0xC0-0xC3 */
	{0xBB, 0xBD}, {0xBB, 0xBE}, {0xBB, 0xBF}, {0xBB, 0xC1}, /* 0xC4-0xC7 */
	{0xBB, 0xC2}, {0xBB, 0xC3}, {0xBB, 0xC5}, {0xBB, 0xC6}, /* 0xC8-0xCB */
	{0xBB, 0xC7}, {0xBB, 0xC9}, {0xBB, 0xCA}, {0xBB, 0xCB}, /* 0xCC-0xCF */
	{0xBB, 0xCC}, {0xBB, 0xCD}, {0xBB, 0xCE}, {0xBB, 0xCF}, /* 0xD0-0xD3 */
	{0xBB, 0xD1}, {0xBB, 0xD2}, {0xBB, 0xD4}, {0xBB, 0xD5}, /* 0xD4-0xD7 */
	{0xBB, 0xD6}, {0xBB, 0xD7}, {0xBB, 0xD8}, {0xBB, 0xD9}, /* 0xD8-0xDB */
	{0xBB, 0xDA}, {0xBB, 0xDB}, {0xBB, 0xDC}, {0xBB, 0xDD}, /* 0xDC-0xDF */
	{0xBB, 0xDE}, {0xBB, 0xDF}, {0xBB, 0xE0}, {0xBB, 0xE1}, /* 0xE0-0xE3 */
	{0xBB, 0xE2}, {0xBB, 0xE3}, {0xBB, 0xE4}, {0xBB, 0xE5}, /* 0xE4-0xE7 */
	{0xBB, 0xE6}, {0xBB, 0xE7}, {0xBB, 0xE8}, {0xBB, 0xE9}, /* 0xE8-0xEB */
	{0xBB, 0xEA}, {0xBB, 0xEB}, {0xBB, 0xEC}, {0xBB, 0xED}, /* 0xEC-0xEF */
	{0xBB, 0xEE}, {0xBB, 0xEF}, {0xBB, 0xF0}, {0xBB, 0xF1}, /* 0xF0-0xF3 */
	{0xBB, 0xF2}, {0xBB, 0xF3}, {0xBB, 0xF4}, {0xBB, 0xF5}, /* 0xF4-0xF7 */
	{0xBB, 0xF6}, {0xBB, 0xF7}, {0xBB, 0xFA}, {0xBB, 0xFB}, /* 0xF8-0xFB */
	{0xBB, 0xFD}, {0xBB, 0xFE}, {0xBC, 0x01}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_93[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xBC, 0x03}, {0xBC, 0x04}, {0xBC, 0x05}, /* 0x40-0x43 */
	{0xBC, 0x06}, {0xBC, 0x07}, {0xBC, 0x0A}, {0xBC, 0x0E}, /* 0x44-0x47 */
	{0xBC, 0x10}, {0xBC, 0x12}, {0xBC, 0x13}, {0xBC, 0x19}, /* 0x48-0x4B */
	{0xBC, 0x1A}, {0xBC, 0x20}, {0xBC, 0x21}, {0xBC, 0x22}, /* 0x4C-0x4F */
	{0xBC, 0x23}, {0xBC, 0x26}, {0xBC, 0x28}, {0xBC, 0x2A}, /* 0x50-0x53 */
	{0xBC, 0x2B}, {0xBC, 0x2C}, {0xBC, 0x2E}, {0xBC, 0x2F}, /* 0x54-0x57 */
	{0xBC, 0x32}, {0xBC, 0x33}, {0xBC, 0x35}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xBC, 0x36}, {0xBC, 0x37}, {0xBC, 0x39}, /* 0x60-0x63 */
	{0xBC, 0x3A}, {0xBC, 0x3B}, {0xBC, 0x3C}, {0xBC, 0x3D}, /* 0x64-0x67 */
	{0xBC, 0x3E}, {0xBC, 0x3F}, {0xBC, 0x42}, {0xBC, 0x46}, /* 0x68-0x6B */
	{0xBC, 0x47}, {0xBC, 0x48}, {0xBC, 0x4A}, {0xBC, 0x4B}, /* 0x6C-0x6F */
	{0xBC, 0x4E}, {0xBC, 0x4F}, {0xBC, 0x51}, {0xBC, 0x52}, /* 0x70-0x73 */
	{0xBC, 0x53}, {0xBC, 0x54}, {0xBC, 0x55}, {0xBC, 0x56}, /* 0x74-0x77 */
	{0xBC, 0x57}, {0xBC, 0x58}, {0xBC, 0x59}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xBC, 0x5A}, {0xBC, 0x5B}, {0xBC, 0x5C}, /* 0x80-0x83 */
	{0xBC, 0x5E}, {0xBC, 0x5F}, {0xBC, 0x60}, {0xBC, 0x61}, /* 0x84-0x87 */
	{0xBC, 0x62}, {0xBC, 0x63}, {0xBC, 0x64}, {0xBC, 0x65}, /* 0x88-0x8B */
	{0xBC, 0x66}, {0xBC, 0x67}, {0xBC, 0x68}, {0xBC, 0x69}, /* 0x8C-0x8F */
	{0xBC, 0x6A}, {0xBC, 0x6B}, {0xBC, 0x6C}, {0xBC, 0x6D}, /* 0x90-0x93 */
	{0xBC, 0x6E}, {0xBC, 0x6F}, {0xBC, 0x70}, {0xBC, 0x71}, /* 0x94-0x97 */
	{0xBC, 0x72}, {0xBC, 0x73}, {0xBC, 0x74}, {0xBC, 0x75}, /* 0x98-0x9B */
	{0xBC, 0x76}, {0xBC, 0x77}, {0xBC, 0x78}, {0xBC, 0x79}, /* 0x9C-0x9F */
	{0xBC, 0x7A}, {0xBC, 0x7B}, {0xBC, 0x7C}, {0xBC, 0x7D}, /* 0xA0-0xA3 */
	{0xBC, 0x7E}, {0xBC, 0x7F}, {0xBC, 0x80}, {0xBC, 0x81}, /* 0xA4-0xA7 */
	{0xBC, 0x82}, {0xBC, 0x83}, {0xBC, 0x86}, {0xBC, 0x87}, /* 0xA8-0xAB */
	{0xBC, 0x89}, {0xBC, 0x8A}, {0xBC, 0x8D}, {0xBC, 0x8F}, /* 0xAC-0xAF */
	{0xBC, 0x90}, {0xBC, 0x91}, {0xBC, 0x92}, {0xBC, 0x93}, /* 0xB0-0xB3 */
	{0xBC, 0x96}, {0xBC, 0x98}, {0xBC, 0x9B}, {0xBC, 0x9C}, /* 0xB4-0xB7 */
	{0xBC, 0x9D}, {0xBC, 0x9E}, {0xBC, 0x9F}, {0xBC, 0xA2}, /* 0xB8-0xBB */
	{0xBC, 0xA3}, {0xBC, 0xA5}, {0xBC, 0xA6}, {0xBC, 0xA9}, /* 0xBC-0xBF */
	{0xBC, 0xAA}, {0xBC, 0xAB}, {0xBC, 0xAC}, {0xBC, 0xAD}, /* 0xC0-0xC3 */
	{0xBC, 0xAE}, {0xBC, 0xAF}, {0xBC, 0xB2}, {0xBC, 0xB6}, /* 0xC4-0xC7 */
	{0xBC, 0xB7}, {0xBC, 0xB8}, {0xBC, 0xB9}, {0xBC, 0xBA}, /* 0xC8-0xCB */
	{0xBC, 0xBB}, {0xBC, 0xBE}, {0xBC, 0xBF}, {0xBC, 0xC1}, /* 0xCC-0xCF */
	{0xBC, 0xC2}, {0xBC, 0xC3}, {0xBC, 0xC5}, {0xBC, 0xC6}, /* 0xD0-0xD3 */
	{0xBC, 0xC7}, {0xBC, 0xC8}, {0xBC, 0xC9}, {0xBC, 0xCA}, /* 0xD4-0xD7 */
	{0xBC, 0xCB}, {0xBC, 0xCC}, {0xBC, 0xCE}, {0xBC, 0xD2}, /* 0xD8-0xDB */
	{0xBC, 0xD3}, {0xBC, 0xD4}, {0xBC, 0xD6}, {0xBC, 0xD7}, /* 0xDC-0xDF */
	{0xBC, 0xD9}, {0xBC, 0xDA}, {0xBC, 0xDB}, {0xBC, 0xDD}, /* 0xE0-0xE3 */
	{0xBC, 0xDE}, {0xBC, 0xDF}, {0xBC, 0xE0}, {0xBC, 0xE1}, /* 0xE4-0xE7 */
	{0xBC, 0xE2}, {0xBC, 0xE3}, {0xBC, 0xE4}, {0xBC, 0xE5}, /* 0xE8-0xEB */
	{0xBC, 0xE6}, {0xBC, 0xE7}, {0xBC, 0xE8}, {0xBC, 0xE9}, /* 0xEC-0xEF */
	{0xBC, 0xEA}, {0xBC, 0xEB}, {0xBC, 0xEC}, {0xBC, 0xED}, /* 0xF0-0xF3 */
	{0xBC, 0xEE}, {0xBC, 0xEF}, {0xBC, 0xF0}, {0xBC, 0xF1}, /* 0xF4-0xF7 */
	{0xBC, 0xF2}, {0xBC, 0xF3}, {0xBC, 0xF7}, {0xBC, 0xF9}, /* 0xF8-0xFB */
	{0xBC, 0xFA}, {0xBC, 0xFB}, {0xBC, 0xFD}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_94[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xBC, 0xFE}, {0xBC, 0xFF}, {0xBD, 0x00}, /* 0x40-0x43 */
	{0xBD, 0x01}, {0xBD, 0x02}, {0xBD, 0x03}, {0xBD, 0x06}, /* 0x44-0x47 */
	{0xBD, 0x08}, {0xBD, 0x0A}, {0xBD, 0x0B}, {0xBD, 0x0C}, /* 0x48-0x4B */
	{0xBD, 0x0D}, {0xBD, 0x0E}, {0xBD, 0x0F}, {0xBD, 0x11}, /* 0x4C-0x4F */
	{0xBD, 0x12}, {0xBD, 0x13}, {0xBD, 0x15}, {0xBD, 0x16}, /* 0x50-0x53 */
	{0xBD, 0x17}, {0xBD, 0x18}, {0xBD, 0x19}, {0xBD, 0x1A}, /* 0x54-0x57 */
	{0xBD, 0x1B}, {0xBD, 0x1C}, {0xBD, 0x1D}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xBD, 0x1E}, {0xBD, 0x1F}, {0xBD, 0x20}, /* 0x60-0x63 */
	{0xBD, 0x21}, {0xBD, 0x22}, {0xBD, 0x23}, {0xBD, 0x25}, /* 0x64-0x67 */
	{0xBD, 0x26}, {0xBD, 0x27}, {0xBD, 0x28}, {0xBD, 0x29}, /* 0x68-0x6B */
	{0xBD, 0x2A}, {0xBD, 0x2B}, {0xBD, 0x2D}, {0xBD, 0x2E}, /* 0x6C-0x6F */
	{0xBD, 0x2F}, {0xBD, 0x30}, {0xBD, 0x31}, {0xBD, 0x32}, /* 0x70-0x73 */
	{0xBD, 0x33}, {0xBD, 0x34}, {0xBD, 0x35}, {0xBD, 0x36}, /* 0x74-0x77 */
	{0xBD, 0x37}, {0xBD, 0x38}, {0xBD, 0x39}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xBD, 0x3A}, {0xBD, 0x3B}, {0xBD, 0x3C}, /* 0x80-0x83 */
	{0xBD, 0x3D}, {0xBD, 0x3E}, {0xBD, 0x3F}, {0xBD, 0x41}, /* 0x84-0x87 */
	{0xBD, 0x42}, {0xBD, 0x43}, {0xBD, 0x44}, {0xBD, 0x45}, /* 0x88-0x8B */
	{0xBD, 0x46}, {0xBD, 0x47}, {0xBD, 0x4A}, {0xBD, 0x4B}, /* 0x8C-0x8F */
	{0xBD, 0x4D}, {0xBD, 0x4E}, {0xBD, 0x4F}, {0xBD, 0x51}, /* 0x90-0x93 */
	{0xBD, 0x52}, {0xBD, 0x53}, {0xBD, 0x54}, {0xBD, 0x55}, /* 0x94-0x97 */
	{0xBD, 0x56}, {0xBD, 0x57}, {0xBD, 0x5A}, {0xBD, 0x5B}, /* 0x98-0x9B */
	{0xBD, 0x5C}, {0xBD, 0x5D}, {0xBD, 0x5E}, {0xBD, 0x5F}, /* 0x9C-0x9F */
	{0xBD, 0x60}, {0xBD, 0x61}, {0xBD, 0x62}, {0xBD, 0x63}, /* 0xA0-0xA3 */
	{0xBD, 0x65}, {0xBD, 0x66}, {0xBD, 0x67}, {0xBD, 0x69}, /* 0xA4-0xA7 */
	{0xBD, 0x6A}, {0xBD, 0x6B}, {0xBD, 0x6C}, {0xBD, 0x6D}, /* 0xA8-0xAB */
	{0xBD, 0x6E}, {0xBD, 0x6F}, {0xBD, 0x70}, {0xBD, 0x71}, /* 0xAC-0xAF */
	{0xBD, 0x72}, {0xBD, 0x73}, {0xBD, 0x74}, {0xBD, 0x75}, /* 0xB0-0xB3 */
	{0xBD, 0x76}, {0xBD, 0x77}, {0xBD, 0x78}, {0xBD, 0x79}, /* 0xB4-0xB7 */
	{0xBD, 0x7A}, {0xBD, 0x7B}, {0xBD, 0x7C}, {0xBD, 0x7D}, /* 0xB8-0xBB */
	{0xBD, 0x7E}, {0xBD, 0x7F}, {0xBD, 0x82}, {0xBD, 0x83}, /* 0xBC-0xBF */
	{0xBD, 0x85}, {0xBD, 0x86}, {0xBD, 0x8B}, {0xBD, 0x8C}, /* 0xC0-0xC3 */
	{0xBD, 0x8D}, {0xBD, 0x8E}, {0xBD, 0x8F}, {0xBD, 0x92}, /* 0xC4-0xC7 */
	{0xBD, 0x94}, {0xBD, 0x96}, {0xBD, 0x97}, {0xBD, 0x98}, /* 0xC8-0xCB */
	{0xBD, 0x9B}, {0xBD, 0x9D}, {0xBD, 0x9E}, {0xBD, 0x9F}, /* 0xCC-0xCF */
	{0xBD, 0xA0}, {0xBD, 0xA1}, {0xBD, 0xA2}, {0xBD, 0xA3}, /* 0xD0-0xD3 */
	{0xBD, 0xA5}, {0xBD, 0xA6}, {0xBD, 0xA7}, {0xBD, 0xA8}, /* 0xD4-0xD7 */
	{0xBD, 0xA9}, {0xBD, 0xAA}, {0xBD, 0xAB}, {0xBD, 0xAC}, /* 0xD8-0xDB */
	{0xBD, 0xAD}, {0xBD, 0xAE}, {0xBD, 0xAF}, {0xBD, 0xB1}, /* 0xDC-0xDF */
	{0xBD, 0xB2}, {0xBD, 0xB3}, {0xBD, 0xB4}, {0xBD, 0xB5}, /* 0xE0-0xE3 */
	{0xBD, 0xB6}, {0xBD, 0xB7}, {0xBD, 0xB9}, {0xBD, 0xBA}, /* 0xE4-0xE7 */
	{0xBD, 0xBB}, {0xBD, 0xBC}, {0xBD, 0xBD}, {0xBD, 0xBE}, /* 0xE8-0xEB */
	{0xBD, 0xBF}, {0xBD, 0xC0}, {0xBD, 0xC1}, {0xBD, 0xC2}, /* 0xEC-0xEF */
	{0xBD, 0xC3}, {0xBD, 0xC4}, {0xBD, 0xC5}, {0xBD, 0xC6}, /* 0xF0-0xF3 */
	{0xBD, 0xC7}, {0xBD, 0xC8}, {0xBD, 0xC9}, {0xBD, 0xCA}, /* 0xF4-0xF7 */
	{0xBD, 0xCB}, {0xBD, 0xCC}, {0xBD, 0xCD}, {0xBD, 0xCE}, /* 0xF8-0xFB */
	{0xBD, 0xCF}, {0xBD, 0xD0}, {0xBD, 0xD1}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_95[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xBD, 0xD2}, {0xBD, 0xD3}, {0xBD, 0xD6}, /* 0x40-0x43 */
	{0xBD, 0xD7}, {0xBD, 0xD9}, {0xBD, 0xDA}, {0xBD, 0xDB}, /* 0x44-0x47 */
	{0xBD, 0xDD}, {0xBD, 0xDE}, {0xBD, 0xDF}, {0xBD, 0xE0}, /* 0x48-0x4B */
	{0xBD, 0xE1}, {0xBD, 0xE2}, {0xBD, 0xE3}, {0xBD, 0xE4}, /* 0x4C-0x4F */
	{0xBD, 0xE5}, {0xBD, 0xE6}, {0xBD, 0xE7}, {0xBD, 0xE8}, /* 0x50-0x53 */
	{0xBD, 0xEA}, {0xBD, 0xEB}, {0xBD, 0xEC}, {0xBD, 0xED}, /* 0x54-0x57 */
	{0xBD, 0xEE}, {0xBD, 0xEF}, {0xBD, 0xF1}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xBD, 0xF2}, {0xBD, 0xF3}, {0xBD, 0xF5}, /* 0x60-0x63 */
	{0xBD, 0xF6}, {0xBD, 0xF7}, {0xBD, 0xF9}, {0xBD, 0xFA}, /* 0x64-0x67 */
	{0xBD, 0xFB}, {0xBD, 0xFC}, {0xBD, 0xFD}, {0xBD, 0xFE}, /* 0x68-0x6B */
	{0xBD, 0xFF}, {0xBE, 0x01}, {0xBE, 0x02}, {0xBE, 0x04}, /* 0x6C-0x6F */
	{0xBE, 0x06}, {0xBE, 0x07}, {0xBE, 0x08}, {0xBE, 0x09}, /* 0x70-0x73 */
	{0xBE, 0x0A}, {0xBE, 0x0B}, {0xBE, 0x0E}, {0xBE, 0x0F}, /* 0x74-0x77 */
	{0xBE, 0x11}, {0xBE, 0x12}, {0xBE, 0x13}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xBE, 0x15}, {0xBE, 0x16}, {0xBE, 0x17}, /* 0x80-0x83 */
	{0xBE, 0x18}, {0xBE, 0x19}, {0xBE, 0x1A}, {0xBE, 0x1B}, /* 0x84-0x87 */
	{0xBE, 0x1E}, {0xBE, 0x20}, {0xBE, 0x21}, {0xBE, 0x22}, /* 0x88-0x8B */
	{0xBE, 0x23}, {0xBE, 0x24}, {0xBE, 0x25}, {0xBE, 0x26}, /* 0x8C-0x8F */
	{0xBE, 0x27}, {0xBE, 0x28}, {0xBE, 0x29}, {0xBE, 0x2A}, /* 0x90-0x93 */
	{0xBE, 0x2B}, {0xBE, 0x2C}, {0xBE, 0x2D}, {0xBE, 0x2E}, /* 0x94-0x97 */
	{0xBE, 0x2F}, {0xBE, 0x30}, {0xBE, 0x31}, {0xBE, 0x32}, /* 0x98-0x9B */
	{0xBE, 0x33}, {0xBE, 0x34}, {0xBE, 0x35}, {0xBE, 0x36}, /* 0x9C-0x9F */
	{0xBE, 0x37}, {0xBE, 0x38}, {0xBE, 0x39}, {0xBE, 0x3A}, /* 0xA0-0xA3 */
	{0xBE, 0x3B}, {0xBE, 0x3C}, {0xBE, 0x3D}, {0xBE, 0x3E}, /* 0xA4-0xA7 */
	{0xBE, 0x3F}, {0xBE, 0x40}, {0xBE, 0x41}, {0xBE, 0x42}, /* 0xA8-0xAB */
	{0xBE, 0x43}, {0xBE, 0x46}, {0xBE, 0x47}, {0xBE, 0x49}, /* 0xAC-0xAF */
	{0xBE, 0x4A}, {0xBE, 0x4B}, {0xBE, 0x4D}, {0xBE, 0x4F}, /* 0xB0-0xB3 */
	{0xBE, 0x50}, {0xBE, 0x51}, {0xBE, 0x52}, {0xBE, 0x53}, /* 0xB4-0xB7 */
	{0xBE, 0x56}, {0xBE, 0x58}, {0xBE, 0x5C}, {0xBE, 0x5D}, /* 0xB8-0xBB */
	{0xBE, 0x5E}, {0xBE, 0x5F}, {0xBE, 0x62}, {0xBE, 0x63}, /* 0xBC-0xBF */
	{0xBE, 0x65}, {0xBE, 0x66}, {0xBE, 0x67}, {0xBE, 0x69}, /* 0xC0-0xC3 */
	{0xBE, 0x6B}, {0xBE, 0x6C}, {0xBE, 0x6D}, {0xBE, 0x6E}, /* 0xC4-0xC7 */
	{0xBE, 0x6F}, {0xBE, 0x72}, {0xBE, 0x76}, {0xBE, 0x77}, /* 0xC8-0xCB */
	{0xBE, 0x78}, {0xBE, 0x79}, {0xBE, 0x7A}, {0xBE, 0x7E}, /* 0xCC-0xCF */
	{0xBE, 0x7F}, {0xBE, 0x81}, {0xBE, 0x82}, {0xBE, 0x83}, /* 0xD0-0xD3 */
	{0xBE, 0x85}, {0xBE, 0x86}, {0xBE, 0x87}, {0xBE, 0x88}, /* 0xD4-0xD7 */
	{0xBE, 0x89}, {0xBE, 0x8A}, {0xBE, 0x8B}, {0xBE, 0x8E}, /* 0xD8-0xDB */
	{0xBE, 0x92}, {0xBE, 0x93}, {0xBE, 0x94}, {0xBE, 0x95}, /* 0xDC-0xDF */
	{0xBE, 0x96}, {0xBE, 0x97}, {0xBE, 0x9A}, {0xBE, 0x9B}, /* 0xE0-0xE3 */
	{0xBE, 0x9C}, {0xBE, 0x9D}, {0xBE, 0x9E}, {0xBE, 0x9F}, /* 0xE4-0xE7 */
	{0xBE, 0xA0}, {0xBE, 0xA1}, {0xBE, 0xA2}, {0xBE, 0xA3}, /* 0xE8-0xEB */
	{0xBE, 0xA4}, {0xBE, 0xA5}, {0xBE, 0xA6}, {0xBE, 0xA7}, /* 0xEC-0xEF */
	{0xBE, 0xA9}, {0xBE, 0xAA}, {0xBE, 0xAB}, {0xBE, 0xAC}, /* 0xF0-0xF3 */
	{0xBE, 0xAD}, {0xBE, 0xAE}, {0xBE, 0xAF}, {0xBE, 0xB0}, /* 0xF4-0xF7 */
	{0xBE, 0xB1}, {0xBE, 0xB2}, {0xBE, 0xB3}, {0xBE, 0xB4}, /* 0xF8-0xFB */
	{0xBE, 0xB5}, {0xBE, 0xB6}, {0xBE, 0xB7}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_96[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xBE, 0xB8}, {0xBE, 0xB9}, {0xBE, 0xBA}, /* 0x40-0x43 */
	{0xBE, 0xBB}, {0xBE, 0xBC}, {0xBE, 0xBD}, {0xBE, 0xBE}, /* 0x44-0x47 */
	{0xBE, 0xBF}, {0xBE, 0xC0}, {0xBE, 0xC1}, {0xBE, 0xC2}, /* 0x48-0x4B */
	{0xBE, 0xC3}, {0xBE, 0xC4}, {0xBE, 0xC5}, {0xBE, 0xC6}, /* 0x4C-0x4F */
	{0xBE, 0xC7}, {0xBE, 0xC8}, {0xBE, 0xC9}, {0xBE, 0xCA}, /* 0x50-0x53 */
	{0xBE, 0xCB}, {0xBE, 0xCC}, {0xBE, 0xCD}, {0xBE, 0xCE}, /* 0x54-0x57 */
	{0xBE, 0xCF}, {0xBE, 0xD2}, {0xBE, 0xD3}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xBE, 0xD5}, {0xBE, 0xD6}, {0xBE, 0xD9}, /* 0x60-0x63 */
	{0xBE, 0xDA}, {0xBE, 0xDB}, {0xBE, 0xDC}, {0xBE, 0xDD}, /* 0x64-0x67 */
	{0xBE, 0xDE}, {0xBE, 0xDF}, {0xBE, 0xE1}, {0xBE, 0xE2}, /* 0x68-0x6B */
	{0xBE, 0xE6}, {0xBE, 0xE7}, {0xBE, 0xE8}, {0xBE, 0xE9}, /* 0x6C-0x6F */
	{0xBE, 0xEA}, {0xBE, 0xEB}, {0xBE, 0xED}, {0xBE, 0xEE}, /* 0x70-0x73 */
	{0xBE, 0xEF}, {0xBE, 0xF0}, {0xBE, 0xF1}, {0xBE, 0xF2}, /* 0x74-0x77 */
	{0xBE, 0xF3}, {0xBE, 0xF4}, {0xBE, 0xF5}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xBE, 0xF6}, {0xBE, 0xF7}, {0xBE, 0xF8}, /* 0x80-0x83 */
	{0xBE, 0xF9}, {0xBE, 0xFA}, {0xBE, 0xFB}, {0xBE, 0xFC}, /* 0x84-0x87 */
	{0xBE, 0xFD}, {0xBE, 0xFE}, {0xBE, 0xFF}, {0xBF, 0x00}, /* 0x88-0x8B */
	{0xBF, 0x02}, {0xBF, 0x03}, {0xBF, 0x04}, {0xBF, 0x05}, /* 0x8C-0x8F */
	{0xBF, 0x06}, {0xBF, 0x07}, {0xBF, 0x0A}, {0xBF, 0x0B}, /* 0x90-0x93 */
	{0xBF, 0x0C}, {0xBF, 0x0D}, {0xBF, 0x0E}, {0xBF, 0x0F}, /* 0x94-0x97 */
	{0xBF, 0x10}, {0xBF, 0x11}, {0xBF, 0x12}, {0xBF, 0x13}, /* 0x98-0x9B */
	{0xBF, 0x14}, {0xBF, 0x15}, {0xBF, 0x16}, {0xBF, 0x17}, /* 0x9C-0x9F */
	{0xBF, 0x1A}, {0xBF, 0x1E}, {0xBF, 0x1F}, {0xBF, 0x20}, /* 0xA0-0xA3 */
	{0xBF, 0x21}, {0xBF, 0x22}, {0xBF, 0x23}, {0xBF, 0x24}, /* 0xA4-0xA7 */
	{0xBF, 0x25}, {0xBF, 0x26}, {0xBF, 0x27}, {0xBF, 0x28}, /* 0xA8-0xAB */
	{0xBF, 0x29}, {0xBF, 0x2A}, {0xBF, 0x2B}, {0xBF, 0x2C}, /* 0xAC-0xAF */
	{0xBF, 0x2D}, {0xBF, 0x2E}, {0xBF, 0x2F}, {0xBF, 0x30}, /* 0xB0-0xB3 */
	{0xBF, 0x31}, {0xBF, 0x32}, {0xBF, 0x33}, {0xBF, 0x34}, /* 0xB4-0xB7 */
	{0xBF, 0x35}, {0xBF, 0x36}, {0xBF, 0x37}, {0xBF, 0x38}, /* 0xB8-0xBB */
	{0xBF, 0x39}, {0xBF, 0x3A}, {0xBF, 0x3B}, {0xBF, 0x3C}, /* 0xBC-0xBF */
	{0xBF, 0x3D}, {0xBF, 0x3E}, {0xBF, 0x3F}, {0xBF, 0x42}, /* 0xC0-0xC3 */
	{0xBF, 0x43}, {0xBF, 0x45}, {0xBF, 0x46}, {0xBF, 0x47}, /* 0xC4-0xC7 */
	{0xBF, 0x49}, {0xBF, 0x4A}, {0xBF, 0x4B}, {0xBF, 0x4C}, /* 0xC8-0xCB */
	{0xBF, 0x4D}, {0xBF, 0x4E}, {0xBF, 0x4F}, {0xBF, 0x52}, /* 0xCC-0xCF */
	{0xBF, 0x53}, {0xBF, 0x54}, {0xBF, 0x56}, {0xBF, 0x57}, /* 0xD0-0xD3 */
	{0xBF, 0x58}, {0xBF, 0x59}, {0xBF, 0x5A}, {0xBF, 0x5B}, /* 0xD4-0xD7 */
	{0xBF, 0x5C}, {0xBF, 0x5D}, {0xBF, 0x5E}, {0xBF, 0x5F}, /* 0xD8-0xDB */
	{0xBF, 0x60}, {0xBF, 0x61}, {0xBF, 0x62}, {0xBF, 0x63}, /* 0xDC-0xDF */
	{0xBF, 0x64}, {0xBF, 0x65}, {0xBF, 0x66}, {0xBF, 0x67}, /* 0xE0-0xE3 */
	{0xBF, 0x68}, {0xBF, 0x69}, {0xBF, 0x6A}, {0xBF, 0x6B}, /* 0xE4-0xE7 */
	{0xBF, 0x6C}, {0xBF, 0x6D}, {0xBF, 0x6E}, {0xBF, 0x6F}, /* 0xE8-0xEB */
	{0xBF, 0x70}, {0xBF, 0x71}, {0xBF, 0x72}, {0xBF, 0x73}, /* 0xEC-0xEF */
	{0xBF, 0x74}, {0xBF, 0x75}, {0xBF, 0x76}, {0xBF, 0x77}, /* 0xF0-0xF3 */
	{0xBF, 0x78}, {0xBF, 0x79}, {0xBF, 0x7A}, {0xBF, 0x7B}, /* 0xF4-0xF7 */
	{0xBF, 0x7C}, {0xBF, 0x7D}, {0xBF, 0x7E}, {0xBF, 0x7F}, /* 0xF8-0xFB */
	{0xBF, 0x80}, {0xBF, 0x81}, {0xBF, 0x82}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_97[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xBF, 0x83}, {0xBF, 0x84}, {0xBF, 0x85}, /* 0x40-0x43 */
	{0xBF, 0x86}, {0xBF, 0x87}, {0xBF, 0x88}, {0xBF, 0x89}, /* 0x44-0x47 */
	{0xBF, 0x8A}, {0xBF, 0x8B}, {0xBF, 0x8C}, {0xBF, 0x8D}, /* 0x48-0x4B */
	{0xBF, 0x8E}, {0xBF, 0x8F}, {0xBF, 0x90}, {0xBF, 0x91}, /* 0x4C-0x4F */
	{0xBF, 0x92}, {0xBF, 0x93}, {0xBF, 0x95}, {0xBF, 0x96}, /* 0x50-0x53 */
	{0xBF, 0x97}, {0xBF, 0x98}, {0xBF, 0x99}, {0xBF, 0x9A}, /* 0x54-0x57 */
	{0xBF, 0x9B}, {0xBF, 0x9C}, {0xBF, 0x9D}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xBF, 0x9E}, {0xBF, 0x9F}, {0xBF, 0xA0}, /* 0x60-0x63 */
	{0xBF, 0xA1}, {0xBF, 0xA2}, {0xBF, 0xA3}, {0xBF, 0xA4}, /* 0x64-0x67 */
	{0xBF, 0xA5}, {0xBF, 0xA6}, {0xBF, 0xA7}, {0xBF, 0xA8}, /* 0x68-0x6B */
	{0xBF, 0xA9}, {0xBF, 0xAA}, {0xBF, 0xAB}, {0xBF, 0xAC}, /* 0x6C-0x6F */
	{0xBF, 0xAD}, {0xBF, 0xAE}, {0xBF, 0xAF}, {0xBF, 0xB1}, /* 0x70-0x73 */
	{0xBF, 0xB2}, {0xBF, 0xB3}, {0xBF, 0xB4}, {0xBF, 0xB5}, /* 0x74-0x77 */
	{0xBF, 0xB6}, {0xBF, 0xB7}, {0xBF, 0xB8}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xBF, 0xB9}, {0xBF, 0xBA}, {0xBF, 0xBB}, /* 0x80-0x83 */
	{0xBF, 0xBC}, {0xBF, 0xBD}, {0xBF, 0xBE}, {0xBF, 0xBF}, /* 0x84-0x87 */
	{0xBF, 0xC0}, {0xBF, 0xC1}, {0xBF, 0xC2}, {0xBF, 0xC3}, /* 0x88-0x8B */
	{0xBF, 0xC4}, {0xBF, 0xC6}, {0xBF, 0xC7}, {0xBF, 0xC8}, /* 0x8C-0x8F */
	{0xBF, 0xC9}, {0xBF, 0xCA}, {0xBF, 0xCB}, {0xBF, 0xCE}, /* 0x90-0x93 */
	{0xBF, 0xCF}, {0xBF, 0xD1}, {0xBF, 0xD2}, {0xBF, 0xD3}, /* 0x94-0x97 */
	{0xBF, 0xD5}, {0xBF, 0xD6}, {0xBF, 0xD7}, {0xBF, 0xD8}, /* 0x98-0x9B */
	{0xBF, 0xD9}, {0xBF, 0xDA}, {0xBF, 0xDB}, {0xBF, 0xDD}, /* 0x9C-0x9F */
	{0xBF, 0xDE}, {0xBF, 0xE0}, {0xBF, 0xE2}, {0xBF, 0xE3}, /* 0xA0-0xA3 */
	{0xBF, 0xE4}, {0xBF, 0xE5}, {0xBF, 0xE6}, {0xBF, 0xE7}, /* 0xA4-0xA7 */
	{0xBF, 0xE8}, {0xBF, 0xE9}, {0xBF, 0xEA}, {0xBF, 0xEB}, /* 0xA8-0xAB */
	{0xBF, 0xEC}, {0xBF, 0xED}, {0xBF, 0xEE}, {0xBF, 0xEF}, /* 0xAC-0xAF */
	{0xBF, 0xF0}, {0xBF, 0xF1}, {0xBF, 0xF2}, {0xBF, 0xF3}, /* 0xB0-0xB3 */
	{0xBF, 0xF4}, {0xBF, 0xF5}, {0xBF, 0xF6}, {0xBF, 0xF7}, /* 0xB4-0xB7 */
	{0xBF, 0xF8}, {0xBF, 0xF9}, {0xBF, 0xFA}, {0xBF, 0xFB}, /* 0xB8-0xBB */
	{0xBF, 0xFC}, {0xBF, 0xFD}, {0xBF, 0xFE}, {0xBF, 0xFF}, /* 0xBC-0xBF */
	{0xC0, 0x00}, {0xC0, 0x01}, {0xC0, 0x02}, {0xC0, 0x03}, /* 0xC0-0xC3 */
	{0xC0, 0x04}, {0xC0, 0x05}, {0xC0, 0x06}, {0xC0, 0x07}, /* 0xC4-0xC7 */
	{0xC0, 0x08}, {0xC0, 0x09}, {0xC0, 0x0A}, {0xC0, 0x0B}, /* 0xC8-0xCB */
	{0xC0, 0x0C}, {0xC0, 0x0D}, {0xC0, 0x0E}, {0xC0, 0x0F}, /* 0xCC-0xCF */
	{0xC0, 0x10}, {0xC0, 0x11}, {0xC0, 0x12}, {0xC0, 0x13}, /* 0xD0-0xD3 */
	{0xC0, 0x14}, {0xC0, 0x15}, {0xC0, 0x16}, {0xC0, 0x17}, /* 0xD4-0xD7 */
	{0xC0, 0x18}, {0xC0, 0x19}, {0xC0, 0x1A}, {0xC0, 0x1B}, /* 0xD8-0xDB */
	{0xC0, 0x1C}, {0xC0, 0x1D}, {0xC0, 0x1E}, {0xC0, 0x1F}, /* 0xDC-0xDF */
	{0xC0, 0x20}, {0xC0, 0x21}, {0xC0, 0x22}, {0xC0, 0x23}, /* 0xE0-0xE3 */
	{0xC0, 0x24}, {0xC0, 0x25}, {0xC0, 0x26}, {0xC0, 0x27}, /* 0xE4-0xE7 */
	{0xC0, 0x28}, {0xC0, 0x29}, {0xC0, 0x2A}, {0xC0, 0x2B}, /* 0xE8-0xEB */
	{0xC0, 0x2C}, {0xC0, 0x2D}, {0xC0, 0x2E}, {0xC0, 0x2F}, /* 0xEC-0xEF */
	{0xC0, 0x30}, {0xC0, 0x31}, {0xC0, 0x32}, {0xC0, 0x33}, /* 0xF0-0xF3 */
	{0xC0, 0x34}, {0xC0, 0x35}, {0xC0, 0x36}, {0xC0, 0x37}, /* 0xF4-0xF7 */
	{0xC0, 0x38}, {0xC0, 0x39}, {0xC0, 0x3A}, {0xC0, 0x3B}, /* 0xF8-0xFB */
	{0xC0, 0x3D}, {0xC0, 0x3E}, {0xC0, 0x3F}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_98[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xC0, 0x40}, {0xC0, 0x41}, {0xC0, 0x42}, /* 0x40-0x43 */
	{0xC0, 0x43}, {0xC0, 0x44}, {0xC0, 0x45}, {0xC0, 0x46}, /* 0x44-0x47 */
	{0xC0, 0x47}, {0xC0, 0x48}, {0xC0, 0x49}, {0xC0, 0x4A}, /* 0x48-0x4B */
	{0xC0, 0x4B}, {0xC0, 0x4C}, {0xC0, 0x4D}, {0xC0, 0x4E}, /* 0x4C-0x4F */
	{0xC0, 0x4F}, {0xC0, 0x50}, {0xC0, 0x52}, {0xC0, 0x53}, /* 0x50-0x53 */
	{0xC0, 0x54}, {0xC0, 0x55}, {0xC0, 0x56}, {0xC0, 0x57}, /* 0x54-0x57 */
	{0xC0, 0x59}, {0xC0, 0x5A}, {0xC0, 0x5B}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xC0, 0x5D}, {0xC0, 0x5E}, {0xC0, 0x5F}, /* 0x60-0x63 */
	{0xC0, 0x61}, {0xC0, 0x62}, {0xC0, 0x63}, {0xC0, 0x64}, /* 0x64-0x67 */
	{0xC0, 0x65}, {0xC0, 0x66}, {0xC0, 0x67}, {0xC0, 0x6A}, /* 0x68-0x6B */
	{0xC0, 0x6B}, {0xC0, 0x6C}, {0xC0, 0x6D}, {0xC0, 0x6E}, /* 0x6C-0x6F */
	{0xC0, 0x6F}, {0xC0, 0x70}, {0xC0, 0x71}, {0xC0, 0x72}, /* 0x70-0x73 */
	{0xC0, 0x73}, {0xC0, 0x74}, {0xC0, 0x75}, {0xC0, 0x76}, /* 0x74-0x77 */
	{0xC0, 0x77}, {0xC0, 0x78}, {0xC0, 0x79}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xC0, 0x7A}, {0xC0, 0x7B}, {0xC0, 0x7C}, /* 0x80-0x83 */
	{0xC0, 0x7D}, {0xC0, 0x7E}, {0xC0, 0x7F}, {0xC0, 0x80}, /* 0x84-0x87 */
	{0xC0, 0x81}, {0xC0, 0x82}, {0xC0, 0x83}, {0xC0, 0x84}, /* 0x88-0x8B */
	{0xC0, 0x85}, {0xC0, 0x86}, {0xC0, 0x87}, {0xC0, 0x88}, /* 0x8C-0x8F */
	{0xC0, 0x89}, {0xC0, 0x8A}, {0xC0, 0x8B}, {0xC0, 0x8C}, /* 0x90-0x93 */
	{0xC0, 0x8D}, {0xC0, 0x8E}, {0xC0, 0x8F}, {0xC0, 0x92}, /* 0x94-0x97 */
	{0xC0, 0x93}, {0xC0, 0x95}, {0xC0, 0x96}, {0xC0, 0x97}, /* 0x98-0x9B */
	{0xC0, 0x99}, {0xC0, 0x9A}, {0xC0, 0x9B}, {0xC0, 0x9C}, /* 0x9C-0x9F */
	{0xC0, 0x9D}, {0xC0, 0x9E}, {0xC0, 0x9F}, {0xC0, 0xA2}, /* 0xA0-0xA3 */
	{0xC0, 0xA4}, {0xC0, 0xA6}, {0xC0, 0xA7}, {0xC0, 0xA8}, /* 0xA4-0xA7 */
	{0xC0, 0xA9}, {0xC0, 0xAA}, {0xC0, 0xAB}, {0xC0, 0xAE}, /* 0xA8-0xAB */
	{0xC0, 0xB1}, {0xC0, 0xB2}, {0xC0, 0xB7}, {0xC0, 0xB8}, /* 0xAC-0xAF */
	{0xC0, 0xB9}, {0xC0, 0xBA}, {0xC0, 0xBB}, {0xC0, 0xBE}, /* 0xB0-0xB3 */
	{0xC0, 0xC2}, {0xC0, 0xC3}, {0xC0, 0xC4}, {0xC0, 0xC6}, /* 0xB4-0xB7 */
	{0xC0, 0xC7}, {0xC0, 0xCA}, {0xC0, 0xCB}, {0xC0, 0xCD}, /* 0xB8-0xBB */
	{0xC0, 0xCE}, {0xC0, 0xCF}, {0xC0, 0xD1}, {0xC0, 0xD2}, /* 0xBC-0xBF */
	{0xC0, 0xD3}, {0xC0, 0xD4}, {0xC0, 0xD5}, {0xC0, 0xD6}, /* 0xC0-0xC3 */
	{0xC0, 0xD7}, {0xC0, 0xDA}, {0xC0, 0xDE}, {0xC0, 0xDF}, /* 0xC4-0xC7 */
	{0xC0, 0xE0}, {0xC0, 0xE1}, {0xC0, 0xE2}, {0xC0, 0xE3}, /* 0xC8-0xCB */
	{0xC0, 0xE6}, {0xC0, 0xE7}, {0xC0, 0xE9}, {0xC0, 0xEA}, /* 0xCC-0xCF */
	{0xC0, 0xEB}, {0xC0, 0xED}, {0xC0, 0xEE}, {0xC0, 0xEF}, /* 0xD0-0xD3 */
	{0xC0, 0xF0}, {0xC0, 0xF1}, {0xC0, 0xF2}, {0xC0, 0xF3}, /* 0xD4-0xD7 */
	{0xC0, 0xF6}, {0xC0, 0xF8}, {0xC0, 0xFA}, {0xC0, 0xFB}, /* 0xD8-0xDB */
	{0xC0, 0xFC}, {0xC0, 0xFD}, {0xC0, 0xFE}, {0xC0, 0xFF}, /* 0xDC-0xDF */
	{0xC1, 0x01}, {0xC1, 0x02}, {0xC1, 0x03}, {0xC1, 0x05}, /* 0xE0-0xE3 */
	{0xC1, 0x06}, {0xC1, 0x07}, {0xC1, 0x09}, {0xC1, 0x0A}, /* 0xE4-0xE7 */
	{0xC1, 0x0B}, {0xC1, 0x0C}, {0xC1, 0x0D}, {0xC1, 0x0E}, /* 0xE8-0xEB */
	{0xC1, 0x0F}, {0xC1, 0x11}, {0xC1, 0x12}, {0xC1, 0x13}, /* 0xEC-0xEF */
	{0xC1, 0x14}, {0xC1, 0x16}, {0xC1, 0x17}, {0xC1, 0x18}, /* 0xF0-0xF3 */
	{0xC1, 0x19}, {0xC1, 0x1A}, {0xC1, 0x1B}, {0xC1, 0x21}, /* 0xF4-0xF7 */
	{0xC1, 0x22}, {0xC1, 0x25}, {0xC1, 0x28}, {0xC1, 0x29}, /* 0xF8-0xFB */
	{0xC1, 0x2A}, {0xC1, 0x2B}, {0xC1, 0x2E}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_99[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xC1, 0x32}, {0xC1, 0x33}, {0xC1, 0x34}, /* 0x40-0x43 */
	{0xC1, 0x35}, {0xC1, 0x37}, {0xC1, 0x3A}, {0xC1, 0x3B}, /* 0x44-0x47 */
	{0xC1, 0x3D}, {0xC1, 0x3E}, {0xC1, 0x3F}, {0xC1, 0x41}, /* 0x48-0x4B */
	{0xC1, 0x42}, {0xC1, 0x43}, {0xC1, 0x44}, {0xC1, 0x45}, /* 0x4C-0x4F */
	{0xC1, 0x46}, {0xC1, 0x47}, {0xC1, 0x4A}, {0xC1, 0x4E}, /* 0x50-0x53 */
	{0xC1, 0x4F}, {0xC1, 0x50}, {0xC1, 0x51}, {0xC1, 0x52}, /* 0x54-0x57 */
	{0xC1, 0x53}, {0xC1, 0x56}, {0xC1, 0x57}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xC1, 0x59}, {0xC1, 0x5A}, {0xC1, 0x5B}, /* 0x60-0x63 */
	{0xC1, 0x5D}, {0xC1, 0x5E}, {0xC1, 0x5F}, {0xC1, 0x60}, /* 0x64-0x67 */
	{0xC1, 0x61}, {0xC1, 0x62}, {0xC1, 0x63}, {0xC1, 0x66}, /* 0x68-0x6B */
	{0xC1, 0x6A}, {0xC1, 0x6B}, {0xC1, 0x6C}, {0xC1, 0x6D}, /* 0x6C-0x6F */
	{0xC1, 0x6E}, {0xC1, 0x6F}, {0xC1, 0x71}, {0xC1, 0x72}, /* 0x70-0x73 */
	{0xC1, 0x73}, {0xC1, 0x75}, {0xC1, 0x76}, {0xC1, 0x77}, /* 0x74-0x77 */
	{0xC1, 0x79}, {0xC1, 0x7A}, {0xC1, 0x7B}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xC1, 0x7C}, {0xC1, 0x7D}, {0xC1, 0x7E}, /* 0x80-0x83 */
	{0xC1, 0x7F}, {0xC1, 0x80}, {0xC1, 0x81}, {0xC1, 0x82}, /* 0x84-0x87 */
	{0xC1, 0x83}, {0xC1, 0x84}, {0xC1, 0x86}, {0xC1, 0x87}, /* 0x88-0x8B */
	{0xC1, 0x88}, {0xC1, 0x89}, {0xC1, 0x8A}, {0xC1, 0x8B}, /* 0x8C-0x8F */
	{0xC1, 0x8F}, {0xC1, 0x91}, {0xC1, 0x92}, {0xC1, 0x93}, /* 0x90-0x93 */
	{0xC1, 0x95}, {0xC1, 0x97}, {0xC1, 0x98}, {0xC1, 0x99}, /* 0x94-0x97 */
	{0xC1, 0x9A}, {0xC1, 0x9B}, {0xC1, 0x9E}, {0xC1, 0xA0}, /* 0x98-0x9B */
	{0xC1, 0xA2}, {0xC1, 0xA3}, {0xC1, 0xA4}, {0xC1, 0xA6}, /* 0x9C-0x9F */
	{0xC1, 0xA7}, {0xC1, 0xAA}, {0xC1, 0xAB}, {0xC1, 0xAD}, /* 0xA0-0xA3 */
	{0xC1, 0xAE}, {0xC1, 0xAF}, {0xC1, 0xB1}, {0xC1, 0xB2}, /* 0xA4-0xA7 */
	{0xC1, 0xB3}, {0xC1, 0xB4}, {0xC1, 0xB5}, {0xC1, 0xB6}, /* 0xA8-0xAB */
	{0xC1, 0xB7}, {0xC1, 0xB8}, {0xC1, 0xB9}, {0xC1, 0xBA}, /* 0xAC-0xAF */
	{0xC1, 0xBB}, {0xC1, 0xBC}, {0xC1, 0xBE}, {0xC1, 0xBF}, /* 0xB0-0xB3 */
	{0xC1, 0xC0}, {0xC1, 0xC1}, {0xC1, 0xC2}, {0xC1, 0xC3}, /* 0xB4-0xB7 */
	{0xC1, 0xC5}, {0xC1, 0xC6}, {0xC1, 0xC7}, {0xC1, 0xC9}, /* 0xB8-0xBB */
	{0xC1, 0xCA}, {0xC1, 0xCB}, {0xC1, 0xCD}, {0xC1, 0xCE}, /* 0xBC-0xBF */
	{0xC1, 0xCF}, {0xC1, 0xD0}, {0xC1, 0xD1}, {0xC1, 0xD2}, /* 0xC0-0xC3 */
	{0xC1, 0xD3}, {0xC1, 0xD5}, {0xC1, 0xD6}, {0xC1, 0xD9}, /* 0xC4-0xC7 */
	{0xC1, 0xDA}, {0xC1, 0xDB}, {0xC1, 0xDC}, {0xC1, 0xDD}, /* 0xC8-0xCB */
	{0xC1, 0xDE}, {0xC1, 0xDF}, {0xC1, 0xE1}, {0xC1, 0xE2}, /* 0xCC-0xCF */
	{0xC1, 0xE3}, {0xC1, 0xE5}, {0xC1, 0xE6}, {0xC1, 0xE7}, /* 0xD0-0xD3 */
	{0xC1, 0xE9}, {0xC1, 0xEA}, {0xC1, 0xEB}, {0xC1, 0xEC}, /* 0xD4-0xD7 */
	{0xC1, 0xED}, {0xC1, 0xEE}, {0xC1, 0xEF}, {0xC1, 0xF2}, /* 0xD8-0xDB */
	{0xC1, 0xF4}, {0xC1, 0xF5}, {0xC1, 0xF6}, {0xC1, 0xF7}, /* 0xDC-0xDF */
	{0xC1, 0xF8}, {0xC1, 0xF9}, {0xC1, 0xFA}, {0xC1, 0xFB}, /* 0xE0-0xE3 */
	{0xC1, 0xFE}, {0xC1, 0xFF}, {0xC2, 0x01}, {0xC2, 0x02}, /* 0xE4-0xE7 */
	{0xC2, 0x03}, {0xC2, 0x05}, {0xC2, 0x06}, {0xC2, 0x07}, /* 0xE8-0xEB */
	{0xC2, 0x08}, {0xC2, 0x09}, {0xC2, 0x0A}, {0xC2, 0x0B}, /* 0xEC-0xEF */
	{0xC2, 0x0E}, {0xC2, 0x10}, {0xC2, 0x12}, {0xC2, 0x13}, /* 0xF0-0xF3 */
	{0xC2, 0x14}, {0xC2, 0x15}, {0xC2, 0x16}, {0xC2, 0x17}, /* 0xF4-0xF7 */
	{0xC2, 0x1A}, {0xC2, 0x1B}, {0xC2, 0x1D}, {0xC2, 0x1E}, /* 0xF8-0xFB */
	{0xC2, 0x21}, {0xC2, 0x22}, {0xC2, 0x23}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_9A[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xC2, 0x24}, {0xC2, 0x25}, {0xC2, 0x26}, /* 0x40-0x43 */
	{0xC2, 0x27}, {0xC2, 0x2A}, {0xC2, 0x2C}, {0xC2, 0x2E}, /* 0x44-0x47 */
	{0xC2, 0x30}, {0xC2, 0x33}, {0xC2, 0x35}, {0xC2, 0x36}, /* 0x48-0x4B */
	{0xC2, 0x37}, {0xC2, 0x38}, {0xC2, 0x39}, {0xC2, 0x3A}, /* 0x4C-0x4F */
	{0xC2, 0x3B}, {0xC2, 0x3C}, {0xC2, 0x3D}, {0xC2, 0x3E}, /* 0x50-0x53 */
	{0xC2, 0x3F}, {0xC2, 0x40}, {0xC2, 0x41}, {0xC2, 0x42}, /* 0x54-0x57 */
	{0xC2, 0x43}, {0xC2, 0x44}, {0xC2, 0x45}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xC2, 0x46}, {0xC2, 0x47}, {0xC2, 0x49}, /* 0x60-0x63 */
	{0xC2, 0x4A}, {0xC2, 0x4B}, {0xC2, 0x4C}, {0xC2, 0x4D}, /* 0x64-0x67 */
	{0xC2, 0x4E}, {0xC2, 0x4F}, {0xC2, 0x52}, {0xC2, 0x53}, /* 0x68-0x6B */
	{0xC2, 0x55}, {0xC2, 0x56}, {0xC2, 0x57}, {0xC2, 0x59}, /* 0x6C-0x6F */
	{0xC2, 0x5A}, {0xC2, 0x5B}, {0xC2, 0x5C}, {0xC2, 0x5D}, /* 0x70-0x73 */
	{0xC2, 0x5E}, {0xC2, 0x5F}, {0xC2, 0x61}, {0xC2, 0x62}, /* 0x74-0x77 */
	{0xC2, 0x63}, {0xC2, 0x64}, {0xC2, 0x66}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xC2, 0x67}, {0xC2, 0x68}, {0xC2, 0x69}, /* 0x80-0x83 */
	{0xC2, 0x6A}, {0xC2, 0x6B}, {0xC2, 0x6E}, {0xC2, 0x6F}, /* 0x84-0x87 */
	{0xC2, 0x71}, {0xC2, 0x72}, {0xC2, 0x73}, {0xC2, 0x75}, /* 0x88-0x8B */
	{0xC2, 0x76}, {0xC2, 0x77}, {0xC2, 0x78}, {0xC2, 0x79}, /* 0x8C-0x8F */
	{0xC2, 0x7A}, {0xC2, 0x7B}, {0xC2, 0x7E}, {0xC2, 0x80}, /* 0x90-0x93 */
	{0xC2, 0x82}, {0xC2, 0x83}, {0xC2, 0x84}, {0xC2, 0x85}, /* 0x94-0x97 */
	{0xC2, 0x86}, {0xC2, 0x87}, {0xC2, 0x8A}, {0xC2, 0x8B}, /* 0x98-0x9B */
	{0xC2, 0x8C}, {0xC2, 0x8D}, {0xC2, 0x8E}, {0xC2, 0x8F}, /* 0x9C-0x9F */
	{0xC2, 0x91}, {0xC2, 0x92}, {0xC2, 0x93}, {0xC2, 0x94}, /* 0xA0-0xA3 */
	{0xC2, 0x95}, {0xC2, 0x96}, {0xC2, 0x97}, {0xC2, 0x99}, /* 0xA4-0xA7 */
	{0xC2, 0x9A}, {0xC2, 0x9C}, {0xC2, 0x9E}, {0xC2, 0x9F}, /* 0xA8-0xAB */
	{0xC2, 0xA0}, {0xC2, 0xA1}, {0xC2, 0xA2}, {0xC2, 0xA3}, /* 0xAC-0xAF */
	{0xC2, 0xA6}, {0xC2, 0xA7}, {0xC2, 0xA9}, {0xC2, 0xAA}, /* 0xB0-0xB3 */
	{0xC2, 0xAB}, {0xC2, 0xAE}, {0xC2, 0xAF}, {0xC2, 0xB0}, /* 0xB4-0xB7 */
	{0xC2, 0xB1}, {0xC2, 0xB2}, {0xC2, 0xB3}, {0xC2, 0xB6}, /* 0xB8-0xBB */
	{0xC2, 0xB8}, {0xC2, 0xBA}, {0xC2, 0xBB}, {0xC2, 0xBC}, /* 0xBC-0xBF */
	{0xC2, 0xBD}, {0xC2, 0xBE}, {0xC2, 0xBF}, {0xC2, 0xC0}, /* 0xC0-0xC3 */
	{0xC2, 0xC1}, {0xC2, 0xC2}, {0xC2, 0xC3}, {0xC2, 0xC4}, /* 0xC4-0xC7 */
	{0xC2, 0xC5}, {0xC2, 0xC6}, {0xC2, 0xC7}, {0xC2, 0xC8}, /* 0xC8-0xCB */
	{0xC2, 0xC9}, {0xC2, 0xCA}, {0xC2, 0xCB}, {0xC2, 0xCC}, /* 0xCC-0xCF */
	{0xC2, 0xCD}, {0xC2, 0xCE}, {0xC2, 0xCF}, {0xC2, 0xD0}, /* 0xD0-0xD3 */
	{0xC2, 0xD1}, {0xC2, 0xD2}, {0xC2, 0xD3}, {0xC2, 0xD4}, /* 0xD4-0xD7 */
	{0xC2, 0xD5}, {0xC2, 0xD6}, {0xC2, 0xD7}, {0xC2, 0xD8}, /* 0xD8-0xDB */
	{0xC2, 0xD9}, {0xC2, 0xDA}, {0xC2, 0xDB}, {0xC2, 0xDE}, /* 0xDC-0xDF */
	{0xC2, 0xDF}, {0xC2, 0xE1}, {0xC2, 0xE2}, {0xC2, 0xE5}, /* 0xE0-0xE3 */
	{0xC2, 0xE6}, {0xC2, 0xE7}, {0xC2, 0xE8}, {0xC2, 0xE9}, /* 0xE4-0xE7 */
	{0xC2, 0xEA}, {0xC2, 0xEE}, {0xC2, 0xF0}, {0xC2, 0xF2}, /* 0xE8-0xEB */
	{0xC2, 0xF3}, {0xC2, 0xF4}, {0xC2, 0xF5}, {0xC2, 0xF7}, /* 0xEC-0xEF */
	{0xC2, 0xFA}, {0xC2, 0xFD}, {0xC2, 0xFE}, {0xC2, 0xFF}, /* 0xF0-0xF3 */
	{0xC3, 0x01}, {0xC3, 0x02}, {0xC3, 0x03}, {0xC3, 0x04}, /* 0xF4-0xF7 */
	{0xC3, 0x05}, {0xC3, 0x06}, {0xC3, 0x07}, {0xC3, 0x0A}, /* 0xF8-0xFB */
	{0xC3, 0x0B}, {0xC3, 0x0E}, {0xC3, 0x0F}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_9B[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xC3, 0x10}, {0xC3, 0x11}, {0xC3, 0x12}, /* 0x40-0x43 */
	{0xC3, 0x16}, {0xC3, 0x17}, {0xC3, 0x19}, {0xC3, 0x1A}, /* 0x44-0x47 */
	{0xC3, 0x1B}, {0xC3, 0x1D}, {0xC3, 0x1E}, {0xC3, 0x1F}, /* 0x48-0x4B */
	{0xC3, 0x20}, {0xC3, 0x21}, {0xC3, 0x22}, {0xC3, 0x23}, /* 0x4C-0x4F */
	{0xC3, 0x26}, {0xC3, 0x27}, {0xC3, 0x2A}, {0xC3, 0x2B}, /* 0x50-0x53 */
	{0xC3, 0x2C}, {0xC3, 0x2D}, {0xC3, 0x2E}, {0xC3, 0x2F}, /* 0x54-0x57 */
	{0xC3, 0x30}, {0xC3, 0x31}, {0xC3, 0x32}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xC3, 0x33}, {0xC3, 0x34}, {0xC3, 0x35}, /* 0x60-0x63 */
	{0xC3, 0x36}, {0xC3, 0x37}, {0xC3, 0x38}, {0xC3, 0x39}, /* 0x64-0x67 */
	{0xC3, 0x3A}, {0xC3, 0x3B}, {0xC3, 0x3C}, {0xC3, 0x3D}, /* 0x68-0x6B */
	{0xC3, 0x3E}, {0xC3, 0x3F}, {0xC3, 0x40}, {0xC3, 0x41}, /* 0x6C-0x6F */
	{0xC3, 0x42}, {0xC3, 0x43}, {0xC3, 0x44}, {0xC3, 0x46}, /* 0x70-0x73 */
	{0xC3, 0x47}, {0xC3, 0x48}, {0xC3, 0x49}, {0xC3, 0x4A}, /* 0x74-0x77 */
	{0xC3, 0x4B}, {0xC3, 0x4C}, {0xC3, 0x4D}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xC3, 0x4E}, {0xC3, 0x4F}, {0xC3, 0x50}, /* 0x80-0x83 */
	{0xC3, 0x51}, {0xC3, 0x52}, {0xC3, 0x53}, {0xC3, 0x54}, /* 0x84-0x87 */
	{0xC3, 0x55}, {0xC3, 0x56}, {0xC3, 0x57}, {0xC3, 0x58}, /* 0x88-0x8B */
	{0xC3, 0x59}, {0xC3, 0x5A}, {0xC3, 0x5B}, {0xC3, 0x5C}, /* 0x8C-0x8F */
	{0xC3, 0x5D}, {0xC3, 0x5E}, {0xC3, 0x5F}, {0xC3, 0x60}, /* 0x90-0x93 */
	{0xC3, 0x61}, {0xC3, 0x62}, {0xC3, 0x63}, {0xC3, 0x64}, /* 0x94-0x97 */
	{0xC3, 0x65}, {0xC3, 0x66}, {0xC3, 0x67}, {0xC3, 0x6A}, /* 0x98-0x9B */
	{0xC3, 0x6B}, {0xC3, 0x6D}, {0xC3, 0x6E}, {0xC3, 0x6F}, /* 0x9C-0x9F */
	{0xC3, 0x71}, {0xC3, 0x73}, {0xC3, 0x74}, {0xC3, 0x75}, /* 0xA0-0xA3 */
	{0xC3, 0x76}, {0xC3, 0x77}, {0xC3, 0x7A}, {0xC3, 0x7B}, /* 0xA4-0xA7 */
	{0xC3, 0x7E}, {0xC3, 0x7F}, {0xC3, 0x80}, {0xC3, 0x81}, /* 0xA8-0xAB */
	{0xC3, 0x82}, {0xC3, 0x83}, {0xC3, 0x85}, {0xC3, 0x86}, /* 0xAC-0xAF */
	{0xC3, 0x87}, {0xC3, 0x89}, {0xC3, 0x8A}, {0xC3, 0x8B}, /* 0xB0-0xB3 */
	{0xC3, 0x8D}, {0xC3, 0x8E}, {0xC3, 0x8F}, {0xC3, 0x90}, /* 0xB4-0xB7 */
	{0xC3, 0x91}, {0xC3, 0x92}, {0xC3, 0x93}, {0xC3, 0x94}, /* 0xB8-0xBB */
	{0xC3, 0x95}, {0xC3, 0x96}, {0xC3, 0x97}, {0xC3, 0x98}, /* 0xBC-0xBF */
	{0xC3, 0x99}, {0xC3, 0x9A}, {0xC3, 0x9B}, {0xC3, 0x9C}, /* 0xC0-0xC3 */
	{0xC3, 0x9D}, {0xC3, 0x9E}, {0xC3, 0x9F}, {0xC3, 0xA0}, /* 0xC4-0xC7 */
	{0xC3, 0xA1}, {0xC3, 0xA2}, {0xC3, 0xA3}, {0xC3, 0xA4}, /* 0xC8-0xCB */
	{0xC3, 0xA5}, {0xC3, 0xA6}, {0xC3, 0xA7}, {0xC3, 0xA8}, /* 0xCC-0xCF */
	{0xC3, 0xA9}, {0xC3, 0xAA}, {0xC3, 0xAB}, {0xC3, 0xAC}, /* 0xD0-0xD3 */
	{0xC3, 0xAD}, {0xC3, 0xAE}, {0xC3, 0xAF}, {0xC3, 0xB0}, /* 0xD4-0xD7 */
	{0xC3, 0xB1}, {0xC3, 0xB2}, {0xC3, 0xB3}, {0xC3, 0xB4}, /* 0xD8-0xDB */
	{0xC3, 0xB5}, {0xC3, 0xB6}, {0xC3, 0xB7}, {0xC3, 0xB8}, /* 0xDC-0xDF */
	{0xC3, 0xB9}, {0xC3, 0xBA}, {0xC3, 0xBB}, {0xC3, 0xBC}, /* 0xE0-0xE3 */
	{0xC3, 0xBD}, {0xC3, 0xBE}, {0xC3, 0xBF}, {0xC3, 0xC1}, /* 0xE4-0xE7 */
	{0xC3, 0xC2}, {0xC3, 0xC3}, {0xC3, 0xC4}, {0xC3, 0xC5}, /* 0xE8-0xEB */
	{0xC3, 0xC6}, {0xC3, 0xC7}, {0xC3, 0xC8}, {0xC3, 0xC9}, /* 0xEC-0xEF */
	{0xC3, 0xCA}, {0xC3, 0xCB}, {0xC3, 0xCC}, {0xC3, 0xCD}, /* 0xF0-0xF3 */
	{0xC3, 0xCE}, {0xC3, 0xCF}, {0xC3, 0xD0}, {0xC3, 0xD1}, /* 0xF4-0xF7 */
	{0xC3, 0xD2}, {0xC3, 0xD3}, {0xC3, 0xD4}, {0xC3, 0xD5}, /* 0xF8-0xFB */
	{0xC3, 0xD6}, {0xC3, 0xD7}, {0xC3, 0xDA}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_9C[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xC3, 0xDB}, {0xC3, 0xDD}, {0xC3, 0xDE}, /* 0x40-0x43 */
	{0xC3, 0xE1}, {0xC3, 0xE3}, {0xC3, 0xE4}, {0xC3, 0xE5}, /* 0x44-0x47 */
	{0xC3, 0xE6}, {0xC3, 0xE7}, {0xC3, 0xEA}, {0xC3, 0xEB}, /* 0x48-0x4B */
	{0xC3, 0xEC}, {0xC3, 0xEE}, {0xC3, 0xEF}, {0xC3, 0xF0}, /* 0x4C-0x4F */
	{0xC3, 0xF1}, {0xC3, 0xF2}, {0xC3, 0xF3}, {0xC3, 0xF6}, /* 0x50-0x53 */
	{0xC3, 0xF7}, {0xC3, 0xF9}, {0xC3, 0xFA}, {0xC3, 0xFB}, /* 0x54-0x57 */
	{0xC3, 0xFC}, {0xC3, 0xFD}, {0xC3, 0xFE}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xC3, 0xFF}, {0xC4, 0x00}, {0xC4, 0x01}, /* 0x60-0x63 */
	{0xC4, 0x02}, {0xC4, 0x03}, {0xC4, 0x04}, {0xC4, 0x05}, /* 0x64-0x67 */
	{0xC4, 0x06}, {0xC4, 0x07}, {0xC4, 0x09}, {0xC4, 0x0A}, /* 0x68-0x6B */
	{0xC4, 0x0B}, {0xC4, 0x0C}, {0xC4, 0x0D}, {0xC4, 0x0E}, /* 0x6C-0x6F */
	{0xC4, 0x0F}, {0xC4, 0x11}, {0xC4, 0x12}, {0xC4, 0x13}, /* 0x70-0x73 */
	{0xC4, 0x14}, {0xC4, 0x15}, {0xC4, 0x16}, {0xC4, 0x17}, /* 0x74-0x77 */
	{0xC4, 0x18}, {0xC4, 0x19}, {0xC4, 0x1A}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xC4, 0x1B}, {0xC4, 0x1C}, {0xC4, 0x1D}, /* 0x80-0x83 */
	{0xC4, 0x1E}, {0xC4, 0x1F}, {0xC4, 0x20}, {0xC4, 0x21}, /* 0x84-0x87 */
	{0xC4, 0x22}, {0xC4, 0x23}, {0xC4, 0x25}, {0xC4, 0x26}, /* 0x88-0x8B */
	{0xC4, 0x27}, {0xC4, 0x28}, {0xC4, 0x29}, {0xC4, 0x2A}, /* 0x8C-0x8F */
	{0xC4, 0x2B}, {0xC4, 0x2D}, {0xC4, 0x2E}, {0xC4, 0x2F}, /* 0x90-0x93 */
	{0xC4, 0x31}, {0xC4, 0x32}, {0xC4, 0x33}, {0xC4, 0x35}, /* 0x94-0x97 */
	{0xC4, 0x36}, {0xC4, 0x37}, {0xC4, 0x38}, {0xC4, 0x39}, /* 0x98-0x9B */
	{0xC4, 0x3A}, {0xC4, 0x3B}, {0xC4, 0x3E}, {0xC4, 0x3F}, /* 0x9C-0x9F */
	{0xC4, 0x40}, {0xC4, 0x41}, {0xC4, 0x42}, {0xC4, 0x43}, /* 0xA0-0xA3 */
	{0xC4, 0x44}, {0xC4, 0x45}, {0xC4, 0x46}, {0xC4, 0x47}, /* 0xA4-0xA7 */
	{0xC4, 0x49}, {0xC4, 0x4A}, {0xC4, 0x4B}, {0xC4, 0x4C}, /* 0xA8-0xAB */
	{0xC4, 0x4D}, {0xC4, 0x4E}, {0xC4, 0x4F}, {0xC4, 0x50}, /* 0xAC-0xAF */
	{0xC4, 0x51}, {0xC4, 0x52}, {0xC4, 0x53}, {0xC4, 0x54}, /* 0xB0-0xB3 */
	{0xC4, 0x55}, {0xC4, 0x56}, {0xC4, 0x57}, {0xC4, 0x58}, /* 0xB4-0xB7 */
	{0xC4, 0x59}, {0xC4, 0x5A}, {0xC4, 0x5B}, {0xC4, 0x5C}, /* 0xB8-0xBB */
	{0xC4, 0x5D}, {0xC4, 0x5E}, {0xC4, 0x5F}, {0xC4, 0x60}, /* 0xBC-0xBF */
	{0xC4, 0x61}, {0xC4, 0x62}, {0xC4, 0x63}, {0xC4, 0x66}, /* 0xC0-0xC3 */
	{0xC4, 0x67}, {0xC4, 0x69}, {0xC4, 0x6A}, {0xC4, 0x6B}, /* 0xC4-0xC7 */
	{0xC4, 0x6D}, {0xC4, 0x6E}, {0xC4, 0x6F}, {0xC4, 0x70}, /* 0xC8-0xCB */
	{0xC4, 0x71}, {0xC4, 0x72}, {0xC4, 0x73}, {0xC4, 0x76}, /* 0xCC-0xCF */
	{0xC4, 0x77}, {0xC4, 0x78}, {0xC4, 0x7A}, {0xC4, 0x7B}, /* 0xD0-0xD3 */
	{0xC4, 0x7C}, {0xC4, 0x7D}, {0xC4, 0x7E}, {0xC4, 0x7F}, /* 0xD4-0xD7 */
	{0xC4, 0x81}, {0xC4, 0x82}, {0xC4, 0x83}, {0xC4, 0x84}, /* 0xD8-0xDB */
	{0xC4, 0x85}, {0xC4, 0x86}, {0xC4, 0x87}, {0xC4, 0x88}, /* 0xDC-0xDF */
	{0xC4, 0x89}, {0xC4, 0x8A}, {0xC4, 0x8B}, {0xC4, 0x8C}, /* 0xE0-0xE3 */
	{0xC4, 0x8D}, {0xC4, 0x8E}, {0xC4, 0x8F}, {0xC4, 0x90}, /* 0xE4-0xE7 */
	{0xC4, 0x91}, {0xC4, 0x92}, {0xC4, 0x93}, {0xC4, 0x95}, /* 0xE8-0xEB */
	{0xC4, 0x96}, {0xC4, 0x97}, {0xC4, 0x98}, {0xC4, 0x99}, /* 0xEC-0xEF */
	{0xC4, 0x9A}, {0xC4, 0x9B}, {0xC4, 0x9D}, {0xC4, 0x9E}, /* 0xF0-0xF3 */
	{0xC4, 0x9F}, {0xC4, 0xA0}, {0xC4, 0xA1}, {0xC4, 0xA2}, /* 0xF4-0xF7 */
	{0xC4, 0xA3}, {0xC4, 0xA4}, {0xC4, 0xA5}, {0xC4, 0xA6}, /* 0xF8-0xFB */
	{0xC4, 0xA7}, {0xC4, 0xA8}, {0xC4, 0xA9}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_9D[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xC4, 0xAA}, {0xC4, 0xAB}, {0xC4, 0xAC}, /* 0x40-0x43 */
	{0xC4, 0xAD}, {0xC4, 0xAE}, {0xC4, 0xAF}, {0xC4, 0xB0}, /* 0x44-0x47 */
	{0xC4, 0xB1}, {0xC4, 0xB2}, {0xC4, 0xB3}, {0xC4, 0xB4}, /* 0x48-0x4B */
	{0xC4, 0xB5}, {0xC4, 0xB6}, {0xC4, 0xB7}, {0xC4, 0xB9}, /* 0x4C-0x4F */
	{0xC4, 0xBA}, {0xC4, 0xBB}, {0xC4, 0xBD}, {0xC4, 0xBE}, /* 0x50-0x53 */
	{0xC4, 0xBF}, {0xC4, 0xC0}, {0xC4, 0xC1}, {0xC4, 0xC2}, /* 0x54-0x57 */
	{0xC4, 0xC3}, {0xC4, 0xC4}, {0xC4, 0xC5}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xC4, 0xC6}, {0xC4, 0xC7}, {0xC4, 0xC8}, /* 0x60-0x63 */
	{0xC4, 0xC9}, {0xC4, 0xCA}, {0xC4, 0xCB}, {0xC4, 0xCC}, /* 0x64-0x67 */
	{0xC4, 0xCD}, {0xC4, 0xCE}, {0xC4, 0xCF}, {0xC4, 0xD0}, /* 0x68-0x6B */
	{0xC4, 0xD1}, {0xC4, 0xD2}, {0xC4, 0xD3}, {0xC4, 0xD4}, /* 0x6C-0x6F */
	{0xC4, 0xD5}, {0xC4, 0xD6}, {0xC4, 0xD7}, {0xC4, 0xD8}, /* 0x70-0x73 */
	{0xC4, 0xD9}, {0xC4, 0xDA}, {0xC4, 0xDB}, {0xC4, 0xDC}, /* 0x74-0x77 */
	{0xC4, 0xDD}, {0xC4, 0xDE}, {0xC4, 0xDF}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xC4, 0xE0}, {0xC4, 0xE1}, {0xC4, 0xE2}, /* 0x80-0x83 */
	{0xC4, 0xE3}, {0xC4, 0xE4}, {0xC4, 0xE5}, {0xC4, 0xE6}, /* 0x84-0x87 */
	{0xC4, 0xE7}, {0xC4, 0xE8}, {0xC4, 0xEA}, {0xC4, 0xEB}, /* 0x88-0x8B */
	{0xC4, 0xEC}, {0xC4, 0xED}, {0xC4, 0xEE}, {0xC4, 0xEF}, /* 0x8C-0x8F */
	{0xC4, 0xF2}, {0xC4, 0xF3}, {0xC4, 0xF5}, {0xC4, 0xF6}, /* 0x90-0x93 */
	{0xC4, 0xF7}, {0xC4, 0xF9}, {0xC4, 0xFB}, {0xC4, 0xFC}, /* 0x94-0x97 */
	{0xC4, 0xFD}, {0xC4, 0xFE}, {0xC5, 0x02}, {0xC5, 0x03}, /* 0x98-0x9B */
	{0xC5, 0x04}, {0xC5, 0x05}, {0xC5, 0x06}, {0xC5, 0x07}, /* 0x9C-0x9F */
	{0xC5, 0x08}, {0xC5, 0x09}, {0xC5, 0x0A}, {0xC5, 0x0B}, /* 0xA0-0xA3 */
	{0xC5, 0x0D}, {0xC5, 0x0E}, {0xC5, 0x0F}, {0xC5, 0x11}, /* 0xA4-0xA7 */
	{0xC5, 0x12}, {0xC5, 0x13}, {0xC5, 0x15}, {0xC5, 0x16}, /* 0xA8-0xAB */
	{0xC5, 0x17}, {0xC5, 0x18}, {0xC5, 0x19}, {0xC5, 0x1A}, /* 0xAC-0xAF */
	{0xC5, 0x1B}, {0xC5, 0x1D}, {0xC5, 0x1E}, {0xC5, 0x1F}, /* 0xB0-0xB3 */
	{0xC5, 0x20}, {0xC5, 0x21}, {0xC5, 0x22}, {0xC5, 0x23}, /* 0xB4-0xB7 */
	{0xC5, 0x24}, {0xC5, 0x25}, {0xC5, 0x26}, {0xC5, 0x27}, /* 0xB8-0xBB */
	{0xC5, 0x2A}, {0xC5, 0x2B}, {0xC5, 0x2D}, {0xC5, 0x2E}, /* 0xBC-0xBF */
	{0xC5, 0x2F}, {0xC5, 0x31}, {0xC5, 0x32}, {0xC5, 0x33}, /* 0xC0-0xC3 */
	{0xC5, 0x34}, {0xC5, 0x35}, {0xC5, 0x36}, {0xC5, 0x37}, /* 0xC4-0xC7 */
	{0xC5, 0x3A}, {0xC5, 0x3C}, {0xC5, 0x3E}, {0xC5, 0x3F}, /* 0xC8-0xCB */
	{0xC5, 0x40}, {0xC5, 0x41}, {0xC5, 0x42}, {0xC5, 0x43}, /* 0xCC-0xCF */
	{0xC5, 0x46}, {0xC5, 0x47}, {0xC5, 0x4B}, {0xC5, 0x4F}, /* 0xD0-0xD3 */
	{0xC5, 0x50}, {0xC5, 0x51}, {0xC5, 0x52}, {0xC5, 0x56}, /* 0xD4-0xD7 */
	{0xC5, 0x5A}, {0xC5, 0x5B}, {0xC5, 0x5C}, {0xC5, 0x5F}, /* 0xD8-0xDB */
	{0xC5, 0x62}, {0xC5, 0x63}, {0xC5, 0x65}, {0xC5, 0x66}, /* 0xDC-0xDF */
	{0xC5, 0x67}, {0xC5, 0x69}, {0xC5, 0x6A}, {0xC5, 0x6B}, /* 0xE0-0xE3 */
	{0xC5, 0x6C}, {0xC5, 0x6D}, {0xC5, 0x6E}, {0xC5, 0x6F}, /* 0xE4-0xE7 */
	{0xC5, 0x72}, {0xC5, 0x76}, {0xC5, 0x77}, {0xC5, 0x78}, /* 0xE8-0xEB */
	{0xC5, 0x79}, {0xC5, 0x7A}, {0xC5, 0x7B}, {0xC5, 0x7E}, /* 0xEC-0xEF */
	{0xC5, 0x7F}, {0xC5, 0x81}, {0xC5, 0x82}, {0xC5, 0x83}, /* 0xF0-0xF3 */
	{0xC5, 0x85}, {0xC5, 0x86}, {0xC5, 0x88}, {0xC5, 0x89}, /* 0xF4-0xF7 */
	{0xC5, 0x8A}, {0xC5, 0x8B}, {0xC5, 0x8E}, {0xC5, 0x90}, /* 0xF8-0xFB */
	{0xC5, 0x92}, {0xC5, 0x93}, {0xC5, 0x94}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_9E[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xC5, 0x96}, {0xC5, 0x99}, {0xC5, 0x9A}, /* 0x40-0x43 */
	{0xC5, 0x9B}, {0xC5, 0x9D}, {0xC5, 0x9E}, {0xC5, 0x9F}, /* 0x44-0x47 */
	{0xC5, 0xA1}, {0xC5, 0xA2}, {0xC5, 0xA3}, {0xC5, 0xA4}, /* 0x48-0x4B */
	{0xC5, 0xA5}, {0xC5, 0xA6}, {0xC5, 0xA7}, {0xC5, 0xA8}, /* 0x4C-0x4F */
	{0xC5, 0xAA}, {0xC5, 0xAB}, {0xC5, 0xAC}, {0xC5, 0xAD}, /* 0x50-0x53 */
	{0xC5, 0xAE}, {0xC5, 0xAF}, {0xC5, 0xB0}, {0xC5, 0xB1}, /* 0x54-0x57 */
	{0xC5, 0xB2}, {0xC5, 0xB3}, {0xC5, 0xB6}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xC5, 0xB7}, {0xC5, 0xBA}, {0xC5, 0xBF}, /* 0x60-0x63 */
	{0xC5, 0xC0}, {0xC5, 0xC1}, {0xC5, 0xC2}, {0xC5, 0xC3}, /* 0x64-0x67 */
	{0xC5, 0xCB}, {0xC5, 0xCD}, {0xC5, 0xCF}, {0xC5, 0xD2}, /* 0x68-0x6B */
	{0xC5, 0xD3}, {0xC5, 0xD5}, {0xC5, 0xD6}, {0xC5, 0xD7}, /* 0x6C-0x6F */
	{0xC5, 0xD9}, {0xC5, 0xDA}, {0xC5, 0xDB}, {0xC5, 0xDC}, /* 0x70-0x73 */
	{0xC5, 0xDD}, {0xC5, 0xDE}, {0xC5, 0xDF}, {0xC5, 0xE2}, /* 0x74-0x77 */
	{0xC5, 0xE4}, {0xC5, 0xE6}, {0xC5, 0xE7}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xC5, 0xE8}, {0xC5, 0xE9}, {0xC5, 0xEA}, /* 0x80-0x83 */
	{0xC5, 0xEB}, {0xC5, 0xEF}, {0xC5, 0xF1}, {0xC5, 0xF2}, /* 0x84-0x87 */
	{0xC5, 0xF3}, {0xC5, 0xF5}, {0xC5, 0xF8}, {0xC5, 0xF9}, /* 0x88-0x8B */
	{0xC5, 0xFA}, {0xC5, 0xFB}, {0xC6, 0x02}, {0xC6, 0x03}, /* 0x8C-0x8F */
	{0xC6, 0x04}, {0xC6, 0x09}, {0xC6, 0x0A}, {0xC6, 0x0B}, /* 0x90-0x93 */
	{0xC6, 0x0D}, {0xC6, 0x0E}, {0xC6, 0x0F}, {0xC6, 0x11}, /* 0x94-0x97 */
	{0xC6, 0x12}, {0xC6, 0x13}, {0xC6, 0x14}, {0xC6, 0x15}, /* 0x98-0x9B */
	{0xC6, 0x16}, {0xC6, 0x17}, {0xC6, 0x1A}, {0xC6, 0x1D}, /* 0x9C-0x9F */
	{0xC6, 0x1E}, {0xC6, 0x1F}, {0xC6, 0x20}, {0xC6, 0x21}, /* 0xA0-0xA3 */
	{0xC6, 0x22}, {0xC6, 0x23}, {0xC6, 0x26}, {0xC6, 0x27}, /* 0xA4-0xA7 */
	{0xC6, 0x29}, {0xC6, 0x2A}, {0xC6, 0x2B}, {0xC6, 0x2F}, /* 0xA8-0xAB */
	{0xC6, 0x31}, {0xC6, 0x32}, {0xC6, 0x36}, {0xC6, 0x38}, /* 0xAC-0xAF */
	{0xC6, 0x3A}, {0xC6, 0x3C}, {0xC6, 0x3D}, {0xC6, 0x3E}, /* 0xB0-0xB3 */
	{0xC6, 0x3F}, {0xC6, 0x42}, {0xC6, 0x43}, {0xC6, 0x45}, /* 0xB4-0xB7 */
	{0xC6, 0x46}, {0xC6, 0x47}, {0xC6, 0x49}, {0xC6, 0x4A}, /* 0xB8-0xBB */
	{0xC6, 0x4B}, {0xC6, 0x4C}, {0xC6, 0x4D}, {0xC6, 0x4E}, /* 0xBC-0xBF */
	{0xC6, 0x4F}, {0xC6, 0x52}, {0xC6, 0x56}, {0xC6, 0x57}, /* 0xC0-0xC3 */
	{0xC6, 0x58}, {0xC6, 0x59}, {0xC6, 0x5A}, {0xC6, 0x5B}, /* 0xC4-0xC7 */
	{0xC6, 0x5E}, {0xC6, 0x5F}, {0xC6, 0x61}, {0xC6, 0x62}, /* 0xC8-0xCB */
	{0xC6, 0x63}, {0xC6, 0x64}, {0xC6, 0x65}, {0xC6, 0x66}, /* 0xCC-0xCF */
	{0xC6, 0x67}, {0xC6, 0x68}, {0xC6, 0x69}, {0xC6, 0x6A}, /* 0xD0-0xD3 */
	{0xC6, 0x6B}, {0xC6, 0x6D}, {0xC6, 0x6E}, {0xC6, 0x70}, /* 0xD4-0xD7 */
	{0xC6, 0x72}, {0xC6, 0x73}, {0xC6, 0x74}, {0xC6, 0x75}, /* 0xD8-0xDB */
	{0xC6, 0x76}, {0xC6, 0x77}, {0xC6, 0x7A}, {0xC6, 0x7B}, /* 0xDC-0xDF */
	{0xC6, 0x7D}, {0xC6, 0x7E}, {0xC6, 0x7F}, {0xC6, 0x81}, /* 0xE0-0xE3 */
	{0xC6, 0x82}, {0xC6, 0x83}, {0xC6, 0x84}, {0xC6, 0x85}, /* 0xE4-0xE7 */
	{0xC6, 0x86}, {0xC6, 0x87}, {0xC6, 0x8A}, {0xC6, 0x8C}, /* 0xE8-0xEB */
	{0xC6, 0x8E}, {0xC6, 0x8F}, {0xC6, 0x90}, {0xC6, 0x91}, /* 0xEC-0xEF */
	{0xC6, 0x92}, {0xC6, 0x93}, {0xC6, 0x96}, {0xC6, 0x97}, /* 0xF0-0xF3 */
	{0xC6, 0x99}, {0xC6, 0x9A}, {0xC6, 0x9B}, {0xC6, 0x9D}, /* 0xF4-0xF7 */
	{0xC6, 0x9E}, {0xC6, 0x9F}, {0xC6, 0xA0}, {0xC6, 0xA1}, /* 0xF8-0xFB */
	{0xC6, 0xA2}, {0xC6, 0xA3}, {0xC6, 0xA6}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_9F[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xC6, 0xA8}, {0xC6, 0xAA}, {0xC6, 0xAB}, /* 0x40-0x43 */
	{0xC6, 0xAC}, {0xC6, 0xAD}, {0xC6, 0xAE}, {0xC6, 0xAF}, /* 0x44-0x47 */
	{0xC6, 0xB2}, {0xC6, 0xB3}, {0xC6, 0xB5}, {0xC6, 0xB6}, /* 0x48-0x4B */
	{0xC6, 0xB7}, {0xC6, 0xBB}, {0xC6, 0xBC}, {0xC6, 0xBD}, /* 0x4C-0x4F */
	{0xC6, 0xBE}, {0xC6, 0xBF}, {0xC6, 0xC2}, {0xC6, 0xC4}, /* 0x50-0x53 */
	{0xC6, 0xC6}, {0xC6, 0xC7}, {0xC6, 0xC8}, {0xC6, 0xC9}, /* 0x54-0x57 */
	{0xC6, 0xCA}, {0xC6, 0xCB}, {0xC6, 0xCE}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xC6, 0xCF}, {0xC6, 0xD1}, {0xC6, 0xD2}, /* 0x60-0x63 */
	{0xC6, 0xD3}, {0xC6, 0xD5}, {0xC6, 0xD6}, {0xC6, 0xD7}, /* 0x64-0x67 */
	{0xC6, 0xD8}, {0xC6, 0xD9}, {0xC6, 0xDA}, {0xC6, 0xDB}, /* 0x68-0x6B */
	{0xC6, 0xDE}, {0xC6, 0xDF}, {0xC6, 0xE2}, {0xC6, 0xE3}, /* 0x6C-0x6F */
	{0xC6, 0xE4}, {0xC6, 0xE5}, {0xC6, 0xE6}, {0xC6, 0xE7}, /* 0x70-0x73 */
	{0xC6, 0xEA}, {0xC6, 0xEB}, {0xC6, 0xED}, {0xC6, 0xEE}, /* 0x74-0x77 */
	{0xC6, 0xEF}, {0xC6, 0xF1}, {0xC6, 0xF2}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xC6, 0xF3}, {0xC6, 0xF4}, {0xC6, 0xF5}, /* 0x80-0x83 */
	{0xC6, 0xF6}, {0xC6, 0xF7}, {0xC6, 0xFA}, {0xC6, 0xFB}, /* 0x84-0x87 */
	{0xC6, 0xFC}, {0xC6, 0xFE}, {0xC6, 0xFF}, {0xC7, 0x00}, /* 0x88-0x8B */
	{0xC7, 0x01}, {0xC7, 0x02}, {0xC7, 0x03}, {0xC7, 0x06}, /* 0x8C-0x8F */
	{0xC7, 0x07}, {0xC7, 0x09}, {0xC7, 0x0A}, {0xC7, 0x0B}, /* 0x90-0x93 */
	{0xC7, 0x0D}, {0xC7, 0x0E}, {0xC7, 0x0F}, {0xC7, 0x10}, /* 0x94-0x97 */
	{0xC7, 0x11}, {0xC7, 0x12}, {0xC7, 0x13}, {0xC7, 0x16}, /* 0x98-0x9B */
	{0xC7, 0x18}, {0xC7, 0x1A}, {0xC7, 0x1B}, {0xC7, 0x1C}, /* 0x9C-0x9F */
	{0xC7, 0x1D}, {0xC7, 0x1E}, {0xC7, 0x1F}, {0xC7, 0x22}, /* 0xA0-0xA3 */
	{0xC7, 0x23}, {0xC7, 0x25}, {0xC7, 0x26}, {0xC7, 0x27}, /* 0xA4-0xA7 */
	{0xC7, 0x29}, {0xC7, 0x2A}, {0xC7, 0x2B}, {0xC7, 0x2C}, /* 0xA8-0xAB */
	{0xC7, 0x2D}, {0xC7, 0x2E}, {0xC7, 0x2F}, {0xC7, 0x32}, /* 0xAC-0xAF */
	{0xC7, 0x34}, {0xC7, 0x36}, {0xC7, 0x38}, {0xC7, 0x39}, /* 0xB0-0xB3 */
	{0xC7, 0x3A}, {0xC7, 0x3B}, {0xC7, 0x3E}, {0xC7, 0x3F}, /* 0xB4-0xB7 */
	{0xC7, 0x41}, {0xC7, 0x42}, {0xC7, 0x43}, {0xC7, 0x45}, /* 0xB8-0xBB */
	{0xC7, 0x46}, {0xC7, 0x47}, {0xC7, 0x48}, {0xC7, 0x49}, /* 0xBC-0xBF */
	{0xC7, 0x4B}, {0xC7, 0x4E}, {0xC7, 0x50}, {0xC7, 0x59}, /* 0xC0-0xC3 */
	{0xC7, 0x5A}, {0xC7, 0x5B}, {0xC7, 0x5D}, {0xC7, 0x5E}, /* 0xC4-0xC7 */
	{0xC7, 0x5F}, {0xC7, 0x61}, {0xC7, 0x62}, {0xC7, 0x63}, /* 0xC8-0xCB */
	{0xC7, 0x64}, {0xC7, 0x65}, {0xC7, 0x66}, {0xC7, 0x67}, /* 0xCC-0xCF */
	{0xC7, 0x69}, {0xC7, 0x6A}, {0xC7, 0x6C}, {0xC7, 0x6D}, /* 0xD0-0xD3 */
	{0xC7, 0x6E}, {0xC7, 0x6F}, {0xC7, 0x70}, {0xC7, 0x71}, /* 0xD4-0xD7 */
	{0xC7, 0x72}, {0xC7, 0x73}, {0xC7, 0x76}, {0xC7, 0x77}, /* 0xD8-0xDB */
	{0xC7, 0x79}, {0xC7, 0x7A}, {0xC7, 0x7B}, {0xC7, 0x7F}, /* 0xDC-0xDF */
	{0xC7, 0x80}, {0xC7, 0x81}, {0xC7, 0x82}, {0xC7, 0x86}, /* 0xE0-0xE3 */
	{0xC7, 0x8B}, {0xC7, 0x8C}, {0xC7, 0x8D}, {0xC7, 0x8F}, /* 0xE4-0xE7 */
	{0xC7, 0x92}, {0xC7, 0x93}, {0xC7, 0x95}, {0xC7, 0x99}, /* 0xE8-0xEB */
	{0xC7, 0x9B}, {0xC7, 0x9C}, {0xC7, 0x9D}, {0xC7, 0x9E}, /* 0xEC-0xEF */
	{0xC7, 0x9F}, {0xC7, 0xA2}, {0xC7, 0xA7}, {0xC7, 0xA8}, /* 0xF0-0xF3 */
	{0xC7, 0xA9}, {0xC7, 0xAA}, {0xC7, 0xAB}, {0xC7, 0xAE}, /* 0xF4-0xF7 */
	{0xC7, 0xAF}, {0xC7, 0xB1}, {0xC7, 0xB2}, {0xC7, 0xB3}, /* 0xF8-0xFB */
	{0xC7, 0xB5}, {0xC7, 0xB6}, {0xC7, 0xB7}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_A0[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xC7, 0xB8}, {0xC7, 0xB9}, {0xC7, 0xBA}, /* 0x40-0x43 */
	{0xC7, 0xBB}, {0xC7, 0xBE}, {0xC7, 0xC2}, {0xC7, 0xC3}, /* 0x44-0x47 */
	{0xC7, 0xC4}, {0xC7, 0xC5}, {0xC7, 0xC6}, {0xC7, 0xC7}, /* 0x48-0x4B */
	{0xC7, 0xCA}, {0xC7, 0xCB}, {0xC7, 0xCD}, {0xC7, 0xCF}, /* 0x4C-0x4F */
	{0xC7, 0xD1}, {0xC7, 0xD2}, {0xC7, 0xD3}, {0xC7, 0xD4}, /* 0x50-0x53 */
	{0xC7, 0xD5}, {0xC7, 0xD6}, {0xC7, 0xD7}, {0xC7, 0xD9}, /* 0x54-0x57 */
	{0xC7, 0xDA}, {0xC7, 0xDB}, {0xC7, 0xDC}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xC7, 0xDE}, {0xC7, 0xDF}, {0xC7, 0xE0}, /* 0x60-0x63 */
	{0xC7, 0xE1}, {0xC7, 0xE2}, {0xC7, 0xE3}, {0xC7, 0xE5}, /* 0x64-0x67 */
	{0xC7, 0xE6}, {0xC7, 0xE7}, {0xC7, 0xE9}, {0xC7, 0xEA}, /* 0x68-0x6B */
	{0xC7, 0xEB}, {0xC7, 0xED}, {0xC7, 0xEE}, {0xC7, 0xEF}, /* 0x6C-0x6F */
	{0xC7, 0xF0}, {0xC7, 0xF1}, {0xC7, 0xF2}, {0xC7, 0xF3}, /* 0x70-0x73 */
	{0xC7, 0xF4}, {0xC7, 0xF5}, {0xC7, 0xF6}, {0xC7, 0xF7}, /* 0x74-0x77 */
	{0xC7, 0xF8}, {0xC7, 0xF9}, {0xC7, 0xFA}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xC7, 0xFB}, {0xC7, 0xFC}, {0xC7, 0xFD}, /* 0x80-0x83 */
	{0xC7, 0xFE}, {0xC7, 0xFF}, {0xC8, 0x02}, {0xC8, 0x03}, /* 0x84-0x87 */
	{0xC8, 0x05}, {0xC8, 0x06}, {0xC8, 0x07}, {0xC8, 0x09}, /* 0x88-0x8B */
	{0xC8, 0x0B}, {0xC8, 0x0C}, {0xC8, 0x0D}, {0xC8, 0x0E}, /* 0x8C-0x8F */
	{0xC8, 0x0F}, {0xC8, 0x12}, {0xC8, 0x14}, {0xC8, 0x17}, /* 0x90-0x93 */
	{0xC8, 0x18}, {0xC8, 0x19}, {0xC8, 0x1A}, {0xC8, 0x1B}, /* 0x94-0x97 */
	{0xC8, 0x1E}, {0xC8, 0x1F}, {0xC8, 0x21}, {0xC8, 0x22}, /* 0x98-0x9B */
	{0xC8, 0x23}, {0xC8, 0x25}, {0xC8, 0x26}, {0xC8, 0x27}, /* 0x9C-0x9F */
	{0xC8, 0x28}, {0xC8, 0x29}, {0xC8, 0x2A}, {0xC8, 0x2B}, /* 0xA0-0xA3 */
	{0xC8, 0x2E}, {0xC8, 0x30}, {0xC8, 0x32}, {0xC8, 0x33}, /* 0xA4-0xA7 */
	{0xC8, 0x34}, {0xC8, 0x35}, {0xC8, 0x36}, {0xC8, 0x37}, /* 0xA8-0xAB */
	{0xC8, 0x39}, {0xC8, 0x3A}, {0xC8, 0x3B}, {0xC8, 0x3D}, /* 0xAC-0xAF */
	{0xC8, 0x3E}, {0xC8, 0x3F}, {0xC8, 0x41}, {0xC8, 0x42}, /* 0xB0-0xB3 */
	{0xC8, 0x43}, {0xC8, 0x44}, {0xC8, 0x45}, {0xC8, 0x46}, /* 0xB4-0xB7 */
	{0xC8, 0x47}, {0xC8, 0x4A}, {0xC8, 0x4B}, {0xC8, 0x4E}, /* 0xB8-0xBB */
	{0xC8, 0x4F}, {0xC8, 0x50}, {0xC8, 0x51}, {0xC8, 0x52}, /* 0xBC-0xBF */
	{0xC8, 0x53}, {0xC8, 0x55}, {0xC8, 0x56}, {0xC8, 0x57}, /* 0xC0-0xC3 */
	{0xC8, 0x58}, {0xC8, 0x59}, {0xC8, 0x5A}, {0xC8, 0x5B}, /* 0xC4-0xC7 */
	{0xC8, 0x5C}, {0xC8, 0x5D}, {0xC8, 0x5E}, {0xC8, 0x5F}, /* 0xC8-0xCB */
	{0xC8, 0x60}, {0xC8, 0x61}, {0xC8, 0x62}, {0xC8, 0x63}, /* 0xCC-0xCF */
	{0xC8, 0x64}, {0xC8, 0x65}, {0xC8, 0x66}, {0xC8, 0x67}, /* 0xD0-0xD3 */
	{0xC8, 0x68}, {0xC8, 0x69}, {0xC8, 0x6A}, {0xC8, 0x6B}, /* 0xD4-0xD7 */
	{0xC8, 0x6C}, {0xC8, 0x6D}, {0xC8, 0x6E}, {0xC8, 0x6F}, /* 0xD8-0xDB */
	{0xC8, 0x72}, {0xC8, 0x73}, {0xC8, 0x75}, {0xC8, 0x76}, /* 0xDC-0xDF */
	{0xC8, 0x77}, {0xC8, 0x79}, {0xC8, 0x7B}, {0xC8, 0x7C}, /* 0xE0-0xE3 */
	{0xC8, 0x7D}, {0xC8, 0x7E}, {0xC8, 0x7F}, {0xC8, 0x82}, /* 0xE4-0xE7 */
	{0xC8, 0x84}, {0xC8, 0x88}, {0xC8, 0x89}, {0xC8, 0x8A}, /* 0xE8-0xEB */
	{0xC8, 0x8E}, {0xC8, 0x8F}, {0xC8, 0x90}, {0xC8, 0x91}, /* 0xEC-0xEF */
	{0xC8, 0x92}, {0xC8, 0x93}, {0xC8, 0x95}, {0xC8, 0x96}, /* 0xF0-0xF3 */
	{0xC8, 0x97}, {0xC8, 0x98}, {0xC8, 0x99}, {0xC8, 0x9A}, /* 0xF4-0xF7 */
	{0xC8, 0x9B}, {0xC8, 0x9C}, {0xC8, 0x9E}, {0xC8, 0xA0}, /* 0xF8-0xFB */
	{0xC8, 0xA2}, {0xC8, 0xA3}, {0xC8, 0xA4}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_A1[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xC8, 0xA5}, {0xC8, 0xA6}, {0xC8, 0xA7}, /* 0x40-0x43 */
	{0xC8, 0xA9}, {0xC8, 0xAA}, {0xC8, 0xAB}, {0xC8, 0xAC}, /* 0x44-0x47 */
	{0xC8, 0xAD}, {0xC8, 0xAE}, {0xC8, 0xAF}, {0xC8, 0xB0}, /* 0x48-0x4B */
	{0xC8, 0xB1}, {0xC8, 0xB2}, {0xC8, 0xB3}, {0xC8, 0xB4}, /* 0x4C-0x4F */
	{0xC8, 0xB5}, {0xC8, 0xB6}, {0xC8, 0xB7}, {0xC8, 0xB8}, /* 0x50-0x53 */
	{0xC8, 0xB9}, {0xC8, 0xBA}, {0xC8, 0xBB}, {0xC8, 0xBE}, /* 0x54-0x57 */
	{0xC8, 0xBF}, {0xC8, 0xC0}, {0xC8, 0xC1}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xC8, 0xC2}, {0xC8, 0xC3}, {0xC8, 0xC5}, /* 0x60-0x63 */
	{0xC8, 0xC6}, {0xC8, 0xC7}, {0xC8, 0xC9}, {0xC8, 0xCA}, /* 0x64-0x67 */
	{0xC8, 0xCB}, {0xC8, 0xCD}, {0xC8, 0xCE}, {0xC8, 0xCF}, /* 0x68-0x6B */
	{0xC8, 0xD0}, {0xC8, 0xD1}, {0xC8, 0xD2}, {0xC8, 0xD3}, /* 0x6C-0x6F */
	{0xC8, 0xD6}, {0xC8, 0xD8}, {0xC8, 0xDA}, {0xC8, 0xDB}, /* 0x70-0x73 */
	{0xC8, 0xDC}, {0xC8, 0xDD}, {0xC8, 0xDE}, {0xC8, 0xDF}, /* 0x74-0x77 */
	{0xC8, 0xE2}, {0xC8, 0xE3}, {0xC8, 0xE5}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xC8, 0xE6}, {0xC8, 0xE7}, {0xC8, 0xE8}, /* 0x80-0x83 */
	{0xC8, 0xE9}, {0xC8, 0xEA}, {0xC8, 0xEB}, {0xC8, 0xEC}, /* 0x84-0x87 */
	{0xC8, 0xED}, {0xC8, 0xEE}, {0xC8, 0xEF}, {0xC8, 0xF0}, /* 0x88-0x8B */
	{0xC8, 0xF1}, {0xC8, 0xF2}, {0xC8, 0xF3}, {0xC8, 0xF4}, /* 0x8C-0x8F */
	{0xC8, 0xF6}, {0xC8, 0xF7}, {0xC8, 0xF8}, {0xC8, 0xF9}, /* 0x90-0x93 */
	{0xC8, 0xFA}, {0xC8, 0xFB}, {0xC8, 0xFE}, {0xC8, 0xFF}, /* 0x94-0x97 */
	{0xC9, 0x01}, {0xC9, 0x02}, {0xC9, 0x03}, {0xC9, 0x07}, /* 0x98-0x9B */
	{0xC9, 0x08}, {0xC9, 0x09}, {0xC9, 0x0A}, {0xC9, 0x0B}, /* 0x9C-0x9F */
	{0xC9, 0x0E}, {0x30, 0x00}, {0x30, 0x01}, {0x30, 0x02}, /* 0xA0-0xA3 */
	{0x00, 0xB7}, {0x20, 0x25}, {0x20, 0x26}, {0x00, 0xA8}, /* 0xA4-0xA7 */
	{0x30, 0x03}, {0x00, 0xAD}, {0x20, 0x15}, {0x22, 0x25}, /* 0xA8-0xAB */
	{0xFF, 0x3C}, {0x22, 0x3C}, {0x20, 0x18}, {0x20, 0x19}, /* 0xAC-0xAF */
	{0x20, 0x1C}, {0x20, 0x1D}, {0x30, 0x14}, {0x30, 0x15}, /* 0xB0-0xB3 */
	{0x30, 0x08}, {0x30, 0x09}, {0x30, 0x0A}, {0x30, 0x0B}, /* 0xB4-0xB7 */
	{0x30, 0x0C}, {0x30, 0x0D}, {0x30, 0x0E}, {0x30, 0x0F}, /* 0xB8-0xBB */
	{0x30, 0x10}, {0x30, 0x11}, {0x00, 0xB1}, {0x00, 0xD7}, /* 0xBC-0xBF */
	{0x00, 0xF7}, {0x22, 0x60}, {0x22, 0x64}, {0x22, 0x65}, /* 0xC0-0xC3 */
	{0x22, 0x1E}, {0x22, 0x34}, {0x00, 0xB0}, {0x20, 0x32}, /* 0xC4-0xC7 */
	{0x20, 0x33}, {0x21, 0x03}, {0x21, 0x2B}, {0xFF, 0xE0}, /* 0xC8-0xCB */
	{0xFF, 0xE1}, {0xFF, 0xE5}, {0x26, 0x42}, {0x26, 0x40}, /* 0xCC-0xCF */
	{0x22, 0x20}, {0x22, 0xA5}, {0x23, 0x12}, {0x22, 0x02}, /* 0xD0-0xD3 */
	{0x22, 0x07}, {0x22, 0x61}, {0x22, 0x52}, {0x00, 0xA7}, /* 0xD4-0xD7 */
	{0x20, 0x3B}, {0x26, 0x06}, {0x26, 0x05}, {0x25, 0xCB}, /* 0xD8-0xDB */
	{0x25, 0xCF}, {0x25, 0xCE}, {0x25, 0xC7}, {0x25, 0xC6}, /* 0xDC-0xDF */
	{0x25, 0xA1}, {0x25, 0xA0}, {0x25, 0xB3}, {0x25, 0xB2}, /* 0xE0-0xE3 */
	{0x25, 0xBD}, {0x25, 0xBC}, {0x21, 0x92}, {0x21, 0x90}, /* 0xE4-0xE7 */
	{0x21, 0x91}, {0x21, 0x93}, {0x21, 0x94}, {0x30, 0x13}, /* 0xE8-0xEB */
	{0x22, 0x6A}, {0x22, 0x6B}, {0x22, 0x1A}, {0x22, 0x3D}, /* 0xEC-0xEF */
	{0x22, 0x1D}, {0x22, 0x35}, {0x22, 0x2B}, {0x22, 0x2C}, /* 0xF0-0xF3 */
	{0x22, 0x08}, {0x22, 0x0B}, {0x22, 0x86}, {0x22, 0x87}, /* 0xF4-0xF7 */
	{0x22, 0x82}, {0x22, 0x83}, {0x22, 0x2A}, {0x22, 0x29}, /* 0xF8-0xFB */
	{0x22, 0x27}, {0x22, 0x28}, {0xFF, 0xE2}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_A2[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xC9, 0x10}, {0xC9, 0x12}, {0xC9, 0x13}, /* 0x40-0x43 */
	{0xC9, 0x14}, {0xC9, 0x15}, {0xC9, 0x16}, {0xC9, 0x17}, /* 0x44-0x47 */
	{0xC9, 0x19}, {0xC9, 0x1A}, {0xC9, 0x1B}, {0xC9, 0x1C}, /* 0x48-0x4B */
	{0xC9, 0x1D}, {0xC9, 0x1E}, {0xC9, 0x1F}, {0xC9, 0x20}, /* 0x4C-0x4F */
	{0xC9, 0x21}, {0xC9, 0x22}, {0xC9, 0x23}, {0xC9, 0x24}, /* 0x50-0x53 */
	{0xC9, 0x25}, {0xC9, 0x26}, {0xC9, 0x27}, {0xC9, 0x28}, /* 0x54-0x57 */
	{0xC9, 0x29}, {0xC9, 0x2A}, {0xC9, 0x2B}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xC9, 0x2D}, {0xC9, 0x2E}, {0xC9, 0x2F}, /* 0x60-0x63 */
	{0xC9, 0x30}, {0xC9, 0x31}, {0xC9, 0x32}, {0xC9, 0x33}, /* 0x64-0x67 */
	{0xC9, 0x35}, {0xC9, 0x36}, {0xC9, 0x37}, {0xC9, 0x38}, /* 0x68-0x6B */
	{0xC9, 0x39}, {0xC9, 0x3A}, {0xC9, 0x3B}, {0xC9, 0x3C}, /* 0x6C-0x6F */
	{0xC9, 0x3D}, {0xC9, 0x3E}, {0xC9, 0x3F}, {0xC9, 0x40}, /* 0x70-0x73 */
	{0xC9, 0x41}, {0xC9, 0x42}, {0xC9, 0x43}, {0xC9, 0x44}, /* 0x74-0x77 */
	{0xC9, 0x45}, {0xC9, 0x46}, {0xC9, 0x47}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xC9, 0x48}, {0xC9, 0x49}, {0xC9, 0x4A}, /* 0x80-0x83 */
	{0xC9, 0x4B}, {0xC9, 0x4C}, {0xC9, 0x4D}, {0xC9, 0x4E}, /* 0x84-0x87 */
	{0xC9, 0x4F}, {0xC9, 0x52}, {0xC9, 0x53}, {0xC9, 0x55}, /* 0x88-0x8B */
	{0xC9, 0x56}, {0xC9, 0x57}, {0xC9, 0x59}, {0xC9, 0x5A}, /* 0x8C-0x8F */
	{0xC9, 0x5B}, {0xC9, 0x5C}, {0xC9, 0x5D}, {0xC9, 0x5E}, /* 0x90-0x93 */
	{0xC9, 0x5F}, {0xC9, 0x62}, {0xC9, 0x64}, {0xC9, 0x65}, /* 0x94-0x97 */
	{0xC9, 0x66}, {0xC9, 0x67}, {0xC9, 0x68}, {0xC9, 0x69}, /* 0x98-0x9B */
	{0xC9, 0x6A}, {0xC9, 0x6B}, {0xC9, 0x6D}, {0xC9, 0x6E}, /* 0x9C-0x9F */
	{0xC9, 0x6F}, {0x21, 0xD2}, {0x21, 0xD4}, {0x22, 0x00}, /* 0xA0-0xA3 */
	{0x22, 0x03}, {0x00, 0xB4}, {0xFF, 0x5E}, {0x02, 0xC7}, /* 0xA4-0xA7 */
	{0x02, 0xD8}, {0x02, 0xDD}, {0x02, 0xDA}, {0x02, 0xD9}, /* 0xA8-0xAB */
	{0x00, 0xB8}, {0x02, 0xDB}, {0x00, 0xA1}, {0x00, 0xBF}, /* 0xAC-0xAF */
	{0x02, 0xD0}, {0x22, 0x2E}, {0x22, 0x11}, {0x22, 0x0F}, /* 0xB0-0xB3 */
	{0x00, 0xA4}, {0x21, 0x09}, {0x20, 0x30}, {0x25, 0xC1}, /* 0xB4-0xB7 */
	{0x25, 0xC0}, {0x25, 0xB7}, {0x25, 0xB6}, {0x26, 0x64}, /* 0xB8-0xBB */
	{0x26, 0x60}, {0x26, 0x61}, {0x26, 0x65}, {0x26, 0x67}, /* 0xBC-0xBF */
	{0x26, 0x63}, {0x22, 0x99}, {0x25, 0xC8}, {0x25, 0xA3}, /* 0xC0-0xC3 */
	{0x25, 0xD0}, {0x25, 0xD1}, {0x25, 0x92}, {0x25, 0xA4}, /* 0xC4-0xC7 */
	{0x25, 0xA5}, {0x25, 0xA8}, {0x25, 0xA7}, {0x25, 0xA6}, /* 0xC8-0xCB */
	{0x25, 0xA9}, {0x26, 0x68}, {0x26, 0x0F}, {0x26, 0x0E}, /* 0xCC-0xCF */
	{0x26, 0x1C}, {0x26, 0x1E}, {0x00, 0xB6}, {0x20, 0x20}, /* 0xD0-0xD3 */
	{0x20, 0x21}, {0x21, 0x95}, {0x21, 0x97}, {0x21, 0x99}, /* 0xD4-0xD7 */
	{0x21, 0x96}, {0x21, 0x98}, {0x26, 0x6D}, {0x26, 0x69}, /* 0xD8-0xDB */
	{0x26, 0x6A}, {0x26, 0x6C}, {0x32, 0x7F}, {0x32, 0x1C}, /* 0xDC-0xDF */
	{0x21, 0x16}, {0x33, 0xC7}, {0x21, 0x22}, {0x33, 0xC2}, /* 0xE0-0xE3 */
	{0x33, 0xD8}, {0x21, 0x21}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xE4-0xE7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xE8-0xEB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xEC-0xEF */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF0-0xF3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF4-0xF7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF8-0xFB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_A3[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xC9, 0x71}, {0xC9, 0x72}, {0xC9, 0x73}, /* 0x40-0x43 */
	{0xC9, 0x75}, {0xC9, 0x76}, {0xC9, 0x77}, {0xC9, 0x78}, /* 0x44-0x47 */
	{0xC9, 0x79}, {0xC9, 0x7A}, {0xC9, 0x7B}, {0xC9, 0x7D}, /* 0x48-0x4B */
	{0xC9, 0x7E}, {0xC9, 0x7F}, {0xC9, 0x80}, {0xC9, 0x81}, /* 0x4C-0x4F */
	{0xC9, 0x82}, {0xC9, 0x83}, {0xC9, 0x84}, {0xC9, 0x85}, /* 0x50-0x53 */
	{0xC9, 0x86}, {0xC9, 0x87}, {0xC9, 0x8A}, {0xC9, 0x8B}, /* 0x54-0x57 */
	{0xC9, 0x8D}, {0xC9, 0x8E}, {0xC9, 0x8F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xC9, 0x91}, {0xC9, 0x92}, {0xC9, 0x93}, /* 0x60-0x63 */
	{0xC9, 0x94}, {0xC9, 0x95}, {0xC9, 0x96}, {0xC9, 0x97}, /* 0x64-0x67 */
	{0xC9, 0x9A}, {0xC9, 0x9C}, {0xC9, 0x9E}, {0xC9, 0x9F}, /* 0x68-0x6B */
	{0xC9, 0xA0}, {0xC9, 0xA1}, {0xC9, 0xA2}, {0xC9, 0xA3}, /* 0x6C-0x6F */
	{0xC9, 0xA4}, {0xC9, 0xA5}, {0xC9, 0xA6}, {0xC9, 0xA7}, /* 0x70-0x73 */
	{0xC9, 0xA8}, {0xC9, 0xA9}, {0xC9, 0xAA}, {0xC9, 0xAB}, /* 0x74-0x77 */
	{0xC9, 0xAC}, {0xC9, 0xAD}, {0xC9, 0xAE}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xC9, 0xAF}, {0xC9, 0xB0}, {0xC9, 0xB1}, /* 0x80-0x83 */
	{0xC9, 0xB2}, {0xC9, 0xB3}, {0xC9, 0xB4}, {0xC9, 0xB5}, /* 0x84-0x87 */
	{0xC9, 0xB6}, {0xC9, 0xB7}, {0xC9, 0xB8}, {0xC9, 0xB9}, /* 0x88-0x8B */
	{0xC9, 0xBA}, {0xC9, 0xBB}, {0xC9, 0xBC}, {0xC9, 0xBD}, /* 0x8C-0x8F */
	{0xC9, 0xBE}, {0xC9, 0xBF}, {0xC9, 0xC2}, {0xC9, 0xC3}, /* 0x90-0x93 */
	{0xC9, 0xC5}, {0xC9, 0xC6}, {0xC9, 0xC9}, {0xC9, 0xCB}, /* 0x94-0x97 */
	{0xC9, 0xCC}, {0xC9, 0xCD}, {0xC9, 0xCE}, {0xC9, 0xCF}, /* 0x98-0x9B */
	{0xC9, 0xD2}, {0xC9, 0xD4}, {0xC9, 0xD7}, {0xC9, 0xD8}, /* 0x9C-0x9F */
	{0xC9, 0xDB}, {0xFF, 0x01}, {0xFF, 0x02}, {0xFF, 0x03}, /* 0xA0-0xA3 */
	{0xFF, 0x04}, {0xFF, 0x05}, {0xFF, 0x06}, {0xFF, 0x07}, /* 0xA4-0xA7 */
	{0xFF, 0x08}, {0xFF, 0x09}, {0xFF, 0x0A}, {0xFF, 0x0B}, /* 0xA8-0xAB */
	{0xFF, 0x0C}, {0xFF, 0x0D}, {0xFF, 0x0E}, {0xFF, 0x0F}, /* 0xAC-0xAF */
	{0xFF, 0x10}, {0xFF, 0x11}, {0xFF, 0x12}, {0xFF, 0x13}, /* 0xB0-0xB3 */
	{0xFF, 0x14}, {0xFF, 0x15}, {0xFF, 0x16}, {0xFF, 0x17}, /* 0xB4-0xB7 */
	{0xFF, 0x18}, {0xFF, 0x19}, {0xFF, 0x1A}, {0xFF, 0x1B}, /* 0xB8-0xBB */
	{0xFF, 0x1C}, {0xFF, 0x1D}, {0xFF, 0x1E}, {0xFF, 0x1F}, /* 0xBC-0xBF */
	{0xFF, 0x20}, {0xFF, 0x21}, {0xFF, 0x22}, {0xFF, 0x23}, /* 0xC0-0xC3 */
	{0xFF, 0x24}, {0xFF, 0x25}, {0xFF, 0x26}, {0xFF, 0x27}, /* 0xC4-0xC7 */
	{0xFF, 0x28}, {0xFF, 0x29}, {0xFF, 0x2A}, {0xFF, 0x2B}, /* 0xC8-0xCB */
	{0xFF, 0x2C}, {0xFF, 0x2D}, {0xFF, 0x2E}, {0xFF, 0x2F}, /* 0xCC-0xCF */
	{0xFF, 0x30}, {0xFF, 0x31}, {0xFF, 0x32}, {0xFF, 0x33}, /* 0xD0-0xD3 */
	{0xFF, 0x34}, {0xFF, 0x35}, {0xFF, 0x36}, {0xFF, 0x37}, /* 0xD4-0xD7 */
	{0xFF, 0x38}, {0xFF, 0x39}, {0xFF, 0x3A}, {0xFF, 0x3B}, /* 0xD8-0xDB */
	{0xFF, 0xE6}, {0xFF, 0x3D}, {0xFF, 0x3E}, {0xFF, 0x3F}, /* 0xDC-0xDF */
	{0xFF, 0x40}, {0xFF, 0x41}, {0xFF, 0x42}, {0xFF, 0x43}, /* 0xE0-0xE3 */
	{0xFF, 0x44}, {0xFF, 0x45}, {0xFF, 0x46}, {0xFF, 0x47}, /* 0xE4-0xE7 */
	{0xFF, 0x48}, {0xFF, 0x49}, {0xFF, 0x4A}, {0xFF, 0x4B}, /* 0xE8-0xEB */
	{0xFF, 0x4C}, {0xFF, 0x4D}, {0xFF, 0x4E}, {0xFF, 0x4F}, /* 0xEC-0xEF */
	{0xFF, 0x50}, {0xFF, 0x51}, {0xFF, 0x52}, {0xFF, 0x53}, /* 0xF0-0xF3 */
	{0xFF, 0x54}, {0xFF, 0x55}, {0xFF, 0x56}, {0xFF, 0x57}, /* 0xF4-0xF7 */
	{0xFF, 0x58}, {0xFF, 0x59}, {0xFF, 0x5A}, {0xFF, 0x5B}, /* 0xF8-0xFB */
	{0xFF, 0x5C}, {0xFF, 0x5D}, {0xFF, 0xE3}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_A4[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xC9, 0xDE}, {0xC9, 0xDF}, {0xC9, 0xE1}, /* 0x40-0x43 */
	{0xC9, 0xE3}, {0xC9, 0xE5}, {0xC9, 0xE6}, {0xC9, 0xE8}, /* 0x44-0x47 */
	{0xC9, 0xE9}, {0xC9, 0xEA}, {0xC9, 0xEB}, {0xC9, 0xEE}, /* 0x48-0x4B */
	{0xC9, 0xF2}, {0xC9, 0xF3}, {0xC9, 0xF4}, {0xC9, 0xF5}, /* 0x4C-0x4F */
	{0xC9, 0xF6}, {0xC9, 0xF7}, {0xC9, 0xFA}, {0xC9, 0xFB}, /* 0x50-0x53 */
	{0xC9, 0xFD}, {0xC9, 0xFE}, {0xC9, 0xFF}, {0xCA, 0x01}, /* 0x54-0x57 */
	{0xCA, 0x02}, {0xCA, 0x03}, {0xCA, 0x04}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xCA, 0x05}, {0xCA, 0x06}, {0xCA, 0x07}, /* 0x60-0x63 */
	{0xCA, 0x0A}, {0xCA, 0x0E}, {0xCA, 0x0F}, {0xCA, 0x10}, /* 0x64-0x67 */
	{0xCA, 0x11}, {0xCA, 0x12}, {0xCA, 0x13}, {0xCA, 0x15}, /* 0x68-0x6B */
	{0xCA, 0x16}, {0xCA, 0x17}, {0xCA, 0x19}, {0xCA, 0x1A}, /* 0x6C-0x6F */
	{0xCA, 0x1B}, {0xCA, 0x1C}, {0xCA, 0x1D}, {0xCA, 0x1E}, /* 0x70-0x73 */
	{0xCA, 0x1F}, {0xCA, 0x20}, {0xCA, 0x21}, {0xCA, 0x22}, /* 0x74-0x77 */
	{0xCA, 0x23}, {0xCA, 0x24}, {0xCA, 0x25}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xCA, 0x26}, {0xCA, 0x27}, {0xCA, 0x28}, /* 0x80-0x83 */
	{0xCA, 0x2A}, {0xCA, 0x2B}, {0xCA, 0x2C}, {0xCA, 0x2D}, /* 0x84-0x87 */
	{0xCA, 0x2E}, {0xCA, 0x2F}, {0xCA, 0x30}, {0xCA, 0x31}, /* 0x88-0x8B */
	{0xCA, 0x32}, {0xCA, 0x33}, {0xCA, 0x34}, {0xCA, 0x35}, /* 0x8C-0x8F */
	{0xCA, 0x36}, {0xCA, 0x37}, {0xCA, 0x38}, {0xCA, 0x39}, /* 0x90-0x93 */
	{0xCA, 0x3A}, {0xCA, 0x3B}, {0xCA, 0x3C}, {0xCA, 0x3D}, /* 0x94-0x97 */
	{0xCA, 0x3E}, {0xCA, 0x3F}, {0xCA, 0x40}, {0xCA, 0x41}, /* 0x98-0x9B */
	{0xCA, 0x42}, {0xCA, 0x43}, {0xCA, 0x44}, {0xCA, 0x45}, /* 0x9C-0x9F */
	{0xCA, 0x46}, {0xFF, 0xA1}, {0xFF, 0xA2}, {0xFF, 0xA3}, /* 0xA0-0xA3 */
	{0xFF, 0xA4}, {0xFF, 0xA5}, {0xFF, 0xA6}, {0xFF, 0xA7}, /* 0xA4-0xA7 */
	{0xFF, 0xA8}, {0xFF, 0xA9}, {0xFF, 0xAA}, {0xFF, 0xAB}, /* 0xA8-0xAB */
	{0xFF, 0xAC}, {0xFF, 0xAD}, {0xFF, 0xAE}, {0xFF, 0xAF}, /* 0xAC-0xAF */
	{0xFF, 0xB0}, {0xFF, 0xB1}, {0xFF, 0xB2}, {0xFF, 0xB3}, /* 0xB0-0xB3 */
	{0xFF, 0xB4}, {0xFF, 0xB5}, {0xFF, 0xB6}, {0xFF, 0xB7}, /* 0xB4-0xB7 */
	{0xFF, 0xB8}, {0xFF, 0xB9}, {0xFF, 0xBA}, {0xFF, 0xBB}, /* 0xB8-0xBB */
	{0xFF, 0xBC}, {0xFF, 0xBD}, {0xFF, 0xBE}, {0xFF, 0xC2}, /* 0xBC-0xBF */
	{0xFF, 0xC3}, {0xFF, 0xC4}, {0xFF, 0xC5}, {0xFF, 0xC6}, /* 0xC0-0xC3 */
	{0xFF, 0xC7}, {0xFF, 0xCA}, {0xFF, 0xCB}, {0xFF, 0xCC}, /* 0xC4-0xC7 */
	{0xFF, 0xCD}, {0xFF, 0xCE}, {0xFF, 0xCF}, {0xFF, 0xD2}, /* 0xC8-0xCB */
	{0xFF, 0xD3}, {0xFF, 0xD4}, {0xFF, 0xD5}, {0xFF, 0xD6}, /* 0xCC-0xCF */
	{0xFF, 0xD7}, {0xFF, 0xDA}, {0xFF, 0xDB}, {0xFF, 0xDC}, /* 0xD0-0xD3 */
	{0xFF, 0xA0}, {0x31, 0x65}, {0x31, 0x66}, {0x31, 0x67}, /* 0xD4-0xD7 */
	{0x31, 0x68}, {0x31, 0x69}, {0x31, 0x6A}, {0x31, 0x6B}, /* 0xD8-0xDB */
	{0x31, 0x6C}, {0x31, 0x6D}, {0x31, 0x6E}, {0x31, 0x6F}, /* 0xDC-0xDF */
	{0x31, 0x70}, {0x31, 0x71}, {0x31, 0x72}, {0x31, 0x73}, /* 0xE0-0xE3 */
	{0x31, 0x74}, {0x31, 0x75}, {0x31, 0x76}, {0x31, 0x77}, /* 0xE4-0xE7 */
	{0x31, 0x78}, {0x31, 0x79}, {0x31, 0x7A}, {0x31, 0x7B}, /* 0xE8-0xEB */
	{0x31, 0x7C}, {0x31, 0x7D}, {0x31, 0x7E}, {0x31, 0x7F}, /* 0xEC-0xEF */
	{0x31, 0x80}, {0x31, 0x81}, {0x31, 0x82}, {0x31, 0x83}, /* 0xF0-0xF3 */
	{0x31, 0x84}, {0x31, 0x85}, {0x31, 0x86}, {0x31, 0x87}, /* 0xF4-0xF7 */
	{0x31, 0x88}, {0x31, 0x89}, {0x31, 0x8A}, {0x31, 0x8B}, /* 0xF8-0xFB */
	{0x31, 0x8C}, {0x31, 0x8D}, {0x31, 0x8E}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_A5[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xCA, 0x47}, {0xCA, 0x48}, {0xCA, 0x49}, /* 0x40-0x43 */
	{0xCA, 0x4A}, {0xCA, 0x4B}, {0xCA, 0x4E}, {0xCA, 0x4F}, /* 0x44-0x47 */
	{0xCA, 0x51}, {0xCA, 0x52}, {0xCA, 0x53}, {0xCA, 0x55}, /* 0x48-0x4B */
	{0xCA, 0x56}, {0xCA, 0x57}, {0xCA, 0x58}, {0xCA, 0x59}, /* 0x4C-0x4F */
	{0xCA, 0x5A}, {0xCA, 0x5B}, {0xCA, 0x5E}, {0xCA, 0x62}, /* 0x50-0x53 */
	{0xCA, 0x63}, {0xCA, 0x64}, {0xCA, 0x65}, {0xCA, 0x66}, /* 0x54-0x57 */
	{0xCA, 0x67}, {0xCA, 0x69}, {0xCA, 0x6A}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xCA, 0x6B}, {0xCA, 0x6C}, {0xCA, 0x6D}, /* 0x60-0x63 */
	{0xCA, 0x6E}, {0xCA, 0x6F}, {0xCA, 0x70}, {0xCA, 0x71}, /* 0x64-0x67 */
	{0xCA, 0x72}, {0xCA, 0x73}, {0xCA, 0x74}, {0xCA, 0x75}, /* 0x68-0x6B */
	{0xCA, 0x76}, {0xCA, 0x77}, {0xCA, 0x78}, {0xCA, 0x79}, /* 0x6C-0x6F */
	{0xCA, 0x7A}, {0xCA, 0x7B}, {0xCA, 0x7C}, {0xCA, 0x7E}, /* 0x70-0x73 */
	{0xCA, 0x7F}, {0xCA, 0x80}, {0xCA, 0x81}, {0xCA, 0x82}, /* 0x74-0x77 */
	{0xCA, 0x83}, {0xCA, 0x85}, {0xCA, 0x86}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xCA, 0x87}, {0xCA, 0x88}, {0xCA, 0x89}, /* 0x80-0x83 */
	{0xCA, 0x8A}, {0xCA, 0x8B}, {0xCA, 0x8C}, {0xCA, 0x8D}, /* 0x84-0x87 */
	{0xCA, 0x8E}, {0xCA, 0x8F}, {0xCA, 0x90}, {0xCA, 0x91}, /* 0x88-0x8B */
	{0xCA, 0x92}, {0xCA, 0x93}, {0xCA, 0x94}, {0xCA, 0x95}, /* 0x8C-0x8F */
	{0xCA, 0x96}, {0xCA, 0x97}, {0xCA, 0x99}, {0xCA, 0x9A}, /* 0x90-0x93 */
	{0xCA, 0x9B}, {0xCA, 0x9C}, {0xCA, 0x9D}, {0xCA, 0x9E}, /* 0x94-0x97 */
	{0xCA, 0x9F}, {0xCA, 0xA0}, {0xCA, 0xA1}, {0xCA, 0xA2}, /* 0x98-0x9B */
	{0xCA, 0xA3}, {0xCA, 0xA4}, {0xCA, 0xA5}, {0xCA, 0xA6}, /* 0x9C-0x9F */
	{0xCA, 0xA7}, {0x21, 0x70}, {0x21, 0x71}, {0x21, 0x72}, /* 0xA0-0xA3 */
	{0x21, 0x73}, {0x21, 0x74}, {0x21, 0x75}, {0x21, 0x76}, /* 0xA4-0xA7 */
	{0x21, 0x77}, {0x21, 0x78}, {0x21, 0x79}, {0x00, 0x3F}, /* 0xA8-0xAB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xAC-0xAF */
	{0x21, 0x60}, {0x21, 0x61}, {0x21, 0x62}, {0x21, 0x63}, /* 0xB0-0xB3 */
	{0x21, 0x64}, {0x21, 0x65}, {0x21, 0x66}, {0x21, 0x67}, /* 0xB4-0xB7 */
	{0x21, 0x68}, {0x21, 0x69}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xB8-0xBB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xBC-0xBF */
	{0x00, 0x3F}, {0x03, 0x91}, {0x03, 0x92}, {0x03, 0x93}, /* 0xC0-0xC3 */
	{0x03, 0x94}, {0x03, 0x95}, {0x03, 0x96}, {0x03, 0x97}, /* 0xC4-0xC7 */
	{0x03, 0x98}, {0x03, 0x99}, {0x03, 0x9A}, {0x03, 0x9B}, /* 0xC8-0xCB */
	{0x03, 0x9C}, {0x03, 0x9D}, {0x03, 0x9E}, {0x03, 0x9F}, /* 0xCC-0xCF */
	{0x03, 0xA0}, {0x03, 0xA1}, {0x03, 0xA3}, {0x03, 0xA4}, /* 0xD0-0xD3 */
	{0x03, 0xA5}, {0x03, 0xA6}, {0x03, 0xA7}, {0x03, 0xA8}, /* 0xD4-0xD7 */
	{0x03, 0xA9}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xD8-0xDB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xDC-0xDF */
	{0x00, 0x3F}, {0x03, 0xB1}, {0x03, 0xB2}, {0x03, 0xB3}, /* 0xE0-0xE3 */
	{0x03, 0xB4}, {0x03, 0xB5}, {0x03, 0xB6}, {0x03, 0xB7}, /* 0xE4-0xE7 */
	{0x03, 0xB8}, {0x03, 0xB9}, {0x03, 0xBA}, {0x03, 0xBB}, /* 0xE8-0xEB */
	{0x03, 0xBC}, {0x03, 0xBD}, {0x03, 0xBE}, {0x03, 0xBF}, /* 0xEC-0xEF */
	{0x03, 0xC0}, {0x03, 0xC1}, {0x03, 0xC3}, {0x03, 0xC4}, /* 0xF0-0xF3 */
	{0x03, 0xC5}, {0x03, 0xC6}, {0x03, 0xC7}, {0x03, 0xC8}, /* 0xF4-0xF7 */
	{0x03, 0xC9}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF8-0xFB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_A6[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xCA, 0xA8}, {0xCA, 0xA9}, {0xCA, 0xAA}, /* 0x40-0x43 */
	{0xCA, 0xAB}, {0xCA, 0xAC}, {0xCA, 0xAD}, {0xCA, 0xAE}, /* 0x44-0x47 */
	{0xCA, 0xAF}, {0xCA, 0xB0}, {0xCA, 0xB1}, {0xCA, 0xB2}, /* 0x48-0x4B */
	{0xCA, 0xB3}, {0xCA, 0xB4}, {0xCA, 0xB5}, {0xCA, 0xB6}, /* 0x4C-0x4F */
	{0xCA, 0xB7}, {0xCA, 0xB8}, {0xCA, 0xB9}, {0xCA, 0xBA}, /* 0x50-0x53 */
	{0xCA, 0xBB}, {0xCA, 0xBE}, {0xCA, 0xBF}, {0xCA, 0xC1}, /* 0x54-0x57 */
	{0xCA, 0xC2}, {0xCA, 0xC3}, {0xCA, 0xC5}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xCA, 0xC6}, {0xCA, 0xC7}, {0xCA, 0xC8}, /* 0x60-0x63 */
	{0xCA, 0xC9}, {0xCA, 0xCA}, {0xCA, 0xCB}, {0xCA, 0xCE}, /* 0x64-0x67 */
	{0xCA, 0xD0}, {0xCA, 0xD2}, {0xCA, 0xD4}, {0xCA, 0xD5}, /* 0x68-0x6B */
	{0xCA, 0xD6}, {0xCA, 0xD7}, {0xCA, 0xDA}, {0xCA, 0xDB}, /* 0x6C-0x6F */
	{0xCA, 0xDC}, {0xCA, 0xDD}, {0xCA, 0xDE}, {0xCA, 0xDF}, /* 0x70-0x73 */
	{0xCA, 0xE1}, {0xCA, 0xE2}, {0xCA, 0xE3}, {0xCA, 0xE4}, /* 0x74-0x77 */
	{0xCA, 0xE5}, {0xCA, 0xE6}, {0xCA, 0xE7}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xCA, 0xE8}, {0xCA, 0xE9}, {0xCA, 0xEA}, /* 0x80-0x83 */
	{0xCA, 0xEB}, {0xCA, 0xED}, {0xCA, 0xEE}, {0xCA, 0xEF}, /* 0x84-0x87 */
	{0xCA, 0xF0}, {0xCA, 0xF1}, {0xCA, 0xF2}, {0xCA, 0xF3}, /* 0x88-0x8B */
	{0xCA, 0xF5}, {0xCA, 0xF6}, {0xCA, 0xF7}, {0xCA, 0xF8}, /* 0x8C-0x8F */
	{0xCA, 0xF9}, {0xCA, 0xFA}, {0xCA, 0xFB}, {0xCA, 0xFC}, /* 0x90-0x93 */
	{0xCA, 0xFD}, {0xCA, 0xFE}, {0xCA, 0xFF}, {0xCB, 0x00}, /* 0x94-0x97 */
	{0xCB, 0x01}, {0xCB, 0x02}, {0xCB, 0x03}, {0xCB, 0x04}, /* 0x98-0x9B */
	{0xCB, 0x05}, {0xCB, 0x06}, {0xCB, 0x07}, {0xCB, 0x09}, /* 0x9C-0x9F */
	{0xCB, 0x0A}, {0x25, 0x00}, {0x25, 0x02}, {0x25, 0x0C}, /* 0xA0-0xA3 */
	{0x25, 0x10}, {0x25, 0x18}, {0x25, 0x14}, {0x25, 0x1C}, /* 0xA4-0xA7 */
	{0x25, 0x2C}, {0x25, 0x24}, {0x25, 0x34}, {0x25, 0x3C}, /* 0xA8-0xAB */
	{0x25, 0x01}, {0x25, 0x03}, {0x25, 0x0F}, {0x25, 0x13}, /* 0xAC-0xAF */
	{0x25, 0x1B}, {0x25, 0x17}, {0x25, 0x23}, {0x25, 0x33}, /* 0xB0-0xB3 */
	{0x25, 0x2B}, {0x25, 0x3B}, {0x25, 0x4B}, {0x25, 0x20}, /* 0xB4-0xB7 */
	{0x25, 0x2F}, {0x25, 0x28}, {0x25, 0x37}, {0x25, 0x3F}, /* 0xB8-0xBB */
	{0x25, 0x1D}, {0x25, 0x30}, {0x25, 0x25}, {0x25, 0x38}, /* 0xBC-0xBF */
	{0x25, 0x42}, {0x25, 0x12}, {0x25, 0x11}, {0x25, 0x1A}, /* 0xC0-0xC3 */
	{0x25, 0x19}, {0x25, 0x16}, {0x25, 0x15}, {0x25, 0x0E}, /* 0xC4-0xC7 */
	{0x25, 0x0D}, {0x25, 0x1E}, {0x25, 0x1F}, {0x25, 0x21}, /* 0xC8-0xCB */
	{0x25, 0x22}, {0x25, 0x26}, {0x25, 0x27}, {0x25, 0x29}, /* 0xCC-0xCF */
	{0x25, 0x2A}, {0x25, 0x2D}, {0x25, 0x2E}, {0x25, 0x31}, /* 0xD0-0xD3 */
	{0x25, 0x32}, {0x25, 0x35}, {0x25, 0x36}, {0x25, 0x39}, /* 0xD4-0xD7 */
	{0x25, 0x3A}, {0x25, 0x3D}, {0x25, 0x3E}, {0x25, 0x40}, /* 0xD8-0xDB */
	{0x25, 0x41}, {0x25, 0x43}, {0x25, 0x44}, {0x25, 0x45}, /* 0xDC-0xDF */
	{0x25, 0x46}, {0x25, 0x47}, {0x25, 0x48}, {0x25, 0x49}, /* 0xE0-0xE3 */
	{0x25, 0x4A}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xE4-0xE7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xE8-0xEB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xEC-0xEF */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF0-0xF3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF4-0xF7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF8-0xFB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_A7[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xCB, 0x0B}, {0xCB, 0x0C}, {0xCB, 0x0D}, /* 0x40-0x43 */
	{0xCB, 0x0E}, {0xCB, 0x0F}, {0xCB, 0x11}, {0xCB, 0x12}, /* 0x44-0x47 */
	{0xCB, 0x13}, {0xCB, 0x15}, {0xCB, 0x16}, {0xCB, 0x17}, /* 0x48-0x4B */
	{0xCB, 0x19}, {0xCB, 0x1A}, {0xCB, 0x1B}, {0xCB, 0x1C}, /* 0x4C-0x4F */
	{0xCB, 0x1D}, {0xCB, 0x1E}, {0xCB, 0x1F}, {0xCB, 0x22}, /* 0x50-0x53 */
	{0xCB, 0x23}, {0xCB, 0x24}, {0xCB, 0x25}, {0xCB, 0x26}, /* 0x54-0x57 */
	{0xCB, 0x27}, {0xCB, 0x28}, {0xCB, 0x29}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xCB, 0x2A}, {0xCB, 0x2B}, {0xCB, 0x2C}, /* 0x60-0x63 */
	{0xCB, 0x2D}, {0xCB, 0x2E}, {0xCB, 0x2F}, {0xCB, 0x30}, /* 0x64-0x67 */
	{0xCB, 0x31}, {0xCB, 0x32}, {0xCB, 0x33}, {0xCB, 0x34}, /* 0x68-0x6B */
	{0xCB, 0x35}, {0xCB, 0x36}, {0xCB, 0x37}, {0xCB, 0x38}, /* 0x6C-0x6F */
	{0xCB, 0x39}, {0xCB, 0x3A}, {0xCB, 0x3B}, {0xCB, 0x3C}, /* 0x70-0x73 */
	{0xCB, 0x3D}, {0xCB, 0x3E}, {0xCB, 0x3F}, {0xCB, 0x40}, /* 0x74-0x77 */
	{0xCB, 0x42}, {0xCB, 0x43}, {0xCB, 0x44}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xCB, 0x45}, {0xCB, 0x46}, {0xCB, 0x47}, /* 0x80-0x83 */
	{0xCB, 0x4A}, {0xCB, 0x4B}, {0xCB, 0x4D}, {0xCB, 0x4E}, /* 0x84-0x87 */
	{0xCB, 0x4F}, {0xCB, 0x51}, {0xCB, 0x52}, {0xCB, 0x53}, /* 0x88-0x8B */
	{0xCB, 0x54}, {0xCB, 0x55}, {0xCB, 0x56}, {0xCB, 0x57}, /* 0x8C-0x8F */
	{0xCB, 0x5A}, {0xCB, 0x5B}, {0xCB, 0x5C}, {0xCB, 0x5E}, /* 0x90-0x93 */
	{0xCB, 0x5F}, {0xCB, 0x60}, {0xCB, 0x61}, {0xCB, 0x62}, /* 0x94-0x97 */
	{0xCB, 0x63}, {0xCB, 0x65}, {0xCB, 0x66}, {0xCB, 0x67}, /* 0x98-0x9B */
	{0xCB, 0x68}, {0xCB, 0x69}, {0xCB, 0x6A}, {0xCB, 0x6B}, /* 0x9C-0x9F */
	{0xCB, 0x6C}, {0x33, 0x95}, {0x33, 0x96}, {0x33, 0x97}, /* 0xA0-0xA3 */
	{0x21, 0x13}, {0x33, 0x98}, {0x33, 0xC4}, {0x33, 0xA3}, /* 0xA4-0xA7 */
	{0x33, 0xA4}, {0x33, 0xA5}, {0x33, 0xA6}, {0x33, 0x99}, /* 0xA8-0xAB */
	{0x33, 0x9A}, {0x33, 0x9B}, {0x33, 0x9C}, {0x33, 0x9D}, /* 0xAC-0xAF */
	{0x33, 0x9E}, {0x33, 0x9F}, {0x33, 0xA0}, {0x33, 0xA1}, /* 0xB0-0xB3 */
	{0x33, 0xA2}, {0x33, 0xCA}, {0x33, 0x8D}, {0x33, 0x8E}, /* 0xB4-0xB7 */
	{0x33, 0x8F}, {0x33, 0xCF}, {0x33, 0x88}, {0x33, 0x89}, /* 0xB8-0xBB */
	{0x33, 0xC8}, {0x33, 0xA7}, {0x33, 0xA8}, {0x33, 0xB0}, /* 0xBC-0xBF */
	{0x33, 0xB1}, {0x33, 0xB2}, {0x33, 0xB3}, {0x33, 0xB4}, /* 0xC0-0xC3 */
	{0x33, 0xB5}, {0x33, 0xB6}, {0x33, 0xB7}, {0x33, 0xB8}, /* 0xC4-0xC7 */
	{0x33, 0xB9}, {0x33, 0x80}, {0x33, 0x81}, {0x33, 0x82}, /* 0xC8-0xCB */
	{0x33, 0x83}, {0x33, 0x84}, {0x33, 0xBA}, {0x33, 0xBB}, /* 0xCC-0xCF */
	{0x33, 0xBC}, {0x33, 0xBD}, {0x33, 0xBE}, {0x33, 0xBF}, /* 0xD0-0xD3 */
	{0x33, 0x90}, {0x33, 0x91}, {0x33, 0x92}, {0x33, 0x93}, /* 0xD4-0xD7 */
	{0x33, 0x94}, {0x21, 0x26}, {0x33, 0xC0}, {0x33, 0xC1}, /* 0xD8-0xDB */
	{0x33, 0x8A}, {0x33, 0x8B}, {0x33, 0x8C}, {0x33, 0xD6}, /* 0xDC-0xDF */
	{0x33, 0xC5}, {0x33, 0xAD}, {0x33, 0xAE}, {0x33, 0xAF}, /* 0xE0-0xE3 */
	{0x33, 0xDB}, {0x33, 0xA9}, {0x33, 0xAA}, {0x33, 0xAB}, /* 0xE4-0xE7 */
	{0x33, 0xAC}, {0x33, 0xDD}, {0x33, 0xD0}, {0x33, 0xD3}, /* 0xE8-0xEB */
	{0x33, 0xC3}, {0x33, 0xC9}, {0x33, 0xDC}, {0x33, 0xC6}, /* 0xEC-0xEF */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF0-0xF3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF4-0xF7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF8-0xFB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_A8[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xCB, 0x6D}, {0xCB, 0x6E}, {0xCB, 0x6F}, /* 0x40-0x43 */
	{0xCB, 0x70}, {0xCB, 0x71}, {0xCB, 0x72}, {0xCB, 0x73}, /* 0x44-0x47 */
	{0xCB, 0x74}, {0xCB, 0x75}, {0xCB, 0x76}, {0xCB, 0x77}, /* 0x48-0x4B */
	{0xCB, 0x7A}, {0xCB, 0x7B}, {0xCB, 0x7C}, {0xCB, 0x7D}, /* 0x4C-0x4F */
	{0xCB, 0x7E}, {0xCB, 0x7F}, {0xCB, 0x80}, {0xCB, 0x81}, /* 0x50-0x53 */
	{0xCB, 0x82}, {0xCB, 0x83}, {0xCB, 0x84}, {0xCB, 0x85}, /* 0x54-0x57 */
	{0xCB, 0x86}, {0xCB, 0x87}, {0xCB, 0x88}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xCB, 0x89}, {0xCB, 0x8A}, {0xCB, 0x8B}, /* 0x60-0x63 */
	{0xCB, 0x8C}, {0xCB, 0x8D}, {0xCB, 0x8E}, {0xCB, 0x8F}, /* 0x64-0x67 */
	{0xCB, 0x90}, {0xCB, 0x91}, {0xCB, 0x92}, {0xCB, 0x93}, /* 0x68-0x6B */
	{0xCB, 0x94}, {0xCB, 0x95}, {0xCB, 0x96}, {0xCB, 0x97}, /* 0x6C-0x6F */
	{0xCB, 0x98}, {0xCB, 0x99}, {0xCB, 0x9A}, {0xCB, 0x9B}, /* 0x70-0x73 */
	{0xCB, 0x9D}, {0xCB, 0x9E}, {0xCB, 0x9F}, {0xCB, 0xA0}, /* 0x74-0x77 */
	{0xCB, 0xA1}, {0xCB, 0xA2}, {0xCB, 0xA3}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xCB, 0xA4}, {0xCB, 0xA5}, {0xCB, 0xA6}, /* 0x80-0x83 */
	{0xCB, 0xA7}, {0xCB, 0xA8}, {0xCB, 0xA9}, {0xCB, 0xAA}, /* 0x84-0x87 */
	{0xCB, 0xAB}, {0xCB, 0xAC}, {0xCB, 0xAD}, {0xCB, 0xAE}, /* 0x88-0x8B */
	{0xCB, 0xAF}, {0xCB, 0xB0}, {0xCB, 0xB1}, {0xCB, 0xB2}, /* 0x8C-0x8F */
	{0xCB, 0xB3}, {0xCB, 0xB4}, {0xCB, 0xB5}, {0xCB, 0xB6}, /* 0x90-0x93 */
	{0xCB, 0xB7}, {0xCB, 0xB9}, {0xCB, 0xBA}, {0xCB, 0xBB}, /* 0x94-0x97 */
	{0xCB, 0xBC}, {0xCB, 0xBD}, {0xCB, 0xBE}, {0xCB, 0xBF}, /* 0x98-0x9B */
	{0xCB, 0xC0}, {0xCB, 0xC1}, {0xCB, 0xC2}, {0xCB, 0xC3}, /* 0x9C-0x9F */
	{0xCB, 0xC4}, {0x00, 0xC6}, {0x00, 0xD0}, {0x00, 0xAA}, /* 0xA0-0xA3 */
	{0x01, 0x26}, {0x00, 0x3F}, {0x01, 0x32}, {0x00, 0x3F}, /* 0xA4-0xA7 */
	{0x01, 0x3F}, {0x01, 0x41}, {0x00, 0xD8}, {0x01, 0x52}, /* 0xA8-0xAB */
	{0x00, 0xBA}, {0x00, 0xDE}, {0x01, 0x66}, {0x01, 0x4A}, /* 0xAC-0xAF */
	{0x00, 0x3F}, {0x32, 0x60}, {0x32, 0x61}, {0x32, 0x62}, /* 0xB0-0xB3 */
	{0x32, 0x63}, {0x32, 0x64}, {0x32, 0x65}, {0x32, 0x66}, /* 0xB4-0xB7 */
	{0x32, 0x67}, {0x32, 0x68}, {0x32, 0x69}, {0x32, 0x6A}, /* 0xB8-0xBB */
	{0x32, 0x6B}, {0x32, 0x6C}, {0x32, 0x6D}, {0x32, 0x6E}, /* 0xBC-0xBF */
	{0x32, 0x6F}, {0x32, 0x70}, {0x32, 0x71}, {0x32, 0x72}, /* 0xC0-0xC3 */
	{0x32, 0x73}, {0x32, 0x74}, {0x32, 0x75}, {0x32, 0x76}, /* 0xC4-0xC7 */
	{0x32, 0x77}, {0x32, 0x78}, {0x32, 0x79}, {0x32, 0x7A}, /* 0xC8-0xCB */
	{0x32, 0x7B}, {0x24, 0xD0}, {0x24, 0xD1}, {0x24, 0xD2}, /* 0xCC-0xCF */
	{0x24, 0xD3}, {0x24, 0xD4}, {0x24, 0xD5}, {0x24, 0xD6}, /* 0xD0-0xD3 */
	{0x24, 0xD7}, {0x24, 0xD8}, {0x24, 0xD9}, {0x24, 0xDA}, /* 0xD4-0xD7 */
	{0x24, 0xDB}, {0x24, 0xDC}, {0x24, 0xDD}, {0x24, 0xDE}, /* 0xD8-0xDB */
	{0x24, 0xDF}, {0x24, 0xE0}, {0x24, 0xE1}, {0x24, 0xE2}, /* 0xDC-0xDF */
	{0x24, 0xE3}, {0x24, 0xE4}, {0x24, 0xE5}, {0x24, 0xE6}, /* 0xE0-0xE3 */
	{0x24, 0xE7}, {0x24, 0xE8}, {0x24, 0xE9}, {0x24, 0x60}, /* 0xE4-0xE7 */
	{0x24, 0x61}, {0x24, 0x62}, {0x24, 0x63}, {0x24, 0x64}, /* 0xE8-0xEB */
	{0x24, 0x65}, {0x24, 0x66}, {0x24, 0x67}, {0x24, 0x68}, /* 0xEC-0xEF */
	{0x24, 0x69}, {0x24, 0x6A}, {0x24, 0x6B}, {0x24, 0x6C}, /* 0xF0-0xF3 */
	{0x24, 0x6D}, {0x24, 0x6E}, {0x00, 0xBD}, {0x21, 0x53}, /* 0xF4-0xF7 */
	{0x21, 0x54}, {0x00, 0xBC}, {0x00, 0xBE}, {0x21, 0x5B}, /* 0xF8-0xFB */
	{0x21, 0x5C}, {0x21, 0x5D}, {0x21, 0x5E}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_A9[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xCB, 0xC5}, {0xCB, 0xC6}, {0xCB, 0xC7}, /* 0x40-0x43 */
	{0xCB, 0xC8}, {0xCB, 0xC9}, {0xCB, 0xCA}, {0xCB, 0xCB}, /* 0x44-0x47 */
	{0xCB, 0xCC}, {0xCB, 0xCD}, {0xCB, 0xCE}, {0xCB, 0xCF}, /* 0x48-0x4B */
	{0xCB, 0xD0}, {0xCB, 0xD1}, {0xCB, 0xD2}, {0xCB, 0xD3}, /* 0x4C-0x4F */
	{0xCB, 0xD5}, {0xCB, 0xD6}, {0xCB, 0xD7}, {0xCB, 0xD8}, /* 0x50-0x53 */
	{0xCB, 0xD9}, {0xCB, 0xDA}, {0xCB, 0xDB}, {0xCB, 0xDC}, /* 0x54-0x57 */
	{0xCB, 0xDD}, {0xCB, 0xDE}, {0xCB, 0xDF}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xCB, 0xE0}, {0xCB, 0xE1}, {0xCB, 0xE2}, /* 0x60-0x63 */
	{0xCB, 0xE3}, {0xCB, 0xE5}, {0xCB, 0xE6}, {0xCB, 0xE8}, /* 0x64-0x67 */
	{0xCB, 0xEA}, {0xCB, 0xEB}, {0xCB, 0xEC}, {0xCB, 0xED}, /* 0x68-0x6B */
	{0xCB, 0xEE}, {0xCB, 0xEF}, {0xCB, 0xF0}, {0xCB, 0xF1}, /* 0x6C-0x6F */
	{0xCB, 0xF2}, {0xCB, 0xF3}, {0xCB, 0xF4}, {0xCB, 0xF5}, /* 0x70-0x73 */
	{0xCB, 0xF6}, {0xCB, 0xF7}, {0xCB, 0xF8}, {0xCB, 0xF9}, /* 0x74-0x77 */
	{0xCB, 0xFA}, {0xCB, 0xFB}, {0xCB, 0xFC}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xCB, 0xFD}, {0xCB, 0xFE}, {0xCB, 0xFF}, /* 0x80-0x83 */
	{0xCC, 0x00}, {0xCC, 0x01}, {0xCC, 0x02}, {0xCC, 0x03}, /* 0x84-0x87 */
	{0xCC, 0x04}, {0xCC, 0x05}, {0xCC, 0x06}, {0xCC, 0x07}, /* 0x88-0x8B */
	{0xCC, 0x08}, {0xCC, 0x09}, {0xCC, 0x0A}, {0xCC, 0x0B}, /* 0x8C-0x8F */
	{0xCC, 0x0E}, {0xCC, 0x0F}, {0xCC, 0x11}, {0xCC, 0x12}, /* 0x90-0x93 */
	{0xCC, 0x13}, {0xCC, 0x15}, {0xCC, 0x16}, {0xCC, 0x17}, /* 0x94-0x97 */
	{0xCC, 0x18}, {0xCC, 0x19}, {0xCC, 0x1A}, {0xCC, 0x1B}, /* 0x98-0x9B */
	{0xCC, 0x1E}, {0xCC, 0x1F}, {0xCC, 0x20}, {0xCC, 0x23}, /* 0x9C-0x9F */
	{0xCC, 0x24}, {0x00, 0xE6}, {0x01, 0x11}, {0x00, 0xF0}, /* 0xA0-0xA3 */
	{0x01, 0x27}, {0x01, 0x31}, {0x01, 0x33}, {0x01, 0x38}, /* 0xA4-0xA7 */
	{0x01, 0x40}, {0x01, 0x42}, {0x00, 0xF8}, {0x01, 0x53}, /* 0xA8-0xAB */
	{0x00, 0xDF}, {0x00, 0xFE}, {0x01, 0x67}, {0x01, 0x4B}, /* 0xAC-0xAF */
	{0x01, 0x49}, {0x32, 0x00}, {0x32, 0x01}, {0x32, 0x02}, /* 0xB0-0xB3 */
	{0x32, 0x03}, {0x32, 0x04}, {0x32, 0x05}, {0x32, 0x06}, /* 0xB4-0xB7 */
	{0x32, 0x07}, {0x32, 0x08}, {0x32, 0x09}, {0x32, 0x0A}, /* 0xB8-0xBB */
	{0x32, 0x0B}, {0x32, 0x0C}, {0x32, 0x0D}, {0x32, 0x0E}, /* 0xBC-0xBF */
	{0x32, 0x0F}, {0x32, 0x10}, {0x32, 0x11}, {0x32, 0x12}, /* 0xC0-0xC3 */
	{0x32, 0x13}, {0x32, 0x14}, {0x32, 0x15}, {0x32, 0x16}, /* 0xC4-0xC7 */
	{0x32, 0x17}, {0x32, 0x18}, {0x32, 0x19}, {0x32, 0x1A}, /* 0xC8-0xCB */
	{0x32, 0x1B}, {0x24, 0x9C}, {0x24, 0x9D}, {0x24, 0x9E}, /* 0xCC-0xCF */
	{0x24, 0x9F}, {0x24, 0xA0}, {0x24, 0xA1}, {0x24, 0xA2}, /* 0xD0-0xD3 */
	{0x24, 0xA3}, {0x24, 0xA4}, {0x24, 0xA5}, {0x24, 0xA6}, /* 0xD4-0xD7 */
	{0x24, 0xA7}, {0x24, 0xA8}, {0x24, 0xA9}, {0x24, 0xAA}, /* 0xD8-0xDB */
	{0x24, 0xAB}, {0x24, 0xAC}, {0x24, 0xAD}, {0x24, 0xAE}, /* 0xDC-0xDF */
	{0x24, 0xAF}, {0x24, 0xB0}, {0x24, 0xB1}, {0x24, 0xB2}, /* 0xE0-0xE3 */
	{0x24, 0xB3}, {0x24, 0xB4}, {0x24, 0xB5}, {0x24, 0x74}, /* 0xE4-0xE7 */
	{0x24, 0x75}, {0x24, 0x76}, {0x24, 0x77}, {0x24, 0x78}, /* 0xE8-0xEB */
	{0x24, 0x79}, {0x24, 0x7A}, {0x24, 0x7B}, {0x24, 0x7C}, /* 0xEC-0xEF */
	{0x24, 0x7D}, {0x24, 0x7E}, {0x24, 0x7F}, {0x24, 0x80}, /* 0xF0-0xF3 */
	{0x24, 0x81}, {0x24, 0x82}, {0x00, 0xB9}, {0x00, 0xB2}, /* 0xF4-0xF7 */
	{0x00, 0xB3}, {0x20, 0x74}, {0x20, 0x7F}, {0x20, 0x81}, /* 0xF8-0xFB */
	{0x20, 0x82}, {0x20, 0x83}, {0x20, 0x84}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_AA[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xCC, 0x25}, {0xCC, 0x26}, {0xCC, 0x2A}, /* 0x40-0x43 */
	{0xCC, 0x2B}, {0xCC, 0x2D}, {0xCC, 0x2F}, {0xCC, 0x31}, /* 0x44-0x47 */
	{0xCC, 0x32}, {0xCC, 0x33}, {0xCC, 0x34}, {0xCC, 0x35}, /* 0x48-0x4B */
	{0xCC, 0x36}, {0xCC, 0x37}, {0xCC, 0x3A}, {0xCC, 0x3F}, /* 0x4C-0x4F */
	{0xCC, 0x40}, {0xCC, 0x41}, {0xCC, 0x42}, {0xCC, 0x43}, /* 0x50-0x53 */
	{0xCC, 0x46}, {0xCC, 0x47}, {0xCC, 0x49}, {0xCC, 0x4A}, /* 0x54-0x57 */
	{0xCC, 0x4B}, {0xCC, 0x4D}, {0xCC, 0x4E}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xCC, 0x4F}, {0xCC, 0x50}, {0xCC, 0x51}, /* 0x60-0x63 */
	{0xCC, 0x52}, {0xCC, 0x53}, {0xCC, 0x56}, {0xCC, 0x5A}, /* 0x64-0x67 */
	{0xCC, 0x5B}, {0xCC, 0x5C}, {0xCC, 0x5D}, {0xCC, 0x5E}, /* 0x68-0x6B */
	{0xCC, 0x5F}, {0xCC, 0x61}, {0xCC, 0x62}, {0xCC, 0x63}, /* 0x6C-0x6F */
	{0xCC, 0x65}, {0xCC, 0x67}, {0xCC, 0x69}, {0xCC, 0x6A}, /* 0x70-0x73 */
	{0xCC, 0x6B}, {0xCC, 0x6C}, {0xCC, 0x6D}, {0xCC, 0x6E}, /* 0x74-0x77 */
	{0xCC, 0x6F}, {0xCC, 0x71}, {0xCC, 0x72}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xCC, 0x73}, {0xCC, 0x74}, {0xCC, 0x76}, /* 0x80-0x83 */
	{0xCC, 0x77}, {0xCC, 0x78}, {0xCC, 0x79}, {0xCC, 0x7A}, /* 0x84-0x87 */
	{0xCC, 0x7B}, {0xCC, 0x7C}, {0xCC, 0x7D}, {0xCC, 0x7E}, /* 0x88-0x8B */
	{0xCC, 0x7F}, {0xCC, 0x80}, {0xCC, 0x81}, {0xCC, 0x82}, /* 0x8C-0x8F */
	{0xCC, 0x83}, {0xCC, 0x84}, {0xCC, 0x85}, {0xCC, 0x86}, /* 0x90-0x93 */
	{0xCC, 0x87}, {0xCC, 0x88}, {0xCC, 0x89}, {0xCC, 0x8A}, /* 0x94-0x97 */
	{0xCC, 0x8B}, {0xCC, 0x8C}, {0xCC, 0x8D}, {0xCC, 0x8E}, /* 0x98-0x9B */
	{0xCC, 0x8F}, {0xCC, 0x90}, {0xCC, 0x91}, {0xCC, 0x92}, /* 0x9C-0x9F */
	{0xCC, 0x93}, {0x30, 0x41}, {0x30, 0x42}, {0x30, 0x43}, /* 0xA0-0xA3 */
	{0x30, 0x44}, {0x30, 0x45}, {0x30, 0x46}, {0x30, 0x47}, /* 0xA4-0xA7 */
	{0x30, 0x48}, {0x30, 0x49}, {0x30, 0x4A}, {0x30, 0x4B}, /* 0xA8-0xAB */
	{0x30, 0x4C}, {0x30, 0x4D}, {0x30, 0x4E}, {0x30, 0x4F}, /* 0xAC-0xAF */
	{0x30, 0x50}, {0x30, 0x51}, {0x30, 0x52}, {0x30, 0x53}, /* 0xB0-0xB3 */
	{0x30, 0x54}, {0x30, 0x55}, {0x30, 0x56}, {0x30, 0x57}, /* 0xB4-0xB7 */
	{0x30, 0x58}, {0x30, 0x59}, {0x30, 0x5A}, {0x30, 0x5B}, /* 0xB8-0xBB */
	{0x30, 0x5C}, {0x30, 0x5D}, {0x30, 0x5E}, {0x30, 0x5F}, /* 0xBC-0xBF */
	{0x30, 0x60}, {0x30, 0x61}, {0x30, 0x62}, {0x30, 0x63}, /* 0xC0-0xC3 */
	{0x30, 0x64}, {0x30, 0x65}, {0x30, 0x66}, {0x30, 0x67}, /* 0xC4-0xC7 */
	{0x30, 0x68}, {0x30, 0x69}, {0x30, 0x6A}, {0x30, 0x6B}, /* 0xC8-0xCB */
	{0x30, 0x6C}, {0x30, 0x6D}, {0x30, 0x6E}, {0x30, 0x6F}, /* 0xCC-0xCF */
	{0x30, 0x70}, {0x30, 0x71}, {0x30, 0x72}, {0x30, 0x73}, /* 0xD0-0xD3 */
	{0x30, 0x74}, {0x30, 0x75}, {0x30, 0x76}, {0x30, 0x77}, /* 0xD4-0xD7 */
	{0x30, 0x78}, {0x30, 0x79}, {0x30, 0x7A}, {0x30, 0x7B}, /* 0xD8-0xDB */
	{0x30, 0x7C}, {0x30, 0x7D}, {0x30, 0x7E}, {0x30, 0x7F}, /* 0xDC-0xDF */
	{0x30, 0x80}, {0x30, 0x81}, {0x30, 0x82}, {0x30, 0x83}, /* 0xE0-0xE3 */
	{0x30, 0x84}, {0x30, 0x85}, {0x30, 0x86}, {0x30, 0x87}, /* 0xE4-0xE7 */
	{0x30, 0x88}, {0x30, 0x89}, {0x30, 0x8A}, {0x30, 0x8B}, /* 0xE8-0xEB */
	{0x30, 0x8C}, {0x30, 0x8D}, {0x30, 0x8E}, {0x30, 0x8F}, /* 0xEC-0xEF */
	{0x30, 0x90}, {0x30, 0x91}, {0x30, 0x92}, {0x30, 0x93}, /* 0xF0-0xF3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF4-0xF7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF8-0xFB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_AB[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xCC, 0x94}, {0xCC, 0x95}, {0xCC, 0x96}, /* 0x40-0x43 */
	{0xCC, 0x97}, {0xCC, 0x9A}, {0xCC, 0x9B}, {0xCC, 0x9D}, /* 0x44-0x47 */
	{0xCC, 0x9E}, {0xCC, 0x9F}, {0xCC, 0xA1}, {0xCC, 0xA2}, /* 0x48-0x4B */
	{0xCC, 0xA3}, {0xCC, 0xA4}, {0xCC, 0xA5}, {0xCC, 0xA6}, /* 0x4C-0x4F */
	{0xCC, 0xA7}, {0xCC, 0xAA}, {0xCC, 0xAE}, {0xCC, 0xAF}, /* 0x50-0x53 */
	{0xCC, 0xB0}, {0xCC, 0xB1}, {0xCC, 0xB2}, {0xCC, 0xB3}, /* 0x54-0x57 */
	{0xCC, 0xB6}, {0xCC, 0xB7}, {0xCC, 0xB9}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xCC, 0xBA}, {0xCC, 0xBB}, {0xCC, 0xBD}, /* 0x60-0x63 */
	{0xCC, 0xBE}, {0xCC, 0xBF}, {0xCC, 0xC0}, {0xCC, 0xC1}, /* 0x64-0x67 */
	{0xCC, 0xC2}, {0xCC, 0xC3}, {0xCC, 0xC6}, {0xCC, 0xC8}, /* 0x68-0x6B */
	{0xCC, 0xCA}, {0xCC, 0xCB}, {0xCC, 0xCC}, {0xCC, 0xCD}, /* 0x6C-0x6F */
	{0xCC, 0xCE}, {0xCC, 0xCF}, {0xCC, 0xD1}, {0xCC, 0xD2}, /* 0x70-0x73 */
	{0xCC, 0xD3}, {0xCC, 0xD5}, {0xCC, 0xD6}, {0xCC, 0xD7}, /* 0x74-0x77 */
	{0xCC, 0xD8}, {0xCC, 0xD9}, {0xCC, 0xDA}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xCC, 0xDB}, {0xCC, 0xDC}, {0xCC, 0xDD}, /* 0x80-0x83 */
	{0xCC, 0xDE}, {0xCC, 0xDF}, {0xCC, 0xE0}, {0xCC, 0xE1}, /* 0x84-0x87 */
	{0xCC, 0xE2}, {0xCC, 0xE3}, {0xCC, 0xE5}, {0xCC, 0xE6}, /* 0x88-0x8B */
	{0xCC, 0xE7}, {0xCC, 0xE8}, {0xCC, 0xE9}, {0xCC, 0xEA}, /* 0x8C-0x8F */
	{0xCC, 0xEB}, {0xCC, 0xED}, {0xCC, 0xEE}, {0xCC, 0xEF}, /* 0x90-0x93 */
	{0xCC, 0xF1}, {0xCC, 0xF2}, {0xCC, 0xF3}, {0xCC, 0xF4}, /* 0x94-0x97 */
	{0xCC, 0xF5}, {0xCC, 0xF6}, {0xCC, 0xF7}, {0xCC, 0xF8}, /* 0x98-0x9B */
	{0xCC, 0xF9}, {0xCC, 0xFA}, {0xCC, 0xFB}, {0xCC, 0xFC}, /* 0x9C-0x9F */
	{0xCC, 0xFD}, {0x30, 0xA1}, {0x30, 0xA2}, {0x30, 0xA3}, /* 0xA0-0xA3 */
	{0x30, 0xA4}, {0x30, 0xA5}, {0x30, 0xA6}, {0x30, 0xA7}, /* 0xA4-0xA7 */
	{0x30, 0xA8}, {0x30, 0xA9}, {0x30, 0xAA}, {0x30, 0xAB}, /* 0xA8-0xAB */
	{0x30, 0xAC}, {0x30, 0xAD}, {0x30, 0xAE}, {0x30, 0xAF}, /* 0xAC-0xAF */
	{0x30, 0xB0}, {0x30, 0xB1}, {0x30, 0xB2}, {0x30, 0xB3}, /* 0xB0-0xB3 */
	{0x30, 0xB4}, {0x30, 0xB5}, {0x30, 0xB6}, {0x30, 0xB7}, /* 0xB4-0xB7 */
	{0x30, 0xB8}, {0x30, 0xB9}, {0x30, 0xBA}, {0x30, 0xBB}, /* 0xB8-0xBB */
	{0x30, 0xBC}, {0x30, 0xBD}, {0x30, 0xBE}, {0x30, 0xBF}, /* 0xBC-0xBF */
	{0x30, 0xC0}, {0x30, 0xC1}, {0x30, 0xC2}, {0x30, 0xC3}, /* 0xC0-0xC3 */
	{0x30, 0xC4}, {0x30, 0xC5}, {0x30, 0xC6}, {0x30, 0xC7}, /* 0xC4-0xC7 */
	{0x30, 0xC8}, {0x30, 0xC9}, {0x30, 0xCA}, {0x30, 0xCB}, /* 0xC8-0xCB */
	{0x30, 0xCC}, {0x30, 0xCD}, {0x30, 0xCE}, {0x30, 0xCF}, /* 0xCC-0xCF */
	{0x30, 0xD0}, {0x30, 0xD1}, {0x30, 0xD2}, {0x30, 0xD3}, /* 0xD0-0xD3 */
	{0x30, 0xD4}, {0x30, 0xD5}, {0x30, 0xD6}, {0x30, 0xD7}, /* 0xD4-0xD7 */
	{0x30, 0xD8}, {0x30, 0xD9}, {0x30, 0xDA}, {0x30, 0xDB}, /* 0xD8-0xDB */
	{0x30, 0xDC}, {0x30, 0xDD}, {0x30, 0xDE}, {0x30, 0xDF}, /* 0xDC-0xDF */
	{0x30, 0xE0}, {0x30, 0xE1}, {0x30, 0xE2}, {0x30, 0xE3}, /* 0xE0-0xE3 */
	{0x30, 0xE4}, {0x30, 0xE5}, {0x30, 0xE6}, {0x30, 0xE7}, /* 0xE4-0xE7 */
	{0x30, 0xE8}, {0x30, 0xE9}, {0x30, 0xEA}, {0x30, 0xEB}, /* 0xE8-0xEB */
	{0x30, 0xEC}, {0x30, 0xED}, {0x30, 0xEE}, {0x30, 0xEF}, /* 0xEC-0xEF */
	{0x30, 0xF0}, {0x30, 0xF1}, {0x30, 0xF2}, {0x30, 0xF3}, /* 0xF0-0xF3 */
	{0x30, 0xF4}, {0x30, 0xF5}, {0x30, 0xF6}, {0x00, 0x3F}, /* 0xF4-0xF7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF8-0xFB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_AC[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xCC, 0xFE}, {0xCC, 0xFF}, {0xCD, 0x00}, /* 0x40-0x43 */
	{0xCD, 0x02}, {0xCD, 0x03}, {0xCD, 0x04}, {0xCD, 0x05}, /* 0x44-0x47 */
	{0xCD, 0x06}, {0xCD, 0x07}, {0xCD, 0x0A}, {0xCD, 0x0B}, /* 0x48-0x4B */
	{0xCD, 0x0D}, {0xCD, 0x0E}, {0xCD, 0x0F}, {0xCD, 0x11}, /* 0x4C-0x4F */
	{0xCD, 0x12}, {0xCD, 0x13}, {0xCD, 0x14}, {0xCD, 0x15}, /* 0x50-0x53 */
	{0xCD, 0x16}, {0xCD, 0x17}, {0xCD, 0x1A}, {0xCD, 0x1C}, /* 0x54-0x57 */
	{0xCD, 0x1E}, {0xCD, 0x1F}, {0xCD, 0x20}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xCD, 0x21}, {0xCD, 0x22}, {0xCD, 0x23}, /* 0x60-0x63 */
	{0xCD, 0x25}, {0xCD, 0x26}, {0xCD, 0x27}, {0xCD, 0x29}, /* 0x64-0x67 */
	{0xCD, 0x2A}, {0xCD, 0x2B}, {0xCD, 0x2D}, {0xCD, 0x2E}, /* 0x68-0x6B */
	{0xCD, 0x2F}, {0xCD, 0x30}, {0xCD, 0x31}, {0xCD, 0x32}, /* 0x6C-0x6F */
	{0xCD, 0x33}, {0xCD, 0x34}, {0xCD, 0x35}, {0xCD, 0x36}, /* 0x70-0x73 */
	{0xCD, 0x37}, {0xCD, 0x38}, {0xCD, 0x3A}, {0xCD, 0x3B}, /* 0x74-0x77 */
	{0xCD, 0x3C}, {0xCD, 0x3D}, {0xCD, 0x3E}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xCD, 0x3F}, {0xCD, 0x40}, {0xCD, 0x41}, /* 0x80-0x83 */
	{0xCD, 0x42}, {0xCD, 0x43}, {0xCD, 0x44}, {0xCD, 0x45}, /* 0x84-0x87 */
	{0xCD, 0x46}, {0xCD, 0x47}, {0xCD, 0x48}, {0xCD, 0x49}, /* 0x88-0x8B */
	{0xCD, 0x4A}, {0xCD, 0x4B}, {0xCD, 0x4C}, {0xCD, 0x4D}, /* 0x8C-0x8F */
	{0xCD, 0x4E}, {0xCD, 0x4F}, {0xCD, 0x50}, {0xCD, 0x51}, /* 0x90-0x93 */
	{0xCD, 0x52}, {0xCD, 0x53}, {0xCD, 0x54}, {0xCD, 0x55}, /* 0x94-0x97 */
	{0xCD, 0x56}, {0xCD, 0x57}, {0xCD, 0x58}, {0xCD, 0x59}, /* 0x98-0x9B */
	{0xCD, 0x5A}, {0xCD, 0x5B}, {0xCD, 0x5D}, {0xCD, 0x5E}, /* 0x9C-0x9F */
	{0xCD, 0x5F}, {0x04, 0x10}, {0x04, 0x11}, {0x04, 0x12}, /* 0xA0-0xA3 */
	{0x04, 0x13}, {0x04, 0x14}, {0x04, 0x15}, {0x04, 0x01}, /* 0xA4-0xA7 */
	{0x04, 0x16}, {0x04, 0x17}, {0x04, 0x18}, {0x04, 0x19}, /* 0xA8-0xAB */
	{0x04, 0x1A}, {0x04, 0x1B}, {0x04, 0x1C}, {0x04, 0x1D}, /* 0xAC-0xAF */
	{0x04, 0x1E}, {0x04, 0x1F}, {0x04, 0x20}, {0x04, 0x21}, /* 0xB0-0xB3 */
	{0x04, 0x22}, {0x04, 0x23}, {0x04, 0x24}, {0x04, 0x25}, /* 0xB4-0xB7 */
	{0x04, 0x26}, {0x04, 0x27}, {0x04, 0x28}, {0x04, 0x29}, /* 0xB8-0xBB */
	{0x04, 0x2A}, {0x04, 0x2B}, {0x04, 0x2C}, {0x04, 0x2D}, /* 0xBC-0xBF */
	{0x04, 0x2E}, {0x04, 0x2F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xC0-0xC3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xC4-0xC7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xC8-0xCB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xCC-0xCF */
	{0x00, 0x3F}, {0x04, 0x30}, {0x04, 0x31}, {0x04, 0x32}, /* 0xD0-0xD3 */
	{0x04, 0x33}, {0x04, 0x34}, {0x04, 0x35}, {0x04, 0x51}, /* 0xD4-0xD7 */
	{0x04, 0x36}, {0x04, 0x37}, {0x04, 0x38}, {0x04, 0x39}, /* 0xD8-0xDB */
	{0x04, 0x3A}, {0x04, 0x3B}, {0x04, 0x3C}, {0x04, 0x3D}, /* 0xDC-0xDF */
	{0x04, 0x3E}, {0x04, 0x3F}, {0x04, 0x40}, {0x04, 0x41}, /* 0xE0-0xE3 */
	{0x04, 0x42}, {0x04, 0x43}, {0x04, 0x44}, {0x04, 0x45}, /* 0xE4-0xE7 */
	{0x04, 0x46}, {0x04, 0x47}, {0x04, 0x48}, {0x04, 0x49}, /* 0xE8-0xEB */
	{0x04, 0x4A}, {0x04, 0x4B}, {0x04, 0x4C}, {0x04, 0x4D}, /* 0xEC-0xEF */
	{0x04, 0x4E}, {0x04, 0x4F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF0-0xF3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF4-0xF7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF8-0xFB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_AD[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xCD, 0x61}, {0xCD, 0x62}, {0xCD, 0x63}, /* 0x40-0x43 */
	{0xCD, 0x65}, {0xCD, 0x66}, {0xCD, 0x67}, {0xCD, 0x68}, /* 0x44-0x47 */
	{0xCD, 0x69}, {0xCD, 0x6A}, {0xCD, 0x6B}, {0xCD, 0x6E}, /* 0x48-0x4B */
	{0xCD, 0x70}, {0xCD, 0x72}, {0xCD, 0x73}, {0xCD, 0x74}, /* 0x4C-0x4F */
	{0xCD, 0x75}, {0xCD, 0x76}, {0xCD, 0x77}, {0xCD, 0x79}, /* 0x50-0x53 */
	{0xCD, 0x7A}, {0xCD, 0x7B}, {0xCD, 0x7C}, {0xCD, 0x7D}, /* 0x54-0x57 */
	{0xCD, 0x7E}, {0xCD, 0x7F}, {0xCD, 0x80}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xCD, 0x81}, {0xCD, 0x82}, {0xCD, 0x83}, /* 0x60-0x63 */
	{0xCD, 0x84}, {0xCD, 0x85}, {0xCD, 0x86}, {0xCD, 0x87}, /* 0x64-0x67 */
	{0xCD, 0x89}, {0xCD, 0x8A}, {0xCD, 0x8B}, {0xCD, 0x8C}, /* 0x68-0x6B */
	{0xCD, 0x8D}, {0xCD, 0x8E}, {0xCD, 0x8F}, {0xCD, 0x90}, /* 0x6C-0x6F */
	{0xCD, 0x91}, {0xCD, 0x92}, {0xCD, 0x93}, {0xCD, 0x96}, /* 0x70-0x73 */
	{0xCD, 0x97}, {0xCD, 0x99}, {0xCD, 0x9A}, {0xCD, 0x9B}, /* 0x74-0x77 */
	{0xCD, 0x9D}, {0xCD, 0x9E}, {0xCD, 0x9F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xCD, 0xA0}, {0xCD, 0xA1}, {0xCD, 0xA2}, /* 0x80-0x83 */
	{0xCD, 0xA3}, {0xCD, 0xA6}, {0xCD, 0xA8}, {0xCD, 0xAA}, /* 0x84-0x87 */
	{0xCD, 0xAB}, {0xCD, 0xAC}, {0xCD, 0xAD}, {0xCD, 0xAE}, /* 0x88-0x8B */
	{0xCD, 0xAF}, {0xCD, 0xB1}, {0xCD, 0xB2}, {0xCD, 0xB3}, /* 0x8C-0x8F */
	{0xCD, 0xB4}, {0xCD, 0xB5}, {0xCD, 0xB6}, {0xCD, 0xB7}, /* 0x90-0x93 */
	{0xCD, 0xB8}, {0xCD, 0xB9}, {0xCD, 0xBA}, {0xCD, 0xBB}, /* 0x94-0x97 */
	{0xCD, 0xBC}, {0xCD, 0xBD}, {0xCD, 0xBE}, {0xCD, 0xBF}, /* 0x98-0x9B */
	{0xCD, 0xC0}, {0xCD, 0xC1}, {0xCD, 0xC2}, {0xCD, 0xC3}, /* 0x9C-0x9F */
	{0xCD, 0xC5}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xA0-0xA3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xA4-0xA7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xA8-0xAB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xAC-0xAF */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xB0-0xB3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xB4-0xB7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xB8-0xBB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xBC-0xBF */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xC0-0xC3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xC4-0xC7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xC8-0xCB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xCC-0xCF */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xD0-0xD3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xD4-0xD7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xD8-0xDB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xDC-0xDF */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xE0-0xE3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xE4-0xE7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xE8-0xEB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xEC-0xEF */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF0-0xF3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF4-0xF7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF8-0xFB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_AE[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xCD, 0xC6}, {0xCD, 0xC7}, {0xCD, 0xC8}, /* 0x40-0x43 */
	{0xCD, 0xC9}, {0xCD, 0xCA}, {0xCD, 0xCB}, {0xCD, 0xCD}, /* 0x44-0x47 */
	{0xCD, 0xCE}, {0xCD, 0xCF}, {0xCD, 0xD1}, {0xCD, 0xD2}, /* 0x48-0x4B */
	{0xCD, 0xD3}, {0xCD, 0xD4}, {0xCD, 0xD5}, {0xCD, 0xD6}, /* 0x4C-0x4F */
	{0xCD, 0xD7}, {0xCD, 0xD8}, {0xCD, 0xD9}, {0xCD, 0xDA}, /* 0x50-0x53 */
	{0xCD, 0xDB}, {0xCD, 0xDC}, {0xCD, 0xDD}, {0xCD, 0xDE}, /* 0x54-0x57 */
	{0xCD, 0xDF}, {0xCD, 0xE0}, {0xCD, 0xE1}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xCD, 0xE2}, {0xCD, 0xE3}, {0xCD, 0xE4}, /* 0x60-0x63 */
	{0xCD, 0xE5}, {0xCD, 0xE6}, {0xCD, 0xE7}, {0xCD, 0xE9}, /* 0x64-0x67 */
	{0xCD, 0xEA}, {0xCD, 0xEB}, {0xCD, 0xED}, {0xCD, 0xEE}, /* 0x68-0x6B */
	{0xCD, 0xEF}, {0xCD, 0xF1}, {0xCD, 0xF2}, {0xCD, 0xF3}, /* 0x6C-0x6F */
	{0xCD, 0xF4}, {0xCD, 0xF5}, {0xCD, 0xF6}, {0xCD, 0xF7}, /* 0x70-0x73 */
	{0xCD, 0xFA}, {0xCD, 0xFC}, {0xCD, 0xFE}, {0xCD, 0xFF}, /* 0x74-0x77 */
	{0xCE, 0x00}, {0xCE, 0x01}, {0xCE, 0x02}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xCE, 0x03}, {0xCE, 0x05}, {0xCE, 0x06}, /* 0x80-0x83 */
	{0xCE, 0x07}, {0xCE, 0x09}, {0xCE, 0x0A}, {0xCE, 0x0B}, /* 0x84-0x87 */
	{0xCE, 0x0D}, {0xCE, 0x0E}, {0xCE, 0x0F}, {0xCE, 0x10}, /* 0x88-0x8B */
	{0xCE, 0x11}, {0xCE, 0x12}, {0xCE, 0x13}, {0xCE, 0x15}, /* 0x8C-0x8F */
	{0xCE, 0x16}, {0xCE, 0x17}, {0xCE, 0x18}, {0xCE, 0x1A}, /* 0x90-0x93 */
	{0xCE, 0x1B}, {0xCE, 0x1C}, {0xCE, 0x1D}, {0xCE, 0x1E}, /* 0x94-0x97 */
	{0xCE, 0x1F}, {0xCE, 0x22}, {0xCE, 0x23}, {0xCE, 0x25}, /* 0x98-0x9B */
	{0xCE, 0x26}, {0xCE, 0x27}, {0xCE, 0x29}, {0xCE, 0x2A}, /* 0x9C-0x9F */
	{0xCE, 0x2B}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xA0-0xA3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xA4-0xA7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xA8-0xAB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xAC-0xAF */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xB0-0xB3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xB4-0xB7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xB8-0xBB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xBC-0xBF */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xC0-0xC3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xC4-0xC7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xC8-0xCB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xCC-0xCF */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xD0-0xD3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xD4-0xD7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xD8-0xDB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xDC-0xDF */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xE0-0xE3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xE4-0xE7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xE8-0xEB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xEC-0xEF */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF0-0xF3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF4-0xF7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF8-0xFB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_AF[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xCE, 0x2C}, {0xCE, 0x2D}, {0xCE, 0x2E}, /* 0x40-0x43 */
	{0xCE, 0x2F}, {0xCE, 0x32}, {0xCE, 0x34}, {0xCE, 0x36}, /* 0x44-0x47 */
	{0xCE, 0x37}, {0xCE, 0x38}, {0xCE, 0x39}, {0xCE, 0x3A}, /* 0x48-0x4B */
	{0xCE, 0x3B}, {0xCE, 0x3C}, {0xCE, 0x3D}, {0xCE, 0x3E}, /* 0x4C-0x4F */
	{0xCE, 0x3F}, {0xCE, 0x40}, {0xCE, 0x41}, {0xCE, 0x42}, /* 0x50-0x53 */
	{0xCE, 0x43}, {0xCE, 0x44}, {0xCE, 0x45}, {0xCE, 0x46}, /* 0x54-0x57 */
	{0xCE, 0x47}, {0xCE, 0x48}, {0xCE, 0x49}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xCE, 0x4A}, {0xCE, 0x4B}, {0xCE, 0x4C}, /* 0x60-0x63 */
	{0xCE, 0x4D}, {0xCE, 0x4E}, {0xCE, 0x4F}, {0xCE, 0x50}, /* 0x64-0x67 */
	{0xCE, 0x51}, {0xCE, 0x52}, {0xCE, 0x53}, {0xCE, 0x54}, /* 0x68-0x6B */
	{0xCE, 0x55}, {0xCE, 0x56}, {0xCE, 0x57}, {0xCE, 0x5A}, /* 0x6C-0x6F */
	{0xCE, 0x5B}, {0xCE, 0x5D}, {0xCE, 0x5E}, {0xCE, 0x62}, /* 0x70-0x73 */
	{0xCE, 0x63}, {0xCE, 0x64}, {0xCE, 0x65}, {0xCE, 0x66}, /* 0x74-0x77 */
	{0xCE, 0x67}, {0xCE, 0x6A}, {0xCE, 0x6C}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xCE, 0x6E}, {0xCE, 0x6F}, {0xCE, 0x70}, /* 0x80-0x83 */
	{0xCE, 0x71}, {0xCE, 0x72}, {0xCE, 0x73}, {0xCE, 0x76}, /* 0x84-0x87 */
	{0xCE, 0x77}, {0xCE, 0x79}, {0xCE, 0x7A}, {0xCE, 0x7B}, /* 0x88-0x8B */
	{0xCE, 0x7D}, {0xCE, 0x7E}, {0xCE, 0x7F}, {0xCE, 0x80}, /* 0x8C-0x8F */
	{0xCE, 0x81}, {0xCE, 0x82}, {0xCE, 0x83}, {0xCE, 0x86}, /* 0x90-0x93 */
	{0xCE, 0x88}, {0xCE, 0x8A}, {0xCE, 0x8B}, {0xCE, 0x8C}, /* 0x94-0x97 */
	{0xCE, 0x8D}, {0xCE, 0x8E}, {0xCE, 0x8F}, {0xCE, 0x92}, /* 0x98-0x9B */
	{0xCE, 0x93}, {0xCE, 0x95}, {0xCE, 0x96}, {0xCE, 0x97}, /* 0x9C-0x9F */
	{0xCE, 0x99}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xA0-0xA3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xA4-0xA7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xA8-0xAB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xAC-0xAF */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xB0-0xB3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xB4-0xB7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xB8-0xBB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xBC-0xBF */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xC0-0xC3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xC4-0xC7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xC8-0xCB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xCC-0xCF */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xD0-0xD3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xD4-0xD7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xD8-0xDB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xDC-0xDF */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xE0-0xE3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xE4-0xE7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xE8-0xEB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xEC-0xEF */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF0-0xF3 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF4-0xF7 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xF8-0xFB */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_B0[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xCE, 0x9A}, {0xCE, 0x9B}, {0xCE, 0x9C}, /* 0x40-0x43 */
	{0xCE, 0x9D}, {0xCE, 0x9E}, {0xCE, 0x9F}, {0xCE, 0xA2}, /* 0x44-0x47 */
	{0xCE, 0xA6}, {0xCE, 0xA7}, {0xCE, 0xA8}, {0xCE, 0xA9}, /* 0x48-0x4B */
	{0xCE, 0xAA}, {0xCE, 0xAB}, {0xCE, 0xAE}, {0xCE, 0xAF}, /* 0x4C-0x4F */
	{0xCE, 0xB0}, {0xCE, 0xB1}, {0xCE, 0xB2}, {0xCE, 0xB3}, /* 0x50-0x53 */
	{0xCE, 0xB4}, {0xCE, 0xB5}, {0xCE, 0xB6}, {0xCE, 0xB7}, /* 0x54-0x57 */
	{0xCE, 0xB8}, {0xCE, 0xB9}, {0xCE, 0xBA}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xCE, 0xBB}, {0xCE, 0xBC}, {0xCE, 0xBD}, /* 0x60-0x63 */
	{0xCE, 0xBE}, {0xCE, 0xBF}, {0xCE, 0xC0}, {0xCE, 0xC2}, /* 0x64-0x67 */
	{0xCE, 0xC3}, {0xCE, 0xC4}, {0xCE, 0xC5}, {0xCE, 0xC6}, /* 0x68-0x6B */
	{0xCE, 0xC7}, {0xCE, 0xC8}, {0xCE, 0xC9}, {0xCE, 0xCA}, /* 0x6C-0x6F */
	{0xCE, 0xCB}, {0xCE, 0xCC}, {0xCE, 0xCD}, {0xCE, 0xCE}, /* 0x70-0x73 */
	{0xCE, 0xCF}, {0xCE, 0xD0}, {0xCE, 0xD1}, {0xCE, 0xD2}, /* 0x74-0x77 */
	{0xCE, 0xD3}, {0xCE, 0xD4}, {0xCE, 0xD5}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xCE, 0xD6}, {0xCE, 0xD7}, {0xCE, 0xD8}, /* 0x80-0x83 */
	{0xCE, 0xD9}, {0xCE, 0xDA}, {0xCE, 0xDB}, {0xCE, 0xDC}, /* 0x84-0x87 */
	{0xCE, 0xDD}, {0xCE, 0xDE}, {0xCE, 0xDF}, {0xCE, 0xE0}, /* 0x88-0x8B */
	{0xCE, 0xE1}, {0xCE, 0xE2}, {0xCE, 0xE3}, {0xCE, 0xE6}, /* 0x8C-0x8F */
	{0xCE, 0xE7}, {0xCE, 0xE9}, {0xCE, 0xEA}, {0xCE, 0xED}, /* 0x90-0x93 */
	{0xCE, 0xEE}, {0xCE, 0xEF}, {0xCE, 0xF0}, {0xCE, 0xF1}, /* 0x94-0x97 */
	{0xCE, 0xF2}, {0xCE, 0xF3}, {0xCE, 0xF6}, {0xCE, 0xFA}, /* 0x98-0x9B */
	{0xCE, 0xFB}, {0xCE, 0xFC}, {0xCE, 0xFD}, {0xCE, 0xFE}, /* 0x9C-0x9F */
	{0xCE, 0xFF}, {0xAC, 0x00}, {0xAC, 0x01}, {0xAC, 0x04}, /* 0xA0-0xA3 */
	{0xAC, 0x07}, {0xAC, 0x08}, {0xAC, 0x09}, {0xAC, 0x0A}, /* 0xA4-0xA7 */
	{0xAC, 0x10}, {0xAC, 0x11}, {0xAC, 0x12}, {0xAC, 0x13}, /* 0xA8-0xAB */
	{0xAC, 0x14}, {0xAC, 0x15}, {0xAC, 0x16}, {0xAC, 0x17}, /* 0xAC-0xAF */
	{0xAC, 0x19}, {0xAC, 0x1A}, {0xAC, 0x1B}, {0xAC, 0x1C}, /* 0xB0-0xB3 */
	{0xAC, 0x1D}, {0xAC, 0x20}, {0xAC, 0x24}, {0xAC, 0x2C}, /* 0xB4-0xB7 */
	{0xAC, 0x2D}, {0xAC, 0x2F}, {0xAC, 0x30}, {0xAC, 0x31}, /* 0xB8-0xBB */
	{0xAC, 0x38}, {0xAC, 0x39}, {0xAC, 0x3C}, {0xAC, 0x40}, /* 0xBC-0xBF */
	{0xAC, 0x4B}, {0xAC, 0x4D}, {0xAC, 0x54}, {0xAC, 0x58}, /* 0xC0-0xC3 */
	{0xAC, 0x5C}, {0xAC, 0x70}, {0xAC, 0x71}, {0xAC, 0x74}, /* 0xC4-0xC7 */
	{0xAC, 0x77}, {0xAC, 0x78}, {0xAC, 0x7A}, {0xAC, 0x80}, /* 0xC8-0xCB */
	{0xAC, 0x81}, {0xAC, 0x83}, {0xAC, 0x84}, {0xAC, 0x85}, /* 0xCC-0xCF */
	{0xAC, 0x86}, {0xAC, 0x89}, {0xAC, 0x8A}, {0xAC, 0x8B}, /* 0xD0-0xD3 */
	{0xAC, 0x8C}, {0xAC, 0x90}, {0xAC, 0x94}, {0xAC, 0x9C}, /* 0xD4-0xD7 */
	{0xAC, 0x9D}, {0xAC, 0x9F}, {0xAC, 0xA0}, {0xAC, 0xA1}, /* 0xD8-0xDB */
	{0xAC, 0xA8}, {0xAC, 0xA9}, {0xAC, 0xAA}, {0xAC, 0xAC}, /* 0xDC-0xDF */
	{0xAC, 0xAF}, {0xAC, 0xB0}, {0xAC, 0xB8}, {0xAC, 0xB9}, /* 0xE0-0xE3 */
	{0xAC, 0xBB}, {0xAC, 0xBC}, {0xAC, 0xBD}, {0xAC, 0xC1}, /* 0xE4-0xE7 */
	{0xAC, 0xC4}, {0xAC, 0xC8}, {0xAC, 0xCC}, {0xAC, 0xD5}, /* 0xE8-0xEB */
	{0xAC, 0xD7}, {0xAC, 0xE0}, {0xAC, 0xE1}, {0xAC, 0xE4}, /* 0xEC-0xEF */
	{0xAC, 0xE7}, {0xAC, 0xE8}, {0xAC, 0xEA}, {0xAC, 0xEC}, /* 0xF0-0xF3 */
	{0xAC, 0xEF}, {0xAC, 0xF0}, {0xAC, 0xF1}, {0xAC, 0xF3}, /* 0xF4-0xF7 */
	{0xAC, 0xF5}, {0xAC, 0xF6}, {0xAC, 0xFC}, {0xAC, 0xFD}, /* 0xF8-0xFB */
	{0xAD, 0x00}, {0xAD, 0x04}, {0xAD, 0x06}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_B1[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xCF, 0x02}, {0xCF, 0x03}, {0xCF, 0x05}, /* 0x40-0x43 */
	{0xCF, 0x06}, {0xCF, 0x07}, {0xCF, 0x09}, {0xCF, 0x0A}, /* 0x44-0x47 */
	{0xCF, 0x0B}, {0xCF, 0x0C}, {0xCF, 0x0D}, {0xCF, 0x0E}, /* 0x48-0x4B */
	{0xCF, 0x0F}, {0xCF, 0x12}, {0xCF, 0x14}, {0xCF, 0x16}, /* 0x4C-0x4F */
	{0xCF, 0x17}, {0xCF, 0x18}, {0xCF, 0x19}, {0xCF, 0x1A}, /* 0x50-0x53 */
	{0xCF, 0x1B}, {0xCF, 0x1D}, {0xCF, 0x1E}, {0xCF, 0x1F}, /* 0x54-0x57 */
	{0xCF, 0x21}, {0xCF, 0x22}, {0xCF, 0x23}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xCF, 0x25}, {0xCF, 0x26}, {0xCF, 0x27}, /* 0x60-0x63 */
	{0xCF, 0x28}, {0xCF, 0x29}, {0xCF, 0x2A}, {0xCF, 0x2B}, /* 0x64-0x67 */
	{0xCF, 0x2E}, {0xCF, 0x32}, {0xCF, 0x33}, {0xCF, 0x34}, /* 0x68-0x6B */
	{0xCF, 0x35}, {0xCF, 0x36}, {0xCF, 0x37}, {0xCF, 0x39}, /* 0x6C-0x6F */
	{0xCF, 0x3A}, {0xCF, 0x3B}, {0xCF, 0x3C}, {0xCF, 0x3D}, /* 0x70-0x73 */
	{0xCF, 0x3E}, {0xCF, 0x3F}, {0xCF, 0x40}, {0xCF, 0x41}, /* 0x74-0x77 */
	{0xCF, 0x42}, {0xCF, 0x43}, {0xCF, 0x44}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xCF, 0x45}, {0xCF, 0x46}, {0xCF, 0x47}, /* 0x80-0x83 */
	{0xCF, 0x48}, {0xCF, 0x49}, {0xCF, 0x4A}, {0xCF, 0x4B}, /* 0x84-0x87 */
	{0xCF, 0x4C}, {0xCF, 0x4D}, {0xCF, 0x4E}, {0xCF, 0x4F}, /* 0x88-0x8B */
	{0xCF, 0x50}, {0xCF, 0x51}, {0xCF, 0x52}, {0xCF, 0x53}, /* 0x8C-0x8F */
	{0xCF, 0x56}, {0xCF, 0x57}, {0xCF, 0x59}, {0xCF, 0x5A}, /* 0x90-0x93 */
	{0xCF, 0x5B}, {0xCF, 0x5D}, {0xCF, 0x5E}, {0xCF, 0x5F}, /* 0x94-0x97 */
	{0xCF, 0x60}, {0xCF, 0x61}, {0xCF, 0x62}, {0xCF, 0x63}, /* 0x98-0x9B */
	{0xCF, 0x66}, {0xCF, 0x68}, {0xCF, 0x6A}, {0xCF, 0x6B}, /* 0x9C-0x9F */
	{0xCF, 0x6C}, {0xAD, 0x0C}, {0xAD, 0x0D}, {0xAD, 0x0F}, /* 0xA0-0xA3 */
	{0xAD, 0x11}, {0xAD, 0x18}, {0xAD, 0x1C}, {0xAD, 0x20}, /* 0xA4-0xA7 */
	{0xAD, 0x29}, {0xAD, 0x2C}, {0xAD, 0x2D}, {0xAD, 0x34}, /* 0xA8-0xAB */
	{0xAD, 0x35}, {0xAD, 0x38}, {0xAD, 0x3C}, {0xAD, 0x44}, /* 0xAC-0xAF */
	{0xAD, 0x45}, {0xAD, 0x47}, {0xAD, 0x49}, {0xAD, 0x50}, /* 0xB0-0xB3 */
	{0xAD, 0x54}, {0xAD, 0x58}, {0xAD, 0x61}, {0xAD, 0x63}, /* 0xB4-0xB7 */
	{0xAD, 0x6C}, {0xAD, 0x6D}, {0xAD, 0x70}, {0xAD, 0x73}, /* 0xB8-0xBB */
	{0xAD, 0x74}, {0xAD, 0x75}, {0xAD, 0x76}, {0xAD, 0x7B}, /* 0xBC-0xBF */
	{0xAD, 0x7C}, {0xAD, 0x7D}, {0xAD, 0x7F}, {0xAD, 0x81}, /* 0xC0-0xC3 */
	{0xAD, 0x82}, {0xAD, 0x88}, {0xAD, 0x89}, {0xAD, 0x8C}, /* 0xC4-0xC7 */
	{0xAD, 0x90}, {0xAD, 0x9C}, {0xAD, 0x9D}, {0xAD, 0xA4}, /* 0xC8-0xCB */
	{0xAD, 0xB7}, {0xAD, 0xC0}, {0xAD, 0xC1}, {0xAD, 0xC4}, /* 0xCC-0xCF */
	{0xAD, 0xC8}, {0xAD, 0xD0}, {0xAD, 0xD1}, {0xAD, 0xD3}, /* 0xD0-0xD3 */
	{0xAD, 0xDC}, {0xAD, 0xE0}, {0xAD, 0xE4}, {0xAD, 0xF8}, /* 0xD4-0xD7 */
	{0xAD, 0xF9}, {0xAD, 0xFC}, {0xAD, 0xFF}, {0xAE, 0x00}, /* 0xD8-0xDB */
	{0xAE, 0x01}, {0xAE, 0x08}, {0xAE, 0x09}, {0xAE, 0x0B}, /* 0xDC-0xDF */
	{0xAE, 0x0D}, {0xAE, 0x14}, {0xAE, 0x30}, {0xAE, 0x31}, /* 0xE0-0xE3 */
	{0xAE, 0x34}, {0xAE, 0x37}, {0xAE, 0x38}, {0xAE, 0x3A}, /* 0xE4-0xE7 */
	{0xAE, 0x40}, {0xAE, 0x41}, {0xAE, 0x43}, {0xAE, 0x45}, /* 0xE8-0xEB */
	{0xAE, 0x46}, {0xAE, 0x4A}, {0xAE, 0x4C}, {0xAE, 0x4D}, /* 0xEC-0xEF */
	{0xAE, 0x4E}, {0xAE, 0x50}, {0xAE, 0x54}, {0xAE, 0x56}, /* 0xF0-0xF3 */
	{0xAE, 0x5C}, {0xAE, 0x5D}, {0xAE, 0x5F}, {0xAE, 0x60}, /* 0xF4-0xF7 */
	{0xAE, 0x61}, {0xAE, 0x65}, {0xAE, 0x68}, {0xAE, 0x69}, /* 0xF8-0xFB */
	{0xAE, 0x6C}, {0xAE, 0x70}, {0xAE, 0x78}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_B2[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xCF, 0x6D}, {0xCF, 0x6E}, {0xCF, 0x6F}, /* 0x40-0x43 */
	{0xCF, 0x72}, {0xCF, 0x73}, {0xCF, 0x75}, {0xCF, 0x76}, /* 0x44-0x47 */
	{0xCF, 0x77}, {0xCF, 0x79}, {0xCF, 0x7A}, {0xCF, 0x7B}, /* 0x48-0x4B */
	{0xCF, 0x7C}, {0xCF, 0x7D}, {0xCF, 0x7E}, {0xCF, 0x7F}, /* 0x4C-0x4F */
	{0xCF, 0x81}, {0xCF, 0x82}, {0xCF, 0x83}, {0xCF, 0x84}, /* 0x50-0x53 */
	{0xCF, 0x86}, {0xCF, 0x87}, {0xCF, 0x88}, {0xCF, 0x89}, /* 0x54-0x57 */
	{0xCF, 0x8A}, {0xCF, 0x8B}, {0xCF, 0x8D}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xCF, 0x8E}, {0xCF, 0x8F}, {0xCF, 0x90}, /* 0x60-0x63 */
	{0xCF, 0x91}, {0xCF, 0x92}, {0xCF, 0x93}, {0xCF, 0x94}, /* 0x64-0x67 */
	{0xCF, 0x95}, {0xCF, 0x96}, {0xCF, 0x97}, {0xCF, 0x98}, /* 0x68-0x6B */
	{0xCF, 0x99}, {0xCF, 0x9A}, {0xCF, 0x9B}, {0xCF, 0x9C}, /* 0x6C-0x6F */
	{0xCF, 0x9D}, {0xCF, 0x9E}, {0xCF, 0x9F}, {0xCF, 0xA0}, /* 0x70-0x73 */
	{0xCF, 0xA2}, {0xCF, 0xA3}, {0xCF, 0xA4}, {0xCF, 0xA5}, /* 0x74-0x77 */
	{0xCF, 0xA6}, {0xCF, 0xA7}, {0xCF, 0xA9}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xCF, 0xAA}, {0xCF, 0xAB}, {0xCF, 0xAC}, /* 0x80-0x83 */
	{0xCF, 0xAD}, {0xCF, 0xAE}, {0xCF, 0xAF}, {0xCF, 0xB1}, /* 0x84-0x87 */
	{0xCF, 0xB2}, {0xCF, 0xB3}, {0xCF, 0xB4}, {0xCF, 0xB5}, /* 0x88-0x8B */
	{0xCF, 0xB6}, {0xCF, 0xB7}, {0xCF, 0xB8}, {0xCF, 0xB9}, /* 0x8C-0x8F */
	{0xCF, 0xBA}, {0xCF, 0xBB}, {0xCF, 0xBC}, {0xCF, 0xBD}, /* 0x90-0x93 */
	{0xCF, 0xBE}, {0xCF, 0xBF}, {0xCF, 0xC0}, {0xCF, 0xC1}, /* 0x94-0x97 */
	{0xCF, 0xC2}, {0xCF, 0xC3}, {0xCF, 0xC5}, {0xCF, 0xC6}, /* 0x98-0x9B */
	{0xCF, 0xC7}, {0xCF, 0xC8}, {0xCF, 0xC9}, {0xCF, 0xCA}, /* 0x9C-0x9F */
	{0xCF, 0xCB}, {0xAE, 0x79}, {0xAE, 0x7B}, {0xAE, 0x7C}, /* 0xA0-0xA3 */
	{0xAE, 0x7D}, {0xAE, 0x84}, {0xAE, 0x85}, {0xAE, 0x8C}, /* 0xA4-0xA7 */
	{0xAE, 0xBC}, {0xAE, 0xBD}, {0xAE, 0xBE}, {0xAE, 0xC0}, /* 0xA8-0xAB */
	{0xAE, 0xC4}, {0xAE, 0xCC}, {0xAE, 0xCD}, {0xAE, 0xCF}, /* 0xAC-0xAF */
	{0xAE, 0xD0}, {0xAE, 0xD1}, {0xAE, 0xD8}, {0xAE, 0xD9}, /* 0xB0-0xB3 */
	{0xAE, 0xDC}, {0xAE, 0xE8}, {0xAE, 0xEB}, {0xAE, 0xED}, /* 0xB4-0xB7 */
	{0xAE, 0xF4}, {0xAE, 0xF8}, {0xAE, 0xFC}, {0xAF, 0x07}, /* 0xB8-0xBB */
	{0xAF, 0x08}, {0xAF, 0x0D}, {0xAF, 0x10}, {0xAF, 0x2C}, /* 0xBC-0xBF */
	{0xAF, 0x2D}, {0xAF, 0x30}, {0xAF, 0x32}, {0xAF, 0x34}, /* 0xC0-0xC3 */
	{0xAF, 0x3C}, {0xAF, 0x3D}, {0xAF, 0x3F}, {0xAF, 0x41}, /* 0xC4-0xC7 */
	{0xAF, 0x42}, {0xAF, 0x43}, {0xAF, 0x48}, {0xAF, 0x49}, /* 0xC8-0xCB */
	{0xAF, 0x50}, {0xAF, 0x5C}, {0xAF, 0x5D}, {0xAF, 0x64}, /* 0xCC-0xCF */
	{0xAF, 0x65}, {0xAF, 0x79}, {0xAF, 0x80}, {0xAF, 0x84}, /* 0xD0-0xD3 */
	{0xAF, 0x88}, {0xAF, 0x90}, {0xAF, 0x91}, {0xAF, 0x95}, /* 0xD4-0xD7 */
	{0xAF, 0x9C}, {0xAF, 0xB8}, {0xAF, 0xB9}, {0xAF, 0xBC}, /* 0xD8-0xDB */
	{0xAF, 0xC0}, {0xAF, 0xC7}, {0xAF, 0xC8}, {0xAF, 0xC9}, /* 0xDC-0xDF */
	{0xAF, 0xCB}, {0xAF, 0xCD}, {0xAF, 0xCE}, {0xAF, 0xD4}, /* 0xE0-0xE3 */
	{0xAF, 0xDC}, {0xAF, 0xE8}, {0xAF, 0xE9}, {0xAF, 0xF0}, /* 0xE4-0xE7 */
	{0xAF, 0xF1}, {0xAF, 0xF4}, {0xAF, 0xF8}, {0xB0, 0x00}, /* 0xE8-0xEB */
	{0xB0, 0x01}, {0xB0, 0x04}, {0xB0, 0x0C}, {0xB0, 0x10}, /* 0xEC-0xEF */
	{0xB0, 0x14}, {0xB0, 0x1C}, {0xB0, 0x1D}, {0xB0, 0x28}, /* 0xF0-0xF3 */
	{0xB0, 0x44}, {0xB0, 0x45}, {0xB0, 0x48}, {0xB0, 0x4A}, /* 0xF4-0xF7 */
	{0xB0, 0x4C}, {0xB0, 0x4E}, {0xB0, 0x53}, {0xB0, 0x54}, /* 0xF8-0xFB */
	{0xB0, 0x55}, {0xB0, 0x57}, {0xB0, 0x59}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_B3[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xCF, 0xCC}, {0xCF, 0xCD}, {0xCF, 0xCE}, /* 0x40-0x43 */
	{0xCF, 0xCF}, {0xCF, 0xD0}, {0xCF, 0xD1}, {0xCF, 0xD2}, /* 0x44-0x47 */
	{0xCF, 0xD3}, {0xCF, 0xD4}, {0xCF, 0xD5}, {0xCF, 0xD6}, /* 0x48-0x4B */
	{0xCF, 0xD7}, {0xCF, 0xD8}, {0xCF, 0xD9}, {0xCF, 0xDA}, /* 0x4C-0x4F */
	{0xCF, 0xDB}, {0xCF, 0xDC}, {0xCF, 0xDD}, {0xCF, 0xDE}, /* 0x50-0x53 */
	{0xCF, 0xDF}, {0xCF, 0xE2}, {0xCF, 0xE3}, {0xCF, 0xE5}, /* 0x54-0x57 */
	{0xCF, 0xE6}, {0xCF, 0xE7}, {0xCF, 0xE9}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xCF, 0xEA}, {0xCF, 0xEB}, {0xCF, 0xEC}, /* 0x60-0x63 */
	{0xCF, 0xED}, {0xCF, 0xEE}, {0xCF, 0xEF}, {0xCF, 0xF2}, /* 0x64-0x67 */
	{0xCF, 0xF4}, {0xCF, 0xF6}, {0xCF, 0xF7}, {0xCF, 0xF8}, /* 0x68-0x6B */
	{0xCF, 0xF9}, {0xCF, 0xFA}, {0xCF, 0xFB}, {0xCF, 0xFD}, /* 0x6C-0x6F */
	{0xCF, 0xFE}, {0xCF, 0xFF}, {0xD0, 0x01}, {0xD0, 0x02}, /* 0x70-0x73 */
	{0xD0, 0x03}, {0xD0, 0x05}, {0xD0, 0x06}, {0xD0, 0x07}, /* 0x74-0x77 */
	{0xD0, 0x08}, {0xD0, 0x09}, {0xD0, 0x0A}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD0, 0x0B}, {0xD0, 0x0C}, {0xD0, 0x0D}, /* 0x80-0x83 */
	{0xD0, 0x0E}, {0xD0, 0x0F}, {0xD0, 0x10}, {0xD0, 0x12}, /* 0x84-0x87 */
	{0xD0, 0x13}, {0xD0, 0x14}, {0xD0, 0x15}, {0xD0, 0x16}, /* 0x88-0x8B */
	{0xD0, 0x17}, {0xD0, 0x19}, {0xD0, 0x1A}, {0xD0, 0x1B}, /* 0x8C-0x8F */
	{0xD0, 0x1C}, {0xD0, 0x1D}, {0xD0, 0x1E}, {0xD0, 0x1F}, /* 0x90-0x93 */
	{0xD0, 0x20}, {0xD0, 0x21}, {0xD0, 0x22}, {0xD0, 0x23}, /* 0x94-0x97 */
	{0xD0, 0x24}, {0xD0, 0x25}, {0xD0, 0x26}, {0xD0, 0x27}, /* 0x98-0x9B */
	{0xD0, 0x28}, {0xD0, 0x29}, {0xD0, 0x2A}, {0xD0, 0x2B}, /* 0x9C-0x9F */
	{0xD0, 0x2C}, {0xB0, 0x5D}, {0xB0, 0x7C}, {0xB0, 0x7D}, /* 0xA0-0xA3 */
	{0xB0, 0x80}, {0xB0, 0x84}, {0xB0, 0x8C}, {0xB0, 0x8D}, /* 0xA4-0xA7 */
	{0xB0, 0x8F}, {0xB0, 0x91}, {0xB0, 0x98}, {0xB0, 0x99}, /* 0xA8-0xAB */
	{0xB0, 0x9A}, {0xB0, 0x9C}, {0xB0, 0x9F}, {0xB0, 0xA0}, /* 0xAC-0xAF */
	{0xB0, 0xA1}, {0xB0, 0xA2}, {0xB0, 0xA8}, {0xB0, 0xA9}, /* 0xB0-0xB3 */
	{0xB0, 0xAB}, {0xB0, 0xAC}, {0xB0, 0xAD}, {0xB0, 0xAE}, /* 0xB4-0xB7 */
	{0xB0, 0xAF}, {0xB0, 0xB1}, {0xB0, 0xB3}, {0xB0, 0xB4}, /* 0xB8-0xBB */
	{0xB0, 0xB5}, {0xB0, 0xB8}, {0xB0, 0xBC}, {0xB0, 0xC4}, /* 0xBC-0xBF */
	{0xB0, 0xC5}, {0xB0, 0xC7}, {0xB0, 0xC8}, {0xB0, 0xC9}, /* 0xC0-0xC3 */
	{0xB0, 0xD0}, {0xB0, 0xD1}, {0xB0, 0xD4}, {0xB0, 0xD8}, /* 0xC4-0xC7 */
	{0xB0, 0xE0}, {0xB0, 0xE5}, {0xB1, 0x08}, {0xB1, 0x09}, /* 0xC8-0xCB */
	{0xB1, 0x0B}, {0xB1, 0x0C}, {0xB1, 0x10}, {0xB1, 0x12}, /* 0xCC-0xCF */
	{0xB1, 0x13}, {0xB1, 0x18}, {0xB1, 0x19}, {0xB1, 0x1B}, /* 0xD0-0xD3 */
	{0xB1, 0x1C}, {0xB1, 0x1D}, {0xB1, 0x23}, {0xB1, 0x24}, /* 0xD4-0xD7 */
	{0xB1, 0x25}, {0xB1, 0x28}, {0xB1, 0x2C}, {0xB1, 0x34}, /* 0xD8-0xDB */
	{0xB1, 0x35}, {0xB1, 0x37}, {0xB1, 0x38}, {0xB1, 0x39}, /* 0xDC-0xDF */
	{0xB1, 0x40}, {0xB1, 0x41}, {0xB1, 0x44}, {0xB1, 0x48}, /* 0xE0-0xE3 */
	{0xB1, 0x50}, {0xB1, 0x51}, {0xB1, 0x54}, {0xB1, 0x55}, /* 0xE4-0xE7 */
	{0xB1, 0x58}, {0xB1, 0x5C}, {0xB1, 0x60}, {0xB1, 0x78}, /* 0xE8-0xEB */
	{0xB1, 0x79}, {0xB1, 0x7C}, {0xB1, 0x80}, {0xB1, 0x82}, /* 0xEC-0xEF */
	{0xB1, 0x88}, {0xB1, 0x89}, {0xB1, 0x8B}, {0xB1, 0x8D}, /* 0xF0-0xF3 */
	{0xB1, 0x92}, {0xB1, 0x93}, {0xB1, 0x94}, {0xB1, 0x98}, /* 0xF4-0xF7 */
	{0xB1, 0x9C}, {0xB1, 0xA8}, {0xB1, 0xCC}, {0xB1, 0xD0}, /* 0xF8-0xFB */
	{0xB1, 0xD4}, {0xB1, 0xDC}, {0xB1, 0xDD}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_B4[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD0, 0x2E}, {0xD0, 0x2F}, {0xD0, 0x30}, /* 0x40-0x43 */
	{0xD0, 0x31}, {0xD0, 0x32}, {0xD0, 0x33}, {0xD0, 0x36}, /* 0x44-0x47 */
	{0xD0, 0x37}, {0xD0, 0x39}, {0xD0, 0x3A}, {0xD0, 0x3B}, /* 0x48-0x4B */
	{0xD0, 0x3D}, {0xD0, 0x3E}, {0xD0, 0x3F}, {0xD0, 0x40}, /* 0x4C-0x4F */
	{0xD0, 0x41}, {0xD0, 0x42}, {0xD0, 0x43}, {0xD0, 0x46}, /* 0x50-0x53 */
	{0xD0, 0x48}, {0xD0, 0x4A}, {0xD0, 0x4B}, {0xD0, 0x4C}, /* 0x54-0x57 */
	{0xD0, 0x4D}, {0xD0, 0x4E}, {0xD0, 0x4F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xD0, 0x51}, {0xD0, 0x52}, {0xD0, 0x53}, /* 0x60-0x63 */
	{0xD0, 0x55}, {0xD0, 0x56}, {0xD0, 0x57}, {0xD0, 0x59}, /* 0x64-0x67 */
	{0xD0, 0x5A}, {0xD0, 0x5B}, {0xD0, 0x5C}, {0xD0, 0x5D}, /* 0x68-0x6B */
	{0xD0, 0x5E}, {0xD0, 0x5F}, {0xD0, 0x61}, {0xD0, 0x62}, /* 0x6C-0x6F */
	{0xD0, 0x63}, {0xD0, 0x64}, {0xD0, 0x65}, {0xD0, 0x66}, /* 0x70-0x73 */
	{0xD0, 0x67}, {0xD0, 0x68}, {0xD0, 0x69}, {0xD0, 0x6A}, /* 0x74-0x77 */
	{0xD0, 0x6B}, {0xD0, 0x6E}, {0xD0, 0x6F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD0, 0x71}, {0xD0, 0x72}, {0xD0, 0x73}, /* 0x80-0x83 */
	{0xD0, 0x75}, {0xD0, 0x76}, {0xD0, 0x77}, {0xD0, 0x78}, /* 0x84-0x87 */
	{0xD0, 0x79}, {0xD0, 0x7A}, {0xD0, 0x7B}, {0xD0, 0x7E}, /* 0x88-0x8B */
	{0xD0, 0x7F}, {0xD0, 0x80}, {0xD0, 0x82}, {0xD0, 0x83}, /* 0x8C-0x8F */
	{0xD0, 0x84}, {0xD0, 0x85}, {0xD0, 0x86}, {0xD0, 0x87}, /* 0x90-0x93 */
	{0xD0, 0x88}, {0xD0, 0x89}, {0xD0, 0x8A}, {0xD0, 0x8B}, /* 0x94-0x97 */
	{0xD0, 0x8C}, {0xD0, 0x8D}, {0xD0, 0x8E}, {0xD0, 0x8F}, /* 0x98-0x9B */
	{0xD0, 0x90}, {0xD0, 0x91}, {0xD0, 0x92}, {0xD0, 0x93}, /* 0x9C-0x9F */
	{0xD0, 0x94}, {0xB1, 0xDF}, {0xB1, 0xE8}, {0xB1, 0xE9}, /* 0xA0-0xA3 */
	{0xB1, 0xEC}, {0xB1, 0xF0}, {0xB1, 0xF9}, {0xB1, 0xFB}, /* 0xA4-0xA7 */
	{0xB1, 0xFD}, {0xB2, 0x04}, {0xB2, 0x05}, {0xB2, 0x08}, /* 0xA8-0xAB */
	{0xB2, 0x0B}, {0xB2, 0x0C}, {0xB2, 0x14}, {0xB2, 0x15}, /* 0xAC-0xAF */
	{0xB2, 0x17}, {0xB2, 0x19}, {0xB2, 0x20}, {0xB2, 0x34}, /* 0xB0-0xB3 */
	{0xB2, 0x3C}, {0xB2, 0x58}, {0xB2, 0x5C}, {0xB2, 0x60}, /* 0xB4-0xB7 */
	{0xB2, 0x68}, {0xB2, 0x69}, {0xB2, 0x74}, {0xB2, 0x75}, /* 0xB8-0xBB */
	{0xB2, 0x7C}, {0xB2, 0x84}, {0xB2, 0x85}, {0xB2, 0x89}, /* 0xBC-0xBF */
	{0xB2, 0x90}, {0xB2, 0x91}, {0xB2, 0x94}, {0xB2, 0x98}, /* 0xC0-0xC3 */
	{0xB2, 0x99}, {0xB2, 0x9A}, {0xB2, 0xA0}, {0xB2, 0xA1}, /* 0xC4-0xC7 */
	{0xB2, 0xA3}, {0xB2, 0xA5}, {0xB2, 0xA6}, {0xB2, 0xAA}, /* 0xC8-0xCB */
	{0xB2, 0xAC}, {0xB2, 0xB0}, {0xB2, 0xB4}, {0xB2, 0xC8}, /* 0xCC-0xCF */
	{0xB2, 0xC9}, {0xB2, 0xCC}, {0xB2, 0xD0}, {0xB2, 0xD2}, /* 0xD0-0xD3 */
	{0xB2, 0xD8}, {0xB2, 0xD9}, {0xB2, 0xDB}, {0xB2, 0xDD}, /* 0xD4-0xD7 */
	{0xB2, 0xE2}, {0xB2, 0xE4}, {0xB2, 0xE5}, {0xB2, 0xE6}, /* 0xD8-0xDB */
	{0xB2, 0xE8}, {0xB2, 0xEB}, {0xB2, 0xEC}, {0xB2, 0xED}, /* 0xDC-0xDF */
	{0xB2, 0xEE}, {0xB2, 0xEF}, {0xB2, 0xF3}, {0xB2, 0xF4}, /* 0xE0-0xE3 */
	{0xB2, 0xF5}, {0xB2, 0xF7}, {0xB2, 0xF8}, {0xB2, 0xF9}, /* 0xE4-0xE7 */
	{0xB2, 0xFA}, {0xB2, 0xFB}, {0xB2, 0xFF}, {0xB3, 0x00}, /* 0xE8-0xEB */
	{0xB3, 0x01}, {0xB3, 0x04}, {0xB3, 0x08}, {0xB3, 0x10}, /* 0xEC-0xEF */
	{0xB3, 0x11}, {0xB3, 0x13}, {0xB3, 0x14}, {0xB3, 0x15}, /* 0xF0-0xF3 */
	{0xB3, 0x1C}, {0xB3, 0x54}, {0xB3, 0x55}, {0xB3, 0x56}, /* 0xF4-0xF7 */
	{0xB3, 0x58}, {0xB3, 0x5B}, {0xB3, 0x5C}, {0xB3, 0x5E}, /* 0xF8-0xFB */
	{0xB3, 0x5F}, {0xB3, 0x64}, {0xB3, 0x65}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_B5[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD0, 0x95}, {0xD0, 0x96}, {0xD0, 0x97}, /* 0x40-0x43 */
	{0xD0, 0x98}, {0xD0, 0x99}, {0xD0, 0x9A}, {0xD0, 0x9B}, /* 0x44-0x47 */
	{0xD0, 0x9C}, {0xD0, 0x9D}, {0xD0, 0x9E}, {0xD0, 0x9F}, /* 0x48-0x4B */
	{0xD0, 0xA0}, {0xD0, 0xA1}, {0xD0, 0xA2}, {0xD0, 0xA3}, /* 0x4C-0x4F */
	{0xD0, 0xA6}, {0xD0, 0xA7}, {0xD0, 0xA9}, {0xD0, 0xAA}, /* 0x50-0x53 */
	{0xD0, 0xAB}, {0xD0, 0xAD}, {0xD0, 0xAE}, {0xD0, 0xAF}, /* 0x54-0x57 */
	{0xD0, 0xB0}, {0xD0, 0xB1}, {0xD0, 0xB2}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xD0, 0xB3}, {0xD0, 0xB6}, {0xD0, 0xB8}, /* 0x60-0x63 */
	{0xD0, 0xBA}, {0xD0, 0xBB}, {0xD0, 0xBC}, {0xD0, 0xBD}, /* 0x64-0x67 */
	{0xD0, 0xBE}, {0xD0, 0xBF}, {0xD0, 0xC2}, {0xD0, 0xC3}, /* 0x68-0x6B */
	{0xD0, 0xC5}, {0xD0, 0xC6}, {0xD0, 0xC7}, {0xD0, 0xCA}, /* 0x6C-0x6F */
	{0xD0, 0xCB}, {0xD0, 0xCC}, {0xD0, 0xCD}, {0xD0, 0xCE}, /* 0x70-0x73 */
	{0xD0, 0xCF}, {0xD0, 0xD2}, {0xD0, 0xD6}, {0xD0, 0xD7}, /* 0x74-0x77 */
	{0xD0, 0xD8}, {0xD0, 0xD9}, {0xD0, 0xDA}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD0, 0xDB}, {0xD0, 0xDE}, {0xD0, 0xDF}, /* 0x80-0x83 */
	{0xD0, 0xE1}, {0xD0, 0xE2}, {0xD0, 0xE3}, {0xD0, 0xE5}, /* 0x84-0x87 */
	{0xD0, 0xE6}, {0xD0, 0xE7}, {0xD0, 0xE8}, {0xD0, 0xE9}, /* 0x88-0x8B */
	{0xD0, 0xEA}, {0xD0, 0xEB}, {0xD0, 0xEE}, {0xD0, 0xF2}, /* 0x8C-0x8F */
	{0xD0, 0xF3}, {0xD0, 0xF4}, {0xD0, 0xF5}, {0xD0, 0xF6}, /* 0x90-0x93 */
	{0xD0, 0xF7}, {0xD0, 0xF9}, {0xD0, 0xFA}, {0xD0, 0xFB}, /* 0x94-0x97 */
	{0xD0, 0xFC}, {0xD0, 0xFD}, {0xD0, 0xFE}, {0xD0, 0xFF}, /* 0x98-0x9B */
	{0xD1, 0x00}, {0xD1, 0x01}, {0xD1, 0x02}, {0xD1, 0x03}, /* 0x9C-0x9F */
	{0xD1, 0x04}, {0xB3, 0x67}, {0xB3, 0x69}, {0xB3, 0x6B}, /* 0xA0-0xA3 */
	{0xB3, 0x6E}, {0xB3, 0x70}, {0xB3, 0x71}, {0xB3, 0x74}, /* 0xA4-0xA7 */
	{0xB3, 0x78}, {0xB3, 0x80}, {0xB3, 0x81}, {0xB3, 0x83}, /* 0xA8-0xAB */
	{0xB3, 0x84}, {0xB3, 0x85}, {0xB3, 0x8C}, {0xB3, 0x90}, /* 0xAC-0xAF */
	{0xB3, 0x94}, {0xB3, 0xA0}, {0xB3, 0xA1}, {0xB3, 0xA8}, /* 0xB0-0xB3 */
	{0xB3, 0xAC}, {0xB3, 0xC4}, {0xB3, 0xC5}, {0xB3, 0xC8}, /* 0xB4-0xB7 */
	{0xB3, 0xCB}, {0xB3, 0xCC}, {0xB3, 0xCE}, {0xB3, 0xD0}, /* 0xB8-0xBB */
	{0xB3, 0xD4}, {0xB3, 0xD5}, {0xB3, 0xD7}, {0xB3, 0xD9}, /* 0xBC-0xBF */
	{0xB3, 0xDB}, {0xB3, 0xDD}, {0xB3, 0xE0}, {0xB3, 0xE4}, /* 0xC0-0xC3 */
	{0xB3, 0xE8}, {0xB3, 0xFC}, {0xB4, 0x10}, {0xB4, 0x18}, /* 0xC4-0xC7 */
	{0xB4, 0x1C}, {0xB4, 0x20}, {0xB4, 0x28}, {0xB4, 0x29}, /* 0xC8-0xCB */
	{0xB4, 0x2B}, {0xB4, 0x34}, {0xB4, 0x50}, {0xB4, 0x51}, /* 0xCC-0xCF */
	{0xB4, 0x54}, {0xB4, 0x58}, {0xB4, 0x60}, {0xB4, 0x61}, /* 0xD0-0xD3 */
	{0xB4, 0x63}, {0xB4, 0x65}, {0xB4, 0x6C}, {0xB4, 0x80}, /* 0xD4-0xD7 */
	{0xB4, 0x88}, {0xB4, 0x9D}, {0xB4, 0xA4}, {0xB4, 0xA8}, /* 0xD8-0xDB */
	{0xB4, 0xAC}, {0xB4, 0xB5}, {0xB4, 0xB7}, {0xB4, 0xB9}, /* 0xDC-0xDF */
	{0xB4, 0xC0}, {0xB4, 0xC4}, {0xB4, 0xC8}, {0xB4, 0xD0}, /* 0xE0-0xE3 */
	{0xB4, 0xD5}, {0xB4, 0xDC}, {0xB4, 0xDD}, {0xB4, 0xE0}, /* 0xE4-0xE7 */
	{0xB4, 0xE3}, {0xB4, 0xE4}, {0xB4, 0xE6}, {0xB4, 0xEC}, /* 0xE8-0xEB */
	{0xB4, 0xED}, {0xB4, 0xEF}, {0xB4, 0xF1}, {0xB4, 0xF8}, /* 0xEC-0xEF */
	{0xB5, 0x14}, {0xB5, 0x15}, {0xB5, 0x18}, {0xB5, 0x1B}, /* 0xF0-0xF3 */
	{0xB5, 0x1C}, {0xB5, 0x24}, {0xB5, 0x25}, {0xB5, 0x27}, /* 0xF4-0xF7 */
	{0xB5, 0x28}, {0xB5, 0x29}, {0xB5, 0x2A}, {0xB5, 0x30}, /* 0xF8-0xFB */
	{0xB5, 0x31}, {0xB5, 0x34}, {0xB5, 0x38}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_B6[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD1, 0x05}, {0xD1, 0x06}, {0xD1, 0x07}, /* 0x40-0x43 */
	{0xD1, 0x08}, {0xD1, 0x09}, {0xD1, 0x0A}, {0xD1, 0x0B}, /* 0x44-0x47 */
	{0xD1, 0x0C}, {0xD1, 0x0E}, {0xD1, 0x0F}, {0xD1, 0x10}, /* 0x48-0x4B */
	{0xD1, 0x11}, {0xD1, 0x12}, {0xD1, 0x13}, {0xD1, 0x14}, /* 0x4C-0x4F */
	{0xD1, 0x15}, {0xD1, 0x16}, {0xD1, 0x17}, {0xD1, 0x18}, /* 0x50-0x53 */
	{0xD1, 0x19}, {0xD1, 0x1A}, {0xD1, 0x1B}, {0xD1, 0x1C}, /* 0x54-0x57 */
	{0xD1, 0x1D}, {0xD1, 0x1E}, {0xD1, 0x1F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xD1, 0x20}, {0xD1, 0x21}, {0xD1, 0x22}, /* 0x60-0x63 */
	{0xD1, 0x23}, {0xD1, 0x24}, {0xD1, 0x25}, {0xD1, 0x26}, /* 0x64-0x67 */
	{0xD1, 0x27}, {0xD1, 0x28}, {0xD1, 0x29}, {0xD1, 0x2A}, /* 0x68-0x6B */
	{0xD1, 0x2B}, {0xD1, 0x2C}, {0xD1, 0x2D}, {0xD1, 0x2E}, /* 0x6C-0x6F */
	{0xD1, 0x2F}, {0xD1, 0x32}, {0xD1, 0x33}, {0xD1, 0x35}, /* 0x70-0x73 */
	{0xD1, 0x36}, {0xD1, 0x37}, {0xD1, 0x39}, {0xD1, 0x3B}, /* 0x74-0x77 */
	{0xD1, 0x3C}, {0xD1, 0x3D}, {0xD1, 0x3E}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD1, 0x3F}, {0xD1, 0x42}, {0xD1, 0x46}, /* 0x80-0x83 */
	{0xD1, 0x47}, {0xD1, 0x48}, {0xD1, 0x49}, {0xD1, 0x4A}, /* 0x84-0x87 */
	{0xD1, 0x4B}, {0xD1, 0x4E}, {0xD1, 0x4F}, {0xD1, 0x51}, /* 0x88-0x8B */
	{0xD1, 0x52}, {0xD1, 0x53}, {0xD1, 0x55}, {0xD1, 0x56}, /* 0x8C-0x8F */
	{0xD1, 0x57}, {0xD1, 0x58}, {0xD1, 0x59}, {0xD1, 0x5A}, /* 0x90-0x93 */
	{0xD1, 0x5B}, {0xD1, 0x5E}, {0xD1, 0x60}, {0xD1, 0x62}, /* 0x94-0x97 */
	{0xD1, 0x63}, {0xD1, 0x64}, {0xD1, 0x65}, {0xD1, 0x66}, /* 0x98-0x9B */
	{0xD1, 0x67}, {0xD1, 0x69}, {0xD1, 0x6A}, {0xD1, 0x6B}, /* 0x9C-0x9F */
	{0xD1, 0x6D}, {0xB5, 0x40}, {0xB5, 0x41}, {0xB5, 0x43}, /* 0xA0-0xA3 */
	{0xB5, 0x44}, {0xB5, 0x45}, {0xB5, 0x4B}, {0xB5, 0x4C}, /* 0xA4-0xA7 */
	{0xB5, 0x4D}, {0xB5, 0x50}, {0xB5, 0x54}, {0xB5, 0x5C}, /* 0xA8-0xAB */
	{0xB5, 0x5D}, {0xB5, 0x5F}, {0xB5, 0x60}, {0xB5, 0x61}, /* 0xAC-0xAF */
	{0xB5, 0xA0}, {0xB5, 0xA1}, {0xB5, 0xA4}, {0xB5, 0xA8}, /* 0xB0-0xB3 */
	{0xB5, 0xAA}, {0xB5, 0xAB}, {0xB5, 0xB0}, {0xB5, 0xB1}, /* 0xB4-0xB7 */
	{0xB5, 0xB3}, {0xB5, 0xB4}, {0xB5, 0xB5}, {0xB5, 0xBB}, /* 0xB8-0xBB */
	{0xB5, 0xBC}, {0xB5, 0xBD}, {0xB5, 0xC0}, {0xB5, 0xC4}, /* 0xBC-0xBF */
	{0xB5, 0xCC}, {0xB5, 0xCD}, {0xB5, 0xCF}, {0xB5, 0xD0}, /* 0xC0-0xC3 */
	{0xB5, 0xD1}, {0xB5, 0xD8}, {0xB5, 0xEC}, {0xB6, 0x10}, /* 0xC4-0xC7 */
	{0xB6, 0x11}, {0xB6, 0x14}, {0xB6, 0x18}, {0xB6, 0x25}, /* 0xC8-0xCB */
	{0xB6, 0x2C}, {0xB6, 0x34}, {0xB6, 0x48}, {0xB6, 0x64}, /* 0xCC-0xCF */
	{0xB6, 0x68}, {0xB6, 0x9C}, {0xB6, 0x9D}, {0xB6, 0xA0}, /* 0xD0-0xD3 */
	{0xB6, 0xA4}, {0xB6, 0xAB}, {0xB6, 0xAC}, {0xB6, 0xB1}, /* 0xD4-0xD7 */
	{0xB6, 0xD4}, {0xB6, 0xF0}, {0xB6, 0xF4}, {0xB6, 0xF8}, /* 0xD8-0xDB */
	{0xB7, 0x00}, {0xB7, 0x01}, {0xB7, 0x05}, {0xB7, 0x28}, /* 0xDC-0xDF */
	{0xB7, 0x29}, {0xB7, 0x2C}, {0xB7, 0x2F}, {0xB7, 0x30}, /* 0xE0-0xE3 */
	{0xB7, 0x38}, {0xB7, 0x39}, {0xB7, 0x3B}, {0xB7, 0x44}, /* 0xE4-0xE7 */
	{0xB7, 0x48}, {0xB7, 0x4C}, {0xB7, 0x54}, {0xB7, 0x55}, /* 0xE8-0xEB */
	{0xB7, 0x60}, {0xB7, 0x64}, {0xB7, 0x68}, {0xB7, 0x70}, /* 0xEC-0xEF */
	{0xB7, 0x71}, {0xB7, 0x73}, {0xB7, 0x75}, {0xB7, 0x7C}, /* 0xF0-0xF3 */
	{0xB7, 0x7D}, {0xB7, 0x80}, {0xB7, 0x84}, {0xB7, 0x8C}, /* 0xF4-0xF7 */
	{0xB7, 0x8D}, {0xB7, 0x8F}, {0xB7, 0x90}, {0xB7, 0x91}, /* 0xF8-0xFB */
	{0xB7, 0x92}, {0xB7, 0x96}, {0xB7, 0x97}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_B7[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD1, 0x6E}, {0xD1, 0x6F}, {0xD1, 0x70}, /* 0x40-0x43 */
	{0xD1, 0x71}, {0xD1, 0x72}, {0xD1, 0x73}, {0xD1, 0x74}, /* 0x44-0x47 */
	{0xD1, 0x75}, {0xD1, 0x76}, {0xD1, 0x77}, {0xD1, 0x78}, /* 0x48-0x4B */
	{0xD1, 0x79}, {0xD1, 0x7A}, {0xD1, 0x7B}, {0xD1, 0x7D}, /* 0x4C-0x4F */
	{0xD1, 0x7E}, {0xD1, 0x7F}, {0xD1, 0x80}, {0xD1, 0x81}, /* 0x50-0x53 */
	{0xD1, 0x82}, {0xD1, 0x83}, {0xD1, 0x85}, {0xD1, 0x86}, /* 0x54-0x57 */
	{0xD1, 0x87}, {0xD1, 0x89}, {0xD1, 0x8A}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xD1, 0x8B}, {0xD1, 0x8C}, {0xD1, 0x8D}, /* 0x60-0x63 */
	{0xD1, 0x8E}, {0xD1, 0x8F}, {0xD1, 0x90}, {0xD1, 0x91}, /* 0x64-0x67 */
	{0xD1, 0x92}, {0xD1, 0x93}, {0xD1, 0x94}, {0xD1, 0x95}, /* 0x68-0x6B */
	{0xD1, 0x96}, {0xD1, 0x97}, {0xD1, 0x98}, {0xD1, 0x99}, /* 0x6C-0x6F */
	{0xD1, 0x9A}, {0xD1, 0x9B}, {0xD1, 0x9C}, {0xD1, 0x9D}, /* 0x70-0x73 */
	{0xD1, 0x9E}, {0xD1, 0x9F}, {0xD1, 0xA2}, {0xD1, 0xA3}, /* 0x74-0x77 */
	{0xD1, 0xA5}, {0xD1, 0xA6}, {0xD1, 0xA7}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD1, 0xA9}, {0xD1, 0xAA}, {0xD1, 0xAB}, /* 0x80-0x83 */
	{0xD1, 0xAC}, {0xD1, 0xAD}, {0xD1, 0xAE}, {0xD1, 0xAF}, /* 0x84-0x87 */
	{0xD1, 0xB2}, {0xD1, 0xB4}, {0xD1, 0xB6}, {0xD1, 0xB7}, /* 0x88-0x8B */
	{0xD1, 0xB8}, {0xD1, 0xB9}, {0xD1, 0xBB}, {0xD1, 0xBD}, /* 0x8C-0x8F */
	{0xD1, 0xBE}, {0xD1, 0xBF}, {0xD1, 0xC1}, {0xD1, 0xC2}, /* 0x90-0x93 */
	{0xD1, 0xC3}, {0xD1, 0xC4}, {0xD1, 0xC5}, {0xD1, 0xC6}, /* 0x94-0x97 */
	{0xD1, 0xC7}, {0xD1, 0xC8}, {0xD1, 0xC9}, {0xD1, 0xCA}, /* 0x98-0x9B */
	{0xD1, 0xCB}, {0xD1, 0xCC}, {0xD1, 0xCD}, {0xD1, 0xCE}, /* 0x9C-0x9F */
	{0xD1, 0xCF}, {0xB7, 0x98}, {0xB7, 0x99}, {0xB7, 0x9C}, /* 0xA0-0xA3 */
	{0xB7, 0xA0}, {0xB7, 0xA8}, {0xB7, 0xA9}, {0xB7, 0xAB}, /* 0xA4-0xA7 */
	{0xB7, 0xAC}, {0xB7, 0xAD}, {0xB7, 0xB4}, {0xB7, 0xB5}, /* 0xA8-0xAB */
	{0xB7, 0xB8}, {0xB7, 0xC7}, {0xB7, 0xC9}, {0xB7, 0xEC}, /* 0xAC-0xAF */
	{0xB7, 0xED}, {0xB7, 0xF0}, {0xB7, 0xF4}, {0xB7, 0xFC}, /* 0xB0-0xB3 */
	{0xB7, 0xFD}, {0xB7, 0xFF}, {0xB8, 0x00}, {0xB8, 0x01}, /* 0xB4-0xB7 */
	{0xB8, 0x07}, {0xB8, 0x08}, {0xB8, 0x09}, {0xB8, 0x0C}, /* 0xB8-0xBB */
	{0xB8, 0x10}, {0xB8, 0x18}, {0xB8, 0x19}, {0xB8, 0x1B}, /* 0xBC-0xBF */
	{0xB8, 0x1D}, {0xB8, 0x24}, {0xB8, 0x25}, {0xB8, 0x28}, /* 0xC0-0xC3 */
	{0xB8, 0x2C}, {0xB8, 0x34}, {0xB8, 0x35}, {0xB8, 0x37}, /* 0xC4-0xC7 */
	{0xB8, 0x38}, {0xB8, 0x39}, {0xB8, 0x40}, {0xB8, 0x44}, /* 0xC8-0xCB */
	{0xB8, 0x51}, {0xB8, 0x53}, {0xB8, 0x5C}, {0xB8, 0x5D}, /* 0xCC-0xCF */
	{0xB8, 0x60}, {0xB8, 0x64}, {0xB8, 0x6C}, {0xB8, 0x6D}, /* 0xD0-0xD3 */
	{0xB8, 0x6F}, {0xB8, 0x71}, {0xB8, 0x78}, {0xB8, 0x7C}, /* 0xD4-0xD7 */
	{0xB8, 0x8D}, {0xB8, 0xA8}, {0xB8, 0xB0}, {0xB8, 0xB4}, /* 0xD8-0xDB */
	{0xB8, 0xB8}, {0xB8, 0xC0}, {0xB8, 0xC1}, {0xB8, 0xC3}, /* 0xDC-0xDF */
	{0xB8, 0xC5}, {0xB8, 0xCC}, {0xB8, 0xD0}, {0xB8, 0xD4}, /* 0xE0-0xE3 */
	{0xB8, 0xDD}, {0xB8, 0xDF}, {0xB8, 0xE1}, {0xB8, 0xE8}, /* 0xE4-0xE7 */
	{0xB8, 0xE9}, {0xB8, 0xEC}, {0xB8, 0xF0}, {0xB8, 0xF8}, /* 0xE8-0xEB */
	{0xB8, 0xF9}, {0xB8, 0xFB}, {0xB8, 0xFD}, {0xB9, 0x04}, /* 0xEC-0xEF */
	{0xB9, 0x18}, {0xB9, 0x20}, {0xB9, 0x3C}, {0xB9, 0x3D}, /* 0xF0-0xF3 */
	{0xB9, 0x40}, {0xB9, 0x44}, {0xB9, 0x4C}, {0xB9, 0x4F}, /* 0xF4-0xF7 */
	{0xB9, 0x51}, {0xB9, 0x58}, {0xB9, 0x59}, {0xB9, 0x5C}, /* 0xF8-0xFB */
	{0xB9, 0x60}, {0xB9, 0x68}, {0xB9, 0x69}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_B8[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD1, 0xD0}, {0xD1, 0xD1}, {0xD1, 0xD2}, /* 0x40-0x43 */
	{0xD1, 0xD3}, {0xD1, 0xD4}, {0xD1, 0xD5}, {0xD1, 0xD6}, /* 0x44-0x47 */
	{0xD1, 0xD7}, {0xD1, 0xD9}, {0xD1, 0xDA}, {0xD1, 0xDB}, /* 0x48-0x4B */
	{0xD1, 0xDC}, {0xD1, 0xDD}, {0xD1, 0xDE}, {0xD1, 0xDF}, /* 0x4C-0x4F */
	{0xD1, 0xE0}, {0xD1, 0xE1}, {0xD1, 0xE2}, {0xD1, 0xE3}, /* 0x50-0x53 */
	{0xD1, 0xE4}, {0xD1, 0xE5}, {0xD1, 0xE6}, {0xD1, 0xE7}, /* 0x54-0x57 */
	{0xD1, 0xE8}, {0xD1, 0xE9}, {0xD1, 0xEA}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xD1, 0xEB}, {0xD1, 0xEC}, {0xD1, 0xED}, /* 0x60-0x63 */
	{0xD1, 0xEE}, {0xD1, 0xEF}, {0xD1, 0xF0}, {0xD1, 0xF1}, /* 0x64-0x67 */
	{0xD1, 0xF2}, {0xD1, 0xF3}, {0xD1, 0xF5}, {0xD1, 0xF6}, /* 0x68-0x6B */
	{0xD1, 0xF7}, {0xD1, 0xF9}, {0xD1, 0xFA}, {0xD1, 0xFB}, /* 0x6C-0x6F */
	{0xD1, 0xFC}, {0xD1, 0xFD}, {0xD1, 0xFE}, {0xD1, 0xFF}, /* 0x70-0x73 */
	{0xD2, 0x00}, {0xD2, 0x01}, {0xD2, 0x02}, {0xD2, 0x03}, /* 0x74-0x77 */
	{0xD2, 0x04}, {0xD2, 0x05}, {0xD2, 0x06}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD2, 0x08}, {0xD2, 0x0A}, {0xD2, 0x0B}, /* 0x80-0x83 */
	{0xD2, 0x0C}, {0xD2, 0x0D}, {0xD2, 0x0E}, {0xD2, 0x0F}, /* 0x84-0x87 */
	{0xD2, 0x11}, {0xD2, 0x12}, {0xD2, 0x13}, {0xD2, 0x14}, /* 0x88-0x8B */
	{0xD2, 0x15}, {0xD2, 0x16}, {0xD2, 0x17}, {0xD2, 0x18}, /* 0x8C-0x8F */
	{0xD2, 0x19}, {0xD2, 0x1A}, {0xD2, 0x1B}, {0xD2, 0x1C}, /* 0x90-0x93 */
	{0xD2, 0x1D}, {0xD2, 0x1E}, {0xD2, 0x1F}, {0xD2, 0x20}, /* 0x94-0x97 */
	{0xD2, 0x21}, {0xD2, 0x22}, {0xD2, 0x23}, {0xD2, 0x24}, /* 0x98-0x9B */
	{0xD2, 0x25}, {0xD2, 0x26}, {0xD2, 0x27}, {0xD2, 0x28}, /* 0x9C-0x9F */
	{0xD2, 0x29}, {0xB9, 0x6B}, {0xB9, 0x6D}, {0xB9, 0x74}, /* 0xA0-0xA3 */
	{0xB9, 0x75}, {0xB9, 0x78}, {0xB9, 0x7C}, {0xB9, 0x84}, /* 0xA4-0xA7 */
	{0xB9, 0x85}, {0xB9, 0x87}, {0xB9, 0x89}, {0xB9, 0x8A}, /* 0xA8-0xAB */
	{0xB9, 0x8D}, {0xB9, 0x8E}, {0xB9, 0xAC}, {0xB9, 0xAD}, /* 0xAC-0xAF */
	{0xB9, 0xB0}, {0xB9, 0xB4}, {0xB9, 0xBC}, {0xB9, 0xBD}, /* 0xB0-0xB3 */
	{0xB9, 0xBF}, {0xB9, 0xC1}, {0xB9, 0xC8}, {0xB9, 0xC9}, /* 0xB4-0xB7 */
	{0xB9, 0xCC}, {0xB9, 0xCE}, {0xB9, 0xCF}, {0xB9, 0xD0}, /* 0xB8-0xBB */
	{0xB9, 0xD1}, {0xB9, 0xD2}, {0xB9, 0xD8}, {0xB9, 0xD9}, /* 0xBC-0xBF */
	{0xB9, 0xDB}, {0xB9, 0xDD}, {0xB9, 0xDE}, {0xB9, 0xE1}, /* 0xC0-0xC3 */
	{0xB9, 0xE3}, {0xB9, 0xE4}, {0xB9, 0xE5}, {0xB9, 0xE8}, /* 0xC4-0xC7 */
	{0xB9, 0xEC}, {0xB9, 0xF4}, {0xB9, 0xF5}, {0xB9, 0xF7}, /* 0xC8-0xCB */
	{0xB9, 0xF8}, {0xB9, 0xF9}, {0xB9, 0xFA}, {0xBA, 0x00}, /* 0xCC-0xCF */
	{0xBA, 0x01}, {0xBA, 0x08}, {0xBA, 0x15}, {0xBA, 0x38}, /* 0xD0-0xD3 */
	{0xBA, 0x39}, {0xBA, 0x3C}, {0xBA, 0x40}, {0xBA, 0x42}, /* 0xD4-0xD7 */
	{0xBA, 0x48}, {0xBA, 0x49}, {0xBA, 0x4B}, {0xBA, 0x4D}, /* 0xD8-0xDB */
	{0xBA, 0x4E}, {0xBA, 0x53}, {0xBA, 0x54}, {0xBA, 0x55}, /* 0xDC-0xDF */
	{0xBA, 0x58}, {0xBA, 0x5C}, {0xBA, 0x64}, {0xBA, 0x65}, /* 0xE0-0xE3 */
	{0xBA, 0x67}, {0xBA, 0x68}, {0xBA, 0x69}, {0xBA, 0x70}, /* 0xE4-0xE7 */
	{0xBA, 0x71}, {0xBA, 0x74}, {0xBA, 0x78}, {0xBA, 0x83}, /* 0xE8-0xEB */
	{0xBA, 0x84}, {0xBA, 0x85}, {0xBA, 0x87}, {0xBA, 0x8C}, /* 0xEC-0xEF */
	{0xBA, 0xA8}, {0xBA, 0xA9}, {0xBA, 0xAB}, {0xBA, 0xAC}, /* 0xF0-0xF3 */
	{0xBA, 0xB0}, {0xBA, 0xB2}, {0xBA, 0xB8}, {0xBA, 0xB9}, /* 0xF4-0xF7 */
	{0xBA, 0xBB}, {0xBA, 0xBD}, {0xBA, 0xC4}, {0xBA, 0xC8}, /* 0xF8-0xFB */
	{0xBA, 0xD8}, {0xBA, 0xD9}, {0xBA, 0xFC}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_B9[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD2, 0x2A}, {0xD2, 0x2B}, {0xD2, 0x2E}, /* 0x40-0x43 */
	{0xD2, 0x2F}, {0xD2, 0x31}, {0xD2, 0x32}, {0xD2, 0x33}, /* 0x44-0x47 */
	{0xD2, 0x35}, {0xD2, 0x36}, {0xD2, 0x37}, {0xD2, 0x38}, /* 0x48-0x4B */
	{0xD2, 0x39}, {0xD2, 0x3A}, {0xD2, 0x3B}, {0xD2, 0x3E}, /* 0x4C-0x4F */
	{0xD2, 0x40}, {0xD2, 0x42}, {0xD2, 0x43}, {0xD2, 0x44}, /* 0x50-0x53 */
	{0xD2, 0x45}, {0xD2, 0x46}, {0xD2, 0x47}, {0xD2, 0x49}, /* 0x54-0x57 */
	{0xD2, 0x4A}, {0xD2, 0x4B}, {0xD2, 0x4C}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xD2, 0x4D}, {0xD2, 0x4E}, {0xD2, 0x4F}, /* 0x60-0x63 */
	{0xD2, 0x50}, {0xD2, 0x51}, {0xD2, 0x52}, {0xD2, 0x53}, /* 0x64-0x67 */
	{0xD2, 0x54}, {0xD2, 0x55}, {0xD2, 0x56}, {0xD2, 0x57}, /* 0x68-0x6B */
	{0xD2, 0x58}, {0xD2, 0x59}, {0xD2, 0x5A}, {0xD2, 0x5B}, /* 0x6C-0x6F */
	{0xD2, 0x5D}, {0xD2, 0x5E}, {0xD2, 0x5F}, {0xD2, 0x60}, /* 0x70-0x73 */
	{0xD2, 0x61}, {0xD2, 0x62}, {0xD2, 0x63}, {0xD2, 0x65}, /* 0x74-0x77 */
	{0xD2, 0x66}, {0xD2, 0x67}, {0xD2, 0x68}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD2, 0x69}, {0xD2, 0x6A}, {0xD2, 0x6B}, /* 0x80-0x83 */
	{0xD2, 0x6C}, {0xD2, 0x6D}, {0xD2, 0x6E}, {0xD2, 0x6F}, /* 0x84-0x87 */
	{0xD2, 0x70}, {0xD2, 0x71}, {0xD2, 0x72}, {0xD2, 0x73}, /* 0x88-0x8B */
	{0xD2, 0x74}, {0xD2, 0x75}, {0xD2, 0x76}, {0xD2, 0x77}, /* 0x8C-0x8F */
	{0xD2, 0x78}, {0xD2, 0x79}, {0xD2, 0x7A}, {0xD2, 0x7B}, /* 0x90-0x93 */
	{0xD2, 0x7C}, {0xD2, 0x7D}, {0xD2, 0x7E}, {0xD2, 0x7F}, /* 0x94-0x97 */
	{0xD2, 0x82}, {0xD2, 0x83}, {0xD2, 0x85}, {0xD2, 0x86}, /* 0x98-0x9B */
	{0xD2, 0x87}, {0xD2, 0x89}, {0xD2, 0x8A}, {0xD2, 0x8B}, /* 0x9C-0x9F */
	{0xD2, 0x8C}, {0xBB, 0x00}, {0xBB, 0x04}, {0xBB, 0x0D}, /* 0xA0-0xA3 */
	{0xBB, 0x0F}, {0xBB, 0x11}, {0xBB, 0x18}, {0xBB, 0x1C}, /* 0xA4-0xA7 */
	{0xBB, 0x20}, {0xBB, 0x29}, {0xBB, 0x2B}, {0xBB, 0x34}, /* 0xA8-0xAB */
	{0xBB, 0x35}, {0xBB, 0x36}, {0xBB, 0x38}, {0xBB, 0x3B}, /* 0xAC-0xAF */
	{0xBB, 0x3C}, {0xBB, 0x3D}, {0xBB, 0x3E}, {0xBB, 0x44}, /* 0xB0-0xB3 */
	{0xBB, 0x45}, {0xBB, 0x47}, {0xBB, 0x49}, {0xBB, 0x4D}, /* 0xB4-0xB7 */
	{0xBB, 0x4F}, {0xBB, 0x50}, {0xBB, 0x54}, {0xBB, 0x58}, /* 0xB8-0xBB */
	{0xBB, 0x61}, {0xBB, 0x63}, {0xBB, 0x6C}, {0xBB, 0x88}, /* 0xBC-0xBF */
	{0xBB, 0x8C}, {0xBB, 0x90}, {0xBB, 0xA4}, {0xBB, 0xA8}, /* 0xC0-0xC3 */
	{0xBB, 0xAC}, {0xBB, 0xB4}, {0xBB, 0xB7}, {0xBB, 0xC0}, /* 0xC4-0xC7 */
	{0xBB, 0xC4}, {0xBB, 0xC8}, {0xBB, 0xD0}, {0xBB, 0xD3}, /* 0xC8-0xCB */
	{0xBB, 0xF8}, {0xBB, 0xF9}, {0xBB, 0xFC}, {0xBB, 0xFF}, /* 0xCC-0xCF */
	{0xBC, 0x00}, {0xBC, 0x02}, {0xBC, 0x08}, {0xBC, 0x09}, /* 0xD0-0xD3 */
	{0xBC, 0x0B}, {0xBC, 0x0C}, {0xBC, 0x0D}, {0xBC, 0x0F}, /* 0xD4-0xD7 */
	{0xBC, 0x11}, {0xBC, 0x14}, {0xBC, 0x15}, {0xBC, 0x16}, /* 0xD8-0xDB */
	{0xBC, 0x17}, {0xBC, 0x18}, {0xBC, 0x1B}, {0xBC, 0x1C}, /* 0xDC-0xDF */
	{0xBC, 0x1D}, {0xBC, 0x1E}, {0xBC, 0x1F}, {0xBC, 0x24}, /* 0xE0-0xE3 */
	{0xBC, 0x25}, {0xBC, 0x27}, {0xBC, 0x29}, {0xBC, 0x2D}, /* 0xE4-0xE7 */
	{0xBC, 0x30}, {0xBC, 0x31}, {0xBC, 0x34}, {0xBC, 0x38}, /* 0xE8-0xEB */
	{0xBC, 0x40}, {0xBC, 0x41}, {0xBC, 0x43}, {0xBC, 0x44}, /* 0xEC-0xEF */
	{0xBC, 0x45}, {0xBC, 0x49}, {0xBC, 0x4C}, {0xBC, 0x4D}, /* 0xF0-0xF3 */
	{0xBC, 0x50}, {0xBC, 0x5D}, {0xBC, 0x84}, {0xBC, 0x85}, /* 0xF4-0xF7 */
	{0xBC, 0x88}, {0xBC, 0x8B}, {0xBC, 0x8C}, {0xBC, 0x8E}, /* 0xF8-0xFB */
	{0xBC, 0x94}, {0xBC, 0x95}, {0xBC, 0x97}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_BA[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD2, 0x8D}, {0xD2, 0x8E}, {0xD2, 0x8F}, /* 0x40-0x43 */
	{0xD2, 0x92}, {0xD2, 0x93}, {0xD2, 0x94}, {0xD2, 0x96}, /* 0x44-0x47 */
	{0xD2, 0x97}, {0xD2, 0x98}, {0xD2, 0x99}, {0xD2, 0x9A}, /* 0x48-0x4B */
	{0xD2, 0x9B}, {0xD2, 0x9D}, {0xD2, 0x9E}, {0xD2, 0x9F}, /* 0x4C-0x4F */
	{0xD2, 0xA1}, {0xD2, 0xA2}, {0xD2, 0xA3}, {0xD2, 0xA5}, /* 0x50-0x53 */
	{0xD2, 0xA6}, {0xD2, 0xA7}, {0xD2, 0xA8}, {0xD2, 0xA9}, /* 0x54-0x57 */
	{0xD2, 0xAA}, {0xD2, 0xAB}, {0xD2, 0xAD}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xD2, 0xAE}, {0xD2, 0xAF}, {0xD2, 0xB0}, /* 0x60-0x63 */
	{0xD2, 0xB2}, {0xD2, 0xB3}, {0xD2, 0xB4}, {0xD2, 0xB5}, /* 0x64-0x67 */
	{0xD2, 0xB6}, {0xD2, 0xB7}, {0xD2, 0xBA}, {0xD2, 0xBB}, /* 0x68-0x6B */
	{0xD2, 0xBD}, {0xD2, 0xBE}, {0xD2, 0xC1}, {0xD2, 0xC3}, /* 0x6C-0x6F */
	{0xD2, 0xC4}, {0xD2, 0xC5}, {0xD2, 0xC6}, {0xD2, 0xC7}, /* 0x70-0x73 */
	{0xD2, 0xCA}, {0xD2, 0xCC}, {0xD2, 0xCD}, {0xD2, 0xCE}, /* 0x74-0x77 */
	{0xD2, 0xCF}, {0xD2, 0xD0}, {0xD2, 0xD1}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD2, 0xD2}, {0xD2, 0xD3}, {0xD2, 0xD5}, /* 0x80-0x83 */
	{0xD2, 0xD6}, {0xD2, 0xD7}, {0xD2, 0xD9}, {0xD2, 0xDA}, /* 0x84-0x87 */
	{0xD2, 0xDB}, {0xD2, 0xDD}, {0xD2, 0xDE}, {0xD2, 0xDF}, /* 0x88-0x8B */
	{0xD2, 0xE0}, {0xD2, 0xE1}, {0xD2, 0xE2}, {0xD2, 0xE3}, /* 0x8C-0x8F */
	{0xD2, 0xE6}, {0xD2, 0xE7}, {0xD2, 0xE8}, {0xD2, 0xE9}, /* 0x90-0x93 */
	{0xD2, 0xEA}, {0xD2, 0xEB}, {0xD2, 0xEC}, {0xD2, 0xED}, /* 0x94-0x97 */
	{0xD2, 0xEE}, {0xD2, 0xEF}, {0xD2, 0xF2}, {0xD2, 0xF3}, /* 0x98-0x9B */
	{0xD2, 0xF5}, {0xD2, 0xF6}, {0xD2, 0xF7}, {0xD2, 0xF9}, /* 0x9C-0x9F */
	{0xD2, 0xFA}, {0xBC, 0x99}, {0xBC, 0x9A}, {0xBC, 0xA0}, /* 0xA0-0xA3 */
	{0xBC, 0xA1}, {0xBC, 0xA4}, {0xBC, 0xA7}, {0xBC, 0xA8}, /* 0xA4-0xA7 */
	{0xBC, 0xB0}, {0xBC, 0xB1}, {0xBC, 0xB3}, {0xBC, 0xB4}, /* 0xA8-0xAB */
	{0xBC, 0xB5}, {0xBC, 0xBC}, {0xBC, 0xBD}, {0xBC, 0xC0}, /* 0xAC-0xAF */
	{0xBC, 0xC4}, {0xBC, 0xCD}, {0xBC, 0xCF}, {0xBC, 0xD0}, /* 0xB0-0xB3 */
	{0xBC, 0xD1}, {0xBC, 0xD5}, {0xBC, 0xD8}, {0xBC, 0xDC}, /* 0xB4-0xB7 */
	{0xBC, 0xF4}, {0xBC, 0xF5}, {0xBC, 0xF6}, {0xBC, 0xF8}, /* 0xB8-0xBB */
	{0xBC, 0xFC}, {0xBD, 0x04}, {0xBD, 0x05}, {0xBD, 0x07}, /* 0xBC-0xBF */
	{0xBD, 0x09}, {0xBD, 0x10}, {0xBD, 0x14}, {0xBD, 0x24}, /* 0xC0-0xC3 */
	{0xBD, 0x2C}, {0xBD, 0x40}, {0xBD, 0x48}, {0xBD, 0x49}, /* 0xC4-0xC7 */
	{0xBD, 0x4C}, {0xBD, 0x50}, {0xBD, 0x58}, {0xBD, 0x59}, /* 0xC8-0xCB */
	{0xBD, 0x64}, {0xBD, 0x68}, {0xBD, 0x80}, {0xBD, 0x81}, /* 0xCC-0xCF */
	{0xBD, 0x84}, {0xBD, 0x87}, {0xBD, 0x88}, {0xBD, 0x89}, /* 0xD0-0xD3 */
	{0xBD, 0x8A}, {0xBD, 0x90}, {0xBD, 0x91}, {0xBD, 0x93}, /* 0xD4-0xD7 */
	{0xBD, 0x95}, {0xBD, 0x99}, {0xBD, 0x9A}, {0xBD, 0x9C}, /* 0xD8-0xDB */
	{0xBD, 0xA4}, {0xBD, 0xB0}, {0xBD, 0xB8}, {0xBD, 0xD4}, /* 0xDC-0xDF */
	{0xBD, 0xD5}, {0xBD, 0xD8}, {0xBD, 0xDC}, {0xBD, 0xE9}, /* 0xE0-0xE3 */
	{0xBD, 0xF0}, {0xBD, 0xF4}, {0xBD, 0xF8}, {0xBE, 0x00}, /* 0xE4-0xE7 */
	{0xBE, 0x03}, {0xBE, 0x05}, {0xBE, 0x0C}, {0xBE, 0x0D}, /* 0xE8-0xEB */
	{0xBE, 0x10}, {0xBE, 0x14}, {0xBE, 0x1C}, {0xBE, 0x1D}, /* 0xEC-0xEF */
	{0xBE, 0x1F}, {0xBE, 0x44}, {0xBE, 0x45}, {0xBE, 0x48}, /* 0xF0-0xF3 */
	{0xBE, 0x4C}, {0xBE, 0x4E}, {0xBE, 0x54}, {0xBE, 0x55}, /* 0xF4-0xF7 */
	{0xBE, 0x57}, {0xBE, 0x59}, {0xBE, 0x5A}, {0xBE, 0x5B}, /* 0xF8-0xFB */
	{0xBE, 0x60}, {0xBE, 0x61}, {0xBE, 0x64}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_BB[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD2, 0xFB}, {0xD2, 0xFC}, {0xD2, 0xFD}, /* 0x40-0x43 */
	{0xD2, 0xFE}, {0xD2, 0xFF}, {0xD3, 0x02}, {0xD3, 0x04}, /* 0x44-0x47 */
	{0xD3, 0x06}, {0xD3, 0x07}, {0xD3, 0x08}, {0xD3, 0x09}, /* 0x48-0x4B */
	{0xD3, 0x0A}, {0xD3, 0x0B}, {0xD3, 0x0F}, {0xD3, 0x11}, /* 0x4C-0x4F */
	{0xD3, 0x12}, {0xD3, 0x13}, {0xD3, 0x15}, {0xD3, 0x17}, /* 0x50-0x53 */
	{0xD3, 0x18}, {0xD3, 0x19}, {0xD3, 0x1A}, {0xD3, 0x1B}, /* 0x54-0x57 */
	{0xD3, 0x1E}, {0xD3, 0x22}, {0xD3, 0x23}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xD3, 0x24}, {0xD3, 0x26}, {0xD3, 0x27}, /* 0x60-0x63 */
	{0xD3, 0x2A}, {0xD3, 0x2B}, {0xD3, 0x2D}, {0xD3, 0x2E}, /* 0x64-0x67 */
	{0xD3, 0x2F}, {0xD3, 0x31}, {0xD3, 0x32}, {0xD3, 0x33}, /* 0x68-0x6B */
	{0xD3, 0x34}, {0xD3, 0x35}, {0xD3, 0x36}, {0xD3, 0x37}, /* 0x6C-0x6F */
	{0xD3, 0x3A}, {0xD3, 0x3E}, {0xD3, 0x3F}, {0xD3, 0x40}, /* 0x70-0x73 */
	{0xD3, 0x41}, {0xD3, 0x42}, {0xD3, 0x43}, {0xD3, 0x46}, /* 0x74-0x77 */
	{0xD3, 0x47}, {0xD3, 0x48}, {0xD3, 0x49}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD3, 0x4A}, {0xD3, 0x4B}, {0xD3, 0x4C}, /* 0x80-0x83 */
	{0xD3, 0x4D}, {0xD3, 0x4E}, {0xD3, 0x4F}, {0xD3, 0x50}, /* 0x84-0x87 */
	{0xD3, 0x51}, {0xD3, 0x52}, {0xD3, 0x53}, {0xD3, 0x54}, /* 0x88-0x8B */
	{0xD3, 0x55}, {0xD3, 0x56}, {0xD3, 0x57}, {0xD3, 0x58}, /* 0x8C-0x8F */
	{0xD3, 0x59}, {0xD3, 0x5A}, {0xD3, 0x5B}, {0xD3, 0x5C}, /* 0x90-0x93 */
	{0xD3, 0x5D}, {0xD3, 0x5E}, {0xD3, 0x5F}, {0xD3, 0x60}, /* 0x94-0x97 */
	{0xD3, 0x61}, {0xD3, 0x62}, {0xD3, 0x63}, {0xD3, 0x64}, /* 0x98-0x9B */
	{0xD3, 0x65}, {0xD3, 0x66}, {0xD3, 0x67}, {0xD3, 0x68}, /* 0x9C-0x9F */
	{0xD3, 0x69}, {0xBE, 0x68}, {0xBE, 0x6A}, {0xBE, 0x70}, /* 0xA0-0xA3 */
	{0xBE, 0x71}, {0xBE, 0x73}, {0xBE, 0x74}, {0xBE, 0x75}, /* 0xA4-0xA7 */
	{0xBE, 0x7B}, {0xBE, 0x7C}, {0xBE, 0x7D}, {0xBE, 0x80}, /* 0xA8-0xAB */
	{0xBE, 0x84}, {0xBE, 0x8C}, {0xBE, 0x8D}, {0xBE, 0x8F}, /* 0xAC-0xAF */
	{0xBE, 0x90}, {0xBE, 0x91}, {0xBE, 0x98}, {0xBE, 0x99}, /* 0xB0-0xB3 */
	{0xBE, 0xA8}, {0xBE, 0xD0}, {0xBE, 0xD1}, {0xBE, 0xD4}, /* 0xB4-0xB7 */
	{0xBE, 0xD7}, {0xBE, 0xD8}, {0xBE, 0xE0}, {0xBE, 0xE3}, /* 0xB8-0xBB */
	{0xBE, 0xE4}, {0xBE, 0xE5}, {0xBE, 0xEC}, {0xBF, 0x01}, /* 0xBC-0xBF */
	{0xBF, 0x08}, {0xBF, 0x09}, {0xBF, 0x18}, {0xBF, 0x19}, /* 0xC0-0xC3 */
	{0xBF, 0x1B}, {0xBF, 0x1C}, {0xBF, 0x1D}, {0xBF, 0x40}, /* 0xC4-0xC7 */
	{0xBF, 0x41}, {0xBF, 0x44}, {0xBF, 0x48}, {0xBF, 0x50}, /* 0xC8-0xCB */
	{0xBF, 0x51}, {0xBF, 0x55}, {0xBF, 0x94}, {0xBF, 0xB0}, /* 0xCC-0xCF */
	{0xBF, 0xC5}, {0xBF, 0xCC}, {0xBF, 0xCD}, {0xBF, 0xD0}, /* 0xD0-0xD3 */
	{0xBF, 0xD4}, {0xBF, 0xDC}, {0xBF, 0xDF}, {0xBF, 0xE1}, /* 0xD4-0xD7 */
	{0xC0, 0x3C}, {0xC0, 0x51}, {0xC0, 0x58}, {0xC0, 0x5C}, /* 0xD8-0xDB */
	{0xC0, 0x60}, {0xC0, 0x68}, {0xC0, 0x69}, {0xC0, 0x90}, /* 0xDC-0xDF */
	{0xC0, 0x91}, {0xC0, 0x94}, {0xC0, 0x98}, {0xC0, 0xA0}, /* 0xE0-0xE3 */
	{0xC0, 0xA1}, {0xC0, 0xA3}, {0xC0, 0xA5}, {0xC0, 0xAC}, /* 0xE4-0xE7 */
	{0xC0, 0xAD}, {0xC0, 0xAF}, {0xC0, 0xB0}, {0xC0, 0xB3}, /* 0xE8-0xEB */
	{0xC0, 0xB4}, {0xC0, 0xB5}, {0xC0, 0xB6}, {0xC0, 0xBC}, /* 0xEC-0xEF */
	{0xC0, 0xBD}, {0xC0, 0xBF}, {0xC0, 0xC0}, {0xC0, 0xC1}, /* 0xF0-0xF3 */
	{0xC0, 0xC5}, {0xC0, 0xC8}, {0xC0, 0xC9}, {0xC0, 0xCC}, /* 0xF4-0xF7 */
	{0xC0, 0xD0}, {0xC0, 0xD8}, {0xC0, 0xD9}, {0xC0, 0xDB}, /* 0xF8-0xFB */
	{0xC0, 0xDC}, {0xC0, 0xDD}, {0xC0, 0xE4}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_BC[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD3, 0x6A}, {0xD3, 0x6B}, {0xD3, 0x6C}, /* 0x40-0x43 */
	{0xD3, 0x6D}, {0xD3, 0x6E}, {0xD3, 0x6F}, {0xD3, 0x70}, /* 0x44-0x47 */
	{0xD3, 0x71}, {0xD3, 0x72}, {0xD3, 0x73}, {0xD3, 0x74}, /* 0x48-0x4B */
	{0xD3, 0x75}, {0xD3, 0x76}, {0xD3, 0x77}, {0xD3, 0x78}, /* 0x4C-0x4F */
	{0xD3, 0x79}, {0xD3, 0x7A}, {0xD3, 0x7B}, {0xD3, 0x7E}, /* 0x50-0x53 */
	{0xD3, 0x7F}, {0xD3, 0x81}, {0xD3, 0x82}, {0xD3, 0x83}, /* 0x54-0x57 */
	{0xD3, 0x85}, {0xD3, 0x86}, {0xD3, 0x87}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xD3, 0x88}, {0xD3, 0x89}, {0xD3, 0x8A}, /* 0x60-0x63 */
	{0xD3, 0x8B}, {0xD3, 0x8E}, {0xD3, 0x92}, {0xD3, 0x93}, /* 0x64-0x67 */
	{0xD3, 0x94}, {0xD3, 0x95}, {0xD3, 0x96}, {0xD3, 0x97}, /* 0x68-0x6B */
	{0xD3, 0x9A}, {0xD3, 0x9B}, {0xD3, 0x9D}, {0xD3, 0x9E}, /* 0x6C-0x6F */
	{0xD3, 0x9F}, {0xD3, 0xA1}, {0xD3, 0xA2}, {0xD3, 0xA3}, /* 0x70-0x73 */
	{0xD3, 0xA4}, {0xD3, 0xA5}, {0xD3, 0xA6}, {0xD3, 0xA7}, /* 0x74-0x77 */
	{0xD3, 0xAA}, {0xD3, 0xAC}, {0xD3, 0xAE}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD3, 0xAF}, {0xD3, 0xB0}, {0xD3, 0xB1}, /* 0x80-0x83 */
	{0xD3, 0xB2}, {0xD3, 0xB3}, {0xD3, 0xB5}, {0xD3, 0xB6}, /* 0x84-0x87 */
	{0xD3, 0xB7}, {0xD3, 0xB9}, {0xD3, 0xBA}, {0xD3, 0xBB}, /* 0x88-0x8B */
	{0xD3, 0xBD}, {0xD3, 0xBE}, {0xD3, 0xBF}, {0xD3, 0xC0}, /* 0x8C-0x8F */
	{0xD3, 0xC1}, {0xD3, 0xC2}, {0xD3, 0xC3}, {0xD3, 0xC6}, /* 0x90-0x93 */
	{0xD3, 0xC7}, {0xD3, 0xCA}, {0xD3, 0xCB}, {0xD3, 0xCC}, /* 0x94-0x97 */
	{0xD3, 0xCD}, {0xD3, 0xCE}, {0xD3, 0xCF}, {0xD3, 0xD1}, /* 0x98-0x9B */
	{0xD3, 0xD2}, {0xD3, 0xD3}, {0xD3, 0xD4}, {0xD3, 0xD5}, /* 0x9C-0x9F */
	{0xD3, 0xD6}, {0xC0, 0xE5}, {0xC0, 0xE8}, {0xC0, 0xEC}, /* 0xA0-0xA3 */
	{0xC0, 0xF4}, {0xC0, 0xF5}, {0xC0, 0xF7}, {0xC0, 0xF9}, /* 0xA4-0xA7 */
	{0xC1, 0x00}, {0xC1, 0x04}, {0xC1, 0x08}, {0xC1, 0x10}, /* 0xA8-0xAB */
	{0xC1, 0x15}, {0xC1, 0x1C}, {0xC1, 0x1D}, {0xC1, 0x1E}, /* 0xAC-0xAF */
	{0xC1, 0x1F}, {0xC1, 0x20}, {0xC1, 0x23}, {0xC1, 0x24}, /* 0xB0-0xB3 */
	{0xC1, 0x26}, {0xC1, 0x27}, {0xC1, 0x2C}, {0xC1, 0x2D}, /* 0xB4-0xB7 */
	{0xC1, 0x2F}, {0xC1, 0x30}, {0xC1, 0x31}, {0xC1, 0x36}, /* 0xB8-0xBB */
	{0xC1, 0x38}, {0xC1, 0x39}, {0xC1, 0x3C}, {0xC1, 0x40}, /* 0xBC-0xBF */
	{0xC1, 0x48}, {0xC1, 0x49}, {0xC1, 0x4B}, {0xC1, 0x4C}, /* 0xC0-0xC3 */
	{0xC1, 0x4D}, {0xC1, 0x54}, {0xC1, 0x55}, {0xC1, 0x58}, /* 0xC4-0xC7 */
	{0xC1, 0x5C}, {0xC1, 0x64}, {0xC1, 0x65}, {0xC1, 0x67}, /* 0xC8-0xCB */
	{0xC1, 0x68}, {0xC1, 0x69}, {0xC1, 0x70}, {0xC1, 0x74}, /* 0xCC-0xCF */
	{0xC1, 0x78}, {0xC1, 0x85}, {0xC1, 0x8C}, {0xC1, 0x8D}, /* 0xD0-0xD3 */
	{0xC1, 0x8E}, {0xC1, 0x90}, {0xC1, 0x94}, {0xC1, 0x96}, /* 0xD4-0xD7 */
	{0xC1, 0x9C}, {0xC1, 0x9D}, {0xC1, 0x9F}, {0xC1, 0xA1}, /* 0xD8-0xDB */
	{0xC1, 0xA5}, {0xC1, 0xA8}, {0xC1, 0xA9}, {0xC1, 0xAC}, /* 0xDC-0xDF */
	{0xC1, 0xB0}, {0xC1, 0xBD}, {0xC1, 0xC4}, {0xC1, 0xC8}, /* 0xE0-0xE3 */
	{0xC1, 0xCC}, {0xC1, 0xD4}, {0xC1, 0xD7}, {0xC1, 0xD8}, /* 0xE4-0xE7 */
	{0xC1, 0xE0}, {0xC1, 0xE4}, {0xC1, 0xE8}, {0xC1, 0xF0}, /* 0xE8-0xEB */
	{0xC1, 0xF1}, {0xC1, 0xF3}, {0xC1, 0xFC}, {0xC1, 0xFD}, /* 0xEC-0xEF */
	{0xC2, 0x00}, {0xC2, 0x04}, {0xC2, 0x0C}, {0xC2, 0x0D}, /* 0xF0-0xF3 */
	{0xC2, 0x0F}, {0xC2, 0x11}, {0xC2, 0x18}, {0xC2, 0x19}, /* 0xF4-0xF7 */
	{0xC2, 0x1C}, {0xC2, 0x1F}, {0xC2, 0x20}, {0xC2, 0x28}, /* 0xF8-0xFB */
	{0xC2, 0x29}, {0xC2, 0x2B}, {0xC2, 0x2D}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_BD[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD3, 0xD7}, {0xD3, 0xD9}, {0xD3, 0xDA}, /* 0x40-0x43 */
	{0xD3, 0xDB}, {0xD3, 0xDC}, {0xD3, 0xDD}, {0xD3, 0xDE}, /* 0x44-0x47 */
	{0xD3, 0xDF}, {0xD3, 0xE0}, {0xD3, 0xE2}, {0xD3, 0xE4}, /* 0x48-0x4B */
	{0xD3, 0xE5}, {0xD3, 0xE6}, {0xD3, 0xE7}, {0xD3, 0xE8}, /* 0x4C-0x4F */
	{0xD3, 0xE9}, {0xD3, 0xEA}, {0xD3, 0xEB}, {0xD3, 0xEE}, /* 0x50-0x53 */
	{0xD3, 0xEF}, {0xD3, 0xF1}, {0xD3, 0xF2}, {0xD3, 0xF3}, /* 0x54-0x57 */
	{0xD3, 0xF5}, {0xD3, 0xF6}, {0xD3, 0xF7}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xD3, 0xF8}, {0xD3, 0xF9}, {0xD3, 0xFA}, /* 0x60-0x63 */
	{0xD3, 0xFB}, {0xD3, 0xFE}, {0xD4, 0x00}, {0xD4, 0x02}, /* 0x64-0x67 */
	{0xD4, 0x03}, {0xD4, 0x04}, {0xD4, 0x05}, {0xD4, 0x06}, /* 0x68-0x6B */
	{0xD4, 0x07}, {0xD4, 0x09}, {0xD4, 0x0A}, {0xD4, 0x0B}, /* 0x6C-0x6F */
	{0xD4, 0x0C}, {0xD4, 0x0D}, {0xD4, 0x0E}, {0xD4, 0x0F}, /* 0x70-0x73 */
	{0xD4, 0x10}, {0xD4, 0x11}, {0xD4, 0x12}, {0xD4, 0x13}, /* 0x74-0x77 */
	{0xD4, 0x14}, {0xD4, 0x15}, {0xD4, 0x16}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD4, 0x17}, {0xD4, 0x18}, {0xD4, 0x19}, /* 0x80-0x83 */
	{0xD4, 0x1A}, {0xD4, 0x1B}, {0xD4, 0x1C}, {0xD4, 0x1E}, /* 0x84-0x87 */
	{0xD4, 0x1F}, {0xD4, 0x20}, {0xD4, 0x21}, {0xD4, 0x22}, /* 0x88-0x8B */
	{0xD4, 0x23}, {0xD4, 0x24}, {0xD4, 0x25}, {0xD4, 0x26}, /* 0x8C-0x8F */
	{0xD4, 0x27}, {0xD4, 0x28}, {0xD4, 0x29}, {0xD4, 0x2A}, /* 0x90-0x93 */
	{0xD4, 0x2B}, {0xD4, 0x2C}, {0xD4, 0x2D}, {0xD4, 0x2E}, /* 0x94-0x97 */
	{0xD4, 0x2F}, {0xD4, 0x30}, {0xD4, 0x31}, {0xD4, 0x32}, /* 0x98-0x9B */
	{0xD4, 0x33}, {0xD4, 0x34}, {0xD4, 0x35}, {0xD4, 0x36}, /* 0x9C-0x9F */
	{0xD4, 0x37}, {0xC2, 0x2F}, {0xC2, 0x31}, {0xC2, 0x32}, /* 0xA0-0xA3 */
	{0xC2, 0x34}, {0xC2, 0x48}, {0xC2, 0x50}, {0xC2, 0x51}, /* 0xA4-0xA7 */
	{0xC2, 0x54}, {0xC2, 0x58}, {0xC2, 0x60}, {0xC2, 0x65}, /* 0xA8-0xAB */
	{0xC2, 0x6C}, {0xC2, 0x6D}, {0xC2, 0x70}, {0xC2, 0x74}, /* 0xAC-0xAF */
	{0xC2, 0x7C}, {0xC2, 0x7D}, {0xC2, 0x7F}, {0xC2, 0x81}, /* 0xB0-0xB3 */
	{0xC2, 0x88}, {0xC2, 0x89}, {0xC2, 0x90}, {0xC2, 0x98}, /* 0xB4-0xB7 */
	{0xC2, 0x9B}, {0xC2, 0x9D}, {0xC2, 0xA4}, {0xC2, 0xA5}, /* 0xB8-0xBB */
	{0xC2, 0xA8}, {0xC2, 0xAC}, {0xC2, 0xAD}, {0xC2, 0xB4}, /* 0xBC-0xBF */
	{0xC2, 0xB5}, {0xC2, 0xB7}, {0xC2, 0xB9}, {0xC2, 0xDC}, /* 0xC0-0xC3 */
	{0xC2, 0xDD}, {0xC2, 0xE0}, {0xC2, 0xE3}, {0xC2, 0xE4}, /* 0xC4-0xC7 */
	{0xC2, 0xEB}, {0xC2, 0xEC}, {0xC2, 0xED}, {0xC2, 0xEF}, /* 0xC8-0xCB */
	{0xC2, 0xF1}, {0xC2, 0xF6}, {0xC2, 0xF8}, {0xC2, 0xF9}, /* 0xCC-0xCF */
	{0xC2, 0xFB}, {0xC2, 0xFC}, {0xC3, 0x00}, {0xC3, 0x08}, /* 0xD0-0xD3 */
	{0xC3, 0x09}, {0xC3, 0x0C}, {0xC3, 0x0D}, {0xC3, 0x13}, /* 0xD4-0xD7 */
	{0xC3, 0x14}, {0xC3, 0x15}, {0xC3, 0x18}, {0xC3, 0x1C}, /* 0xD8-0xDB */
	{0xC3, 0x24}, {0xC3, 0x25}, {0xC3, 0x28}, {0xC3, 0x29}, /* 0xDC-0xDF */
	{0xC3, 0x45}, {0xC3, 0x68}, {0xC3, 0x69}, {0xC3, 0x6C}, /* 0xE0-0xE3 */
	{0xC3, 0x70}, {0xC3, 0x72}, {0xC3, 0x78}, {0xC3, 0x79}, /* 0xE4-0xE7 */
	{0xC3, 0x7C}, {0xC3, 0x7D}, {0xC3, 0x84}, {0xC3, 0x88}, /* 0xE8-0xEB */
	{0xC3, 0x8C}, {0xC3, 0xC0}, {0xC3, 0xD8}, {0xC3, 0xD9}, /* 0xEC-0xEF */
	{0xC3, 0xDC}, {0xC3, 0xDF}, {0xC3, 0xE0}, {0xC3, 0xE2}, /* 0xF0-0xF3 */
	{0xC3, 0xE8}, {0xC3, 0xE9}, {0xC3, 0xED}, {0xC3, 0xF4}, /* 0xF4-0xF7 */
	{0xC3, 0xF5}, {0xC3, 0xF8}, {0xC4, 0x08}, {0xC4, 0x10}, /* 0xF8-0xFB */
	{0xC4, 0x24}, {0xC4, 0x2C}, {0xC4, 0x30}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_BE[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD4, 0x38}, {0xD4, 0x39}, {0xD4, 0x3A}, /* 0x40-0x43 */
	{0xD4, 0x3B}, {0xD4, 0x3C}, {0xD4, 0x3D}, {0xD4, 0x3E}, /* 0x44-0x47 */
	{0xD4, 0x3F}, {0xD4, 0x41}, {0xD4, 0x42}, {0xD4, 0x43}, /* 0x48-0x4B */
	{0xD4, 0x45}, {0xD4, 0x46}, {0xD4, 0x47}, {0xD4, 0x48}, /* 0x4C-0x4F */
	{0xD4, 0x49}, {0xD4, 0x4A}, {0xD4, 0x4B}, {0xD4, 0x4C}, /* 0x50-0x53 */
	{0xD4, 0x4D}, {0xD4, 0x4E}, {0xD4, 0x4F}, {0xD4, 0x50}, /* 0x54-0x57 */
	{0xD4, 0x51}, {0xD4, 0x52}, {0xD4, 0x53}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xD4, 0x54}, {0xD4, 0x55}, {0xD4, 0x56}, /* 0x60-0x63 */
	{0xD4, 0x57}, {0xD4, 0x58}, {0xD4, 0x59}, {0xD4, 0x5A}, /* 0x64-0x67 */
	{0xD4, 0x5B}, {0xD4, 0x5D}, {0xD4, 0x5E}, {0xD4, 0x5F}, /* 0x68-0x6B */
	{0xD4, 0x61}, {0xD4, 0x62}, {0xD4, 0x63}, {0xD4, 0x65}, /* 0x6C-0x6F */
	{0xD4, 0x66}, {0xD4, 0x67}, {0xD4, 0x68}, {0xD4, 0x69}, /* 0x70-0x73 */
	{0xD4, 0x6A}, {0xD4, 0x6B}, {0xD4, 0x6C}, {0xD4, 0x6E}, /* 0x74-0x77 */
	{0xD4, 0x70}, {0xD4, 0x71}, {0xD4, 0x72}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD4, 0x73}, {0xD4, 0x74}, {0xD4, 0x75}, /* 0x80-0x83 */
	{0xD4, 0x76}, {0xD4, 0x77}, {0xD4, 0x7A}, {0xD4, 0x7B}, /* 0x84-0x87 */
	{0xD4, 0x7D}, {0xD4, 0x7E}, {0xD4, 0x81}, {0xD4, 0x83}, /* 0x88-0x8B */
	{0xD4, 0x84}, {0xD4, 0x85}, {0xD4, 0x86}, {0xD4, 0x87}, /* 0x8C-0x8F */
	{0xD4, 0x8A}, {0xD4, 0x8C}, {0xD4, 0x8E}, {0xD4, 0x8F}, /* 0x90-0x93 */
	{0xD4, 0x90}, {0xD4, 0x91}, {0xD4, 0x92}, {0xD4, 0x93}, /* 0x94-0x97 */
	{0xD4, 0x95}, {0xD4, 0x96}, {0xD4, 0x97}, {0xD4, 0x98}, /* 0x98-0x9B */
	{0xD4, 0x99}, {0xD4, 0x9A}, {0xD4, 0x9B}, {0xD4, 0x9C}, /* 0x9C-0x9F */
	{0xD4, 0x9D}, {0xC4, 0x34}, {0xC4, 0x3C}, {0xC4, 0x3D}, /* 0xA0-0xA3 */
	{0xC4, 0x48}, {0xC4, 0x64}, {0xC4, 0x65}, {0xC4, 0x68}, /* 0xA4-0xA7 */
	{0xC4, 0x6C}, {0xC4, 0x74}, {0xC4, 0x75}, {0xC4, 0x79}, /* 0xA8-0xAB */
	{0xC4, 0x80}, {0xC4, 0x94}, {0xC4, 0x9C}, {0xC4, 0xB8}, /* 0xAC-0xAF */
	{0xC4, 0xBC}, {0xC4, 0xE9}, {0xC4, 0xF0}, {0xC4, 0xF1}, /* 0xB0-0xB3 */
	{0xC4, 0xF4}, {0xC4, 0xF8}, {0xC4, 0xFA}, {0xC4, 0xFF}, /* 0xB4-0xB7 */
	{0xC5, 0x00}, {0xC5, 0x01}, {0xC5, 0x0C}, {0xC5, 0x10}, /* 0xB8-0xBB */
	{0xC5, 0x14}, {0xC5, 0x1C}, {0xC5, 0x28}, {0xC5, 0x29}, /* 0xBC-0xBF */
	{0xC5, 0x2C}, {0xC5, 0x30}, {0xC5, 0x38}, {0xC5, 0x39}, /* 0xC0-0xC3 */
	{0xC5, 0x3B}, {0xC5, 0x3D}, {0xC5, 0x44}, {0xC5, 0x45}, /* 0xC4-0xC7 */
	{0xC5, 0x48}, {0xC5, 0x49}, {0xC5, 0x4A}, {0xC5, 0x4C}, /* 0xC8-0xCB */
	{0xC5, 0x4D}, {0xC5, 0x4E}, {0xC5, 0x53}, {0xC5, 0x54}, /* 0xCC-0xCF */
	{0xC5, 0x55}, {0xC5, 0x57}, {0xC5, 0x58}, {0xC5, 0x59}, /* 0xD0-0xD3 */
	{0xC5, 0x5D}, {0xC5, 0x5E}, {0xC5, 0x60}, {0xC5, 0x61}, /* 0xD4-0xD7 */
	{0xC5, 0x64}, {0xC5, 0x68}, {0xC5, 0x70}, {0xC5, 0x71}, /* 0xD8-0xDB */
	{0xC5, 0x73}, {0xC5, 0x74}, {0xC5, 0x75}, {0xC5, 0x7C}, /* 0xDC-0xDF */
	{0xC5, 0x7D}, {0xC5, 0x80}, {0xC5, 0x84}, {0xC5, 0x87}, /* 0xE0-0xE3 */
	{0xC5, 0x8C}, {0xC5, 0x8D}, {0xC5, 0x8F}, {0xC5, 0x91}, /* 0xE4-0xE7 */
	{0xC5, 0x95}, {0xC5, 0x97}, {0xC5, 0x98}, {0xC5, 0x9C}, /* 0xE8-0xEB */
	{0xC5, 0xA0}, {0xC5, 0xA9}, {0xC5, 0xB4}, {0xC5, 0xB5}, /* 0xEC-0xEF */
	{0xC5, 0xB8}, {0xC5, 0xB9}, {0xC5, 0xBB}, {0xC5, 0xBC}, /* 0xF0-0xF3 */
	{0xC5, 0xBD}, {0xC5, 0xBE}, {0xC5, 0xC4}, {0xC5, 0xC5}, /* 0xF4-0xF7 */
	{0xC5, 0xC6}, {0xC5, 0xC7}, {0xC5, 0xC8}, {0xC5, 0xC9}, /* 0xF8-0xFB */
	{0xC5, 0xCA}, {0xC5, 0xCC}, {0xC5, 0xCE}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_BF[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD4, 0x9E}, {0xD4, 0x9F}, {0xD4, 0xA0}, /* 0x40-0x43 */
	{0xD4, 0xA1}, {0xD4, 0xA2}, {0xD4, 0xA3}, {0xD4, 0xA4}, /* 0x44-0x47 */
	{0xD4, 0xA5}, {0xD4, 0xA6}, {0xD4, 0xA7}, {0xD4, 0xA8}, /* 0x48-0x4B */
	{0xD4, 0xAA}, {0xD4, 0xAB}, {0xD4, 0xAC}, {0xD4, 0xAD}, /* 0x4C-0x4F */
	{0xD4, 0xAE}, {0xD4, 0xAF}, {0xD4, 0xB0}, {0xD4, 0xB1}, /* 0x50-0x53 */
	{0xD4, 0xB2}, {0xD4, 0xB3}, {0xD4, 0xB4}, {0xD4, 0xB5}, /* 0x54-0x57 */
	{0xD4, 0xB6}, {0xD4, 0xB7}, {0xD4, 0xB8}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xD4, 0xB9}, {0xD4, 0xBA}, {0xD4, 0xBB}, /* 0x60-0x63 */
	{0xD4, 0xBC}, {0xD4, 0xBD}, {0xD4, 0xBE}, {0xD4, 0xBF}, /* 0x64-0x67 */
	{0xD4, 0xC0}, {0xD4, 0xC1}, {0xD4, 0xC2}, {0xD4, 0xC3}, /* 0x68-0x6B */
	{0xD4, 0xC4}, {0xD4, 0xC5}, {0xD4, 0xC6}, {0xD4, 0xC7}, /* 0x6C-0x6F */
	{0xD4, 0xC8}, {0xD4, 0xC9}, {0xD4, 0xCA}, {0xD4, 0xCB}, /* 0x70-0x73 */
	{0xD4, 0xCD}, {0xD4, 0xCE}, {0xD4, 0xCF}, {0xD4, 0xD1}, /* 0x74-0x77 */
	{0xD4, 0xD2}, {0xD4, 0xD3}, {0xD4, 0xD5}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD4, 0xD6}, {0xD4, 0xD7}, {0xD4, 0xD8}, /* 0x80-0x83 */
	{0xD4, 0xD9}, {0xD4, 0xDA}, {0xD4, 0xDB}, {0xD4, 0xDD}, /* 0x84-0x87 */
	{0xD4, 0xDE}, {0xD4, 0xE0}, {0xD4, 0xE1}, {0xD4, 0xE2}, /* 0x88-0x8B */
	{0xD4, 0xE3}, {0xD4, 0xE4}, {0xD4, 0xE5}, {0xD4, 0xE6}, /* 0x8C-0x8F */
	{0xD4, 0xE7}, {0xD4, 0xE9}, {0xD4, 0xEA}, {0xD4, 0xEB}, /* 0x90-0x93 */
	{0xD4, 0xED}, {0xD4, 0xEE}, {0xD4, 0xEF}, {0xD4, 0xF1}, /* 0x94-0x97 */
	{0xD4, 0xF2}, {0xD4, 0xF3}, {0xD4, 0xF4}, {0xD4, 0xF5}, /* 0x98-0x9B */
	{0xD4, 0xF6}, {0xD4, 0xF7}, {0xD4, 0xF9}, {0xD4, 0xFA}, /* 0x9C-0x9F */
	{0xD4, 0xFC}, {0xC5, 0xD0}, {0xC5, 0xD1}, {0xC5, 0xD4}, /* 0xA0-0xA3 */
	{0xC5, 0xD8}, {0xC5, 0xE0}, {0xC5, 0xE1}, {0xC5, 0xE3}, /* 0xA4-0xA7 */
	{0xC5, 0xE5}, {0xC5, 0xEC}, {0xC5, 0xED}, {0xC5, 0xEE}, /* 0xA8-0xAB */
	{0xC5, 0xF0}, {0xC5, 0xF4}, {0xC5, 0xF6}, {0xC5, 0xF7}, /* 0xAC-0xAF */
	{0xC5, 0xFC}, {0xC5, 0xFD}, {0xC5, 0xFE}, {0xC5, 0xFF}, /* 0xB0-0xB3 */
	{0xC6, 0x00}, {0xC6, 0x01}, {0xC6, 0x05}, {0xC6, 0x06}, /* 0xB4-0xB7 */
	{0xC6, 0x07}, {0xC6, 0x08}, {0xC6, 0x0C}, {0xC6, 0x10}, /* 0xB8-0xBB */
	{0xC6, 0x18}, {0xC6, 0x19}, {0xC6, 0x1B}, {0xC6, 0x1C}, /* 0xBC-0xBF */
	{0xC6, 0x24}, {0xC6, 0x25}, {0xC6, 0x28}, {0xC6, 0x2C}, /* 0xC0-0xC3 */
	{0xC6, 0x2D}, {0xC6, 0x2E}, {0xC6, 0x30}, {0xC6, 0x33}, /* 0xC4-0xC7 */
	{0xC6, 0x34}, {0xC6, 0x35}, {0xC6, 0x37}, {0xC6, 0x39}, /* 0xC8-0xCB */
	{0xC6, 0x3B}, {0xC6, 0x40}, {0xC6, 0x41}, {0xC6, 0x44}, /* 0xCC-0xCF */
	{0xC6, 0x48}, {0xC6, 0x50}, {0xC6, 0x51}, {0xC6, 0x53}, /* 0xD0-0xD3 */
	{0xC6, 0x54}, {0xC6, 0x55}, {0xC6, 0x5C}, {0xC6, 0x5D}, /* 0xD4-0xD7 */
	{0xC6, 0x60}, {0xC6, 0x6C}, {0xC6, 0x6F}, {0xC6, 0x71}, /* 0xD8-0xDB */
	{0xC6, 0x78}, {0xC6, 0x79}, {0xC6, 0x7C}, {0xC6, 0x80}, /* 0xDC-0xDF */
	{0xC6, 0x88}, {0xC6, 0x89}, {0xC6, 0x8B}, {0xC6, 0x8D}, /* 0xE0-0xE3 */
	{0xC6, 0x94}, {0xC6, 0x95}, {0xC6, 0x98}, {0xC6, 0x9C}, /* 0xE4-0xE7 */
	{0xC6, 0xA4}, {0xC6, 0xA5}, {0xC6, 0xA7}, {0xC6, 0xA9}, /* 0xE8-0xEB */
	{0xC6, 0xB0}, {0xC6, 0xB1}, {0xC6, 0xB4}, {0xC6, 0xB8}, /* 0xEC-0xEF */
	{0xC6, 0xB9}, {0xC6, 0xBA}, {0xC6, 0xC0}, {0xC6, 0xC1}, /* 0xF0-0xF3 */
	{0xC6, 0xC3}, {0xC6, 0xC5}, {0xC6, 0xCC}, {0xC6, 0xCD}, /* 0xF4-0xF7 */
	{0xC6, 0xD0}, {0xC6, 0xD4}, {0xC6, 0xDC}, {0xC6, 0xDD}, /* 0xF8-0xFB */
	{0xC6, 0xE0}, {0xC6, 0xE1}, {0xC6, 0xE8}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_C0[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD4, 0xFE}, {0xD4, 0xFF}, {0xD5, 0x00}, /* 0x40-0x43 */
	{0xD5, 0x01}, {0xD5, 0x02}, {0xD5, 0x03}, {0xD5, 0x05}, /* 0x44-0x47 */
	{0xD5, 0x06}, {0xD5, 0x07}, {0xD5, 0x09}, {0xD5, 0x0A}, /* 0x48-0x4B */
	{0xD5, 0x0B}, {0xD5, 0x0D}, {0xD5, 0x0E}, {0xD5, 0x0F}, /* 0x4C-0x4F */
	{0xD5, 0x10}, {0xD5, 0x11}, {0xD5, 0x12}, {0xD5, 0x13}, /* 0x50-0x53 */
	{0xD5, 0x16}, {0xD5, 0x18}, {0xD5, 0x19}, {0xD5, 0x1A}, /* 0x54-0x57 */
	{0xD5, 0x1B}, {0xD5, 0x1C}, {0xD5, 0x1D}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xD5, 0x1E}, {0xD5, 0x1F}, {0xD5, 0x20}, /* 0x60-0x63 */
	{0xD5, 0x21}, {0xD5, 0x22}, {0xD5, 0x23}, {0xD5, 0x24}, /* 0x64-0x67 */
	{0xD5, 0x25}, {0xD5, 0x26}, {0xD5, 0x27}, {0xD5, 0x28}, /* 0x68-0x6B */
	{0xD5, 0x29}, {0xD5, 0x2A}, {0xD5, 0x2B}, {0xD5, 0x2C}, /* 0x6C-0x6F */
	{0xD5, 0x2D}, {0xD5, 0x2E}, {0xD5, 0x2F}, {0xD5, 0x30}, /* 0x70-0x73 */
	{0xD5, 0x31}, {0xD5, 0x32}, {0xD5, 0x33}, {0xD5, 0x34}, /* 0x74-0x77 */
	{0xD5, 0x35}, {0xD5, 0x36}, {0xD5, 0x37}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD5, 0x38}, {0xD5, 0x39}, {0xD5, 0x3A}, /* 0x80-0x83 */
	{0xD5, 0x3B}, {0xD5, 0x3E}, {0xD5, 0x3F}, {0xD5, 0x41}, /* 0x84-0x87 */
	{0xD5, 0x42}, {0xD5, 0x43}, {0xD5, 0x45}, {0xD5, 0x46}, /* 0x88-0x8B */
	{0xD5, 0x47}, {0xD5, 0x48}, {0xD5, 0x49}, {0xD5, 0x4A}, /* 0x8C-0x8F */
	{0xD5, 0x4B}, {0xD5, 0x4E}, {0xD5, 0x50}, {0xD5, 0x52}, /* 0x90-0x93 */
	{0xD5, 0x53}, {0xD5, 0x54}, {0xD5, 0x55}, {0xD5, 0x56}, /* 0x94-0x97 */
	{0xD5, 0x57}, {0xD5, 0x5A}, {0xD5, 0x5B}, {0xD5, 0x5D}, /* 0x98-0x9B */
	{0xD5, 0x5E}, {0xD5, 0x5F}, {0xD5, 0x61}, {0xD5, 0x62}, /* 0x9C-0x9F */
	{0xD5, 0x63}, {0xC6, 0xE9}, {0xC6, 0xEC}, {0xC6, 0xF0}, /* 0xA0-0xA3 */
	{0xC6, 0xF8}, {0xC6, 0xF9}, {0xC6, 0xFD}, {0xC7, 0x04}, /* 0xA4-0xA7 */
	{0xC7, 0x05}, {0xC7, 0x08}, {0xC7, 0x0C}, {0xC7, 0x14}, /* 0xA8-0xAB */
	{0xC7, 0x15}, {0xC7, 0x17}, {0xC7, 0x19}, {0xC7, 0x20}, /* 0xAC-0xAF */
	{0xC7, 0x21}, {0xC7, 0x24}, {0xC7, 0x28}, {0xC7, 0x30}, /* 0xB0-0xB3 */
	{0xC7, 0x31}, {0xC7, 0x33}, {0xC7, 0x35}, {0xC7, 0x37}, /* 0xB4-0xB7 */
	{0xC7, 0x3C}, {0xC7, 0x3D}, {0xC7, 0x40}, {0xC7, 0x44}, /* 0xB8-0xBB */
	{0xC7, 0x4A}, {0xC7, 0x4C}, {0xC7, 0x4D}, {0xC7, 0x4F}, /* 0xBC-0xBF */
	{0xC7, 0x51}, {0xC7, 0x52}, {0xC7, 0x53}, {0xC7, 0x54}, /* 0xC0-0xC3 */
	{0xC7, 0x55}, {0xC7, 0x56}, {0xC7, 0x57}, {0xC7, 0x58}, /* 0xC4-0xC7 */
	{0xC7, 0x5C}, {0xC7, 0x60}, {0xC7, 0x68}, {0xC7, 0x6B}, /* 0xC8-0xCB */
	{0xC7, 0x74}, {0xC7, 0x75}, {0xC7, 0x78}, {0xC7, 0x7C}, /* 0xCC-0xCF */
	{0xC7, 0x7D}, {0xC7, 0x7E}, {0xC7, 0x83}, {0xC7, 0x84}, /* 0xD0-0xD3 */
	{0xC7, 0x85}, {0xC7, 0x87}, {0xC7, 0x88}, {0xC7, 0x89}, /* 0xD4-0xD7 */
	{0xC7, 0x8A}, {0xC7, 0x8E}, {0xC7, 0x90}, {0xC7, 0x91}, /* 0xD8-0xDB */
	{0xC7, 0x94}, {0xC7, 0x96}, {0xC7, 0x97}, {0xC7, 0x98}, /* 0xDC-0xDF */
	{0xC7, 0x9A}, {0xC7, 0xA0}, {0xC7, 0xA1}, {0xC7, 0xA3}, /* 0xE0-0xE3 */
	{0xC7, 0xA4}, {0xC7, 0xA5}, {0xC7, 0xA6}, {0xC7, 0xAC}, /* 0xE4-0xE7 */
	{0xC7, 0xAD}, {0xC7, 0xB0}, {0xC7, 0xB4}, {0xC7, 0xBC}, /* 0xE8-0xEB */
	{0xC7, 0xBD}, {0xC7, 0xBF}, {0xC7, 0xC0}, {0xC7, 0xC1}, /* 0xEC-0xEF */
	{0xC7, 0xC8}, {0xC7, 0xC9}, {0xC7, 0xCC}, {0xC7, 0xCE}, /* 0xF0-0xF3 */
	{0xC7, 0xD0}, {0xC7, 0xD8}, {0xC7, 0xDD}, {0xC7, 0xE4}, /* 0xF4-0xF7 */
	{0xC7, 0xE8}, {0xC7, 0xEC}, {0xC8, 0x00}, {0xC8, 0x01}, /* 0xF8-0xFB */
	{0xC8, 0x04}, {0xC8, 0x08}, {0xC8, 0x0A}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_C1[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD5, 0x64}, {0xD5, 0x66}, {0xD5, 0x67}, /* 0x40-0x43 */
	{0xD5, 0x6A}, {0xD5, 0x6C}, {0xD5, 0x6E}, {0xD5, 0x6F}, /* 0x44-0x47 */
	{0xD5, 0x70}, {0xD5, 0x71}, {0xD5, 0x72}, {0xD5, 0x73}, /* 0x48-0x4B */
	{0xD5, 0x76}, {0xD5, 0x77}, {0xD5, 0x79}, {0xD5, 0x7A}, /* 0x4C-0x4F */
	{0xD5, 0x7B}, {0xD5, 0x7D}, {0xD5, 0x7E}, {0xD5, 0x7F}, /* 0x50-0x53 */
	{0xD5, 0x80}, {0xD5, 0x81}, {0xD5, 0x82}, {0xD5, 0x83}, /* 0x54-0x57 */
	{0xD5, 0x86}, {0xD5, 0x8A}, {0xD5, 0x8B}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xD5, 0x8C}, {0xD5, 0x8D}, {0xD5, 0x8E}, /* 0x60-0x63 */
	{0xD5, 0x8F}, {0xD5, 0x91}, {0xD5, 0x92}, {0xD5, 0x93}, /* 0x64-0x67 */
	{0xD5, 0x94}, {0xD5, 0x95}, {0xD5, 0x96}, {0xD5, 0x97}, /* 0x68-0x6B */
	{0xD5, 0x98}, {0xD5, 0x99}, {0xD5, 0x9A}, {0xD5, 0x9B}, /* 0x6C-0x6F */
	{0xD5, 0x9C}, {0xD5, 0x9D}, {0xD5, 0x9E}, {0xD5, 0x9F}, /* 0x70-0x73 */
	{0xD5, 0xA0}, {0xD5, 0xA1}, {0xD5, 0xA2}, {0xD5, 0xA3}, /* 0x74-0x77 */
	{0xD5, 0xA4}, {0xD5, 0xA6}, {0xD5, 0xA7}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD5, 0xA8}, {0xD5, 0xA9}, {0xD5, 0xAA}, /* 0x80-0x83 */
	{0xD5, 0xAB}, {0xD5, 0xAC}, {0xD5, 0xAD}, {0xD5, 0xAE}, /* 0x84-0x87 */
	{0xD5, 0xAF}, {0xD5, 0xB0}, {0xD5, 0xB1}, {0xD5, 0xB2}, /* 0x88-0x8B */
	{0xD5, 0xB3}, {0xD5, 0xB4}, {0xD5, 0xB5}, {0xD5, 0xB6}, /* 0x8C-0x8F */
	{0xD5, 0xB7}, {0xD5, 0xB8}, {0xD5, 0xB9}, {0xD5, 0xBA}, /* 0x90-0x93 */
	{0xD5, 0xBB}, {0xD5, 0xBC}, {0xD5, 0xBD}, {0xD5, 0xBE}, /* 0x94-0x97 */
	{0xD5, 0xBF}, {0xD5, 0xC0}, {0xD5, 0xC1}, {0xD5, 0xC2}, /* 0x98-0x9B */
	{0xD5, 0xC3}, {0xD5, 0xC4}, {0xD5, 0xC5}, {0xD5, 0xC6}, /* 0x9C-0x9F */
	{0xD5, 0xC7}, {0xC8, 0x10}, {0xC8, 0x11}, {0xC8, 0x13}, /* 0xA0-0xA3 */
	{0xC8, 0x15}, {0xC8, 0x16}, {0xC8, 0x1C}, {0xC8, 0x1D}, /* 0xA4-0xA7 */
	{0xC8, 0x20}, {0xC8, 0x24}, {0xC8, 0x2C}, {0xC8, 0x2D}, /* 0xA8-0xAB */
	{0xC8, 0x2F}, {0xC8, 0x31}, {0xC8, 0x38}, {0xC8, 0x3C}, /* 0xAC-0xAF */
	{0xC8, 0x40}, {0xC8, 0x48}, {0xC8, 0x49}, {0xC8, 0x4C}, /* 0xB0-0xB3 */
	{0xC8, 0x4D}, {0xC8, 0x54}, {0xC8, 0x70}, {0xC8, 0x71}, /* 0xB4-0xB7 */
	{0xC8, 0x74}, {0xC8, 0x78}, {0xC8, 0x7A}, {0xC8, 0x80}, /* 0xB8-0xBB */
	{0xC8, 0x81}, {0xC8, 0x83}, {0xC8, 0x85}, {0xC8, 0x86}, /* 0xBC-0xBF */
	{0xC8, 0x87}, {0xC8, 0x8B}, {0xC8, 0x8C}, {0xC8, 0x8D}, /* 0xC0-0xC3 */
	{0xC8, 0x94}, {0xC8, 0x9D}, {0xC8, 0x9F}, {0xC8, 0xA1}, /* 0xC4-0xC7 */
	{0xC8, 0xA8}, {0xC8, 0xBC}, {0xC8, 0xBD}, {0xC8, 0xC4}, /* 0xC8-0xCB */
	{0xC8, 0xC8}, {0xC8, 0xCC}, {0xC8, 0xD4}, {0xC8, 0xD5}, /* 0xCC-0xCF */
	{0xC8, 0xD7}, {0xC8, 0xD9}, {0xC8, 0xE0}, {0xC8, 0xE1}, /* 0xD0-0xD3 */
	{0xC8, 0xE4}, {0xC8, 0xF5}, {0xC8, 0xFC}, {0xC8, 0xFD}, /* 0xD4-0xD7 */
	{0xC9, 0x00}, {0xC9, 0x04}, {0xC9, 0x05}, {0xC9, 0x06}, /* 0xD8-0xDB */
	{0xC9, 0x0C}, {0xC9, 0x0D}, {0xC9, 0x0F}, {0xC9, 0x11}, /* 0xDC-0xDF */
	{0xC9, 0x18}, {0xC9, 0x2C}, {0xC9, 0x34}, {0xC9, 0x50}, /* 0xE0-0xE3 */
	{0xC9, 0x51}, {0xC9, 0x54}, {0xC9, 0x58}, {0xC9, 0x60}, /* 0xE4-0xE7 */
	{0xC9, 0x61}, {0xC9, 0x63}, {0xC9, 0x6C}, {0xC9, 0x70}, /* 0xE8-0xEB */
	{0xC9, 0x74}, {0xC9, 0x7C}, {0xC9, 0x88}, {0xC9, 0x89}, /* 0xEC-0xEF */
	{0xC9, 0x8C}, {0xC9, 0x90}, {0xC9, 0x98}, {0xC9, 0x99}, /* 0xF0-0xF3 */
	{0xC9, 0x9B}, {0xC9, 0x9D}, {0xC9, 0xC0}, {0xC9, 0xC1}, /* 0xF4-0xF7 */
	{0xC9, 0xC4}, {0xC9, 0xC7}, {0xC9, 0xC8}, {0xC9, 0xCA}, /* 0xF8-0xFB */
	{0xC9, 0xD0}, {0xC9, 0xD1}, {0xC9, 0xD3}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_C2[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD5, 0xCA}, {0xD5, 0xCB}, {0xD5, 0xCD}, /* 0x40-0x43 */
	{0xD5, 0xCE}, {0xD5, 0xCF}, {0xD5, 0xD1}, {0xD5, 0xD3}, /* 0x44-0x47 */
	{0xD5, 0xD4}, {0xD5, 0xD5}, {0xD5, 0xD6}, {0xD5, 0xD7}, /* 0x48-0x4B */
	{0xD5, 0xDA}, {0xD5, 0xDC}, {0xD5, 0xDE}, {0xD5, 0xDF}, /* 0x4C-0x4F */
	{0xD5, 0xE0}, {0xD5, 0xE1}, {0xD5, 0xE2}, {0xD5, 0xE3}, /* 0x50-0x53 */
	{0xD5, 0xE6}, {0xD5, 0xE7}, {0xD5, 0xE9}, {0xD5, 0xEA}, /* 0x54-0x57 */
	{0xD5, 0xEB}, {0xD5, 0xED}, {0xD5, 0xEE}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xD5, 0xEF}, {0xD5, 0xF0}, {0xD5, 0xF1}, /* 0x60-0x63 */
	{0xD5, 0xF2}, {0xD5, 0xF3}, {0xD5, 0xF6}, {0xD5, 0xF8}, /* 0x64-0x67 */
	{0xD5, 0xFA}, {0xD5, 0xFB}, {0xD5, 0xFC}, {0xD5, 0xFD}, /* 0x68-0x6B */
	{0xD5, 0xFE}, {0xD5, 0xFF}, {0xD6, 0x02}, {0xD6, 0x03}, /* 0x6C-0x6F */
	{0xD6, 0x05}, {0xD6, 0x06}, {0xD6, 0x07}, {0xD6, 0x09}, /* 0x70-0x73 */
	{0xD6, 0x0A}, {0xD6, 0x0B}, {0xD6, 0x0C}, {0xD6, 0x0D}, /* 0x74-0x77 */
	{0xD6, 0x0E}, {0xD6, 0x0F}, {0xD6, 0x12}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD6, 0x16}, {0xD6, 0x17}, {0xD6, 0x18}, /* 0x80-0x83 */
	{0xD6, 0x19}, {0xD6, 0x1A}, {0xD6, 0x1B}, {0xD6, 0x1D}, /* 0x84-0x87 */
	{0xD6, 0x1E}, {0xD6, 0x1F}, {0xD6, 0x21}, {0xD6, 0x22}, /* 0x88-0x8B */
	{0xD6, 0x23}, {0xD6, 0x25}, {0xD6, 0x26}, {0xD6, 0x27}, /* 0x8C-0x8F */
	{0xD6, 0x28}, {0xD6, 0x29}, {0xD6, 0x2A}, {0xD6, 0x2B}, /* 0x90-0x93 */
	{0xD6, 0x2C}, {0xD6, 0x2E}, {0xD6, 0x2F}, {0xD6, 0x30}, /* 0x94-0x97 */
	{0xD6, 0x31}, {0xD6, 0x32}, {0xD6, 0x33}, {0xD6, 0x34}, /* 0x98-0x9B */
	{0xD6, 0x35}, {0xD6, 0x36}, {0xD6, 0x37}, {0xD6, 0x3A}, /* 0x9C-0x9F */
	{0xD6, 0x3B}, {0xC9, 0xD5}, {0xC9, 0xD6}, {0xC9, 0xD9}, /* 0xA0-0xA3 */
	{0xC9, 0xDA}, {0xC9, 0xDC}, {0xC9, 0xDD}, {0xC9, 0xE0}, /* 0xA4-0xA7 */
	{0xC9, 0xE2}, {0xC9, 0xE4}, {0xC9, 0xE7}, {0xC9, 0xEC}, /* 0xA8-0xAB */
	{0xC9, 0xED}, {0xC9, 0xEF}, {0xC9, 0xF0}, {0xC9, 0xF1}, /* 0xAC-0xAF */
	{0xC9, 0xF8}, {0xC9, 0xF9}, {0xC9, 0xFC}, {0xCA, 0x00}, /* 0xB0-0xB3 */
	{0xCA, 0x08}, {0xCA, 0x09}, {0xCA, 0x0B}, {0xCA, 0x0C}, /* 0xB4-0xB7 */
	{0xCA, 0x0D}, {0xCA, 0x14}, {0xCA, 0x18}, {0xCA, 0x29}, /* 0xB8-0xBB */
	{0xCA, 0x4C}, {0xCA, 0x4D}, {0xCA, 0x50}, {0xCA, 0x54}, /* 0xBC-0xBF */
	{0xCA, 0x5C}, {0xCA, 0x5D}, {0xCA, 0x5F}, {0xCA, 0x60}, /* 0xC0-0xC3 */
	{0xCA, 0x61}, {0xCA, 0x68}, {0xCA, 0x7D}, {0xCA, 0x84}, /* 0xC4-0xC7 */
	{0xCA, 0x98}, {0xCA, 0xBC}, {0xCA, 0xBD}, {0xCA, 0xC0}, /* 0xC8-0xCB */
	{0xCA, 0xC4}, {0xCA, 0xCC}, {0xCA, 0xCD}, {0xCA, 0xCF}, /* 0xCC-0xCF */
	{0xCA, 0xD1}, {0xCA, 0xD3}, {0xCA, 0xD8}, {0xCA, 0xD9}, /* 0xD0-0xD3 */
	{0xCA, 0xE0}, {0xCA, 0xEC}, {0xCA, 0xF4}, {0xCB, 0x08}, /* 0xD4-0xD7 */
	{0xCB, 0x10}, {0xCB, 0x14}, {0xCB, 0x18}, {0xCB, 0x20}, /* 0xD8-0xDB */
	{0xCB, 0x21}, {0xCB, 0x41}, {0xCB, 0x48}, {0xCB, 0x49}, /* 0xDC-0xDF */
	{0xCB, 0x4C}, {0xCB, 0x50}, {0xCB, 0x58}, {0xCB, 0x59}, /* 0xE0-0xE3 */
	{0xCB, 0x5D}, {0xCB, 0x64}, {0xCB, 0x78}, {0xCB, 0x79}, /* 0xE4-0xE7 */
	{0xCB, 0x9C}, {0xCB, 0xB8}, {0xCB, 0xD4}, {0xCB, 0xE4}, /* 0xE8-0xEB */
	{0xCB, 0xE7}, {0xCB, 0xE9}, {0xCC, 0x0C}, {0xCC, 0x0D}, /* 0xEC-0xEF */
	{0xCC, 0x10}, {0xCC, 0x14}, {0xCC, 0x1C}, {0xCC, 0x1D}, /* 0xF0-0xF3 */
	{0xCC, 0x21}, {0xCC, 0x22}, {0xCC, 0x27}, {0xCC, 0x28}, /* 0xF4-0xF7 */
	{0xCC, 0x29}, {0xCC, 0x2C}, {0xCC, 0x2E}, {0xCC, 0x30}, /* 0xF8-0xFB */
	{0xCC, 0x38}, {0xCC, 0x39}, {0xCC, 0x3B}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_C3[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD6, 0x3D}, {0xD6, 0x3E}, {0xD6, 0x3F}, /* 0x40-0x43 */
	{0xD6, 0x41}, {0xD6, 0x42}, {0xD6, 0x43}, {0xD6, 0x44}, /* 0x44-0x47 */
	{0xD6, 0x46}, {0xD6, 0x47}, {0xD6, 0x4A}, {0xD6, 0x4C}, /* 0x48-0x4B */
	{0xD6, 0x4E}, {0xD6, 0x4F}, {0xD6, 0x50}, {0xD6, 0x52}, /* 0x4C-0x4F */
	{0xD6, 0x53}, {0xD6, 0x56}, {0xD6, 0x57}, {0xD6, 0x59}, /* 0x50-0x53 */
	{0xD6, 0x5A}, {0xD6, 0x5B}, {0xD6, 0x5D}, {0xD6, 0x5E}, /* 0x54-0x57 */
	{0xD6, 0x5F}, {0xD6, 0x60}, {0xD6, 0x61}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xD6, 0x62}, {0xD6, 0x63}, {0xD6, 0x64}, /* 0x60-0x63 */
	{0xD6, 0x65}, {0xD6, 0x66}, {0xD6, 0x68}, {0xD6, 0x6A}, /* 0x64-0x67 */
	{0xD6, 0x6B}, {0xD6, 0x6C}, {0xD6, 0x6D}, {0xD6, 0x6E}, /* 0x68-0x6B */
	{0xD6, 0x6F}, {0xD6, 0x72}, {0xD6, 0x73}, {0xD6, 0x75}, /* 0x6C-0x6F */
	{0xD6, 0x76}, {0xD6, 0x77}, {0xD6, 0x78}, {0xD6, 0x79}, /* 0x70-0x73 */
	{0xD6, 0x7A}, {0xD6, 0x7B}, {0xD6, 0x7C}, {0xD6, 0x7D}, /* 0x74-0x77 */
	{0xD6, 0x7E}, {0xD6, 0x7F}, {0xD6, 0x80}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD6, 0x81}, {0xD6, 0x82}, {0xD6, 0x84}, /* 0x80-0x83 */
	{0xD6, 0x86}, {0xD6, 0x87}, {0xD6, 0x88}, {0xD6, 0x89}, /* 0x84-0x87 */
	{0xD6, 0x8A}, {0xD6, 0x8B}, {0xD6, 0x8E}, {0xD6, 0x8F}, /* 0x88-0x8B */
	{0xD6, 0x91}, {0xD6, 0x92}, {0xD6, 0x93}, {0xD6, 0x95}, /* 0x8C-0x8F */
	{0xD6, 0x96}, {0xD6, 0x97}, {0xD6, 0x98}, {0xD6, 0x99}, /* 0x90-0x93 */
	{0xD6, 0x9A}, {0xD6, 0x9B}, {0xD6, 0x9C}, {0xD6, 0x9E}, /* 0x94-0x97 */
	{0xD6, 0xA0}, {0xD6, 0xA2}, {0xD6, 0xA3}, {0xD6, 0xA4}, /* 0x98-0x9B */
	{0xD6, 0xA5}, {0xD6, 0xA6}, {0xD6, 0xA7}, {0xD6, 0xA9}, /* 0x9C-0x9F */
	{0xD6, 0xAA}, {0xCC, 0x3C}, {0xCC, 0x3D}, {0xCC, 0x3E}, /* 0xA0-0xA3 */
	{0xCC, 0x44}, {0xCC, 0x45}, {0xCC, 0x48}, {0xCC, 0x4C}, /* 0xA4-0xA7 */
	{0xCC, 0x54}, {0xCC, 0x55}, {0xCC, 0x57}, {0xCC, 0x58}, /* 0xA8-0xAB */
	{0xCC, 0x59}, {0xCC, 0x60}, {0xCC, 0x64}, {0xCC, 0x66}, /* 0xAC-0xAF */
	{0xCC, 0x68}, {0xCC, 0x70}, {0xCC, 0x75}, {0xCC, 0x98}, /* 0xB0-0xB3 */
	{0xCC, 0x99}, {0xCC, 0x9C}, {0xCC, 0xA0}, {0xCC, 0xA8}, /* 0xB4-0xB7 */
	{0xCC, 0xA9}, {0xCC, 0xAB}, {0xCC, 0xAC}, {0xCC, 0xAD}, /* 0xB8-0xBB */
	{0xCC, 0xB4}, {0xCC, 0xB5}, {0xCC, 0xB8}, {0xCC, 0xBC}, /* 0xBC-0xBF */
	{0xCC, 0xC4}, {0xCC, 0xC5}, {0xCC, 0xC7}, {0xCC, 0xC9}, /* 0xC0-0xC3 */
	{0xCC, 0xD0}, {0xCC, 0xD4}, {0xCC, 0xE4}, {0xCC, 0xEC}, /* 0xC4-0xC7 */
	{0xCC, 0xF0}, {0xCD, 0x01}, {0xCD, 0x08}, {0xCD, 0x09}, /* 0xC8-0xCB */
	{0xCD, 0x0C}, {0xCD, 0x10}, {0xCD, 0x18}, {0xCD, 0x19}, /* 0xCC-0xCF */
	{0xCD, 0x1B}, {0xCD, 0x1D}, {0xCD, 0x24}, {0xCD, 0x28}, /* 0xD0-0xD3 */
	{0xCD, 0x2C}, {0xCD, 0x39}, {0xCD, 0x5C}, {0xCD, 0x60}, /* 0xD4-0xD7 */
	{0xCD, 0x64}, {0xCD, 0x6C}, {0xCD, 0x6D}, {0xCD, 0x6F}, /* 0xD8-0xDB */
	{0xCD, 0x71}, {0xCD, 0x78}, {0xCD, 0x88}, {0xCD, 0x94}, /* 0xDC-0xDF */
	{0xCD, 0x95}, {0xCD, 0x98}, {0xCD, 0x9C}, {0xCD, 0xA4}, /* 0xE0-0xE3 */
	{0xCD, 0xA5}, {0xCD, 0xA7}, {0xCD, 0xA9}, {0xCD, 0xB0}, /* 0xE4-0xE7 */
	{0xCD, 0xC4}, {0xCD, 0xCC}, {0xCD, 0xD0}, {0xCD, 0xE8}, /* 0xE8-0xEB */
	{0xCD, 0xEC}, {0xCD, 0xF0}, {0xCD, 0xF8}, {0xCD, 0xF9}, /* 0xEC-0xEF */
	{0xCD, 0xFB}, {0xCD, 0xFD}, {0xCE, 0x04}, {0xCE, 0x08}, /* 0xF0-0xF3 */
	{0xCE, 0x0C}, {0xCE, 0x14}, {0xCE, 0x19}, {0xCE, 0x20}, /* 0xF4-0xF7 */
	{0xCE, 0x21}, {0xCE, 0x24}, {0xCE, 0x28}, {0xCE, 0x30}, /* 0xF8-0xFB */
	{0xCE, 0x31}, {0xCE, 0x33}, {0xCE, 0x35}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_C4[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD6, 0xAB}, {0xD6, 0xAD}, {0xD6, 0xAE}, /* 0x40-0x43 */
	{0xD6, 0xAF}, {0xD6, 0xB1}, {0xD6, 0xB2}, {0xD6, 0xB3}, /* 0x44-0x47 */
	{0xD6, 0xB4}, {0xD6, 0xB5}, {0xD6, 0xB6}, {0xD6, 0xB7}, /* 0x48-0x4B */
	{0xD6, 0xB8}, {0xD6, 0xBA}, {0xD6, 0xBC}, {0xD6, 0xBD}, /* 0x4C-0x4F */
	{0xD6, 0xBE}, {0xD6, 0xBF}, {0xD6, 0xC0}, {0xD6, 0xC1}, /* 0x50-0x53 */
	{0xD6, 0xC2}, {0xD6, 0xC3}, {0xD6, 0xC6}, {0xD6, 0xC7}, /* 0x54-0x57 */
	{0xD6, 0xC9}, {0xD6, 0xCA}, {0xD6, 0xCB}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xD6, 0xCD}, {0xD6, 0xCE}, {0xD6, 0xCF}, /* 0x60-0x63 */
	{0xD6, 0xD0}, {0xD6, 0xD2}, {0xD6, 0xD3}, {0xD6, 0xD5}, /* 0x64-0x67 */
	{0xD6, 0xD6}, {0xD6, 0xD8}, {0xD6, 0xDA}, {0xD6, 0xDB}, /* 0x68-0x6B */
	{0xD6, 0xDC}, {0xD6, 0xDD}, {0xD6, 0xDE}, {0xD6, 0xDF}, /* 0x6C-0x6F */
	{0xD6, 0xE1}, {0xD6, 0xE2}, {0xD6, 0xE3}, {0xD6, 0xE5}, /* 0x70-0x73 */
	{0xD6, 0xE6}, {0xD6, 0xE7}, {0xD6, 0xE9}, {0xD6, 0xEA}, /* 0x74-0x77 */
	{0xD6, 0xEB}, {0xD6, 0xEC}, {0xD6, 0xED}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD6, 0xEE}, {0xD6, 0xEF}, {0xD6, 0xF1}, /* 0x80-0x83 */
	{0xD6, 0xF2}, {0xD6, 0xF3}, {0xD6, 0xF4}, {0xD6, 0xF6}, /* 0x84-0x87 */
	{0xD6, 0xF7}, {0xD6, 0xF8}, {0xD6, 0xF9}, {0xD6, 0xFA}, /* 0x88-0x8B */
	{0xD6, 0xFB}, {0xD6, 0xFE}, {0xD6, 0xFF}, {0xD7, 0x01}, /* 0x8C-0x8F */
	{0xD7, 0x02}, {0xD7, 0x03}, {0xD7, 0x05}, {0xD7, 0x06}, /* 0x90-0x93 */
	{0xD7, 0x07}, {0xD7, 0x08}, {0xD7, 0x09}, {0xD7, 0x0A}, /* 0x94-0x97 */
	{0xD7, 0x0B}, {0xD7, 0x0C}, {0xD7, 0x0D}, {0xD7, 0x0E}, /* 0x98-0x9B */
	{0xD7, 0x0F}, {0xD7, 0x10}, {0xD7, 0x12}, {0xD7, 0x13}, /* 0x9C-0x9F */
	{0xD7, 0x14}, {0xCE, 0x58}, {0xCE, 0x59}, {0xCE, 0x5C}, /* 0xA0-0xA3 */
	{0xCE, 0x5F}, {0xCE, 0x60}, {0xCE, 0x61}, {0xCE, 0x68}, /* 0xA4-0xA7 */
	{0xCE, 0x69}, {0xCE, 0x6B}, {0xCE, 0x6D}, {0xCE, 0x74}, /* 0xA8-0xAB */
	{0xCE, 0x75}, {0xCE, 0x78}, {0xCE, 0x7C}, {0xCE, 0x84}, /* 0xAC-0xAF */
	{0xCE, 0x85}, {0xCE, 0x87}, {0xCE, 0x89}, {0xCE, 0x90}, /* 0xB0-0xB3 */
	{0xCE, 0x91}, {0xCE, 0x94}, {0xCE, 0x98}, {0xCE, 0xA0}, /* 0xB4-0xB7 */
	{0xCE, 0xA1}, {0xCE, 0xA3}, {0xCE, 0xA4}, {0xCE, 0xA5}, /* 0xB8-0xBB */
	{0xCE, 0xAC}, {0xCE, 0xAD}, {0xCE, 0xC1}, {0xCE, 0xE4}, /* 0xBC-0xBF */
	{0xCE, 0xE5}, {0xCE, 0xE8}, {0xCE, 0xEB}, {0xCE, 0xEC}, /* 0xC0-0xC3 */
	{0xCE, 0xF4}, {0xCE, 0xF5}, {0xCE, 0xF7}, {0xCE, 0xF8}, /* 0xC4-0xC7 */
	{0xCE, 0xF9}, {0xCF, 0x00}, {0xCF, 0x01}, {0xCF, 0x04}, /* 0xC8-0xCB */
	{0xCF, 0x08}, {0xCF, 0x10}, {0xCF, 0x11}, {0xCF, 0x13}, /* 0xCC-0xCF */
	{0xCF, 0x15}, {0xCF, 0x1C}, {0xCF, 0x20}, {0xCF, 0x24}, /* 0xD0-0xD3 */
	{0xCF, 0x2C}, {0xCF, 0x2D}, {0xCF, 0x2F}, {0xCF, 0x30}, /* 0xD4-0xD7 */
	{0xCF, 0x31}, {0xCF, 0x38}, {0xCF, 0x54}, {0xCF, 0x55}, /* 0xD8-0xDB */
	{0xCF, 0x58}, {0xCF, 0x5C}, {0xCF, 0x64}, {0xCF, 0x65}, /* 0xDC-0xDF */
	{0xCF, 0x67}, {0xCF, 0x69}, {0xCF, 0x70}, {0xCF, 0x71}, /* 0xE0-0xE3 */
	{0xCF, 0x74}, {0xCF, 0x78}, {0xCF, 0x80}, {0xCF, 0x85}, /* 0xE4-0xE7 */
	{0xCF, 0x8C}, {0xCF, 0xA1}, {0xCF, 0xA8}, {0xCF, 0xB0}, /* 0xE8-0xEB */
	{0xCF, 0xC4}, {0xCF, 0xE0}, {0xCF, 0xE1}, {0xCF, 0xE4}, /* 0xEC-0xEF */
	{0xCF, 0xE8}, {0xCF, 0xF0}, {0xCF, 0xF1}, {0xCF, 0xF3}, /* 0xF0-0xF3 */
	{0xCF, 0xF5}, {0xCF, 0xFC}, {0xD0, 0x00}, {0xD0, 0x04}, /* 0xF4-0xF7 */
	{0xD0, 0x11}, {0xD0, 0x18}, {0xD0, 0x2D}, {0xD0, 0x34}, /* 0xF8-0xFB */
	{0xD0, 0x35}, {0xD0, 0x38}, {0xD0, 0x3C}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_C5[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD7, 0x15}, {0xD7, 0x16}, {0xD7, 0x17}, /* 0x40-0x43 */
	{0xD7, 0x1A}, {0xD7, 0x1B}, {0xD7, 0x1D}, {0xD7, 0x1E}, /* 0x44-0x47 */
	{0xD7, 0x1F}, {0xD7, 0x21}, {0xD7, 0x22}, {0xD7, 0x23}, /* 0x48-0x4B */
	{0xD7, 0x24}, {0xD7, 0x25}, {0xD7, 0x26}, {0xD7, 0x27}, /* 0x4C-0x4F */
	{0xD7, 0x2A}, {0xD7, 0x2C}, {0xD7, 0x2E}, {0xD7, 0x2F}, /* 0x50-0x53 */
	{0xD7, 0x30}, {0xD7, 0x31}, {0xD7, 0x32}, {0xD7, 0x33}, /* 0x54-0x57 */
	{0xD7, 0x36}, {0xD7, 0x37}, {0xD7, 0x39}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0xD7, 0x3A}, {0xD7, 0x3B}, {0xD7, 0x3D}, /* 0x60-0x63 */
	{0xD7, 0x3E}, {0xD7, 0x3F}, {0xD7, 0x40}, {0xD7, 0x41}, /* 0x64-0x67 */
	{0xD7, 0x42}, {0xD7, 0x43}, {0xD7, 0x45}, {0xD7, 0x46}, /* 0x68-0x6B */
	{0xD7, 0x48}, {0xD7, 0x4A}, {0xD7, 0x4B}, {0xD7, 0x4C}, /* 0x6C-0x6F */
	{0xD7, 0x4D}, {0xD7, 0x4E}, {0xD7, 0x4F}, {0xD7, 0x52}, /* 0x70-0x73 */
	{0xD7, 0x53}, {0xD7, 0x55}, {0xD7, 0x5A}, {0xD7, 0x5B}, /* 0x74-0x77 */
	{0xD7, 0x5C}, {0xD7, 0x5D}, {0xD7, 0x5E}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0xD7, 0x5F}, {0xD7, 0x62}, {0xD7, 0x64}, /* 0x80-0x83 */
	{0xD7, 0x66}, {0xD7, 0x67}, {0xD7, 0x68}, {0xD7, 0x6A}, /* 0x84-0x87 */
	{0xD7, 0x6B}, {0xD7, 0x6D}, {0xD7, 0x6E}, {0xD7, 0x6F}, /* 0x88-0x8B */
	{0xD7, 0x71}, {0xD7, 0x72}, {0xD7, 0x73}, {0xD7, 0x75}, /* 0x8C-0x8F */
	{0xD7, 0x76}, {0xD7, 0x77}, {0xD7, 0x78}, {0xD7, 0x79}, /* 0x90-0x93 */
	{0xD7, 0x7A}, {0xD7, 0x7B}, {0xD7, 0x7E}, {0xD7, 0x7F}, /* 0x94-0x97 */
	{0xD7, 0x80}, {0xD7, 0x82}, {0xD7, 0x83}, {0xD7, 0x84}, /* 0x98-0x9B */
	{0xD7, 0x85}, {0xD7, 0x86}, {0xD7, 0x87}, {0xD7, 0x8A}, /* 0x9C-0x9F */
	{0xD7, 0x8B}, {0xD0, 0x44}, {0xD0, 0x45}, {0xD0, 0x47}, /* 0xA0-0xA3 */
	{0xD0, 0x49}, {0xD0, 0x50}, {0xD0, 0x54}, {0xD0, 0x58}, /* 0xA4-0xA7 */
	{0xD0, 0x60}, {0xD0, 0x6C}, {0xD0, 0x6D}, {0xD0, 0x70}, /* 0xA8-0xAB */
	{0xD0, 0x74}, {0xD0, 0x7C}, {0xD0, 0x7D}, {0xD0, 0x81}, /* 0xAC-0xAF */
	{0xD0, 0xA4}, {0xD0, 0xA5}, {0xD0, 0xA8}, {0xD0, 0xAC}, /* 0xB0-0xB3 */
	{0xD0, 0xB4}, {0xD0, 0xB5}, {0xD0, 0xB7}, {0xD0, 0xB9}, /* 0xB4-0xB7 */
	{0xD0, 0xC0}, {0xD0, 0xC1}, {0xD0, 0xC4}, {0xD0, 0xC8}, /* 0xB8-0xBB */
	{0xD0, 0xC9}, {0xD0, 0xD0}, {0xD0, 0xD1}, {0xD0, 0xD3}, /* 0xBC-0xBF */
	{0xD0, 0xD4}, {0xD0, 0xD5}, {0xD0, 0xDC}, {0xD0, 0xDD}, /* 0xC0-0xC3 */
	{0xD0, 0xE0}, {0xD0, 0xE4}, {0xD0, 0xEC}, {0xD0, 0xED}, /* 0xC4-0xC7 */
	{0xD0, 0xEF}, {0xD0, 0xF0}, {0xD0, 0xF1}, {0xD0, 0xF8}, /* 0xC8-0xCB */
	{0xD1, 0x0D}, {0xD1, 0x30}, {0xD1, 0x31}, {0xD1, 0x34}, /* 0xCC-0xCF */
	{0xD1, 0x38}, {0xD1, 0x3A}, {0xD1, 0x40}, {0xD1, 0x41}, /* 0xD0-0xD3 */
	{0xD1, 0x43}, {0xD1, 0x44}, {0xD1, 0x45}, {0xD1, 0x4C}, /* 0xD4-0xD7 */
	{0xD1, 0x4D}, {0xD1, 0x50}, {0xD1, 0x54}, {0xD1, 0x5C}, /* 0xD8-0xDB */
	{0xD1, 0x5D}, {0xD1, 0x5F}, {0xD1, 0x61}, {0xD1, 0x68}, /* 0xDC-0xDF */
	{0xD1, 0x6C}, {0xD1, 0x7C}, {0xD1, 0x84}, {0xD1, 0x88}, /* 0xE0-0xE3 */
	{0xD1, 0xA0}, {0xD1, 0xA1}, {0xD1, 0xA4}, {0xD1, 0xA8}, /* 0xE4-0xE7 */
	{0xD1, 0xB0}, {0xD1, 0xB1}, {0xD1, 0xB3}, {0xD1, 0xB5}, /* 0xE8-0xEB */
	{0xD1, 0xBA}, {0xD1, 0xBC}, {0xD1, 0xC0}, {0xD1, 0xD8}, /* 0xEC-0xEF */
	{0xD1, 0xF4}, {0xD1, 0xF8}, {0xD2, 0x07}, {0xD2, 0x09}, /* 0xF0-0xF3 */
	{0xD2, 0x10}, {0xD2, 0x2C}, {0xD2, 0x2D}, {0xD2, 0x30}, /* 0xF4-0xF7 */
	{0xD2, 0x34}, {0xD2, 0x3C}, {0xD2, 0x3D}, {0xD2, 0x3F}, /* 0xF8-0xFB */
	{0xD2, 0x41}, {0xD2, 0x48}, {0xD2, 0x5C}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_C6[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0xD7, 0x8D}, {0xD7, 0x8E}, {0xD7, 0x8F}, /* 0x40-0x43 */
	{0xD7, 0x91}, {0xD7, 0x92}, {0xD7, 0x93}, {0xD7, 0x94}, /* 0x44-0x47 */
	{0xD7, 0x95}, {0xD7, 0x96}, {0xD7, 0x97}, {0xD7, 0x9A}, /* 0x48-0x4B */
	{0xD7, 0x9C}, {0xD7, 0x9E}, {0xD7, 0x9F}, {0xD7, 0xA0}, /* 0x4C-0x4F */
	{0xD7, 0xA1}, {0xD7, 0xA2}, {0xD7, 0xA3}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0xD2, 0x64}, {0xD2, 0x80}, {0xD2, 0x81}, /* 0xA0-0xA3 */
	{0xD2, 0x84}, {0xD2, 0x88}, {0xD2, 0x90}, {0xD2, 0x91}, /* 0xA4-0xA7 */
	{0xD2, 0x95}, {0xD2, 0x9C}, {0xD2, 0xA0}, {0xD2, 0xA4}, /* 0xA8-0xAB */
	{0xD2, 0xAC}, {0xD2, 0xB1}, {0xD2, 0xB8}, {0xD2, 0xB9}, /* 0xAC-0xAF */
	{0xD2, 0xBC}, {0xD2, 0xBF}, {0xD2, 0xC0}, {0xD2, 0xC2}, /* 0xB0-0xB3 */
	{0xD2, 0xC8}, {0xD2, 0xC9}, {0xD2, 0xCB}, {0xD2, 0xD4}, /* 0xB4-0xB7 */
	{0xD2, 0xD8}, {0xD2, 0xDC}, {0xD2, 0xE4}, {0xD2, 0xE5}, /* 0xB8-0xBB */
	{0xD2, 0xF0}, {0xD2, 0xF1}, {0xD2, 0xF4}, {0xD2, 0xF8}, /* 0xBC-0xBF */
	{0xD3, 0x00}, {0xD3, 0x01}, {0xD3, 0x03}, {0xD3, 0x05}, /* 0xC0-0xC3 */
	{0xD3, 0x0C}, {0xD3, 0x0D}, {0xD3, 0x0E}, {0xD3, 0x10}, /* 0xC4-0xC7 */
	{0xD3, 0x14}, {0xD3, 0x16}, {0xD3, 0x1C}, {0xD3, 0x1D}, /* 0xC8-0xCB */
	{0xD3, 0x1F}, {0xD3, 0x20}, {0xD3, 0x21}, {0xD3, 0x25}, /* 0xCC-0xCF */
	{0xD3, 0x28}, {0xD3, 0x29}, {0xD3, 0x2C}, {0xD3, 0x30}, /* 0xD0-0xD3 */
	{0xD3, 0x38}, {0xD3, 0x39}, {0xD3, 0x3B}, {0xD3, 0x3C}, /* 0xD4-0xD7 */
	{0xD3, 0x3D}, {0xD3, 0x44}, {0xD3, 0x45}, {0xD3, 0x7C}, /* 0xD8-0xDB */
	{0xD3, 0x7D}, {0xD3, 0x80}, {0xD3, 0x84}, {0xD3, 0x8C}, /* 0xDC-0xDF */
	{0xD3, 0x8D}, {0xD3, 0x8F}, {0xD3, 0x90}, {0xD3, 0x91}, /* 0xE0-0xE3 */
	{0xD3, 0x98}, {0xD3, 0x99}, {0xD3, 0x9C}, {0xD3, 0xA0}, /* 0xE4-0xE7 */
	{0xD3, 0xA8}, {0xD3, 0xA9}, {0xD3, 0xAB}, {0xD3, 0xAD}, /* 0xE8-0xEB */
	{0xD3, 0xB4}, {0xD3, 0xB8}, {0xD3, 0xBC}, {0xD3, 0xC4}, /* 0xEC-0xEF */
	{0xD3, 0xC5}, {0xD3, 0xC8}, {0xD3, 0xC9}, {0xD3, 0xD0}, /* 0xF0-0xF3 */
	{0xD3, 0xD8}, {0xD3, 0xE1}, {0xD3, 0xE3}, {0xD3, 0xEC}, /* 0xF4-0xF7 */
	{0xD3, 0xED}, {0xD3, 0xF0}, {0xD3, 0xF4}, {0xD3, 0xFC}, /* 0xF8-0xFB */
	{0xD3, 0xFD}, {0xD3, 0xFF}, {0xD4, 0x01}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_C7[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0xD4, 0x08}, {0xD4, 0x1D}, {0xD4, 0x40}, /* 0xA0-0xA3 */
	{0xD4, 0x44}, {0xD4, 0x5C}, {0xD4, 0x60}, {0xD4, 0x64}, /* 0xA4-0xA7 */
	{0xD4, 0x6D}, {0xD4, 0x6F}, {0xD4, 0x78}, {0xD4, 0x79}, /* 0xA8-0xAB */
	{0xD4, 0x7C}, {0xD4, 0x7F}, {0xD4, 0x80}, {0xD4, 0x82}, /* 0xAC-0xAF */
	{0xD4, 0x88}, {0xD4, 0x89}, {0xD4, 0x8B}, {0xD4, 0x8D}, /* 0xB0-0xB3 */
	{0xD4, 0x94}, {0xD4, 0xA9}, {0xD4, 0xCC}, {0xD4, 0xD0}, /* 0xB4-0xB7 */
	{0xD4, 0xD4}, {0xD4, 0xDC}, {0xD4, 0xDF}, {0xD4, 0xE8}, /* 0xB8-0xBB */
	{0xD4, 0xEC}, {0xD4, 0xF0}, {0xD4, 0xF8}, {0xD4, 0xFB}, /* 0xBC-0xBF */
	{0xD4, 0xFD}, {0xD5, 0x04}, {0xD5, 0x08}, {0xD5, 0x0C}, /* 0xC0-0xC3 */
	{0xD5, 0x14}, {0xD5, 0x15}, {0xD5, 0x17}, {0xD5, 0x3C}, /* 0xC4-0xC7 */
	{0xD5, 0x3D}, {0xD5, 0x40}, {0xD5, 0x44}, {0xD5, 0x4C}, /* 0xC8-0xCB */
	{0xD5, 0x4D}, {0xD5, 0x4F}, {0xD5, 0x51}, {0xD5, 0x58}, /* 0xCC-0xCF */
	{0xD5, 0x59}, {0xD5, 0x5C}, {0xD5, 0x60}, {0xD5, 0x65}, /* 0xD0-0xD3 */
	{0xD5, 0x68}, {0xD5, 0x69}, {0xD5, 0x6B}, {0xD5, 0x6D}, /* 0xD4-0xD7 */
	{0xD5, 0x74}, {0xD5, 0x75}, {0xD5, 0x78}, {0xD5, 0x7C}, /* 0xD8-0xDB */
	{0xD5, 0x84}, {0xD5, 0x85}, {0xD5, 0x87}, {0xD5, 0x88}, /* 0xDC-0xDF */
	{0xD5, 0x89}, {0xD5, 0x90}, {0xD5, 0xA5}, {0xD5, 0xC8}, /* 0xE0-0xE3 */
	{0xD5, 0xC9}, {0xD5, 0xCC}, {0xD5, 0xD0}, {0xD5, 0xD2}, /* 0xE4-0xE7 */
	{0xD5, 0xD8}, {0xD5, 0xD9}, {0xD5, 0xDB}, {0xD5, 0xDD}, /* 0xE8-0xEB */
	{0xD5, 0xE4}, {0xD5, 0xE5}, {0xD5, 0xE8}, {0xD5, 0xEC}, /* 0xEC-0xEF */
	{0xD5, 0xF4}, {0xD5, 0xF5}, {0xD5, 0xF7}, {0xD5, 0xF9}, /* 0xF0-0xF3 */
	{0xD6, 0x00}, {0xD6, 0x01}, {0xD6, 0x04}, {0xD6, 0x08}, /* 0xF4-0xF7 */
	{0xD6, 0x10}, {0xD6, 0x11}, {0xD6, 0x13}, {0xD6, 0x14}, /* 0xF8-0xFB */
	{0xD6, 0x15}, {0xD6, 0x1C}, {0xD6, 0x20}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_C8[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0xD6, 0x24}, {0xD6, 0x2D}, {0xD6, 0x38}, /* 0xA0-0xA3 */
	{0xD6, 0x39}, {0xD6, 0x3C}, {0xD6, 0x40}, {0xD6, 0x45}, /* 0xA4-0xA7 */
	{0xD6, 0x48}, {0xD6, 0x49}, {0xD6, 0x4B}, {0xD6, 0x4D}, /* 0xA8-0xAB */
	{0xD6, 0x51}, {0xD6, 0x54}, {0xD6, 0x55}, {0xD6, 0x58}, /* 0xAC-0xAF */
	{0xD6, 0x5C}, {0xD6, 0x67}, {0xD6, 0x69}, {0xD6, 0x70}, /* 0xB0-0xB3 */
	{0xD6, 0x71}, {0xD6, 0x74}, {0xD6, 0x83}, {0xD6, 0x85}, /* 0xB4-0xB7 */
	{0xD6, 0x8C}, {0xD6, 0x8D}, {0xD6, 0x90}, {0xD6, 0x94}, /* 0xB8-0xBB */
	{0xD6, 0x9D}, {0xD6, 0x9F}, {0xD6, 0xA1}, {0xD6, 0xA8}, /* 0xBC-0xBF */
	{0xD6, 0xAC}, {0xD6, 0xB0}, {0xD6, 0xB9}, {0xD6, 0xBB}, /* 0xC0-0xC3 */
	{0xD6, 0xC4}, {0xD6, 0xC5}, {0xD6, 0xC8}, {0xD6, 0xCC}, /* 0xC4-0xC7 */
	{0xD6, 0xD1}, {0xD6, 0xD4}, {0xD6, 0xD7}, {0xD6, 0xD9}, /* 0xC8-0xCB */
	{0xD6, 0xE0}, {0xD6, 0xE4}, {0xD6, 0xE8}, {0xD6, 0xF0}, /* 0xCC-0xCF */
	{0xD6, 0xF5}, {0xD6, 0xFC}, {0xD6, 0xFD}, {0xD7, 0x00}, /* 0xD0-0xD3 */
	{0xD7, 0x04}, {0xD7, 0x11}, {0xD7, 0x18}, {0xD7, 0x19}, /* 0xD4-0xD7 */
	{0xD7, 0x1C}, {0xD7, 0x20}, {0xD7, 0x28}, {0xD7, 0x29}, /* 0xD8-0xDB */
	{0xD7, 0x2B}, {0xD7, 0x2D}, {0xD7, 0x34}, {0xD7, 0x35}, /* 0xDC-0xDF */
	{0xD7, 0x38}, {0xD7, 0x3C}, {0xD7, 0x44}, {0xD7, 0x47}, /* 0xE0-0xE3 */
	{0xD7, 0x49}, {0xD7, 0x50}, {0xD7, 0x51}, {0xD7, 0x54}, /* 0xE4-0xE7 */
	{0xD7, 0x56}, {0xD7, 0x57}, {0xD7, 0x58}, {0xD7, 0x59}, /* 0xE8-0xEB */
	{0xD7, 0x60}, {0xD7, 0x61}, {0xD7, 0x63}, {0xD7, 0x65}, /* 0xEC-0xEF */
	{0xD7, 0x69}, {0xD7, 0x6C}, {0xD7, 0x70}, {0xD7, 0x74}, /* 0xF0-0xF3 */
	{0xD7, 0x7C}, {0xD7, 0x7D}, {0xD7, 0x81}, {0xD7, 0x88}, /* 0xF4-0xF7 */
	{0xD7, 0x89}, {0xD7, 0x8C}, {0xD7, 0x90}, {0xD7, 0x98}, /* 0xF8-0xFB */
	{0xD7, 0x99}, {0xD7, 0x9B}, {0xD7, 0x9D}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_CA[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x4F, 0x3D}, {0x4F, 0x73}, {0x50, 0x47}, /* 0xA0-0xA3 */
	{0x50, 0xF9}, {0x52, 0xA0}, {0x53, 0xEF}, {0x54, 0x75}, /* 0xA4-0xA7 */
	{0x54, 0xE5}, {0x56, 0x09}, {0x5A, 0xC1}, {0x5B, 0xB6}, /* 0xA8-0xAB */
	{0x66, 0x87}, {0x67, 0xB6}, {0x67, 0xB7}, {0x67, 0xEF}, /* 0xAC-0xAF */
	{0x6B, 0x4C}, {0x73, 0xC2}, {0x75, 0xC2}, {0x7A, 0x3C}, /* 0xB0-0xB3 */
	{0x82, 0xDB}, {0x83, 0x04}, {0x88, 0x57}, {0x88, 0x88}, /* 0xB4-0xB7 */
	{0x8A, 0x36}, {0x8C, 0xC8}, {0x8D, 0xCF}, {0x8E, 0xFB}, /* 0xB8-0xBB */
	{0x8F, 0xE6}, {0x99, 0xD5}, {0x52, 0x3B}, {0x53, 0x74}, /* 0xBC-0xBF */
	{0x54, 0x04}, {0x60, 0x6A}, {0x61, 0x64}, {0x6B, 0xBC}, /* 0xC0-0xC3 */
	{0x73, 0xCF}, {0x81, 0x1A}, {0x89, 0xBA}, {0x89, 0xD2}, /* 0xC4-0xC7 */
	{0x95, 0xA3}, {0x4F, 0x83}, {0x52, 0x0A}, {0x58, 0xBE}, /* 0xC8-0xCB */
	{0x59, 0x78}, {0x59, 0xE6}, {0x5E, 0x72}, {0x5E, 0x79}, /* 0xCC-0xCF */
	{0x61, 0xC7}, {0x63, 0xC0}, {0x67, 0x46}, {0x67, 0xEC}, /* 0xD0-0xD3 */
	{0x68, 0x7F}, {0x6F, 0x97}, {0x76, 0x4E}, {0x77, 0x0B}, /* 0xD4-0xD7 */
	{0x78, 0xF5}, {0x7A, 0x08}, {0x7A, 0xFF}, {0x7C, 0x21}, /* 0xD8-0xDB */
	{0x80, 0x9D}, {0x82, 0x6E}, {0x82, 0x71}, {0x8A, 0xEB}, /* 0xDC-0xDF */
	{0x95, 0x93}, {0x4E, 0x6B}, {0x55, 0x9D}, {0x66, 0xF7}, /* 0xE0-0xE3 */
	{0x6E, 0x34}, {0x78, 0xA3}, {0x7A, 0xED}, {0x84, 0x5B}, /* 0xE4-0xE7 */
	{0x89, 0x10}, {0x87, 0x4E}, {0x97, 0xA8}, {0x52, 0xD8}, /* 0xE8-0xEB */
	{0x57, 0x4E}, {0x58, 0x2A}, {0x5D, 0x4C}, {0x61, 0x1F}, /* 0xEC-0xEF */
	{0x61, 0xBE}, {0x62, 0x21}, {0x65, 0x62}, {0x67, 0xD1}, /* 0xF0-0xF3 */
	{0x6A, 0x44}, {0x6E, 0x1B}, {0x75, 0x18}, {0x75, 0xB3}, /* 0xF4-0xF7 */
	{0x76, 0xE3}, {0x77, 0xB0}, {0x7D, 0x3A}, {0x90, 0xAF}, /* 0xF8-0xFB */
	{0x94, 0x51}, {0x94, 0x52}, {0x9F, 0x95}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_CB[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x53, 0x23}, {0x5C, 0xAC}, {0x75, 0x32}, /* 0xA0-0xA3 */
	{0x80, 0xDB}, {0x92, 0x40}, {0x95, 0x98}, {0x52, 0x5B}, /* 0xA4-0xA7 */
	{0x58, 0x08}, {0x59, 0xDC}, {0x5C, 0xA1}, {0x5D, 0x17}, /* 0xA8-0xAB */
	{0x5E, 0xB7}, {0x5F, 0x3A}, {0x5F, 0x4A}, {0x61, 0x77}, /* 0xAC-0xAF */
	{0x6C, 0x5F}, {0x75, 0x7A}, {0x75, 0x86}, {0x7C, 0xE0}, /* 0xB0-0xB3 */
	{0x7D, 0x73}, {0x7D, 0xB1}, {0x7F, 0x8C}, {0x81, 0x54}, /* 0xB4-0xB7 */
	{0x82, 0x21}, {0x85, 0x91}, {0x89, 0x41}, {0x8B, 0x1B}, /* 0xB8-0xBB */
	{0x92, 0xFC}, {0x96, 0x4D}, {0x9C, 0x47}, {0x4E, 0xCB}, /* 0xBC-0xBF */
	{0x4E, 0xF7}, {0x50, 0x0B}, {0x51, 0xF1}, {0x58, 0x4F}, /* 0xC0-0xC3 */
	{0x61, 0x37}, {0x61, 0x3E}, {0x61, 0x68}, {0x65, 0x39}, /* 0xC4-0xC7 */
	{0x69, 0xEA}, {0x6F, 0x11}, {0x75, 0xA5}, {0x76, 0x86}, /* 0xC8-0xCB */
	{0x76, 0xD6}, {0x7B, 0x87}, {0x82, 0xA5}, {0x84, 0xCB}, /* 0xCC-0xCF */
	{0xF9, 0x00}, {0x93, 0xA7}, {0x95, 0x8B}, {0x55, 0x80}, /* 0xD0-0xD3 */
	{0x5B, 0xA2}, {0x57, 0x51}, {0xF9, 0x01}, {0x7C, 0xB3}, /* 0xD4-0xD7 */
	{0x7F, 0xB9}, {0x91, 0xB5}, {0x50, 0x28}, {0x53, 0xBB}, /* 0xD8-0xDB */
	{0x5C, 0x45}, {0x5D, 0xE8}, {0x62, 0xD2}, {0x63, 0x6E}, /* 0xDC-0xDF */
	{0x64, 0xDA}, {0x64, 0xE7}, {0x6E, 0x20}, {0x70, 0xAC}, /* 0xE0-0xE3 */
	{0x79, 0x5B}, {0x8D, 0xDD}, {0x8E, 0x1E}, {0xF9, 0x02}, /* 0xE4-0xE7 */
	{0x90, 0x7D}, {0x92, 0x45}, {0x92, 0xF8}, {0x4E, 0x7E}, /* 0xE8-0xEB */
	{0x4E, 0xF6}, {0x50, 0x65}, {0x5D, 0xFE}, {0x5E, 0xFA}, /* 0xEC-0xEF */
	{0x61, 0x06}, {0x69, 0x57}, {0x81, 0x71}, {0x86, 0x54}, /* 0xF0-0xF3 */
	{0x8E, 0x47}, {0x93, 0x75}, {0x9A, 0x2B}, {0x4E, 0x5E}, /* 0xF4-0xF7 */
	{0x50, 0x91}, {0x67, 0x70}, {0x68, 0x40}, {0x51, 0x09}, /* 0xF8-0xFB */
	{0x52, 0x8D}, {0x52, 0x92}, {0x6A, 0xA2}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_CC[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x77, 0xBC}, {0x92, 0x10}, {0x9E, 0xD4}, /* 0xA0-0xA3 */
	{0x52, 0xAB}, {0x60, 0x2F}, {0x8F, 0xF2}, {0x50, 0x48}, /* 0xA4-0xA7 */
	{0x61, 0xA9}, {0x63, 0xED}, {0x64, 0xCA}, {0x68, 0x3C}, /* 0xA8-0xAB */
	{0x6A, 0x84}, {0x6F, 0xC0}, {0x81, 0x88}, {0x89, 0xA1}, /* 0xAC-0xAF */
	{0x96, 0x94}, {0x58, 0x05}, {0x72, 0x7D}, {0x72, 0xAC}, /* 0xB0-0xB3 */
	{0x75, 0x04}, {0x7D, 0x79}, {0x7E, 0x6D}, {0x80, 0xA9}, /* 0xB4-0xB7 */
	{0x89, 0x8B}, {0x8B, 0x74}, {0x90, 0x63}, {0x9D, 0x51}, /* 0xB8-0xBB */
	{0x62, 0x89}, {0x6C, 0x7A}, {0x6F, 0x54}, {0x7D, 0x50}, /* 0xBC-0xBF */
	{0x7F, 0x3A}, {0x8A, 0x23}, {0x51, 0x7C}, {0x61, 0x4A}, /* 0xC0-0xC3 */
	{0x7B, 0x9D}, {0x8B, 0x19}, {0x92, 0x57}, {0x93, 0x8C}, /* 0xC4-0xC7 */
	{0x4E, 0xAC}, {0x4F, 0xD3}, {0x50, 0x1E}, {0x50, 0xBE}, /* 0xC8-0xCB */
	{0x51, 0x06}, {0x52, 0xC1}, {0x52, 0xCD}, {0x53, 0x7F}, /* 0xCC-0xCF */
	{0x57, 0x70}, {0x58, 0x83}, {0x5E, 0x9A}, {0x5F, 0x91}, /* 0xD0-0xD3 */
	{0x61, 0x76}, {0x61, 0xAC}, {0x64, 0xCE}, {0x65, 0x6C}, /* 0xD4-0xD7 */
	{0x66, 0x6F}, {0x66, 0xBB}, {0x66, 0xF4}, {0x68, 0x97}, /* 0xD8-0xDB */
	{0x6D, 0x87}, {0x70, 0x85}, {0x70, 0xF1}, {0x74, 0x9F}, /* 0xDC-0xDF */
	{0x74, 0xA5}, {0x74, 0xCA}, {0x75, 0xD9}, {0x78, 0x6C}, /* 0xE0-0xE3 */
	{0x78, 0xEC}, {0x7A, 0xDF}, {0x7A, 0xF6}, {0x7D, 0x45}, /* 0xE4-0xE7 */
	{0x7D, 0x93}, {0x80, 0x15}, {0x80, 0x3F}, {0x81, 0x1B}, /* 0xE8-0xEB */
	{0x83, 0x96}, {0x8B, 0x66}, {0x8F, 0x15}, {0x90, 0x15}, /* 0xEC-0xEF */
	{0x93, 0xE1}, {0x98, 0x03}, {0x98, 0x38}, {0x9A, 0x5A}, /* 0xF0-0xF3 */
	{0x9B, 0xE8}, {0x4F, 0xC2}, {0x55, 0x53}, {0x58, 0x3A}, /* 0xF4-0xF7 */
	{0x59, 0x51}, {0x5B, 0x63}, {0x5C, 0x46}, {0x60, 0xB8}, /* 0xF8-0xFB */
	{0x62, 0x12}, {0x68, 0x42}, {0x68, 0xB0}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_CD[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x68, 0xE8}, {0x6E, 0xAA}, {0x75, 0x4C}, /* 0xA0-0xA3 */
	{0x76, 0x78}, {0x78, 0xCE}, {0x7A, 0x3D}, {0x7C, 0xFB}, /* 0xA4-0xA7 */
	{0x7E, 0x6B}, {0x7E, 0x7C}, {0x8A, 0x08}, {0x8A, 0xA1}, /* 0xA8-0xAB */
	{0x8C, 0x3F}, {0x96, 0x8E}, {0x9D, 0xC4}, {0x53, 0xE4}, /* 0xAC-0xAF */
	{0x53, 0xE9}, {0x54, 0x4A}, {0x54, 0x71}, {0x56, 0xFA}, /* 0xB0-0xB3 */
	{0x59, 0xD1}, {0x5B, 0x64}, {0x5C, 0x3B}, {0x5E, 0xAB}, /* 0xB4-0xB7 */
	{0x62, 0xF7}, {0x65, 0x37}, {0x65, 0x45}, {0x65, 0x72}, /* 0xB8-0xBB */
	{0x66, 0xA0}, {0x67, 0xAF}, {0x69, 0xC1}, {0x6C, 0xBD}, /* 0xBC-0xBF */
	{0x75, 0xFC}, {0x76, 0x90}, {0x77, 0x7E}, {0x7A, 0x3F}, /* 0xC0-0xC3 */
	{0x7F, 0x94}, {0x80, 0x03}, {0x80, 0xA1}, {0x81, 0x8F}, /* 0xC4-0xC7 */
	{0x82, 0xE6}, {0x82, 0xFD}, {0x83, 0xF0}, {0x85, 0xC1}, /* 0xC8-0xCB */
	{0x88, 0x31}, {0x88, 0xB4}, {0x8A, 0xA5}, {0xF9, 0x03}, /* 0xCC-0xCF */
	{0x8F, 0x9C}, {0x93, 0x2E}, {0x96, 0xC7}, {0x98, 0x67}, /* 0xD0-0xD3 */
	{0x9A, 0xD8}, {0x9F, 0x13}, {0x54, 0xED}, {0x65, 0x9B}, /* 0xD4-0xD7 */
	{0x66, 0xF2}, {0x68, 0x8F}, {0x7A, 0x40}, {0x8C, 0x37}, /* 0xD8-0xDB */
	{0x9D, 0x60}, {0x56, 0xF0}, {0x57, 0x64}, {0x5D, 0x11}, /* 0xDC-0xDF */
	{0x66, 0x06}, {0x68, 0xB1}, {0x68, 0xCD}, {0x6E, 0xFE}, /* 0xE0-0xE3 */
	{0x74, 0x28}, {0x88, 0x9E}, {0x9B, 0xE4}, {0x6C, 0x68}, /* 0xE4-0xE7 */
	{0xF9, 0x04}, {0x9A, 0xA8}, {0x4F, 0x9B}, {0x51, 0x6C}, /* 0xE8-0xEB */
	{0x51, 0x71}, {0x52, 0x9F}, {0x5B, 0x54}, {0x5D, 0xE5}, /* 0xEC-0xEF */
	{0x60, 0x50}, {0x60, 0x6D}, {0x62, 0xF1}, {0x63, 0xA7}, /* 0xF0-0xF3 */
	{0x65, 0x3B}, {0x73, 0xD9}, {0x7A, 0x7A}, {0x86, 0xA3}, /* 0xF4-0xF7 */
	{0x8C, 0xA2}, {0x97, 0x8F}, {0x4E, 0x32}, {0x5B, 0xE1}, /* 0xF8-0xFB */
	{0x62, 0x08}, {0x67, 0x9C}, {0x74, 0xDC}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_CE[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x79, 0xD1}, {0x83, 0xD3}, {0x8A, 0x87}, /* 0xA0-0xA3 */
	{0x8A, 0xB2}, {0x8D, 0xE8}, {0x90, 0x4E}, {0x93, 0x4B}, /* 0xA4-0xA7 */
	{0x98, 0x46}, {0x5E, 0xD3}, {0x69, 0xE8}, {0x85, 0xFF}, /* 0xA8-0xAB */
	{0x90, 0xED}, {0xF9, 0x05}, {0x51, 0xA0}, {0x5B, 0x98}, /* 0xAC-0xAF */
	{0x5B, 0xEC}, {0x61, 0x63}, {0x68, 0xFA}, {0x6B, 0x3E}, /* 0xB0-0xB3 */
	{0x70, 0x4C}, {0x74, 0x2F}, {0x74, 0xD8}, {0x7B, 0xA1}, /* 0xB4-0xB7 */
	{0x7F, 0x50}, {0x83, 0xC5}, {0x89, 0xC0}, {0x8C, 0xAB}, /* 0xB8-0xBB */
	{0x95, 0xDC}, {0xFA, 0x2C}, {0x52, 0x2E}, {0x60, 0x5D}, /* 0xBC-0xBF */
	{0x62, 0xEC}, {0x90, 0x02}, {0x4F, 0x8A}, {0x51, 0x49}, /* 0xC0-0xC3 */
	{0x53, 0x21}, {0x58, 0xD9}, {0x5E, 0xE3}, {0x66, 0xE0}, /* 0xC4-0xC7 */
	{0x6D, 0x38}, {0x70, 0x9A}, {0x72, 0xC2}, {0x73, 0xD6}, /* 0xC8-0xCB */
	{0x7B, 0x50}, {0x80, 0xF1}, {0x94, 0x5B}, {0x53, 0x66}, /* 0xCC-0xCF */
	{0x63, 0x9B}, {0x7F, 0x6B}, {0x4E, 0x56}, {0x50, 0x80}, /* 0xD0-0xD3 */
	{0x58, 0x4A}, {0x58, 0xDE}, {0x60, 0x2A}, {0x61, 0x27}, /* 0xD4-0xD7 */
	{0x62, 0xD0}, {0x69, 0xD0}, {0x9B, 0x41}, {0x5B, 0x8F}, /* 0xD8-0xDB */
	{0x7D, 0x18}, {0x80, 0xB1}, {0x8F, 0x5F}, {0x4E, 0xA4}, /* 0xDC-0xDF */
	{0x50, 0xD1}, {0x54, 0xAC}, {0x55, 0xAC}, {0x5B, 0x0C}, /* 0xE0-0xE3 */
	{0x5D, 0xA0}, {0x5D, 0xE7}, {0x65, 0x2A}, {0x65, 0x4E}, /* 0xE4-0xE7 */
	{0x68, 0x21}, {0x6A, 0x4B}, {0x72, 0xE1}, {0x76, 0x8E}, /* 0xE8-0xEB */
	{0x77, 0xEF}, {0x7D, 0x5E}, {0x7F, 0xF9}, {0x81, 0xA0}, /* 0xEC-0xEF */
	{0x85, 0x4E}, {0x86, 0xDF}, {0x8F, 0x03}, {0x8F, 0x4E}, /* 0xF0-0xF3 */
	{0x90, 0xCA}, {0x99, 0x03}, {0x9A, 0x55}, {0x9B, 0xAB}, /* 0xF4-0xF7 */
	{0x4E, 0x18}, {0x4E, 0x45}, {0x4E, 0x5D}, {0x4E, 0xC7}, /* 0xF8-0xFB */
	{0x4F, 0xF1}, {0x51, 0x77}, {0x52, 0xFE}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_CF[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x53, 0x40}, {0x53, 0xE3}, {0x53, 0xE5}, /* 0xA0-0xA3 */
	{0x54, 0x8E}, {0x56, 0x14}, {0x57, 0x75}, {0x57, 0xA2}, /* 0xA4-0xA7 */
	{0x5B, 0xC7}, {0x5D, 0x87}, {0x5E, 0xD0}, {0x61, 0xFC}, /* 0xA8-0xAB */
	{0x62, 0xD8}, {0x65, 0x51}, {0x67, 0xB8}, {0x67, 0xE9}, /* 0xAC-0xAF */
	{0x69, 0xCB}, {0x6B, 0x50}, {0x6B, 0xC6}, {0x6B, 0xEC}, /* 0xB0-0xB3 */
	{0x6C, 0x42}, {0x6E, 0x9D}, {0x70, 0x78}, {0x72, 0xD7}, /* 0xB4-0xB7 */
	{0x73, 0x96}, {0x74, 0x03}, {0x77, 0xBF}, {0x77, 0xE9}, /* 0xB8-0xBB */
	{0x7A, 0x76}, {0x7D, 0x7F}, {0x80, 0x09}, {0x81, 0xFC}, /* 0xBC-0xBF */
	{0x82, 0x05}, {0x82, 0x0A}, {0x82, 0xDF}, {0x88, 0x62}, /* 0xC0-0xC3 */
	{0x8B, 0x33}, {0x8C, 0xFC}, {0x8E, 0xC0}, {0x90, 0x11}, /* 0xC4-0xC7 */
	{0x90, 0xB1}, {0x92, 0x64}, {0x92, 0xB6}, {0x99, 0xD2}, /* 0xC8-0xCB */
	{0x9A, 0x45}, {0x9C, 0xE9}, {0x9D, 0xD7}, {0x9F, 0x9C}, /* 0xCC-0xCF */
	{0x57, 0x0B}, {0x5C, 0x40}, {0x83, 0xCA}, {0x97, 0xA0}, /* 0xD0-0xD3 */
	{0x97, 0xAB}, {0x9E, 0xB4}, {0x54, 0x1B}, {0x7A, 0x98}, /* 0xD4-0xD7 */
	{0x7F, 0xA4}, {0x88, 0xD9}, {0x8E, 0xCD}, {0x90, 0xE1}, /* 0xD8-0xDB */
	{0x58, 0x00}, {0x5C, 0x48}, {0x63, 0x98}, {0x7A, 0x9F}, /* 0xDC-0xDF */
	{0x5B, 0xAE}, {0x5F, 0x13}, {0x7A, 0x79}, {0x7A, 0xAE}, /* 0xE0-0xE3 */
	{0x82, 0x8E}, {0x8E, 0xAC}, {0x50, 0x26}, {0x52, 0x38}, /* 0xE4-0xE7 */
	{0x52, 0xF8}, {0x53, 0x77}, {0x57, 0x08}, {0x62, 0xF3}, /* 0xE8-0xEB */
	{0x63, 0x72}, {0x6B, 0x0A}, {0x6D, 0xC3}, {0x77, 0x37}, /* 0xEC-0xEF */
	{0x53, 0xA5}, {0x73, 0x57}, {0x85, 0x68}, {0x8E, 0x76}, /* 0xF0-0xF3 */
	{0x95, 0xD5}, {0x67, 0x3A}, {0x6A, 0xC3}, {0x6F, 0x70}, /* 0xF4-0xF7 */
	{0x8A, 0x6D}, {0x8E, 0xCC}, {0x99, 0x4B}, {0xF9, 0x06}, /* 0xF8-0xFB */
	{0x66, 0x77}, {0x6B, 0x78}, {0x8C, 0xB4}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_D0[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x9B, 0x3C}, {0xF9, 0x07}, {0x53, 0xEB}, /* 0xA0-0xA3 */
	{0x57, 0x2D}, {0x59, 0x4E}, {0x63, 0xC6}, {0x69, 0xFB}, /* 0xA4-0xA7 */
	{0x73, 0xEA}, {0x78, 0x45}, {0x7A, 0xBA}, {0x7A, 0xC5}, /* 0xA8-0xAB */
	{0x7C, 0xFE}, {0x84, 0x75}, {0x89, 0x8F}, {0x8D, 0x73}, /* 0xAC-0xAF */
	{0x90, 0x35}, {0x95, 0xA8}, {0x52, 0xFB}, {0x57, 0x47}, /* 0xB0-0xB3 */
	{0x75, 0x47}, {0x7B, 0x60}, {0x83, 0xCC}, {0x92, 0x1E}, /* 0xB4-0xB7 */
	{0xF9, 0x08}, {0x6A, 0x58}, {0x51, 0x4B}, {0x52, 0x4B}, /* 0xB8-0xBB */
	{0x52, 0x87}, {0x62, 0x1F}, {0x68, 0xD8}, {0x69, 0x75}, /* 0xBC-0xBF */
	{0x96, 0x99}, {0x50, 0xC5}, {0x52, 0xA4}, {0x52, 0xE4}, /* 0xC0-0xC3 */
	{0x61, 0xC3}, {0x65, 0xA4}, {0x68, 0x39}, {0x69, 0xFF}, /* 0xC4-0xC7 */
	{0x74, 0x7E}, {0x7B, 0x4B}, {0x82, 0xB9}, {0x83, 0xEB}, /* 0xC8-0xCB */
	{0x89, 0xB2}, {0x8B, 0x39}, {0x8F, 0xD1}, {0x99, 0x49}, /* 0xCC-0xCF */
	{0xF9, 0x09}, {0x4E, 0xCA}, {0x59, 0x97}, {0x64, 0xD2}, /* 0xD0-0xD3 */
	{0x66, 0x11}, {0x6A, 0x8E}, {0x74, 0x34}, {0x79, 0x81}, /* 0xD4-0xD7 */
	{0x79, 0xBD}, {0x82, 0xA9}, {0x88, 0x7E}, {0x88, 0x7F}, /* 0xD8-0xDB */
	{0x89, 0x5F}, {0xF9, 0x0A}, {0x93, 0x26}, {0x4F, 0x0B}, /* 0xDC-0xDF */
	{0x53, 0xCA}, {0x60, 0x25}, {0x62, 0x71}, {0x6C, 0x72}, /* 0xE0-0xE3 */
	{0x7D, 0x1A}, {0x7D, 0x66}, {0x4E, 0x98}, {0x51, 0x62}, /* 0xE4-0xE7 */
	{0x77, 0xDC}, {0x80, 0xAF}, {0x4F, 0x01}, {0x4F, 0x0E}, /* 0xE8-0xEB */
	{0x51, 0x76}, {0x51, 0x80}, {0x55, 0xDC}, {0x56, 0x68}, /* 0xEC-0xEF */
	{0x57, 0x3B}, {0x57, 0xFA}, {0x57, 0xFC}, {0x59, 0x14}, /* 0xF0-0xF3 */
	{0x59, 0x47}, {0x59, 0x93}, {0x5B, 0xC4}, {0x5C, 0x90}, /* 0xF4-0xF7 */
	{0x5D, 0x0E}, {0x5D, 0xF1}, {0x5E, 0x7E}, {0x5F, 0xCC}, /* 0xF8-0xFB */
	{0x62, 0x80}, {0x65, 0xD7}, {0x65, 0xE3}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_D1[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x67, 0x1E}, {0x67, 0x1F}, {0x67, 0x5E}, /* 0xA0-0xA3 */
	{0x68, 0xCB}, {0x68, 0xC4}, {0x6A, 0x5F}, {0x6B, 0x3A}, /* 0xA4-0xA7 */
	{0x6C, 0x23}, {0x6C, 0x7D}, {0x6C, 0x82}, {0x6D, 0xC7}, /* 0xA8-0xAB */
	{0x73, 0x98}, {0x74, 0x26}, {0x74, 0x2A}, {0x74, 0x82}, /* 0xAC-0xAF */
	{0x74, 0xA3}, {0x75, 0x78}, {0x75, 0x7F}, {0x78, 0x81}, /* 0xB0-0xB3 */
	{0x78, 0xEF}, {0x79, 0x41}, {0x79, 0x47}, {0x79, 0x48}, /* 0xB4-0xB7 */
	{0x79, 0x7A}, {0x7B, 0x95}, {0x7D, 0x00}, {0x7D, 0xBA}, /* 0xB8-0xBB */
	{0x7F, 0x88}, {0x80, 0x06}, {0x80, 0x2D}, {0x80, 0x8C}, /* 0xBC-0xBF */
	{0x8A, 0x18}, {0x8B, 0x4F}, {0x8C, 0x48}, {0x8D, 0x77}, /* 0xC0-0xC3 */
	{0x93, 0x21}, {0x93, 0x24}, {0x98, 0xE2}, {0x99, 0x51}, /* 0xC4-0xC7 */
	{0x9A, 0x0E}, {0x9A, 0x0F}, {0x9A, 0x65}, {0x9E, 0x92}, /* 0xC8-0xCB */
	{0x7D, 0xCA}, {0x4F, 0x76}, {0x54, 0x09}, {0x62, 0xEE}, /* 0xCC-0xCF */
	{0x68, 0x54}, {0x91, 0xD1}, {0x55, 0xAB}, {0x51, 0x3A}, /* 0xD0-0xD3 */
	{0xF9, 0x0B}, {0xF9, 0x0C}, {0x5A, 0x1C}, {0x61, 0xE6}, /* 0xD4-0xD7 */
	{0xF9, 0x0D}, {0x62, 0xCF}, {0x62, 0xFF}, {0xF9, 0x0E}, /* 0xD8-0xDB */
	{0xF9, 0x0F}, {0xF9, 0x10}, {0xF9, 0x11}, {0xF9, 0x12}, /* 0xDC-0xDF */
	{0xF9, 0x13}, {0x90, 0xA3}, {0xF9, 0x14}, {0xF9, 0x15}, /* 0xE0-0xE3 */
	{0xF9, 0x16}, {0xF9, 0x17}, {0xF9, 0x18}, {0x8A, 0xFE}, /* 0xE4-0xE7 */
	{0xF9, 0x19}, {0xF9, 0x1A}, {0xF9, 0x1B}, {0xF9, 0x1C}, /* 0xE8-0xEB */
	{0x66, 0x96}, {0xF9, 0x1D}, {0x71, 0x56}, {0xF9, 0x1E}, /* 0xEC-0xEF */
	{0xF9, 0x1F}, {0x96, 0xE3}, {0xF9, 0x20}, {0x63, 0x4F}, /* 0xF0-0xF3 */
	{0x63, 0x7A}, {0x53, 0x57}, {0xF9, 0x21}, {0x67, 0x8F}, /* 0xF4-0xF7 */
	{0x69, 0x60}, {0x6E, 0x73}, {0xF9, 0x22}, {0x75, 0x37}, /* 0xF8-0xFB */
	{0xF9, 0x23}, {0xF9, 0x24}, {0xF9, 0x25}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_D2[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x7D, 0x0D}, {0xF9, 0x26}, {0xF9, 0x27}, /* 0xA0-0xA3 */
	{0x88, 0x72}, {0x56, 0xCA}, {0x5A, 0x18}, {0xF9, 0x28}, /* 0xA4-0xA7 */
	{0xF9, 0x29}, {0xF9, 0x2A}, {0xF9, 0x2B}, {0xF9, 0x2C}, /* 0xA8-0xAB */
	{0x4E, 0x43}, {0xF9, 0x2D}, {0x51, 0x67}, {0x59, 0x48}, /* 0xAC-0xAF */
	{0x67, 0xF0}, {0x80, 0x10}, {0xF9, 0x2E}, {0x59, 0x73}, /* 0xB0-0xB3 */
	{0x5E, 0x74}, {0x64, 0x9A}, {0x79, 0xCA}, {0x5F, 0xF5}, /* 0xB4-0xB7 */
	{0x60, 0x6C}, {0x62, 0xC8}, {0x63, 0x7B}, {0x5B, 0xE7}, /* 0xB8-0xBB */
	{0x5B, 0xD7}, {0x52, 0xAA}, {0xF9, 0x2F}, {0x59, 0x74}, /* 0xBC-0xBF */
	{0x5F, 0x29}, {0x60, 0x12}, {0xF9, 0x30}, {0xF9, 0x31}, /* 0xC0-0xC3 */
	{0xF9, 0x32}, {0x74, 0x59}, {0xF9, 0x33}, {0xF9, 0x34}, /* 0xC4-0xC7 */
	{0xF9, 0x35}, {0xF9, 0x36}, {0xF9, 0x37}, {0xF9, 0x38}, /* 0xC8-0xCB */
	{0x99, 0xD1}, {0xF9, 0x39}, {0xF9, 0x3A}, {0xF9, 0x3B}, /* 0xCC-0xCF */
	{0xF9, 0x3C}, {0xF9, 0x3D}, {0xF9, 0x3E}, {0xF9, 0x3F}, /* 0xD0-0xD3 */
	{0xF9, 0x40}, {0xF9, 0x41}, {0xF9, 0x42}, {0xF9, 0x43}, /* 0xD4-0xD7 */
	{0x6F, 0xC3}, {0xF9, 0x44}, {0xF9, 0x45}, {0x81, 0xBF}, /* 0xD8-0xDB */
	{0x8F, 0xB2}, {0x60, 0xF1}, {0xF9, 0x46}, {0xF9, 0x47}, /* 0xDC-0xDF */
	{0x81, 0x66}, {0xF9, 0x48}, {0xF9, 0x49}, {0x5C, 0x3F}, /* 0xE0-0xE3 */
	{0xF9, 0x4A}, {0xF9, 0x4B}, {0xF9, 0x4C}, {0xF9, 0x4D}, /* 0xE4-0xE7 */
	{0xF9, 0x4E}, {0xF9, 0x4F}, {0xF9, 0x50}, {0xF9, 0x51}, /* 0xE8-0xEB */
	{0x5A, 0xE9}, {0x8A, 0x25}, {0x67, 0x7B}, {0x7D, 0x10}, /* 0xEC-0xEF */
	{0xF9, 0x52}, {0xF9, 0x53}, {0xF9, 0x54}, {0xF9, 0x55}, /* 0xF0-0xF3 */
	{0xF9, 0x56}, {0xF9, 0x57}, {0x80, 0xFD}, {0xF9, 0x58}, /* 0xF4-0xF7 */
	{0xF9, 0x59}, {0x5C, 0x3C}, {0x6C, 0xE5}, {0x53, 0x3F}, /* 0xF8-0xFB */
	{0x6E, 0xBA}, {0x59, 0x1A}, {0x83, 0x36}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_D3[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x4E, 0x39}, {0x4E, 0xB6}, {0x4F, 0x46}, /* 0xA0-0xA3 */
	{0x55, 0xAE}, {0x57, 0x18}, {0x58, 0xC7}, {0x5F, 0x56}, /* 0xA4-0xA7 */
	{0x65, 0xB7}, {0x65, 0xE6}, {0x6A, 0x80}, {0x6B, 0xB5}, /* 0xA8-0xAB */
	{0x6E, 0x4D}, {0x77, 0xED}, {0x7A, 0xEF}, {0x7C, 0x1E}, /* 0xAC-0xAF */
	{0x7D, 0xDE}, {0x86, 0xCB}, {0x88, 0x92}, {0x91, 0x32}, /* 0xB0-0xB3 */
	{0x93, 0x5B}, {0x64, 0xBB}, {0x6F, 0xBE}, {0x73, 0x7A}, /* 0xB4-0xB7 */
	{0x75, 0xB8}, {0x90, 0x54}, {0x55, 0x56}, {0x57, 0x4D}, /* 0xB8-0xBB */
	{0x61, 0xBA}, {0x64, 0xD4}, {0x66, 0xC7}, {0x6D, 0xE1}, /* 0xBC-0xBF */
	{0x6E, 0x5B}, {0x6F, 0x6D}, {0x6F, 0xB9}, {0x75, 0xF0}, /* 0xC0-0xC3 */
	{0x80, 0x43}, {0x81, 0xBD}, {0x85, 0x41}, {0x89, 0x83}, /* 0xC4-0xC7 */
	{0x8A, 0xC7}, {0x8B, 0x5A}, {0x93, 0x1F}, {0x6C, 0x93}, /* 0xC8-0xCB */
	{0x75, 0x53}, {0x7B, 0x54}, {0x8E, 0x0F}, {0x90, 0x5D}, /* 0xCC-0xCF */
	{0x55, 0x10}, {0x58, 0x02}, {0x58, 0x58}, {0x5E, 0x62}, /* 0xD0-0xD3 */
	{0x62, 0x07}, {0x64, 0x9E}, {0x68, 0xE0}, {0x75, 0x76}, /* 0xD4-0xD7 */
	{0x7C, 0xD6}, {0x87, 0xB3}, {0x9E, 0xE8}, {0x4E, 0xE3}, /* 0xD8-0xDB */
	{0x57, 0x88}, {0x57, 0x6E}, {0x59, 0x27}, {0x5C, 0x0D}, /* 0xDC-0xDF */
	{0x5C, 0xB1}, {0x5E, 0x36}, {0x5F, 0x85}, {0x62, 0x34}, /* 0xE0-0xE3 */
	{0x64, 0xE1}, {0x73, 0xB3}, {0x81, 0xFA}, {0x88, 0x8B}, /* 0xE4-0xE7 */
	{0x8C, 0xB8}, {0x96, 0x8A}, {0x9E, 0xDB}, {0x5B, 0x85}, /* 0xE8-0xEB */
	{0x5F, 0xB7}, {0x60, 0xB3}, {0x50, 0x12}, {0x52, 0x00}, /* 0xEC-0xEF */
	{0x52, 0x30}, {0x57, 0x16}, {0x58, 0x35}, {0x58, 0x57}, /* 0xF0-0xF3 */
	{0x5C, 0x0E}, {0x5C, 0x60}, {0x5C, 0xF6}, {0x5D, 0x8B}, /* 0xF4-0xF7 */
	{0x5E, 0xA6}, {0x5F, 0x92}, {0x60, 0xBC}, {0x63, 0x11}, /* 0xF8-0xFB */
	{0x63, 0x89}, {0x64, 0x17}, {0x68, 0x43}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_D4[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x68, 0xF9}, {0x6A, 0xC2}, {0x6D, 0xD8}, /* 0xA0-0xA3 */
	{0x6E, 0x21}, {0x6E, 0xD4}, {0x6F, 0xE4}, {0x71, 0xFE}, /* 0xA4-0xA7 */
	{0x76, 0xDC}, {0x77, 0x79}, {0x79, 0xB1}, {0x7A, 0x3B}, /* 0xA8-0xAB */
	{0x84, 0x04}, {0x89, 0xA9}, {0x8C, 0xED}, {0x8D, 0xF3}, /* 0xAC-0xAF */
	{0x8E, 0x48}, {0x90, 0x03}, {0x90, 0x14}, {0x90, 0x53}, /* 0xB0-0xB3 */
	{0xFA, 0x26}, {0x93, 0x4D}, {0x96, 0x76}, {0x97, 0xDC}, /* 0xB4-0xB7 */
	{0x6B, 0xD2}, {0x70, 0x06}, {0x72, 0x58}, {0x72, 0xA2}, /* 0xB8-0xBB */
	{0x73, 0x68}, {0x77, 0x63}, {0x79, 0xBF}, {0x7B, 0xE4}, /* 0xBC-0xBF */
	{0x7E, 0x9B}, {0x8B, 0x80}, {0x58, 0xA9}, {0x60, 0xC7}, /* 0xC0-0xC3 */
	{0x65, 0x66}, {0x65, 0xFD}, {0x66, 0xBE}, {0x6C, 0x8C}, /* 0xC4-0xC7 */
	{0x71, 0x1E}, {0x71, 0xC9}, {0x8C, 0x5A}, {0x98, 0x13}, /* 0xC8-0xCB */
	{0x4E, 0x6D}, {0x7A, 0x81}, {0x4E, 0xDD}, {0x51, 0xAC}, /* 0xCC-0xCF */
	{0x51, 0xCD}, {0x52, 0xD5}, {0x54, 0x0C}, {0x61, 0xA7}, /* 0xD0-0xD3 */
	{0x67, 0x71}, {0x68, 0x50}, {0x68, 0xDF}, {0x6D, 0x1E}, /* 0xD4-0xD7 */
	{0x6F, 0x7C}, {0x75, 0xBC}, {0x77, 0xB3}, {0x7A, 0xE5}, /* 0xD8-0xDB */
	{0x80, 0xF4}, {0x84, 0x63}, {0x92, 0x85}, {0x51, 0x5C}, /* 0xDC-0xDF */
	{0x65, 0x97}, {0x67, 0x5C}, {0x67, 0x93}, {0x75, 0xD8}, /* 0xE0-0xE3 */
	{0x7A, 0xC7}, {0x83, 0x73}, {0xF9, 0x5A}, {0x8C, 0x46}, /* 0xE4-0xE7 */
	{0x90, 0x17}, {0x98, 0x2D}, {0x5C, 0x6F}, {0x81, 0xC0}, /* 0xE8-0xEB */
	{0x82, 0x9A}, {0x90, 0x41}, {0x90, 0x6F}, {0x92, 0x0D}, /* 0xEC-0xEF */
	{0x5F, 0x97}, {0x5D, 0x9D}, {0x6A, 0x59}, {0x71, 0xC8}, /* 0xF0-0xF3 */
	{0x76, 0x7B}, {0x7B, 0x49}, {0x85, 0xE4}, {0x8B, 0x04}, /* 0xF4-0xF7 */
	{0x91, 0x27}, {0x9A, 0x30}, {0x55, 0x87}, {0x61, 0xF6}, /* 0xF8-0xFB */
	{0xF9, 0x5B}, {0x76, 0x69}, {0x7F, 0x85}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_D5[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x86, 0x3F}, {0x87, 0xBA}, {0x88, 0xF8}, /* 0xA0-0xA3 */
	{0x90, 0x8F}, {0xF9, 0x5C}, {0x6D, 0x1B}, {0x70, 0xD9}, /* 0xA4-0xA7 */
	{0x73, 0xDE}, {0x7D, 0x61}, {0x84, 0x3D}, {0xF9, 0x5D}, /* 0xA8-0xAB */
	{0x91, 0x6A}, {0x99, 0xF1}, {0xF9, 0x5E}, {0x4E, 0x82}, /* 0xAC-0xAF */
	{0x53, 0x75}, {0x6B, 0x04}, {0x6B, 0x12}, {0x70, 0x3E}, /* 0xB0-0xB3 */
	{0x72, 0x1B}, {0x86, 0x2D}, {0x9E, 0x1E}, {0x52, 0x4C}, /* 0xB4-0xB7 */
	{0x8F, 0xA3}, {0x5D, 0x50}, {0x64, 0xE5}, {0x65, 0x2C}, /* 0xB8-0xBB */
	{0x6B, 0x16}, {0x6F, 0xEB}, {0x7C, 0x43}, {0x7E, 0x9C}, /* 0xBC-0xBF */
	{0x85, 0xCD}, {0x89, 0x64}, {0x89, 0xBD}, {0x62, 0xC9}, /* 0xC0-0xC3 */
	{0x81, 0xD8}, {0x88, 0x1F}, {0x5E, 0xCA}, {0x67, 0x17}, /* 0xC4-0xC7 */
	{0x6D, 0x6A}, {0x72, 0xFC}, {0x74, 0x05}, {0x74, 0x6F}, /* 0xC8-0xCB */
	{0x87, 0x82}, {0x90, 0xDE}, {0x4F, 0x86}, {0x5D, 0x0D}, /* 0xCC-0xCF */
	{0x5F, 0xA0}, {0x84, 0x0A}, {0x51, 0xB7}, {0x63, 0xA0}, /* 0xD0-0xD3 */
	{0x75, 0x65}, {0x4E, 0xAE}, {0x50, 0x06}, {0x51, 0x69}, /* 0xD4-0xD7 */
	{0x51, 0xC9}, {0x68, 0x81}, {0x6A, 0x11}, {0x7C, 0xAE}, /* 0xD8-0xDB */
	{0x7C, 0xB1}, {0x7C, 0xE7}, {0x82, 0x6F}, {0x8A, 0xD2}, /* 0xDC-0xDF */
	{0x8F, 0x1B}, {0x91, 0xCF}, {0x4F, 0xB6}, {0x51, 0x37}, /* 0xE0-0xE3 */
	{0x52, 0xF5}, {0x54, 0x42}, {0x5E, 0xEC}, {0x61, 0x6E}, /* 0xE4-0xE7 */
	{0x62, 0x3E}, {0x65, 0xC5}, {0x6A, 0xDA}, {0x6F, 0xFE}, /* 0xE8-0xEB */
	{0x79, 0x2A}, {0x85, 0xDC}, {0x88, 0x23}, {0x95, 0xAD}, /* 0xEC-0xEF */
	{0x9A, 0x62}, {0x9A, 0x6A}, {0x9E, 0x97}, {0x9E, 0xCE}, /* 0xF0-0xF3 */
	{0x52, 0x9B}, {0x66, 0xC6}, {0x6B, 0x77}, {0x70, 0x1D}, /* 0xF4-0xF7 */
	{0x79, 0x2B}, {0x8F, 0x62}, {0x97, 0x42}, {0x61, 0x90}, /* 0xF8-0xFB */
	{0x62, 0x00}, {0x65, 0x23}, {0x6F, 0x23}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_D6[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x71, 0x49}, {0x74, 0x89}, {0x7D, 0xF4}, /* 0xA0-0xA3 */
	{0x80, 0x6F}, {0x84, 0xEE}, {0x8F, 0x26}, {0x90, 0x23}, /* 0xA4-0xA7 */
	{0x93, 0x4A}, {0x51, 0xBD}, {0x52, 0x17}, {0x52, 0xA3}, /* 0xA8-0xAB */
	{0x6D, 0x0C}, {0x70, 0xC8}, {0x88, 0xC2}, {0x5E, 0xC9}, /* 0xAC-0xAF */
	{0x65, 0x82}, {0x6B, 0xAE}, {0x6F, 0xC2}, {0x7C, 0x3E}, /* 0xB0-0xB3 */
	{0x73, 0x75}, {0x4E, 0xE4}, {0x4F, 0x36}, {0x56, 0xF9}, /* 0xB4-0xB7 */
	{0xF9, 0x5F}, {0x5C, 0xBA}, {0x5D, 0xBA}, {0x60, 0x1C}, /* 0xB8-0xBB */
	{0x73, 0xB2}, {0x7B, 0x2D}, {0x7F, 0x9A}, {0x7F, 0xCE}, /* 0xBC-0xBF */
	{0x80, 0x46}, {0x90, 0x1E}, {0x92, 0x34}, {0x96, 0xF6}, /* 0xC0-0xC3 */
	{0x97, 0x48}, {0x98, 0x18}, {0x9F, 0x61}, {0x4F, 0x8B}, /* 0xC4-0xC7 */
	{0x6F, 0xA7}, {0x79, 0xAE}, {0x91, 0xB4}, {0x96, 0xB7}, /* 0xC8-0xCB */
	{0x52, 0xDE}, {0xF9, 0x60}, {0x64, 0x88}, {0x64, 0xC4}, /* 0xCC-0xCF */
	{0x6A, 0xD3}, {0x6F, 0x5E}, {0x70, 0x18}, {0x72, 0x10}, /* 0xD0-0xD3 */
	{0x76, 0xE7}, {0x80, 0x01}, {0x86, 0x06}, {0x86, 0x5C}, /* 0xD4-0xD7 */
	{0x8D, 0xEF}, {0x8F, 0x05}, {0x97, 0x32}, {0x9B, 0x6F}, /* 0xD8-0xDB */
	{0x9D, 0xFA}, {0x9E, 0x75}, {0x78, 0x8C}, {0x79, 0x7F}, /* 0xDC-0xDF */
	{0x7D, 0xA0}, {0x83, 0xC9}, {0x93, 0x04}, {0x9E, 0x7F}, /* 0xE0-0xE3 */
	{0x9E, 0x93}, {0x8A, 0xD6}, {0x58, 0xDF}, {0x5F, 0x04}, /* 0xE4-0xE7 */
	{0x67, 0x27}, {0x70, 0x27}, {0x74, 0xCF}, {0x7C, 0x60}, /* 0xE8-0xEB */
	{0x80, 0x7E}, {0x51, 0x21}, {0x70, 0x28}, {0x72, 0x62}, /* 0xEC-0xEF */
	{0x78, 0xCA}, {0x8C, 0xC2}, {0x8C, 0xDA}, {0x8C, 0xF4}, /* 0xF0-0xF3 */
	{0x96, 0xF7}, {0x4E, 0x86}, {0x50, 0xDA}, {0x5B, 0xEE}, /* 0xF4-0xF7 */
	{0x5E, 0xD6}, {0x65, 0x99}, {0x71, 0xCE}, {0x76, 0x42}, /* 0xF8-0xFB */
	{0x77, 0xAD}, {0x80, 0x4A}, {0x84, 0xFC}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_D7[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x90, 0x7C}, {0x9B, 0x27}, {0x9F, 0x8D}, /* 0xA0-0xA3 */
	{0x58, 0xD8}, {0x5A, 0x41}, {0x5C, 0x62}, {0x6A, 0x13}, /* 0xA4-0xA7 */
	{0x6D, 0xDA}, {0x6F, 0x0F}, {0x76, 0x3B}, {0x7D, 0x2F}, /* 0xA8-0xAB */
	{0x7E, 0x37}, {0x85, 0x1E}, {0x89, 0x38}, {0x93, 0xE4}, /* 0xAC-0xAF */
	{0x96, 0x4B}, {0x52, 0x89}, {0x65, 0xD2}, {0x67, 0xF3}, /* 0xB0-0xB3 */
	{0x69, 0xB4}, {0x6D, 0x41}, {0x6E, 0x9C}, {0x70, 0x0F}, /* 0xB4-0xB7 */
	{0x74, 0x09}, {0x74, 0x60}, {0x75, 0x59}, {0x76, 0x24}, /* 0xB8-0xBB */
	{0x78, 0x6B}, {0x8B, 0x2C}, {0x98, 0x5E}, {0x51, 0x6D}, /* 0xBC-0xBF */
	{0x62, 0x2E}, {0x96, 0x78}, {0x4F, 0x96}, {0x50, 0x2B}, /* 0xC0-0xC3 */
	{0x5D, 0x19}, {0x6D, 0xEA}, {0x7D, 0xB8}, {0x8F, 0x2A}, /* 0xC4-0xC7 */
	{0x5F, 0x8B}, {0x61, 0x44}, {0x68, 0x17}, {0xF9, 0x61}, /* 0xC8-0xCB */
	{0x96, 0x86}, {0x52, 0xD2}, {0x80, 0x8B}, {0x51, 0xDC}, /* 0xCC-0xCF */
	{0x51, 0xCC}, {0x69, 0x5E}, {0x7A, 0x1C}, {0x7D, 0xBE}, /* 0xD0-0xD3 */
	{0x83, 0xF1}, {0x96, 0x75}, {0x4F, 0xDA}, {0x52, 0x29}, /* 0xD4-0xD7 */
	{0x53, 0x98}, {0x54, 0x0F}, {0x55, 0x0E}, {0x5C, 0x65}, /* 0xD8-0xDB */
	{0x60, 0xA7}, {0x67, 0x4E}, {0x68, 0xA8}, {0x6D, 0x6C}, /* 0xDC-0xDF */
	{0x72, 0x81}, {0x72, 0xF8}, {0x74, 0x06}, {0x74, 0x83}, /* 0xE0-0xE3 */
	{0xF9, 0x62}, {0x75, 0xE2}, {0x7C, 0x6C}, {0x7F, 0x79}, /* 0xE4-0xE7 */
	{0x7F, 0xB8}, {0x83, 0x89}, {0x88, 0xCF}, {0x88, 0xE1}, /* 0xE8-0xEB */
	{0x91, 0xCC}, {0x91, 0xD0}, {0x96, 0xE2}, {0x9B, 0xC9}, /* 0xEC-0xEF */
	{0x54, 0x1D}, {0x6F, 0x7E}, {0x71, 0xD0}, {0x74, 0x98}, /* 0xF0-0xF3 */
	{0x85, 0xFA}, {0x8E, 0xAA}, {0x96, 0xA3}, {0x9C, 0x57}, /* 0xF4-0xF7 */
	{0x9E, 0x9F}, {0x67, 0x97}, {0x6D, 0xCB}, {0x74, 0x33}, /* 0xF8-0xFB */
	{0x81, 0xE8}, {0x97, 0x16}, {0x78, 0x2C}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_D8[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x7A, 0xCB}, {0x7B, 0x20}, {0x7C, 0x92}, /* 0xA0-0xA3 */
	{0x64, 0x69}, {0x74, 0x6A}, {0x75, 0xF2}, {0x78, 0xBC}, /* 0xA4-0xA7 */
	{0x78, 0xE8}, {0x99, 0xAC}, {0x9B, 0x54}, {0x9E, 0xBB}, /* 0xA8-0xAB */
	{0x5B, 0xDE}, {0x5E, 0x55}, {0x6F, 0x20}, {0x81, 0x9C}, /* 0xAC-0xAF */
	{0x83, 0xAB}, {0x90, 0x88}, {0x4E, 0x07}, {0x53, 0x4D}, /* 0xB0-0xB3 */
	{0x5A, 0x29}, {0x5D, 0xD2}, {0x5F, 0x4E}, {0x61, 0x62}, /* 0xB4-0xB7 */
	{0x63, 0x3D}, {0x66, 0x69}, {0x66, 0xFC}, {0x6E, 0xFF}, /* 0xB8-0xBB */
	{0x6F, 0x2B}, {0x70, 0x63}, {0x77, 0x9E}, {0x84, 0x2C}, /* 0xBC-0xBF */
	{0x85, 0x13}, {0x88, 0x3B}, {0x8F, 0x13}, {0x99, 0x45}, /* 0xC0-0xC3 */
	{0x9C, 0x3B}, {0x55, 0x1C}, {0x62, 0xB9}, {0x67, 0x2B}, /* 0xC4-0xC7 */
	{0x6C, 0xAB}, {0x83, 0x09}, {0x89, 0x6A}, {0x97, 0x7A}, /* 0xC8-0xCB */
	{0x4E, 0xA1}, {0x59, 0x84}, {0x5F, 0xD8}, {0x5F, 0xD9}, /* 0xCC-0xCF */
	{0x67, 0x1B}, {0x7D, 0xB2}, {0x7F, 0x54}, {0x82, 0x92}, /* 0xD0-0xD3 */
	{0x83, 0x2B}, {0x83, 0xBD}, {0x8F, 0x1E}, {0x90, 0x99}, /* 0xD4-0xD7 */
	{0x57, 0xCB}, {0x59, 0xB9}, {0x5A, 0x92}, {0x5B, 0xD0}, /* 0xD8-0xDB */
	{0x66, 0x27}, {0x67, 0x9A}, {0x68, 0x85}, {0x6B, 0xCF}, /* 0xDC-0xDF */
	{0x71, 0x64}, {0x7F, 0x75}, {0x8C, 0xB7}, {0x8C, 0xE3}, /* 0xE0-0xE3 */
	{0x90, 0x81}, {0x9B, 0x45}, {0x81, 0x08}, {0x8C, 0x8A}, /* 0xE4-0xE7 */
	{0x96, 0x4C}, {0x9A, 0x40}, {0x9E, 0xA5}, {0x5B, 0x5F}, /* 0xE8-0xEB */
	{0x6C, 0x13}, {0x73, 0x1B}, {0x76, 0xF2}, {0x76, 0xDF}, /* 0xEC-0xEF */
	{0x84, 0x0C}, {0x51, 0xAA}, {0x89, 0x93}, {0x51, 0x4D}, /* 0xF0-0xF3 */
	{0x51, 0x95}, {0x52, 0xC9}, {0x68, 0xC9}, {0x6C, 0x94}, /* 0xF4-0xF7 */
	{0x77, 0x04}, {0x77, 0x20}, {0x7D, 0xBF}, {0x7D, 0xEC}, /* 0xF8-0xFB */
	{0x97, 0x62}, {0x9E, 0xB5}, {0x6E, 0xC5}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_D9[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x85, 0x11}, {0x51, 0xA5}, {0x54, 0x0D}, /* 0xA0-0xA3 */
	{0x54, 0x7D}, {0x66, 0x0E}, {0x66, 0x9D}, {0x69, 0x27}, /* 0xA4-0xA7 */
	{0x6E, 0x9F}, {0x76, 0xBF}, {0x77, 0x91}, {0x83, 0x17}, /* 0xA8-0xAB */
	{0x84, 0xC2}, {0x87, 0x9F}, {0x91, 0x69}, {0x92, 0x98}, /* 0xAC-0xAF */
	{0x9C, 0xF4}, {0x88, 0x82}, {0x4F, 0xAE}, {0x51, 0x92}, /* 0xB0-0xB3 */
	{0x52, 0xDF}, {0x59, 0xC6}, {0x5E, 0x3D}, {0x61, 0x55}, /* 0xB4-0xB7 */
	{0x64, 0x78}, {0x64, 0x79}, {0x66, 0xAE}, {0x67, 0xD0}, /* 0xB8-0xBB */
	{0x6A, 0x21}, {0x6B, 0xCD}, {0x6B, 0xDB}, {0x72, 0x5F}, /* 0xBC-0xBF */
	{0x72, 0x61}, {0x74, 0x41}, {0x77, 0x38}, {0x77, 0xDB}, /* 0xC0-0xC3 */
	{0x80, 0x17}, {0x82, 0xBC}, {0x83, 0x05}, {0x8B, 0x00}, /* 0xC4-0xC7 */
	{0x8B, 0x28}, {0x8C, 0x8C}, {0x67, 0x28}, {0x6C, 0x90}, /* 0xC8-0xCB */
	{0x72, 0x67}, {0x76, 0xEE}, {0x77, 0x66}, {0x7A, 0x46}, /* 0xCC-0xCF */
	{0x9D, 0xA9}, {0x6B, 0x7F}, {0x6C, 0x92}, {0x59, 0x22}, /* 0xD0-0xD3 */
	{0x67, 0x26}, {0x84, 0x99}, {0x53, 0x6F}, {0x58, 0x93}, /* 0xD4-0xD7 */
	{0x59, 0x99}, {0x5E, 0xDF}, {0x63, 0xCF}, {0x66, 0x34}, /* 0xD8-0xDB */
	{0x67, 0x73}, {0x6E, 0x3A}, {0x73, 0x2B}, {0x7A, 0xD7}, /* 0xDC-0xDF */
	{0x82, 0xD7}, {0x93, 0x28}, {0x52, 0xD9}, {0x5D, 0xEB}, /* 0xE0-0xE3 */
	{0x61, 0xAE}, {0x61, 0xCB}, {0x62, 0x0A}, {0x62, 0xC7}, /* 0xE4-0xE7 */
	{0x64, 0xAB}, {0x65, 0xE0}, {0x69, 0x59}, {0x6B, 0x66}, /* 0xE8-0xEB */
	{0x6B, 0xCB}, {0x71, 0x21}, {0x73, 0xF7}, {0x75, 0x5D}, /* 0xEC-0xEF */
	{0x7E, 0x46}, {0x82, 0x1E}, {0x83, 0x02}, {0x85, 0x6A}, /* 0xF0-0xF3 */
	{0x8A, 0xA3}, {0x8C, 0xBF}, {0x97, 0x27}, {0x9D, 0x61}, /* 0xF4-0xF7 */
	{0x58, 0xA8}, {0x9E, 0xD8}, {0x50, 0x11}, {0x52, 0x0E}, /* 0xF8-0xFB */
	{0x54, 0x3B}, {0x55, 0x4F}, {0x65, 0x87}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_DA[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x6C, 0x76}, {0x7D, 0x0A}, {0x7D, 0x0B}, /* 0xA0-0xA3 */
	{0x80, 0x5E}, {0x86, 0x8A}, {0x95, 0x80}, {0x96, 0xEF}, /* 0xA4-0xA7 */
	{0x52, 0xFF}, {0x6C, 0x95}, {0x72, 0x69}, {0x54, 0x73}, /* 0xA8-0xAB */
	{0x5A, 0x9A}, {0x5C, 0x3E}, {0x5D, 0x4B}, {0x5F, 0x4C}, /* 0xAC-0xAF */
	{0x5F, 0xAE}, {0x67, 0x2A}, {0x68, 0xB6}, {0x69, 0x63}, /* 0xB0-0xB3 */
	{0x6E, 0x3C}, {0x6E, 0x44}, {0x77, 0x09}, {0x7C, 0x73}, /* 0xB4-0xB7 */
	{0x7F, 0x8E}, {0x85, 0x87}, {0x8B, 0x0E}, {0x8F, 0xF7}, /* 0xB8-0xBB */
	{0x97, 0x61}, {0x9E, 0xF4}, {0x5C, 0xB7}, {0x60, 0xB6}, /* 0xBC-0xBF */
	{0x61, 0x0D}, {0x61, 0xAB}, {0x65, 0x4F}, {0x65, 0xFB}, /* 0xC0-0xC3 */
	{0x65, 0xFC}, {0x6C, 0x11}, {0x6C, 0xEF}, {0x73, 0x9F}, /* 0xC4-0xC7 */
	{0x73, 0xC9}, {0x7D, 0xE1}, {0x95, 0x94}, {0x5B, 0xC6}, /* 0xC8-0xCB */
	{0x87, 0x1C}, {0x8B, 0x10}, {0x52, 0x5D}, {0x53, 0x5A}, /* 0xCC-0xCF */
	{0x62, 0xCD}, {0x64, 0x0F}, {0x64, 0xB2}, {0x67, 0x34}, /* 0xD0-0xD3 */
	{0x6A, 0x38}, {0x6C, 0xCA}, {0x73, 0xC0}, {0x74, 0x9E}, /* 0xD4-0xD7 */
	{0x7B, 0x94}, {0x7C, 0x95}, {0x7E, 0x1B}, {0x81, 0x8A}, /* 0xD8-0xDB */
	{0x82, 0x36}, {0x85, 0x84}, {0x8F, 0xEB}, {0x96, 0xF9}, /* 0xDC-0xDF */
	{0x99, 0xC1}, {0x4F, 0x34}, {0x53, 0x4A}, {0x53, 0xCD}, /* 0xE0-0xE3 */
	{0x53, 0xDB}, {0x62, 0xCC}, {0x64, 0x2C}, {0x65, 0x00}, /* 0xE4-0xE7 */
	{0x65, 0x91}, {0x69, 0xC3}, {0x6C, 0xEE}, {0x6F, 0x58}, /* 0xE8-0xEB */
	{0x73, 0xED}, {0x75, 0x54}, {0x76, 0x22}, {0x76, 0xE4}, /* 0xEC-0xEF */
	{0x76, 0xFC}, {0x78, 0xD0}, {0x78, 0xFB}, {0x79, 0x2C}, /* 0xF0-0xF3 */
	{0x7D, 0x46}, {0x82, 0x2C}, {0x87, 0xE0}, {0x8F, 0xD4}, /* 0xF4-0xF7 */
	{0x98, 0x12}, {0xFA, 0x2A}, {0x52, 0xC3}, {0x62, 0xD4}, /* 0xF8-0xFB */
	{0x64, 0xA5}, {0x6E, 0x24}, {0x6F, 0x51}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_DB[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x76, 0x7C}, {0x8D, 0xCB}, {0x91, 0xB1}, /* 0xA0-0xA3 */
	{0x92, 0x62}, {0x9A, 0xEE}, {0x9B, 0x43}, {0x50, 0x23}, /* 0xA4-0xA7 */
	{0x50, 0x8D}, {0x57, 0x4A}, {0x59, 0xA8}, {0x5C, 0x28}, /* 0xA8-0xAB */
	{0x5E, 0x47}, {0x5F, 0x77}, {0x62, 0x3F}, {0x65, 0x3E}, /* 0xAC-0xAF */
	{0x65, 0xB9}, {0x65, 0xC1}, {0x66, 0x09}, {0x67, 0x8B}, /* 0xB0-0xB3 */
	{0x69, 0x9C}, {0x6E, 0xC2}, {0x78, 0xC5}, {0x7D, 0x21}, /* 0xB4-0xB7 */
	{0x80, 0xAA}, {0x81, 0x80}, {0x82, 0x2B}, {0x82, 0xB3}, /* 0xB8-0xBB */
	{0x84, 0xA1}, {0x86, 0x8C}, {0x8A, 0x2A}, {0x8B, 0x17}, /* 0xBC-0xBF */
	{0x90, 0xA6}, {0x96, 0x32}, {0x9F, 0x90}, {0x50, 0x0D}, /* 0xC0-0xC3 */
	{0x4F, 0xF3}, {0xF9, 0x63}, {0x57, 0xF9}, {0x5F, 0x98}, /* 0xC4-0xC7 */
	{0x62, 0xDC}, {0x63, 0x92}, {0x67, 0x6F}, {0x6E, 0x43}, /* 0xC8-0xCB */
	{0x71, 0x19}, {0x76, 0xC3}, {0x80, 0xCC}, {0x80, 0xDA}, /* 0xCC-0xCF */
	{0x88, 0xF4}, {0x88, 0xF5}, {0x89, 0x19}, {0x8C, 0xE0}, /* 0xD0-0xD3 */
	{0x8F, 0x29}, {0x91, 0x4D}, {0x96, 0x6A}, {0x4F, 0x2F}, /* 0xD4-0xD7 */
	{0x4F, 0x70}, {0x5E, 0x1B}, {0x67, 0xCF}, {0x68, 0x22}, /* 0xD8-0xDB */
	{0x76, 0x7D}, {0x76, 0x7E}, {0x9B, 0x44}, {0x5E, 0x61}, /* 0xDC-0xDF */
	{0x6A, 0x0A}, {0x71, 0x69}, {0x71, 0xD4}, {0x75, 0x6A}, /* 0xE0-0xE3 */
	{0xF9, 0x64}, {0x7E, 0x41}, {0x85, 0x43}, {0x85, 0xE9}, /* 0xE4-0xE7 */
	{0x98, 0xDC}, {0x4F, 0x10}, {0x7B, 0x4F}, {0x7F, 0x70}, /* 0xE8-0xEB */
	{0x95, 0xA5}, {0x51, 0xE1}, {0x5E, 0x06}, {0x68, 0xB5}, /* 0xEC-0xEF */
	{0x6C, 0x3E}, {0x6C, 0x4E}, {0x6C, 0xDB}, {0x72, 0xAF}, /* 0xF0-0xF3 */
	{0x7B, 0xC4}, {0x83, 0x03}, {0x6C, 0xD5}, {0x74, 0x3A}, /* 0xF4-0xF7 */
	{0x50, 0xFB}, {0x52, 0x88}, {0x58, 0xC1}, {0x64, 0xD8}, /* 0xF8-0xFB */
	{0x6A, 0x97}, {0x74, 0xA7}, {0x76, 0x56}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_DC[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x78, 0xA7}, {0x86, 0x17}, {0x95, 0xE2}, /* 0xA0-0xA3 */
	{0x97, 0x39}, {0xF9, 0x65}, {0x53, 0x5E}, {0x5F, 0x01}, /* 0xA4-0xA7 */
	{0x8B, 0x8A}, {0x8F, 0xA8}, {0x8F, 0xAF}, {0x90, 0x8A}, /* 0xA8-0xAB */
	{0x52, 0x25}, {0x77, 0xA5}, {0x9C, 0x49}, {0x9F, 0x08}, /* 0xAC-0xAF */
	{0x4E, 0x19}, {0x50, 0x02}, {0x51, 0x75}, {0x5C, 0x5B}, /* 0xB0-0xB3 */
	{0x5E, 0x77}, {0x66, 0x1E}, {0x66, 0x3A}, {0x67, 0xC4}, /* 0xB4-0xB7 */
	{0x68, 0xC5}, {0x70, 0xB3}, {0x75, 0x01}, {0x75, 0xC5}, /* 0xB8-0xBB */
	{0x79, 0xC9}, {0x7A, 0xDD}, {0x8F, 0x27}, {0x99, 0x20}, /* 0xBC-0xBF */
	{0x9A, 0x08}, {0x4F, 0xDD}, {0x58, 0x21}, {0x58, 0x31}, /* 0xC0-0xC3 */
	{0x5B, 0xF6}, {0x66, 0x6E}, {0x6B, 0x65}, {0x6D, 0x11}, /* 0xC4-0xC7 */
	{0x6E, 0x7A}, {0x6F, 0x7D}, {0x73, 0xE4}, {0x75, 0x2B}, /* 0xC8-0xCB */
	{0x83, 0xE9}, {0x88, 0xDC}, {0x89, 0x13}, {0x8B, 0x5C}, /* 0xCC-0xCF */
	{0x8F, 0x14}, {0x4F, 0x0F}, {0x50, 0xD5}, {0x53, 0x10}, /* 0xD0-0xD3 */
	{0x53, 0x5C}, {0x5B, 0x93}, {0x5F, 0xA9}, {0x67, 0x0D}, /* 0xD4-0xD7 */
	{0xFA, 0x1B}, {0x81, 0x79}, {0x83, 0x2F}, {0x85, 0x14}, /* 0xD8-0xDB */
	{0x89, 0x07}, {0x89, 0x86}, {0x8F, 0x39}, {0x8F, 0x3B}, /* 0xDC-0xDF */
	{0x99, 0xA5}, {0x9C, 0x12}, {0x67, 0x2C}, {0x4E, 0x76}, /* 0xE0-0xE3 */
	{0x4F, 0xF8}, {0x59, 0x49}, {0x5C, 0x01}, {0x5C, 0xEF}, /* 0xE4-0xE7 */
	{0x5C, 0xF0}, {0x63, 0x67}, {0x68, 0xD2}, {0x70, 0xFD}, /* 0xE8-0xEB */
	{0x71, 0xA2}, {0x74, 0x2B}, {0x7E, 0x2B}, {0x84, 0xEC}, /* 0xEC-0xEF */
	{0x87, 0x02}, {0x90, 0x22}, {0x92, 0xD2}, {0x9C, 0xF3}, /* 0xF0-0xF3 */
	{0x4E, 0x0D}, {0x4E, 0xD8}, {0x4F, 0xEF}, {0x50, 0x85}, /* 0xF4-0xF7 */
	{0x52, 0x56}, {0x52, 0x6F}, {0x54, 0x26}, {0x54, 0x90}, /* 0xF8-0xFB */
	{0x57, 0xE0}, {0x59, 0x2B}, {0x5A, 0x66}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_DD[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x5B, 0x5A}, {0x5B, 0x75}, {0x5B, 0xCC}, /* 0xA0-0xA3 */
	{0x5E, 0x9C}, {0xF9, 0x66}, {0x62, 0x76}, {0x65, 0x77}, /* 0xA4-0xA7 */
	{0x65, 0xA7}, {0x6D, 0x6E}, {0x6E, 0xA5}, {0x72, 0x36}, /* 0xA8-0xAB */
	{0x7B, 0x26}, {0x7C, 0x3F}, {0x7F, 0x36}, {0x81, 0x50}, /* 0xAC-0xAF */
	{0x81, 0x51}, {0x81, 0x9A}, {0x82, 0x40}, {0x82, 0x99}, /* 0xB0-0xB3 */
	{0x83, 0xA9}, {0x8A, 0x03}, {0x8C, 0xA0}, {0x8C, 0xE6}, /* 0xB4-0xB7 */
	{0x8C, 0xFB}, {0x8D, 0x74}, {0x8D, 0xBA}, {0x90, 0xE8}, /* 0xB8-0xBB */
	{0x91, 0xDC}, {0x96, 0x1C}, {0x96, 0x44}, {0x99, 0xD9}, /* 0xBC-0xBF */
	{0x9C, 0xE7}, {0x53, 0x17}, {0x52, 0x06}, {0x54, 0x29}, /* 0xC0-0xC3 */
	{0x56, 0x74}, {0x58, 0xB3}, {0x59, 0x54}, {0x59, 0x6E}, /* 0xC4-0xC7 */
	{0x5F, 0xFF}, {0x61, 0xA4}, {0x62, 0x6E}, {0x66, 0x10}, /* 0xC8-0xCB */
	{0x6C, 0x7E}, {0x71, 0x1A}, {0x76, 0xC6}, {0x7C, 0x89}, /* 0xCC-0xCF */
	{0x7C, 0xDE}, {0x7D, 0x1B}, {0x82, 0xAC}, {0x8C, 0xC1}, /* 0xD0-0xD3 */
	{0x96, 0xF0}, {0xF9, 0x67}, {0x4F, 0x5B}, {0x5F, 0x17}, /* 0xD4-0xD7 */
	{0x5F, 0x7F}, {0x62, 0xC2}, {0x5D, 0x29}, {0x67, 0x0B}, /* 0xD8-0xDB */
	{0x68, 0xDA}, {0x78, 0x7C}, {0x7E, 0x43}, {0x9D, 0x6C}, /* 0xDC-0xDF */
	{0x4E, 0x15}, {0x50, 0x99}, {0x53, 0x15}, {0x53, 0x2A}, /* 0xE0-0xE3 */
	{0x53, 0x51}, {0x59, 0x83}, {0x5A, 0x62}, {0x5E, 0x87}, /* 0xE4-0xE7 */
	{0x60, 0xB2}, {0x61, 0x8A}, {0x62, 0x49}, {0x62, 0x79}, /* 0xE8-0xEB */
	{0x65, 0x90}, {0x67, 0x87}, {0x69, 0xA7}, {0x6B, 0xD4}, /* 0xEC-0xEF */
	{0x6B, 0xD6}, {0x6B, 0xD7}, {0x6B, 0xD8}, {0x6C, 0xB8}, /* 0xF0-0xF3 */
	{0xF9, 0x68}, {0x74, 0x35}, {0x75, 0xFA}, {0x78, 0x12}, /* 0xF4-0xF7 */
	{0x78, 0x91}, {0x79, 0xD5}, {0x79, 0xD8}, {0x7C, 0x83}, /* 0xF8-0xFB */
	{0x7D, 0xCB}, {0x7F, 0xE1}, {0x80, 0xA5}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_DE[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x81, 0x3E}, {0x81, 0xC2}, {0x83, 0xF2}, /* 0xA0-0xA3 */
	{0x87, 0x1A}, {0x88, 0xE8}, {0x8A, 0xB9}, {0x8B, 0x6C}, /* 0xA4-0xA7 */
	{0x8C, 0xBB}, {0x91, 0x19}, {0x97, 0x5E}, {0x98, 0xDB}, /* 0xA8-0xAB */
	{0x9F, 0x3B}, {0x56, 0xAC}, {0x5B, 0x2A}, {0x5F, 0x6C}, /* 0xAC-0xAF */
	{0x65, 0x8C}, {0x6A, 0xB3}, {0x6B, 0xAF}, {0x6D, 0x5C}, /* 0xB0-0xB3 */
	{0x6F, 0xF1}, {0x70, 0x15}, {0x72, 0x5D}, {0x73, 0xAD}, /* 0xB4-0xB7 */
	{0x8C, 0xA7}, {0x8C, 0xD3}, {0x98, 0x3B}, {0x61, 0x91}, /* 0xB8-0xBB */
	{0x6C, 0x37}, {0x80, 0x58}, {0x9A, 0x01}, {0x4E, 0x4D}, /* 0xBC-0xBF */
	{0x4E, 0x8B}, {0x4E, 0x9B}, {0x4E, 0xD5}, {0x4F, 0x3A}, /* 0xC0-0xC3 */
	{0x4F, 0x3C}, {0x4F, 0x7F}, {0x4F, 0xDF}, {0x50, 0xFF}, /* 0xC4-0xC7 */
	{0x53, 0xF2}, {0x53, 0xF8}, {0x55, 0x06}, {0x55, 0xE3}, /* 0xC8-0xCB */
	{0x56, 0xDB}, {0x58, 0xEB}, {0x59, 0x62}, {0x5A, 0x11}, /* 0xCC-0xCF */
	{0x5B, 0xEB}, {0x5B, 0xFA}, {0x5C, 0x04}, {0x5D, 0xF3}, /* 0xD0-0xD3 */
	{0x5E, 0x2B}, {0x5F, 0x99}, {0x60, 0x1D}, {0x63, 0x68}, /* 0xD4-0xD7 */
	{0x65, 0x9C}, {0x65, 0xAF}, {0x67, 0xF6}, {0x67, 0xFB}, /* 0xD8-0xDB */
	{0x68, 0xAD}, {0x6B, 0x7B}, {0x6C, 0x99}, {0x6C, 0xD7}, /* 0xDC-0xDF */
	{0x6E, 0x23}, {0x70, 0x09}, {0x73, 0x45}, {0x78, 0x02}, /* 0xE0-0xE3 */
	{0x79, 0x3E}, {0x79, 0x40}, {0x79, 0x60}, {0x79, 0xC1}, /* 0xE4-0xE7 */
	{0x7B, 0xE9}, {0x7D, 0x17}, {0x7D, 0x72}, {0x80, 0x86}, /* 0xE8-0xEB */
	{0x82, 0x0D}, {0x83, 0x8E}, {0x84, 0xD1}, {0x86, 0xC7}, /* 0xEC-0xEF */
	{0x88, 0xDF}, {0x8A, 0x50}, {0x8A, 0x5E}, {0x8B, 0x1D}, /* 0xF0-0xF3 */
	{0x8C, 0xDC}, {0x8D, 0x66}, {0x8F, 0xAD}, {0x90, 0xAA}, /* 0xF4-0xF7 */
	{0xFA, 0x2B}, {0x99, 0xDF}, {0x9E, 0x9D}, {0x52, 0x4A}, /* 0xF8-0xFB */
	{0xF9, 0x69}, {0x67, 0x14}, {0xF9, 0x6A}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_DF[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x50, 0x98}, {0x52, 0x2A}, {0x5C, 0x71}, /* 0xA0-0xA3 */
	{0x65, 0x63}, {0x6C, 0x55}, {0x73, 0xCA}, {0x75, 0x23}, /* 0xA4-0xA7 */
	{0x75, 0x9D}, {0x7B, 0x97}, {0x84, 0x9C}, {0x91, 0x78}, /* 0xA8-0xAB */
	{0x97, 0x30}, {0x4E, 0x77}, {0x64, 0x92}, {0x6B, 0xBA}, /* 0xAC-0xAF */
	{0x71, 0x5E}, {0x85, 0xA9}, {0x4E, 0x09}, {0xF9, 0x6B}, /* 0xB0-0xB3 */
	{0x67, 0x49}, {0x68, 0xEE}, {0x6E, 0x17}, {0x82, 0x9F}, /* 0xB4-0xB7 */
	{0x85, 0x18}, {0x88, 0x6B}, {0x63, 0xF7}, {0x6F, 0x81}, /* 0xB8-0xBB */
	{0x92, 0x12}, {0x98, 0xAF}, {0x4E, 0x0A}, {0x50, 0xB7}, /* 0xBC-0xBF */
	{0x50, 0xCF}, {0x51, 0x1F}, {0x55, 0x46}, {0x55, 0xAA}, /* 0xC0-0xC3 */
	{0x56, 0x17}, {0x5B, 0x40}, {0x5C, 0x19}, {0x5C, 0xE0}, /* 0xC4-0xC7 */
	{0x5E, 0x38}, {0x5E, 0x8A}, {0x5E, 0xA0}, {0x5E, 0xC2}, /* 0xC8-0xCB */
	{0x60, 0xF3}, {0x68, 0x51}, {0x6A, 0x61}, {0x6E, 0x58}, /* 0xCC-0xCF */
	{0x72, 0x3D}, {0x72, 0x40}, {0x72, 0xC0}, {0x76, 0xF8}, /* 0xD0-0xD3 */
	{0xFA, 0x1A}, {0x7B, 0xB1}, {0x7F, 0xD4}, {0x88, 0xF3}, /* 0xD4-0xD7 */
	{0x89, 0xF4}, {0x8A, 0x73}, {0x8C, 0x61}, {0x8C, 0xDE}, /* 0xD8-0xDB */
	{0x97, 0x1C}, {0x58, 0x5E}, {0x74, 0xBD}, {0x8C, 0xFD}, /* 0xDC-0xDF */
	{0x55, 0xC7}, {0xF9, 0x6C}, {0x7A, 0x61}, {0x7D, 0x22}, /* 0xE0-0xE3 */
	{0x82, 0x72}, {0x72, 0x72}, {0x75, 0x1F}, {0x75, 0x25}, /* 0xE4-0xE7 */
	{0xF9, 0x6D}, {0x7B, 0x19}, {0x58, 0x85}, {0x58, 0xFB}, /* 0xE8-0xEB */
	{0x5D, 0xBC}, {0x5E, 0x8F}, {0x5E, 0xB6}, {0x5F, 0x90}, /* 0xEC-0xEF */
	{0x60, 0x55}, {0x62, 0x92}, {0x63, 0x7F}, {0x65, 0x4D}, /* 0xF0-0xF3 */
	{0x66, 0x91}, {0x66, 0xD9}, {0x66, 0xF8}, {0x68, 0x16}, /* 0xF4-0xF7 */
	{0x68, 0xF2}, {0x72, 0x80}, {0x74, 0x5E}, {0x7B, 0x6E}, /* 0xF8-0xFB */
	{0x7D, 0x6E}, {0x7D, 0xD6}, {0x7F, 0x72}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_E0[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x80, 0xE5}, {0x82, 0x12}, {0x85, 0xAF}, /* 0xA0-0xA3 */
	{0x89, 0x7F}, {0x8A, 0x93}, {0x90, 0x1D}, {0x92, 0xE4}, /* 0xA4-0xA7 */
	{0x9E, 0xCD}, {0x9F, 0x20}, {0x59, 0x15}, {0x59, 0x6D}, /* 0xA8-0xAB */
	{0x5E, 0x2D}, {0x60, 0xDC}, {0x66, 0x14}, {0x66, 0x73}, /* 0xAC-0xAF */
	{0x67, 0x90}, {0x6C, 0x50}, {0x6D, 0xC5}, {0x6F, 0x5F}, /* 0xB0-0xB3 */
	{0x77, 0xF3}, {0x78, 0xA9}, {0x84, 0xC6}, {0x91, 0xCB}, /* 0xB4-0xB7 */
	{0x93, 0x2B}, {0x4E, 0xD9}, {0x50, 0xCA}, {0x51, 0x48}, /* 0xB8-0xBB */
	{0x55, 0x84}, {0x5B, 0x0B}, {0x5B, 0xA3}, {0x62, 0x47}, /* 0xBC-0xBF */
	{0x65, 0x7E}, {0x65, 0xCB}, {0x6E, 0x32}, {0x71, 0x7D}, /* 0xC0-0xC3 */
	{0x74, 0x01}, {0x74, 0x44}, {0x74, 0x87}, {0x74, 0xBF}, /* 0xC4-0xC7 */
	{0x76, 0x6C}, {0x79, 0xAA}, {0x7D, 0xDA}, {0x7E, 0x55}, /* 0xC8-0xCB */
	{0x7F, 0xA8}, {0x81, 0x7A}, {0x81, 0xB3}, {0x82, 0x39}, /* 0xCC-0xCF */
	{0x86, 0x1A}, {0x87, 0xEC}, {0x8A, 0x75}, {0x8D, 0xE3}, /* 0xD0-0xD3 */
	{0x90, 0x78}, {0x92, 0x91}, {0x94, 0x25}, {0x99, 0x4D}, /* 0xD4-0xD7 */
	{0x9B, 0xAE}, {0x53, 0x68}, {0x5C, 0x51}, {0x69, 0x54}, /* 0xD8-0xDB */
	{0x6C, 0xC4}, {0x6D, 0x29}, {0x6E, 0x2B}, {0x82, 0x0C}, /* 0xDC-0xDF */
	{0x85, 0x9B}, {0x89, 0x3B}, {0x8A, 0x2D}, {0x8A, 0xAA}, /* 0xE0-0xE3 */
	{0x96, 0xEA}, {0x9F, 0x67}, {0x52, 0x61}, {0x66, 0xB9}, /* 0xE4-0xE7 */
	{0x6B, 0xB2}, {0x7E, 0x96}, {0x87, 0xFE}, {0x8D, 0x0D}, /* 0xE8-0xEB */
	{0x95, 0x83}, {0x96, 0x5D}, {0x65, 0x1D}, {0x6D, 0x89}, /* 0xEC-0xEF */
	{0x71, 0xEE}, {0xF9, 0x6E}, {0x57, 0xCE}, {0x59, 0xD3}, /* 0xF0-0xF3 */
	{0x5B, 0xAC}, {0x60, 0x27}, {0x60, 0xFA}, {0x62, 0x10}, /* 0xF4-0xF7 */
	{0x66, 0x1F}, {0x66, 0x5F}, {0x73, 0x29}, {0x73, 0xF9}, /* 0xF8-0xFB */
	{0x76, 0xDB}, {0x77, 0x01}, {0x7B, 0x6C}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_E1[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x80, 0x56}, {0x80, 0x72}, {0x81, 0x65}, /* 0xA0-0xA3 */
	{0x8A, 0xA0}, {0x91, 0x92}, {0x4E, 0x16}, {0x52, 0xE2}, /* 0xA4-0xA7 */
	{0x6B, 0x72}, {0x6D, 0x17}, {0x7A, 0x05}, {0x7B, 0x39}, /* 0xA8-0xAB */
	{0x7D, 0x30}, {0xF9, 0x6F}, {0x8C, 0xB0}, {0x53, 0xEC}, /* 0xAC-0xAF */
	{0x56, 0x2F}, {0x58, 0x51}, {0x5B, 0xB5}, {0x5C, 0x0F}, /* 0xB0-0xB3 */
	{0x5C, 0x11}, {0x5D, 0xE2}, {0x62, 0x40}, {0x63, 0x83}, /* 0xB4-0xB7 */
	{0x64, 0x14}, {0x66, 0x2D}, {0x68, 0xB3}, {0x6C, 0xBC}, /* 0xB8-0xBB */
	{0x6D, 0x88}, {0x6E, 0xAF}, {0x70, 0x1F}, {0x70, 0xA4}, /* 0xBC-0xBF */
	{0x71, 0xD2}, {0x75, 0x26}, {0x75, 0x8F}, {0x75, 0x8E}, /* 0xC0-0xC3 */
	{0x76, 0x19}, {0x7B, 0x11}, {0x7B, 0xE0}, {0x7C, 0x2B}, /* 0xC4-0xC7 */
	{0x7D, 0x20}, {0x7D, 0x39}, {0x85, 0x2C}, {0x85, 0x6D}, /* 0xC8-0xCB */
	{0x86, 0x07}, {0x8A, 0x34}, {0x90, 0x0D}, {0x90, 0x61}, /* 0xCC-0xCF */
	{0x90, 0xB5}, {0x92, 0xB7}, {0x97, 0xF6}, {0x9A, 0x37}, /* 0xD0-0xD3 */
	{0x4F, 0xD7}, {0x5C, 0x6C}, {0x67, 0x5F}, {0x6D, 0x91}, /* 0xD4-0xD7 */
	{0x7C, 0x9F}, {0x7E, 0x8C}, {0x8B, 0x16}, {0x8D, 0x16}, /* 0xD8-0xDB */
	{0x90, 0x1F}, {0x5B, 0x6B}, {0x5D, 0xFD}, {0x64, 0x0D}, /* 0xDC-0xDF */
	{0x84, 0xC0}, {0x90, 0x5C}, {0x98, 0xE1}, {0x73, 0x87}, /* 0xE0-0xE3 */
	{0x5B, 0x8B}, {0x60, 0x9A}, {0x67, 0x7E}, {0x6D, 0xDE}, /* 0xE4-0xE7 */
	{0x8A, 0x1F}, {0x8A, 0xA6}, {0x90, 0x01}, {0x98, 0x0C}, /* 0xE8-0xEB */
	{0x52, 0x37}, {0xF9, 0x70}, {0x70, 0x51}, {0x78, 0x8E}, /* 0xEC-0xEF */
	{0x93, 0x96}, {0x88, 0x70}, {0x91, 0xD7}, {0x4F, 0xEE}, /* 0xF0-0xF3 */
	{0x53, 0xD7}, {0x55, 0xFD}, {0x56, 0xDA}, {0x57, 0x82}, /* 0xF4-0xF7 */
	{0x58, 0xFD}, {0x5A, 0xC2}, {0x5B, 0x88}, {0x5C, 0xAB}, /* 0xF8-0xFB */
	{0x5C, 0xC0}, {0x5E, 0x25}, {0x61, 0x01}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_E2[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x62, 0x0D}, {0x62, 0x4B}, {0x63, 0x88}, /* 0xA0-0xA3 */
	{0x64, 0x1C}, {0x65, 0x36}, {0x65, 0x78}, {0x6A, 0x39}, /* 0xA4-0xA7 */
	{0x6B, 0x8A}, {0x6C, 0x34}, {0x6D, 0x19}, {0x6F, 0x31}, /* 0xA8-0xAB */
	{0x71, 0xE7}, {0x72, 0xE9}, {0x73, 0x78}, {0x74, 0x07}, /* 0xAC-0xAF */
	{0x74, 0xB2}, {0x76, 0x26}, {0x77, 0x61}, {0x79, 0xC0}, /* 0xB0-0xB3 */
	{0x7A, 0x57}, {0x7A, 0xEA}, {0x7C, 0xB9}, {0x7D, 0x8F}, /* 0xB4-0xB7 */
	{0x7D, 0xAC}, {0x7E, 0x61}, {0x7F, 0x9E}, {0x81, 0x29}, /* 0xB8-0xBB */
	{0x83, 0x31}, {0x84, 0x90}, {0x84, 0xDA}, {0x85, 0xEA}, /* 0xBC-0xBF */
	{0x88, 0x96}, {0x8A, 0xB0}, {0x8B, 0x90}, {0x8F, 0x38}, /* 0xC0-0xC3 */
	{0x90, 0x42}, {0x90, 0x83}, {0x91, 0x6C}, {0x92, 0x96}, /* 0xC4-0xC7 */
	{0x92, 0xB9}, {0x96, 0x8B}, {0x96, 0xA7}, {0x96, 0xA8}, /* 0xC8-0xCB */
	{0x96, 0xD6}, {0x97, 0x00}, {0x98, 0x08}, {0x99, 0x96}, /* 0xCC-0xCF */
	{0x9A, 0xD3}, {0x9B, 0x1A}, {0x53, 0xD4}, {0x58, 0x7E}, /* 0xD0-0xD3 */
	{0x59, 0x19}, {0x5B, 0x70}, {0x5B, 0xBF}, {0x6D, 0xD1}, /* 0xD4-0xD7 */
	{0x6F, 0x5A}, {0x71, 0x9F}, {0x74, 0x21}, {0x74, 0xB9}, /* 0xD8-0xDB */
	{0x80, 0x85}, {0x83, 0xFD}, {0x5D, 0xE1}, {0x5F, 0x87}, /* 0xDC-0xDF */
	{0x5F, 0xAA}, {0x60, 0x42}, {0x65, 0xEC}, {0x68, 0x12}, /* 0xE0-0xE3 */
	{0x69, 0x6F}, {0x6A, 0x53}, {0x6B, 0x89}, {0x6D, 0x35}, /* 0xE4-0xE7 */
	{0x6D, 0xF3}, {0x73, 0xE3}, {0x76, 0xFE}, {0x77, 0xAC}, /* 0xE8-0xEB */
	{0x7B, 0x4D}, {0x7D, 0x14}, {0x81, 0x23}, {0x82, 0x1C}, /* 0xEC-0xEF */
	{0x83, 0x40}, {0x84, 0xF4}, {0x85, 0x63}, {0x8A, 0x62}, /* 0xF0-0xF3 */
	{0x8A, 0xC4}, {0x91, 0x87}, {0x93, 0x1E}, {0x98, 0x06}, /* 0xF4-0xF7 */
	{0x99, 0xB4}, {0x62, 0x0C}, {0x88, 0x53}, {0x8F, 0xF0}, /* 0xF8-0xFB */
	{0x92, 0x65}, {0x5D, 0x07}, {0x5D, 0x27}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_E3[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x5D, 0x69}, {0x74, 0x5F}, {0x81, 0x9D}, /* 0xA0-0xA3 */
	{0x87, 0x68}, {0x6F, 0xD5}, {0x62, 0xFE}, {0x7F, 0xD2}, /* 0xA4-0xA7 */
	{0x89, 0x36}, {0x89, 0x72}, {0x4E, 0x1E}, {0x4E, 0x58}, /* 0xA8-0xAB */
	{0x50, 0xE7}, {0x52, 0xDD}, {0x53, 0x47}, {0x62, 0x7F}, /* 0xAC-0xAF */
	{0x66, 0x07}, {0x7E, 0x69}, {0x88, 0x05}, {0x96, 0x5E}, /* 0xB0-0xB3 */
	{0x4F, 0x8D}, {0x53, 0x19}, {0x56, 0x36}, {0x59, 0xCB}, /* 0xB4-0xB7 */
	{0x5A, 0xA4}, {0x5C, 0x38}, {0x5C, 0x4E}, {0x5C, 0x4D}, /* 0xB8-0xBB */
	{0x5E, 0x02}, {0x5F, 0x11}, {0x60, 0x43}, {0x65, 0xBD}, /* 0xBC-0xBF */
	{0x66, 0x2F}, {0x66, 0x42}, {0x67, 0xBE}, {0x67, 0xF4}, /* 0xC0-0xC3 */
	{0x73, 0x1C}, {0x77, 0xE2}, {0x79, 0x3A}, {0x7F, 0xC5}, /* 0xC4-0xC7 */
	{0x84, 0x94}, {0x84, 0xCD}, {0x89, 0x96}, {0x8A, 0x66}, /* 0xC8-0xCB */
	{0x8A, 0x69}, {0x8A, 0xE1}, {0x8C, 0x55}, {0x8C, 0x7A}, /* 0xCC-0xCF */
	{0x57, 0xF4}, {0x5B, 0xD4}, {0x5F, 0x0F}, {0x60, 0x6F}, /* 0xD0-0xD3 */
	{0x62, 0xED}, {0x69, 0x0D}, {0x6B, 0x96}, {0x6E, 0x5C}, /* 0xD4-0xD7 */
	{0x71, 0x84}, {0x7B, 0xD2}, {0x87, 0x55}, {0x8B, 0x58}, /* 0xD8-0xDB */
	{0x8E, 0xFE}, {0x98, 0xDF}, {0x98, 0xFE}, {0x4F, 0x38}, /* 0xDC-0xDF */
	{0x4F, 0x81}, {0x4F, 0xE1}, {0x54, 0x7B}, {0x5A, 0x20}, /* 0xE0-0xE3 */
	{0x5B, 0xB8}, {0x61, 0x3C}, {0x65, 0xB0}, {0x66, 0x68}, /* 0xE4-0xE7 */
	{0x71, 0xFC}, {0x75, 0x33}, {0xFA, 0x19}, {0x7D, 0x33}, /* 0xE8-0xEB */
	{0x81, 0x4E}, {0x81, 0xE3}, {0x83, 0x98}, {0x85, 0xAA}, /* 0xEC-0xEF */
	{0x85, 0xCE}, {0x87, 0x03}, {0x8A, 0x0A}, {0x8E, 0xAB}, /* 0xF0-0xF3 */
	{0x8F, 0x9B}, {0xF9, 0x71}, {0x8F, 0xC5}, {0x59, 0x31}, /* 0xF4-0xF7 */
	{0x5B, 0xA4}, {0x5B, 0xE6}, {0x60, 0x89}, {0x5B, 0xE9}, /* 0xF8-0xFB */
	{0x5C, 0x0B}, {0x5F, 0xC3}, {0x6C, 0x81}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_E4[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0xF9, 0x72}, {0x6D, 0xF1}, {0x70, 0x0B}, /* 0xA0-0xA3 */
	{0x75, 0x1A}, {0x82, 0xAF}, {0x8A, 0xF6}, {0x4E, 0xC0}, /* 0xA4-0xA7 */
	{0x53, 0x41}, {0xF9, 0x73}, {0x96, 0xD9}, {0x6C, 0x0F}, /* 0xA8-0xAB */
	{0x4E, 0x9E}, {0x4F, 0xC4}, {0x51, 0x52}, {0x55, 0x5E}, /* 0xAC-0xAF */
	{0x5A, 0x25}, {0x5C, 0xE8}, {0x62, 0x11}, {0x72, 0x59}, /* 0xB0-0xB3 */
	{0x82, 0xBD}, {0x83, 0xAA}, {0x86, 0xFE}, {0x88, 0x59}, /* 0xB4-0xB7 */
	{0x8A, 0x1D}, {0x96, 0x3F}, {0x96, 0xC5}, {0x99, 0x13}, /* 0xB8-0xBB */
	{0x9D, 0x09}, {0x9D, 0x5D}, {0x58, 0x0A}, {0x5C, 0xB3}, /* 0xBC-0xBF */
	{0x5D, 0xBD}, {0x5E, 0x44}, {0x60, 0xE1}, {0x61, 0x15}, /* 0xC0-0xC3 */
	{0x63, 0xE1}, {0x6A, 0x02}, {0x6E, 0x25}, {0x91, 0x02}, /* 0xC4-0xC7 */
	{0x93, 0x54}, {0x98, 0x4E}, {0x9C, 0x10}, {0x9F, 0x77}, /* 0xC8-0xCB */
	{0x5B, 0x89}, {0x5C, 0xB8}, {0x63, 0x09}, {0x66, 0x4F}, /* 0xCC-0xCF */
	{0x68, 0x48}, {0x77, 0x3C}, {0x96, 0xC1}, {0x97, 0x8D}, /* 0xD0-0xD3 */
	{0x98, 0x54}, {0x9B, 0x9F}, {0x65, 0xA1}, {0x8B, 0x01}, /* 0xD4-0xD7 */
	{0x8E, 0xCB}, {0x95, 0xBC}, {0x55, 0x35}, {0x5C, 0xA9}, /* 0xD8-0xDB */
	{0x5D, 0xD6}, {0x5E, 0xB5}, {0x66, 0x97}, {0x76, 0x4C}, /* 0xDC-0xDF */
	{0x83, 0xF4}, {0x95, 0xC7}, {0x58, 0xD3}, {0x62, 0xBC}, /* 0xE0-0xE3 */
	{0x72, 0xCE}, {0x9D, 0x28}, {0x4E, 0xF0}, {0x59, 0x2E}, /* 0xE4-0xE7 */
	{0x60, 0x0F}, {0x66, 0x3B}, {0x6B, 0x83}, {0x79, 0xE7}, /* 0xE8-0xEB */
	{0x9D, 0x26}, {0x53, 0x93}, {0x54, 0xC0}, {0x57, 0xC3}, /* 0xEC-0xEF */
	{0x5D, 0x16}, {0x61, 0x1B}, {0x66, 0xD6}, {0x6D, 0xAF}, /* 0xF0-0xF3 */
	{0x78, 0x8D}, {0x82, 0x7E}, {0x96, 0x98}, {0x97, 0x44}, /* 0xF4-0xF7 */
	{0x53, 0x84}, {0x62, 0x7C}, {0x63, 0x96}, {0x6D, 0xB2}, /* 0xF8-0xFB */
	{0x7E, 0x0A}, {0x81, 0x4B}, {0x98, 0x4D}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_E5[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x6A, 0xFB}, {0x7F, 0x4C}, {0x9D, 0xAF}, /* 0xA0-0xA3 */
	{0x9E, 0x1A}, {0x4E, 0x5F}, {0x50, 0x3B}, {0x51, 0xB6}, /* 0xA4-0xA7 */
	{0x59, 0x1C}, {0x60, 0xF9}, {0x63, 0xF6}, {0x69, 0x30}, /* 0xA8-0xAB */
	{0x72, 0x3A}, {0x80, 0x36}, {0xF9, 0x74}, {0x91, 0xCE}, /* 0xAC-0xAF */
	{0x5F, 0x31}, {0xF9, 0x75}, {0xF9, 0x76}, {0x7D, 0x04}, /* 0xB0-0xB3 */
	{0x82, 0xE5}, {0x84, 0x6F}, {0x84, 0xBB}, {0x85, 0xE5}, /* 0xB4-0xB7 */
	{0x8E, 0x8D}, {0xF9, 0x77}, {0x4F, 0x6F}, {0xF9, 0x78}, /* 0xB8-0xBB */
	{0xF9, 0x79}, {0x58, 0xE4}, {0x5B, 0x43}, {0x60, 0x59}, /* 0xBC-0xBF */
	{0x63, 0xDA}, {0x65, 0x18}, {0x65, 0x6D}, {0x66, 0x98}, /* 0xC0-0xC3 */
	{0xF9, 0x7A}, {0x69, 0x4A}, {0x6A, 0x23}, {0x6D, 0x0B}, /* 0xC4-0xC7 */
	{0x70, 0x01}, {0x71, 0x6C}, {0x75, 0xD2}, {0x76, 0x0D}, /* 0xC8-0xCB */
	{0x79, 0xB3}, {0x7A, 0x70}, {0xF9, 0x7B}, {0x7F, 0x8A}, /* 0xCC-0xCF */
	{0xF9, 0x7C}, {0x89, 0x44}, {0xF9, 0x7D}, {0x8B, 0x93}, /* 0xD0-0xD3 */
	{0x91, 0xC0}, {0x96, 0x7D}, {0xF9, 0x7E}, {0x99, 0x0A}, /* 0xD4-0xD7 */
	{0x57, 0x04}, {0x5F, 0xA1}, {0x65, 0xBC}, {0x6F, 0x01}, /* 0xD8-0xDB */
	{0x76, 0x00}, {0x79, 0xA6}, {0x8A, 0x9E}, {0x99, 0xAD}, /* 0xDC-0xDF */
	{0x9B, 0x5A}, {0x9F, 0x6C}, {0x51, 0x04}, {0x61, 0xB6}, /* 0xE0-0xE3 */
	{0x62, 0x91}, {0x6A, 0x8D}, {0x81, 0xC6}, {0x50, 0x43}, /* 0xE4-0xE7 */
	{0x58, 0x30}, {0x5F, 0x66}, {0x71, 0x09}, {0x8A, 0x00}, /* 0xE8-0xEB */
	{0x8A, 0xFA}, {0x5B, 0x7C}, {0x86, 0x16}, {0x4F, 0xFA}, /* 0xEC-0xEF */
	{0x51, 0x3C}, {0x56, 0xB4}, {0x59, 0x44}, {0x63, 0xA9}, /* 0xF0-0xF3 */
	{0x6D, 0xF9}, {0x5D, 0xAA}, {0x69, 0x6D}, {0x51, 0x86}, /* 0xF4-0xF7 */
	{0x4E, 0x88}, {0x4F, 0x59}, {0xF9, 0x7F}, {0xF9, 0x80}, /* 0xF8-0xFB */
	{0xF9, 0x81}, {0x59, 0x82}, {0xF9, 0x82}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_E6[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0xF9, 0x83}, {0x6B, 0x5F}, {0x6C, 0x5D}, /* 0xA0-0xA3 */
	{0xF9, 0x84}, {0x74, 0xB5}, {0x79, 0x16}, {0xF9, 0x85}, /* 0xA4-0xA7 */
	{0x82, 0x07}, {0x82, 0x45}, {0x83, 0x39}, {0x8F, 0x3F}, /* 0xA8-0xAB */
	{0x8F, 0x5D}, {0xF9, 0x86}, {0x99, 0x18}, {0xF9, 0x87}, /* 0xAC-0xAF */
	{0xF9, 0x88}, {0xF9, 0x89}, {0x4E, 0xA6}, {0xF9, 0x8A}, /* 0xB0-0xB3 */
	{0x57, 0xDF}, {0x5F, 0x79}, {0x66, 0x13}, {0xF9, 0x8B}, /* 0xB4-0xB7 */
	{0xF9, 0x8C}, {0x75, 0xAB}, {0x7E, 0x79}, {0x8B, 0x6F}, /* 0xB8-0xBB */
	{0xF9, 0x8D}, {0x90, 0x06}, {0x9A, 0x5B}, {0x56, 0xA5}, /* 0xBC-0xBF */
	{0x58, 0x27}, {0x59, 0xF8}, {0x5A, 0x1F}, {0x5B, 0xB4}, /* 0xC0-0xC3 */
	{0xF9, 0x8E}, {0x5E, 0xF6}, {0xF9, 0x8F}, {0xF9, 0x90}, /* 0xC4-0xC7 */
	{0x63, 0x50}, {0x63, 0x3B}, {0xF9, 0x91}, {0x69, 0x3D}, /* 0xC8-0xCB */
	{0x6C, 0x87}, {0x6C, 0xBF}, {0x6D, 0x8E}, {0x6D, 0x93}, /* 0xCC-0xCF */
	{0x6D, 0xF5}, {0x6F, 0x14}, {0xF9, 0x92}, {0x70, 0xDF}, /* 0xD0-0xD3 */
	{0x71, 0x36}, {0x71, 0x59}, {0xF9, 0x93}, {0x71, 0xC3}, /* 0xD4-0xD7 */
	{0x71, 0xD5}, {0xF9, 0x94}, {0x78, 0x4F}, {0x78, 0x6F}, /* 0xD8-0xDB */
	{0xF9, 0x95}, {0x7B, 0x75}, {0x7D, 0xE3}, {0xF9, 0x96}, /* 0xDC-0xDF */
	{0x7E, 0x2F}, {0xF9, 0x97}, {0x88, 0x4D}, {0x8E, 0xDF}, /* 0xE0-0xE3 */
	{0xF9, 0x98}, {0xF9, 0x99}, {0xF9, 0x9A}, {0x92, 0x5B}, /* 0xE4-0xE7 */
	{0xF9, 0x9B}, {0x9C, 0xF6}, {0xF9, 0x9C}, {0xF9, 0x9D}, /* 0xE8-0xEB */
	{0xF9, 0x9E}, {0x60, 0x85}, {0x6D, 0x85}, {0xF9, 0x9F}, /* 0xEC-0xEF */
	{0x71, 0xB1}, {0xF9, 0xA0}, {0xF9, 0xA1}, {0x95, 0xB1}, /* 0xF0-0xF3 */
	{0x53, 0xAD}, {0xF9, 0xA2}, {0xF9, 0xA3}, {0xF9, 0xA4}, /* 0xF4-0xF7 */
	{0x67, 0xD3}, {0xF9, 0xA5}, {0x70, 0x8E}, {0x71, 0x30}, /* 0xF8-0xFB */
	{0x74, 0x30}, {0x82, 0x76}, {0x82, 0xD2}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_E7[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0xF9, 0xA6}, {0x95, 0xBB}, {0x9A, 0xE5}, /* 0xA0-0xA3 */
	{0x9E, 0x7D}, {0x66, 0xC4}, {0xF9, 0xA7}, {0x71, 0xC1}, /* 0xA4-0xA7 */
	{0x84, 0x49}, {0xF9, 0xA8}, {0xF9, 0xA9}, {0x58, 0x4B}, /* 0xA8-0xAB */
	{0xF9, 0xAA}, {0xF9, 0xAB}, {0x5D, 0xB8}, {0x5F, 0x71}, /* 0xAC-0xAF */
	{0xF9, 0xAC}, {0x66, 0x20}, {0x66, 0x8E}, {0x69, 0x79}, /* 0xB0-0xB3 */
	{0x69, 0xAE}, {0x6C, 0x38}, {0x6C, 0xF3}, {0x6E, 0x36}, /* 0xB4-0xB7 */
	{0x6F, 0x41}, {0x6F, 0xDA}, {0x70, 0x1B}, {0x70, 0x2F}, /* 0xB8-0xBB */
	{0x71, 0x50}, {0x71, 0xDF}, {0x73, 0x70}, {0xF9, 0xAD}, /* 0xBC-0xBF */
	{0x74, 0x5B}, {0xF9, 0xAE}, {0x74, 0xD4}, {0x76, 0xC8}, /* 0xC0-0xC3 */
	{0x7A, 0x4E}, {0x7E, 0x93}, {0xF9, 0xAF}, {0xF9, 0xB0}, /* 0xC4-0xC7 */
	{0x82, 0xF1}, {0x8A, 0x60}, {0x8F, 0xCE}, {0xF9, 0xB1}, /* 0xC8-0xCB */
	{0x93, 0x48}, {0xF9, 0xB2}, {0x97, 0x19}, {0xF9, 0xB3}, /* 0xCC-0xCF */
	{0xF9, 0xB4}, {0x4E, 0x42}, {0x50, 0x2A}, {0xF9, 0xB5}, /* 0xD0-0xD3 */
	{0x52, 0x08}, {0x53, 0xE1}, {0x66, 0xF3}, {0x6C, 0x6D}, /* 0xD4-0xD7 */
	{0x6F, 0xCA}, {0x73, 0x0A}, {0x77, 0x7F}, {0x7A, 0x62}, /* 0xD8-0xDB */
	{0x82, 0xAE}, {0x85, 0xDD}, {0x86, 0x02}, {0xF9, 0xB6}, /* 0xDC-0xDF */
	{0x88, 0xD4}, {0x8A, 0x63}, {0x8B, 0x7D}, {0x8C, 0x6B}, /* 0xE0-0xE3 */
	{0xF9, 0xB7}, {0x92, 0xB3}, {0xF9, 0xB8}, {0x97, 0x13}, /* 0xE4-0xE7 */
	{0x98, 0x10}, {0x4E, 0x94}, {0x4F, 0x0D}, {0x4F, 0xC9}, /* 0xE8-0xEB */
	{0x50, 0xB2}, {0x53, 0x48}, {0x54, 0x3E}, {0x54, 0x33}, /* 0xEC-0xEF */
	{0x55, 0xDA}, {0x58, 0x62}, {0x58, 0xBA}, {0x59, 0x67}, /* 0xF0-0xF3 */
	{0x5A, 0x1B}, {0x5B, 0xE4}, {0x60, 0x9F}, {0xF9, 0xB9}, /* 0xF4-0xF7 */
	{0x61, 0xCA}, {0x65, 0x56}, {0x65, 0xFF}, {0x66, 0x64}, /* 0xF8-0xFB */
	{0x68, 0xA7}, {0x6C, 0x5A}, {0x6F, 0xB3}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_E8[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x70, 0xCF}, {0x71, 0xAC}, {0x73, 0x52}, /* 0xA0-0xA3 */
	{0x7B, 0x7D}, {0x87, 0x08}, {0x8A, 0xA4}, {0x9C, 0x32}, /* 0xA4-0xA7 */
	{0x9F, 0x07}, {0x5C, 0x4B}, {0x6C, 0x83}, {0x73, 0x44}, /* 0xA8-0xAB */
	{0x73, 0x89}, {0x92, 0x3A}, {0x6E, 0xAB}, {0x74, 0x65}, /* 0xAC-0xAF */
	{0x76, 0x1F}, {0x7A, 0x69}, {0x7E, 0x15}, {0x86, 0x0A}, /* 0xB0-0xB3 */
	{0xFA, 0x0C}, {0x58, 0xC5}, {0x64, 0xC1}, {0x74, 0xEE}, /* 0xB4-0xB7 */
	{0x75, 0x15}, {0x76, 0x70}, {0x7F, 0xC1}, {0x90, 0x95}, /* 0xB8-0xBB */
	{0x96, 0xCD}, {0x99, 0x54}, {0x6E, 0x26}, {0x74, 0xE6}, /* 0xBC-0xBF */
	{0x7A, 0xA9}, {0x7A, 0xAA}, {0x81, 0xE5}, {0x86, 0xD9}, /* 0xC0-0xC3 */
	{0x87, 0x78}, {0x8A, 0x1B}, {0x5A, 0x49}, {0x5B, 0x8C}, /* 0xC4-0xC7 */
	{0x5B, 0x9B}, {0x68, 0xA1}, {0x69, 0x00}, {0x6D, 0x63}, /* 0xC8-0xCB */
	{0x73, 0xA9}, {0x74, 0x13}, {0x74, 0x2C}, {0x78, 0x97}, /* 0xCC-0xCF */
	{0x7D, 0xE9}, {0x7F, 0xEB}, {0x81, 0x18}, {0x81, 0x55}, /* 0xD0-0xD3 */
	{0x83, 0x9E}, {0x8C, 0x4C}, {0x96, 0x2E}, {0x98, 0x11}, /* 0xD4-0xD7 */
	{0x66, 0xF0}, {0x5F, 0x80}, {0x65, 0xFA}, {0x67, 0x89}, /* 0xD8-0xDB */
	{0x6C, 0x6A}, {0x73, 0x8B}, {0x50, 0x2D}, {0x5A, 0x03}, /* 0xDC-0xDF */
	{0x6B, 0x6A}, {0x77, 0xEE}, {0x59, 0x16}, {0x5D, 0x6C}, /* 0xE0-0xE3 */
	{0x5D, 0xCD}, {0x73, 0x25}, {0x75, 0x4F}, {0xF9, 0xBA}, /* 0xE4-0xE7 */
	{0xF9, 0xBB}, {0x50, 0xE5}, {0x51, 0xF9}, {0x58, 0x2F}, /* 0xE8-0xEB */
	{0x59, 0x2D}, {0x59, 0x96}, {0x59, 0xDA}, {0x5B, 0xE5}, /* 0xEC-0xEF */
	{0xF9, 0xBC}, {0xF9, 0xBD}, {0x5D, 0xA2}, {0x62, 0xD7}, /* 0xF0-0xF3 */
	{0x64, 0x16}, {0x64, 0x93}, {0x64, 0xFE}, {0xF9, 0xBE}, /* 0xF4-0xF7 */
	{0x66, 0xDC}, {0xF9, 0xBF}, {0x6A, 0x48}, {0xF9, 0xC0}, /* 0xF8-0xFB */
	{0x71, 0xFF}, {0x74, 0x64}, {0xF9, 0xC1}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_E9[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x7A, 0x88}, {0x7A, 0xAF}, {0x7E, 0x47}, /* 0xA0-0xA3 */
	{0x7E, 0x5E}, {0x80, 0x00}, {0x81, 0x70}, {0xF9, 0xC2}, /* 0xA4-0xA7 */
	{0x87, 0xEF}, {0x89, 0x81}, {0x8B, 0x20}, {0x90, 0x59}, /* 0xA8-0xAB */
	{0xF9, 0xC3}, {0x90, 0x80}, {0x99, 0x52}, {0x61, 0x7E}, /* 0xAC-0xAF */
	{0x6B, 0x32}, {0x6D, 0x74}, {0x7E, 0x1F}, {0x89, 0x25}, /* 0xB0-0xB3 */
	{0x8F, 0xB1}, {0x4F, 0xD1}, {0x50, 0xAD}, {0x51, 0x97}, /* 0xB4-0xB7 */
	{0x52, 0xC7}, {0x57, 0xC7}, {0x58, 0x89}, {0x5B, 0xB9}, /* 0xB8-0xBB */
	{0x5E, 0xB8}, {0x61, 0x42}, {0x69, 0x95}, {0x6D, 0x8C}, /* 0xBC-0xBF */
	{0x6E, 0x67}, {0x6E, 0xB6}, {0x71, 0x94}, {0x74, 0x62}, /* 0xC0-0xC3 */
	{0x75, 0x28}, {0x75, 0x2C}, {0x80, 0x73}, {0x83, 0x38}, /* 0xC4-0xC7 */
	{0x84, 0xC9}, {0x8E, 0x0A}, {0x93, 0x94}, {0x93, 0xDE}, /* 0xC8-0xCB */
	{0xF9, 0xC4}, {0x4E, 0x8E}, {0x4F, 0x51}, {0x50, 0x76}, /* 0xCC-0xCF */
	{0x51, 0x2A}, {0x53, 0xC8}, {0x53, 0xCB}, {0x53, 0xF3}, /* 0xD0-0xD3 */
	{0x5B, 0x87}, {0x5B, 0xD3}, {0x5C, 0x24}, {0x61, 0x1A}, /* 0xD4-0xD7 */
	{0x61, 0x82}, {0x65, 0xF4}, {0x72, 0x5B}, {0x73, 0x97}, /* 0xD8-0xDB */
	{0x74, 0x40}, {0x76, 0xC2}, {0x79, 0x50}, {0x79, 0x91}, /* 0xDC-0xDF */
	{0x79, 0xB9}, {0x7D, 0x06}, {0xFA, 0x1E}, {0x82, 0x8B}, /* 0xE0-0xE3 */
	{0x85, 0xD5}, {0x86, 0x5E}, {0x8F, 0xC2}, {0x90, 0x47}, /* 0xE4-0xE7 */
	{0x90, 0xF5}, {0x91, 0xEA}, {0x96, 0x85}, {0x96, 0xE8}, /* 0xE8-0xEB */
	{0x96, 0xE9}, {0x52, 0xD6}, {0x5F, 0x67}, {0x65, 0xED}, /* 0xEC-0xEF */
	{0x66, 0x31}, {0x68, 0x2F}, {0x71, 0x5C}, {0x7A, 0x36}, /* 0xF0-0xF3 */
	{0x90, 0xC1}, {0x98, 0x0A}, {0x4E, 0x91}, {0xF9, 0xC5}, /* 0xF4-0xF7 */
	{0x6A, 0x52}, {0x6B, 0x9E}, {0x6F, 0x90}, {0x71, 0x89}, /* 0xF8-0xFB */
	{0x80, 0x18}, {0x82, 0xB8}, {0x85, 0x53}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_EA[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x90, 0x4B}, {0x96, 0x95}, {0x96, 0xF2}, /* 0xA0-0xA3 */
	{0x97, 0xFB}, {0x85, 0x1A}, {0x9B, 0x31}, {0x4E, 0x90}, /* 0xA4-0xA7 */
	{0x71, 0x8A}, {0x96, 0xC4}, {0x51, 0x43}, {0x53, 0x9F}, /* 0xA8-0xAB */
	{0x54, 0xE1}, {0x57, 0x13}, {0x57, 0x12}, {0x57, 0xA3}, /* 0xAC-0xAF */
	{0x5A, 0x9B}, {0x5A, 0xC4}, {0x5B, 0xC3}, {0x60, 0x28}, /* 0xB0-0xB3 */
	{0x61, 0x3F}, {0x63, 0xF4}, {0x6C, 0x85}, {0x6D, 0x39}, /* 0xB4-0xB7 */
	{0x6E, 0x72}, {0x6E, 0x90}, {0x72, 0x30}, {0x73, 0x3F}, /* 0xB8-0xBB */
	{0x74, 0x57}, {0x82, 0xD1}, {0x88, 0x81}, {0x8F, 0x45}, /* 0xBC-0xBF */
	{0x90, 0x60}, {0xF9, 0xC6}, {0x96, 0x62}, {0x98, 0x58}, /* 0xC0-0xC3 */
	{0x9D, 0x1B}, {0x67, 0x08}, {0x8D, 0x8A}, {0x92, 0x5E}, /* 0xC4-0xC7 */
	{0x4F, 0x4D}, {0x50, 0x49}, {0x50, 0xDE}, {0x53, 0x71}, /* 0xC8-0xCB */
	{0x57, 0x0D}, {0x59, 0xD4}, {0x5A, 0x01}, {0x5C, 0x09}, /* 0xCC-0xCF */
	{0x61, 0x70}, {0x66, 0x90}, {0x6E, 0x2D}, {0x72, 0x32}, /* 0xD0-0xD3 */
	{0x74, 0x4B}, {0x7D, 0xEF}, {0x80, 0xC3}, {0x84, 0x0E}, /* 0xD4-0xD7 */
	{0x84, 0x66}, {0x85, 0x3F}, {0x87, 0x5F}, {0x88, 0x5B}, /* 0xD8-0xDB */
	{0x89, 0x18}, {0x8B, 0x02}, {0x90, 0x55}, {0x97, 0xCB}, /* 0xDC-0xDF */
	{0x9B, 0x4F}, {0x4E, 0x73}, {0x4F, 0x91}, {0x51, 0x12}, /* 0xE0-0xE3 */
	{0x51, 0x6A}, {0xF9, 0xC7}, {0x55, 0x2F}, {0x55, 0xA9}, /* 0xE4-0xE7 */
	{0x5B, 0x7A}, {0x5B, 0xA5}, {0x5E, 0x7C}, {0x5E, 0x7D}, /* 0xE8-0xEB */
	{0x5E, 0xBE}, {0x60, 0xA0}, {0x60, 0xDF}, {0x61, 0x08}, /* 0xEC-0xEF */
	{0x61, 0x09}, {0x63, 0xC4}, {0x65, 0x38}, {0x67, 0x09}, /* 0xF0-0xF3 */
	{0xF9, 0xC8}, {0x67, 0xD4}, {0x67, 0xDA}, {0xF9, 0xC9}, /* 0xF4-0xF7 */
	{0x69, 0x61}, {0x69, 0x62}, {0x6C, 0xB9}, {0x6D, 0x27}, /* 0xF8-0xFB */
	{0xF9, 0xCA}, {0x6E, 0x38}, {0xF9, 0xCB}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_EB[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x6F, 0xE1}, {0x73, 0x36}, {0x73, 0x37}, /* 0xA0-0xA3 */
	{0xF9, 0xCC}, {0x74, 0x5C}, {0x75, 0x31}, {0xF9, 0xCD}, /* 0xA4-0xA7 */
	{0x76, 0x52}, {0xF9, 0xCE}, {0xF9, 0xCF}, {0x7D, 0xAD}, /* 0xA8-0xAB */
	{0x81, 0xFE}, {0x84, 0x38}, {0x88, 0xD5}, {0x8A, 0x98}, /* 0xAC-0xAF */
	{0x8A, 0xDB}, {0x8A, 0xED}, {0x8E, 0x30}, {0x8E, 0x42}, /* 0xB0-0xB3 */
	{0x90, 0x4A}, {0x90, 0x3E}, {0x90, 0x7A}, {0x91, 0x49}, /* 0xB4-0xB7 */
	{0x91, 0xC9}, {0x93, 0x6E}, {0xF9, 0xD0}, {0xF9, 0xD1}, /* 0xB8-0xBB */
	{0x58, 0x09}, {0xF9, 0xD2}, {0x6B, 0xD3}, {0x80, 0x89}, /* 0xBC-0xBF */
	{0x80, 0xB2}, {0xF9, 0xD3}, {0xF9, 0xD4}, {0x51, 0x41}, /* 0xC0-0xC3 */
	{0x59, 0x6B}, {0x5C, 0x39}, {0xF9, 0xD5}, {0xF9, 0xD6}, /* 0xC4-0xC7 */
	{0x6F, 0x64}, {0x73, 0xA7}, {0x80, 0xE4}, {0x8D, 0x07}, /* 0xC8-0xCB */
	{0xF9, 0xD7}, {0x92, 0x17}, {0x95, 0x8F}, {0xF9, 0xD8}, /* 0xCC-0xCF */
	{0xF9, 0xD9}, {0xF9, 0xDA}, {0xF9, 0xDB}, {0x80, 0x7F}, /* 0xD0-0xD3 */
	{0x62, 0x0E}, {0x70, 0x1C}, {0x7D, 0x68}, {0x87, 0x8D}, /* 0xD4-0xD7 */
	{0xF9, 0xDC}, {0x57, 0xA0}, {0x60, 0x69}, {0x61, 0x47}, /* 0xD8-0xDB */
	{0x6B, 0xB7}, {0x8A, 0xBE}, {0x92, 0x80}, {0x96, 0xB1}, /* 0xDC-0xDF */
	{0x4E, 0x59}, {0x54, 0x1F}, {0x6D, 0xEB}, {0x85, 0x2D}, /* 0xE0-0xE3 */
	{0x96, 0x70}, {0x97, 0xF3}, {0x98, 0xEE}, {0x63, 0xD6}, /* 0xE4-0xE7 */
	{0x6C, 0xE3}, {0x90, 0x91}, {0x51, 0xDD}, {0x61, 0xC9}, /* 0xE8-0xEB */
	{0x81, 0xBA}, {0x9D, 0xF9}, {0x4F, 0x9D}, {0x50, 0x1A}, /* 0xEC-0xEF */
	{0x51, 0x00}, {0x5B, 0x9C}, {0x61, 0x0F}, {0x61, 0xFF}, /* 0xF0-0xF3 */
	{0x64, 0xEC}, {0x69, 0x05}, {0x6B, 0xC5}, {0x75, 0x91}, /* 0xF4-0xF7 */
	{0x77, 0xE3}, {0x7F, 0xA9}, {0x82, 0x64}, {0x85, 0x8F}, /* 0xF8-0xFB */
	{0x87, 0xFB}, {0x88, 0x63}, {0x8A, 0xBC}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_EC[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x8B, 0x70}, {0x91, 0xAB}, {0x4E, 0x8C}, /* 0xA0-0xA3 */
	{0x4E, 0xE5}, {0x4F, 0x0A}, {0xF9, 0xDD}, {0xF9, 0xDE}, /* 0xA4-0xA7 */
	{0x59, 0x37}, {0x59, 0xE8}, {0xF9, 0xDF}, {0x5D, 0xF2}, /* 0xA8-0xAB */
	{0x5F, 0x1B}, {0x5F, 0x5B}, {0x60, 0x21}, {0xF9, 0xE0}, /* 0xAC-0xAF */
	{0xF9, 0xE1}, {0xF9, 0xE2}, {0xF9, 0xE3}, {0x72, 0x3E}, /* 0xB0-0xB3 */
	{0x73, 0xE5}, {0xF9, 0xE4}, {0x75, 0x70}, {0x75, 0xCD}, /* 0xB4-0xB7 */
	{0xF9, 0xE5}, {0x79, 0xFB}, {0xF9, 0xE6}, {0x80, 0x0C}, /* 0xB8-0xBB */
	{0x80, 0x33}, {0x80, 0x84}, {0x82, 0xE1}, {0x83, 0x51}, /* 0xBC-0xBF */
	{0xF9, 0xE7}, {0xF9, 0xE8}, {0x8C, 0xBD}, {0x8C, 0xB3}, /* 0xC0-0xC3 */
	{0x90, 0x87}, {0xF9, 0xE9}, {0xF9, 0xEA}, {0x98, 0xF4}, /* 0xC4-0xC7 */
	{0x99, 0x0C}, {0xF9, 0xEB}, {0xF9, 0xEC}, {0x70, 0x37}, /* 0xC8-0xCB */
	{0xFA, 0x17}, {0x7F, 0xCA}, {0x7F, 0xCC}, {0x7F, 0xFC}, /* 0xCC-0xCF */
	{0x8B, 0x1A}, {0x4E, 0xBA}, {0x4E, 0xC1}, {0x52, 0x03}, /* 0xD0-0xD3 */
	{0x53, 0x70}, {0xF9, 0xED}, {0x54, 0xBD}, {0x56, 0xE0}, /* 0xD4-0xD7 */
	{0x59, 0xFB}, {0x5B, 0xC5}, {0x5F, 0x15}, {0x5F, 0xCD}, /* 0xD8-0xDB */
	{0x6E, 0x6E}, {0xF9, 0xEE}, {0xF9, 0xEF}, {0x7D, 0x6A}, /* 0xDC-0xDF */
	{0x83, 0x35}, {0xF9, 0xF0}, {0x86, 0x93}, {0x8A, 0x8D}, /* 0xE0-0xE3 */
	{0xF9, 0xF1}, {0x97, 0x6D}, {0x97, 0x77}, {0xF9, 0xF2}, /* 0xE4-0xE7 */
	{0xF9, 0xF3}, {0x4E, 0x00}, {0x4F, 0x5A}, {0x4F, 0x7E}, /* 0xE8-0xEB */
	{0x58, 0xF9}, {0x65, 0xE5}, {0x6E, 0xA2}, {0xFA, 0x25}, /* 0xEC-0xEF */
	{0x93, 0xB0}, {0x99, 0xB9}, {0x4E, 0xFB}, {0x58, 0xEC}, /* 0xF0-0xF3 */
	{0x59, 0x8A}, {0x59, 0xD9}, {0x60, 0x41}, {0xF9, 0xF4}, /* 0xF4-0xF7 */
	{0xF9, 0xF5}, {0x7A, 0x14}, {0xF9, 0xF6}, {0x83, 0x4F}, /* 0xF8-0xFB */
	{0x8C, 0xC3}, {0x51, 0x65}, {0x53, 0x44}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_ED[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0xF9, 0xF7}, {0xF9, 0xF8}, {0xF9, 0xF9}, /* 0xA0-0xA3 */
	{0x4E, 0xCD}, {0x52, 0x69}, {0x5B, 0x55}, {0x82, 0xBF}, /* 0xA4-0xA7 */
	{0x4E, 0xD4}, {0x52, 0x3A}, {0x54, 0xA8}, {0x59, 0xC9}, /* 0xA8-0xAB */
	{0x59, 0xFF}, {0x5B, 0x50}, {0x5B, 0x57}, {0x5B, 0x5C}, /* 0xAC-0xAF */
	{0x60, 0x63}, {0x61, 0x48}, {0x6E, 0xCB}, {0x70, 0x99}, /* 0xB0-0xB3 */
	{0x71, 0x6E}, {0x73, 0x86}, {0x74, 0xF7}, {0x75, 0xB5}, /* 0xB4-0xB7 */
	{0x78, 0xC1}, {0x7D, 0x2B}, {0x80, 0x05}, {0x81, 0xEA}, /* 0xB8-0xBB */
	{0x83, 0x28}, {0x85, 0x17}, {0x85, 0xC9}, {0x8A, 0xEE}, /* 0xBC-0xBF */
	{0x8C, 0xC7}, {0x96, 0xCC}, {0x4F, 0x5C}, {0x52, 0xFA}, /* 0xC0-0xC3 */
	{0x56, 0xBC}, {0x65, 0xAB}, {0x66, 0x28}, {0x70, 0x7C}, /* 0xC4-0xC7 */
	{0x70, 0xB8}, {0x72, 0x35}, {0x7D, 0xBD}, {0x82, 0x8D}, /* 0xC8-0xCB */
	{0x91, 0x4C}, {0x96, 0xC0}, {0x9D, 0x72}, {0x5B, 0x71}, /* 0xCC-0xCF */
	{0x68, 0xE7}, {0x6B, 0x98}, {0x6F, 0x7A}, {0x76, 0xDE}, /* 0xD0-0xD3 */
	{0x5C, 0x91}, {0x66, 0xAB}, {0x6F, 0x5B}, {0x7B, 0xB4}, /* 0xD4-0xD7 */
	{0x7C, 0x2A}, {0x88, 0x36}, {0x96, 0xDC}, {0x4E, 0x08}, /* 0xD8-0xDB */
	{0x4E, 0xD7}, {0x53, 0x20}, {0x58, 0x34}, {0x58, 0xBB}, /* 0xDC-0xDF */
	{0x58, 0xEF}, {0x59, 0x6C}, {0x5C, 0x07}, {0x5E, 0x33}, /* 0xE0-0xE3 */
	{0x5E, 0x84}, {0x5F, 0x35}, {0x63, 0x8C}, {0x66, 0xB2}, /* 0xE4-0xE7 */
	{0x67, 0x56}, {0x6A, 0x1F}, {0x6A, 0xA3}, {0x6B, 0x0C}, /* 0xE8-0xEB */
	{0x6F, 0x3F}, {0x72, 0x46}, {0xF9, 0xFA}, {0x73, 0x50}, /* 0xEC-0xEF */
	{0x74, 0x8B}, {0x7A, 0xE0}, {0x7C, 0xA7}, {0x81, 0x78}, /* 0xF0-0xF3 */
	{0x81, 0xDF}, {0x81, 0xE7}, {0x83, 0x8A}, {0x84, 0x6C}, /* 0xF4-0xF7 */
	{0x85, 0x23}, {0x85, 0x94}, {0x85, 0xCF}, {0x88, 0xDD}, /* 0xF8-0xFB */
	{0x8D, 0x13}, {0x91, 0xAC}, {0x95, 0x77}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_EE[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x96, 0x9C}, {0x51, 0x8D}, {0x54, 0xC9}, /* 0xA0-0xA3 */
	{0x57, 0x28}, {0x5B, 0xB0}, {0x62, 0x4D}, {0x67, 0x50}, /* 0xA4-0xA7 */
	{0x68, 0x3D}, {0x68, 0x93}, {0x6E, 0x3D}, {0x6E, 0xD3}, /* 0xA8-0xAB */
	{0x70, 0x7D}, {0x7E, 0x21}, {0x88, 0xC1}, {0x8C, 0xA1}, /* 0xAC-0xAF */
	{0x8F, 0x09}, {0x9F, 0x4B}, {0x9F, 0x4E}, {0x72, 0x2D}, /* 0xB0-0xB3 */
	{0x7B, 0x8F}, {0x8A, 0xCD}, {0x93, 0x1A}, {0x4F, 0x47}, /* 0xB4-0xB7 */
	{0x4F, 0x4E}, {0x51, 0x32}, {0x54, 0x80}, {0x59, 0xD0}, /* 0xB8-0xBB */
	{0x5E, 0x95}, {0x62, 0xB5}, {0x67, 0x75}, {0x69, 0x6E}, /* 0xBC-0xBF */
	{0x6A, 0x17}, {0x6C, 0xAE}, {0x6E, 0x1A}, {0x72, 0xD9}, /* 0xC0-0xC3 */
	{0x73, 0x2A}, {0x75, 0xBD}, {0x7B, 0xB8}, {0x7D, 0x35}, /* 0xC4-0xC7 */
	{0x82, 0xE7}, {0x83, 0xF9}, {0x84, 0x57}, {0x85, 0xF7}, /* 0xC8-0xCB */
	{0x8A, 0x5B}, {0x8C, 0xAF}, {0x8E, 0x87}, {0x90, 0x19}, /* 0xCC-0xCF */
	{0x90, 0xB8}, {0x96, 0xCE}, {0x9F, 0x5F}, {0x52, 0xE3}, /* 0xD0-0xD3 */
	{0x54, 0x0A}, {0x5A, 0xE1}, {0x5B, 0xC2}, {0x64, 0x58}, /* 0xD4-0xD7 */
	{0x65, 0x75}, {0x6E, 0xF4}, {0x72, 0xC4}, {0xF9, 0xFB}, /* 0xD8-0xDB */
	{0x76, 0x84}, {0x7A, 0x4D}, {0x7B, 0x1B}, {0x7C, 0x4D}, /* 0xDC-0xDF */
	{0x7E, 0x3E}, {0x7F, 0xDF}, {0x83, 0x7B}, {0x8B, 0x2B}, /* 0xE0-0xE3 */
	{0x8C, 0xCA}, {0x8D, 0x64}, {0x8D, 0xE1}, {0x8E, 0x5F}, /* 0xE4-0xE7 */
	{0x8F, 0xEA}, {0x8F, 0xF9}, {0x90, 0x69}, {0x93, 0xD1}, /* 0xE8-0xEB */
	{0x4F, 0x43}, {0x4F, 0x7A}, {0x50, 0xB3}, {0x51, 0x68}, /* 0xEC-0xEF */
	{0x51, 0x78}, {0x52, 0x4D}, {0x52, 0x6A}, {0x58, 0x61}, /* 0xF0-0xF3 */
	{0x58, 0x7C}, {0x59, 0x60}, {0x5C, 0x08}, {0x5C, 0x55}, /* 0xF4-0xF7 */
	{0x5E, 0xDB}, {0x60, 0x9B}, {0x62, 0x30}, {0x68, 0x13}, /* 0xF8-0xFB */
	{0x6B, 0xBF}, {0x6C, 0x08}, {0x6F, 0xB1}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_EF[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x71, 0x4E}, {0x74, 0x20}, {0x75, 0x30}, /* 0xA0-0xA3 */
	{0x75, 0x38}, {0x75, 0x51}, {0x76, 0x72}, {0x7B, 0x4C}, /* 0xA4-0xA7 */
	{0x7B, 0x8B}, {0x7B, 0xAD}, {0x7B, 0xC6}, {0x7E, 0x8F}, /* 0xA8-0xAB */
	{0x8A, 0x6E}, {0x8F, 0x3E}, {0x8F, 0x49}, {0x92, 0x3F}, /* 0xAC-0xAF */
	{0x92, 0x93}, {0x93, 0x22}, {0x94, 0x2B}, {0x96, 0xFB}, /* 0xB0-0xB3 */
	{0x98, 0x5A}, {0x98, 0x6B}, {0x99, 0x1E}, {0x52, 0x07}, /* 0xB4-0xB7 */
	{0x62, 0x2A}, {0x62, 0x98}, {0x6D, 0x59}, {0x76, 0x64}, /* 0xB8-0xBB */
	{0x7A, 0xCA}, {0x7B, 0xC0}, {0x7D, 0x76}, {0x53, 0x60}, /* 0xBC-0xBF */
	{0x5C, 0xBE}, {0x5E, 0x97}, {0x6F, 0x38}, {0x70, 0xB9}, /* 0xC0-0xC3 */
	{0x7C, 0x98}, {0x97, 0x11}, {0x9B, 0x8E}, {0x9E, 0xDE}, /* 0xC4-0xC7 */
	{0x63, 0xA5}, {0x64, 0x7A}, {0x87, 0x76}, {0x4E, 0x01}, /* 0xC8-0xCB */
	{0x4E, 0x95}, {0x4E, 0xAD}, {0x50, 0x5C}, {0x50, 0x75}, /* 0xCC-0xCF */
	{0x54, 0x48}, {0x59, 0xC3}, {0x5B, 0x9A}, {0x5E, 0x40}, /* 0xD0-0xD3 */
	{0x5E, 0xAD}, {0x5E, 0xF7}, {0x5F, 0x81}, {0x60, 0xC5}, /* 0xD4-0xD7 */
	{0x63, 0x3A}, {0x65, 0x3F}, {0x65, 0x74}, {0x65, 0xCC}, /* 0xD8-0xDB */
	{0x66, 0x76}, {0x66, 0x78}, {0x67, 0xFE}, {0x69, 0x68}, /* 0xDC-0xDF */
	{0x6A, 0x89}, {0x6B, 0x63}, {0x6C, 0x40}, {0x6D, 0xC0}, /* 0xE0-0xE3 */
	{0x6D, 0xE8}, {0x6E, 0x1F}, {0x6E, 0x5E}, {0x70, 0x1E}, /* 0xE4-0xE7 */
	{0x70, 0xA1}, {0x73, 0x8E}, {0x73, 0xFD}, {0x75, 0x3A}, /* 0xE8-0xEB */
	{0x77, 0x5B}, {0x78, 0x87}, {0x79, 0x8E}, {0x7A, 0x0B}, /* 0xEC-0xEF */
	{0x7A, 0x7D}, {0xFA, 0x1D}, {0x7D, 0x8E}, {0x82, 0x47}, /* 0xF0-0xF3 */
	{0x8A, 0x02}, {0x8A, 0xEA}, {0x8C, 0x9E}, {0x91, 0x2D}, /* 0xF4-0xF7 */
	{0x91, 0x4A}, {0x91, 0xD8}, {0x92, 0x66}, {0x92, 0xCC}, /* 0xF8-0xFB */
	{0x93, 0x20}, {0x97, 0x06}, {0xFA, 0x1C}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_F0[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x97, 0x5C}, {0x98, 0x02}, {0x9F, 0x0E}, /* 0xA0-0xA3 */
	{0x52, 0x36}, {0x52, 0x91}, {0x55, 0x7C}, {0x58, 0x24}, /* 0xA4-0xA7 */
	{0x5E, 0x1D}, {0x5F, 0x1F}, {0x60, 0x8C}, {0x63, 0xD0}, /* 0xA8-0xAB */
	{0x68, 0xAF}, {0x6F, 0xDF}, {0x79, 0x6D}, {0x7B, 0x2C}, /* 0xAC-0xAF */
	{0x81, 0xCD}, {0x85, 0xBA}, {0x88, 0xFD}, {0xFA, 0x22}, /* 0xB0-0xB3 */
	{0x8E, 0x44}, {0x91, 0x8D}, {0x96, 0x64}, {0x96, 0x9B}, /* 0xB4-0xB7 */
	{0x97, 0x3D}, {0x98, 0x4C}, {0x9F, 0x4A}, {0x4F, 0xCE}, /* 0xB8-0xBB */
	{0x51, 0x46}, {0x51, 0xCB}, {0x52, 0xA9}, {0x56, 0x32}, /* 0xBC-0xBF */
	{0x5F, 0x14}, {0x5F, 0x6B}, {0x63, 0xAA}, {0x64, 0xCD}, /* 0xC0-0xC3 */
	{0x65, 0xE9}, {0x66, 0x41}, {0x66, 0xFA}, {0x66, 0xF9}, /* 0xC4-0xC7 */
	{0x67, 0x1D}, {0x68, 0x9D}, {0x68, 0xD7}, {0x69, 0xFD}, /* 0xC8-0xCB */
	{0x6F, 0x15}, {0x6F, 0x6E}, {0x71, 0x67}, {0x71, 0xE5}, /* 0xCC-0xCF */
	{0x72, 0x2A}, {0x74, 0xAA}, {0x77, 0x3A}, {0x79, 0x56}, /* 0xD0-0xD3 */
	{0x79, 0x5A}, {0x79, 0xDF}, {0x7A, 0x20}, {0x7A, 0x95}, /* 0xD4-0xD7 */
	{0x7C, 0x97}, {0x7C, 0xDF}, {0x7D, 0x44}, {0x7E, 0x70}, /* 0xD8-0xDB */
	{0x80, 0x87}, {0x85, 0xFB}, {0x86, 0xA4}, {0x8A, 0x54}, /* 0xDC-0xDF */
	{0x8A, 0xBF}, {0x8D, 0x99}, {0x8E, 0x81}, {0x90, 0x20}, /* 0xE0-0xE3 */
	{0x90, 0x6D}, {0x91, 0xE3}, {0x96, 0x3B}, {0x96, 0xD5}, /* 0xE4-0xE7 */
	{0x9C, 0xE5}, {0x65, 0xCF}, {0x7C, 0x07}, {0x8D, 0xB3}, /* 0xE8-0xEB */
	{0x93, 0xC3}, {0x5B, 0x58}, {0x5C, 0x0A}, {0x53, 0x52}, /* 0xEC-0xEF */
	{0x62, 0xD9}, {0x73, 0x1D}, {0x50, 0x27}, {0x5B, 0x97}, /* 0xF0-0xF3 */
	{0x5F, 0x9E}, {0x60, 0xB0}, {0x61, 0x6B}, {0x68, 0xD5}, /* 0xF4-0xF7 */
	{0x6D, 0xD9}, {0x74, 0x2E}, {0x7A, 0x2E}, {0x7D, 0x42}, /* 0xF8-0xFB */
	{0x7D, 0x9C}, {0x7E, 0x31}, {0x81, 0x6B}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_F1[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x8E, 0x2A}, {0x8E, 0x35}, {0x93, 0x7E}, /* 0xA0-0xA3 */
	{0x94, 0x18}, {0x4F, 0x50}, {0x57, 0x50}, {0x5D, 0xE6}, /* 0xA4-0xA7 */
	{0x5E, 0xA7}, {0x63, 0x2B}, {0x7F, 0x6A}, {0x4E, 0x3B}, /* 0xA8-0xAB */
	{0x4F, 0x4F}, {0x4F, 0x8F}, {0x50, 0x5A}, {0x59, 0xDD}, /* 0xAC-0xAF */
	{0x80, 0xC4}, {0x54, 0x6A}, {0x54, 0x68}, {0x55, 0xFE}, /* 0xB0-0xB3 */
	{0x59, 0x4F}, {0x5B, 0x99}, {0x5D, 0xDE}, {0x5E, 0xDA}, /* 0xB4-0xB7 */
	{0x66, 0x5D}, {0x67, 0x31}, {0x67, 0xF1}, {0x68, 0x2A}, /* 0xB8-0xBB */
	{0x6C, 0xE8}, {0x6D, 0x32}, {0x6E, 0x4A}, {0x6F, 0x8D}, /* 0xBC-0xBF */
	{0x70, 0xB7}, {0x73, 0xE0}, {0x75, 0x87}, {0x7C, 0x4C}, /* 0xC0-0xC3 */
	{0x7D, 0x02}, {0x7D, 0x2C}, {0x7D, 0xA2}, {0x82, 0x1F}, /* 0xC4-0xC7 */
	{0x86, 0xDB}, {0x8A, 0x3B}, {0x8A, 0x85}, {0x8D, 0x70}, /* 0xC8-0xCB */
	{0x8E, 0x8A}, {0x8F, 0x33}, {0x90, 0x31}, {0x91, 0x4E}, /* 0xCC-0xCF */
	{0x91, 0x52}, {0x94, 0x44}, {0x99, 0xD0}, {0x7A, 0xF9}, /* 0xD0-0xD3 */
	{0x7C, 0xA5}, {0x4F, 0xCA}, {0x51, 0x01}, {0x51, 0xC6}, /* 0xD4-0xD7 */
	{0x57, 0xC8}, {0x5B, 0xEF}, {0x5C, 0xFB}, {0x66, 0x59}, /* 0xD8-0xDB */
	{0x6A, 0x3D}, {0x6D, 0x5A}, {0x6E, 0x96}, {0x6F, 0xEC}, /* 0xDC-0xDF */
	{0x71, 0x0C}, {0x75, 0x6F}, {0x7A, 0xE3}, {0x88, 0x22}, /* 0xE0-0xE3 */
	{0x90, 0x21}, {0x90, 0x75}, {0x96, 0xCB}, {0x99, 0xFF}, /* 0xE4-0xE7 */
	{0x83, 0x01}, {0x4E, 0x2D}, {0x4E, 0xF2}, {0x88, 0x46}, /* 0xE8-0xEB */
	{0x91, 0xCD}, {0x53, 0x7D}, {0x6A, 0xDB}, {0x69, 0x6B}, /* 0xEC-0xEF */
	{0x6C, 0x41}, {0x84, 0x7A}, {0x58, 0x9E}, {0x61, 0x8E}, /* 0xF0-0xF3 */
	{0x66, 0xFE}, {0x62, 0xEF}, {0x70, 0xDD}, {0x75, 0x11}, /* 0xF4-0xF7 */
	{0x75, 0xC7}, {0x7E, 0x52}, {0x84, 0xB8}, {0x8B, 0x49}, /* 0xF8-0xFB */
	{0x8D, 0x08}, {0x4E, 0x4B}, {0x53, 0xEA}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_F2[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x54, 0xAB}, {0x57, 0x30}, {0x57, 0x40}, /* 0xA0-0xA3 */
	{0x5F, 0xD7}, {0x63, 0x01}, {0x63, 0x07}, {0x64, 0x6F}, /* 0xA4-0xA7 */
	{0x65, 0x2F}, {0x65, 0xE8}, {0x66, 0x7A}, {0x67, 0x9D}, /* 0xA8-0xAB */
	{0x67, 0xB3}, {0x6B, 0x62}, {0x6C, 0x60}, {0x6C, 0x9A}, /* 0xAC-0xAF */
	{0x6F, 0x2C}, {0x77, 0xE5}, {0x78, 0x25}, {0x79, 0x49}, /* 0xB0-0xB3 */
	{0x79, 0x57}, {0x7D, 0x19}, {0x80, 0xA2}, {0x81, 0x02}, /* 0xB4-0xB7 */
	{0x81, 0xF3}, {0x82, 0x9D}, {0x82, 0xB7}, {0x87, 0x18}, /* 0xB8-0xBB */
	{0x8A, 0x8C}, {0xF9, 0xFC}, {0x8D, 0x04}, {0x8D, 0xBE}, /* 0xBC-0xBF */
	{0x90, 0x72}, {0x76, 0xF4}, {0x7A, 0x19}, {0x7A, 0x37}, /* 0xC0-0xC3 */
	{0x7E, 0x54}, {0x80, 0x77}, {0x55, 0x07}, {0x55, 0xD4}, /* 0xC4-0xC7 */
	{0x58, 0x75}, {0x63, 0x2F}, {0x64, 0x22}, {0x66, 0x49}, /* 0xC8-0xCB */
	{0x66, 0x4B}, {0x68, 0x6D}, {0x69, 0x9B}, {0x6B, 0x84}, /* 0xCC-0xCF */
	{0x6D, 0x25}, {0x6E, 0xB1}, {0x73, 0xCD}, {0x74, 0x68}, /* 0xD0-0xD3 */
	{0x74, 0xA1}, {0x75, 0x5B}, {0x75, 0xB9}, {0x76, 0xE1}, /* 0xD4-0xD7 */
	{0x77, 0x1E}, {0x77, 0x8B}, {0x79, 0xE6}, {0x7E, 0x09}, /* 0xD8-0xDB */
	{0x7E, 0x1D}, {0x81, 0xFB}, {0x85, 0x2F}, {0x88, 0x97}, /* 0xDC-0xDF */
	{0x8A, 0x3A}, {0x8C, 0xD1}, {0x8E, 0xEB}, {0x8F, 0xB0}, /* 0xE0-0xE3 */
	{0x90, 0x32}, {0x93, 0xAD}, {0x96, 0x63}, {0x96, 0x73}, /* 0xE4-0xE7 */
	{0x97, 0x07}, {0x4F, 0x84}, {0x53, 0xF1}, {0x59, 0xEA}, /* 0xE8-0xEB */
	{0x5A, 0xC9}, {0x5E, 0x19}, {0x68, 0x4E}, {0x74, 0xC6}, /* 0xEC-0xEF */
	{0x75, 0xBE}, {0x79, 0xE9}, {0x7A, 0x92}, {0x81, 0xA3}, /* 0xF0-0xF3 */
	{0x86, 0xED}, {0x8C, 0xEA}, {0x8D, 0xCC}, {0x8F, 0xED}, /* 0xF4-0xF7 */
	{0x65, 0x9F}, {0x67, 0x15}, {0xF9, 0xFD}, {0x57, 0xF7}, /* 0xF8-0xFB */
	{0x6F, 0x57}, {0x7D, 0xDD}, {0x8F, 0x2F}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_F3[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x93, 0xF6}, {0x96, 0xC6}, {0x5F, 0xB5}, /* 0xA0-0xA3 */
	{0x61, 0xF2}, {0x6F, 0x84}, {0x4E, 0x14}, {0x4F, 0x98}, /* 0xA4-0xA7 */
	{0x50, 0x1F}, {0x53, 0xC9}, {0x55, 0xDF}, {0x5D, 0x6F}, /* 0xA8-0xAB */
	{0x5D, 0xEE}, {0x6B, 0x21}, {0x6B, 0x64}, {0x78, 0xCB}, /* 0xAC-0xAF */
	{0x7B, 0x9A}, {0xF9, 0xFE}, {0x8E, 0x49}, {0x8E, 0xCA}, /* 0xB0-0xB3 */
	{0x90, 0x6E}, {0x63, 0x49}, {0x64, 0x3E}, {0x77, 0x40}, /* 0xB4-0xB7 */
	{0x7A, 0x84}, {0x93, 0x2F}, {0x94, 0x7F}, {0x9F, 0x6A}, /* 0xB8-0xBB */
	{0x64, 0xB0}, {0x6F, 0xAF}, {0x71, 0xE6}, {0x74, 0xA8}, /* 0xBC-0xBF */
	{0x74, 0xDA}, {0x7A, 0xC4}, {0x7C, 0x12}, {0x7E, 0x82}, /* 0xC0-0xC3 */
	{0x7C, 0xB2}, {0x7E, 0x98}, {0x8B, 0x9A}, {0x8D, 0x0A}, /* 0xC4-0xC7 */
	{0x94, 0x7D}, {0x99, 0x10}, {0x99, 0x4C}, {0x52, 0x39}, /* 0xC8-0xCB */
	{0x5B, 0xDF}, {0x64, 0xE6}, {0x67, 0x2D}, {0x7D, 0x2E}, /* 0xCC-0xCF */
	{0x50, 0xED}, {0x53, 0xC3}, {0x58, 0x79}, {0x61, 0x58}, /* 0xD0-0xD3 */
	{0x61, 0x59}, {0x61, 0xFA}, {0x65, 0xAC}, {0x7A, 0xD9}, /* 0xD4-0xD7 */
	{0x8B, 0x92}, {0x8B, 0x96}, {0x50, 0x09}, {0x50, 0x21}, /* 0xD8-0xDB */
	{0x52, 0x75}, {0x55, 0x31}, {0x5A, 0x3C}, {0x5E, 0xE0}, /* 0xDC-0xDF */
	{0x5F, 0x70}, {0x61, 0x34}, {0x65, 0x5E}, {0x66, 0x0C}, /* 0xE0-0xE3 */
	{0x66, 0x36}, {0x66, 0xA2}, {0x69, 0xCD}, {0x6E, 0xC4}, /* 0xE4-0xE7 */
	{0x6F, 0x32}, {0x73, 0x16}, {0x76, 0x21}, {0x7A, 0x93}, /* 0xE8-0xEB */
	{0x81, 0x39}, {0x82, 0x59}, {0x83, 0xD6}, {0x84, 0xBC}, /* 0xEC-0xEF */
	{0x50, 0xB5}, {0x57, 0xF0}, {0x5B, 0xC0}, {0x5B, 0xE8}, /* 0xF0-0xF3 */
	{0x5F, 0x69}, {0x63, 0xA1}, {0x78, 0x26}, {0x7D, 0xB5}, /* 0xF4-0xF7 */
	{0x83, 0xDC}, {0x85, 0x21}, {0x91, 0xC7}, {0x91, 0xF5}, /* 0xF8-0xFB */
	{0x51, 0x8A}, {0x67, 0xF5}, {0x7B, 0x56}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_F4[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x8C, 0xAC}, {0x51, 0xC4}, {0x59, 0xBB}, /* 0xA0-0xA3 */
	{0x60, 0xBD}, {0x86, 0x55}, {0x50, 0x1C}, {0xF9, 0xFF}, /* 0xA4-0xA7 */
	{0x52, 0x54}, {0x5C, 0x3A}, {0x61, 0x7D}, {0x62, 0x1A}, /* 0xA8-0xAB */
	{0x62, 0xD3}, {0x64, 0xF2}, {0x65, 0xA5}, {0x6E, 0xCC}, /* 0xAC-0xAF */
	{0x76, 0x20}, {0x81, 0x0A}, {0x8E, 0x60}, {0x96, 0x5F}, /* 0xB0-0xB3 */
	{0x96, 0xBB}, {0x4E, 0xDF}, {0x53, 0x43}, {0x55, 0x98}, /* 0xB4-0xB7 */
	{0x59, 0x29}, {0x5D, 0xDD}, {0x64, 0xC5}, {0x6C, 0xC9}, /* 0xB8-0xBB */
	{0x6D, 0xFA}, {0x73, 0x94}, {0x7A, 0x7F}, {0x82, 0x1B}, /* 0xBC-0xBF */
	{0x85, 0xA6}, {0x8C, 0xE4}, {0x8E, 0x10}, {0x90, 0x77}, /* 0xC0-0xC3 */
	{0x91, 0xE7}, {0x95, 0xE1}, {0x96, 0x21}, {0x97, 0xC6}, /* 0xC4-0xC7 */
	{0x51, 0xF8}, {0x54, 0xF2}, {0x55, 0x86}, {0x5F, 0xB9}, /* 0xC8-0xCB */
	{0x64, 0xA4}, {0x6F, 0x88}, {0x7D, 0xB4}, {0x8F, 0x1F}, /* 0xCC-0xCF */
	{0x8F, 0x4D}, {0x94, 0x35}, {0x50, 0xC9}, {0x5C, 0x16}, /* 0xD0-0xD3 */
	{0x6C, 0xBE}, {0x6D, 0xFB}, {0x75, 0x1B}, {0x77, 0xBB}, /* 0xD4-0xD7 */
	{0x7C, 0x3D}, {0x7C, 0x64}, {0x8A, 0x79}, {0x8A, 0xC2}, /* 0xD8-0xDB */
	{0x58, 0x1E}, {0x59, 0xBE}, {0x5E, 0x16}, {0x63, 0x77}, /* 0xDC-0xDF */
	{0x72, 0x52}, {0x75, 0x8A}, {0x77, 0x6B}, {0x8A, 0xDC}, /* 0xE0-0xE3 */
	{0x8C, 0xBC}, {0x8F, 0x12}, {0x5E, 0xF3}, {0xFA, 0x12}, /* 0xE4-0xE7 */
	{0x6D, 0xF8}, {0x80, 0x7D}, {0x83, 0xC1}, {0x8A, 0xCB}, /* 0xE8-0xEB */
	{0x97, 0x51}, {0x9B, 0xD6}, {0xFA, 0x00}, {0x52, 0x43}, /* 0xEC-0xEF */
	{0x66, 0xFF}, {0x6D, 0x95}, {0x6E, 0xEF}, {0x7D, 0xE0}, /* 0xF0-0xF3 */
	{0x8A, 0xE6}, {0x90, 0x2E}, {0x90, 0x5E}, {0x9A, 0xD4}, /* 0xF4-0xF7 */
	{0x52, 0x1D}, {0x52, 0x7F}, {0x54, 0xE8}, {0x61, 0x94}, /* 0xF8-0xFB */
	{0x62, 0x84}, {0x62, 0xDB}, {0x68, 0xA2}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_F5[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x69, 0x12}, {0x69, 0x5A}, {0x6A, 0x35}, /* 0xA0-0xA3 */
	{0x70, 0x92}, {0x71, 0x26}, {0x78, 0x5D}, {0x79, 0x01}, /* 0xA4-0xA7 */
	{0x79, 0x0E}, {0x79, 0xD2}, {0x7A, 0x0D}, {0x80, 0x96}, /* 0xA8-0xAB */
	{0x82, 0x78}, {0x82, 0xD5}, {0x83, 0x49}, {0x85, 0x49}, /* 0xAC-0xAF */
	{0x8C, 0x82}, {0x8D, 0x85}, {0x91, 0x62}, {0x91, 0x8B}, /* 0xB0-0xB3 */
	{0x91, 0xAE}, {0x4F, 0xC3}, {0x56, 0xD1}, {0x71, 0xED}, /* 0xB4-0xB7 */
	{0x77, 0xD7}, {0x87, 0x00}, {0x89, 0xF8}, {0x5B, 0xF8}, /* 0xB8-0xBB */
	{0x5F, 0xD6}, {0x67, 0x51}, {0x90, 0xA8}, {0x53, 0xE2}, /* 0xBC-0xBF */
	{0xFA, 0x10}, {0x5B, 0xF5}, {0x60, 0xA4}, {0x61, 0x81}, /* 0xC0-0xC3 */
	{0x64, 0x60}, {0x7E, 0x3D}, {0x80, 0x70}, {0x85, 0x25}, /* 0xC4-0xC7 */
	{0x92, 0x83}, {0x64, 0xAE}, {0x50, 0xAC}, {0x5D, 0x14}, /* 0xC8-0xCB */
	{0x67, 0x00}, {0x58, 0x9C}, {0x62, 0xBD}, {0x63, 0xA8}, /* 0xCC-0xCF */
	{0x69, 0x0E}, {0x69, 0x78}, {0x6A, 0x1E}, {0x6E, 0x6B}, /* 0xD0-0xD3 */
	{0x76, 0xBA}, {0x79, 0xCB}, {0x82, 0xBB}, {0x84, 0x29}, /* 0xD4-0xD7 */
	{0x8A, 0xCF}, {0x8D, 0xA8}, {0x8F, 0xFD}, {0x91, 0x12}, /* 0xD8-0xDB */
	{0x91, 0x4B}, {0x91, 0x9C}, {0x93, 0x10}, {0x93, 0x18}, /* 0xDC-0xDF */
	{0x93, 0x9A}, {0x96, 0xDB}, {0x9A, 0x36}, {0x9C, 0x0D}, /* 0xE0-0xE3 */
	{0x4E, 0x11}, {0x75, 0x5C}, {0x79, 0x5D}, {0x7A, 0xFA}, /* 0xE4-0xE7 */
	{0x7B, 0x51}, {0x7B, 0xC9}, {0x7E, 0x2E}, {0x84, 0xC4}, /* 0xE8-0xEB */
	{0x8E, 0x59}, {0x8E, 0x74}, {0x8E, 0xF8}, {0x90, 0x10}, /* 0xEC-0xEF */
	{0x66, 0x25}, {0x69, 0x3F}, {0x74, 0x43}, {0x51, 0xFA}, /* 0xF0-0xF3 */
	{0x67, 0x2E}, {0x9E, 0xDC}, {0x51, 0x45}, {0x5F, 0xE0}, /* 0xF4-0xF7 */
	{0x6C, 0x96}, {0x87, 0xF2}, {0x88, 0x5D}, {0x88, 0x77}, /* 0xF8-0xFB */
	{0x60, 0xB4}, {0x81, 0xB5}, {0x84, 0x03}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_F6[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x8D, 0x05}, {0x53, 0xD6}, {0x54, 0x39}, /* 0xA0-0xA3 */
	{0x56, 0x34}, {0x5A, 0x36}, {0x5C, 0x31}, {0x70, 0x8A}, /* 0xA4-0xA7 */
	{0x7F, 0xE0}, {0x80, 0x5A}, {0x81, 0x06}, {0x81, 0xED}, /* 0xA8-0xAB */
	{0x8D, 0xA3}, {0x91, 0x89}, {0x9A, 0x5F}, {0x9D, 0xF2}, /* 0xAC-0xAF */
	{0x50, 0x74}, {0x4E, 0xC4}, {0x53, 0xA0}, {0x60, 0xFB}, /* 0xB0-0xB3 */
	{0x6E, 0x2C}, {0x5C, 0x64}, {0x4F, 0x88}, {0x50, 0x24}, /* 0xB4-0xB7 */
	{0x55, 0xE4}, {0x5C, 0xD9}, {0x5E, 0x5F}, {0x60, 0x65}, /* 0xB8-0xBB */
	{0x68, 0x94}, {0x6C, 0xBB}, {0x6D, 0xC4}, {0x71, 0xBE}, /* 0xBC-0xBF */
	{0x75, 0xD4}, {0x75, 0xF4}, {0x76, 0x61}, {0x7A, 0x1A}, /* 0xC0-0xC3 */
	{0x7A, 0x49}, {0x7D, 0xC7}, {0x7D, 0xFB}, {0x7F, 0x6E}, /* 0xC4-0xC7 */
	{0x81, 0xF4}, {0x86, 0xA9}, {0x8F, 0x1C}, {0x96, 0xC9}, /* 0xC8-0xCB */
	{0x99, 0xB3}, {0x9F, 0x52}, {0x52, 0x47}, {0x52, 0xC5}, /* 0xCC-0xCF */
	{0x98, 0xED}, {0x89, 0xAA}, {0x4E, 0x03}, {0x67, 0xD2}, /* 0xD0-0xD3 */
	{0x6F, 0x06}, {0x4F, 0xB5}, {0x5B, 0xE2}, {0x67, 0x95}, /* 0xD4-0xD7 */
	{0x6C, 0x88}, {0x6D, 0x78}, {0x74, 0x1B}, {0x78, 0x27}, /* 0xD8-0xDB */
	{0x91, 0xDD}, {0x93, 0x7C}, {0x87, 0xC4}, {0x79, 0xE4}, /* 0xDC-0xDF */
	{0x7A, 0x31}, {0x5F, 0xEB}, {0x4E, 0xD6}, {0x54, 0xA4}, /* 0xE0-0xE3 */
	{0x55, 0x3E}, {0x58, 0xAE}, {0x59, 0xA5}, {0x60, 0xF0}, /* 0xE4-0xE7 */
	{0x62, 0x53}, {0x62, 0xD6}, {0x67, 0x36}, {0x69, 0x55}, /* 0xE8-0xEB */
	{0x82, 0x35}, {0x96, 0x40}, {0x99, 0xB1}, {0x99, 0xDD}, /* 0xEC-0xEF */
	{0x50, 0x2C}, {0x53, 0x53}, {0x55, 0x44}, {0x57, 0x7C}, /* 0xF0-0xF3 */
	{0xFA, 0x01}, {0x62, 0x58}, {0xFA, 0x02}, {0x64, 0xE2}, /* 0xF4-0xF7 */
	{0x66, 0x6B}, {0x67, 0xDD}, {0x6F, 0xC1}, {0x6F, 0xEF}, /* 0xF8-0xFB */
	{0x74, 0x22}, {0x74, 0x38}, {0x8A, 0x17}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_F7[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x94, 0x38}, {0x54, 0x51}, {0x56, 0x06}, /* 0xA0-0xA3 */
	{0x57, 0x66}, {0x5F, 0x48}, {0x61, 0x9A}, {0x6B, 0x4E}, /* 0xA4-0xA7 */
	{0x70, 0x58}, {0x70, 0xAD}, {0x7D, 0xBB}, {0x8A, 0x95}, /* 0xA8-0xAB */
	{0x59, 0x6A}, {0x81, 0x2B}, {0x63, 0xA2}, {0x77, 0x08}, /* 0xAC-0xAF */
	{0x80, 0x3D}, {0x8C, 0xAA}, {0x58, 0x54}, {0x64, 0x2D}, /* 0xB0-0xB3 */
	{0x69, 0xBB}, {0x5B, 0x95}, {0x5E, 0x11}, {0x6E, 0x6F}, /* 0xB4-0xB7 */
	{0xFA, 0x03}, {0x85, 0x69}, {0x51, 0x4C}, {0x53, 0xF0}, /* 0xB8-0xBB */
	{0x59, 0x2A}, {0x60, 0x20}, {0x61, 0x4B}, {0x6B, 0x86}, /* 0xBC-0xBF */
	{0x6C, 0x70}, {0x6C, 0xF0}, {0x7B, 0x1E}, {0x80, 0xCE}, /* 0xC0-0xC3 */
	{0x82, 0xD4}, {0x8D, 0xC6}, {0x90, 0xB0}, {0x98, 0xB1}, /* 0xC4-0xC7 */
	{0xFA, 0x04}, {0x64, 0xC7}, {0x6F, 0xA4}, {0x64, 0x91}, /* 0xC8-0xCB */
	{0x65, 0x04}, {0x51, 0x4E}, {0x54, 0x10}, {0x57, 0x1F}, /* 0xCC-0xCF */
	{0x8A, 0x0E}, {0x61, 0x5F}, {0x68, 0x76}, {0xFA, 0x05}, /* 0xD0-0xD3 */
	{0x75, 0xDB}, {0x7B, 0x52}, {0x7D, 0x71}, {0x90, 0x1A}, /* 0xD4-0xD7 */
	{0x58, 0x06}, {0x69, 0xCC}, {0x81, 0x7F}, {0x89, 0x2A}, /* 0xD8-0xDB */
	{0x90, 0x00}, {0x98, 0x39}, {0x50, 0x78}, {0x59, 0x57}, /* 0xDC-0xDF */
	{0x59, 0xAC}, {0x62, 0x95}, {0x90, 0x0F}, {0x9B, 0x2A}, /* 0xE0-0xE3 */
	{0x61, 0x5D}, {0x72, 0x79}, {0x95, 0xD6}, {0x57, 0x61}, /* 0xE4-0xE7 */
	{0x5A, 0x46}, {0x5D, 0xF4}, {0x62, 0x8A}, {0x64, 0xAD}, /* 0xE8-0xEB */
	{0x64, 0xFA}, {0x67, 0x77}, {0x6C, 0xE2}, {0x6D, 0x3E}, /* 0xEC-0xEF */
	{0x72, 0x2C}, {0x74, 0x36}, {0x78, 0x34}, {0x7F, 0x77}, /* 0xF0-0xF3 */
	{0x82, 0xAD}, {0x8D, 0xDB}, {0x98, 0x17}, {0x52, 0x24}, /* 0xF4-0xF7 */
	{0x57, 0x42}, {0x67, 0x7F}, {0x72, 0x48}, {0x74, 0xE3}, /* 0xF8-0xFB */
	{0x8C, 0xA9}, {0x8F, 0xA6}, {0x92, 0x11}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_F8[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x96, 0x2A}, {0x51, 0x6B}, {0x53, 0xED}, /* 0xA0-0xA3 */
	{0x63, 0x4C}, {0x4F, 0x69}, {0x55, 0x04}, {0x60, 0x96}, /* 0xA4-0xA7 */
	{0x65, 0x57}, {0x6C, 0x9B}, {0x6D, 0x7F}, {0x72, 0x4C}, /* 0xA8-0xAB */
	{0x72, 0xFD}, {0x7A, 0x17}, {0x89, 0x87}, {0x8C, 0x9D}, /* 0xAC-0xAF */
	{0x5F, 0x6D}, {0x6F, 0x8E}, {0x70, 0xF9}, {0x81, 0xA8}, /* 0xB0-0xB3 */
	{0x61, 0x0E}, {0x4F, 0xBF}, {0x50, 0x4F}, {0x62, 0x41}, /* 0xB4-0xB7 */
	{0x72, 0x47}, {0x7B, 0xC7}, {0x7D, 0xE8}, {0x7F, 0xE9}, /* 0xB8-0xBB */
	{0x90, 0x4D}, {0x97, 0xAD}, {0x9A, 0x19}, {0x8C, 0xB6}, /* 0xBC-0xBF */
	{0x57, 0x6A}, {0x5E, 0x73}, {0x67, 0xB0}, {0x84, 0x0D}, /* 0xC0-0xC3 */
	{0x8A, 0x55}, {0x54, 0x20}, {0x5B, 0x16}, {0x5E, 0x63}, /* 0xC4-0xC7 */
	{0x5E, 0xE2}, {0x5F, 0x0A}, {0x65, 0x83}, {0x80, 0xBA}, /* 0xC8-0xCB */
	{0x85, 0x3D}, {0x95, 0x89}, {0x96, 0x5B}, {0x4F, 0x48}, /* 0xCC-0xCF */
	{0x53, 0x05}, {0x53, 0x0D}, {0x53, 0x0F}, {0x54, 0x86}, /* 0xD0-0xD3 */
	{0x54, 0xFA}, {0x57, 0x03}, {0x5E, 0x03}, {0x60, 0x16}, /* 0xD4-0xD7 */
	{0x62, 0x9B}, {0x62, 0xB1}, {0x63, 0x55}, {0xFA, 0x06}, /* 0xD8-0xDB */
	{0x6C, 0xE1}, {0x6D, 0x66}, {0x75, 0xB1}, {0x78, 0x32}, /* 0xDC-0xDF */
	{0x80, 0xDE}, {0x81, 0x2F}, {0x82, 0xDE}, {0x84, 0x61}, /* 0xE0-0xE3 */
	{0x84, 0xB2}, {0x88, 0x8D}, {0x89, 0x12}, {0x90, 0x0B}, /* 0xE4-0xE7 */
	{0x92, 0xEA}, {0x98, 0xFD}, {0x9B, 0x91}, {0x5E, 0x45}, /* 0xE8-0xEB */
	{0x66, 0xB4}, {0x66, 0xDD}, {0x70, 0x11}, {0x72, 0x06}, /* 0xEC-0xEF */
	{0xFA, 0x07}, {0x4F, 0xF5}, {0x52, 0x7D}, {0x5F, 0x6A}, /* 0xF0-0xF3 */
	{0x61, 0x53}, {0x67, 0x53}, {0x6A, 0x19}, {0x6F, 0x02}, /* 0xF4-0xF7 */
	{0x74, 0xE2}, {0x79, 0x68}, {0x88, 0x68}, {0x8C, 0x79}, /* 0xF8-0xFB */
	{0x98, 0xC7}, {0x98, 0xC4}, {0x9A, 0x43}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_F9[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x54, 0xC1}, {0x7A, 0x1F}, {0x69, 0x53}, /* 0xA0-0xA3 */
	{0x8A, 0xF7}, {0x8C, 0x4A}, {0x98, 0xA8}, {0x99, 0xAE}, /* 0xA4-0xA7 */
	{0x5F, 0x7C}, {0x62, 0xAB}, {0x75, 0xB2}, {0x76, 0xAE}, /* 0xA8-0xAB */
	{0x88, 0xAB}, {0x90, 0x7F}, {0x96, 0x42}, {0x53, 0x39}, /* 0xAC-0xAF */
	{0x5F, 0x3C}, {0x5F, 0xC5}, {0x6C, 0xCC}, {0x73, 0xCC}, /* 0xB0-0xB3 */
	{0x75, 0x62}, {0x75, 0x8B}, {0x7B, 0x46}, {0x82, 0xFE}, /* 0xB4-0xB7 */
	{0x99, 0x9D}, {0x4E, 0x4F}, {0x90, 0x3C}, {0x4E, 0x0B}, /* 0xB8-0xBB */
	{0x4F, 0x55}, {0x53, 0xA6}, {0x59, 0x0F}, {0x5E, 0xC8}, /* 0xBC-0xBF */
	{0x66, 0x30}, {0x6C, 0xB3}, {0x74, 0x55}, {0x83, 0x77}, /* 0xC0-0xC3 */
	{0x87, 0x66}, {0x8C, 0xC0}, {0x90, 0x50}, {0x97, 0x1E}, /* 0xC4-0xC7 */
	{0x9C, 0x15}, {0x58, 0xD1}, {0x5B, 0x78}, {0x86, 0x50}, /* 0xC8-0xCB */
	{0x8B, 0x14}, {0xFA, 0x2D}, {0x5B, 0xD2}, {0x60, 0x68}, /* 0xCC-0xCF */
	{0x60, 0x8D}, {0x65, 0xF1}, {0x6C, 0x57}, {0x6F, 0x22}, /* 0xD0-0xD3 */
	{0x6F, 0xA3}, {0x70, 0x1A}, {0x7F, 0x55}, {0x7F, 0xF0}, /* 0xD4-0xD7 */
	{0x95, 0x91}, {0x95, 0x92}, {0x96, 0x50}, {0x97, 0xD3}, /* 0xD8-0xDB */
	{0x52, 0x72}, {0x8F, 0x44}, {0x51, 0xFD}, {0x54, 0x2B}, /* 0xDC-0xDF */
	{0x54, 0xB8}, {0x55, 0x63}, {0x55, 0x8A}, {0x6A, 0xBB}, /* 0xE0-0xE3 */
	{0x6D, 0xB5}, {0x7D, 0xD8}, {0x82, 0x66}, {0x92, 0x9C}, /* 0xE4-0xE7 */
	{0x96, 0x77}, {0x9E, 0x79}, {0x54, 0x08}, {0x54, 0xC8}, /* 0xE8-0xEB */
	{0x76, 0xD2}, {0x86, 0xE4}, {0x95, 0xA4}, {0x95, 0xD4}, /* 0xEC-0xEF */
	{0x96, 0x5C}, {0x4E, 0xA2}, {0x4F, 0x09}, {0x59, 0xEE}, /* 0xF0-0xF3 */
	{0x5A, 0xE6}, {0x5D, 0xF7}, {0x60, 0x52}, {0x62, 0x97}, /* 0xF4-0xF7 */
	{0x67, 0x6D}, {0x68, 0x41}, {0x6C, 0x86}, {0x6E, 0x2F}, /* 0xF8-0xFB */
	{0x7F, 0x38}, {0x80, 0x9B}, {0x82, 0x2A}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_FA[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0xFA, 0x08}, {0xFA, 0x09}, {0x98, 0x05}, /* 0xA0-0xA3 */
	{0x4E, 0xA5}, {0x50, 0x55}, {0x54, 0xB3}, {0x57, 0x93}, /* 0xA4-0xA7 */
	{0x59, 0x5A}, {0x5B, 0x69}, {0x5B, 0xB3}, {0x61, 0xC8}, /* 0xA8-0xAB */
	{0x69, 0x77}, {0x6D, 0x77}, {0x70, 0x23}, {0x87, 0xF9}, /* 0xAC-0xAF */
	{0x89, 0xE3}, {0x8A, 0x72}, {0x8A, 0xE7}, {0x90, 0x82}, /* 0xB0-0xB3 */
	{0x99, 0xED}, {0x9A, 0xB8}, {0x52, 0xBE}, {0x68, 0x38}, /* 0xB4-0xB7 */
	{0x50, 0x16}, {0x5E, 0x78}, {0x67, 0x4F}, {0x83, 0x47}, /* 0xB8-0xBB */
	{0x88, 0x4C}, {0x4E, 0xAB}, {0x54, 0x11}, {0x56, 0xAE}, /* 0xBC-0xBF */
	{0x73, 0xE6}, {0x91, 0x15}, {0x97, 0xFF}, {0x99, 0x09}, /* 0xC0-0xC3 */
	{0x99, 0x57}, {0x99, 0x99}, {0x56, 0x53}, {0x58, 0x9F}, /* 0xC4-0xC7 */
	{0x86, 0x5B}, {0x8A, 0x31}, {0x61, 0xB2}, {0x6A, 0xF6}, /* 0xC8-0xCB */
	{0x73, 0x7B}, {0x8E, 0xD2}, {0x6B, 0x47}, {0x96, 0xAA}, /* 0xCC-0xCF */
	{0x9A, 0x57}, {0x59, 0x55}, {0x72, 0x00}, {0x8D, 0x6B}, /* 0xD0-0xD3 */
	{0x97, 0x69}, {0x4F, 0xD4}, {0x5C, 0xF4}, {0x5F, 0x26}, /* 0xD4-0xD7 */
	{0x61, 0xF8}, {0x66, 0x5B}, {0x6C, 0xEB}, {0x70, 0xAB}, /* 0xD8-0xDB */
	{0x73, 0x84}, {0x73, 0xB9}, {0x73, 0xFE}, {0x77, 0x29}, /* 0xDC-0xDF */
	{0x77, 0x4D}, {0x7D, 0x43}, {0x7D, 0x62}, {0x7E, 0x23}, /* 0xE0-0xE3 */
	{0x82, 0x37}, {0x88, 0x52}, {0xFA, 0x0A}, {0x8C, 0xE2}, /* 0xE4-0xE7 */
	{0x92, 0x49}, {0x98, 0x6F}, {0x5B, 0x51}, {0x7A, 0x74}, /* 0xE8-0xEB */
	{0x88, 0x40}, {0x98, 0x01}, {0x5A, 0xCC}, {0x4F, 0xE0}, /* 0xEC-0xEF */
	{0x53, 0x54}, {0x59, 0x3E}, {0x5C, 0xFD}, {0x63, 0x3E}, /* 0xF0-0xF3 */
	{0x6D, 0x79}, {0x72, 0xF9}, {0x81, 0x05}, {0x81, 0x07}, /* 0xF4-0xF7 */
	{0x83, 0xA2}, {0x92, 0xCF}, {0x98, 0x30}, {0x4E, 0xA8}, /* 0xF8-0xFB */
	{0x51, 0x44}, {0x52, 0x11}, {0x57, 0x8B}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_FB[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x5F, 0x62}, {0x6C, 0xC2}, {0x6E, 0xCE}, /* 0xA0-0xA3 */
	{0x70, 0x05}, {0x70, 0x50}, {0x70, 0xAF}, {0x71, 0x92}, /* 0xA4-0xA7 */
	{0x73, 0xE9}, {0x74, 0x69}, {0x83, 0x4A}, {0x87, 0xA2}, /* 0xA8-0xAB */
	{0x88, 0x61}, {0x90, 0x08}, {0x90, 0xA2}, {0x93, 0xA3}, /* 0xAC-0xAF */
	{0x99, 0xA8}, {0x51, 0x6E}, {0x5F, 0x57}, {0x60, 0xE0}, /* 0xB0-0xB3 */
	{0x61, 0x67}, {0x66, 0xB3}, {0x85, 0x59}, {0x8E, 0x4A}, /* 0xB4-0xB7 */
	{0x91, 0xAF}, {0x97, 0x8B}, {0x4E, 0x4E}, {0x4E, 0x92}, /* 0xB8-0xBB */
	{0x54, 0x7C}, {0x58, 0xD5}, {0x58, 0xFA}, {0x59, 0x7D}, /* 0xBC-0xBF */
	{0x5C, 0xB5}, {0x5F, 0x27}, {0x62, 0x36}, {0x62, 0x48}, /* 0xC0-0xC3 */
	{0x66, 0x0A}, {0x66, 0x67}, {0x6B, 0xEB}, {0x6D, 0x69}, /* 0xC4-0xC7 */
	{0x6D, 0xCF}, {0x6E, 0x56}, {0x6E, 0xF8}, {0x6F, 0x94}, /* 0xC8-0xCB */
	{0x6F, 0xE0}, {0x6F, 0xE9}, {0x70, 0x5D}, {0x72, 0xD0}, /* 0xCC-0xCF */
	{0x74, 0x25}, {0x74, 0x5A}, {0x74, 0xE0}, {0x76, 0x93}, /* 0xD0-0xD3 */
	{0x79, 0x5C}, {0x7C, 0xCA}, {0x7E, 0x1E}, {0x80, 0xE1}, /* 0xD4-0xD7 */
	{0x82, 0xA6}, {0x84, 0x6B}, {0x84, 0xBF}, {0x86, 0x4E}, /* 0xD8-0xDB */
	{0x86, 0x5F}, {0x87, 0x74}, {0x8B, 0x77}, {0x8C, 0x6A}, /* 0xDC-0xDF */
	{0x93, 0xAC}, {0x98, 0x00}, {0x98, 0x65}, {0x60, 0xD1}, /* 0xE0-0xE3 */
	{0x62, 0x16}, {0x91, 0x77}, {0x5A, 0x5A}, {0x66, 0x0F}, /* 0xE4-0xE7 */
	{0x6D, 0xF7}, {0x6E, 0x3E}, {0x74, 0x3F}, {0x9B, 0x42}, /* 0xE8-0xEB */
	{0x5F, 0xFD}, {0x60, 0xDA}, {0x7B, 0x0F}, {0x54, 0xC4}, /* 0xEC-0xEF */
	{0x5F, 0x18}, {0x6C, 0x5E}, {0x6C, 0xD3}, {0x6D, 0x2A}, /* 0xF0-0xF3 */
	{0x70, 0xD8}, {0x7D, 0x05}, {0x86, 0x79}, {0x8A, 0x0C}, /* 0xF4-0xF7 */
	{0x9D, 0x3B}, {0x53, 0x16}, {0x54, 0x8C}, {0x5B, 0x05}, /* 0xF8-0xFB */
	{0x6A, 0x3A}, {0x70, 0x6B}, {0x75, 0x75}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_FC[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x79, 0x8D}, {0x79, 0xBE}, {0x82, 0xB1}, /* 0xA0-0xA3 */
	{0x83, 0xEF}, {0x8A, 0x71}, {0x8B, 0x41}, {0x8C, 0xA8}, /* 0xA4-0xA7 */
	{0x97, 0x74}, {0xFA, 0x0B}, {0x64, 0xF4}, {0x65, 0x2B}, /* 0xA8-0xAB */
	{0x78, 0xBA}, {0x78, 0xBB}, {0x7A, 0x6B}, {0x4E, 0x38}, /* 0xAC-0xAF */
	{0x55, 0x9A}, {0x59, 0x50}, {0x5B, 0xA6}, {0x5E, 0x7B}, /* 0xB0-0xB3 */
	{0x60, 0xA3}, {0x63, 0xDB}, {0x6B, 0x61}, {0x66, 0x65}, /* 0xB4-0xB7 */
	{0x68, 0x53}, {0x6E, 0x19}, {0x71, 0x65}, {0x74, 0xB0}, /* 0xB8-0xBB */
	{0x7D, 0x08}, {0x90, 0x84}, {0x9A, 0x69}, {0x9C, 0x25}, /* 0xBC-0xBF */
	{0x6D, 0x3B}, {0x6E, 0xD1}, {0x73, 0x3E}, {0x8C, 0x41}, /* 0xC0-0xC3 */
	{0x95, 0xCA}, {0x51, 0xF0}, {0x5E, 0x4C}, {0x5F, 0xA8}, /* 0xC4-0xC7 */
	{0x60, 0x4D}, {0x60, 0xF6}, {0x61, 0x30}, {0x61, 0x4C}, /* 0xC8-0xCB */
	{0x66, 0x43}, {0x66, 0x44}, {0x69, 0xA5}, {0x6C, 0xC1}, /* 0xCC-0xCF */
	{0x6E, 0x5F}, {0x6E, 0xC9}, {0x6F, 0x62}, {0x71, 0x4C}, /* 0xD0-0xD3 */
	{0x74, 0x9C}, {0x76, 0x87}, {0x7B, 0xC1}, {0x7C, 0x27}, /* 0xD4-0xD7 */
	{0x83, 0x52}, {0x87, 0x57}, {0x90, 0x51}, {0x96, 0x8D}, /* 0xD8-0xDB */
	{0x9E, 0xC3}, {0x53, 0x2F}, {0x56, 0xDE}, {0x5E, 0xFB}, /* 0xDC-0xDF */
	{0x5F, 0x8A}, {0x60, 0x62}, {0x60, 0x94}, {0x61, 0xF7}, /* 0xE0-0xE3 */
	{0x66, 0x66}, {0x67, 0x03}, {0x6A, 0x9C}, {0x6D, 0xEE}, /* 0xE4-0xE7 */
	{0x6F, 0xAE}, {0x70, 0x70}, {0x73, 0x6A}, {0x7E, 0x6A}, /* 0xE8-0xEB */
	{0x81, 0xBE}, {0x83, 0x34}, {0x86, 0xD4}, {0x8A, 0xA8}, /* 0xEC-0xEF */
	{0x8C, 0xC4}, {0x52, 0x83}, {0x73, 0x72}, {0x5B, 0x96}, /* 0xF0-0xF3 */
	{0x6A, 0x6B}, {0x94, 0x04}, {0x54, 0xEE}, {0x56, 0x86}, /* 0xF4-0xF7 */
	{0x5B, 0x5D}, {0x65, 0x48}, {0x65, 0x85}, {0x66, 0xC9}, /* 0xF8-0xFB */
	{0x68, 0x9F}, {0x6D, 0x8D}, {0x6D, 0xC6}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode c2u_FD[256] = {
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x00-0x03 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x04-0x07 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x08-0x0B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x0C-0x0F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x10-0x13 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x14-0x17 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x18-0x1B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x1C-0x1F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x20-0x23 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x24-0x27 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x28-0x2B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x2C-0x2F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x30-0x33 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x34-0x37 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x38-0x3B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x3C-0x3F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x40-0x43 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x44-0x47 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x48-0x4B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x4C-0x4F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x50-0x53 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x54-0x57 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x58-0x5B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x5C-0x5F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x60-0x63 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x64-0x67 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x68-0x6B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x6C-0x6F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x70-0x73 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x74-0x77 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x78-0x7B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x7C-0x7F */
	
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x80-0x83 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x84-0x87 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x88-0x8B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x8C-0x8F */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x90-0x93 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x94-0x97 */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x98-0x9B */
	{0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, {0x00, 0x3F}, /* 0x9C-0x9F */
	{0x00, 0x3F}, {0x72, 0x3B}, {0x80, 0xB4}, {0x91, 0x75}, /* 0xA0-0xA3 */
	{0x9A, 0x4D}, {0x4F, 0xAF}, {0x50, 0x19}, {0x53, 0x9A}, /* 0xA4-0xA7 */
	{0x54, 0x0E}, {0x54, 0x3C}, {0x55, 0x89}, {0x55, 0xC5}, /* 0xA8-0xAB */
	{0x5E, 0x3F}, {0x5F, 0x8C}, {0x67, 0x3D}, {0x71, 0x66}, /* 0xAC-0xAF */
	{0x73, 0xDD}, {0x90, 0x05}, {0x52, 0xDB}, {0x52, 0xF3}, /* 0xB0-0xB3 */
	{0x58, 0x64}, {0x58, 0xCE}, {0x71, 0x04}, {0x71, 0x8F}, /* 0xB4-0xB7 */
	{0x71, 0xFB}, {0x85, 0xB0}, {0x8A, 0x13}, {0x66, 0x88}, /* 0xB8-0xBB */
	{0x85, 0xA8}, {0x55, 0xA7}, {0x66, 0x84}, {0x71, 0x4A}, /* 0xBC-0xBF */
	{0x84, 0x31}, {0x53, 0x49}, {0x55, 0x99}, {0x6B, 0xC1}, /* 0xC0-0xC3 */
	{0x5F, 0x59}, {0x5F, 0xBD}, {0x63, 0xEE}, {0x66, 0x89}, /* 0xC4-0xC7 */
	{0x71, 0x47}, {0x8A, 0xF1}, {0x8F, 0x1D}, {0x9E, 0xBE}, /* 0xC8-0xCB */
	{0x4F, 0x11}, {0x64, 0x3A}, {0x70, 0xCB}, {0x75, 0x66}, /* 0xCC-0xCF */
	{0x86, 0x67}, {0x60, 0x64}, {0x8B, 0x4E}, {0x9D, 0xF8}, /* 0xD0-0xD3 */
	{0x51, 0x47}, {0x51, 0xF6}, {0x53, 0x08}, {0x6D, 0x36}, /* 0xD4-0xD7 */
	{0x80, 0xF8}, {0x9E, 0xD1}, {0x66, 0x15}, {0x6B, 0x23}, /* 0xD8-0xDB */
	{0x70, 0x98}, {0x75, 0xD5}, {0x54, 0x03}, {0x5C, 0x79}, /* 0xDC-0xDF */
	{0x7D, 0x07}, {0x8A, 0x16}, {0x6B, 0x20}, {0x6B, 0x3D}, /* 0xE0-0xE3 */
	{0x6B, 0x46}, {0x54, 0x38}, {0x60, 0x70}, {0x6D, 0x3D}, /* 0xE4-0xE7 */
	{0x7F, 0xD5}, {0x82, 0x08}, {0x50, 0xD6}, {0xFA, 0x15}, /* 0xE8-0xEB */
	{0x55, 0x9C}, {0x56, 0x6B}, {0x56, 0xCD}, {0x59, 0xEC}, /* 0xEC-0xEF */
	{0x5B, 0x09}, {0x5E, 0x0C}, {0x61, 0x99}, {0x61, 0x98}, /* 0xF0-0xF3 */
	{0x62, 0x31}, {0x66, 0x5E}, {0x66, 0xE6}, {0x71, 0x99}, /* 0xF4-0xF7 */
	{0x71, 0xB9}, {0x71, 0xBA}, {0x72, 0xA7}, {0x79, 0xA7}, /* 0xF8-0xFB */
	{0x7A, 0x00}, {0x7F, 0xB2}, {0x8A, 0x70}, {0x00, 0x3F}, /* 0xFC-0xFF */
};

static struct nls_unicode *page_charset2uni[256] = {
	NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   
	NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   
	NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   
	NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   
	NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   
	NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   
	NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   
	NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   
	NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   
	NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   
	NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   
	NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   
	NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   
	NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   
	NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   
	NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   NULL,   
	NULL,   c2u_81, c2u_82, c2u_83, c2u_84, c2u_85, c2u_86, c2u_87, 
	c2u_88, c2u_89, c2u_8A, c2u_8B, c2u_8C, c2u_8D, c2u_8E, c2u_8F, 
	c2u_90, c2u_91, c2u_92, c2u_93, c2u_94, c2u_95, c2u_96, c2u_97, 
	c2u_98, c2u_99, c2u_9A, c2u_9B, c2u_9C, c2u_9D, c2u_9E, c2u_9F, 
	c2u_A0, c2u_A1, c2u_A2, c2u_A3, c2u_A4, c2u_A5, c2u_A6, c2u_A7, 
	c2u_A8, c2u_A9, c2u_AA, c2u_AB, c2u_AC, c2u_AD, c2u_AE, c2u_AF, 
	c2u_B0, c2u_B1, c2u_B2, c2u_B3, c2u_B4, c2u_B5, c2u_B6, c2u_B7, 
	c2u_B8, c2u_B9, c2u_BA, c2u_BB, c2u_BC, c2u_BD, c2u_BE, c2u_BF, 
	c2u_C0, c2u_C1, c2u_C2, c2u_C3, c2u_C4, c2u_C5, c2u_C6, c2u_C7, 
	c2u_C8, NULL,   c2u_CA, c2u_CB, c2u_CC, c2u_CD, c2u_CE, c2u_CF, 
	c2u_D0, c2u_D1, c2u_D2, c2u_D3, c2u_D4, c2u_D5, c2u_D6, c2u_D7, 
	c2u_D8, c2u_D9, c2u_DA, c2u_DB, c2u_DC, c2u_DD, c2u_DE, c2u_DF, 
	c2u_E0, c2u_E1, c2u_E2, c2u_E3, c2u_E4, c2u_E5, c2u_E6, c2u_E7, 
	c2u_E8, c2u_E9, c2u_EA, c2u_EB, c2u_EC, c2u_ED, c2u_EE, c2u_EF, 
	c2u_F0, c2u_F1, c2u_F2, c2u_F3, c2u_F4, c2u_F5, c2u_F6, c2u_F7, 
	c2u_F8, c2u_F9, c2u_FA, c2u_FB, c2u_FC, c2u_FD, NULL,   NULL,   
};

static unsigned char u2c_01[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0xA9, 0xA2, 0xA9, 0xA2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA8, 0xA4, 0xA9, 0xA4, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0xA9, 0xA5, 0xA8, 0xA6, 0xA9, 0xA6, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0xA9, 0xA7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xA8, 0xA8, /* 0x3C-0x3F */
	0xA9, 0xA8, 0xA8, 0xA9, 0xA9, 0xA9, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0xA9, 0xB0, 0xA8, 0xAF, 0xA9, 0xAF, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA8, 0xAB, 0xA9, 0xAB, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA8, 0xAE, 0xA9, 0xAE, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_02[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xA2, 0xA7, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0xA2, 0xB0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0xA2, 0xA8, 0xA2, 0xAB, 0xA2, 0xAA, 0xA2, 0xAD, /* 0xD8-0xDB */
	0x3F, 0x3F, 0xA2, 0xA9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_03[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0xA5, 0xC1, 0xA5, 0xC2, 0xA5, 0xC3, /* 0x90-0x93 */
	0xA5, 0xC4, 0xA5, 0xC5, 0xA5, 0xC6, 0xA5, 0xC7, /* 0x94-0x97 */
	0xA5, 0xC8, 0xA5, 0xC9, 0xA5, 0xCA, 0xA5, 0xCB, /* 0x98-0x9B */
	0xA5, 0xCC, 0xA5, 0xCD, 0xA5, 0xCE, 0xA5, 0xCF, /* 0x9C-0x9F */
	0xA5, 0xD0, 0xA5, 0xD1, 0x3F, 0x3F, 0xA5, 0xD2, /* 0xA0-0xA3 */
	0xA5, 0xD3, 0xA5, 0xD4, 0xA5, 0xD5, 0xA5, 0xD6, /* 0xA4-0xA7 */
	0xA5, 0xD7, 0xA5, 0xD8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0xA5, 0xE1, 0xA5, 0xE2, 0xA5, 0xE3, /* 0xB0-0xB3 */
	0xA5, 0xE4, 0xA5, 0xE5, 0xA5, 0xE6, 0xA5, 0xE7, /* 0xB4-0xB7 */
	0xA5, 0xE8, 0xA5, 0xE9, 0xA5, 0xEA, 0xA5, 0xEB, /* 0xB8-0xBB */
	0xA5, 0xEC, 0xA5, 0xED, 0xA5, 0xEE, 0xA5, 0xEF, /* 0xBC-0xBF */
	0xA5, 0xF0, 0xA5, 0xF1, 0x3F, 0x3F, 0xA5, 0xF2, /* 0xC0-0xC3 */
	0xA5, 0xF3, 0xA5, 0xF4, 0xA5, 0xF5, 0xA5, 0xF6, /* 0xC4-0xC7 */
	0xA5, 0xF7, 0xA5, 0xF8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_04[512] = {
	0x3F, 0x3F, 0xAC, 0xA7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0xAC, 0xA1, 0xAC, 0xA2, 0xAC, 0xA3, 0xAC, 0xA4, /* 0x10-0x13 */
	0xAC, 0xA5, 0xAC, 0xA6, 0xAC, 0xA8, 0xAC, 0xA9, /* 0x14-0x17 */
	0xAC, 0xAA, 0xAC, 0xAB, 0xAC, 0xAC, 0xAC, 0xAD, /* 0x18-0x1B */
	0xAC, 0xAE, 0xAC, 0xAF, 0xAC, 0xB0, 0xAC, 0xB1, /* 0x1C-0x1F */
	0xAC, 0xB2, 0xAC, 0xB3, 0xAC, 0xB4, 0xAC, 0xB5, /* 0x20-0x23 */
	0xAC, 0xB6, 0xAC, 0xB7, 0xAC, 0xB8, 0xAC, 0xB9, /* 0x24-0x27 */
	0xAC, 0xBA, 0xAC, 0xBB, 0xAC, 0xBC, 0xAC, 0xBD, /* 0x28-0x2B */
	0xAC, 0xBE, 0xAC, 0xBF, 0xAC, 0xC0, 0xAC, 0xC1, /* 0x2C-0x2F */
	0xAC, 0xD1, 0xAC, 0xD2, 0xAC, 0xD3, 0xAC, 0xD4, /* 0x30-0x33 */
	0xAC, 0xD5, 0xAC, 0xD6, 0xAC, 0xD8, 0xAC, 0xD9, /* 0x34-0x37 */
	0xAC, 0xDA, 0xAC, 0xDB, 0xAC, 0xDC, 0xAC, 0xDD, /* 0x38-0x3B */
	0xAC, 0xDE, 0xAC, 0xDF, 0xAC, 0xE0, 0xAC, 0xE1, /* 0x3C-0x3F */
	0xAC, 0xE2, 0xAC, 0xE3, 0xAC, 0xE4, 0xAC, 0xE5, /* 0x40-0x43 */
	0xAC, 0xE6, 0xAC, 0xE7, 0xAC, 0xE8, 0xAC, 0xE9, /* 0x44-0x47 */
	0xAC, 0xEA, 0xAC, 0xEB, 0xAC, 0xEC, 0xAC, 0xED, /* 0x48-0x4B */
	0xAC, 0xEE, 0xAC, 0xEF, 0xAC, 0xF0, 0xAC, 0xF1, /* 0x4C-0x4F */
	0x3F, 0x3F, 0xAC, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_11[512] = {
	0xA4, 0xA1, 0xA4, 0xA2, 0xA4, 0xA4, 0xA4, 0xA7, /* 0x00-0x03 */
	0xA4, 0xA8, 0xA4, 0xA9, 0xA4, 0xB1, 0xA4, 0xB2, /* 0x04-0x07 */
	0xA4, 0xB3, 0xA4, 0xB5, 0xA4, 0xB6, 0xA4, 0xB7, /* 0x08-0x0B */
	0xA4, 0xB8, 0xA4, 0xB9, 0xA4, 0xBA, 0xA4, 0xBB, /* 0x0C-0x0F */
	0xA4, 0xBC, 0xA4, 0xBD, 0xA4, 0xBE, 0x3F, 0x3F, /* 0x10-0x13 */
	0xA4, 0xD5, 0xA4, 0xD6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA4, 0xDD, 0x3F, 0x3F, /* 0x18-0x1B */
	0xA4, 0xDE, 0xA4, 0xE1, 0xA4, 0xE2, 0x3F, 0x3F, /* 0x1C-0x1F */
	0xA4, 0xE3, 0xA4, 0xB4, 0xA4, 0xE4, 0xA4, 0xE5, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xA4, 0xE6, /* 0x24-0x27 */
	0x3F, 0x3F, 0xA4, 0xE7, 0x3F, 0x3F, 0xA4, 0xE8, /* 0x28-0x2B */
	0xA4, 0xE9, 0xA4, 0xEA, 0xA4, 0xEB, 0xA4, 0xEC, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA4, 0xED, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA4, 0xEE, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0xA4, 0xB5, 0xA4, 0xB6, 0xA4, 0xB5, 0xA4, 0xB6, /* 0x3C-0x3F */
	0xA4, 0xEF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0xA4, 0xF2, 0xA4, 0xF3, 0xA4, 0xF0, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0xA4, 0xB7, 0x3F, 0x3F, 0xA4, 0xB8, 0xA4, 0xB9, /* 0x4C-0x4F */
	0xA4, 0xB8, 0xA4, 0xB9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0xA4, 0xBA, 0xA4, 0xBA, 0x3F, 0x3F, 0xA4, 0xF4, /* 0x54-0x57 */
	0xA4, 0xF5, 0xA4, 0xF6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xA4, 0xD4, /* 0x5C-0x5F */
	0x3F, 0x3F, 0xA4, 0xBF, 0xA4, 0xC0, 0xA4, 0xC1, /* 0x60-0x63 */
	0xA4, 0xC2, 0xA4, 0xC3, 0xA4, 0xC4, 0xA4, 0xC5, /* 0x64-0x67 */
	0xA4, 0xC6, 0xA4, 0xC7, 0xA4, 0xC8, 0xA4, 0xC9, /* 0x68-0x6B */
	0xA4, 0xCA, 0xA4, 0xCB, 0xA4, 0xCC, 0xA4, 0xCD, /* 0x6C-0x6F */
	0xA4, 0xCE, 0xA4, 0xCF, 0xA4, 0xD0, 0xA4, 0xD1, /* 0x70-0x73 */
	0xA4, 0xD2, 0xA4, 0xD3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0xA4, 0xF7, 0xA4, 0xF8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0xA4, 0xF9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0xA4, 0xFA, 0xA4, 0xFB, 0x3F, 0x3F, /* 0x90-0x93 */
	0xA4, 0xFC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA4, 0xFD, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0xA4, 0xFE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0xA4, 0xA1, 0xA4, 0xA2, 0xA4, 0xA3, 0xA4, 0xA4, /* 0xA8-0xAB */
	0xA4, 0xA5, 0xA4, 0xA6, 0xA4, 0xA7, 0xA4, 0xA9, /* 0xAC-0xAF */
	0xA4, 0xAA, 0xA4, 0xAB, 0xA4, 0xAC, 0xA4, 0xAD, /* 0xB0-0xB3 */
	0xA4, 0xAE, 0xA4, 0xAF, 0xA4, 0xB0, 0xA4, 0xB1, /* 0xB4-0xB7 */
	0xA4, 0xB2, 0xA4, 0xB4, 0xA4, 0xB5, 0xA4, 0xB6, /* 0xB8-0xBB */
	0xA4, 0xB7, 0xA4, 0xB8, 0xA4, 0xBA, 0xA4, 0xBB, /* 0xBC-0xBF */
	0xA4, 0xBC, 0xA4, 0xBD, 0xA4, 0xBE, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA4, 0xD6, 0xA4, 0xD7, /* 0xC4-0xC7 */
	0xA4, 0xD8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0xA4, 0xD9, 0x3F, 0x3F, 0xA4, 0xDA, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xA4, 0xDB, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xA4, 0xDC, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0xA4, 0xDD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0xA4, 0xDE, 0xA4, 0xDF, 0x3F, 0x3F, 0xA4, 0xE0, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA4, 0xE8, 0xA4, 0xEA, /* 0xE4-0xE7 */
	0xA4, 0xEC, 0x3F, 0x3F, 0xA4, 0xED, 0xA4, 0xEF, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA4, 0xF0, 0x3F, 0x3F, /* 0xEC-0xEF */
	0xA4, 0xB7, 0xA4, 0xF2, 0xA4, 0xF3, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0xA4, 0xF4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0xA4, 0xF6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_20[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0xA1, 0xAA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0xA1, 0xAE, 0xA1, 0xAF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0xA1, 0xB0, 0xA1, 0xB1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0xA2, 0xD3, 0xA2, 0xD4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0xA1, 0xA5, 0xA1, 0xA6, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0xA2, 0xB6, 0x3F, 0x3F, 0xA1, 0xC7, 0xA1, 0xC8, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xA1, 0xD8, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0xA9, 0xF9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xA9, 0xFA, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0xA9, 0xFB, 0xA9, 0xFC, 0xA9, 0xFD, /* 0x80-0x83 */
	0xA9, 0xFE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x00, 0x5C, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_21[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xA1, 0xC9, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0xA2, 0xB5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xA7, 0xA4, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA2, 0xE0, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0xA2, 0xE5, 0xA2, 0xE2, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA7, 0xD9, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xA1, 0xCA, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xA8, 0xF7, /* 0x50-0x53 */
	0xA8, 0xF8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xA8, 0xFB, /* 0x58-0x5B */
	0xA8, 0xFC, 0xA8, 0xFD, 0xA8, 0xFE, 0x3F, 0x3F, /* 0x5C-0x5F */
	0xA5, 0xB0, 0xA5, 0xB1, 0xA5, 0xB2, 0xA5, 0xB3, /* 0x60-0x63 */
	0xA5, 0xB4, 0xA5, 0xB5, 0xA5, 0xB6, 0xA5, 0xB7, /* 0x64-0x67 */
	0xA5, 0xB8, 0xA5, 0xB9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0xA5, 0xA1, 0xA5, 0xA2, 0xA5, 0xA3, 0xA5, 0xA4, /* 0x70-0x73 */
	0xA5, 0xA5, 0xA5, 0xA6, 0xA5, 0xA7, 0xA5, 0xA8, /* 0x74-0x77 */
	0xA5, 0xA9, 0xA5, 0xAA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0xA1, 0xE7, 0xA1, 0xE8, 0xA1, 0xE6, 0xA1, 0xE9, /* 0x90-0x93 */
	0xA1, 0xEA, 0xA2, 0xD5, 0xA2, 0xD8, 0xA2, 0xD6, /* 0x94-0x97 */
	0xA2, 0xD9, 0xA2, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA2, 0xA1, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0xA2, 0xA2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_22[512] = {
	0xA2, 0xA3, 0x3F, 0x3F, 0xA1, 0xD3, 0xA2, 0xA4, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xA1, 0xD4, /* 0x04-0x07 */
	0xA1, 0xF4, 0x3F, 0x3F, 0x3F, 0x3F, 0xA1, 0xF5, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xA2, 0xB3, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xA2, 0xB2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA1, 0xEE, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0xA1, 0xF0, 0xA1, 0xC4, 0x3F, 0x3F, /* 0x1C-0x1F */
	0xA1, 0xD0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0xA1, 0xAB, 0x3F, 0x3F, 0xA1, 0xFC, /* 0x24-0x27 */
	0xA1, 0xFD, 0xA1, 0xFB, 0xA1, 0xFA, 0xA1, 0xF2, /* 0x28-0x2B */
	0xA1, 0xF3, 0x3F, 0x3F, 0xA2, 0xB1, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0xA1, 0xC5, 0xA1, 0xF1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0xA1, 0xAD, 0xA1, 0xEF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA1, 0xD6, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0xA1, 0xC1, 0xA1, 0xD5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0xA1, 0xC2, 0xA1, 0xC3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA1, 0xEC, 0xA1, 0xED, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0xA1, 0xF8, 0xA1, 0xF9, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA1, 0xF6, 0xA1, 0xF7, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0xA2, 0xC1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0xA1, 0xD1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_23[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA1, 0xD2, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_24[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0xA8, 0xE7, 0xA8, 0xE8, 0xA8, 0xE9, 0xA8, 0xEA, /* 0x60-0x63 */
	0xA8, 0xEB, 0xA8, 0xEC, 0xA8, 0xED, 0xA8, 0xEE, /* 0x64-0x67 */
	0xA8, 0xEF, 0xA8, 0xF0, 0xA8, 0xF1, 0xA8, 0xF2, /* 0x68-0x6B */
	0xA8, 0xF3, 0xA8, 0xF4, 0xA8, 0xF5, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0xA9, 0xE7, 0xA9, 0xE8, 0xA9, 0xE9, 0xA9, 0xEA, /* 0x74-0x77 */
	0xA9, 0xEB, 0xA9, 0xEC, 0xA9, 0xED, 0xA9, 0xEE, /* 0x78-0x7B */
	0xA9, 0xEF, 0xA9, 0xF0, 0xA9, 0xF1, 0xA9, 0xF2, /* 0x7C-0x7F */
	
	0xA9, 0xF3, 0xA9, 0xF4, 0xA9, 0xF5, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0xA9, 0xCD, 0xA9, 0xCE, 0xA9, 0xCF, 0xA9, 0xD0, /* 0x9C-0x9F */
	0xA9, 0xD1, 0xA9, 0xD2, 0xA9, 0xD3, 0xA9, 0xD4, /* 0xA0-0xA3 */
	0xA9, 0xD5, 0xA9, 0xD6, 0xA9, 0xD7, 0xA9, 0xD8, /* 0xA4-0xA7 */
	0xA9, 0xD9, 0xA9, 0xDA, 0xA9, 0xDB, 0xA9, 0xDC, /* 0xA8-0xAB */
	0xA9, 0xDD, 0xA9, 0xDE, 0xA9, 0xDF, 0xA9, 0xE0, /* 0xAC-0xAF */
	0xA9, 0xE1, 0xA9, 0xE2, 0xA9, 0xE3, 0xA9, 0xE4, /* 0xB0-0xB3 */
	0xA9, 0xE5, 0xA9, 0xE6, 0xA8, 0xCD, 0xA8, 0xCE, /* 0xB4-0xB7 */
	0xA8, 0xCF, 0xA8, 0xD0, 0xA8, 0xD1, 0xA8, 0xD2, /* 0xB8-0xBB */
	0xA8, 0xD3, 0xA8, 0xD4, 0xA8, 0xD5, 0xA8, 0xD6, /* 0xBC-0xBF */
	0xA8, 0xD7, 0xA8, 0xD8, 0xA8, 0xD9, 0xA8, 0xDA, /* 0xC0-0xC3 */
	0xA8, 0xDB, 0xA8, 0xDC, 0xA8, 0xDD, 0xA8, 0xDE, /* 0xC4-0xC7 */
	0xA8, 0xDF, 0xA8, 0xE0, 0xA8, 0xE1, 0xA8, 0xE2, /* 0xC8-0xCB */
	0xA8, 0xE3, 0xA8, 0xE4, 0xA8, 0xE5, 0xA8, 0xE6, /* 0xCC-0xCF */
	0xA8, 0xCD, 0xA8, 0xCE, 0xA8, 0xCF, 0xA8, 0xD0, /* 0xD0-0xD3 */
	0xA8, 0xD1, 0xA8, 0xD2, 0xA8, 0xD3, 0xA8, 0xD4, /* 0xD4-0xD7 */
	0xA8, 0xD5, 0xA8, 0xD6, 0xA8, 0xD7, 0xA8, 0xD8, /* 0xD8-0xDB */
	0xA8, 0xD9, 0xA8, 0xDA, 0xA8, 0xDB, 0xA8, 0xDC, /* 0xDC-0xDF */
	0xA8, 0xDD, 0xA8, 0xDE, 0xA8, 0xDF, 0xA8, 0xE0, /* 0xE0-0xE3 */
	0xA8, 0xE1, 0xA8, 0xE2, 0xA8, 0xE3, 0xA8, 0xE4, /* 0xE4-0xE7 */
	0xA8, 0xE5, 0xA8, 0xE6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_25[512] = {
	0xA6, 0xA1, 0xA6, 0xAC, 0xA6, 0xA2, 0xA6, 0xAD, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0xA6, 0xA3, 0xA6, 0xC8, 0xA6, 0xC7, 0xA6, 0xAE, /* 0x0C-0x0F */
	0xA6, 0xA4, 0xA6, 0xC2, 0xA6, 0xC1, 0xA6, 0xAF, /* 0x10-0x13 */
	0xA6, 0xA6, 0xA6, 0xC6, 0xA6, 0xC5, 0xA6, 0xB1, /* 0x14-0x17 */
	0xA6, 0xA5, 0xA6, 0xC4, 0xA6, 0xC3, 0xA6, 0xB0, /* 0x18-0x1B */
	0xA6, 0xA7, 0xA6, 0xBC, 0xA6, 0xC9, 0xA6, 0xCA, /* 0x1C-0x1F */
	0xA6, 0xB7, 0xA6, 0xCB, 0xA6, 0xCC, 0xA6, 0xB2, /* 0x20-0x23 */
	0xA6, 0xA9, 0xA6, 0xBE, 0xA6, 0xCD, 0xA6, 0xCE, /* 0x24-0x27 */
	0xA6, 0xB9, 0xA6, 0xCF, 0xA6, 0xD0, 0xA6, 0xB4, /* 0x28-0x2B */
	0xA6, 0xA8, 0xA6, 0xD1, 0xA6, 0xD2, 0xA6, 0xB8, /* 0x2C-0x2F */
	0xA6, 0xBD, 0xA6, 0xD3, 0xA6, 0xD4, 0xA6, 0xB3, /* 0x30-0x33 */
	0xA6, 0xAA, 0xA6, 0xD5, 0xA6, 0xD6, 0xA6, 0xBA, /* 0x34-0x37 */
	0xA6, 0xBF, 0xA6, 0xD7, 0xA6, 0xD8, 0xA6, 0xB5, /* 0x38-0x3B */
	0xA6, 0xAB, 0xA6, 0xD9, 0xA6, 0xDA, 0xA6, 0xBB, /* 0x3C-0x3F */
	0xA6, 0xDB, 0xA6, 0xDC, 0xA6, 0xC0, 0xA6, 0xDD, /* 0x40-0x43 */
	0xA6, 0xDE, 0xA6, 0xDF, 0xA6, 0xE0, 0xA6, 0xE1, /* 0x44-0x47 */
	0xA6, 0xE2, 0xA6, 0xE3, 0xA6, 0xE4, 0xA6, 0xB6, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA2, 0xC6, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0xA1, 0xE1, 0xA1, 0xE0, 0x3F, 0x3F, 0xA2, 0xC3, /* 0xA0-0xA3 */
	0xA2, 0xC7, 0xA2, 0xC8, 0xA2, 0xCB, 0xA2, 0xCA, /* 0xA4-0xA7 */
	0xA2, 0xC9, 0xA2, 0xCC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA1, 0xE3, 0xA1, 0xE2, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA2, 0xBA, 0xA2, 0xB9, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0xA1, 0xE5, 0xA1, 0xE4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0xA2, 0xB8, 0xA2, 0xB7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA1, 0xDF, 0xA1, 0xDE, /* 0xC4-0xC7 */
	0xA2, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, 0xA1, 0xDB, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA1, 0xDD, 0xA1, 0xDC, /* 0xCC-0xCF */
	0xA2, 0xC4, 0xA2, 0xC5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_26[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0xA1, 0xDA, 0xA1, 0xD9, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA2, 0xCF, 0xA2, 0xCE, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0xA2, 0xD0, 0x3F, 0x3F, 0xA2, 0xD1, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0xA1, 0xCF, 0x3F, 0x3F, 0xA1, 0xCE, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0xA2, 0xBC, 0xA2, 0xBD, 0x3F, 0x3F, 0xA2, 0xC0, /* 0x60-0x63 */
	0xA2, 0xBB, 0xA2, 0xBE, 0x3F, 0x3F, 0xA2, 0xBF, /* 0x64-0x67 */
	0xA2, 0xCD, 0xA2, 0xDB, 0xA2, 0xDC, 0x3F, 0x3F, /* 0x68-0x6B */
	0xA2, 0xDD, 0xA2, 0xDA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_30[512] = {
	0xA1, 0xA1, 0xA1, 0xA2, 0xA1, 0xA3, 0xA1, 0xA8, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0xA1, 0xB4, 0xA1, 0xB5, 0xA1, 0xB6, 0xA1, 0xB7, /* 0x08-0x0B */
	0xA1, 0xB8, 0xA1, 0xB9, 0xA1, 0xBA, 0xA1, 0xBB, /* 0x0C-0x0F */
	0xA1, 0xBC, 0xA1, 0xBD, 0x3F, 0x3F, 0xA1, 0xEB, /* 0x10-0x13 */
	0xA1, 0xB2, 0xA1, 0xB3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0xAA, 0xA1, 0xAA, 0xA2, 0xAA, 0xA3, /* 0x40-0x43 */
	0xAA, 0xA4, 0xAA, 0xA5, 0xAA, 0xA6, 0xAA, 0xA7, /* 0x44-0x47 */
	0xAA, 0xA8, 0xAA, 0xA9, 0xAA, 0xAA, 0xAA, 0xAB, /* 0x48-0x4B */
	0xAA, 0xAC, 0xAA, 0xAD, 0xAA, 0xAE, 0xAA, 0xAF, /* 0x4C-0x4F */
	0xAA, 0xB0, 0xAA, 0xB1, 0xAA, 0xB2, 0xAA, 0xB3, /* 0x50-0x53 */
	0xAA, 0xB4, 0xAA, 0xB5, 0xAA, 0xB6, 0xAA, 0xB7, /* 0x54-0x57 */
	0xAA, 0xB8, 0xAA, 0xB9, 0xAA, 0xBA, 0xAA, 0xBB, /* 0x58-0x5B */
	0xAA, 0xBC, 0xAA, 0xBD, 0xAA, 0xBE, 0xAA, 0xBF, /* 0x5C-0x5F */
	0xAA, 0xC0, 0xAA, 0xC1, 0xAA, 0xC2, 0xAA, 0xC3, /* 0x60-0x63 */
	0xAA, 0xC4, 0xAA, 0xC5, 0xAA, 0xC6, 0xAA, 0xC7, /* 0x64-0x67 */
	0xAA, 0xC8, 0xAA, 0xC9, 0xAA, 0xCA, 0xAA, 0xCB, /* 0x68-0x6B */
	0xAA, 0xCC, 0xAA, 0xCD, 0xAA, 0xCE, 0xAA, 0xCF, /* 0x6C-0x6F */
	0xAA, 0xD0, 0xAA, 0xD1, 0xAA, 0xD2, 0xAA, 0xD3, /* 0x70-0x73 */
	0xAA, 0xD4, 0xAA, 0xD5, 0xAA, 0xD6, 0xAA, 0xD7, /* 0x74-0x77 */
	0xAA, 0xD8, 0xAA, 0xD9, 0xAA, 0xDA, 0xAA, 0xDB, /* 0x78-0x7B */
	0xAA, 0xDC, 0xAA, 0xDD, 0xAA, 0xDE, 0xAA, 0xDF, /* 0x7C-0x7F */
	
	0xAA, 0xE0, 0xAA, 0xE1, 0xAA, 0xE2, 0xAA, 0xE3, /* 0x80-0x83 */
	0xAA, 0xE4, 0xAA, 0xE5, 0xAA, 0xE6, 0xAA, 0xE7, /* 0x84-0x87 */
	0xAA, 0xE8, 0xAA, 0xE9, 0xAA, 0xEA, 0xAA, 0xEB, /* 0x88-0x8B */
	0xAA, 0xEC, 0xAA, 0xED, 0xAA, 0xEE, 0xAA, 0xEF, /* 0x8C-0x8F */
	0xAA, 0xF0, 0xAA, 0xF1, 0xAA, 0xF2, 0xAA, 0xF3, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0xAB, 0xA1, 0xAB, 0xA2, 0xAB, 0xA3, /* 0xA0-0xA3 */
	0xAB, 0xA4, 0xAB, 0xA5, 0xAB, 0xA6, 0xAB, 0xA7, /* 0xA4-0xA7 */
	0xAB, 0xA8, 0xAB, 0xA9, 0xAB, 0xAA, 0xAB, 0xAB, /* 0xA8-0xAB */
	0xAB, 0xAC, 0xAB, 0xAD, 0xAB, 0xAE, 0xAB, 0xAF, /* 0xAC-0xAF */
	0xAB, 0xB0, 0xAB, 0xB1, 0xAB, 0xB2, 0xAB, 0xB3, /* 0xB0-0xB3 */
	0xAB, 0xB4, 0xAB, 0xB5, 0xAB, 0xB6, 0xAB, 0xB7, /* 0xB4-0xB7 */
	0xAB, 0xB8, 0xAB, 0xB9, 0xAB, 0xBA, 0xAB, 0xBB, /* 0xB8-0xBB */
	0xAB, 0xBC, 0xAB, 0xBD, 0xAB, 0xBE, 0xAB, 0xBF, /* 0xBC-0xBF */
	0xAB, 0xC0, 0xAB, 0xC1, 0xAB, 0xC2, 0xAB, 0xC3, /* 0xC0-0xC3 */
	0xAB, 0xC4, 0xAB, 0xC5, 0xAB, 0xC6, 0xAB, 0xC7, /* 0xC4-0xC7 */
	0xAB, 0xC8, 0xAB, 0xC9, 0xAB, 0xCA, 0xAB, 0xCB, /* 0xC8-0xCB */
	0xAB, 0xCC, 0xAB, 0xCD, 0xAB, 0xCE, 0xAB, 0xCF, /* 0xCC-0xCF */
	0xAB, 0xD0, 0xAB, 0xD1, 0xAB, 0xD2, 0xAB, 0xD3, /* 0xD0-0xD3 */
	0xAB, 0xD4, 0xAB, 0xD5, 0xAB, 0xD6, 0xAB, 0xD7, /* 0xD4-0xD7 */
	0xAB, 0xD8, 0xAB, 0xD9, 0xAB, 0xDA, 0xAB, 0xDB, /* 0xD8-0xDB */
	0xAB, 0xDC, 0xAB, 0xDD, 0xAB, 0xDE, 0xAB, 0xDF, /* 0xDC-0xDF */
	0xAB, 0xE0, 0xAB, 0xE1, 0xAB, 0xE2, 0xAB, 0xE3, /* 0xE0-0xE3 */
	0xAB, 0xE4, 0xAB, 0xE5, 0xAB, 0xE6, 0xAB, 0xE7, /* 0xE4-0xE7 */
	0xAB, 0xE8, 0xAB, 0xE9, 0xAB, 0xEA, 0xAB, 0xEB, /* 0xE8-0xEB */
	0xAB, 0xEC, 0xAB, 0xED, 0xAB, 0xEE, 0xAB, 0xEF, /* 0xEC-0xEF */
	0xAB, 0xF0, 0xAB, 0xF1, 0xAB, 0xF2, 0xAB, 0xF3, /* 0xF0-0xF3 */
	0xAB, 0xF4, 0xAB, 0xF5, 0xAB, 0xF6, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_31[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0xA4, 0xA1, 0xA4, 0xA2, 0xA4, 0xA3, /* 0x30-0x33 */
	0xA4, 0xA4, 0xA4, 0xA5, 0xA4, 0xA6, 0xA4, 0xA7, /* 0x34-0x37 */
	0xA4, 0xA8, 0xA4, 0xA9, 0xA4, 0xAA, 0xA4, 0xAB, /* 0x38-0x3B */
	0xA4, 0xAC, 0xA4, 0xAD, 0xA4, 0xAE, 0xA4, 0xAF, /* 0x3C-0x3F */
	0xA4, 0xB0, 0xA4, 0xB1, 0xA4, 0xB2, 0xA4, 0xB3, /* 0x40-0x43 */
	0xA4, 0xB4, 0xA4, 0xB5, 0xA4, 0xB6, 0xA4, 0xB7, /* 0x44-0x47 */
	0xA4, 0xB8, 0xA4, 0xB9, 0xA4, 0xBA, 0xA4, 0xBB, /* 0x48-0x4B */
	0xA4, 0xBC, 0xA4, 0xBD, 0xA4, 0xBE, 0xA4, 0xBF, /* 0x4C-0x4F */
	0xA4, 0xC0, 0xA4, 0xC1, 0xA4, 0xC2, 0xA4, 0xC3, /* 0x50-0x53 */
	0xA4, 0xC4, 0xA4, 0xC5, 0xA4, 0xC6, 0xA4, 0xC7, /* 0x54-0x57 */
	0xA4, 0xC8, 0xA4, 0xC9, 0xA4, 0xCA, 0xA4, 0xCB, /* 0x58-0x5B */
	0xA4, 0xCC, 0xA4, 0xCD, 0xA4, 0xCE, 0xA4, 0xCF, /* 0x5C-0x5F */
	0xA4, 0xD0, 0xA4, 0xD1, 0xA4, 0xD2, 0xA4, 0xD3, /* 0x60-0x63 */
	0xA4, 0xD4, 0xA4, 0xD5, 0xA4, 0xD6, 0xA4, 0xD7, /* 0x64-0x67 */
	0xA4, 0xD8, 0xA4, 0xD9, 0xA4, 0xDA, 0xA4, 0xDB, /* 0x68-0x6B */
	0xA4, 0xDC, 0xA4, 0xDD, 0xA4, 0xDE, 0xA4, 0xDF, /* 0x6C-0x6F */
	0xA4, 0xE0, 0xA4, 0xE1, 0xA4, 0xE2, 0xA4, 0xE3, /* 0x70-0x73 */
	0xA4, 0xE4, 0xA4, 0xE5, 0xA4, 0xE6, 0xA4, 0xE7, /* 0x74-0x77 */
	0xA4, 0xE8, 0xA4, 0xE9, 0xA4, 0xEA, 0xA4, 0xEB, /* 0x78-0x7B */
	0xA4, 0xEC, 0xA4, 0xED, 0xA4, 0xEE, 0xA4, 0xEF, /* 0x7C-0x7F */
	
	0xA4, 0xF0, 0xA4, 0xF1, 0xA4, 0xF2, 0xA4, 0xF3, /* 0x80-0x83 */
	0xA4, 0xF4, 0xA4, 0xF5, 0xA4, 0xF6, 0xA4, 0xF7, /* 0x84-0x87 */
	0xA4, 0xF8, 0xA4, 0xF9, 0xA4, 0xFA, 0xA4, 0xFB, /* 0x88-0x8B */
	0xA4, 0xFC, 0xA4, 0xFD, 0xA4, 0xFE, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xE9, 0xEC, 0xA3, /* 0x90-0x93 */
	0xDF, 0xB2, 0xDE, 0xCC, 0xDF, 0xBE, 0xF1, 0xE9, /* 0x94-0x97 */
	0xF9, 0xBB, 0xCB, 0xA3, 0xEB, 0xE0, 0xDC, 0xB0, /* 0x98-0x9B */
	0xEF, 0xCB, 0xF4, 0xB8, 0xF2, 0xA2, 0xEC, 0xD1, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_32[512] = {
	0xA9, 0xB1, 0xA9, 0xB2, 0xA9, 0xB3, 0xA9, 0xB4, /* 0x00-0x03 */
	0xA9, 0xB5, 0xA9, 0xB6, 0xA9, 0xB7, 0xA9, 0xB8, /* 0x04-0x07 */
	0xA9, 0xB9, 0xA9, 0xBA, 0xA9, 0xBB, 0xA9, 0xBC, /* 0x08-0x0B */
	0xA9, 0xBD, 0xA9, 0xBE, 0xA9, 0xBF, 0xA9, 0xC0, /* 0x0C-0x0F */
	0xA9, 0xC1, 0xA9, 0xC2, 0xA9, 0xC3, 0xA9, 0xC4, /* 0x10-0x13 */
	0xA9, 0xC5, 0xA9, 0xC6, 0xA9, 0xC7, 0xA9, 0xC8, /* 0x14-0x17 */
	0xA9, 0xC9, 0xA9, 0xCA, 0xA9, 0xCB, 0xA9, 0xCC, /* 0x18-0x1B */
	0xA2, 0xDF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0xEC, 0xE9, 0xEC, 0xA3, 0xDF, 0xB2, 0xDE, 0xCC, /* 0x20-0x23 */
	0xE7, 0xE9, 0xD7, 0xBF, 0xF6, 0xD2, 0xF8, 0xA2, /* 0x24-0x27 */
	0xCE, 0xFA, 0xE4, 0xA8, 0xEA, 0xC5, 0xFB, 0xFD, /* 0x28-0x2B */
	0xE2, 0xA9, 0xD9, 0xCA, 0xD1, 0xD1, 0xF7, 0xCF, /* 0x2C-0x2F */
	0xEC, 0xED, 0xF1, 0xBB, 0xEA, 0xF3, 0xDE, 0xE4, /* 0x30-0x33 */
	0xD9, 0xA3, 0xF7, 0xE5, 0xEE, 0xAF, 0xF5, 0xE6, /* 0x34-0x37 */
	0xD6, 0xCC, 0xD3, 0xDB, 0xFB, 0xBC, 0xF9, 0xCA, /* 0x38-0x3B */
	0xCA, 0xF8, 0xD0, 0xEA, 0xED, 0xC0, 0xFA, 0xF0, /* 0x3C-0x3F */
	0xF0, 0xAE, 0xFD, 0xCC, 0xED, 0xBB, 0xF2, 0xB8, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0xA8, 0xB1, 0xA8, 0xB2, 0xA8, 0xB3, 0xA8, 0xB4, /* 0x60-0x63 */
	0xA8, 0xB5, 0xA8, 0xB6, 0xA8, 0xB7, 0xA8, 0xB8, /* 0x64-0x67 */
	0xA8, 0xB9, 0xA8, 0xBA, 0xA8, 0xBB, 0xA8, 0xBC, /* 0x68-0x6B */
	0xA8, 0xBD, 0xA8, 0xBE, 0xA8, 0xBF, 0xA8, 0xC0, /* 0x6C-0x6F */
	0xA8, 0xC1, 0xA8, 0xC2, 0xA8, 0xC3, 0xA8, 0xC4, /* 0x70-0x73 */
	0xA8, 0xC5, 0xA8, 0xC6, 0xA8, 0xC7, 0xA8, 0xC8, /* 0x74-0x77 */
	0xA8, 0xC9, 0xA8, 0xCA, 0xA8, 0xCB, 0xA8, 0xCC, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xA2, 0xDE, /* 0x7C-0x7F */
	
	0xEC, 0xE9, 0xEC, 0xA3, 0xDF, 0xB2, 0xDE, 0xCC, /* 0x80-0x83 */
	0xE7, 0xE9, 0xD7, 0xBF, 0xF6, 0xD2, 0xF8, 0xA2, /* 0x84-0x87 */
	0xCE, 0xFA, 0xE4, 0xA8, 0xEA, 0xC5, 0xFB, 0xFD, /* 0x88-0x8B */
	0xE2, 0xA9, 0xD9, 0xCA, 0xD1, 0xD1, 0xF7, 0xCF, /* 0x8C-0x8F */
	0xEC, 0xED, 0xF1, 0xBB, 0xEA, 0xF3, 0xDE, 0xE4, /* 0x90-0x93 */
	0xD9, 0xA3, 0xF7, 0xE5, 0xEE, 0xAF, 0xF5, 0xE6, /* 0x94-0x97 */
	0xD6, 0xCC, 0xDD, 0xFA, 0xD1, 0xFB, 0xD2, 0xB3, /* 0x98-0x9B */
	0xEE, 0xEA, 0xE9, 0xD0, 0xEC, 0xD4, 0xF1, 0xBC, /* 0x9C-0x9F */
	0xFA, 0xA3, 0xFD, 0xCC, 0xDE, 0xD0, 0xEF, 0xE1, /* 0xA0-0xA3 */
	0xDF, 0xBE, 0xF1, 0xE9, 0xF9, 0xBB, 0xF1, 0xA7, /* 0xA4-0xA7 */
	0xE9, 0xD3, 0xEC, 0xA2, 0xF0, 0xF3, 0xF9, 0xCA, /* 0xA8-0xAB */
	0xCA, 0xF8, 0xD0, 0xEA, 0xED, 0xC0, 0xFA, 0xF0, /* 0xAC-0xAF */
	0xE5, 0xA8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_33[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0xA7, 0xC9, 0xA7, 0xCA, 0xA7, 0xCB, 0xA7, 0xCC, /* 0x80-0x83 */
	0xA7, 0xCD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0xA7, 0xBA, 0xA7, 0xBB, 0xA7, 0xDC, 0xA7, 0xDD, /* 0x88-0x8B */
	0xA7, 0xDE, 0xA7, 0xB6, 0xA7, 0xB7, 0xA7, 0xB8, /* 0x8C-0x8F */
	0xA7, 0xD4, 0xA7, 0xD5, 0xA7, 0xD6, 0xA7, 0xD7, /* 0x90-0x93 */
	0xA7, 0xD8, 0xA7, 0xA1, 0xA7, 0xA2, 0xA7, 0xA3, /* 0x94-0x97 */
	0xA7, 0xA5, 0xA7, 0xAB, 0xA7, 0xAC, 0xA7, 0xAD, /* 0x98-0x9B */
	0xA7, 0xAE, 0xA7, 0xAF, 0xA7, 0xB0, 0xA7, 0xB1, /* 0x9C-0x9F */
	0xA7, 0xB2, 0xA7, 0xB3, 0xA7, 0xB4, 0xA7, 0xA7, /* 0xA0-0xA3 */
	0xA7, 0xA8, 0xA7, 0xA9, 0xA7, 0xAA, 0xA7, 0xBD, /* 0xA4-0xA7 */
	0xA7, 0xBE, 0xA7, 0xE5, 0xA7, 0xE6, 0xA7, 0xE7, /* 0xA8-0xAB */
	0xA7, 0xE8, 0xA7, 0xE1, 0xA7, 0xE2, 0xA7, 0xE3, /* 0xAC-0xAF */
	0xA7, 0xBF, 0xA7, 0xC0, 0xA7, 0xC1, 0xA7, 0xC2, /* 0xB0-0xB3 */
	0xA7, 0xC3, 0xA7, 0xC4, 0xA7, 0xC5, 0xA7, 0xC6, /* 0xB4-0xB7 */
	0xA7, 0xC7, 0xA7, 0xC8, 0xA7, 0xCE, 0xA7, 0xCF, /* 0xB8-0xBB */
	0xA7, 0xD0, 0xA7, 0xD1, 0xA7, 0xD2, 0xA7, 0xD3, /* 0xBC-0xBF */
	0xA7, 0xDA, 0xA7, 0xDB, 0xA2, 0xE3, 0xA7, 0xEC, /* 0xC0-0xC3 */
	0xA7, 0xA6, 0xA7, 0xE0, 0xA7, 0xEF, 0xA2, 0xE1, /* 0xC4-0xC7 */
	0xA7, 0xBC, 0xA7, 0xED, 0xA7, 0xB5, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xA7, 0xB9, /* 0xCC-0xCF */
	0xA7, 0xEA, 0x3F, 0x3F, 0x3F, 0x3F, 0xA7, 0xEB, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xA7, 0xDF, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0xA2, 0xE4, 0x3F, 0x3F, 0x3F, 0x3F, 0xA7, 0xE4, /* 0xD8-0xDB */
	0xA7, 0xEE, 0xA7, 0xE9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_4E[512] = {
	0xEC, 0xE9, 0xEF, 0xCB, 0x3F, 0x3F, 0xF6, 0xD2, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xB2, /* 0x04-0x07 */
	0xED, 0xDB, 0xDF, 0xB2, 0xDF, 0xBE, 0xF9, 0xBB, /* 0x08-0x0B */
	0x3F, 0x3F, 0xDC, 0xF4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xF5, 0xE4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0xF3, 0xA6, 0xDD, 0xE0, 0xE1, 0xA6, 0x3F, 0x3F, /* 0x14-0x17 */
	0xCE, 0xF8, 0xDC, 0xB0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xAA, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0xF1, 0xE9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xFA, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0xFC, 0xAF, 0xD3, 0xA1, 0x3F, 0x3F, 0xF1, 0xAB, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xD1, 0xD2, 0xAC, /* 0x40-0x43 */
	0x3F, 0x3F, 0xCE, 0xF9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xFD, /* 0x48-0x4B */
	0x3F, 0x3F, 0xDE, 0xBF, 0xFB, 0xBA, 0xF9, 0xB9, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xD2, 0x3F, 0x3F, /* 0x54-0x57 */
	0xE3, 0xAB, 0xEB, 0xE0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0xCE, 0xFA, 0xCB, 0xF7, 0xE5, 0xA5, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xE1, /* 0x68-0x6B */
	0x3F, 0x3F, 0xD4, 0xCC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xE1, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xE3, 0xDF, 0xAD, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xEB, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xAF, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xF5, 0x3F, 0x3F, /* 0x84-0x87 */
	0xE5, 0xF8, 0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xC0, /* 0x88-0x8B */
	0xEC, 0xA3, 0x3F, 0x3F, 0xE9, 0xCD, 0x3F, 0x3F, /* 0x8C-0x8F */
	0xEA, 0xA7, 0xE9, 0xF6, 0xFB, 0xBB, 0x3F, 0x3F, /* 0x90-0x93 */
	0xE7, 0xE9, 0xEF, 0xCC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0xD0, 0xE6, 0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xC1, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xAC, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0xD8, 0xCC, 0xF9, 0xF1, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0xCE, 0xDF, 0xFA, 0xA4, 0xE6, 0xB2, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0xFA, 0xFB, 0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xBD, /* 0xA8-0xAB */
	0xCC, 0xC8, 0xEF, 0xCD, 0xD5, 0xD5, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xA2, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xD1, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0xE4, 0xA7, 0xEC, 0xD2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xF6, 0xB1, 0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xFB, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xD1, 0xCB, 0xBF, /* 0xC8-0xCB */
	0x3F, 0x3F, 0xED, 0xA4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0xED, 0xA8, 0xDE, 0xC2, 0xF6, 0xE2, 0xED, 0xDC, /* 0xD4-0xD7 */
	0xDC, 0xF5, 0xE0, 0xB9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0xD4, 0xCE, 0x3F, 0x3F, 0xF4, 0xB5, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xDB, /* 0xE0-0xE3 */
	0xD6, 0xB5, 0xEC, 0xA4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0xE4, 0xE6, 0x3F, 0x3F, 0xF1, 0xEA, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xEC, 0xCB, 0xC0, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xF2, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_4F[512] = {
	0x3F, 0x3F, 0xD0, 0xEA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0xF9, 0xF2, 0xEC, 0xA5, 0xD0, 0xDF, /* 0x08-0x0B */
	0x3F, 0x3F, 0xE7, 0xEA, 0xD0, 0xEB, 0xDC, 0xD1, /* 0x0C-0x0F */
	0xDB, 0xE9, 0xFD, 0xCC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xD7, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0xDA, 0xE1, 0x3F, 0x3F, 0xD6, 0xB6, 0x3F, 0x3F, /* 0x34-0x37 */
	0xE3, 0xDF, 0x3F, 0x3F, 0xDE, 0xC3, 0x3F, 0x3F, /* 0x38-0x3B */
	0xDE, 0xC4, 0xCA, 0xA1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xEC, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xA3, 0xEE, 0xB7, /* 0x44-0x47 */
	0xF8, 0xCF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0xEA, 0xC8, 0xEE, 0xB8, 0xF1, 0xAC, /* 0x4C-0x4F */
	0xF1, 0xA5, 0xE9, 0xCE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0xF9, 0xBC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0xE5, 0xF9, 0xEC, 0xEA, 0xDD, 0xD6, /* 0x58-0x5B */
	0xED, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0xF8, 0xA5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xBA, /* 0x6C-0x6F */
	0xDB, 0xD8, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xA2, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xCD, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xED, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xEB, 0xDE, 0xC5, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0xE3, 0xE0, 0x3F, 0x3F, 0xCA, 0xC9, /* 0x80-0x83 */
	0xF2, 0xE9, 0x3F, 0x3F, 0xD5, 0xCE, 0x3F, 0x3F, /* 0x84-0x87 */
	0xF6, 0xB6, 0x3F, 0x3F, 0xCE, 0xC2, 0xD6, 0xC7, /* 0x88-0x8B */
	0x3F, 0x3F, 0xE3, 0xB4, 0x3F, 0x3F, 0xF1, 0xAD, /* 0x8C-0x8F */
	0x3F, 0x3F, 0xEA, 0xE2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xC2, 0x3F, 0x3F, /* 0x94-0x97 */
	0xF3, 0xA7, 0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xEA, /* 0x98-0x9B */
	0x3F, 0x3F, 0xEB, 0xEE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xB2, 0xFD, 0xA5, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0xF6, 0xD5, 0xD5, 0xE2, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xB5, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xF5, 0xF5, 0xB5, /* 0xC0-0xC3 */
	0xE4, 0xAD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xE7, 0xEB, 0xF1, 0xD5, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xBB, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0xE9, 0xB5, 0x3F, 0x3F, 0xCC, 0xC9, /* 0xD0-0xD3 */
	0xFA, 0xD5, 0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xD4, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xD6, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0xDC, 0xC1, 0x3F, 0x3F, 0xDE, 0xC6, /* 0xDC-0xDF */
	0xFA, 0xEF, 0xE3, 0xE1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xF3, 0xDC, 0xF6, /* 0xEC-0xEF */
	0x3F, 0x3F, 0xCE, 0xFC, 0x3F, 0x3F, 0xDB, 0xC4, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0xF8, 0xF1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0xDC, 0xE4, 0x3F, 0x3F, 0xE5, 0xEF, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_50[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xB1, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xD6, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0xF3, 0xDA, 0x3F, 0x3F, 0xCB, 0xC1, /* 0x08-0x0B */
	0x3F, 0x3F, 0xDB, 0xC3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xD9, 0xFA, 0xD3, 0xEE, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xB8, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0xFD, 0xA6, 0xEB, 0xEF, 0x3F, 0x3F, /* 0x18-0x1B */
	0xF4, 0xA6, 0x3F, 0x3F, 0xCC, 0xCA, 0xF3, 0xA8, /* 0x1C-0x1F */
	0x3F, 0x3F, 0xF3, 0xDB, 0x3F, 0x3F, 0xDB, 0xA7, /* 0x20-0x23 */
	0xF6, 0xB7, 0x3F, 0x3F, 0xCF, 0xE6, 0xF0, 0xF2, /* 0x24-0x27 */
	0xCB, 0xDA, 0x3F, 0x3F, 0xE7, 0xD2, 0xD7, 0xC3, /* 0x28-0x2B */
	0xF6, 0xF0, 0xE8, 0xDE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xA6, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xE7, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xA3, /* 0x44-0x47 */
	0xCC, 0xA7, 0xEA, 0xC9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xB6, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0xFA, 0xA5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xAE, 0x3F, 0x3F, /* 0x58-0x5B */
	0xEF, 0xCE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0xCB, 0xED, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0xF6, 0xB0, 0xEF, 0xCF, 0xE9, 0xCF, 0x3F, 0x3F, /* 0x74-0x77 */
	0xF7, 0xDE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0xCE, 0xD3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0xDC, 0xF7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0xDB, 0xA8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0xCB, 0xF8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0xDF, 0xA1, 0xDD, 0xE1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0xF5, 0xCA, 0xE9, 0xB6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xEC, 0xEE, 0xEE, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0xF3, 0xF0, 0x3F, 0x3F, 0xDF, 0xBF, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xCB, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0xD0, 0xC1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xF4, 0xD2, 0xE0, 0xBA, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xC0, /* 0xCC-0xCF */
	0x3F, 0x3F, 0xCE, 0xE0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0xDC, 0xD2, 0xFD, 0xEA, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xF6, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xCA, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0xE8, 0xE9, 0x3F, 0x3F, 0xE3, 0xAC, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0xF3, 0xD0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0xCA, 0xA4, 0x3F, 0x3F, 0xDB, 0xF8, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xC7, /* 0xFC-0xFF */
};

static unsigned char u2c_51[512] = {
	0xEB, 0xF0, 0xF1, 0xD6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0xE5, 0xE2, 0x3F, 0x3F, 0xCC, 0xCC, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0xCB, 0xFB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xE3, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xC1, /* 0x1C-0x1F */
	0x3F, 0x3F, 0xD6, 0xED, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xD0, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xB9, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xE3, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xD3, 0x3F, 0x3F, /* 0x38-0x3B */
	0xE5, 0xF0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0xE8, 0xB4, 0xEB, 0xC3, 0x3F, 0x3F, 0xEA, 0xAA, /* 0x40-0x43 */
	0xFA, 0xFC, 0xF5, 0xF6, 0xF0, 0xBC, 0xFD, 0xD4, /* 0x44-0x47 */
	0xE0, 0xBB, 0xCE, 0xC3, 0x3F, 0x3F, 0xD0, 0xBA, /* 0x48-0x4B */
	0xF7, 0xBA, 0xD8, 0xF3, 0xF7, 0xCD, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xAE, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0xD4, 0xDF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xE7, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0xEC, 0xFD, 0x3F, 0x3F, 0xD2, 0xAE, /* 0x64-0x67 */
	0xEE, 0xEF, 0xD5, 0xD7, 0xEA, 0xE4, 0xF8, 0xA2, /* 0x68-0x6B */
	0xCD, 0xEB, 0xD7, 0xBF, 0xFB, 0xB1, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0xCD, 0xEC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0xDC, 0xB2, 0xD0, 0xEC, 0xCE, 0xFD, /* 0x74-0x77 */
	0xEE, 0xF0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0xCC, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0xD0, 0xED, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xF7, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xFC, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0xEE, 0xA2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xB3, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0xD8, 0xF4, 0x3F, 0x3F, 0xE9, 0xB7, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0xCE, 0xAE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0xD9, 0xA2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xF1, 0x3F, 0x3F, /* 0xA8-0xAB */
	0xD4, 0xCF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xA7, 0xD5, 0xD2, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0xD6, 0xA9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xF4, 0xA2, 0x3F, 0x3F, 0xF1, 0xD7, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xD5, 0xD8, 0x3F, 0x3F, 0xF0, 0xBD, /* 0xC8-0xCB */
	0xD7, 0xD0, 0xD4, 0xD0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0xD7, 0xCF, 0xEB, 0xEA, 0xFD, 0xEB, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xDB, 0xED, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0xFC, 0xC5, 0xCB, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xD5, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0xF4, 0xC8, 0xE8, 0xEA, 0xF5, 0xF3, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0xF9, 0xDE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_52[512] = {
	0xD3, 0xEF, 0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xD3, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xC2, 0xEF, 0xB7, /* 0x04-0x07 */
	0xE7, 0xD4, 0x3F, 0x3F, 0xCA, 0xCA, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xFB, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xFA, 0xFD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xAA, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0xF4, 0xF8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0xF7, 0xF7, 0xDC, 0xAC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0xD7, 0xD7, 0xDF, 0xA2, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xBE, 0x3F, 0x3F, /* 0x2C-0x2F */
	0xD3, 0xF0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xA4, 0xE1, 0xEC, /* 0x34-0x37 */
	0xCF, 0xE7, 0xF3, 0xCB, 0xED, 0xA9, 0xCA, 0xBE, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xEF, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xCE, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xFB, 0xD0, 0xBB, /* 0x48-0x4B */
	0xD5, 0xB7, 0xEE, 0xF1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0xF4, 0xA8, 0x3F, 0x3F, 0xDC, 0xF8, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xA7, /* 0x58-0x5B */
	0x3F, 0x3F, 0xDA, 0xCE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0xE0, 0xE6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0xED, 0xA5, 0xEE, 0xF2, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xF9, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xDC, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0xF3, 0xDC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0xF8, 0xF2, 0x3F, 0x3F, 0xF4, 0xF9, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xF1, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xBC, /* 0x84-0x87 */
	0xDB, 0xF9, 0xD7, 0xB1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0xCB, 0xFC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0xF0, 0xA5, 0xCB, 0xFD, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xF4, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xED, /* 0x9C-0x9F */
	0xCA, 0xA5, 0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xAB, /* 0xA0-0xA3 */
	0xD0, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0xF0, 0xBE, 0xD2, 0xBD, 0xCC, 0xA4, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xB6, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0xCC, 0xCD, 0x3F, 0x3F, 0xDA, 0xFA, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0xF6, 0xCF, 0x3F, 0x3F, 0xE9, 0xB8, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xD8, 0xF5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0xCC, 0xCE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xCD, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0xD4, 0xD1, 0xE9, 0xED, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0xCA, 0xEB, 0xD9, 0xE2, 0x3F, 0x3F, 0xFD, 0xB2, /* 0xD8-0xDB */
	0x3F, 0x3F, 0xE3, 0xAD, 0xD6, 0xCC, 0xD9, 0xB4, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xA7, 0xEE, 0xD3, /* 0xE0-0xE3 */
	0xD0, 0xC3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xB3, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0xD5, 0xE4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0xCF, 0xE8, 0x3F, 0x3F, 0xED, 0xC3, 0xD0, 0xB2, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xFE, 0xDA, 0xA8, /* 0xFC-0xFF */
};

static unsigned char u2c_53[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0xF8, 0xD0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0xFD, 0xD6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0xF8, 0xD1, 0x3F, 0x3F, 0xF8, 0xD2, /* 0x0C-0x0F */
	0xDC, 0xD3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0xDD, 0xE2, 0xFB, 0xF9, 0xDD, 0xC1, /* 0x14-0x17 */
	0x3F, 0x3F, 0xE3, 0xB5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0xED, 0xDD, 0xCE, 0xC4, 0x3F, 0x3F, 0xCB, 0xA1, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xE3, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xDD, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0xF9, 0xAF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD2, 0xFB, /* 0x3C-0x3F */
	0xCF, 0xA1, 0xE4, 0xA8, 0x3F, 0x3F, 0xF4, 0xB6, /* 0x40-0x43 */
	0xEC, 0xFE, 0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xAE, /* 0x44-0x47 */
	0xE7, 0xED, 0xFD, 0xC1, 0xDA, 0xE2, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0xD8, 0xB3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0xDD, 0xE4, 0xF0, 0xEF, 0xF6, 0xF1, /* 0x50-0x53 */
	0xFA, 0xF0, 0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xF5, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDA, 0xCF, 0x3F, 0x3F, /* 0x58-0x5B */
	0xDC, 0xD4, 0x3F, 0x3F, 0xDC, 0xA6, 0x3F, 0x3F, /* 0x5C-0x5F */
	0xEF, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xCF, 0x3F, 0x3F, /* 0x64-0x67 */
	0xE0, 0xD9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xD6, /* 0x6C-0x6F */
	0xEC, 0xD4, 0xEA, 0xCB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0xCA, 0xBF, 0xD5, 0xB0, 0x3F, 0x3F, 0xCF, 0xE9, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0xF1, 0xED, 0x3F, 0x3F, 0xCC, 0xCF, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0xE4, 0xF8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xED, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0xD7, 0xD8, 0x3F, 0x3F, 0xFD, 0xA7, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xAB, /* 0x9C-0x9F */
	0xF6, 0xB2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0xCF, 0xF0, 0xF9, 0xBD, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0xE6, 0xF4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xDB, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xD1, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0xE9, 0xD1, 0xF3, 0xA9, 0xD0, 0xE0, 0xE9, 0xD2, /* 0xC8-0xCB */
	0x3F, 0x3F, 0xDA, 0xE3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0xE2, 0xD2, 0x3F, 0x3F, 0xF6, 0xA2, 0xE1, 0xF4, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDA, 0xE4, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xE7, 0xD5, 0xF5, 0xBF, 0xCF, 0xA2, /* 0xE0-0xE3 */
	0xCD, 0xAF, 0xCF, 0xA3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0xCD, 0xB0, 0xF1, 0xFE, 0xD0, 0xA3, /* 0xE8-0xEB */
	0xE1, 0xAF, 0xF8, 0xA3, 0x3F, 0x3F, 0xCA, 0xA6, /* 0xEC-0xEF */
	0xF7, 0xBB, 0xF2, 0xEA, 0xDE, 0xC8, 0xE9, 0xD3, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0xDE, 0xC9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_54[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xDE, /* 0x00-0x03 */
	0xCA, 0xC0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0xF9, 0xEA, 0xD1, 0xCE, 0xEE, 0xD4, 0x3F, 0x3F, /* 0x08-0x0B */
	0xD4, 0xD2, 0xD9, 0xA3, 0xFD, 0xA8, 0xD7, 0xD9, /* 0x0C-0x0F */
	0xF7, 0xCE, 0xFA, 0xBE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xD6, /* 0x18-0x1B */
	0x3F, 0x3F, 0xD7, 0xF0, 0x3F, 0x3F, 0xEB, 0xE1, /* 0x1C-0x1F */
	0xF8, 0xC5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xFA, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0xDD, 0xC3, 0x3F, 0x3F, 0xF9, 0xDF, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xEF, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0xFD, 0xE5, 0xF6, 0xA3, 0x3F, 0x3F, 0xD9, 0xFC, /* 0x38-0x3B */
	0xFD, 0xA9, 0x3F, 0x3F, 0xE7, 0xEE, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xE5, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0xEF, 0xD0, 0x3F, 0x3F, 0xCD, 0xB1, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0xF7, 0xA2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0xF1, 0xB2, 0x3F, 0x3F, 0xF1, 0xB1, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0xCD, 0xB2, 0x3F, 0x3F, 0xDA, 0xAB, /* 0x70-0x73 */
	0x3F, 0x3F, 0xCA, 0xA7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xE2, /* 0x78-0x7B */
	0xFB, 0xBC, 0xD9, 0xA4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0xEE, 0xBA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xD3, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0xFB, 0xFA, 0x3F, 0x3F, 0xCF, 0xA4, 0x3F, 0x3F, /* 0x8C-0x8F */
	0xDC, 0xFB, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0xF6, 0xE3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0xED, 0xAA, 0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xA1, /* 0xA8-0xAB */
	0xCE, 0xE1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xA6, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0xF9, 0xE0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0xEC, 0xD6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0xE4, 0xEE, 0xF9, 0xA1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xFB, 0xEF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0xF9, 0xEB, 0xEE, 0xA3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xEA, 0xAC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0xCA, 0xA8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0xF4, 0xFA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0xCD, 0xD6, 0xFC, 0xF6, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xC9, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xD4, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_55[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0xF8, 0xA6, 0x3F, 0x3F, 0xDE, 0xCA, 0xF2, 0xC6, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xDA, 0x3F, 0x3F, /* 0x0C-0x0F */
	0xD3, 0xD0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0xD8, 0xC5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xE6, /* 0x2C-0x2F */
	0x3F, 0x3F, 0xF3, 0xDD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0xE4, 0xDA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xE4, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0xF6, 0xF2, 0x3F, 0x3F, 0xDF, 0xC2, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xFD, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xF6, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xBA, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xAF, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xE1, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0xF0, 0xA6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0xCB, 0xD3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0xE0, 0xBC, 0x3F, 0x3F, 0xF4, 0xCA, 0xD4, 0xFA, /* 0x84-0x87 */
	0x3F, 0x3F, 0xFD, 0xAA, 0xF9, 0xE2, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0xF4, 0xB7, 0xFD, 0xC2, 0xFC, 0xB0, 0x3F, 0x3F, /* 0x98-0x9B */
	0xFD, 0xEC, 0xCA, 0xE2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xBD, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0xEA, 0xE7, 0xDF, 0xC3, 0xD1, 0xD2, /* 0xA8-0xAB */
	0xCE, 0xE2, 0x3F, 0x3F, 0xD3, 0xA4, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0xFD, 0xAB, 0x3F, 0x3F, 0xDF, 0xE0, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0xF2, 0xC7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xF0, 0x3F, 0x3F, /* 0xD8-0xDB */
	0xD0, 0xEE, 0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xAA, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xCB, /* 0xE0-0xE3 */
	0xF6, 0xB8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0xE1, 0xF5, 0xF1, 0xB3, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_56[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF7, 0xA3, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0xCA, 0xA9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0xCF, 0xA5, 0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xC4, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xB0, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xBF, 0x3F, 0x3F, /* 0x30-0x33 */
	0xF6, 0xA4, 0x3F, 0x3F, 0xE3, 0xB6, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xC6, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0xD0, 0xEF, 0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xED, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0xDD, 0xC4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xF7, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0xE6, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0xDE, 0xAD, 0x3F, 0x3F, 0xFA, 0xBF, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0xE5, 0xF1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0xED, 0xC4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD2, 0xA5, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0xFD, 0xEE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0xF5, 0xB6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xF6, 0xDE, 0xCC, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xDE, 0x3F, 0x3F, /* 0xDC-0xDF */
	0xEC, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0xCD, 0xDD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0xD6, 0xB7, 0xCD, 0xB3, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_57[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xD5, /* 0x00-0x03 */
	0xE5, 0xD8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0xCF, 0xEA, 0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xD0, /* 0x08-0x0B */
	0x3F, 0x3F, 0xEA, 0xCC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xAE, 0xEA, 0xAD, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xF1, 0x3F, 0x3F, /* 0x14-0x17 */
	0xD3, 0xA5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF7, 0xCF, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0xEE, 0xA4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0xD0, 0xA4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0xF2, 0xA2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xF0, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0xF2, 0xA3, 0x3F, 0x3F, 0xF7, 0xF8, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xB3, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xA9, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0xD3, 0xBB, 0xCA, 0xEC, 0x3F, 0x3F, /* 0x4C-0x4F */
	0xF1, 0xA6, 0xCB, 0xD5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0xF7, 0xE7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0xCD, 0xDE, 0x3F, 0x3F, 0xF7, 0xA4, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xC0, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xDD, 0x3F, 0x3F, /* 0x6C-0x6F */
	0xCC, 0xD0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0xCF, 0xA6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0xF6, 0xF3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xF7, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0xD3, 0xDC, 0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xFE, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xA7, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0xEB, 0xD9, 0x3F, 0x3F, 0xCF, 0xA7, 0xEA, 0xAF, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xEF, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xB9, /* 0xC4-0xC7 */
	0xF1, 0xD8, 0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xD8, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xF2, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE6, 0xB4, /* 0xDC-0xDF */
	0xDC, 0xFC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0xF3, 0xF1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0xE3, 0xD0, 0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xFB, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0xDB, 0xC6, 0xD0, 0xF1, 0x3F, 0x3F, /* 0xF8-0xFB */
	0xD0, 0xF2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_58[512] = {
	0xCF, 0xDC, 0x3F, 0x3F, 0xD3, 0xD1, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0xCC, 0xB1, 0xF7, 0xD8, 0x3F, 0x3F, /* 0x04-0x07 */
	0xCB, 0xA8, 0xEB, 0xBC, 0xE4, 0xBE, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xDC, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0xDC, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0xF0, 0xA7, 0x3F, 0x3F, 0x3F, 0x3F, 0xE6, 0xC0, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xED, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xEB, /* 0x2C-0x2F */
	0xE5, 0xE8, 0xDC, 0xC3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0xED, 0xDE, 0xD3, 0xF2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xF7, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xD4, 0xE7, 0xAB, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xC3, /* 0x4C-0x4F */
	0x3F, 0x3F, 0xE1, 0xB1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0xF7, 0xB2, 0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xF3, /* 0x54-0x57 */
	0xD3, 0xD2, 0x3F, 0x3F, 0xF5, 0xC0, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xDD, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0xEE, 0xF3, 0xE7, 0xF1, 0x3F, 0x3F, /* 0x60-0x63 */
	0xFD, 0xB4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0xF2, 0xC8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0xF3, 0xD2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0xEE, 0xF4, 0x3F, 0x3F, 0xE2, 0xD3, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xD1, /* 0x80-0x83 */
	0x3F, 0x3F, 0xDF, 0xEA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0xE9, 0xBA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xD7, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0xF5, 0xCD, 0x3F, 0x3F, 0xF1, 0xF2, 0xFA, 0xC7, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0xD9, 0xF8, 0xD4, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xE5, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xC5, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xF2, 0xED, 0xDF, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xCB, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0xDB, 0xFA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0xE8, 0xB5, 0x3F, 0x3F, 0xD3, 0xA6, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xB5, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0xF9, 0xC9, 0x3F, 0x3F, 0xE4, 0xE2, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0xFB, 0xBD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0xD7, 0xA4, 0xCE, 0xC5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xD5, 0xD6, 0xE6, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0xE5, 0xBD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xCD, /* 0xE8-0xEB */
	0xEC, 0xF3, 0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xE0, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0xEC, 0xEC, 0xFB, 0xBE, 0xDF, 0xEB, /* 0xF8-0xFB */
	0x3F, 0x3F, 0xE1, 0xF8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_59[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xBE, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0xD0, 0xF3, 0xE0, 0xAA, 0xE8, 0xE2, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0xE2, 0xD4, 0xD2, 0xFD, 0x3F, 0x3F, /* 0x18-0x1B */
	0xE5, 0xA8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xD3, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xDE, /* 0x24-0x27 */
	0x3F, 0x3F, 0xF4, 0xB8, 0xF7, 0xBC, 0xDC, 0xFD, /* 0x28-0x2B */
	0x3F, 0x3F, 0xE8, 0xEC, 0xE4, 0xE7, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0xE3, 0xF7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xA8, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xF1, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0xE5, 0xF2, 0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xF4, /* 0x44-0x47 */
	0xD2, 0xAF, 0xDC, 0xE5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xA5, 0xF1, 0xB4, /* 0x4C-0x4F */
	0xFC, 0xB1, 0xCC, 0xF8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0xDD, 0xC6, 0xFA, 0xD1, 0x3F, 0x3F, 0xF7, 0xDF, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xA8, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0xEE, 0xF5, 0x3F, 0x3F, 0xDE, 0xCE, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xF3, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF7, 0xAC, 0xEB, 0xC4, /* 0x68-0x6B */
	0xED, 0xE1, 0xE0, 0xAB, 0xDD, 0xC7, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD2, 0xB3, /* 0x70-0x73 */
	0xD2, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0xCA, 0xCC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0xFB, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xFD, 0xDD, 0xE5, /* 0x80-0x83 */
	0xD8, 0xCD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xF4, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xF5, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xED, 0xD0, 0xD2, /* 0x94-0x97 */
	0x3F, 0x3F, 0xD9, 0xD8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0xF6, 0xE6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0xDB, 0xAA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0xF7, 0xE0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0xD8, 0xD9, 0x3F, 0x3F, 0xF4, 0xA3, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xDD, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xD1, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xB5, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xED, 0xAB, 0x3F, 0x3F, 0xE3, 0xB7, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0xEE, 0xBB, 0xCD, 0xB4, 0x3F, 0x3F, 0xE0, 0xF3, /* 0xD0-0xD3 */
	0xEA, 0xCD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0xEC, 0xF5, 0xE8, 0xEE, 0x3F, 0x3F, /* 0xD8-0xDB */
	0xCB, 0xA9, 0xF1, 0xAF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xCD, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0xEC, 0xA9, 0x3F, 0x3F, 0xF2, 0xEB, 0x3F, 0x3F, /* 0xE8-0xEB */
	0xFD, 0xEF, 0x3F, 0x3F, 0xF9, 0xF3, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0xE6, 0xC1, 0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xD8, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xAC, /* 0xFC-0xFF */
};

static unsigned char u2c_5A[512] = {
	0x3F, 0x3F, 0xEA, 0xCE, 0x3F, 0x3F, 0xE8, 0xDF, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xDE, 0xCF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0xD2, 0xA6, 0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xF4, /* 0x18-0x1B */
	0xD1, 0xD6, 0x3F, 0x3F, 0x3F, 0x3F, 0xE6, 0xC2, /* 0x1C-0x1F */
	0xE3, 0xE3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0xE4, 0xB0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0xD8, 0xB4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xA5, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0xF3, 0xDE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0xD7, 0xA5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF7, 0xE8, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0xE8, 0xC6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xE6, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xE6, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xFE, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xDA, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDA, 0xAC, 0xEA, 0xB0, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0xE3, 0xB8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0xCA, 0xAA, 0xE1, 0xF9, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xEA, 0xB1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xF2, 0xEC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0xFA, 0xEE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xEE, 0xD5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xF4, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0xD2, 0xEC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_5B[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0xFB, 0xFB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0xFD, 0xF0, 0x3F, 0x3F, 0xE0, 0xBD, /* 0x08-0x0B */
	0xCE, 0xE3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xC6, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xAE, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0xDF, 0xC5, 0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xBE, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0xED, 0xAD, 0xFA, 0xEA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0xCD, 0xEE, 0xED, 0xA6, 0x3F, 0x3F, 0xED, 0xAE, /* 0x54-0x57 */
	0xF0, 0xED, 0x3F, 0x3F, 0xDD, 0xA1, 0x3F, 0x3F, /* 0x58-0x5B */
	0xED, 0xAF, 0xFC, 0xF8, 0x3F, 0x3F, 0xD8, 0xEB, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xF9, /* 0x60-0x63 */
	0xCD, 0xB5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0xFA, 0xA9, 0x3F, 0x3F, 0xE1, 0xDD, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0xE2, 0xD5, 0xED, 0xCF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0xDD, 0xA2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0xF9, 0xCA, 0x3F, 0x3F, 0xEA, 0xE8, 0x3F, 0x3F, /* 0x78-0x7B */
	0xE5, 0xED, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0xD3, 0xEB, 0x3F, 0x3F, 0xE9, 0xD4, /* 0x84-0x87 */
	0xE1, 0xFA, 0xE4, 0xCC, 0x3F, 0x3F, 0xE1, 0xE4, /* 0x88-0x8B */
	0xE8, 0xC7, 0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xDB, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xD5, /* 0x90-0x93 */
	0x3F, 0x3F, 0xF7, 0xB5, 0xFC, 0xF3, 0xF0, 0xF3, /* 0x94-0x97 */
	0xCE, 0xAF, 0xF1, 0xB5, 0xEF, 0xD2, 0xE8, 0xC8, /* 0x98-0x9B */
	0xEB, 0xF1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xD4, 0xE0, 0xBE, /* 0xA0-0xA3 */
	0xE3, 0xF8, 0xEA, 0xE9, 0xFC, 0xB2, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0xE0, 0xF4, 0x3F, 0x3F, 0xCF, 0xE0, 0x3F, 0x3F, /* 0xAC-0xAF */
	0xEE, 0xA5, 0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xAA, /* 0xB0-0xB3 */
	0xE6, 0xC3, 0xE1, 0xB2, 0xCA, 0xAB, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0xE3, 0xE4, 0xE9, 0xBB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xD6, /* 0xBC-0xBF */
	0xF3, 0xF2, 0x3F, 0x3F, 0xEE, 0xD6, 0xEA, 0xB2, /* 0xC0-0xC3 */
	0xD0, 0xF6, 0xEC, 0xD9, 0xDA, 0xCB, 0xCF, 0xA8, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0xDD, 0xA3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0xD8, 0xDB, 0x3F, 0x3F, 0xF9, 0xCE, 0xE9, 0xD5, /* 0xD0-0xD3 */
	0xE3, 0xD1, 0x3F, 0x3F, 0x3F, 0x3F, 0xD2, 0xBC, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xAC, 0xF3, 0xCC, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xCD, 0xFB, 0xF6, 0xD6, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0xE7, 0xF5, 0xE8, 0xEF, 0xE3, 0xF9, 0xD2, 0xBB, /* 0xE4-0xE7 */
	0xF3, 0xF3, 0xE3, 0xFB, 0x3F, 0x3F, 0xDE, 0xD0, /* 0xE8-0xEB */
	0xCE, 0xB0, 0x3F, 0x3F, 0xD6, 0xF7, 0xF1, 0xD9, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0xF5, 0xC1, 0xDC, 0xC4, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0xF5, 0xBB, 0x3F, 0x3F, 0xDE, 0xD1, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_5C[512] = {
	0x3F, 0x3F, 0xDC, 0xE6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0xDE, 0xD2, 0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xE2, /* 0x04-0x07 */
	0xEE, 0xF6, 0xEA, 0xCF, 0xF0, 0xEE, 0xE3, 0xFC, /* 0x08-0x0B */
	0x3F, 0x3F, 0xD3, 0xDF, 0xD3, 0xF4, 0xE1, 0xB3, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xE1, 0xB4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xD3, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0xDF, 0xC6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0xE9, 0xD6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0xDB, 0xAB, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0xF6, 0xA6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0xE3, 0xB9, 0xEB, 0xC5, 0xF4, 0xA9, 0xCD, 0xB6, /* 0x38-0x3B */
	0xD2, 0xF9, 0x3F, 0x3F, 0xDA, 0xAD, 0xD2, 0xE3, /* 0x3C-0x3F */
	0xCF, 0xD1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0xCB, 0xDC, 0xCC, 0xFA, 0x3F, 0x3F, /* 0x44-0x47 */
	0xCF, 0xDD, 0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xA9, /* 0x48-0x4B */
	0x3F, 0x3F, 0xE3, 0xBB, 0xE3, 0xBA, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0xE0, 0xDA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0xEE, 0xF7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xB3, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0xD3, 0xF5, 0x3F, 0x3F, 0xD7, 0xA6, 0x3F, 0x3F, /* 0x60-0x63 */
	0xF6, 0xB5, 0xD7, 0xDB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0xE1, 0xD5, 0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xEA, /* 0x6C-0x6F */
	0x3F, 0x3F, 0xDF, 0xA3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0xFD, 0xDF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0xD0, 0xF7, 0xED, 0xD4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0xCB, 0xAA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0xE4, 0xDB, 0x3F, 0x3F, 0xE1, 0xFB, /* 0xA8-0xAB */
	0xCB, 0xA2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0xD3, 0xE0, 0x3F, 0x3F, 0xE4, 0xBF, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0xFB, 0xC0, 0x3F, 0x3F, 0xDA, 0xBE, /* 0xB4-0xB7 */
	0xE4, 0xCD, 0x3F, 0x3F, 0xD6, 0xB9, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xC0, 0x3F, 0x3F, /* 0xBC-0xBF */
	0xE1, 0xFC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0xF6, 0xB9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0xDF, 0xC7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0xE4, 0xB1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xE7, /* 0xEC-0xEF */
	0xDC, 0xE8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0xFA, 0xD6, 0x3F, 0x3F, 0xD3, 0xF6, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xDA, /* 0xF8-0xFB */
	0x3F, 0x3F, 0xFA, 0xF2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_5D[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xFD, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0xD5, 0xCF, 0xD0, 0xF8, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xCD, 0xDF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0xF5, 0xCB, 0x3F, 0x3F, 0xE4, 0xF0, 0xCB, 0xAB, /* 0x14-0x17 */
	0x3F, 0x3F, 0xD7, 0xC4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xFE, /* 0x24-0x27 */
	0x3F, 0x3F, 0xDD, 0xDA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDA, 0xAE, /* 0x48-0x4B */
	0xCA, 0xEE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0xD5, 0xB9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0xE3, 0xA1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0xE8, 0xE3, 0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xAB, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xA9, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xF7, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0xD4, 0xF1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0xCE, 0xE4, 0x3F, 0x3F, 0xE8, 0xF2, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xF5, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0xE7, 0xAE, 0x3F, 0x3F, 0xD6, 0xBA, 0x3F, 0x3F, /* 0xB8-0xBB */
	0xDF, 0xEC, 0xE4, 0xC0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0xE8, 0xE4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xB5, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xDC, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0xF4, 0xB9, 0xF1, 0xB6, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xE2, 0xDE, 0xE1, 0xB5, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0xCD, 0xEF, 0xF1, 0xA7, 0xCE, 0xE5, /* 0xE4-0xE7 */
	0xCB, 0xDD, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xE3, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xAC, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0xD0, 0xF9, 0xEC, 0xAB, 0xDE, 0xD3, /* 0xF0-0xF3 */
	0xF7, 0xE9, 0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xF5, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0xE1, 0xDE, 0xCB, 0xEE, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_5E[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xBC, 0xF8, 0xD6, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xEE, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0xFD, 0xF1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xF7, 0xB6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xDE, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0xF2, 0xED, 0x3F, 0x3F, 0xDB, 0xD9, /* 0x18-0x1B */
	0x3F, 0x3F, 0xF0, 0xA8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0xE1, 0xFD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xD4, /* 0x28-0x2B */
	0x3F, 0x3F, 0xE0, 0xAC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xE3, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xE1, 0x3F, 0x3F, /* 0x34-0x37 */
	0xDF, 0xC8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0xD9, 0xB6, 0x3F, 0x3F, 0xFD, 0xAC, /* 0x3C-0x3F */
	0xEF, 0xD3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0xE4, 0xC1, 0xF8, 0xEB, 0x3F, 0x3F, 0xDB, 0xAC, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0xFC, 0xC6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0xD8, 0xAD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xBA, /* 0x5C-0x5F */
	0x3F, 0x3F, 0xDB, 0xDF, 0xD3, 0xD3, 0xF8, 0xC7, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xCE, 0xF8, 0xC1, /* 0x70-0x73 */
	0xD2, 0xB4, 0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xB4, /* 0x74-0x77 */
	0xFA, 0xB9, 0xCA, 0xCF, 0x3F, 0x3F, 0xFC, 0xB3, /* 0x78-0x7B */
	0xEA, 0xEA, 0xEA, 0xEB, 0xD0, 0xFA, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0xED, 0xE4, 0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xE7, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xC9, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xED, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0xEE, 0xBC, 0x3F, 0x3F, 0xEF, 0xC1, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xD2, 0x3F, 0x3F, /* 0x98-0x9B */
	0xDD, 0xA4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0xDF, 0xCA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xF8, 0xF1, 0xA8, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xB7, /* 0xA8-0xAB */
	0x3F, 0x3F, 0xEF, 0xD4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0xE4, 0xDD, 0xDF, 0xEE, 0xCB, 0xAC, /* 0xB4-0xB7 */
	0xE9, 0xBC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xEC, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xCB, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0xF9, 0xBF, 0xD6, 0xAF, 0xD5, 0xC6, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0xCF, 0xAA, 0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xA9, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xF8, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xB7, 0xEE, 0xF8, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xD9, /* 0xDC-0xDF */
	0xF3, 0xDF, 0x3F, 0x3F, 0xF8, 0xC8, 0xCE, 0xC6, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0xD5, 0xE6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xE6, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE6, 0xC5, 0xEF, 0xD5, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xEF, 0xFC, 0xDF, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_5F[512] = {
	0x3F, 0x3F, 0xDC, 0xA7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0xD6, 0xE7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xC9, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xD2, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xE3, 0xBD, 0x3F, 0x3F, 0xCF, 0xE1, /* 0x10-0x13 */
	0xF0, 0xC0, 0xEC, 0xDA, 0x3F, 0x3F, 0xDD, 0xD7, /* 0x14-0x17 */
	0xFB, 0xF0, 0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xAC, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xA9, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xD7, 0xFB, 0xC1, /* 0x24-0x27 */
	0x3F, 0x3F, 0xD2, 0xC0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0xE5, 0xB0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0xED, 0xE5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xAD, 0x3F, 0x3F, /* 0x38-0x3B */
	0xF9, 0xB0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0xF7, 0xA5, 0x3F, 0x3F, 0xCB, 0xAE, 0x3F, 0x3F, /* 0x48-0x4B */
	0xDA, 0xAF, 0x3F, 0x3F, 0xD8, 0xB6, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xA7, 0xFB, 0xB2, /* 0x54-0x57 */
	0x3F, 0x3F, 0xFD, 0xC4, 0x3F, 0x3F, 0xEC, 0xAD, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xA1, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xE9, 0xE9, 0xEE, /* 0x64-0x67 */
	0x3F, 0x3F, 0xF3, 0xF4, 0xF8, 0xF3, 0xF0, 0xC1, /* 0x68-0x6B */
	0xDE, 0xAF, 0xF8, 0xB0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0xF3, 0xE0, 0xE7, 0xAF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xAD, /* 0x74-0x77 */
	0x3F, 0x3F, 0xE6, 0xB5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0xF9, 0xA8, 0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xD8, /* 0x7C-0x7F */
	
	0xE8, 0xD9, 0xEF, 0xD6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0xD3, 0xE2, 0x3F, 0x3F, 0xE2, 0xDF, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xE0, 0xD7, 0xC8, /* 0x88-0x8B */
	0xFD, 0xAD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0xDF, 0xEF, 0xCC, 0xD3, 0xD3, 0xF9, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xF0, /* 0x94-0x97 */
	0xDB, 0xC7, 0xDE, 0xD5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xF4, 0x3F, 0x3F, /* 0x9C-0x9F */
	0xD5, 0xD0, 0xE5, 0xD9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0xFC, 0xC7, 0xDC, 0xD6, 0xE2, 0xE0, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDA, 0xB0, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0xF3, 0xA3, 0x3F, 0x3F, 0xD3, 0xEC, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0xF4, 0xCB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0xFD, 0xC5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xFD, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0xF9, 0xB1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0xD0, 0xFB, 0xEC, 0xDB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xBC, 0xF2, 0xA4, /* 0xD4-0xD7 */
	0xD8, 0xCE, 0xD8, 0xCF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0xF5, 0xF7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xE1, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0xD2, 0xB7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0xFB, 0xEC, 0x3F, 0x3F, 0xDD, 0xC8, /* 0xFC-0xFF */
};

static unsigned char u2c_60[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xE8, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD2, 0xC1, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xD7, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0xD6, 0xBB, 0xDE, 0xD6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0xF7, 0xBD, 0xEC, 0xAE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0xD0, 0xE1, 0x3F, 0x3F, 0xE0, 0xF5, /* 0x24-0x27 */
	0xEA, 0xB3, 0x3F, 0x3F, 0xCE, 0xD6, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xA5, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0xEC, 0xF6, 0xE2, 0xE1, 0xE3, 0xBE, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0xFC, 0xC8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0xCD, 0xF0, 0x3F, 0x3F, 0xF9, 0xF6, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0xDF, 0xF0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0xE5, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0xCE, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xE1, 0xED, 0xB0, /* 0x60-0x63 */
	0xFD, 0xD1, 0xF6, 0xBB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0xF9, 0xCF, 0xEB, 0xDA, 0xCA, 0xC1, 0x3F, 0x3F, /* 0x68-0x6B */
	0xD2, 0xB8, 0xCD, 0xF1, 0x3F, 0x3F, 0xE3, 0xD3, /* 0x6C-0x6F */
	0xFD, 0xE6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0xE6, 0xED, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0xE3, 0xFA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0xF0, 0xAA, 0xF9, 0xD0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0xFC, 0xE2, 0x3F, 0x3F, 0xF8, 0xA7, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xE5, 0xEE, 0xF9, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xF6, /* 0x9C-0x9F */
	0xEA, 0xED, 0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xB4, /* 0xA0-0xA3 */
	0xF5, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xDC, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0xF0, 0xF5, 0x3F, 0x3F, 0xDD, 0xE8, 0xD3, 0xED, /* 0xB0-0xB3 */
	0xF5, 0xFC, 0x3F, 0x3F, 0xDA, 0xBF, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0xCC, 0xFB, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0xD3, 0xFA, 0xF4, 0xA4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0xEF, 0xD7, 0x3F, 0x3F, 0xD4, 0xC3, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0xFB, 0xE3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xED, 0x3F, 0x3F, /* 0xD8-0xDB */
	0xE0, 0xAD, 0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xEE, /* 0xDC-0xDF */
	0xFB, 0xB3, 0xE4, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0xF6, 0xE7, 0xD2, 0xDD, 0x3F, 0x3F, 0xDF, 0xCC, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xC9, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0xE5, 0xA9, 0xE0, 0xF6, 0xF6, 0xB3, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_61[512] = {
	0x3F, 0x3F, 0xE1, 0xFE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xF0, 0x3F, 0x3F, /* 0x04-0x07 */
	0xEA, 0xEF, 0xEA, 0xF0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0xDA, 0xC0, 0xF8, 0xB4, 0xEB, 0xF2, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0xE4, 0xC3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xD7, 0xE4, 0xF1, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xEF, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xD7, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0xFC, 0xCA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0xF3, 0xE1, 0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xC4, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0xE3, 0xE5, 0x3F, 0x3F, 0xCB, 0xC5, 0xEA, 0xB4, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xBD, 0x3F, 0x3F, /* 0x40-0x43 */
	0xD7, 0xC9, 0x3F, 0x3F, 0x3F, 0x3F, 0xEB, 0xDB, /* 0x44-0x47 */
	0xED, 0xB1, 0x3F, 0x3F, 0xCC, 0xC3, 0xF7, 0xBE, /* 0x48-0x4B */
	0xFC, 0xCB, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xF4, /* 0x50-0x53 */
	0x3F, 0x3F, 0xD9, 0xB7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0xF3, 0xD3, 0xF3, 0xD4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0xF7, 0xE4, 0x3F, 0x3F, 0xF7, 0xD1, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xB7, 0xCE, 0xB1, /* 0x60-0x63 */
	0xCA, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xB4, /* 0x64-0x67 */
	0xCB, 0xC6, 0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xF6, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xE7, 0x3F, 0x3F, /* 0x6C-0x6F */
	0xEA, 0xD0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xD4, 0xCB, 0xAF, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0xF4, 0xAA, 0xE9, 0xAF, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0xF5, 0xC3, 0xE9, 0xD8, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xE9, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xF3, 0x3F, 0x3F, /* 0x8C-0x8F */
	0xD5, 0xFB, 0xDE, 0xBB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0xF4, 0xFB, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0xFD, 0xF3, 0xFD, 0xF2, 0xF7, 0xA6, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0xDD, 0xC9, 0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xD3, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0xCC, 0xA8, 0x3F, 0x3F, 0xDA, 0xC1, /* 0xA8-0xAB */
	0xCC, 0xD5, 0x3F, 0x3F, 0xD9, 0xE4, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xCA, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xE3, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xBC, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xF0, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xC4, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xD0, /* 0xC4-0xC7 */
	0xFA, 0xAB, 0xEB, 0xEB, 0xE7, 0xF8, 0xD9, 0xE5, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xD7, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xA4, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xFB, 0xFC, 0xE3, /* 0xF4-0xF7 */
	0xFA, 0xD8, 0x3F, 0x3F, 0xF3, 0xD5, 0x3F, 0x3F, /* 0xF8-0xFB */
	0xCF, 0xAB, 0x3F, 0x3F, 0x3F, 0x3F, 0xEB, 0xF3, /* 0xFC-0xFF */
};

static unsigned char u2c_62[512] = {
	0xD5, 0xFC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xD4, /* 0x04-0x07 */
	0xCD, 0xFC, 0x3F, 0x3F, 0xD9, 0xE6, 0x3F, 0x3F, /* 0x08-0x0B */
	0xE2, 0xF9, 0xE2, 0xA1, 0xEB, 0xD4, 0x3F, 0x3F, /* 0x0C-0x0F */
	0xE0, 0xF7, 0xE4, 0xB2, 0xCC, 0xFC, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xE4, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xAB, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xBD, /* 0x1C-0x1F */
	0x3F, 0x3F, 0xCA, 0xF1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xB8, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xC0, 0x3F, 0x3F, /* 0x2C-0x2F */
	0xEE, 0xFA, 0xFD, 0xF4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0xD3, 0xE3, 0x3F, 0x3F, 0xFB, 0xC2, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xE8, 0xDB, 0xAE, /* 0x3C-0x3F */
	0xE1, 0xB6, 0xF8, 0xB7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xBF, /* 0x44-0x47 */
	0xFB, 0xC3, 0xDD, 0xEA, 0x3F, 0x3F, 0xE2, 0xA2, /* 0x48-0x4B */
	0x3F, 0x3F, 0xEE, 0xA6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xE8, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0xF6, 0xF5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xCA, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0xD0, 0xE2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xA6, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0xDD, 0xEB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0xE4, 0xF9, 0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xAF, /* 0x7C-0x7F */
	
	0xD0, 0xFC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0xF4, 0xFC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0xCC, 0xBC, 0xF7, 0xEA, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0xE5, 0xE4, 0xDF, 0xF1, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0xF7, 0xE1, 0x3F, 0x3F, 0xF9, 0xF7, /* 0x94-0x97 */
	0xEF, 0xB9, 0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xD8, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xA9, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0xF8, 0xD9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0xEE, 0xBD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0xD8, 0xC6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0xE4, 0xE3, 0xF5, 0xCE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xD9, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xE7, /* 0xC4-0xC7 */
	0xD2, 0xB9, 0xD5, 0xC3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0xDA, 0xE5, 0xDA, 0xD0, 0x3F, 0x3F, 0xD1, 0xD9, /* 0xCC-0xCF */
	0xCE, 0xD8, 0x3F, 0x3F, 0xCB, 0xDE, 0xF4, 0xAC, /* 0xD0-0xD3 */
	0xDA, 0xFB, 0x3F, 0x3F, 0xF6, 0xE9, 0xE8, 0xF3, /* 0xD4-0xD7 */
	0xCF, 0xAC, 0xF0, 0xF0, 0x3F, 0x3F, 0xF4, 0xFD, /* 0xD8-0xDB */
	0xDB, 0xC8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0xCE, 0xC0, 0xE3, 0xD4, 0xD1, 0xCF, 0xF1, 0xF5, /* 0xEC-0xEF */
	0x3F, 0x3F, 0xCD, 0xF2, 0x3F, 0x3F, 0xCF, 0xEB, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xB8, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xA6, 0xD1, 0xDA, /* 0xFC-0xFF */
};

static unsigned char u2c_63[512] = {
	0x3F, 0x3F, 0xF2, 0xA5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xA6, /* 0x04-0x07 */
	0x3F, 0x3F, 0xE4, 0xCE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xD3, 0xFB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xA9, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xC9, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xD8, 0xE6, 0xC9, /* 0x38-0x3B */
	0x3F, 0x3F, 0xD8, 0xB8, 0xFA, 0xF3, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0xF3, 0xB5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0xF8, 0xA4, 0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xF3, /* 0x4C-0x4F */
	0xE6, 0xC8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0xF8, 0xDA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xE9, /* 0x64-0x67 */
	0xDE, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xDF, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xEC, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xDF, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xF4, 0xD2, 0xBA, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xF2, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xB7, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0xE2, 0xA3, 0xD3, 0xFC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0xED, 0xE6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xC9, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xFA, 0x3F, 0x3F, /* 0x94-0x97 */
	0xCF, 0xDE, 0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xD0, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0xD5, 0xD3, 0xF3, 0xF5, 0xF7, 0xAE, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0xEF, 0xC8, 0x3F, 0x3F, 0xCD, 0xF3, /* 0xA4-0xA7 */
	0xF5, 0xCF, 0xE5, 0xF3, 0xF0, 0xC2, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0xCA, 0xD1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xEA, 0xF1, 0x3F, 0x3F, 0xD0, 0xA6, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xDA, /* 0xCC-0xCF */
	0xF0, 0xAB, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEB, 0xE7, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xC0, 0xFC, 0xB5, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xE4, 0xC4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0xCC, 0xA9, 0xFD, 0xC6, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0xEA, 0xB5, 0x3F, 0x3F, 0xE5, 0xAA, 0xDF, 0xBA, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_64[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0xE1, 0xDF, 0x3F, 0x3F, 0xDA, 0xD1, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0xE1, 0xB8, 0x3F, 0x3F, 0xE8, 0xF4, 0xD3, 0xFD, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0xE2, 0xA4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xCA, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0xDA, 0xE6, 0xF7, 0xB3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xCD, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xB6, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0xEE, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0xF5, 0xC4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0xD8, 0xA4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xA7, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0xD9, 0xB8, 0xD9, 0xB9, 0xEF, 0xC9, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0xD6, 0xCE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0xF7, 0xCB, 0xDF, 0xAE, 0xE8, 0xF5, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD2, 0xB5, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xD5, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0xF4, 0xCC, 0xDA, 0xFC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xE8, /* 0xA8-0xAB */
	0x3F, 0x3F, 0xF7, 0xEB, 0xF5, 0xC9, 0x3F, 0x3F, /* 0xAC-0xAF */
	0xF3, 0xBC, 0x3F, 0x3F, 0xDA, 0xD2, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xB5, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0xE8, 0xB6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xD6, 0xCF, 0xF4, 0xBA, 0x3F, 0x3F, 0xF7, 0xC9, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xAA, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0xF0, 0xC3, 0xCC, 0xD6, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xD3, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0xD3, 0xBD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0xDB, 0xFB, 0x3F, 0x3F, 0xCB, 0xE0, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xD3, 0xE4, 0xF6, 0xF7, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0xD5, 0xBA, 0xF3, 0xCD, 0xCB, 0xE1, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0xEB, 0xF4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xAD, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0xFC, 0xAA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF7, 0xEC, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xF6, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_65[512] = {
	0xDA, 0xE7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0xF7, 0xCC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0xE5, 0xC1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0xE0, 0xEE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xFD, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xE6, 0xFC, 0xAB, /* 0x28-0x2B */
	0xD5, 0xBB, 0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xA8, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xA5, 0xCD, 0xB9, /* 0x34-0x37 */
	0xEA, 0xF2, 0xCB, 0xC7, 0x3F, 0x3F, 0xCD, 0xF4, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xAF, 0xEF, 0xD9, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0xCD, 0xBA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0xFC, 0xF9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0xDF, 0xF3, 0xCE, 0xE7, 0xDA, 0xC2, /* 0x4C-0x4F */
	0x3F, 0x3F, 0xCF, 0xAD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xF9, 0xF8, 0xA8, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xE2, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xF2, 0xDF, 0xA4, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xC4, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0xCC, 0xD7, 0xE5, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xBB, 0x3F, 0x3F, /* 0x70-0x73 */
	0xEF, 0xDA, 0xEE, 0xD8, 0x3F, 0x3F, 0xDD, 0xA7, /* 0x74-0x77 */
	0xE2, 0xA6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xC0, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xB0, 0xF8, 0xCA, /* 0x80-0x83 */
	0x3F, 0x3F, 0xFC, 0xFA, 0x3F, 0x3F, 0xD9, 0xFE, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0xDE, 0xB0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0xDD, 0xEC, 0xDA, 0xE8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xE0, /* 0x94-0x97 */
	0x3F, 0x3F, 0xD6, 0xF9, 0x3F, 0x3F, 0xCD, 0xD7, /* 0x98-0x9B */
	0xDE, 0xD8, 0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xF8, /* 0x9C-0x9F */
	0x3F, 0x3F, 0xE4, 0xD6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0xD0, 0xC5, 0xF4, 0xAE, 0x3F, 0x3F, 0xDD, 0xA8, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xC5, /* 0xA8-0xAB */
	0xF3, 0xD6, 0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xD9, /* 0xAC-0xAF */
	0xE3, 0xE6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xA8, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0xDB, 0xB0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0xE5, 0xDA, 0xE3, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0xDB, 0xB1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0xD5, 0xE9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xC1, /* 0xC8-0xCB */
	0xEF, 0xDB, 0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xE9, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xB2, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xFD, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0xD9, 0xE9, 0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xFE, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0xEC, 0xED, 0xD3, 0xA9, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0xF2, 0xA9, 0xF0, 0xC4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0xE2, 0xE2, 0xE9, 0xEF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0xF9, 0xD1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0xE9, 0xD9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xDA, 0xDA, 0xC3, /* 0xF8-0xFB */
	0xDA, 0xC4, 0xD4, 0xC5, 0x3F, 0x3F, 0xE7, 0xFA, /* 0xFC-0xFF */
};

static unsigned char u2c_66[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xE0, 0xE3, 0xB0, /* 0x04-0x07 */
	0x3F, 0x3F, 0xDB, 0xB2, 0xFB, 0xC4, 0x3F, 0x3F, /* 0x08-0x0B */
	0xF3, 0xE3, 0x3F, 0x3F, 0xD9, 0xA5, 0xFB, 0xE7, /* 0x0C-0x0F */
	0xDD, 0xCB, 0xD0, 0xD4, 0x3F, 0x3F, 0xE6, 0xB6, /* 0x10-0x13 */
	0xE0, 0xAE, 0xFD, 0xDA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xB5, 0xE0, 0xF8, /* 0x1C-0x1F */
	0xE7, 0xB1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0xF5, 0xF0, 0x3F, 0x3F, 0xD8, 0xDC, /* 0x24-0x27 */
	0xED, 0xC6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0xE1, 0xB9, 0x3F, 0x3F, 0xE3, 0xC0, /* 0x2C-0x2F */
	0xF9, 0xC0, 0xE9, 0xF0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0xD9, 0xDB, 0x3F, 0x3F, 0xF3, 0xE4, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xB6, 0xE4, 0xE9, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0xF0, 0xC5, 0xE3, 0xC1, 0xFC, 0xCC, /* 0x40-0x43 */
	0xFC, 0xCD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0xF2, 0xCB, 0x3F, 0x3F, 0xF2, 0xCC, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xCF, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0xF1, 0xDB, 0x3F, 0x3F, 0xFA, 0xD9, /* 0x58-0x5B */
	0x3F, 0x3F, 0xF1, 0xB8, 0xFD, 0xF5, 0xE0, 0xF9, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0xE7, 0xFB, 0xFC, 0xB7, 0xFC, 0xE4, 0xFB, 0xC5, /* 0x64-0x67 */
	0xE3, 0xE7, 0xD8, 0xB9, 0x3F, 0x3F, 0xF6, 0xF8, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xC5, 0xCC, 0xD8, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xAF, /* 0x70-0x73 */
	0xF4, 0xE7, 0x3F, 0x3F, 0xEF, 0xDC, 0xCF, 0xFC, /* 0x74-0x77 */
	0xEF, 0xDD, 0x3F, 0x3F, 0xF2, 0xAA, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0xFD, 0xBE, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xAC, /* 0x84-0x87 */
	0xFD, 0xBB, 0xFD, 0xC7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xB2, 0x3F, 0x3F, /* 0x8C-0x8F */
	0xEA, 0xD1, 0xDF, 0xF4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xEC, 0xE4, 0xDE, /* 0x94-0x97 */
	0xE5, 0xC3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0xD9, 0xA6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0xCD, 0xBC, 0x3F, 0x3F, 0xF3, 0xE5, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xD5, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xBA, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xE7, 0xFB, 0xB5, /* 0xB0-0xB3 */
	0xF8, 0xEC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0xE0, 0xE7, 0x3F, 0x3F, 0xCC, 0xD9, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xC6, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xE7, 0xA5, 0x3F, 0x3F, 0xD5, 0xF5, 0xD3, 0xBE, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xFC, 0xFB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xF2, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0xDF, 0xF5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0xE8, 0xF8, 0xF8, 0xED, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0xCE, 0xC7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xF6, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0xE8, 0xD8, 0x3F, 0x3F, 0xCD, 0xD8, 0xE7, 0xD6, /* 0xF0-0xF3 */
	0xCC, 0xDA, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xE3, /* 0xF4-0xF7 */
	0xDF, 0xF6, 0xF0, 0xC7, 0xF0, 0xC6, 0x3F, 0x3F, /* 0xF8-0xFB */
	0xD8, 0xBA, 0x3F, 0x3F, 0xF1, 0xF4, 0xF4, 0xF0, /* 0xFC-0xFF */
};

static unsigned char u2c_67[512] = {
	0xF5, 0xCC, 0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xE5, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0xEA, 0xC5, 0xEA, 0xF3, 0x3F, 0x3F, 0xDD, 0xDB, /* 0x08-0x0B */
	0x3F, 0x3F, 0xDC, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0xDE, 0xFD, 0xF2, 0xF9, 0x3F, 0x3F, 0xD5, 0xC7, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xD0, /* 0x18-0x1B */
	0x3F, 0x3F, 0xF0, 0xC8, 0xD1, 0xA1, 0xD1, 0xA2, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xD4, 0xD6, 0xE8, /* 0x24-0x27 */
	0xD9, 0xCA, 0x3F, 0x3F, 0xDA, 0xB1, 0xD8, 0xC7, /* 0x28-0x2B */
	0xDC, 0xE2, 0xF3, 0xCE, 0xF5, 0xF4, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0xF1, 0xB9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0xDA, 0xD3, 0x3F, 0x3F, 0xF6, 0xEA, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xF5, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0xFD, 0xAE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xD2, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0xDF, 0xB4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xDD, 0xFA, 0xBA, /* 0x4C-0x4F */
	0xEE, 0xA7, 0xF5, 0xBD, 0x3F, 0x3F, 0xF8, 0xF5, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xE8, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0xD4, 0xE1, 0x3F, 0x3F, 0xD1, 0xA3, 0xE1, 0xD6, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0xF9, 0xF8, 0x3F, 0x3F, 0xDB, 0xCA, /* 0x6C-0x6F */
	0xCB, 0xF9, 0xD4, 0xD4, 0x3F, 0x3F, 0xD9, 0xDC, /* 0x70-0x73 */
	0x3F, 0x3F, 0xEE, 0xBE, 0x3F, 0x3F, 0xF7, 0xED, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD2, 0xEE, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xE6, 0xF7, 0xF9, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xED, /* 0x84-0x87 */
	0x3F, 0x3F, 0xE8, 0xDB, 0x3F, 0x3F, 0xDB, 0xB3, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xF7, /* 0x8C-0x8F */
	0xE0, 0xB0, 0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xE2, /* 0x90-0x93 */
	0x3F, 0x3F, 0xF6, 0xD7, 0x3F, 0x3F, 0xD7, 0xF9, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xDD, 0x3F, 0x3F, /* 0x98-0x9B */
	0xCD, 0xFD, 0xF2, 0xAB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xBD, /* 0xAC-0xAF */
	0xF8, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xAC, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xAD, 0xCA, 0xAE, /* 0xB4-0xB7 */
	0xCF, 0xAE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xC2, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xDC, 0xB7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xDA, /* 0xCC-0xCF */
	0xD9, 0xBB, 0xCA, 0xF3, 0xF6, 0xD3, 0xE6, 0xF8, /* 0xD0-0xD3 */
	0xEA, 0xF5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xF6, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0xF6, 0xF9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0xCF, 0xAF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0xCA, 0xD3, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xAF, /* 0xEC-0xEF */
	0xD2, 0xB0, 0xF1, 0xBA, 0x3F, 0x3F, 0xD7, 0xB3, /* 0xF0-0xF3 */
	0xE3, 0xC3, 0xF3, 0xFD, 0xDE, 0xDA, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xDB, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xDE, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_68[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xE3, 0xEE, 0xFB, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xF7, 0xD7, 0xCA, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0xCE, 0xE8, 0xDB, 0xDB, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xBB, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xF1, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0xFA, 0xB7, 0xD0, 0xC6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0xCC, 0xAB, 0xEE, 0xA8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0xCB, 0xFA, 0xF9, 0xF9, 0xCC, 0xFD, 0xD3, 0xFE, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0xE4, 0xD0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xEE, 0x3F, 0x3F, /* 0x4C-0x4F */
	0xD4, 0xD5, 0xDF, 0xCD, 0x3F, 0x3F, 0xFC, 0xB8, /* 0x50-0x53 */
	0xD1, 0xD0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0xF2, 0xCD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF7, 0xD2, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xD4, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0xD5, 0xD9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0xD8, 0xDE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xD9, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xA9, /* 0x90-0x93 */
	0xF6, 0xBC, 0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xDB, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0xF0, 0xC9, 0x3F, 0x3F, 0xFC, 0xFC, /* 0x9C-0x9F */
	0x3F, 0x3F, 0xE8, 0xC9, 0xF4, 0xFE, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xFC, /* 0xA4-0xA7 */
	0xD7, 0xDE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0xDE, 0xDC, 0x3F, 0x3F, 0xF0, 0xAC, /* 0xAC-0xAF */
	0xCC, 0xFE, 0xCD, 0xE1, 0x3F, 0x3F, 0xE1, 0xBA, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0xDB, 0xEF, 0xDA, 0xB2, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xD1, 0xA5, 0xDC, 0xB8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xD8, 0xF6, 0x3F, 0x3F, 0xD1, 0xA4, /* 0xC8-0xCB */
	0x3F, 0x3F, 0xCD, 0xE2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xEA, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0xF0, 0xF7, 0x3F, 0x3F, 0xF0, 0xCA, /* 0xD4-0xD7 */
	0xD0, 0xBE, 0x3F, 0x3F, 0xDD, 0xDC, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xD6, /* 0xDC-0xDF */
	0xD3, 0xD6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xD0, /* 0xE4-0xE7 */
	0xCD, 0xA1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xB5, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xF8, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0xD4, 0xA1, 0xCE, 0xB2, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_69[512] = {
	0xE8, 0xCA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0xEB, 0xF5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0xE3, 0xD5, 0xF5, 0xD0, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xA1, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xA7, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0xE5, 0xAB, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0xE6, 0xCB, 0x3F, 0x3F, 0xF5, 0xF1, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xC5, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xA3, /* 0x50-0x53 */
	0xE0, 0xDB, 0xF6, 0xEB, 0x3F, 0x3F, 0xCB, 0xF1, /* 0x54-0x57 */
	0x3F, 0x3F, 0xD9, 0xEA, 0xF5, 0xA2, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xD1, 0x3F, 0x3F, /* 0x5C-0x5F */
	0xD1, 0xF8, 0xEA, 0xF8, 0xEA, 0xF9, 0xDA, 0xB3, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0xEF, 0xDF, 0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xEF, /* 0x68-0x6B */
	0x3F, 0x3F, 0xE5, 0xF6, 0xEE, 0xBF, 0xE2, 0xE4, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0xD0, 0xBF, 0x3F, 0x3F, 0xFA, 0xAC, /* 0x74-0x77 */
	0xF5, 0xD1, 0xE7, 0xB3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0xE9, 0xBE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xCE, /* 0x98-0x9B */
	0xDB, 0xB4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0xFC, 0xCE, 0x3F, 0x3F, 0xDD, 0xEE, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xB4, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0xD7, 0xB4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF7, 0xB4, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0xCD, 0xBE, 0x3F, 0x3F, 0xDA, 0xE9, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xB0, /* 0xC8-0xCB */
	0xF7, 0xD9, 0xF3, 0xE6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0xCE, 0xD9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0xCE, 0xAA, 0x3F, 0x3F, 0xCB, 0xC8, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xA7, /* 0xF8-0xFB */
	0x3F, 0x3F, 0xF0, 0xCB, 0x3F, 0x3F, 0xD0, 0xC7, /* 0xFC-0xFF */
};

static unsigned char u2c_6A[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xC5, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xE0, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xD5, 0xDA, 0x3F, 0x3F, 0xD7, 0xA7, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xC0, /* 0x14-0x17 */
	0x3F, 0x3F, 0xF8, 0xF6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xD2, 0xED, 0xE9, /* 0x1C-0x1F */
	0x3F, 0x3F, 0xD9, 0xBC, 0x3F, 0x3F, 0xE5, 0xC6, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0xF5, 0xA3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0xDA, 0xD4, 0xE2, 0xA7, 0xFB, 0xFC, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0xF1, 0xDC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0xCA, 0xF4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0xE8, 0xFA, 0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xE9, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xF8, 0xE2, 0xE5, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0xD0, 0xB9, 0xD4, 0xF2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xA6, /* 0x5C-0x5F */
	0x3F, 0x3F, 0xDF, 0xCE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xF4, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0xD3, 0xAA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0xCC, 0xAC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0xEF, 0xE0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0xE5, 0xE5, 0xD0, 0xD5, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xFC, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0xFC, 0xE6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xFE, 0xED, 0xEA, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xB1, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xE3, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xA2, 0xCF, 0xF6, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xD0, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xEA, 0xF1, 0xEE, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xCB, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xA1, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_6B[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0xD5, 0xB1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xED, 0x3F, 0x3F, /* 0x08-0x0B */
	0xED, 0xEB, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xB2, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xBC, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0xFD, 0xE2, 0xF3, 0xAD, 0x3F, 0x3F, 0xFD, 0xDB, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xB0, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xA7, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0xFD, 0xE3, 0xCE, 0xB3, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xE4, 0xFA, 0xCE, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0xCA, 0xB0, 0x3F, 0x3F, 0xF7, 0xA7, 0x3F, 0x3F, /* 0x4C-0x4F */
	0xCF, 0xB1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE6, 0xA2, /* 0x5C-0x5F */
	0x3F, 0x3F, 0xFC, 0xB6, 0xF2, 0xAD, 0xEF, 0xE1, /* 0x60-0x63 */
	0xF3, 0xAE, 0xDC, 0xC6, 0xD9, 0xEB, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xE0, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xA8, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xF6, /* 0x74-0x77 */
	0xCF, 0xFD, 0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xDD, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xD1, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xEA, /* 0x80-0x83 */
	0xF2, 0xCF, 0x3F, 0x3F, 0xF7, 0xBF, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0xE2, 0xE6, 0xE2, 0xA8, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xD6, 0x3F, 0x3F, /* 0x94-0x97 */
	0xED, 0xD1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xF9, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xB1, 0xDE, 0xB2, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xE8, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0xD3, 0xAB, 0x3F, 0x3F, 0xEB, 0xDC, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xAF, 0x3F, 0x3F, /* 0xB8-0xBB */
	0xCA, 0xC3, 0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xFC, /* 0xBC-0xBF */
	0x3F, 0x3F, 0xFD, 0xC3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0xEB, 0xF6, 0xCF, 0xB2, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xEC, /* 0xC8-0xCB */
	0x3F, 0x3F, 0xD9, 0xBD, 0x3F, 0x3F, 0xD8, 0xDF, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xB8, 0xEB, 0xBE, /* 0xD0-0xD3 */
	0xDD, 0xEF, 0x3F, 0x3F, 0xDD, 0xF0, 0xDD, 0xF1, /* 0xD4-0xD7 */
	0xDD, 0xF2, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xBE, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xC6, /* 0xE8-0xEB */
	0xCF, 0xB3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_6C[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0xEE, 0xFD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xAB, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xDA, 0xC5, 0x3F, 0x3F, 0xD8, 0xEC, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xA8, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0xE2, 0xA9, 0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xBC, /* 0x34-0x37 */
	0xE7, 0xB5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xF0, 0x3F, 0x3F, /* 0x3C-0x3F */
	0xEF, 0xE2, 0xF1, 0xF0, 0xCF, 0xB4, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xF1, 0x3F, 0x3F, /* 0x4C-0x4F */
	0xE0, 0xB1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0xDF, 0xA5, 0x3F, 0x3F, 0xF9, 0xD2, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xFD, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0xE6, 0xA3, 0xFB, 0xF1, 0xCB, 0xB0, /* 0x5C-0x5F */
	0xF2, 0xAE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0xCD, 0xE7, 0x3F, 0x3F, 0xE8, 0xDC, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0xE7, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0xF7, 0xC0, 0x3F, 0x3F, 0xD0, 0xE3, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDA, 0xA1, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xBD, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0xD1, 0xA9, 0xDD, 0xCC, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0xE3, 0xFE, 0xD1, 0xAA, 0xE8, 0xAA, /* 0x80-0x83 */
	0x3F, 0x3F, 0xEA, 0xB6, 0xF9, 0xFA, 0xE6, 0xCC, /* 0x84-0x87 */
	0xF6, 0xD8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0xD4, 0xC7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0xD9, 0xCB, 0x3F, 0x3F, 0xD9, 0xD2, 0xD3, 0xCB, /* 0x90-0x93 */
	0xD8, 0xF7, 0xDA, 0xA9, 0xF5, 0xF8, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0xDE, 0xDE, 0xF2, 0xAF, 0xF8, 0xA9, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xC8, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xC1, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xC1, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0xDD, 0xF3, 0xEA, 0xFA, 0x3F, 0x3F, 0xF6, 0xBD, /* 0xB8-0xBB */
	0xE1, 0xBB, 0xCD, 0xBF, 0xF4, 0xD4, 0xE6, 0xCD, /* 0xBC-0xBF */
	0x3F, 0x3F, 0xFC, 0xCF, 0xFB, 0xA2, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xE0, 0xDC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xF4, 0xBB, 0xDA, 0xD5, 0x3F, 0x3F, /* 0xC8-0xCB */
	0xF9, 0xB2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xF2, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0xDB, 0xF6, 0x3F, 0x3F, 0xDE, 0xDF, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xF2, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xF8, 0xDC, 0xF7, 0xEE, 0xEB, 0xE8, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0xD2, 0xFA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0xF1, 0xBC, 0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xDA, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDA, 0xEA, 0xDA, 0xC6, /* 0xEC-0xEF */
	0xF7, 0xC1, 0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xB6, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_6D[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xC7, /* 0x08-0x0B */
	0xD6, 0xAC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xDC, 0xC7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xA9, /* 0x14-0x17 */
	0x3F, 0x3F, 0xE2, 0xAA, 0x3F, 0x3F, 0xD5, 0xA6, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xD7, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0xF2, 0xD0, 0x3F, 0x3F, 0xEA, 0xFB, /* 0x24-0x27 */
	0x3F, 0x3F, 0xE0, 0xDD, 0xFB, 0xF3, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xBD, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0xE2, 0xE7, 0xFD, 0xD7, 0x3F, 0x3F, /* 0x34-0x37 */
	0xCE, 0xC8, 0xEA, 0xB7, 0x3F, 0x3F, 0xFC, 0xC0, /* 0x38-0x3B */
	0x3F, 0x3F, 0xFD, 0xE7, 0xF7, 0xEF, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0xD7, 0xB5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0xEF, 0xBA, 0xF1, 0xDD, 0x3F, 0x3F, /* 0x58-0x5B */
	0xDE, 0xB3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xCB, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xDD, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0xFB, 0xC7, 0xD5, 0xC8, 0x3F, 0x3F, /* 0x68-0x6B */
	0xD7, 0xDF, 0x3F, 0x3F, 0xDD, 0xA9, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0xE9, 0xB1, 0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xAD, /* 0x74-0x77 */
	0xF6, 0xD9, 0xFA, 0xF4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xAA, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0xE6, 0xEE, 0x3F, 0x3F, 0xCC, 0xDC, /* 0x84-0x87 */
	0xE1, 0xBC, 0xE0, 0xEF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0xE9, 0xBF, 0xFC, 0xFD, 0xE6, 0xCE, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0xE1, 0xD7, 0x3F, 0x3F, 0xE6, 0xCF, /* 0x90-0x93 */
	0x3F, 0x3F, 0xF4, 0xF1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xF3, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xFB, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0xF9, 0xE4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0xEF, 0xE3, 0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xEE, /* 0xC0-0xC3 */
	0xF6, 0xBE, 0xE0, 0xB2, 0xFC, 0xFE, 0xD1, 0xAB, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xFA, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xC8, /* 0xCC-0xCF */
	0x3F, 0x3F, 0xE2, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0xD4, 0xA3, 0xF0, 0xF8, 0xD7, 0xA8, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xE7, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xD3, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0xEF, 0xE4, 0x3F, 0x3F, 0xD7, 0xC5, 0xEB, 0xE2, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xE7, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0xE4, 0xA2, 0x3F, 0x3F, 0xE2, 0xE8, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0xE6, 0xD0, 0x3F, 0x3F, 0xFB, 0xE8, /* 0xF4-0xF7 */
	0xF4, 0xE8, 0xE5, 0xF4, 0xF4, 0xBC, 0xF4, 0xD5, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_6E[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xB6, /* 0x14-0x17 */
	0x3F, 0x3F, 0xFC, 0xB9, 0xEE, 0xC2, 0xCA, 0xF5, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xE5, /* 0x1C-0x1F */
	0xCB, 0xE2, 0xD4, 0xA4, 0x3F, 0x3F, 0xDE, 0xE0, /* 0x20-0x23 */
	0xDA, 0xFD, 0xE4, 0xC6, 0xE8, 0xBE, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xDE, /* 0x28-0x2B */
	0xF6, 0xB4, 0xEA, 0xD2, 0x3F, 0x3F, 0xF9, 0xFB, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xC2, 0x3F, 0x3F, /* 0x30-0x33 */
	0xCA, 0xE4, 0x3F, 0x3F, 0xE7, 0xB7, 0x3F, 0x3F, /* 0x34-0x37 */
	0xEA, 0xFD, 0x3F, 0x3F, 0xD9, 0xDD, 0x3F, 0x3F, /* 0x38-0x3B */
	0xDA, 0xB4, 0xEE, 0xAA, 0xFB, 0xE9, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xCB, /* 0x40-0x43 */
	0xDA, 0xB5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xBE, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0xD3, 0xAC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xC9, 0x3F, 0x3F, /* 0x54-0x57 */
	0xDF, 0xCF, 0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xC0, /* 0x58-0x5B */
	0xE3, 0xD7, 0x3F, 0x3F, 0xEF, 0xE6, 0xFC, 0xD0, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xC0, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xD3, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xDC, 0xF7, 0xB7, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xB8, 0xD1, 0xF9, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xC8, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0xEA, 0xB9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xDE, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0xD7, 0xB6, 0xCF, 0xB5, 0x3F, 0x3F, 0xD9, 0xA8, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xEE, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0xDD, 0xAA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xA2, 0xE8, 0xAE, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xBD, /* 0xAC-0xAF */
	0x3F, 0x3F, 0xF2, 0xD1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xC1, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD2, 0xFC, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xB5, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xF3, 0xE7, 0xD8, 0xFE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xFC, 0xD1, 0x3F, 0x3F, 0xED, 0xB2, /* 0xC8-0xCB */
	0xF4, 0xAF, 0x3F, 0x3F, 0xFB, 0xA3, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0xFC, 0xC1, 0x3F, 0x3F, 0xEE, 0xAB, /* 0xD0-0xD3 */
	0xD4, 0xA5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xF2, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0xEE, 0xD9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0xFB, 0xCA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xE3, 0xD8, 0xBB, /* 0xFC-0xFF */
};

static unsigned char u2c_6F[512] = {
	0x3F, 0x3F, 0xE5, 0xDB, 0xF8, 0xF7, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xD4, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xA9, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xCB, 0xC9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0xE6, 0xD1, 0xF0, 0xCC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0xD8, 0xAE, 0x3F, 0x3F, 0xF9, 0xD3, 0xD5, 0xFE, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xBC, /* 0x28-0x2B */
	0xF2, 0xB0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0xE2, 0xAB, 0xF3, 0xE8, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0xEF, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xEC, /* 0x3C-0x3F */
	0x3F, 0x3F, 0xE7, 0xB8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0xDA, 0xFE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0xCC, 0xBE, 0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xFC, /* 0x54-0x57 */
	0xDA, 0xEB, 0x3F, 0x3F, 0xE2, 0xD8, 0xED, 0xD6, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xD1, 0xE0, 0xB3, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xD2, 0x3F, 0x3F, /* 0x60-0x63 */
	0xEB, 0xC8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0xD3, 0xC1, 0xF0, 0xCD, 0x3F, 0x3F, /* 0x6C-0x6F */
	0xCF, 0xF7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xD2, 0x3F, 0x3F, /* 0x78-0x7B */
	0xD4, 0xD8, 0xDC, 0xC9, 0xD7, 0xF1, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0xDF, 0xBB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0xF3, 0xA5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0xF4, 0xCD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0xF1, 0xBF, 0xF8, 0xB1, 0x3F, 0x3F, /* 0x8C-0x8F */
	0xE9, 0xFA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0xFB, 0xCB, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xD5, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xD4, /* 0xA0-0xA3 */
	0xF7, 0xCA, 0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xC8, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xE8, 0xF3, 0xBD, /* 0xAC-0xAF */
	0x3F, 0x3F, 0xEE, 0xFE, 0x3F, 0x3F, 0xE7, 0xFE, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0xD3, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xB6, 0x3F, 0x3F, /* 0xBC-0xBF */
	0xCC, 0xAD, 0xF6, 0xFA, 0xD6, 0xB2, 0xD2, 0xD8, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xD8, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0xE3, 0xA5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xB9, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xAD, /* 0xDC-0xDF */
	0xFB, 0xCC, 0xEB, 0xA1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0xD4, 0xA6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0xFB, 0xCD, 0x3F, 0x3F, 0xD5, 0xBD, /* 0xE8-0xEB */
	0xF1, 0xDF, 0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xFB, /* 0xEC-0xEF */
	0x3F, 0x3F, 0xDE, 0xB4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xEB, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_70[512] = {
	0x3F, 0x3F, 0xE5, 0xC8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0xFB, 0xA4, 0xD4, 0xB9, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0xDE, 0xE1, 0x3F, 0x3F, 0xE4, 0xA3, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xB7, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xF8, 0xEE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0xDE, 0xB5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0xD6, 0xD2, 0x3F, 0x3F, 0xF9, 0xD5, 0xE7, 0xBA, /* 0x18-0x1B */
	0xEB, 0xD5, 0xD5, 0xF7, 0xEF, 0xE7, 0xE1, 0xBE, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xAE, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xE9, /* 0x24-0x27 */
	0xD6, 0xEE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xBB, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xCB, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xB3, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0xCE, 0xB4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0xFB, 0xA5, 0xE1, 0xEE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0xF7, 0xA8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0xFB, 0xCE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xBD, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xFD, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0xFC, 0xE9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0xCF, 0xB6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0xED, 0xC7, 0xEE, 0xAC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0xCC, 0xDD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xA7, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE6, 0xFA, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xA4, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0xFD, 0xDC, 0xED, 0xB3, 0xCE, 0xC9, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0xEF, 0xE8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0xE1, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xDB, /* 0xA8-0xAB */
	0xCB, 0xE3, 0xF7, 0xA9, 0x3F, 0x3F, 0xFB, 0xA6, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xB9, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xC0, /* 0xB4-0xB7 */
	0xED, 0xC8, 0xEF, 0xC3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0xD6, 0xAD, 0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xCE, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xA1, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0xFB, 0xF4, 0xD5, 0xA7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0xF1, 0xF6, 0x3F, 0x3F, 0xE6, 0xD3, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0xCC, 0xDE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0xF8, 0xB2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0xDC, 0xEB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_71[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0xFD, 0xB6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0xE5, 0xEA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0xF1, 0xE0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0xDB, 0xCC, 0xDD, 0xCD, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xC8, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0xD9, 0xED, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xA5, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0xE6, 0xFB, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE6, 0xD4, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xC8, /* 0x44-0x47 */
	0x3F, 0x3F, 0xD6, 0xA1, 0xFD, 0xBF, 0x3F, 0x3F, /* 0x48-0x4B */
	0xFC, 0xD3, 0x3F, 0x3F, 0xEF, 0xA1, 0x3F, 0x3F, /* 0x4C-0x4F */
	0xE7, 0xBC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xEE, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0xE6, 0xD5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0xE9, 0xF2, 0x3F, 0x3F, 0xDF, 0xB0, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0xD8, 0xE0, 0xFC, 0xBA, 0xFD, 0xAF, 0xF0, 0xCE, /* 0x64-0x67 */
	0x3F, 0x3F, 0xDB, 0xE1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0xE5, 0xC9, 0x3F, 0x3F, 0xED, 0xB4, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0xE0, 0xC3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0xE3, 0xD8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0xE9, 0xFB, 0xEA, 0xA8, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xB7, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xA7, 0x3F, 0x3F, /* 0x90-0x93 */
	0xE9, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0xFD, 0xF7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xD9, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xEC, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0xE8, 0xA2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0xE6, 0xF0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0xFD, 0xF8, 0xFD, 0xF9, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xBF, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0xE7, 0xA7, 0x3F, 0x3F, 0xE6, 0xD7, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0xD4, 0xF3, 0xD4, 0xC9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xFA, 0x3F, 0x3F, /* 0xCC-0xCF */
	0xD7, 0xF2, 0x3F, 0x3F, 0xE1, 0xC0, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0xDB, 0xE2, 0xE6, 0xD8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xBD, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0xF0, 0xCF, 0xF3, 0xBE, 0xE2, 0xAC, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0xF5, 0xB7, 0xE0, 0xF0, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xB8, /* 0xF8-0xFB */
	0xE3, 0xE8, 0x3F, 0x3F, 0xD4, 0xA7, 0xE8, 0xFC, /* 0xFC-0xFF */
};

static unsigned char u2c_72[512] = {
	0xFA, 0xD2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xEF, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0xD6, 0xD3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xB4, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xD0, 0x3F, 0x3F, /* 0x28-0x2B */
	0xF7, 0xF0, 0xEE, 0xB3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0xEA, 0xBA, 0x3F, 0x3F, 0xEA, 0xD3, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0xED, 0xC9, 0xDD, 0xAB, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xAC, 0xFD, 0xA1, /* 0x38-0x3B */
	0x3F, 0x3F, 0xDF, 0xD0, 0xEC, 0xB3, 0x3F, 0x3F, /* 0x3C-0x3F */
	0xDF, 0xD1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xED, 0xF8, 0xB8, /* 0x44-0x47 */
	0xF7, 0xFA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0xF8, 0xAB, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xE0, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0xD4, 0xBA, 0xE4, 0xB3, 0x3F, 0x3F, 0xE9, 0xDA, /* 0x58-0x5B */
	0x3F, 0x3F, 0xDE, 0xB6, 0x3F, 0x3F, 0xD9, 0xBF, /* 0x5C-0x5F */
	0x3F, 0x3F, 0xD9, 0xC0, 0xD6, 0xEF, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xCC, /* 0x64-0x67 */
	0x3F, 0x3F, 0xDA, 0xAA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xE5, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0xF7, 0xE5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0xCC, 0xB2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0xDF, 0xF9, 0xD7, 0xE0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xBB, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xFA, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0xCC, 0xB3, 0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xF3, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0xDF, 0xD2, 0x3F, 0x3F, 0xCE, 0xCA, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xEE, 0xDA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xE4, 0x3F, 0x3F, /* 0xCC-0xCF */
	0xFB, 0xCF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xB7, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0xEE, 0xC3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xCE, 0xEA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0xE2, 0xAD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0xD7, 0xE1, 0xFA, 0xF5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0xD5, 0xC9, 0xF8, 0xAC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_73[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xD9, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xE9, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xED, /* 0x18-0x1B */
	0xE3, 0xC4, 0xF0, 0xF1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0xE8, 0xE5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0xE0, 0xFA, 0xEE, 0xC4, 0xD9, 0xDE, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEB, 0xA2, 0xEB, 0xA3, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xC2, 0xEA, 0xBB, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0xE8, 0xAB, 0xDE, 0xE2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0xED, 0xEF, 0x3F, 0x3F, 0xE8, 0xA3, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xF1, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0xD4, 0xBC, 0x3F, 0x3F, 0xFC, 0xEA, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0xE7, 0xBE, 0x3F, 0x3F, 0xFC, 0xF2, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0xD6, 0xB4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0xE2, 0xAE, 0x3F, 0x3F, 0xD3, 0xB7, 0xFA, 0xCC, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0xFA, 0xDC, 0x3F, 0x3F, 0xED, 0xB5, 0xE1, 0xE3, /* 0x84-0x87 */
	0x3F, 0x3F, 0xE8, 0xAC, 0x3F, 0x3F, 0xE8, 0xDD, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xE9, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0xF4, 0xBD, 0x3F, 0x3F, 0xCF, 0xB8, 0xE9, 0xDB, /* 0x94-0x97 */
	0xD1, 0xAC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDA, 0xC7, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEB, 0xC9, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0xE8, 0xCC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0xDE, 0xB7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xBC, 0xD3, 0xE5, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0xFA, 0xDD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0xDA, 0xD6, 0x3F, 0x3F, 0xCA, 0xB1, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xDA, 0xC8, 0xDF, 0xA6, 0x3F, 0x3F, /* 0xC8-0xCB */
	0xF9, 0xB3, 0xF2, 0xD2, 0x3F, 0x3F, 0xCA, 0xC4, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xCB, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0xCD, 0xF5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0xFD, 0xB0, 0xD5, 0xA8, 0x3F, 0x3F, /* 0xDC-0xDF */
	0xF1, 0xC1, 0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xE9, /* 0xE0-0xE3 */
	0xDC, 0xCA, 0xEC, 0xB4, 0xFA, 0xC0, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0xFB, 0xA8, 0xD0, 0xA8, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0xDA, 0xEC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xEE, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0xE0, 0xFB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0xEF, 0xEA, 0xFA, 0xDE, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_74[512] = {
	0x3F, 0x3F, 0xE0, 0xC4, 0x3F, 0x3F, 0xCF, 0xB9, /* 0x00-0x03 */
	0x3F, 0x3F, 0xD5, 0xCA, 0xD7, 0xE2, 0xE2, 0xAF, /* 0x04-0x07 */
	0x3F, 0x3F, 0xD7, 0xB8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xCD, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xDA, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0xEF, 0xA2, 0xE2, 0xDA, 0xF6, 0xFC, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0xFB, 0xD0, 0xD1, 0xAD, 0x3F, 0x3F, /* 0x24-0x27 */
	0xCD, 0xE4, 0x3F, 0x3F, 0xD1, 0xAE, 0xDC, 0xED, /* 0x28-0x2B */
	0xE8, 0xCE, 0x3F, 0x3F, 0xF0, 0xF9, 0xCE, 0xB5, /* 0x2C-0x2F */
	0xE6, 0xFC, 0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xFB, /* 0x30-0x33 */
	0xD0, 0xD6, 0xDD, 0xF5, 0xF7, 0xF1, 0x3F, 0x3F, /* 0x34-0x37 */
	0xF6, 0xFD, 0x3F, 0x3F, 0xDB, 0xF7, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xEA, /* 0x3C-0x3F */
	0xE9, 0xDC, 0xD9, 0xC1, 0x3F, 0x3F, 0xF5, 0xF2, /* 0x40-0x43 */
	0xE0, 0xC5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xD4, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0xF9, 0xC2, 0x3F, 0x3F, 0xEA, 0xBC, /* 0x54-0x57 */
	0x3F, 0x3F, 0xD2, 0xC5, 0xFB, 0xD1, 0xE7, 0xC0, /* 0x58-0x5B */
	0xEB, 0xA5, 0x3F, 0x3F, 0xDF, 0xFA, 0xE3, 0xA2, /* 0x5C-0x5F */
	0xD7, 0xB9, 0x3F, 0x3F, 0xE9, 0xC3, 0x3F, 0x3F, /* 0x60-0x63 */
	0xE8, 0xFD, 0xE8, 0xAF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0xF2, 0xD3, 0xFB, 0xA9, 0xD8, 0xA5, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xCB, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xC8, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xAF, 0xD7, 0xE3, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xC6, /* 0x84-0x87 */
	0x3F, 0x3F, 0xD6, 0xA2, 0x3F, 0x3F, 0xED, 0xF0, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0xD7, 0xF3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0xFC, 0xD4, 0x3F, 0x3F, 0xDA, 0xD7, 0xCC, 0xDF, /* 0x9C-0x9F */
	0x3F, 0x3F, 0xF2, 0xD4, 0x3F, 0x3F, 0xD1, 0xB0, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0xCC, 0xE0, 0x3F, 0x3F, 0xDB, 0xFD, /* 0xA4-0xA7 */
	0xF3, 0xBF, 0x3F, 0x3F, 0xF0, 0xD1, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0xFC, 0xBB, 0x3F, 0x3F, 0xE2, 0xB0, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0xE6, 0xA5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0xE2, 0xDB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0xDF, 0xDE, 0x3F, 0x3F, 0xE0, 0xC7, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xEF, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xE1, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xEA, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0xE7, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0xCE, 0xB6, 0x3F, 0x3F, 0xF3, 0xC0, 0x3F, 0x3F, /* 0xD8-0xDB */
	0xCD, 0xFE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0xFB, 0xD2, 0x3F, 0x3F, 0xF8, 0xF8, 0xF7, 0xFB, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xBF, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xB7, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xB6, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_75[512] = {
	0x3F, 0x3F, 0xDC, 0xBA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0xCC, 0xB4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xF1, 0xF7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0xE8, 0xB8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0xCA, 0xF6, 0x3F, 0x3F, 0xE4, 0xA4, 0xF4, 0xD6, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xE6, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xA7, /* 0x20-0x23 */
	0x3F, 0x3F, 0xDF, 0xE7, 0xE1, 0xC1, 0x3F, 0x3F, /* 0x24-0x27 */
	0xE9, 0xC4, 0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xCB, /* 0x28-0x2B */
	0xE9, 0xC5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0xEF, 0xA3, 0xEB, 0xA6, 0xCB, 0xA3, 0xE3, 0xE9, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xFB, /* 0x34-0x37 */
	0xEF, 0xA4, 0x3F, 0x3F, 0xEF, 0xEB, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xB4, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0xCD, 0xA3, 0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xE6, /* 0x4C-0x4F */
	0x3F, 0x3F, 0xEF, 0xA5, 0x3F, 0x3F, 0xD3, 0xCC, /* 0x50-0x53 */
	0xDA, 0xED, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0xD7, 0xBA, 0x3F, 0x3F, 0xF2, 0xD5, /* 0x58-0x5B */
	0xF5, 0xE5, 0xD9, 0xEF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xB4, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0xD5, 0xD4, 0xFD, 0xCF, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xE3, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xE1, /* 0x6C-0x6F */
	0xEC, 0xB6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0xFB, 0xFE, 0xD3, 0xD7, 0x3F, 0x3F, /* 0x74-0x77 */
	0xD1, 0xB1, 0x3F, 0x3F, 0xCB, 0xB1, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xB2, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xB2, 0xF1, 0xC2, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xE1, 0xF9, 0xB5, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xC3, 0xE1, 0xC2, /* 0x8C-0x8F */
	0x3F, 0x3F, 0xEB, 0xF7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0xDF, 0xA8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0xCB, 0xCA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE6, 0xB9, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0xF8, 0xDE, 0xF9, 0xAA, 0xCA, 0xF7, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0xED, 0xB7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0xD3, 0xB8, 0xF2, 0xD6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0xD4, 0xD9, 0xEE, 0xC5, 0xF2, 0xF0, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xB2, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0xDC, 0xBB, 0x3F, 0x3F, 0xF1, 0xF8, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0xEC, 0xB7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xCA, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0xF6, 0xC0, 0xFD, 0xDD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0xD4, 0xE3, 0xCC, 0xE2, 0x3F, 0x3F, 0xF7, 0xD4, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xE5, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0xD3, 0xC3, 0x3F, 0x3F, 0xD8, 0xA6, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0xF6, 0xC1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xF6, 0x3F, 0x3F, /* 0xF8-0xFB */
	0xCD, 0xC0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_76[512] = {
	0xE5, 0xDC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0xE5, 0xCB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0xE1, 0xC4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xB0, /* 0x1C-0x1F */
	0xF4, 0xB0, 0xF3, 0xEA, 0xDA, 0xEE, 0x3F, 0x3F, /* 0x20-0x23 */
	0xD7, 0xBB, 0x3F, 0x3F, 0xE2, 0xB1, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xAA, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xFB, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0xE4, 0xDF, 0x3F, 0x3F, 0xCA, 0xD6, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEB, 0xA8, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xFE, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0xF6, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0xEF, 0xBB, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0xD4, 0xFD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0xE0, 0xC8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0xE8, 0xB9, 0x3F, 0x3F, 0xEF, 0xA6, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0xCD, 0xA4, 0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xF4, /* 0x78-0x7B */
	0xDB, 0xA1, 0xDB, 0xDC, 0xDB, 0xDD, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0xEE, 0xDC, 0x3F, 0x3F, 0xCB, 0xCB, 0xFC, 0xD5, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xEB, 0x3F, 0x3F, /* 0x8C-0x8F */
	0xCD, 0xC1, 0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xD3, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xAB, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xD4, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xA9, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xDD, 0xDB, 0xCD, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xCE, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0xE7, 0xC3, 0x3F, 0x3F, 0xEC, 0xCC, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xEC, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xCC, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xFC, /* 0xD8-0xDB */
	0xD4, 0xA8, 0x3F, 0x3F, 0xED, 0xD3, 0xD8, 0xEF, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xF2, 0xD7, 0x3F, 0x3F, 0xCA, 0xF8, /* 0xE0-0xE3 */
	0xDA, 0xEF, 0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xD4, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xCD, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xEE, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0xF2, 0xC1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0xDF, 0xD3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0xDA, 0xF0, 0x3F, 0x3F, 0xE2, 0xEA, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_77[512] = {
	0x3F, 0x3F, 0xE0, 0xFD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0xD8, 0xF8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0xF7, 0xAF, 0xDA, 0xB6, 0x3F, 0x3F, 0xCA, 0xD7, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xD8, 0x3F, 0x3F, /* 0x1C-0x1F */
	0xD8, 0xF9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0xFA, 0xDF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xEF, /* 0x34-0x37 */
	0xD9, 0xC2, 0x3F, 0x3F, 0xF0, 0xD2, 0x3F, 0x3F, /* 0x38-0x3B */
	0xE4, 0xD1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0xF3, 0xB7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0xFA, 0xE0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xEC, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0xE2, 0xB2, 0x3F, 0x3F, 0xD4, 0xBD, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xCE, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xE2, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0xD4, 0xA9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xC2, 0xE7, 0xDA, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xD9, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0xD9, 0xAA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xBE, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0xDC, 0xAD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0xE2, 0xEB, 0xD6, 0xFC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0xCA, 0xF9, 0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xDA, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xD7, /* 0xB8-0xBB */
	0xCC, 0xA1, 0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xBA, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xB8, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xC3, /* 0xD8-0xDB */
	0xD0, 0xE8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xC5, 0xEB, 0xF8, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0xF2, 0xB1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0xCF, 0xBB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0xD3, 0xAD, 0xE8, 0xE1, 0xCE, 0xEC, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xB4, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_78[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xE3, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xF7, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0xF2, 0xB2, 0xF3, 0xF6, 0xF6, 0xDB, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0xD7, 0xFE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xDF, 0x3F, 0x3F, /* 0x30-0x33 */
	0xF7, 0xF2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0xD0, 0xA9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE6, 0xDA, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0xF5, 0xA6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xBC, /* 0x68-0x6B */
	0xCC, 0xE3, 0x3F, 0x3F, 0x3F, 0x3F, 0xE6, 0xDB, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0xDD, 0xDD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0xD1, 0xB3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xED, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0xD6, 0xDE, 0xE4, 0xF4, 0xE1, 0xEF, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0xDD, 0xF8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xCF, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xE5, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xA1, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0xE0, 0xB5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xAC, 0xFC, 0xAD, /* 0xB8-0xBB */
	0xD8, 0xA7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0xED, 0xB8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0xDB, 0xB6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xF0, 0xF3, 0xAF, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xA5, 0x3F, 0x3F, /* 0xCC-0xCF */
	0xDA, 0xF1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0xD8, 0xA8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0xCC, 0xE4, 0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xB4, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0xCA, 0xD8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDA, 0xF2, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_79[512] = {
	0x3F, 0x3F, 0xF5, 0xA7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xA8, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE6, 0xA6, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xEC, 0xD5, 0xF8, /* 0x28-0x2B */
	0xDA, 0xF3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xC6, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xE4, 0x3F, 0x3F, /* 0x3C-0x3F */
	0xDE, 0xE5, 0xD1, 0xB5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xB6, /* 0x44-0x47 */
	0xD1, 0xB7, 0xF2, 0xB3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0xE9, 0xDE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xD3, 0xF2, 0xB4, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xD4, 0xCB, 0xE4, /* 0x58-0x5B */
	0xFB, 0xD4, 0xF5, 0xE6, 0xE3, 0xEA, 0x3F, 0x3F, /* 0x5C-0x5F */
	0xDE, 0xE6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0xDF, 0xD4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0xF8, 0xF9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0xF0, 0xAE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xB8, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xDF, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0xD0, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0xFC, 0xA1, 0xEF, 0xEE, 0xDC, 0xD8, /* 0x8C-0x8F */
	0x3F, 0x3F, 0xE9, 0xDF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xDD, 0xFD, 0xFB, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xC9, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xC9, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0xD4, 0xAA, 0x3F, 0x3F, 0xE5, 0xCC, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0xE9, 0xE0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0xD0, 0xD8, 0xFC, 0xA2, 0xD4, 0xBE, /* 0xBC-0xBF */
	0xE2, 0xB3, 0xDE, 0xE7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xDC, 0xBC, 0xD2, 0xB6, 0xF5, 0xD5, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0xCE, 0xA1, 0xF5, 0xA9, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0xDD, 0xF9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0xDD, 0xFA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xD5, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0xF6, 0xDF, 0x3F, 0x3F, 0xF2, 0xDA, 0xE4, 0xEB, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0xF2, 0xF1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xB9, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_7A[512] = {
	0xFD, 0xFC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0xE1, 0xAA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0xCA, 0xD9, 0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xEF, /* 0x08-0x0B */
	0x3F, 0x3F, 0xF5, 0xAA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0xEC, 0xF9, 0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xAD, /* 0x14-0x17 */
	0x3F, 0x3F, 0xF2, 0xC2, 0xF6, 0xC3, 0x3F, 0x3F, /* 0x18-0x1B */
	0xD7, 0xD2, 0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xA2, /* 0x1C-0x1F */
	0xF0, 0xD6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xFA, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0xF6, 0xE0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xF3, 0xF2, 0xC3, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xAB, /* 0x38-0x3B */
	0xCA, 0xB3, 0xCD, 0xA6, 0x3F, 0x3F, 0xCD, 0xC3, /* 0x3C-0x3F */
	0xCD, 0xDA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xCF, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0xF6, 0xC4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0xEE, 0xDD, 0xE7, 0xC4, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xB4, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0xDF, 0xE2, 0xE7, 0xDB, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0xE8, 0xB1, 0x3F, 0x3F, 0xFC, 0xAE, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0xE5, 0xCD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0xFA, 0xEB, 0x3F, 0x3F, 0xCF, 0xBC, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0xCF, 0xE2, 0xCD, 0xF6, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0xEF, 0xF0, 0x3F, 0x3F, 0xF4, 0xBE, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0xD4, 0xCD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0xF3, 0xB8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0xE9, 0xA1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xF2, 0xF3, 0xEB, /* 0x90-0x93 */
	0x3F, 0x3F, 0xF0, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0xCF, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xDF, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0xE8, 0xC0, 0xE8, 0xC1, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xE3, 0xE9, 0xA2, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xAA, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xF3, 0xC1, 0xD0, 0xAB, 0x3F, 0x3F, 0xD4, 0xE4, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xBC, 0xD8, 0xA1, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xDF, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0xF3, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0xDC, 0xBD, 0x3F, 0x3F, 0xCC, 0xE5, /* 0xDC-0xDF */
	0xED, 0xF1, 0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xE2, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0xD4, 0xDB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xB5, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0xCA, 0xE6, 0x3F, 0x3F, 0xD3, 0xAE, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xE6, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0xF1, 0xD3, 0xF5, 0xE7, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xDA, /* 0xFC-0xFF */
};

static unsigned char u2c_7B[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xEE, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xE1, 0xC5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0xDF, 0xE9, 0x3F, 0x3F, 0xEE, 0xDE, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF7, 0xC2, 0x3F, 0x3F, /* 0x1C-0x1F */
	0xD8, 0xA2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xAC, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0xF0, 0xAF, 0xD6, 0xBD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0xE1, 0xAB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xB6, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0xD4, 0xF5, 0x3F, 0x3F, 0xD0, 0xC9, /* 0x48-0x4B */
	0xEF, 0xA7, 0xE2, 0xEC, 0x3F, 0x3F, 0xDB, 0xEA, /* 0x4C-0x4F */
	0xCE, 0xCC, 0xF5, 0xE8, 0xF7, 0xD5, 0x3F, 0x3F, /* 0x50-0x53 */
	0xD3, 0xCD, 0x3F, 0x3F, 0xF3, 0xFE, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0xD0, 0xB5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0xE0, 0xFE, 0x3F, 0x3F, 0xDF, 0xFB, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0xE6, 0xDD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0xE8, 0xA4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xCD, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xA8, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xB4, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0xDA, 0xD8, 0xD1, 0xB9, 0x3F, 0x3F, 0xDF, 0xA9, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xB0, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0xCC, 0xC4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0xCE, 0xB7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0xEF, 0xA9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0xDF, 0xD5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0xED, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0xEE, 0xC6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0xEF, 0xBD, 0xFC, 0xD6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xDB, 0xF4, 0x3F, 0x3F, 0xEF, 0xAA, 0xF8, 0xB9, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xF5, 0xE9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xD9, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0xE1, 0xC6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0xD4, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0xDE, 0xE8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_7C[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xEA, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xC2, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xAF, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0xCA, 0xDB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xD7, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xD8, 0xE1, 0xC7, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0xF4, 0xD8, 0xD6, 0xB3, 0xDD, 0xAD, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xBE, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0xF1, 0xC3, 0xEE, 0xDF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0xD6, 0xEB, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0xF4, 0xD9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0xD7, 0xE6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDA, 0xB7, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xFB, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0xDD, 0xCF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xA3, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0xDA, 0xD9, 0x3F, 0x3F, 0xF0, 0xD8, /* 0x94-0x97 */
	0xEF, 0xC4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xD8, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0xF1, 0xD4, 0x3F, 0x3F, 0xED, 0xF2, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xDB, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0xD5, 0xDC, 0xF3, 0xC4, 0xCB, 0xD7, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0xE2, 0xB6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xF1, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xD5, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xD8, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xD0, 0xF0, 0xD9, /* 0xDC-0xDF */
	0xCB, 0xB3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xDD, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xA7, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xAC, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_7D[512] = {
	0xD1, 0xBA, 0x3F, 0x3F, 0xF1, 0xC4, 0x3F, 0x3F, /* 0x00-0x03 */
	0xE5, 0xB3, 0xFB, 0xF5, 0xE9, 0xE1, 0xFD, 0xE0, /* 0x04-0x07 */
	0xFC, 0xBC, 0x3F, 0x3F, 0xDA, 0xA2, 0xDA, 0xA3, /* 0x08-0x0B */
	0x3F, 0x3F, 0xD2, 0xA1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0xD2, 0xEF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0xE2, 0xED, 0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xE9, /* 0x14-0x17 */
	0xCE, 0xDC, 0xF2, 0xB5, 0xD0, 0xE4, 0xDD, 0xD1, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0xE1, 0xC8, 0xDB, 0xB7, 0xDF, 0xE3, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xB9, /* 0x28-0x2B */
	0xF1, 0xC5, 0x3F, 0x3F, 0xF3, 0xCF, 0xD7, 0xAB, /* 0x2C-0x2F */
	0xE1, 0xAC, 0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xEB, /* 0x30-0x33 */
	0x3F, 0x3F, 0xEE, 0xC7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0xE1, 0xC9, 0xCA, 0xFA, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xFB, 0xFA, 0xE1, /* 0x40-0x43 */
	0xF0, 0xDA, 0xCC, 0xE7, 0xDA, 0xF4, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0xCC, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xED, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0xD5, 0xA9, 0xFA, 0xE2, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xE5, 0x3F, 0x3F, /* 0x64-0x67 */
	0xEB, 0xD6, 0x3F, 0x3F, 0xEC, 0xDF, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xFC, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0xF7, 0xD6, 0xDE, 0xEA, 0xCB, 0xB4, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xBE, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0xCC, 0xB5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xBD, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xF2, 0xE2, 0xB7, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xE8, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0xF0, 0xFC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0xD6, 0xE0, 0x3F, 0x3F, 0xF1, 0xC6, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0xE2, 0xB8, 0xEB, 0xAB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0xCB, 0xB5, 0xD8, 0xD1, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0xF4, 0xCE, 0xF3, 0xF7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0xD7, 0xC6, 0x3F, 0x3F, 0xD1, 0xBB, 0xF7, 0xAA, /* 0xB8-0xBB */
	0x3F, 0x3F, 0xED, 0xCA, 0xD7, 0xD3, 0xD8, 0xFA, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xC5, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xCC, 0xDD, 0xFC, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xFD, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0xF9, 0xE5, 0x3F, 0x3F, 0xE0, 0xCA, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0xF2, 0xFD, 0xD3, 0xB0, 0x3F, 0x3F, /* 0xDC-0xDF */
	0xF4, 0xF3, 0xDA, 0xC9, 0x3F, 0x3F, 0xE6, 0xDE, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0xF8, 0xBA, 0xE8, 0xD0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0xD8, 0xFB, 0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xD5, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0xD6, 0xA3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xC6, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_7E[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0xF2, 0xDB, 0xE4, 0xFC, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0xE8, 0xB2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDA, 0xDA, /* 0x18-0x1B */
	0x3F, 0x3F, 0xF2, 0xDC, 0xFB, 0xD6, 0xE9, 0xB2, /* 0x1C-0x1F */
	0x3F, 0x3F, 0xEE, 0xAD, 0x3F, 0x3F, 0xFA, 0xE3, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xEE, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xEA, 0xE6, 0xE0, /* 0x2C-0x2F */
	0x3F, 0x3F, 0xF0, 0xFD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xAC, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0xF5, 0xC5, 0xEE, 0xE0, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0xDB, 0xE5, 0x3F, 0x3F, 0xDD, 0xDE, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xF0, 0xE9, 0xA3, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xF9, 0x3F, 0x3F, /* 0x50-0x53 */
	0xF2, 0xC4, 0xE0, 0xCB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xA4, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0xE2, 0xB9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0xE3, 0xB1, 0xFC, 0xEB, 0xCD, 0xA8, /* 0x68-0x6B */
	0x3F, 0x3F, 0xCC, 0xB6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0xF0, 0xDB, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0xE6, 0xBA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0xCD, 0xA9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xC3, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0xE1, 0xD9, 0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xAB, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xC5, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xE9, 0x3F, 0x3F, /* 0x94-0x97 */
	0xF3, 0xC5, 0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xC0, /* 0x98-0x9B */
	0xD5, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_7F[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xAE, 0x3F, 0x3F, /* 0x34-0x37 */
	0xF9, 0xFC, 0x3F, 0x3F, 0xCC, 0xC0, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0xE5, 0xA2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0xCE, 0xB8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0xD8, 0xD2, 0xF9, 0xD6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xAA, 0xCE, 0xD1, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xC7, 0x3F, 0x3F, /* 0x6C-0x6F */
	0xDB, 0xEB, 0x3F, 0x3F, 0xDF, 0xFE, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0xD8, 0xE1, 0x3F, 0x3F, 0xF7, 0xF3, /* 0x74-0x77 */
	0x3F, 0x3F, 0xD7, 0xE7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0xD4, 0xFE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0xD1, 0xBC, 0x3F, 0x3F, 0xE5, 0xCF, 0x3F, 0x3F, /* 0x88-0x8B */
	0xCB, 0xB6, 0x3F, 0x3F, 0xDA, 0xB8, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0xCD, 0xC4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xBE, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xBA, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0xCF, 0xD8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0xE0, 0xCC, 0xEB, 0xF9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xFD, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0xD7, 0xE8, 0xCB, 0xD8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0xE9, 0xE2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0xE8, 0xBA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0xE3, 0xC7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xCD, 0x3F, 0x3F, /* 0xC8-0xCB */
	0xEC, 0xCE, 0x3F, 0x3F, 0xD6, 0xBF, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xA7, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0xDF, 0xD6, 0xFD, 0xE8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xE1, /* 0xDC-0xDF */
	0xF6, 0xA8, 0xDD, 0xFD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0xF8, 0xBB, 0x3F, 0x3F, 0xE8, 0xD1, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0xF9, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0xCE, 0xEE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0xEC, 0xCF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_80[512] = {
	0xE9, 0xA5, 0xD6, 0xD5, 0x3F, 0x3F, 0xCD, 0xC5, /* 0x00-0x03 */
	0x3F, 0x3F, 0xED, 0xBA, 0xD1, 0xBD, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0xCF, 0xBE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0xEC, 0xBB, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0xD2, 0xB1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0xCC, 0xE9, 0x3F, 0x3F, 0xD9, 0xC4, /* 0x14-0x17 */
	0xE9, 0xFC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0xD1, 0xBE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xBC, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xAD, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0xF7, 0xB0, 0x3F, 0x3F, 0xCC, 0xEA, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xC4, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xC0, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xFD, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xA1, 0x3F, 0x3F, /* 0x54-0x57 */
	0xDE, 0xBD, 0x3F, 0x3F, 0xF6, 0xA9, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDA, 0xA4, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xA4, /* 0x6C-0x6F */
	0xF5, 0xC6, 0x3F, 0x3F, 0xE1, 0xA2, 0xE9, 0xC6, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xC5, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0xF4, 0xE9, 0xD6, 0xEC, 0xEB, 0xD3, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0xEC, 0xBD, 0xE2, 0xDC, 0xDE, 0xEB, 0xF0, 0xDC, /* 0x84-0x87 */
	0x3F, 0x3F, 0xEB, 0xBF, 0x3F, 0x3F, 0xD7, 0xCE, /* 0x88-0x8B */
	0xD1, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xAB, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xFD, /* 0x98-0x9B */
	0x3F, 0x3F, 0xCA, 0xDC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0xCD, 0xC6, 0xF2, 0xB6, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0xDD, 0xFE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0xCC, 0xB7, 0xDB, 0xB8, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xE9, /* 0xAC-0xAF */
	0x3F, 0x3F, 0xCE, 0xDD, 0xEB, 0xC0, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0xFD, 0xA2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xCB, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xD6, /* 0xC0-0xC3 */
	0xF1, 0xB0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0xDB, 0xCE, 0x3F, 0x3F, 0xF7, 0xC3, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xCF, 0xCB, 0xA4, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xE0, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xFB, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0xEB, 0xCA, 0xE0, 0xA1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0xCE, 0xCD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0xD4, 0xDC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0xFD, 0xD8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0xD2, 0xF6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_81[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xB7, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0xFA, 0xF6, 0xF6, 0xAA, 0xFA, 0xF7, /* 0x04-0x07 */
	0xD8, 0xE6, 0x3F, 0x3F, 0xF4, 0xB1, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0xE8, 0xD2, 0x3F, 0x3F, 0xCA, 0xC5, 0xCC, 0xEB, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xEE, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0xE2, 0xBB, 0x3F, 0x3F, 0xF7, 0xAD, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xE1, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0xF3, 0xEC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xA1, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xFD, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xEC, 0x3F, 0x3F, /* 0x4C-0x4F */
	0xDD, 0xAF, 0xDD, 0xB0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0xCB, 0xB7, 0xE8, 0xD3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0xE1, 0xA3, 0xD2, 0xE0, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xFE, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0xE9, 0xA6, 0xCB, 0xF2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0xED, 0xF3, 0xDC, 0xD9, 0xE0, 0xCD, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF7, 0xDA, /* 0x7C-0x7F */
	
	0xDB, 0xB9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0xCC, 0xAE, 0x3F, 0x3F, 0xDA, 0xDB, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xC7, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xB1, 0x3F, 0x3F, /* 0x98-0x9B */
	0xD8, 0xAF, 0xE3, 0xA3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0xCE, 0xEF, 0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xF3, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0xF8, 0xB3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xCE, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0xF5, 0xFD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEB, 0xEC, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0xD3, 0xC5, 0xFC, 0xEC, 0xD2, 0xDB, /* 0xBC-0xBF */
	0xD4, 0xEB, 0x3F, 0x3F, 0xDE, 0xA2, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xE6, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0xF0, 0xB0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0xD5, 0xC4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xF4, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xED, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0xE8, 0xC2, 0x3F, 0x3F, 0xED, 0xF5, /* 0xE4-0xE7 */
	0xD7, 0xFC, 0x3F, 0x3F, 0xED, 0xBB, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0xF6, 0xAB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xB8, /* 0xF0-0xF3 */
	0xF6, 0xC8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xE6, 0xF2, 0xDD, /* 0xF8-0xFB */
	0xCF, 0xBF, 0x3F, 0x3F, 0xEB, 0xAC, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_82[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0xCF, 0xC0, 0x3F, 0x3F, 0xE6, 0xA8, /* 0x04-0x07 */
	0xFD, 0xE9, 0x3F, 0x3F, 0xCF, 0xC1, 0x3F, 0x3F, /* 0x08-0x0B */
	0xE0, 0xDF, 0xDE, 0xEC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xA2, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xBF, /* 0x18-0x1B */
	0xE2, 0xEF, 0x3F, 0x3F, 0xD9, 0xF1, 0xF1, 0xC7, /* 0x1C-0x1F */
	0x3F, 0x3F, 0xCB, 0xB8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xFE, 0xDB, 0xBA, /* 0x28-0x2B */
	0xDA, 0xF5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0xF6, 0xEC, 0xDA, 0xDC, 0xFA, 0xE4, /* 0x34-0x37 */
	0x3F, 0x3F, 0xE0, 0xCF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0xDD, 0xB2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0xE6, 0xA9, 0x3F, 0x3F, 0xEF, 0xF3, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0xF3, 0xED, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0xEB, 0xFA, 0x3F, 0x3F, 0xF9, 0xE6, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xDD, 0xD5, 0xDE, /* 0x6C-0x6F */
	0x3F, 0x3F, 0xCA, 0xDE, 0xDF, 0xE4, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE6, 0xFD, 0x3F, 0x3F, /* 0x74-0x77 */
	0xF5, 0xAC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xF5, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xE3, /* 0x88-0x8B */
	0x3F, 0x3F, 0xED, 0xCB, 0xCF, 0xE4, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xD3, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0xDD, 0xB3, 0xD4, 0xEC, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0xF2, 0xB9, 0x3F, 0x3F, 0xDF, 0xB7, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0xCB, 0xCE, 0xFB, 0xD8, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0xD0, 0xD9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0xDD, 0xD2, 0xF7, 0xF4, 0xE7, 0xDC, 0xE4, 0xA5, /* 0xAC-0xAF */
	0x3F, 0x3F, 0xFC, 0xA3, 0x3F, 0x3F, 0xDB, 0xBB, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xBA, /* 0xB4-0xB7 */
	0xE9, 0xFD, 0xD0, 0xCA, 0x3F, 0x3F, 0xF5, 0xD6, /* 0xB8-0xBB */
	0xD9, 0xC5, 0xE4, 0xB4, 0x3F, 0x3F, 0xED, 0xA7, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0xEA, 0xBD, 0xE6, 0xFE, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0xF7, 0xC4, 0xF5, 0xAD, 0x3F, 0x3F, 0xD9, 0xE0, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xB4, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xE2, 0xCF, 0xC2, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xEC, 0xBE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0xE5, 0xB4, 0xCD, 0xC8, 0xEE, 0xC8, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0xE7, 0xC8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0xCD, 0xC9, 0xF9, 0xB7, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_83[512] = {
	0x3F, 0x3F, 0xF1, 0xE8, 0xD9, 0xF2, 0xDB, 0xF5, /* 0x00-0x03 */
	0xCA, 0xB5, 0xD9, 0xC6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0xD8, 0xC9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xAB, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0xED, 0xBC, 0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xD4, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xDA, /* 0x2C-0x2F */
	0x3F, 0x3F, 0xE2, 0xBC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0xFC, 0xED, 0xEC, 0xE0, 0xD2, 0xFE, 0x3F, 0x3F, /* 0x34-0x37 */
	0xE9, 0xC7, 0xE6, 0xAA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0xE2, 0xF0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xBB, /* 0x44-0x47 */
	0x3F, 0x3F, 0xF5, 0xAE, 0xFB, 0xAA, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xFB, /* 0x4C-0x4F */
	0x3F, 0x3F, 0xEC, 0xBF, 0xFC, 0xD8, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xE5, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xC3, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xE2, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0xD7, 0xE9, 0xED, 0xF6, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xED, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xEC, 0x3F, 0x3F, /* 0x94-0x97 */
	0xE3, 0xEE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xD4, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xF8, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0xDD, 0xB4, 0xE4, 0xB5, 0xD8, 0xB0, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0xD8, 0xD5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0xF4, 0xEA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0xCE, 0xB9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xD6, 0xE1, 0xCF, 0xD2, 0x3F, 0x3F, /* 0xC8-0xCB */
	0xD0, 0xB6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xA2, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xEE, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0xF3, 0xF8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0xDC, 0xCC, 0x3F, 0x3F, 0xD0, 0xCB, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xA4, /* 0xEC-0xEF */
	0xCD, 0xCA, 0xD7, 0xD4, 0xDE, 0xA3, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0xE4, 0xE0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0xEE, 0xC9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0xE2, 0xDD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_84[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xFE, /* 0x00-0x03 */
	0xD4, 0xAC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xD1, 0x3F, 0x3F, /* 0x08-0x0B */
	0xD8, 0xF0, 0xF8, 0xC3, 0xEA, 0xD7, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0xF5, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0xD8, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0xFD, 0xC0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0xEB, 0xAD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0xD5, 0xAA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0xE7, 0xA8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xCA, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xE7, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0xF8, 0xE3, 0x3F, 0x3F, 0xD4, 0xDD, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xD8, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xD9, /* 0x68-0x6B */
	0xED, 0xF7, 0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xB5, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0xD0, 0xAD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xF1, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0xE2, 0xBD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0xE3, 0xC8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0xD9, 0xD5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0xDF, 0xAA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0xDB, 0xBC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xE4, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0xF1, 0xFA, 0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xB6, /* 0xB8-0xBB */
	0xF3, 0xEF, 0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xDA, /* 0xBC-0xBF */
	0xE1, 0xE0, 0x3F, 0x3F, 0xD9, 0xAC, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xF5, 0xEB, 0x3F, 0x3F, 0xE0, 0xB6, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xE9, 0xC8, 0x3F, 0x3F, 0xCB, 0xCF, /* 0xC8-0xCB */
	0x3F, 0x3F, 0xE3, 0xC9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0xDE, 0xEE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xBE, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0xDC, 0xEF, 0x3F, 0x3F, 0xD6, 0xA5, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0xE2, 0xF1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0xD6, 0xFE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_85[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xD9, 0xA1, 0x3F, 0x3F, 0xD8, 0xC0, /* 0x10-0x13 */
	0xDC, 0xDB, 0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xBD, /* 0x14-0x17 */
	0xDF, 0xB8, 0x3F, 0x3F, 0xEA, 0xA5, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xAD, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0xF3, 0xF9, 0x3F, 0x3F, 0xED, 0xF8, /* 0x20-0x23 */
	0x3F, 0x3F, 0xF5, 0xC7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0xE1, 0xCA, 0xEB, 0xE3, 0x3F, 0x3F, 0xF2, 0xDE, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0xF8, 0xCC, 0x3F, 0x3F, 0xEA, 0xD9, /* 0x3C-0x3F */
	0x3F, 0x3F, 0xD3, 0xC6, 0x3F, 0x3F, 0xDB, 0xE6, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0xF5, 0xAF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xF0, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xFE, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0xFB, 0xB6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xF2, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0xCF, 0xF2, 0xF7, 0xB9, 0xD9, 0xF3, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0xE1, 0xCB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0xDA, 0xDD, 0x3F, 0x3F, 0x3F, 0x3F, 0xDA, 0xB9, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEB, 0xFB, /* 0x8C-0x8F */
	0x3F, 0x3F, 0xCB, 0xB9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0xED, 0xF9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xE0, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xC0, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0xFD, 0xBC, 0xDF, 0xB1, 0xE3, 0xEF, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xA3, /* 0xAC-0xAF */
	0xFD, 0xB9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xB1, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0xCD, 0xCB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xED, 0xBE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0xD5, 0xC0, 0xE3, 0xF0, 0xED, 0xFA, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0xE9, 0xE4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0xD5, 0xED, 0xE7, 0xDD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0xD4, 0xF6, 0xE5, 0xB7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0xDB, 0xE7, 0xE2, 0xBF, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xCB, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xF4, 0xF0, 0xDD, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xAB, /* 0xFC-0xFF */
};

static unsigned char u2c_86[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xDE, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xD6, 0xE1, 0xCC, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xB3, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xEE, 0xDC, 0xA2, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xD0, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0xD5, 0xB5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xA1, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xDB, 0x3F, 0x3F, /* 0x4C-0x4F */
	0xF9, 0xCB, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0xCB, 0xF3, 0xF4, 0xA5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xC8, /* 0x58-0x5B */
	0xD6, 0xD7, 0x3F, 0x3F, 0xE9, 0xE5, 0xFB, 0xDC, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xD0, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0xFB, 0xF6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDA, 0xA5, 0x3F, 0x3F, /* 0x88-0x8B */
	0xDB, 0xBD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xE2, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xF7, /* 0xA0-0xA3 */
	0xF0, 0xDE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0xF6, 0xC9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xEF, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xB1, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0xFC, 0xEE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0xE8, 0xC3, 0x3F, 0x3F, 0xF1, 0xC8, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xF1, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0xF9, 0xED, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0xF2, 0xF4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xB6, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_87[512] = {
	0xF5, 0xB9, 0x3F, 0x3F, 0xDC, 0xF0, 0xE3, 0xF1, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0xE8, 0xA5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0xF2, 0xBB, 0x3F, 0x3F, 0xDE, 0xA4, 0x3F, 0x3F, /* 0x18-0x1B */
	0xDA, 0xCC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xE9, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0xE3, 0xDA, 0x3F, 0x3F, 0xFC, 0xD9, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xDA, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xC4, 0x3F, 0x3F, /* 0x64-0x67 */
	0xE3, 0xA4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0xFB, 0xDD, 0x3F, 0x3F, 0xEF, 0xCA, 0x3F, 0x3F, /* 0x74-0x77 */
	0xE8, 0xC4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xCC, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0xEB, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xAD, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xAB, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xD9, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xA2, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xF6, 0xDE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0xDA, 0xF6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0xE0, 0xD1, 0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xA8, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xF9, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0xFA, 0xAF, 0x3F, 0x3F, 0xEB, 0xFC, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xEA, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_88[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0xE3, 0xB2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xC5, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xE3, 0xD5, 0xEE, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0xCD, 0xCC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xD9, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xC1, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0xFA, 0xEC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xEB, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0xFA, 0xBC, 0xE6, 0xE2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xE5, 0xE2, 0xFA, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xB6, /* 0x54-0x57 */
	0x3F, 0x3F, 0xE4, 0xB7, 0x3F, 0x3F, 0xEA, 0xDB, /* 0x58-0x5B */
	0x3F, 0x3F, 0xF5, 0xFA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0xFB, 0xAC, 0xCF, 0xC3, 0xEB, 0xFD, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0xF8, 0xFA, 0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xB9, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0xE1, 0xF1, 0x3F, 0x3F, 0xD2, 0xA4, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xFB, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xDA, 0xD0, 0xDB, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0xEA, 0xBE, 0xD9, 0xB1, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0xCA, 0xB7, 0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xE7, /* 0x88-0x8B */
	0x3F, 0x3F, 0xF8, 0xE5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xB2, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xC0, 0xF2, 0xDF, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xE5, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xAC, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0xCD, 0xCD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0xEE, 0xAE, 0xD6, 0xAE, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xEA, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0xE7, 0xE0, 0xEB, 0xAE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0xCF, 0xD9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0xDC, 0xCD, 0xED, 0xFB, 0x3F, 0x3F, 0xDE, 0xF0, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xD7, 0xEB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0xDE, 0xA5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xD7, /* 0xF0-0xF3 */
	0xDB, 0xD0, 0xDB, 0xD1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0xD5, 0xA3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0xF0, 0xB2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_89[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xDC, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0xCA, 0xE8, 0x3F, 0x3F, 0xF8, 0xE6, 0xDC, 0xCE, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0xEA, 0xDC, 0xDB, 0xD2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0xE9, 0xB3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF7, 0xDB, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xA8, 0x3F, 0x3F, /* 0x34-0x37 */
	0xD7, 0xAE, 0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xE1, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0xCB, 0xBA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0xE5, 0xD1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xDC, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0xD5, 0xC1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xCA, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xA9, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xA4, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0xE9, 0xA9, 0x3F, 0x3F, 0xD3, 0xC7, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xDD, 0xF8, 0xAE, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xB8, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xAE, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xF2, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xCA, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0xCC, 0xAF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0xD4, 0xAD, 0xF6, 0xD1, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xCC, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xC6, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0xD5, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0xCE, 0xBA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xC7, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xB0, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0xDF, 0xD8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0xF5, 0xBA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_8A[512] = {
	0xE5, 0xEB, 0x3F, 0x3F, 0xEF, 0xF4, 0xDD, 0xB5, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0xCD, 0xAA, 0x3F, 0x3F, 0xE3, 0xF2, 0x3F, 0x3F, /* 0x08-0x0B */
	0xFB, 0xF7, 0x3F, 0x3F, 0xF7, 0xD0, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xBA, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xE1, 0xF6, 0xFE, /* 0x14-0x17 */
	0xD1, 0xC0, 0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xC5, /* 0x18-0x1B */
	0x3F, 0x3F, 0xE4, 0xB8, 0x3F, 0x3F, 0xE1, 0xE8, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xC1, /* 0x20-0x23 */
	0x3F, 0x3F, 0xD2, 0xED, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xBE, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0xE0, 0xE2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0xFA, 0xC9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0xE1, 0xCD, 0x3F, 0x3F, 0xCA, 0xB8, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xE0, 0xF1, 0xC9, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0xDE, 0xF1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0xF0, 0xDF, 0xF8, 0xC4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xCC, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xF2, 0x3F, 0x3F, /* 0x5C-0x5F */
	0xE7, 0xC9, 0x3F, 0x3F, 0xE2, 0xF3, 0xE7, 0xE1, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xCB, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0xE3, 0xCC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0xCF, 0xF8, 0xEF, 0xAC, 0x3F, 0x3F, /* 0x6C-0x6F */
	0xFD, 0xFE, 0xFC, 0xA5, 0xFA, 0xB1, 0xDF, 0xD9, /* 0x70-0x73 */
	0x3F, 0x3F, 0xE0, 0xD2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0xF4, 0xDA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0xF1, 0xCA, 0x3F, 0x3F, 0xCE, 0xA3, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0xF2, 0xBC, 0xEC, 0xE3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xA5, /* 0x90-0x93 */
	0x3F, 0x3F, 0xF7, 0xAB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0xEB, 0xAF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xDE, 0x3F, 0x3F, /* 0x9C-0x9F */
	0xE1, 0xA4, 0xCD, 0xAB, 0x3F, 0x3F, 0xD9, 0xF4, /* 0xA0-0xA3 */
	0xE8, 0xA6, 0xCD, 0xCE, 0xE1, 0xE9, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0xFC, 0xEF, 0x3F, 0x3F, 0xE0, 0xE3, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0xE2, 0xC1, 0x3F, 0x3F, 0xCE, 0xA4, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0xDE, 0xA6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0xEB, 0xFE, 0x3F, 0x3F, 0xEB, 0xDD, 0xF0, 0xE0, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xDB, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xE2, 0xF4, 0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xC8, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xEB, /* 0xC8-0xCB */
	0x3F, 0x3F, 0xEE, 0xB5, 0x3F, 0x3F, 0xF5, 0xD8, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xDF, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xE5, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEB, 0xB0, /* 0xD8-0xDB */
	0xF4, 0xE3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xE3, 0xCD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xF4, 0xFA, 0xB2, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xF5, 0xCA, 0xDF, /* 0xE8-0xEB */
	0x3F, 0x3F, 0xEB, 0xB1, 0xED, 0xBF, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0xFD, 0xC9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xA6, 0xF9, 0xA4, /* 0xF4-0xF7 */
	0xF0, 0xB3, 0x3F, 0x3F, 0xE5, 0xEC, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xE7, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_8B[512] = {
	0xD9, 0xC7, 0xE4, 0xD7, 0xEA, 0xDD, 0x3F, 0x3F, /* 0x00-0x03 */
	0xD4, 0xF7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDA, 0xBA, 0x3F, 0x3F, /* 0x0C-0x0F */
	0xDA, 0xCD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0xF9, 0xCC, 0x3F, 0x3F, 0xE1, 0xDA, 0xDB, 0xBF, /* 0x14-0x17 */
	0x3F, 0x3F, 0xCC, 0xC5, 0xEC, 0xD0, 0xCB, 0xBB, /* 0x18-0x1B */
	0x3F, 0x3F, 0xDE, 0xF3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0xE9, 0xAA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0xD9, 0xC8, 0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xE3, /* 0x28-0x2B */
	0xD7, 0xBD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xC4, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0xD0, 0xCD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0xFC, 0xA6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0xF1, 0xFB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xD2, 0xD1, 0xC1, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0xE3, 0xDB, 0x3F, 0x3F, 0xD3, 0xC9, 0x3F, 0x3F, /* 0x58-0x5B */
	0xDC, 0xCF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xED, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0xDE, 0xA7, 0x3F, 0x3F, 0x3F, 0x3F, 0xE6, 0xBB, /* 0x6C-0x6F */
	0xEC, 0xA1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0xCC, 0xB9, 0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xDE, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0xE7, 0xE2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0xD4, 0xC1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xA8, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0xE2, 0xC2, 0x3F, 0x3F, 0xF3, 0xD8, 0xE5, 0xD3, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xD9, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xC6, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_8C[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xDB, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xAC, /* 0x3C-0x3F */
	0x3F, 0x3F, 0xFC, 0xC3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xE7, 0x3F, 0x3F, /* 0x44-0x47 */
	0xD1, 0xC2, 0x3F, 0x3F, 0xF9, 0xA5, 0x3F, 0x3F, /* 0x48-0x4B */
	0xE8, 0xD5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0xE3, 0xCE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xCA, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0xDF, 0xDA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xDF, 0xE7, 0xE3, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0xF8, 0xFB, 0xE3, 0xCF, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xB0, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xE7, 0x3F, 0x3F, /* 0x88-0x8B */
	0xD9, 0xC9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0xF8, 0xAF, 0xEF, 0xF6, 0x3F, 0x3F, /* 0x9C-0x9F */
	0xDD, 0xB6, 0xEE, 0xAF, 0xCD, 0xF8, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xB8, /* 0xA4-0xA7 */
	0xFC, 0xA7, 0xF7, 0xFC, 0xF7, 0xB1, 0xCE, 0xBB, /* 0xA8-0xAB */
	0xF4, 0xA1, 0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xCD, /* 0xAC-0xAF */
	0xE1, 0xAE, 0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xC3, /* 0xB0-0xB3 */
	0xCF, 0xFE, 0x3F, 0x3F, 0xF8, 0xBF, 0xD8, 0xE2, /* 0xB4-0xB7 */
	0xD3, 0xE8, 0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xA8, /* 0xB8-0xBB */
	0xF4, 0xE4, 0xEC, 0xC2, 0x3F, 0x3F, 0xD9, 0xF5, /* 0xBC-0xBF */
	0xF9, 0xC5, 0xDD, 0xD3, 0xD6, 0xF1, 0xEC, 0xFC, /* 0xC0-0xC3 */
	0xFC, 0xF0, 0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xC0, /* 0xC4-0xC7 */
	0xCA, 0xB9, 0x3F, 0x3F, 0xEE, 0xE4, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0xF2, 0xE1, 0x3F, 0x3F, 0xDE, 0xB9, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xF2, 0x3F, 0x3F, /* 0xD8-0xDB */
	0xDE, 0xF4, 0x3F, 0x3F, 0xDF, 0xDB, 0x3F, 0x3F, /* 0xDC-0xDF */
	0xDB, 0xD3, 0x3F, 0x3F, 0xFA, 0xE7, 0xD8, 0xE3, /* 0xE0-0xE3 */
	0xF4, 0xC1, 0x3F, 0x3F, 0xDD, 0xB7, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xF5, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0xD4, 0xAE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0xD6, 0xF3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xB8, /* 0xF8-0xFB */
	0xCF, 0xC5, 0xDF, 0xDF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_8D[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0xF2, 0xBE, 0xF6, 0xA1, 0x3F, 0x3F, 0xEB, 0xCB, /* 0x04-0x07 */
	0xF1, 0xFC, 0x3F, 0x3F, 0xF3, 0xC7, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0xE0, 0xEB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xFC, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xDB, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0xEE, 0xE5, 0x3F, 0x3F, 0xDE, 0xF5, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xD3, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0xF1, 0xCB, 0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xAF, /* 0x70-0x73 */
	0xDD, 0xB9, 0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xC3, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0xF5, 0xB1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xC6, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0xF0, 0xE1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xAC, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0xF5, 0xD9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xEB, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDD, 0xBA, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xBF, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF7, 0xC5, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xA2, /* 0xC8-0xCB */
	0xF2, 0xF6, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xBA, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF7, 0xF5, /* 0xD8-0xDB */
	0x3F, 0x3F, 0xCB, 0xE5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xEE, 0xE6, 0x3F, 0x3F, 0xE0, 0xD3, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0xCE, 0xA5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xD8, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xAF, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_8E[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xC9, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xCE, /* 0x0C-0x0F */
	0xF4, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xE6, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xA1, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0xEB, 0xB2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0xF1, 0xA2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEB, 0xB3, 0x3F, 0x3F, /* 0x40-0x43 */
	0xF0, 0xB4, 0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xF4, /* 0x44-0x47 */
	0xD4, 0xB0, 0xF3, 0xB2, 0xFB, 0xB7, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0xF5, 0xEC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xE7, /* 0x5C-0x5F */
	0xF4, 0xB2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0xF5, 0xED, 0x3F, 0x3F, 0xCF, 0xF3, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0xF0, 0xE2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xCE, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xCC, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0xE5, 0xB8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xF5, 0xE3, 0xF3, /* 0xA8-0xAB */
	0xCF, 0xE5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0xCF, 0xC6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xB3, 0xE4, 0xD8, /* 0xC8-0xCB */
	0xCF, 0xF9, 0xCF, 0xDA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xCD, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE6, 0xE3, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xE2, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0xF5, 0xEE, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xBB, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xDC, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_8F[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xF2, /* 0x00-0x03 */
	0x3F, 0x3F, 0xD6, 0xD9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0xEE, 0xB0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xE5, 0xD8, 0xC2, /* 0x10-0x13 */
	0xDC, 0xD0, 0xCC, 0xEE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xE0, /* 0x18-0x1B */
	0xF6, 0xCA, 0xFD, 0xCA, 0xD8, 0xD6, 0xF4, 0xCF, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xA6, 0xDC, 0xBE, /* 0x24-0x27 */
	0x3F, 0x3F, 0xDB, 0xD4, 0xD7, 0xC7, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xFE, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xCD, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0xE2, 0xC3, 0xDC, 0xDE, 0x3F, 0x3F, 0xDC, 0xDF, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xAD, 0xE6, 0xAB, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0xF9, 0xDD, 0xEA, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0xEF, 0xAE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0xF4, 0xD0, 0xCE, 0xF3, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0xE6, 0xAC, 0x3F, 0x3F, 0xCE, 0xDE, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xF9, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xF4, /* 0x98-0x9B */
	0xCD, 0xD0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xB8, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF7, 0xFD, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0xDC, 0xA9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0xDE, 0xF6, 0x3F, 0x3F, 0xDC, 0xAA, /* 0xAC-0xAF */
	0xF2, 0xE3, 0xE9, 0xB4, 0xD2, 0xDC, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xE6, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0xE3, 0xF6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xCA, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0xD0, 0xCE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0xDA, 0xF7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xBC, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xE8, 0xDA, 0xDE, /* 0xE8-0xEB */
	0x3F, 0x3F, 0xF2, 0xF7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0xE2, 0xFB, 0x3F, 0x3F, 0xCC, 0xA6, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDA, 0xBB, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0xEE, 0xE9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0xF5, 0xDA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_90[512] = {
	0xF7, 0xDC, 0xE1, 0xEA, 0xCE, 0xC1, 0xD4, 0xB1, /* 0x00-0x03 */
	0x3F, 0x3F, 0xFD, 0xB1, 0xE6, 0xBD, 0x3F, 0x3F, /* 0x04-0x07 */
	0xFB, 0xAD, 0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xE7, /* 0x08-0x0B */
	0x3F, 0x3F, 0xE1, 0xCE, 0x3F, 0x3F, 0xF7, 0xE2, /* 0x0C-0x0F */
	0xF5, 0xEF, 0xCF, 0xC7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0xD4, 0xB2, 0xCC, 0xEF, 0x3F, 0x3F, 0xD4, 0xE8, /* 0x14-0x17 */
	0x3F, 0x3F, 0xEE, 0xCF, 0xF7, 0xD7, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0xE0, 0xA6, 0xD6, 0xC1, 0xE1, 0xDC, /* 0x1C-0x1F */
	0xF0, 0xE3, 0xF1, 0xE4, 0xDC, 0xF1, 0xD6, 0xA7, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xF5, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0xF1, 0xCE, 0xF2, 0xE4, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0xD0, 0xB0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0xEC, 0xEF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0xF9, 0xBA, 0x3F, 0x3F, 0xEB, 0xB5, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0xD4, 0xED, 0xE2, 0xC4, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xE7, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEB, 0xB4, 0xEA, 0xA1, /* 0x48-0x4B */
	0x3F, 0x3F, 0xF8, 0xBC, 0xCE, 0xA6, 0x3F, 0x3F, /* 0x4C-0x4F */
	0xF9, 0xC6, 0xFC, 0xDA, 0x3F, 0x3F, 0xD4, 0xB3, /* 0x50-0x53 */
	0xD3, 0xB9, 0xEA, 0xDE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0xE9, 0xAB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0xE1, 0xE1, 0xD3, 0xCF, 0xF4, 0xF6, 0x3F, 0x3F, /* 0x5C-0x5F */
	0xEA, 0xC0, 0xE1, 0xCF, 0x3F, 0x3F, 0xCC, 0xBA, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0xEE, 0xEA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0xF0, 0xE4, 0xF3, 0xB4, 0xD4, 0xEE, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xC0, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0xF1, 0xE5, 0x3F, 0x3F, 0xF4, 0xC3, /* 0x74-0x77 */
	0xE0, 0xD4, 0x3F, 0x3F, 0xEB, 0xB6, 0x3F, 0x3F, /* 0x78-0x7B */
	0xD7, 0xA1, 0xCB, 0xE8, 0x3F, 0x3F, 0xF9, 0xAD, /* 0x7C-0x7F */
	
	0xE9, 0xAD, 0xD8, 0xE4, 0xFA, 0xB3, 0xE2, 0xC5, /* 0x80-0x83 */
	0xFC, 0xBD, 0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xC4, /* 0x84-0x87 */
	0xD8, 0xB1, 0x3F, 0x3F, 0xDC, 0xAB, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xA4, /* 0x8C-0x8F */
	0x3F, 0x3F, 0xEB, 0xE9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0xE8, 0xBB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0xD8, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xAE, 0xD1, 0xE1, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xC0, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0xF5, 0xBE, 0x3F, 0x3F, 0xDE, 0xF7, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xFB, /* 0xAC-0xAF */
	0xF7, 0xC6, 0xCF, 0xC8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0xE1, 0xD0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0xEE, 0xD0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0xE9, 0xF4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xF4, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xCD, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xCF, 0xDB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0xDD, 0xBB, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0xCE, 0xAC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0xE9, 0xE8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0xD4, 0xB4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_91[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xC7, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xDB, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0xFA, 0xC1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0xDE, 0xA9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD4, 0xF8, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0xEF, 0xF7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xB3, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0xEB, 0xB7, 0xEF, 0xF8, 0xF5, 0xDC, /* 0x48-0x4B */
	0xED, 0xCC, 0xDB, 0xD5, 0xF1, 0xCF, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xD0, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xB2, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0xD9, 0xAE, 0xD5, 0xAC, 0x3F, 0x3F, /* 0x68-0x6B */
	0xE2, 0xC6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0xFD, 0xA3, 0x3F, 0x3F, 0xFB, 0xE5, /* 0x74-0x77 */
	0xDF, 0xAB, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xF5, /* 0x84-0x87 */
	0x3F, 0x3F, 0xF6, 0xAD, 0x3F, 0x3F, 0xF5, 0xB3, /* 0x88-0x8B */
	0x3F, 0x3F, 0xF0, 0xB5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xA5, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0xF5, 0xDD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xA2, /* 0xA8-0xAB */
	0xED, 0xFD, 0x3F, 0x3F, 0xF5, 0xB4, 0xFB, 0xB8, /* 0xAC-0xAF */
	0x3F, 0x3F, 0xDB, 0xA3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0xD6, 0xCA, 0xCB, 0xD9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0xE5, 0xD4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xFA, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xEB, 0xB8, 0x3F, 0x3F, 0xE0, 0xB7, /* 0xC8-0xCB */
	0xD7, 0xEC, 0xF1, 0xEC, 0xE5, 0xAF, 0xD5, 0xE1, /* 0xCC-0xCF */
	0xD7, 0xED, 0xD1, 0xD1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xF2, /* 0xD4-0xD7 */
	0xEF, 0xF9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0xDD, 0xBC, 0xF6, 0xDC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xE5, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xC4, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xE9, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0xF3, 0xFB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_92[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0xD4, 0xEF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0xCC, 0xA2, 0xF7, 0xFE, 0xDF, 0xBC, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEB, 0xCD, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD0, 0xB7, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0xD6, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xAD, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xAF, /* 0x3C-0x3F */
	0xCB, 0xA5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0xCB, 0xE9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0xFA, 0xE8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xC6, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE6, 0xE7, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xC7, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xA4, 0x3F, 0x3F, /* 0x60-0x63 */
	0xCF, 0xC9, 0xE2, 0xFC, 0xEF, 0xFA, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0xEB, 0xDE, 0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xC8, /* 0x80-0x83 */
	0x3F, 0x3F, 0xD4, 0xDE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0xE0, 0xD5, 0x3F, 0x3F, 0xEF, 0xB0, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xC7, 0x3F, 0x3F, /* 0x94-0x97 */
	0xD9, 0xAF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0xF9, 0xE7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xE5, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xCA, 0xE1, 0xD1, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0xE2, 0xC8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0xEF, 0xFB, 0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xF9, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xF2, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0xE0, 0xA7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xE8, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0xCB, 0xEA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0xCB, 0xBC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_93[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0xD6, 0xE2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0xF5, 0xDE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0xF5, 0xDF, 0x3F, 0x3F, 0xEE, 0xB6, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xF6, 0xD3, 0xCA, /* 0x1C-0x1F */
	0xEF, 0xFC, 0xD1, 0xC4, 0xEF, 0xB1, 0x3F, 0x3F, /* 0x20-0x23 */
	0xD1, 0xC5, 0x3F, 0x3F, 0xD0, 0xDE, 0x3F, 0x3F, /* 0x24-0x27 */
	0xD9, 0xE1, 0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xB8, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xD1, 0xF3, 0xB9, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0xE7, 0xCC, 0x3F, 0x3F, 0xD6, 0xA8, 0xCE, 0xA7, /* 0x48-0x4B */
	0x3F, 0x3F, 0xD4, 0xB5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0xE4, 0xC8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xB4, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEB, 0xB9, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0xCB, 0xF5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0xF6, 0xDD, 0x3F, 0x3F, 0xF1, 0xA3, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0xCC, 0xC7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0xE9, 0xCA, 0x3F, 0x3F, 0xE1, 0xF0, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xE0, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xAF, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xD1, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0xFB, 0xE0, 0xF2, 0xE5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0xEC, 0xF0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xEC, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0xEE, 0xEB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE9, 0xCB, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xCC, 0xF0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0xD7, 0xAF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xA1, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_94[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0xFC, 0xF5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0xF1, 0xA4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0xE0, 0xD6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xB2, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0xF4, 0xD1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0xF7, 0xA1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0xF1, 0xD1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0xCA, 0xFC, 0xCA, 0xFD, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xCE, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0xF3, 0xC8, 0x3F, 0x3F, 0xF3, 0xBA, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_95[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xFE, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0xDA, 0xA6, 0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xEC, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0xF8, 0xCD, 0x3F, 0x3F, 0xCB, 0xD2, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEB, 0xCE, /* 0x8C-0x8F */
	0x3F, 0x3F, 0xF9, 0xD8, 0xF9, 0xD9, 0xCA, 0xE0, /* 0x90-0x93 */
	0xDA, 0xCA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0xCB, 0xA6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCA, 0xC8, /* 0xA0-0xA3 */
	0xF9, 0xEE, 0xDB, 0xEC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0xD0, 0xB1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0xD5, 0xEF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0xE6, 0xF3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE7, 0xA2, /* 0xB8-0xBB */
	0xE4, 0xD9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xE1, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xC4, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0xF9, 0xEF, 0xCF, 0xF4, 0xF7, 0xE6, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0xCE, 0xBC, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xF4, 0xC5, 0xDC, 0xA3, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_96[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0xDD, 0xBD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0xF4, 0xC6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xA1, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xD6, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xC1, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xE6, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xB9, /* 0x3C-0x3F */
	0xF6, 0xED, 0x3F, 0x3F, 0xF9, 0xAE, 0x3F, 0x3F, /* 0x40-0x43 */
	0xDD, 0xBE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xB0, /* 0x48-0x4B */
	0xD8, 0xE8, 0xCB, 0xBD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0xF9, 0xDA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xCE, /* 0x58-0x5B */
	0xF9, 0xF0, 0xE0, 0xED, 0xE3, 0xB3, 0xF4, 0xB3, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xC2, 0xF2, 0xE6, /* 0x60-0x63 */
	0xF0, 0xB6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xD6, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0xEB, 0xE4, 0x3F, 0x3F, 0x3F, 0x3F, 0xF2, 0xE7, /* 0x70-0x73 */
	0x3F, 0x3F, 0xD7, 0xD5, 0xD4, 0xB6, 0xF9, 0xE8, /* 0x74-0x77 */
	0xD7, 0xC1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0xE5, 0xD5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0xE9, 0xEA, 0xD7, 0xCC, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xE9, 0xE2, 0xC9, /* 0x88-0x8B */
	0x3F, 0x3F, 0xFC, 0xDB, 0xCD, 0xAD, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0xCC, 0xB0, 0xEA, 0xA2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0xE4, 0xF6, 0xD0, 0xC0, 0x3F, 0x3F, 0xF0, 0xB7, /* 0x98-0x9B */
	0xEE, 0xA1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xF6, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xCA, /* 0xA4-0xA7 */
	0xE2, 0xCB, 0x3F, 0x3F, 0xFA, 0xCF, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0xEB, 0xDF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xCB, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xB4, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0xED, 0xCD, 0xE4, 0xD2, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xEA, 0xA9, 0xE4, 0xBA, 0xF3, 0xA2, 0xCD, 0xD2, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xF6, 0xCB, 0x3F, 0x3F, 0xF1, 0xE6, /* 0xC8-0xCB */
	0xED, 0xC1, 0xE8, 0xBC, 0xEE, 0xD1, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0xF0, 0xE7, 0xE2, 0xCC, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0xE4, 0xAA, 0x3F, 0x3F, 0xF5, 0xE1, /* 0xD8-0xDB */
	0xED, 0xDA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xEE, 0xD1, 0xF1, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0xE9, 0xEB, 0xE9, 0xEC, 0xE0, 0xE4, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDA, 0xA7, /* 0xEC-0xEF */
	0xDD, 0xD4, 0x3F, 0x3F, 0xEA, 0xA3, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xC3, 0xD6, 0xF4, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0xDA, 0xDF, 0x3F, 0x3F, 0xEF, 0xB3, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_97[512] = {
	0xE2, 0xCD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xFD, 0xF2, 0xE8, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0xEF, 0xC5, 0x3F, 0x3F, 0xE7, 0xE7, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xFD, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0xE7, 0xCE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0xDF, 0xDC, 0x3F, 0x3F, 0xF9, 0xC7, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD9, 0xF6, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0xDF, 0xAC, 0x3F, 0x3F, 0xD6, 0xDA, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0xDC, 0xA4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0xF0, 0xB8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xFA, 0x3F, 0x3F, /* 0x40-0x43 */
	0xE4, 0xF7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0xD6, 0xC4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0xF4, 0xEC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xFE, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0xF0, 0xA1, 0x3F, 0x3F, 0xDE, 0xAA, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0xDA, 0xBC, 0xD8, 0xFC, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0xFA, 0xD4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0xEC, 0xE5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0xFC, 0xA8, 0x3F, 0x3F, 0x3F, 0x3F, 0xEC, 0xE6, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xCB, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xB9, /* 0x88-0x8B */
	0x3F, 0x3F, 0xE4, 0xD3, 0x3F, 0x3F, 0xCD, 0xF9, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0xCF, 0xD3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0xCA, 0xEA, 0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xD4, /* 0xA8-0xAB */
	0x3F, 0x3F, 0xF8, 0xBD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xC7, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xDF, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF9, 0xDB, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0xD4, 0xB7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEB, 0xE5, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE1, 0xD2, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xA4, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xC2, /* 0xFC-0xFF */
};

static unsigned char u2c_98[512] = {
	0xFB, 0xE1, 0xFA, 0xED, 0xF0, 0xA2, 0xCC, 0xF1, /* 0x00-0x03 */
	0x3F, 0x3F, 0xFA, 0xA3, 0xE2, 0xF7, 0x3F, 0x3F, /* 0x04-0x07 */
	0xE2, 0xCE, 0x3F, 0x3F, 0xE9, 0xF5, 0x3F, 0x3F, /* 0x08-0x0B */
	0xE1, 0xEB, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0xE7, 0xE8, 0xE8, 0xD7, 0xDA, 0xF8, 0xD4, 0xCB, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF7, 0xF6, /* 0x14-0x17 */
	0xD6, 0xC5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0xD4, 0xE9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0xFA, 0xFA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0xCC, 0xF2, 0xF7, 0xDD, 0x3F, 0x3F, 0xDE, 0xBA, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xA8, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0xF0, 0xB9, 0xE4, 0xFE, 0xE4, 0xC9, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0xE4, 0xD4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0xEA, 0xC3, 0x3F, 0x3F, 0xEF, 0xB4, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xBE, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0xFB, 0xE2, 0x3F, 0x3F, 0xCD, 0xD3, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xB5, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xE9, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0xF9, 0xA6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDF, 0xBD, /* 0xAC-0xAF */
	0x3F, 0x3F, 0xF7, 0xC7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xF8, 0xFD, 0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xFC, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xAB, /* 0xD8-0xDB */
	0xDB, 0xE8, 0x3F, 0x3F, 0x3F, 0x3F, 0xE3, 0xDD, /* 0xDC-0xDF */
	0x3F, 0x3F, 0xE1, 0xE2, 0xD1, 0xC6, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0xF6, 0xD0, 0xEB, 0xE6, 0xDA, 0xF9, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0xEC, 0xC7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0xDE, 0xF8, 0xF8, 0xE9, 0xE3, 0xDE, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_99[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xF5, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0xFA, 0xC3, 0xE5, 0xD7, 0x3F, 0x3F, /* 0x08-0x0B */
	0xEC, 0xC8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0xF3, 0xC9, 0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xBB, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0xE6, 0xAE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xB6, 0x3F, 0x3F, /* 0x1C-0x1F */
	0xDC, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0xCE, 0xBD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0xD8, 0xC3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0xD0, 0xCF, 0x3F, 0x3F, 0xCF, 0xFA, /* 0x48-0x4B */
	0xF3, 0xCA, 0xE0, 0xD7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0xD1, 0xC7, 0xE9, 0xAE, 0x3F, 0x3F, /* 0x50-0x53 */
	0xE8, 0xBD, 0x3F, 0x3F, 0x3F, 0x3F, 0xFA, 0xC4, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xCF, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0xFA, 0xC5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0xF9, 0xB8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0xDC, 0xE0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0xFB, 0xB0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0xD8, 0xA9, 0xE5, 0xDF, 0xF9, 0xA7, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0xF6, 0xEE, 0x3F, 0x3F, 0xF6, 0xCC, /* 0xB0-0xB3 */
	0xE2, 0xF8, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0xEC, 0xF1, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0xDA, 0xE0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0xF1, 0xD2, 0xD2, 0xCC, 0xCF, 0xCB, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0xCA, 0xBD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0xDD, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0xF6, 0xEF, 0x3F, 0x3F, 0xDE, 0xF9, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0xFA, 0xB4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0xD5, 0xAD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF1, 0xE7, /* 0xFC-0xFF */
};

static unsigned char u2c_9A[512] = {
	0x3F, 0x3F, 0xDE, 0xBE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0xDC, 0xC0, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xC8, 0xD1, 0xC9, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0xF8, 0xBE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xF6, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0xD4, 0xF9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF5, 0xE2, 0xE1, 0xD3, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0xD8, 0xE9, 0x3F, 0x3F, 0x3F, 0x3F, 0xF8, 0xFE, /* 0x40-0x43 */
	0x3F, 0x3F, 0xCF, 0xCC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0xFD, 0xA4, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0xCE, 0xF6, 0x3F, 0x3F, 0xFA, 0xD0, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xCC, 0xF3, 0xE6, 0xBE, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xAE, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xF0, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0xD1, 0xCA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0xFC, 0xBE, 0xD5, 0xF1, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0xCD, 0xE9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0xFA, 0xB5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xD0, /* 0xD0-0xD3 */
	0xF4, 0xF7, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0xCD, 0xD4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0xE7, 0xA3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xDB, 0xA5, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_9B[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE2, 0xD1, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xA2, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF7, 0xE3, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0xEA, 0xA6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0xD0, 0xA1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0xCE, 0xDA, 0xFB, 0xEB, 0xDB, 0xA6, /* 0x40-0x43 */
	0xDB, 0xDE, 0xD8, 0xE5, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xE0, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0xD8, 0xAA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xE0, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD6, 0xDB, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEF, 0xC6, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0xF8, 0xEA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xD5, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCE, 0xF7, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xD8, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0xD7, 0xEF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF4, 0xED, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0xCD, 0xE6, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0xCC, 0xF4, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_9C[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0xF5, 0xE3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0xE4, 0xCA, 0x3F, 0x3F, 0xDC, 0xE1, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0xF9, 0xC8, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0xFC, 0xBF, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xA7, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xC4, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCB, 0xBE, /* 0x44-0x47 */
	0x3F, 0x3F, 0xDC, 0xAE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD7, 0xF7, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0xF0, 0xE8, 0x3F, 0x3F, 0xDD, 0xC0, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0xCF, 0xCD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDC, 0xF3, /* 0xF0-0xF3 */
	0xD9, 0xB0, 0x3F, 0x3F, 0xE6, 0xE9, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_9D[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0xE4, 0xBC, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEA, 0xC4, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xEC, 0x3F, 0x3F, /* 0x24-0x27 */
	0xE4, 0xE5, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFB, 0xF8, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0xCC, 0xBB, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0xE4, 0xBD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0xCD, 0xDC, 0xD9, 0xF7, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0xDD, 0xDF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xED, 0xCE, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0xD9, 0xD0, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xA3, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0xF9, 0xCD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0xCD, 0xAE, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCF, 0xCE, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xAF, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0xFD, 0xD3, 0xEB, 0xED, 0xD6, 0xDC, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_9E[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x04-0x07 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xE5, 0xA4, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xB6, 0x3F, 0x3F, /* 0x1C-0x1F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x5C-0x5F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x68-0x6B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0xD6, 0xDD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x74-0x77 */
	0x3F, 0x3F, 0xF9, 0xE9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0xE7, 0xA4, 0x3F, 0x3F, 0xD6, 0xE3, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xD1, 0xCB, 0xD6, 0xE4, /* 0x90-0x93 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD5, 0xF2, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0x3F, 0x3F, 0xDE, 0xFA, 0x3F, 0x3F, 0xD7, 0xF8, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0xD8, 0xEA, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0xCF, 0xD5, 0xD8, 0xFD, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xD8, 0xAB, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0xFD, 0xCB, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xFC, 0xDC, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0xE0, 0xA8, 0xD5, 0xF3, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0xFD, 0xD9, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0xCC, 0xA3, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0xD9, 0xF9, 0x3F, 0x3F, 0x3F, 0x3F, 0xD3, 0xEA, /* 0xD8-0xDB */
	0xF5, 0xF5, 0x3F, 0x3F, 0xEF, 0xC7, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0xD3, 0xDA, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0xDA, 0xBD, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_9F[512] = {
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x00-0x03 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE8, 0xA8, /* 0x04-0x07 */
	0xDC, 0xAF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x08-0x0B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xA3, 0x3F, 0x3F, /* 0x0C-0x0F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xCD, 0xD5, /* 0x10-0x13 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x14-0x17 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x18-0x1B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x1C-0x1F */
	0xE0, 0xA9, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x20-0x23 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x24-0x27 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x28-0x2B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x2C-0x2F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x30-0x33 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x34-0x37 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xDE, 0xAC, /* 0x38-0x3B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x3C-0x3F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x40-0x43 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x44-0x47 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF0, 0xBA, 0xEE, 0xB1, /* 0x48-0x4B */
	0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xB2, 0x3F, 0x3F, /* 0x4C-0x4F */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF6, 0xCD, 0x3F, 0x3F, /* 0x50-0x53 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x54-0x57 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x58-0x5B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xEE, 0xD2, /* 0x5C-0x5F */
	0x3F, 0x3F, 0xD6, 0xC6, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x60-0x63 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE0, 0xE5, /* 0x64-0x67 */
	0x3F, 0x3F, 0x3F, 0x3F, 0xF3, 0xBB, 0x3F, 0x3F, /* 0x68-0x6B */
	0xE5, 0xE1, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x6C-0x6F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x70-0x73 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0xE4, 0xCB, /* 0x74-0x77 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x78-0x7B */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x7C-0x7F */
	
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x80-0x83 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x84-0x87 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x88-0x8B */
	0x3F, 0x3F, 0xD7, 0xA3, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x8C-0x8F */
	0xDB, 0xC2, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x90-0x93 */
	0x3F, 0x3F, 0xCA, 0xFE, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x94-0x97 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x98-0x9B */
	0xCF, 0xCF, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0x9C-0x9F */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA0-0xA3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA4-0xA7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xA8-0xAB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xAC-0xAF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB0-0xB3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB4-0xB7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xB8-0xBB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xBC-0xBF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC0-0xC3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC4-0xC7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xC8-0xCB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xCC-0xCF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD0-0xD3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD4-0xD7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xD8-0xDB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xDC-0xDF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE0-0xE3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE4-0xE7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xE8-0xEB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xEC-0xEF */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF0-0xF3 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF4-0xF7 */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xF8-0xFB */
	0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, 0x3F, /* 0xFC-0xFF */
};

static unsigned char u2c_AC[512] = {
	0xB0, 0xA1, 0xB0, 0xA2, 0x81, 0x41, 0x81, 0x42, /* 0x00-0x03 */
	0xB0, 0xA3, 0x81, 0x43, 0x81, 0x44, 0xB0, 0xA4, /* 0x04-0x07 */
	0xB0, 0xA5, 0xB0, 0xA6, 0xB0, 0xA7, 0x81, 0x45, /* 0x08-0x0B */
	0x81, 0x46, 0x81, 0x47, 0x81, 0x48, 0x81, 