#ifndef H_NET
#define H_NET

#include "devices.h"

#include <netinet/in.h>
#include <netinet/ip.h>
#include <arpa/inet.h>

#define BOOTPROTO_UNKNOWN	0
#define BOOTPROTO_STATIC	1
#define BOOTPROTO_BOOTP		2
#define BOOTPROTO_DHCP		3
#define MAX_DNS_SERVERS         3

#define INTFINFO_HAS_IP		(1 << 0)
#define INTFINFO_HAS_NETMASK	(1 << 1)
#define INTFINFO_HAS_BROADCAST	(1 << 2)
#define INTFINFO_HAS_NETWORK	(1 << 3)
#define INTFINFO_HAS_BOOTPROTO	(1 << 4)
#define INTFINFO_HAS_DEVICE	(1 << 5)
#define INTFINFO_HAS_BOOTSERVER	(1 << 6)
#define INTFINFO_HAS_BOOTFILE	(1 << 7)

#define NETINFO_HAS_GATEWAY	(1 << 0)
#define NETINFO_HAS_HOSTNAME	(1 << 1)
#define NETINFO_HAS_DOMAIN	(1 << 2)
#define NETINFO_HAS_DNS		(1 << 3)

/* all of these in_addr things are in network byte order! */
struct intfInfo {
    char device[10];
    int isPtp, isUp;
    int set, manuallySet;
    struct in_addr ip, netmask, broadcast, network;
    struct in_addr bootServer;
    char * bootFile;
    int bootProto;
};

struct netInfo {
    int set, manuallySet;
    char * hostname, * domain;		/* dynamically allocated */
    struct in_addr gateway;
    struct in_addr dnsServers[MAX_DNS_SERVERS];
    int numDns;
};

int readNetInterfaceConfig(char * prefix, char * device, 
			   struct intfInfo * intf);
int writeNetInterfaceConfig(char * prefix, struct intfInfo * intf);
int writeNetConfig(char * prefix, struct netInfo * netc, 
		   struct intfInfo * gwdev, int verbose);
int writeResolvConf(char * prefix, struct netInfo * net);
int writeHosts(char * prefix, struct netInfo * netc, 
	       struct intfInfo * intf, int force);
int readNetConfig(char * prefix, struct netInfo * netc);
int bringUpNetworking(struct intfInfo * intf, struct netInfo * netc,
		      struct driversLoaded ** dl, int dir);
int writeNetConfig(char * prefix, struct netInfo * netc, 
		   struct intfInfo * gwdev, int verbose);
int netDeviceAvailable(char * device);
int checkNetConfig(struct intfInfo * intf, struct netInfo * netc,
		   struct intfInfo * intfFinal, struct netInfo * netcFinal,
		   struct driversLoaded ** dl, int dir);

#endif
